/// Utilities related to URL validation.
class UrlValidator {
  const UrlValidator._();

  /// Returns true when [candidate] is a valid HTTPS URL with a non-empty host.
  static bool isSecureHttpUrl(String candidate) {
    final trimmed = candidate.trim();
    if (trimmed.isEmpty) return false;

    final uri = Uri.tryParse(trimmed);
    if (uri == null) return false;

    if (!uri.hasScheme || uri.scheme.toLowerCase() != 'https') {
      return false;
    }

    return uri.host.isNotEmpty;
  }
}
