import 'package:natinfo_flutter/shared/data_sources/asset_source_adapter.dart';
import 'package:natinfo_flutter/shared/data_sources/file_source_adapter.dart';
import 'package:natinfo_flutter/shared/data_sources/http_source_adapter.dart';
import 'package:natinfo_flutter/shared/data_sources/source_adapter.dart';
import 'package:natinfo_flutter/shared/data_sources/source_spec.dart';

/// Builds canonical adapter sets for source loading.
class DefaultSourceAdapters {
  const DefaultSourceAdapters._();

  /// Returns adapters keyed by [SourceType], falling back to built-in defaults.
  ///
  /// Adapters in [overrides] replace the default for their [SourceType].
  static Map<SourceType, SourceAdapter> buildMap({
    Iterable<SourceAdapter> overrides = const [],
  }) {
    final adapters = <SourceType, SourceAdapter>{
      for (final adapter in overrides) adapter.type: adapter,
    };
    adapters.putIfAbsent(SourceType.api, HttpSourceAdapter.new);
    adapters.putIfAbsent(SourceType.asset, AssetSourceAdapter.new);
    adapters.putIfAbsent(SourceType.file, FileSourceAdapter.new);
    return adapters;
  }

  /// Returns adapters as a list, preserving the map's insertion order.
  static List<SourceAdapter> buildList({
    Iterable<SourceAdapter> overrides = const [],
  }) {
    return buildMap(overrides: overrides).values.toList(growable: false);
  }
}
