import 'package:flutter/material.dart';
import 'package:natinfo_flutter/features/tools/presentation/identification_chien_page.dart';
import 'package:natinfo_flutter/features/pr_locator/presentation/pages/pr_locator_page.dart';
import 'calculateur_vitesse_page.dart';
import 'calculateur_alcoolemie_page.dart';
import 'package:natinfo_flutter/features/glossary/presentation/glossaire_page.dart';
import 'package:natinfo_flutter/shared/services/matomo_service.dart';

/// Entry page listing utility tools.
class ToolsPage extends StatefulWidget {
  const ToolsPage({super.key});

  @override
  State<ToolsPage> createState() => _ToolsPageState();
}

class _ToolsPageState extends State<ToolsPage> {
  /// Navigates to the provided tool page.
  void _navigate(BuildContext context, Widget page) {
    Navigator.push(context, MaterialPageRoute<void>(builder: (_) => page));
  }

  @override
  void initState() {
    super.initState();
    MatomoService().trackPage(title: 'Outils', path: '/tools/');
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(title: const Text('Outils')),
      body: Padding(
        padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 24),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            _ToolCard(
              title: "Calculateur de taux d'alcoolémie",
              icon: Icons.local_bar,
              iconBg: Colors.orange,
              onTap:
                  () =>
                      _navigate(context, const CalculateurTauxAlcoolemiePage()),
            ),
            const SizedBox(height: 8),
            _ToolCard(
              title: 'Calculateur de vitesse',
              icon: Icons.speed,
              iconBg: Colors.purple,
              onTap: () => _navigate(context, const CalculateurVitessePage()),
            ),
            const SizedBox(height: 8),
            _ToolCard(
              title: 'Glossaire',
              icon: Icons.book,
              iconBg: Colors.blue,
              onTap: () => _navigate(context, const GlossairePage()),
            ),
            const SizedBox(height: 8),
            _ToolCard(
              title: 'Localisation de points de repère routiers',
              icon: Icons.not_listed_location,
              iconBg: Colors.teal,
              onTap: () => _navigate(context, const PrLocatorPage()),
            ),
            const SizedBox(height: 8),
            _ToolCard(
              title: 'Chiens dangereux',
              icon: Icons.pets,
              iconBg: Colors.red,
              onTap: () => _navigate(context, const ChiensDangereuxPage()),
            ),
          ],
        ),
      ),
    );
  }
}

/// Une tuile tappable avec icône dans un bloc coloré, titre et chevron.
class _ToolCard extends StatelessWidget {
  final String title;
  final IconData icon;
  final Color iconBg;
  final VoidCallback onTap;

  const _ToolCard({
    required this.title,
    required this.icon,
    required this.iconBg,
    required this.onTap,
  });

  @override
  Widget build(BuildContext context) {
    return Card(
      elevation: 2,
      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(12)),
      child: InkWell(
        borderRadius: BorderRadius.circular(12),
        onTap: onTap,
        child: Container(
          padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 12),
          child: Row(
            children: [
              // Bloc coloré contenant l'icône
              Container(
                width: 40,
                height: 40,
                decoration: BoxDecoration(
                  color: iconBg,
                  borderRadius: BorderRadius.circular(8),
                ),
                child: Icon(icon, color: Colors.white, size: 24),
              ),
              const SizedBox(width: 16),
              // Titre
              Expanded(
                child: Text(
                  title,
                  style: Theme.of(context).textTheme.titleMedium?.copyWith(
                    fontWeight: FontWeight.w600,
                  ),
                ),
              ),
              // Chevron
              Icon(Icons.chevron_right, color: Theme.of(context).hintColor),
            ],
          ),
        ),
      ),
    );
  }
}
