/// Global application configuration.
class AppConfig {
  /// Whether runtime downloads are permitted. Defaults to true unless
  /// overridden via `--dart-define=ALLOW_DOWNLOADS=false`.
  static const bool allowDownloads = bool.fromEnvironment(
    'ALLOW_DOWNLOADS',
    defaultValue: true,
  );

  /// Preferred source id for the NATINF dataset supplied at build time
  /// (`--dart-define=SOURCE_NATINF=<id>`). Empty means default priority.
  static const String sourceNatinf = String.fromEnvironment(
    'SOURCE_NATINF',
    defaultValue: '',
  );

  /// Optional policy name to drive source selection, provided at build time
  /// (`--dart-define=SOURCE_POLICY=<policy>`). Empty means default policy.
  static const String sourcePolicy = String.fromEnvironment(
    'SOURCE_POLICY',
    defaultValue: '',
  );

  /// Forces offline mode when true, typically toggled from user settings.
  static bool forceOffline = false;

  /// Indicates whether the app is currently in operational mode.
  static bool operationalMode = false;

  /// Returns the preferred NATINF source id if defined, otherwise null.
  static String? get sourceNatinfOverride =>
      sourceNatinf.isEmpty ? null : sourceNatinf;

  /// Returns the configured source policy if defined, otherwise null.
  static String? get sourcePolicyOverride =>
      sourcePolicy.isEmpty ? null : sourcePolicy;
}
