// lib/pages/pr_locator_page.dart

import 'package:flutter/material.dart';
import 'package:flutter_map/flutter_map.dart';
import 'package:natinfo_flutter/features/pr_locator/data/location_service.dart';
import 'package:natinfo_flutter/features/pr_locator/data/pr_repository.dart';
import 'package:provider/provider.dart';
import 'package:natinfo_flutter/features/pr_locator/presentation/viewmodels/pr_locator_viewmodel.dart';
import 'package:natinfo_flutter/features/pr_locator/presentation/widgets/pr_action_bar.dart';
import 'package:natinfo_flutter/features/pr_locator/presentation/widgets/pr_map.dart';
import 'package:natinfo_flutter/shared/services/matomo_service.dart';

class PrLocatorPage extends StatefulWidget {
  const PrLocatorPage({super.key});

  @override
  State<PrLocatorPage> createState() => _PrLocatorPageState();
}

class _PrLocatorPageState extends State<PrLocatorPage> {
  static const _title = 'Loc. points de repère routiers';
  late final MapController _mapController;

  @override
  void initState() {
    super.initState();
    _mapController = MapController();
    MatomoService().trackPage(
      title: 'Loc. points de repère routiers',
      path: '/tools/pr-locator/',
    );
  }

  @override
  Widget build(BuildContext context) {
    return ChangeNotifierProvider(
      create: (_) => PrLocatorViewModel(PrRepository(), LocationService()),
      child: Consumer<PrLocatorViewModel>(
        builder: (_, vm, __) {
          return Scaffold(
            appBar: AppBar(title: const Text(_title)),
            body: _buildBody(vm),
          );
        },
      ),
    );
  }

  Widget _buildBody(PrLocatorViewModel vm) {
    switch (vm.state) {
      case LoadState.missing:
        return _buildDownloadPrompt(vm);
      case LoadState.loading:
        return _buildCenteredBody([
          const CircularProgressIndicator(),
          const SizedBox(height: 16),
          Text(vm.loadingMessage),
        ]);
      case LoadState.error:
        return _buildCenteredBody([
          Text('Erreur : ${vm.errorMessage}'),
          const SizedBox(height: 12),
          _buildDownloadButton(vm),
        ]);
      case LoadState.ready:
        return _buildMapLayout(vm);
    }
  }

  Widget _buildDownloadPrompt(PrLocatorViewModel vm) {
    return _buildCenteredBody([
      _buildDownloadButton(vm),
      const SizedBox(height: 12),
      const Text(
        'Environ 120 Mo de données',
        style: TextStyle(fontSize: 12, color: Colors.grey),
      ),
    ]);
  }

  Widget _buildCenteredBody(List<Widget> children) {
    return Center(
      child: Column(mainAxisSize: MainAxisSize.min, children: children),
    );
  }

  Widget _buildDownloadButton(PrLocatorViewModel vm) {
    return ElevatedButton(
      onPressed: vm.loadData,
      child: const Text('Télécharger les données'),
    );
  }

  Widget _buildMapLayout(PrLocatorViewModel vm) {
    return Stack(
      children: [
        Column(
          children: [
            Padding(
              padding: const EdgeInsets.all(8),
              child: ActionBar(
                onSearchAddress: vm.locateAddress,
                onReset: vm.resetMap,
              ),
            ),
            Expanded(child: PrMap(controller: _mapController)),
          ],
        ),
      ],
    );
  }
}
