import 'package:flutter/material.dart';
import 'package:natinfo_flutter/features/auth/presentation/login_page.dart';

/// CTA inviting users to authenticate before viewing DocPro content.
class DocProLoginPrompt extends StatelessWidget {
  const DocProLoginPrompt({super.key, this.compact = false, this.onLoggedIn});

  /// Uses tighter padding when embedded in list cards.
  final bool compact;

  /// Optional callback invoked when the login flow completes successfully.
  final VoidCallback? onLoggedIn;

  Future<void> _openLogin(BuildContext context) async {
    final loggedIn = await Navigator.of(
      context,
    ).push<bool>(MaterialPageRoute(builder: (_) => const LoginPage()));
    if (loggedIn == true) {
      onLoggedIn?.call();
    }
  }

  @override
  Widget build(BuildContext context) {
    final colorScheme = Theme.of(context).colorScheme;
    final textTheme = Theme.of(context).textTheme;

    return Container(
      decoration: BoxDecoration(
        color: colorScheme.surfaceVariant,
        borderRadius: BorderRadius.circular(compact ? 10 : 12),
      ),
      padding:
          compact
              ? const EdgeInsets.symmetric(horizontal: 12, vertical: 8)
              : const EdgeInsets.all(12),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Icon(Icons.lock_outline, color: colorScheme.primary),
          const SizedBox(width: 12),
          Expanded(
            child: Text(
              'Connectez-vous pour consulter les documents professionnels DocPro.',
              style: textTheme.bodyMedium?.copyWith(
                color: colorScheme.onSurfaceVariant,
              ),
            ),
          ),
          TextButton(
            onPressed: () => _openLogin(context),
            child: const Text('Connexion'),
          ),
        ],
      ),
    );
  }
}
