import 'package:flutter/foundation.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:natinfo_flutter/app/config/app_config.dart';

class OperationalModeProvider extends ChangeNotifier {
  bool _opMode = false;
  bool get opMode => _opMode;

  OperationalModeProvider() {
    _loadMode();
  }

  Future<void> _loadMode() async {
    final prefs = await SharedPreferences.getInstance();
    _opMode = prefs.getBool('operationalMode') ?? false;
    AppConfig.operationalMode = _opMode;
    notifyListeners();
  }

  set opMode(bool value) {
    if (_opMode == value) return;
    _opMode = value;
    AppConfig.operationalMode = value;
    notifyListeners();
    SharedPreferences.getInstance().then(
      (prefs) => prefs.setBool('operationalMode', value),
    );
  }
}
