import 'package:flutter_test/flutter_test.dart';
import 'package:natinfo_flutter/shared/utils/url_validator.dart';

void main() {
  group('UrlValidator.isSecureHttpUrl', () {
    test('returns true for https URL with host', () {
      expect(UrlValidator.isSecureHttpUrl('https://example.com'), isTrue);
    });

    test('returns false for http URL', () {
      expect(UrlValidator.isSecureHttpUrl('http://example.com'), isFalse);
    });

    test('returns false for empty string', () {
      expect(UrlValidator.isSecureHttpUrl(''), isFalse);
    });

    test('returns false for malformed string', () {
      expect(UrlValidator.isSecureHttpUrl('not a url'), isFalse);
    });

    test('returns false when host is missing', () {
      expect(UrlValidator.isSecureHttpUrl('https://'), isFalse);
    });
  });
}
