import 'package:flutter/material.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:http/http.dart' as http;
import 'package:http/testing.dart';
import 'package:natinfo_flutter/app/theme/theme_provider.dart';
import 'package:natinfo_flutter/features/auth/data/auth_repository.dart';
import 'package:natinfo_flutter/features/auth/data/auth_storage.dart';
import 'package:natinfo_flutter/features/auth/presentation/auth_provider.dart';
import 'package:natinfo_flutter/features/natinf/data/api/swagger.swagger.dart';
import 'package:natinfo_flutter/features/natinf/data/natinf_repository.dart';
import 'package:natinfo_flutter/features/natinf/presentation/widgets/natinf_list.dart';
import 'package:provider/provider.dart';

void main() {
  late AuthProvider signedOutAuth;

  setUp(() async {
    signedOutAuth = await _buildAuthProvider();
  });

  testWidgets('records history via repository when tapping an item', (
    tester,
  ) async {
    final repository = _RecordingNatinfRepository();
    var tapHandled = false;
    const natinf = Natinf(
      numeroNatinf: '12345',
      qualificationInfraction: 'Test',
      dacgSource: 0,
    );

    await tester.pumpWidget(
      MultiProvider(
        providers: [
          ChangeNotifierProvider(create: (_) => ThemeProvider()),
          ChangeNotifierProvider<AuthProvider>.value(value: signedOutAuth),
          Provider<NatinfRepository>.value(value: repository),
        ],
        child: MaterialApp(
          home: Scaffold(
            body: NatinfList(
              natinfList: const [natinf],
              onNatinfTap: (_, __) async {
                tapHandled = true;
              },
            ),
          ),
        ),
      ),
    );

    await tester.tap(find.byType(InkWell));
    await tester.pumpAndSettle();

    expect(repository.recordedNumero, '12345');
    expect(tapHandled, isTrue);
  });
}

class _RecordingNatinfRepository extends NatinfRepository {
  String? recordedNumero;

  @override
  Future<void> recordHistoryEntry(String numero) async {
    recordedNumero = numero;
  }
}

Future<AuthProvider> _buildAuthProvider() async {
  final storage = InMemoryAuthStorage();
  final repository = AuthRepository(
    baseUri: Uri.parse('https://natinfo.app/api'),
    storage: storage,
    httpClient: MockClient((request) async => http.Response('{}', 200)),
  );
  final provider = AuthProvider(repository);
  await provider.bootstrap();
  return provider;
}
