/// Représente un dossier de favoris stocké localement.
class FavouriteFolder {
  const FavouriteFolder({
    required this.id,
    required this.name,
    this.parentId,
    required this.createdAt,
  });

  /// Identifiant unique du dossier.
  final int id;

  /// Nom affiché pour le dossier.
  final String name;

  /// Identifiant du dossier parent, ou `null` pour la racine.
  final int? parentId;

  /// Date de création du dossier.
  final DateTime createdAt;

  /// Crée une instance à partir d'une carte [map].
  factory FavouriteFolder.fromMap({
    required int id,
    required Map<String, dynamic> map,
  }) {
    return FavouriteFolder(
      id: id,
      name: map['name'] as String? ?? 'Dossier',
      parentId: map['parent_id'] as int?,
      createdAt: DateTime.fromMillisecondsSinceEpoch(
        map['created_at'] as int? ?? 0,
      ),
    );
  }

  /// Convertit le dossier en carte pour l'enregistrement en base.
  Map<String, dynamic> toMap() => {
    'name': name,
    'parent_id': parentId,
    'created_at': createdAt.millisecondsSinceEpoch,
  };

  /// Renvoie une copie modifiée du dossier.
  FavouriteFolder copyWith({String? name, int? parentId}) {
    return FavouriteFolder(
      id: id,
      name: name ?? this.name,
      parentId: parentId ?? this.parentId,
      createdAt: createdAt,
    );
  }
}
