#!/bin/bash

if [ -z "$BASH_VERSION" ]; then
	echo "Invalid shell, re-running using bash..."
	exec bash "$0" "$@"
	exit $?
fi
SRCLOC="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
source "$SRCLOC/../../../build/utils/functions.sh"

prepareUpstreamFromTarArchive "$SRCLOC" "http://builder.osmand.net/dependencies-mirror/glew-1.12.0.tgz"
        echo af58103f4824b443e7fa4ed3af593b8edac6f3a7be3b30911edbc7344f48e4bf "$SRCLOC/upstream.pack" | sha256sum --check -        || { echo 'Failed checksum' 1>&2; exit; }
patchUpstream "$SRCLOC"
