#ifndef _OSMAND_CORE_COMMON_WORDS_H_
#define _OSMAND_CORE_COMMON_WORDS_H_

//  OsmAnd-java/src/main/java/net/osmand/binary/CommonWords.java
//  git revision 63f67248593c49f0901738085b5f41d22b992f62

#include <OsmAndCore/stdlib_common.h>
#include <functional>

#include <QtGlobal>
#include <QString>
#include <QList>

#include <OsmAndCore.h>
#include <OsmAndCore/Common.h>
#include <OsmAndCore/QuickAccessors.h>

namespace OsmAnd
{
    // for ex: 100 bridge, ленина 30, but not potenitally name of street (31st road)
    const QString NUMBER_WITH_LESS_THAN_2_LETTERS = QStringLiteral("NUMBER_WITH_LESS_THAN_2_LETTERS");
    const static QStringList FREQUENTLY_USED_WORDS
    {
           QStringLiteral("santa"),
           QStringLiteral("west"),
           QStringLiteral("east"),
           QStringLiteral("north"),
           QStringLiteral("northeast"),
           QStringLiteral("northwest"),
           QStringLiteral("southwest"),
           QStringLiteral("san"),
           QStringLiteral("southeast"),
           QStringLiteral("old"),
           QStringLiteral("main"),
           QStringLiteral("ridge"),
           QStringLiteral("josé"),
           QStringLiteral("view"),
           QStringLiteral("range"),
           QStringLiteral("pine"),
           QStringLiteral("church"),
           QStringLiteral("mill"),
           QStringLiteral("green"),
           QStringLiteral("point"),
           QStringLiteral("cove"),
           QStringLiteral("gardens"),
           QStringLiteral("francisco"),
           QStringLiteral("mountain"),
           QStringLiteral("jean"),
           QStringLiteral("joão"),
           QStringLiteral("meadow"),
           QStringLiteral("farm"),
           QStringLiteral("juan"),
           QStringLiteral("bay"),
           QStringLiteral("run"),
           QStringLiteral("national"),
           QStringLiteral("cedar"),
           QStringLiteral("hollow"),
           QStringLiteral("new"),
           QStringLiteral("high"),
           QStringLiteral("maple"),
           QStringLiteral("antonio"),
           QStringLiteral("walk"),
           QStringLiteral("maria"),
           QStringLiteral("spring"),
           QStringLiteral("pedro"),
           QStringLiteral("vista"),
           QStringLiteral("grand"),
           QStringLiteral("giuseppe"),
           QStringLiteral("antônio"),
           QStringLiteral("saint"),
           QStringLiteral("development"),
           QStringLiteral("washington"),
           QStringLiteral("john"),
           QStringLiteral("white"),
           QStringLiteral("silva"),
           QStringLiteral("willow"),
           QStringLiteral("school"),
           QStringLiteral("giovanni"),
           QStringLiteral("canyon"),
           QStringLiteral("general"),
           QStringLiteral("charles"),
           QStringLiteral("king"),
           QStringLiteral("moulin"),
           QStringLiteral("monte"),
           QStringLiteral("wood"),
           QStringLiteral("glen"),
           QStringLiteral("rock"),
           QStringLiteral("elm"),
           QStringLiteral("center"),
           QStringLiteral("mount"),
           QStringLiteral("tree"),
           QStringLiteral("red"),
           QStringLiteral("central"),
           QStringLiteral("norte"),
           QStringLiteral("delle"),
           QStringLiteral("église"),
           QStringLiteral("carlos"),
           QStringLiteral("springs"),
           QStringLiteral("doutor"),
           QStringLiteral("grande"),
           QStringLiteral("martin"),
           QStringLiteral("station"),
           QStringLiteral("statale"),
           QStringLiteral("alte"),
           QStringLiteral("paul"),
           QStringLiteral("hills"),
           QStringLiteral("beach"),
           QStringLiteral("brook"),
           QStringLiteral("walnut"),
           QStringLiteral("gate"),
           QStringLiteral("oaks"),
           QStringLiteral("cross"),
           QStringLiteral("pierre"),
           QStringLiteral("rural"),
           QStringLiteral("service"),
           QStringLiteral("manuel"),
           QStringLiteral("country"),
           QStringLiteral("blue"),
           QStringLiteral("miguel"),
           QStringLiteral("branch"),
           QStringLiteral("cherry"),
           QStringLiteral("don"),
           QStringLiteral("lincoln"),
           QStringLiteral("orchard"),
           QStringLiteral("little"),
           QStringLiteral("memorial"),
           QStringLiteral("clos"),
           QStringLiteral("club"),
           QStringLiteral("bois"),
           QStringLiteral("james"),
           QStringLiteral("ranch"),
           QStringLiteral("louis"),
           QStringLiteral("sunset"),
           QStringLiteral("pond"),
           QStringLiteral("george"),
           QStringLiteral("général"),
           QStringLiteral("costa"),
           QStringLiteral("santos"),
           QStringLiteral("victoria"),
           QStringLiteral("albert"),
           QStringLiteral("manor"),
           QStringLiteral("hall"),
           QStringLiteral("cemetery"),
           QStringLiteral("rose"),
           QStringLiteral("luis"),
           QStringLiteral("fox"),
           QStringLiteral("doctor"),
           QStringLiteral("long"),
           QStringLiteral("alameda"),
           QStringLiteral("smith"),
           QStringLiteral("padre"),
           QStringLiteral("woods"),
           QStringLiteral("villa"),
           QStringLiteral("lotissement"),
           QStringLiteral("indian"),
           QStringLiteral("pleasant"),
           QStringLiteral("jackson"),
           QStringLiteral("water"),
           QStringLiteral("wilson"),
           QStringLiteral("hickory"),
           QStringLiteral("deer"),
           QStringLiteral("birch"),
           QStringLiteral("chestnut"),
           QStringLiteral("eagle"),
           QStringLiteral("laurel"),
           QStringLiteral("heights"),
           QStringLiteral("jana"),
           QStringLiteral("shore"),
           QStringLiteral("highland"),
           QStringLiteral("roma"),
           QStringLiteral("oliveira"),
           QStringLiteral("garden"),
           QStringLiteral("château"),
           QStringLiteral("provincial"),
           QStringLiteral("thomas"),
           QStringLiteral("camp"),
           QStringLiteral("largo"),
           QStringLiteral("access"),
           QStringLiteral("georges"),
           QStringLiteral("college"),
           QStringLiteral("chapel"),
           QStringLiteral("house"),
           QStringLiteral("rosa"),
           QStringLiteral("johnson"),
           QStringLiteral("upper"),
           QStringLiteral("union"),
           QStringLiteral("crest"),
           QStringLiteral("gare"),
           QStringLiteral("market"),
           QStringLiteral("ленина"),
           QStringLiteral("jefferson"),
           QStringLiteral("stone"),
           QStringLiteral("franklin"),
           QStringLiteral("résidence"),
           QStringLiteral("francesco"),
           QStringLiteral("railroad"),
           QStringLiteral("black"),
           QStringLiteral("fontaine"),
           QStringLiteral("silver"),
           QStringLiteral("lower"),
           QStringLiteral("mile"),
           QStringLiteral("henri"),
           QStringLiteral("big"),
           QStringLiteral("brown"),
           QStringLiteral("kennedy"),
           QStringLiteral("pereira"),
           QStringLiteral("airport"),
           QStringLiteral("spruce"),
           QStringLiteral("woodland"),
           QStringLiteral("robert"),
           QStringLiteral("victor"),
           QStringLiteral("manoel"),
           QStringLiteral("meadows"),
           QStringLiteral("vicente"),
           QStringLiteral("ash"),
           QStringLiteral("rise"),
           QStringLiteral("pike"),
           QStringLiteral("luigi"),
           QStringLiteral("sant"),
           QStringLiteral("santo"),
           QStringLiteral("western"),
           QStringLiteral("poplar"),
           QStringLiteral("советская"),
           QStringLiteral("croix"),
           QStringLiteral("real"),
           QStringLiteral("vittorio"),
           QStringLiteral("mews"),
           QStringLiteral("taylor"),
           QStringLiteral("davis"),
           QStringLiteral("jose"),
           QStringLiteral("frontage"),
           QStringLiteral("gaulle"),
           QStringLiteral("bank"),
           QStringLiteral("ferry"),
           QStringLiteral("nord"),
           QStringLiteral("holly"),
           QStringLiteral("castle"),
           QStringLiteral("sierra"),
           QStringLiteral("acceso"),
           QStringLiteral("royal"),
           QStringLiteral("praça"),
           QStringLiteral("williams"),
           QStringLiteral("souza"),
           QStringLiteral("madison"),
           QStringLiteral("joseph"),
           QStringLiteral("riverside"),
           QStringLiteral("adams"),
           QStringLiteral("nacional"),
           QStringLiteral("oude"),
           QStringLiteral("tee"),
           QStringLiteral("port"),
           QStringLiteral("private"),
           QStringLiteral("mayo"),
           QStringLiteral("carlo"),
           QStringLiteral("york"),
           QStringLiteral("ferreira"),
           QStringLiteral("giacomo"),
           QStringLiteral("parade"),
           QStringLiteral("field"),
           QStringLiteral("professor"),
           QStringLiteral("jones"),
           QStringLiteral("maría"),
           QStringLiteral("lakeview"),
           QStringLiteral("great"),
           QStringLiteral("alves"),
           QStringLiteral("miller"),
           QStringLiteral("william"),
           QStringLiteral("henry"),
           QStringLiteral("coronel"),
           QStringLiteral("industrial"),
           QStringLiteral("maréchal"),
           QStringLiteral("acres"),
           QStringLiteral("joaquim"),
           QStringLiteral("landing"),
           QStringLiteral("summit"),
           QStringLiteral("burgemeester"),
           QStringLiteral("magnolia"),
           QStringLiteral("trace"),
           QStringLiteral("presidente"),
           QStringLiteral("falls"),
           QStringLiteral("jules"),
           QStringLiteral("docteur"),
           QStringLiteral("pacific"),
           QStringLiteral("auzoa"),
           QStringLiteral("prairie"),
           QStringLiteral("luiz"),
           QStringLiteral("diagonal"),
           QStringLiteral("cypress"),
           QStringLiteral("mar"),
           QStringLiteral("harbor"),
           QStringLiteral("shady"),
           QStringLiteral("clark"),
           QStringLiteral("fort"),
           QStringLiteral("bluff"),
           QStringLiteral("grant"),
           QStringLiteral("fork"),
           QStringLiteral("fire"),
           QStringLiteral("petit"),
           QStringLiteral("sycamore"),
           QStringLiteral("nelson"),
           QStringLiteral("queen"),
           QStringLiteral("city"),
           QStringLiteral("vico"),
           QStringLiteral("józefa"),
           QStringLiteral("pietro"),
           QStringLiteral("bear"),
           QStringLiteral("lima"),
           QStringLiteral("центральная"),
           QStringLiteral("pablo"),
           QStringLiteral("golden"),
           QStringLiteral("mary"),
           QStringLiteral("hillside"),
           QStringLiteral("haven"),
           QStringLiteral("alberto"),
           QStringLiteral("lorong"),
           QStringLiteral("elizabeth"),
           QStringLiteral("kings"),
           QStringLiteral("dogwood"),
           QStringLiteral("scott"),
           QStringLiteral("beech"),
           QStringLiteral("lange"),
           QStringLiteral("andré"),
           QStringLiteral("verde"),
           QStringLiteral("front"),
           QStringLiteral("obere"),
           QStringLiteral("hidden"),
           QStringLiteral("centre"),
           QStringLiteral("hamilton"),
           QStringLiteral("arthur"),
           QStringLiteral("parc"),
           QStringLiteral("quail"),
           QStringLiteral("julio"),
           QStringLiteral("jan"),
           QStringLiteral("bell"),
           QStringLiteral("sandy"),
           QStringLiteral("back"),
           QStringLiteral("sud"),
           QStringLiteral("paulo"),
           QStringLiteral("lago"),
           QStringLiteral("locust"),
           QStringLiteral("martín"),
           QStringLiteral("gabriel"),
           QStringLiteral("chase"),
           QStringLiteral("palm"),
           QStringLiteral("liberty"),
           QStringLiteral("mairie"),
           QStringLiteral("jorge"),
           QStringLiteral("castro"),
           QStringLiteral("fernando"),
           QStringLiteral("alter"),
           QStringLiteral("salvador"),
           QStringLiteral("hillcrest"),
           QStringLiteral("cité"),
           QStringLiteral("rodrigues"),
           QStringLiteral("prospect"),
           QStringLiteral("golf"),
           QStringLiteral("dom"),
           QStringLiteral("jacques"),
           QStringLiteral("berliner"),
           QStringLiteral("santiago"),
           QStringLiteral("transversal"),
           QStringLiteral("садовая"),
           QStringLiteral("guglielmo"),
           QStringLiteral("pointe"),
           QStringLiteral("circuit"),
           QStringLiteral("rang"),
           QStringLiteral("françois"),
           QStringLiteral("lewis"),
           QStringLiteral("railway"),
           QStringLiteral("allen"),
           QStringLiteral("grange"),
           QStringLiteral("ronda"),
           QStringLiteral("link"),
           QStringLiteral("harrison"),
           QStringLiteral("tower"),
           QStringLiteral("garibaldi"),
           QStringLiteral("novembre"),
           QStringLiteral("heritage"),
           QStringLiteral("anderson"),
           QStringLiteral("evergreen"),
           QStringLiteral("ribeiro"),
           QStringLiteral("ford"),
           QStringLiteral("linden"),
           QStringLiteral("short"),
           QStringLiteral("walker"),
           QStringLiteral("marie"),
           QStringLiteral("twin"),
           QStringLiteral("untere"),
           QStringLiteral("university"),
           QStringLiteral("douglas"),
           QStringLiteral("marconi"),
           QStringLiteral("martins"),
           QStringLiteral("windsor"),
           QStringLiteral("мира"),
           QStringLiteral("david"),
           QStringLiteral("middle"),
           QStringLiteral("fairview"),
           QStringLiteral("stanisława"),
           QStringLiteral("timber"),
           QStringLiteral("thompson"),
           QStringLiteral("generała"),
           QStringLiteral("virginia"),
           QStringLiteral("broad"),
           QStringLiteral("pasteur"),
           QStringLiteral("promenade"),
           QStringLiteral("hugo"),
           QStringLiteral("montée"),
           QStringLiteral("gomes"),
           QStringLiteral("warren"),
           QStringLiteral("luther"),
           QStringLiteral("columbia"),
           QStringLiteral("lakes"),
           QStringLiteral("campo"),
           QStringLiteral("puerto"),
           QStringLiteral("république"),
           QStringLiteral("enrico"),
           QStringLiteral("champ"),
           QStringLiteral("lawrence"),
           QStringLiteral("monroe"),
           QStringLiteral("alessandro"),
           QStringLiteral("władysława"),
           QStringLiteral("pod"),
           QStringLiteral("campbell"),
           QStringLiteral("pinto"),
           QStringLiteral("школьная"),
           QStringLiteral("estates"),
           QStringLiteral("howard"),
           QStringLiteral("orange"),
           QStringLiteral("croft"),
           QStringLiteral("star"),
           QStringLiteral("est"),
           QStringLiteral("triq"),
           QStringLiteral("beaver"),
           QStringLiteral("principale"),
           QStringLiteral("paz"),
           QStringLiteral("sol"),
           QStringLiteral("vieux"),
           QStringLiteral("southern"),
           QStringLiteral("greenway"),
           QStringLiteral("rocky"),
           QStringLiteral("roosevelt"),
           QStringLiteral("mai"),
           QStringLiteral("aspen"),
           QStringLiteral("russell"),
           QStringLiteral("pines"),
           QStringLiteral("concession"),
           QStringLiteral("wellington"),
           QStringLiteral("barrio"),
           QStringLiteral("neue"),
           QStringLiteral("post"),
           QStringLiteral("vale"),
           QStringLiteral("молодёжная"),
           QStringLiteral("октябрьская"),
           QStringLiteral("london"),
           QStringLiteral("four"),
           QStringLiteral("machado"),
           QStringLiteral("parque"),
           QStringLiteral("augusto"),
           QStringLiteral("carvalho"),
           QStringLiteral("markt"),
           QStringLiteral("division"),
           QStringLiteral("marina"),
           QStringLiteral("almeida"),
           QStringLiteral("horse"),
           QStringLiteral("berg"),
           QStringLiteral("mitchell"),
           QStringLiteral("pearl"),
           QStringLiteral("governador"),
           QStringLiteral("side"),
           QStringLiteral("robin"),
           QStringLiteral("iii"),
           QStringLiteral("vignes"),
           QStringLiteral("dale"),
           QStringLiteral("oriente"),
           QStringLiteral("coast"),
           QStringLiteral("baker"),
           QStringLiteral("ann"),
           QStringLiteral("europa"),
           QStringLiteral("maurice"),
           QStringLiteral("plac"),
           QStringLiteral("prince"),
           QStringLiteral("jardins"),
           QStringLiteral("ocean"),
           QStringLiteral("harris"),
           QStringLiteral("oxford"),
           QStringLiteral("kirchweg"),
           QStringLiteral("sunrise"),
           QStringLiteral("moore"),
           QStringLiteral("apple"),
           QStringLiteral("birkenweg"),
           QStringLiteral("flores"),
           QStringLiteral("marcel"),
           QStringLiteral("morgan"),
           QStringLiteral("ana"),
           QStringLiteral("cesare"),
           QStringLiteral("comunale"),
           QStringLiteral("mário"),
           QStringLiteral("olive"),
           QStringLiteral("rené"),
           QStringLiteral("vine"),
           QStringLiteral("rafael"),
           QStringLiteral("champs"),
           QStringLiteral("nova"),
           QStringLiteral("brasil"),
           QStringLiteral("privada"),
           QStringLiteral("barbosa"),
           QStringLiteral("mare"),
           QStringLiteral("dias"),
           QStringLiteral("leclerc"),
           QStringLiteral("daniel"),
           QStringLiteral("dante"),
           QStringLiteral("parker"),
           QStringLiteral("francis"),
           QStringLiteral("prés"),
           QStringLiteral("knoll"),
           QStringLiteral("torre"),
           QStringLiteral("contrada"),
           QStringLiteral("località"),
           QStringLiteral("mesa"),
           QStringLiteral("stade"),
           QStringLiteral("hampton"),
           QStringLiteral("alfredo"),
           QStringLiteral("peak"),
           QStringLiteral("ross"),
           QStringLiteral("лесная"),
           QStringLiteral("ivy"),
           QStringLiteral("filho"),
           QStringLiteral("mills"),
           QStringLiteral("major"),
           QStringLiteral("fratelli"),
           QStringLiteral("garcía"),
           QStringLiteral("wild"),
           QStringLiteral("gordon"),
           QStringLiteral("diego"),
           QStringLiteral("cerro"),
           QStringLiteral("cambridge"),
           QStringLiteral("alta"),
           QStringLiteral("home"),
           QStringLiteral("ramón"),
           QStringLiteral("raymond"),
           QStringLiteral("juniper"),
           QStringLiteral("redwood"),
           QStringLiteral("crystal"),
           QStringLiteral("mulberry"),
           QStringLiteral("новая"),
           QStringLiteral("poniente"),
           QStringLiteral("alten"),
           QStringLiteral("гагарина"),
           QStringLiteral("bellevue"),
           QStringLiteral("veterans"),
           QStringLiteral("hope"),
           QStringLiteral("jaurès"),
           QStringLiteral("summer"),
           QStringLiteral("bahnhof"),
           QStringLiteral("r-c"),
           QStringLiteral("oakwood"),
           QStringLiteral("richmond"),
           QStringLiteral("paris"),
           QStringLiteral("lorenzo"),
           QStringLiteral("hof"),
           QStringLiteral("mariano"),
           QStringLiteral("navajo"),
           QStringLiteral("комсомольская"),
           QStringLiteral("kleine"),
           QStringLiteral("lodge"),
           QStringLiteral("torres"),
           QStringLiteral("leśna"),
           QStringLiteral("cardinal"),
           QStringLiteral("marsh"),
           QStringLiteral("fern"),
           QStringLiteral("campos"),
           QStringLiteral("nationale"),
           QStringLiteral("berry"),
           QStringLiteral("commerce"),
           QStringLiteral("ignacio"),
           QStringLiteral("acesso"),
           QStringLiteral("madrid"),
           QStringLiteral("mission"),
           QStringLiteral("gang"),
           QStringLiteral("oeste"),
           QStringLiteral("cherokee"),
           QStringLiteral("paolo"),
           QStringLiteral("stewart"),
           QStringLiteral("cliff"),
           QStringLiteral("eduardo"),
           QStringLiteral("marshall"),
           QStringLiteral("dam"),
           QStringLiteral("pioneer"),
           QStringLiteral("alfred"),
           QStringLiteral("greenwood"),
           QStringLiteral("robinson"),
           QStringLiteral("acacias"),
           QStringLiteral("lópez"),
           QStringLiteral("tadeusza"),
           QStringLiteral("leonardo"),
           QStringLiteral("hilltop"),
           QStringLiteral("diamond"),
           QStringLiteral("quarry"),
           QStringLiteral("het"),
           QStringLiteral("temple"),
           QStringLiteral("scenic"),
           QStringLiteral("alexander"),
           QStringLiteral("победы"),
           QStringLiteral("osiedle"),
           QStringLiteral("écoles"),
           QStringLiteral("cleveland"),
           QStringLiteral("lynn"),
           QStringLiteral("top"),
           QStringLiteral("mont"),
           QStringLiteral("polna"),
           QStringLiteral("leaf"),
           QStringLiteral("vieira"),
           QStringLiteral("cottonwood"),
           QStringLiteral("perry"),
           QStringLiteral("morris"),
           QStringLiteral("oberer"),
           QStringLiteral("domingo"),
           QStringLiteral("hawthorne"),
           QStringLiteral("autumn"),
           QStringLiteral("alto"),
           QStringLiteral("chapelle"),
           QStringLiteral("kelly"),
           QStringLiteral("sherwood"),
           QStringLiteral("garcia"),
           QStringLiteral("bruce"),
           QStringLiteral("cour"),
           QStringLiteral("petite"),
           QStringLiteral("gap"),
           QStringLiteral("sea"),
           QStringLiteral("émile"),
           QStringLiteral("murray"),
           QStringLiteral("tangenziale"),
           QStringLiteral("mühlenweg"),
           QStringLiteral("gonçalves"),
           QStringLiteral("eastern"),
           QStringLiteral("belle"),
           QStringLiteral("northern"),
           QStringLiteral("xxiii"),
           QStringLiteral("vicinale"),
           QStringLiteral("hemlock"),
           QStringLiteral("hunter"),
           QStringLiteral("лет"),
           QStringLiteral("roberts"),
           QStringLiteral("heather"),
           QStringLiteral("bernardo"),
           QStringLiteral("verte"),
           QStringLiteral("arbor"),
           QStringLiteral("puits"),
           QStringLiteral("mine"),
           QStringLiteral("stefana"),
           QStringLiteral("güterweg"),
           QStringLiteral("newton"),
           QStringLiteral("кирова"),
           QStringLiteral("riverview"),
           QStringLiteral("clay"),
           QStringLiteral("sint"),
           QStringLiteral("aldo"),
           QStringLiteral("tilleuls"),
           QStringLiteral("claude"),
           QStringLiteral("kossuth"),
           QStringLiteral("edward"),
           QStringLiteral("communale"),
           QStringLiteral("fuente"),
           QStringLiteral("cooper"),
           QStringLiteral("trails"),
           QStringLiteral("nieuwe"),
           QStringLiteral("sebastião"),
           QStringLiteral("roberto"),
           QStringLiteral("overlook"),
           QStringLiteral("первомайская"),
           QStringLiteral("roger"),
           QStringLiteral("turner"),
           QStringLiteral("france"),
           QStringLiteral("mario"),
           QStringLiteral("iv"),
           QStringLiteral("sugar"),
           QStringLiteral("hudson"),
           QStringLiteral("lopes"),
           QStringLiteral("evans"),
           QStringLiteral("cottage"),
           QStringLiteral("raya"),
           QStringLiteral("branco"),
           QStringLiteral("vernon"),
           QStringLiteral("traverse"),
           QStringLiteral("emerald"),
           QStringLiteral("dove"),
           QStringLiteral("felipe"),
           QStringLiteral("wildwood"),
           QStringLiteral("moro"),
           QStringLiteral("marechal"),
           QStringLiteral("köz"),
           QStringLiteral("marion"),
           QStringLiteral("marco"),
           QStringLiteral("léon"),
           QStringLiteral("mt"),
           QStringLiteral("veneto"),
           QStringLiteral("mazzini"),
           QStringLiteral("plum"),
           QStringLiteral("boundary"),
           QStringLiteral("barros"),
           QStringLiteral("tour"),
           QStringLiteral("andrews"),
           QStringLiteral("wiesenweg"),
           QStringLiteral("maggio"),
           QStringLiteral("ricardo"),
           QStringLiteral("pennsylvania"),
           QStringLiteral("myrtle"),
           QStringLiteral("matteotti"),
           QStringLiteral("hinter"),
           QStringLiteral("линия"),
           QStringLiteral("ouest"),
           QStringLiteral("maja"),
           QStringLiteral("kent"),
           QStringLiteral("stanley"),
           QStringLiteral("jacob"),
           QStringLiteral("principal"),
           QStringLiteral("rogers"),
           QStringLiteral("homestead"),
           QStringLiteral("collins"),
           QStringLiteral("richard"),
           QStringLiteral("crown"),
           QStringLiteral("moss"),
           QStringLiteral("moreno"),
           QStringLiteral("garfield"),
           QStringLiteral("belmont"),
           QStringLiteral("rolling"),
           QStringLiteral("sportplatz"),
           QStringLiteral("côte"),
           QStringLiteral("hospital"),
           QStringLiteral("sun"),
           QStringLiteral("горького"),
           QStringLiteral("flat"),
           QStringLiteral("colonial"),
           QStringLiteral("ramos"),
           QStringLiteral("lilas"),
           QStringLiteral("mason"),
           QStringLiteral("forge"),
           QStringLiteral("shadow"),
           QStringLiteral("gold"),
           QStringLiteral("rocha"),
           QStringLiteral("linda"),
           QStringLiteral("young"),
           QStringLiteral("estate"),
           QStringLiteral("martiri"),
           QStringLiteral("verdi"),
           QStringLiteral("augusta")

    };
    
    inline QHash<QString, int>& COMMON_WORDS()
    {
    
        static QStringList words =
        {
        QStringLiteral("la"),
        QStringLiteral("via"),
        QStringLiteral("rua"),
        QStringLiteral("de"),
        QStringLiteral("du"),
        QStringLiteral("des"),
        QStringLiteral("del"),
        QStringLiteral("am"),
        QStringLiteral("da"),
        QStringLiteral("a"),
        QStringLiteral("der"),
        QStringLiteral("do"),
        QStringLiteral("los"),
        QStringLiteral("di"),
        QStringLiteral("im"),
        QStringLiteral("el"),
        QStringLiteral("e"),
        QStringLiteral("an"),
        QStringLiteral("g."),
        QStringLiteral("rd"),
        QStringLiteral("dos"),
        QStringLiteral("dei"),
        QStringLiteral("b"),
        QStringLiteral("st"),
        QStringLiteral("the"),
        QStringLiteral("las"),
        QStringLiteral("f"),
        QStringLiteral("u"),
        QStringLiteral("jl."),
        QStringLiteral("j"),
        QStringLiteral("sk"),
        QStringLiteral("w"),
        QStringLiteral("a."),
        QStringLiteral("of"),
        QStringLiteral("k"),
        QStringLiteral("r"),
        QStringLiteral("h"),
        QStringLiteral("mc"),
        QStringLiteral("sw"),
        QStringLiteral("g"),
        QStringLiteral("v"),
        QStringLiteral("m"),
        QStringLiteral("c."),
        QStringLiteral("r."),
        QStringLiteral("ct"),
        QStringLiteral("e."),
        QStringLiteral("dr."),
        QStringLiteral("j."),
        QStringLiteral("in"),
        QStringLiteral("al"),
        QStringLiteral("út"),
        QStringLiteral("per"),
        QStringLiteral("ne"),
        QStringLiteral("p"),
        QStringLiteral("et"),
        QStringLiteral("s."),
        QStringLiteral("f."),
        QStringLiteral("t"),
        QStringLiteral("fe"),
        QStringLiteral("à"),
        QStringLiteral("i"),
        QStringLiteral("c"),
        QStringLiteral("le"),
        QStringLiteral("s"),
        QStringLiteral("av."),
        QStringLiteral("den"),
        QStringLiteral("dr"),
        QStringLiteral("y"),
        QStringLiteral("un"),
        
        // Push higher than roads to avoid problem with "Drive A 21"
        NUMBER_WITH_LESS_THAN_2_LETTERS,
        
        QStringLiteral("van"),
        QStringLiteral("road"),
        QStringLiteral("street"),
        QStringLiteral("sector"),
        QStringLiteral("drive"),
        QStringLiteral("avenue"),
        QStringLiteral("rue"),
        QStringLiteral("lane"),
        QStringLiteral("улица"),
        QStringLiteral("спуск"),
        QStringLiteral("straße"),
        QStringLiteral("chemin"),
        QStringLiteral("way"),
        
        QStringLiteral("court"),
        QStringLiteral("calle"),
        
        QStringLiteral("place"),
        
        QStringLiteral("avenida"),
        QStringLiteral("boulevard"),
        QStringLiteral("county"),
        QStringLiteral("route"),
        QStringLiteral("trail"),
        QStringLiteral("circle"),
        QStringLiteral("close"),
        QStringLiteral("highway"),
        
        QStringLiteral("strada"),
        QStringLiteral("impasse"),
        QStringLiteral("utca"),
        QStringLiteral("creek"),
        QStringLiteral("carrer"),
        QStringLiteral("вулиця"),
        QStringLiteral("allée"),
        QStringLiteral("weg"),
        QStringLiteral("площадь"),
        QStringLiteral("тупик"),
        
        QStringLiteral("terrace"),
        QStringLiteral("jalan"),
        
        QStringLiteral("parkway"),
        QStringLiteral("переулок"),
        
        QStringLiteral("carretera"),
        QStringLiteral("valley"),
        
        QStringLiteral("camino"),
        QStringLiteral("viale"),
        QStringLiteral("loop"),
        
        QStringLiteral("bridge"),
        QStringLiteral("embankment"),
        QStringLiteral("township"),
        QStringLiteral("town"),
        QStringLiteral("village"),
        QStringLiteral("piazza"),
        QStringLiteral("della"),
        
        QStringLiteral("plaza"),
        QStringLiteral("pasaje"),
        QStringLiteral("expressway"),
        QStringLiteral("ruta"),
        QStringLiteral("square"),
        QStringLiteral("freeway"),
        QStringLiteral("line"),
        
        QStringLiteral("track"),
        
        QStringLiteral("zum"),
        QStringLiteral("rodovia"),
        QStringLiteral("sokak"),
        QStringLiteral("sur"),
        QStringLiteral("path"),
        QStringLiteral("das"),
        
        QStringLiteral("yolu"),
        
        QStringLiteral("проспект"),
        
        QStringLiteral("auf"),
        QStringLiteral("alley"),
        QStringLiteral("são"),
        QStringLiteral("les"),
        QStringLiteral("delle"),
        QStringLiteral("paseo"),
        QStringLiteral("alte"),
        QStringLiteral("autostrada"),
        QStringLiteral("iela"),
        QStringLiteral("autovía"),
        QStringLiteral("d"),
        QStringLiteral("ulica"),
        
        QStringLiteral("na"),
        QStringLiteral("проезд"),
        QStringLiteral("n"),
        QStringLiteral("ул."),
        QStringLiteral("voie"),
        QStringLiteral("ring"),
        QStringLiteral("ruelle"),
        QStringLiteral("vicolo"),
        QStringLiteral("avinguda"),
        QStringLiteral("шоссе"),
        QStringLiteral("zur"),
        QStringLiteral("corso"),
        QStringLiteral("autopista"),
        QStringLiteral("провулок"),
        QStringLiteral("broadway"),
        QStringLiteral("to"),
        QStringLiteral("passage"),
        QStringLiteral("sentier"),
        QStringLiteral("aleja"),
        QStringLiteral("dem"),
        QStringLiteral("valle"),
        QStringLiteral("cruz"),
        
        QStringLiteral("bypass"),
        QStringLiteral("rúa"),
        QStringLiteral("crest"),
        QStringLiteral("ave"),
        
        QStringLiteral("expressway)"),
        
        QStringLiteral("autoroute"),
        QStringLiteral("crossing"),
        QStringLiteral("camí"),
        QStringLiteral("bend"),
        
        QStringLiteral("end"),
        QStringLiteral("caddesi"),
        QStringLiteral("bis"),
        
        QStringLiteral("ქუჩა"),
        QStringLiteral("kalea"),
        QStringLiteral("pass"),
        QStringLiteral("ponte"),
        QStringLiteral("cruce"),
        QStringLiteral("se"),
        QStringLiteral("au"),
        
        QStringLiteral("allee"),
        QStringLiteral("autobahn"),
        QStringLiteral("väg"),
        QStringLiteral("sentiero"),
        QStringLiteral("plaça"),
        QStringLiteral("o"),
        QStringLiteral("vej"),
        QStringLiteral("aux"),
        QStringLiteral("spur"),
        QStringLiteral("ringstraße"),
        QStringLiteral("prospect"),
        QStringLiteral("m."),
        QStringLiteral("chaussee"),
        QStringLiteral("row"),
        QStringLiteral("link"),
        
        QStringLiteral("travesía"),
        QStringLiteral("degli"),
        QStringLiteral("piazzale"),
        QStringLiteral("vei"),
        QStringLiteral("waldstraße"),
        QStringLiteral("promenade"),
        QStringLiteral("puente"),
        QStringLiteral("rond-point"),
        QStringLiteral("vía"),
        QStringLiteral("pod"),
        QStringLiteral("triq"),
        QStringLiteral("hwy"),
        QStringLiteral("οδός"),
        QStringLiteral("dels"),
        QStringLiteral("and"),
        
        QStringLiteral("pré"),
        QStringLiteral("plac"),
        QStringLiteral("fairway"),
        
        //      QStringLiteral("farm-to-market"),
        
        QStringLiteral("набережная"),
        
        QStringLiteral("chaussée"),
        
        QStringLiteral("náměstí"),
        QStringLiteral("tér"),
        QStringLiteral("roundabout"),
        QStringLiteral("lakeshore"),
        QStringLiteral("lakeside"),
        QStringLiteral("alle"),
        QStringLiteral("gasse"),
        QStringLiteral("str."),
        //      QStringLiteral("p."),
        QStringLiteral("ville"),
        QStringLiteral("beco"),
        QStringLiteral("platz"),
        
        //      QStringLiteral("porto"),
        
        QStringLiteral("sideroad"),
        QStringLiteral("pista"),
        
        QStringLiteral("аллея"),
        QStringLiteral("бульвар"),
        QStringLiteral("город"),
        QStringLiteral("городок"),
        QStringLiteral("деревня"),
        QStringLiteral("дер."),
        QStringLiteral("пос."),
        QStringLiteral("дорога"),
        QStringLiteral("дорожка"),
        QStringLiteral("кольцо"),
        QStringLiteral("мост"),
        QStringLiteral("остров"),
        QStringLiteral("островок"),
        QStringLiteral("поселок"),
        QStringLiteral("посёлок"),
        QStringLiteral("путепровод"),
        QStringLiteral("слобода"),
        QStringLiteral("станция"),
        QStringLiteral("тоннель"),
        QStringLiteral("тракт"),
        QStringLiteral("island"),
        QStringLiteral("islet"),
        QStringLiteral("tunnel"),
        QStringLiteral("stadt"),
        QStringLiteral("brücke"),
        QStringLiteral("damm"),
        QStringLiteral("insel"),
        QStringLiteral("dorf"),
        QStringLiteral("bereich"),
        QStringLiteral("überführung"),
        QStringLiteral("bulevar"),
        QStringLiteral("ciudad"),
        QStringLiteral("pueblo"),
        QStringLiteral("anillo"),
        QStringLiteral("muelle"),
        QStringLiteral("isla"),
        QStringLiteral("islote"),
        QStringLiteral("carril"),
        QStringLiteral("viaje"),
        QStringLiteral("città"),
        QStringLiteral("paese"),
        QStringLiteral("villaggio"),
        QStringLiteral("banchina"),
        QStringLiteral("isola"),
        QStringLiteral("isolotto"),
        QStringLiteral("corsia"),
        QStringLiteral("viaggio"),
        QStringLiteral("canale"),
        QStringLiteral("pont"),
        QStringLiteral("quai"),
        QStringLiteral("île"),
        QStringLiteral("îlot"),
        QStringLiteral("voyage"),
        QStringLiteral("descente"),
        QStringLiteral("straat"),
        QStringLiteral("stad"),
        QStringLiteral("dorp"),
        QStringLiteral("brug"),
        QStringLiteral("kade"),
        QStringLiteral("eiland"),
        QStringLiteral("eilandje"),
        QStringLiteral("laan"),
        QStringLiteral("plein"),
        QStringLiteral("reizen"),
        QStringLiteral("afkomst"),
        QStringLiteral("kanaal"),
        QStringLiteral("doodlopende"),
        QStringLiteral("stradă"),
        QStringLiteral("rutier"),
        QStringLiteral("alee"),
        QStringLiteral("municipiu"),
        QStringLiteral("oras"),
        QStringLiteral("drumuri"),
        QStringLiteral("poduri"),
        QStringLiteral("cheu"),
        QStringLiteral("insula"),
        QStringLiteral("ostrov"),
        QStringLiteral("sat"),
        QStringLiteral("călătorie"),
        QStringLiteral("coborâre"),
        QStringLiteral("statie"),
        QStringLiteral("tunel"),
        QStringLiteral("fundătură"),
        QStringLiteral("ulice"),
        QStringLiteral("silnice"),
        QStringLiteral("bulvár"),
        QStringLiteral("město"),
        QStringLiteral("obec"),
        QStringLiteral("most"),
        QStringLiteral("nábřeží"),
        QStringLiteral("ostrova"),
        QStringLiteral("ostrůvek"),
        QStringLiteral("lane"),
        QStringLiteral("vesnice"),
        QStringLiteral("jezdit"),
        QStringLiteral("sestup"),
        QStringLiteral("nádraží"),
        QStringLiteral("kanál"),
        QStringLiteral("ulička"),
        QStringLiteral("gata"),
        QStringLiteral("by"),
        QStringLiteral("bro"),
        QStringLiteral("kaj"),
        QStringLiteral("ö"),
        QStringLiteral("holme"),
        QStringLiteral("fyrkant"),
        QStringLiteral("resa"),
        QStringLiteral("härkomst"),
        QStringLiteral("kanal"),
        QStringLiteral("återvändsgränd"),
        QStringLiteral("cesty"),
        QStringLiteral("ostrovček"),
        QStringLiteral("námestie"),
        QStringLiteral("dediny"),
        QStringLiteral("jazdiť"),
        QStringLiteral("zostup"),
        QStringLiteral("stanice"),
        QStringLiteral("cesta"),
        QStringLiteral("pot"),
        QStringLiteral("mesto"),
        QStringLiteral("kraj"),
        QStringLiteral("vas"),
        QStringLiteral("pomol"),
        QStringLiteral("otok"),
        QStringLiteral("otoček"),
        QStringLiteral("trg"),
        QStringLiteral("potovanje"),
        QStringLiteral("spust"),
        QStringLiteral("postaja"),
        QStringLiteral("predor"),
        QStringLiteral("вуліца"),
        QStringLiteral("шаша"),
        QStringLiteral("алея"),
        QStringLiteral("горад"),
        QStringLiteral("мястэчка"),
        QStringLiteral("вёска"),
        QStringLiteral("дарога"),
        QStringLiteral("набярэжная"),
        QStringLiteral("востраў"),
        QStringLiteral("астравок"),
        QStringLiteral("завулак"),
        QStringLiteral("плошча"),
        QStringLiteral("пасёлак"),
        QStringLiteral("праезд"),
        QStringLiteral("праспект"),
        QStringLiteral("станцыя"),
        QStringLiteral("тунэль"),
        QStringLiteral("тупік"),
        QStringLiteral("افي."),
        QStringLiteral("إلى"),
        QStringLiteral("تسوية"),
        QStringLiteral("جادة"),
        QStringLiteral("جزيرة"),
        QStringLiteral("جسر"),
        QStringLiteral("زقاق"),
        QStringLiteral("شارع"),
        QStringLiteral("طريق"),
        QStringLiteral("قرية"),
        QStringLiteral("مأزق"),
        QStringLiteral("محطة"),
        QStringLiteral("مدينة"),
        QStringLiteral("مرور"),
        QStringLiteral("مسار"),
        QStringLiteral("ممر"),
        QStringLiteral("منطقة"),
        QStringLiteral("نفق"),
        QStringLiteral("път"),
        QStringLiteral("булевард"),
        QStringLiteral("град"),
        QStringLiteral("село"),
        QStringLiteral("кей"),
        QStringLiteral("островче"),
        QStringLiteral("платно"),
        QStringLiteral("квадрат"),
        QStringLiteral("пътуване"),
        QStringLiteral("произход"),
        QStringLiteral("гара"),
        QStringLiteral("тунел"),
        QStringLiteral("канал"),
        QStringLiteral("körút"),
        QStringLiteral("híd"),
        QStringLiteral("rakpart"),
        QStringLiteral("állomás"),
        QStringLiteral("alagút"),
        QStringLiteral("đường"),
        QStringLiteral("đại"),
        QStringLiteral("làng"),
        QStringLiteral("cầu"),
        QStringLiteral("đảo"),
        QStringLiteral("phố"),
        QStringLiteral("gốc"),
        QStringLiteral("kênh"),
        QStringLiteral("δρόμο"),
        QStringLiteral("λεωφόρος"),
        QStringLiteral("πόλη"),
        QStringLiteral("κωμόπολη"),
        QStringLiteral("χωριό"),
        QStringLiteral("δρόμος"),
        QStringLiteral("γέφυρα"),
        QStringLiteral("αποβάθρα"),
        QStringLiteral("νησί"),
        QStringLiteral("νησίδα"),
        QStringLiteral("λωρίδα"),
        QStringLiteral("πλατεία"),
        QStringLiteral("χωριό"),
        QStringLiteral("ταξίδια"),
        QStringLiteral("ø"),
        QStringLiteral("bane"),
        QStringLiteral("villages"),
        QStringLiteral("stravenue"),
        QStringLiteral("forge"),
        QStringLiteral("loops"),
        QStringLiteral("crossroad"),
        QStringLiteral("ridges"),
        QStringLiteral("motorway"),
        QStringLiteral("squares"),
        QStringLiteral("ways"),
        QStringLiteral("junctions"),
        QStringLiteral("drives"),
        QStringLiteral("throughway"),
        QStringLiteral("trafficway"),
        QStringLiteral("plaine")
        };
        
        static QHash<QString, int> dictionary = [&]()
        {
            QHash<QString, int> dict;
            for (int i = 0; i < words.size(); ++i)
            {
                dict.insert(words.at(i), i);
            }
            return dict;
        }();
        return dictionary;
    }
    
    union CommonWords
    {
        static inline int getFrequentlyUsed(const QString name)
        {
            return FREQUENTLY_USED_WORDS.indexOf(name);
        }
        
        static inline int getCommonSearch(QString name)
        {
            bool startsWithDigit = false;
            for (int i = 0; i < name.length(); i++)
            {
                if (name.at(i).isDigit())
                {
                    startsWithDigit = true;
                    break;
                }
                else if (name.at(i).isLetter())
                {
                    break;
                }
            }
            if (startsWithDigit && letters(name) < 2)
            {
                name = NUMBER_WITH_LESS_THAN_2_LETTERS;
            }
            
            auto it = COMMON_WORDS().find(name);
            // higher means better for search
            if (it == COMMON_WORDS().end())
            {
                int fq = getFrequentlyUsed(name);
                if (fq != -1)
                {
                    return COMMON_WORDS().size() + fq;
                }
                return -1;
            }
            return *it;
        }
        
        static int letters(const QString &s)
        {
                int count = 0;
                for (int i = 0; i < s.length(); i++)
                {
                    if (!s[i].isDigit() && s[i].isLetter())
                    {
                        count++;
                    }
                }
                return count;
        }

        static inline int getCommonGeocoding(const QString name)
        {
            auto it = COMMON_WORDS().find(name);
            if (it == COMMON_WORDS().end())
            {
                return -1;
            }
            return *it;
        }
        
        static inline void addRegionName(const QString & regionName)
        {
            auto it = COMMON_WORDS().find(regionName.toLower());
            if (it == COMMON_WORDS().end())
            {
                COMMON_WORDS().insert(regionName.toLower(), COMMON_WORDS().size());
            }
        }
        
        static inline void insertCommonWord(const QString name, int index)
        {
            if (index < COMMON_WORDS().size())
            {
                COMMON_WORDS().insert(name, index);
            }
        }
    };
}

#endif // !defined(_OSMAND_CORE_COMMON_WORDS_H_)
