# no longer used didn't compile with ndk 23 / cmake 3.21 (use android-ndk-clang.cmake instead)
set(CMAKE_SYSTEM_NAME Android)
set(CMAKE_TARGET_OS android)
set(CMAKE_SHARED_LIBS_ALLOWED_ON_TARGET TRUE)
set(CMAKE_STATIC_LIBS_ALLOWED_ON_TARGET TRUE)
set(CMAKE_COMPILER_FAMILY "clang")

#set(CMAKE_DL_LIBS "dl")
set(CMAKE_SHARED_LIBRARY_RUNTIME_C_FLAG "-Wl,-rpath,")
set(CMAKE_SHARED_LIBRARY_RUNTIME_C_FLAG_SEP ":")
set(CMAKE_SHARED_LIBRARY_RPATH_LINK_C_FLAG "-Wl,-rpath-link,")
set(CMAKE_SHARED_LIBRARY_SONAME_C_FLAG "-Wl,-soname,")

# Verify environment
if (NOT DEFINED ENV{ANDROID_NDK})
	message(FATAL_ERROR "Environment variable ANDROID_NDK is not set")
endif()
set(ANDROID_NDK "$ENV{ANDROID_NDK}" CACHE STRING "Android NDK path")
if (CMAKE_HOST_WIN32)
	string(REGEX REPLACE "\\\\" "/" ANDROID_NDK ${ANDROID_NDK}) 
endif()


# Determine toolchain prefix
set(toolchain_prefix "")
set(platform_version "android-21")
if (CMAKE_TARGET_CPU_ARCH STREQUAL "armeabi-v7a")
	set(toolchain_prefix "arm-linux-androideabi")
elseif (CMAKE_TARGET_CPU_ARCH STREQUAL "arm64-v8a")
	set(toolchain_prefix "aarch64-linux-android")
elseif (CMAKE_TARGET_CPU_ARCH STREQUAL "x86")
	set(toolchain_prefix "i686-linux-android")
elseif (CMAKE_TARGET_CPU_ARCH STREQUAL "x86-64")
	set(toolchain_prefix "x86_64-linux-android")
else()
	message(FATAL_ERROR "Unsupported target architecture '${CMAKE_TARGET_CPU_ARCH}'")
endif()

set(toolchain_full_name "llvm")
set(toolchain_path "${ANDROID_NDK}/toolchains/${toolchain_full_name}")
if (NOT EXISTS "${toolchain_path}")
	message(FATAL_ERROR "Missing ${toolchain_full_name} toolchain at ${toolchain_path}")
endif()

# Determine NDK host platform
set(exe_host_extension "")
set(ndk_host_platform "")
if (CMAKE_HOST_APPLE)
	if (EXISTS "${toolchain_path}/prebuilt/darwin-x86_64")
		set(ndk_host_platform "darwin-x86_64")
	elseif (EXISTS "${toolchain_path}/prebuilt/darwin-x86")
		set(ndk_host_platform "darwin-x86")
	elseif (EXISTS "${toolchain_path}/prebuilt/darwin")
		set(ndk_host_platform "darwin")
	endif()
elseif (CMAKE_HOST_WIN32)
	if (EXISTS "${toolchain_path}/prebuilt/windows-x86_64")
		set(ndk_host_platform "windows-x86_64")
	elseif (EXISTS "${toolchain_path}/prebuilt/windows-x86")
		set(ndk_host_platform "windows-x86")
	elseif (EXISTS "${toolchain_path}/prebuilt/windows")
		set(ndk_host_platform "windows")
	endif()
	set(exe_host_extension ".exe")
elseif(CMAKE_HOST_UNIX)
	if (EXISTS "${toolchain_path}/prebuilt/linux-x86_64")
		set(ndk_host_platform "linux-x86_64")
	elseif (EXISTS "${toolchain_path}/prebuilt/linux-x86")
		set(ndk_host_platform "linux-x86")
	elseif (EXISTS "${toolchain_path}/prebuilt/linux")
		set(ndk_host_platform "linux")
	endif()
endif()
if (ndk_host_platform STREQUAL "")
	message(FATAL_ERROR "Unsupported NDK host platform")
endif()
set(toolchain_root "${toolchain_path}/prebuilt/${ndk_host_platform}")

# set(CMAKE_TOOLCHAIN_FILE "${ANDROID_NDK}/build/cmake/android.toolchain.cmake")
# set(CMAKE_ANDROID_NDK "${ANDROID_NDK}")
# set(CMAKE_ANDROID_STANDALONE_TOOLCHAIN "${toolchain_root}")

# set(CMAKE_SYSTEM_VERSION 21)
# set(CMAKE_ANDROID_NDK_TOOLCHAIN_VERSION "clang")
# set(CMAKE_ANDROID_ARCH_ABI "${CMAKE_TARGET_CPU_ARCH}")
# set(CMAKE_ANDROID_STL_TYPE c++_static) #c++_static
# set(ANDROID_STL c++_static)

# Configure flags
#set(CMAKE_ASM_FLAGS "--sysroot=${platform_root}")
#set(CMAKE_C_FLAGS "--sysroot=${platform_root}")
#set(CMAKE_CXX_FLAGS "--sysroot=${platform_root}")
#set(CMAKE_EXE_LINKER_FLAGS "--sysroot=${platform_root}")
#set(CMAKE_MODULE_LINKER_FLAGS "--sysroot=${platform_root}")
#set(CMAKE_SHARED_LINKER_FLAGS "--sysroot=${platform_root}")
set(CMAKE_STATIC_LINKER_FLAGS "")

set(CMAKE_ASM_FLAGS_RELEASE "-O3")
set(CMAKE_C_FLAGS_RELEASE "-O3")
set(CMAKE_CXX_FLAGS_RELEASE "-O3")

set(CMAKE_ASM_FLAGS_RELWITHDEBINFO "-O2 -g -DNDEBUG")
set(CMAKE_C_FLAGS_RELWITHDEBINFO "-O2 -g -DNDEBUG")
set(CMAKE_CXX_FLAGS_RELWITHDEBINFO "-O2 -g -DNDEBUG")

set(CMAKE_ASM_FLAGS_MINSIZEREL "-Os -DNDEBUG")
set(CMAKE_C_FLAGS_MINSIZEREL "-Os -DNDEBUG")
set(CMAKE_CXX_FLAGS_MINSIZEREL "-Os -DNDEBUG")

set(CMAKE_ASM_FLAGS_DEBUG "-g -O0")
set(CMAKE_C_FLAGS_DEBUG "-g -O0")
set(CMAKE_CXX_FLAGS_DEBUG "-g -O0")

if (CMAKE_TARGET_CPU_ARCH_FAMILY STREQUAL "arm")
	set(common_compiler_flags "")
	if (CMAKE_TARGET_CPU_ARCH STREQUAL "armeabi-v7a")
		set(common_compiler_flags "${common_compiler_flags} -march=armv7-a")
		set(common_compiler_flags "${common_compiler_flags} -mfpu=vfpv3-d16")
		set(common_compiler_flags "${common_compiler_flags} -mfloat-abi=softfp")
	endif()
	set(CMAKE_ASM_FLAGS "${CMAKE_ASM_FLAGS} ${common_compiler_flags}")
	set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${common_compiler_flags}")
	set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${common_compiler_flags}")
	
	set(common_compiler_release_flags "")
	set(common_compiler_release_flags "${common_compiler_release_flags} -fomit-frame-pointer")
	set(common_compiler_release_flags "${common_compiler_release_flags} -fstrict-aliasing")
	set(common_compiler_release_flags "${common_compiler_release_flags} -funswitch-loops")
	set(common_compiler_release_flags "${common_compiler_release_flags} -finline-limit=300")
	set(CMAKE_ASM_FLAGS_RELEASE "${CMAKE_ASM_FLAGS_RELEASE} ${common_compiler_release_flags}")
	set(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} ${common_compiler_release_flags}")
	set(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE} ${common_compiler_release_flags}")
	
	set(common_compiler_relwithdebuginfo_flags "")
	set(CMAKE_ASM_FLAGS_RELWITHDEBINFO "${CMAKE_ASM_FLAGS_RELWITHDEBINFO} ${common_compiler_release_flags} ${common_compiler_relwithdebuginfo_flags}")
	set(CMAKE_C_FLAGS_RELWITHDEBINFO "${CMAKE_C_FLAGS_RELWITHDEBINFO} ${common_compiler_release_flags} ${common_compiler_relwithdebuginfo_flags}")
	set(CMAKE_CXX_FLAGS_RELWITHDEBINFO "${CMAKE_CXX_FLAGS_RELWITHDEBINFO} ${common_compiler_release_flags} ${common_compiler_relwithdebuginfo_flags}")
	
	set(common_compiler_minsizerel_flags "")
	set(CMAKE_ASM_FLAGS_MINSIZEREL "${CMAKE_ASM_FLAGS_MINSIZEREL} ${common_compiler_release_flags} ${common_compiler_minsizerel_flags}")
	set(CMAKE_C_FLAGS_MINSIZEREL "${CMAKE_C_FLAGS_MINSIZEREL} ${common_compiler_release_flags} ${common_compiler_minsizerel_flags}")
	set(CMAKE_CXX_FLAGS_MINSIZEREL "${CMAKE_CXX_FLAGS_MINSIZEREL} ${common_compiler_release_flags} ${common_compiler_minsizerel_flags}")
	
	set(common_compiler_debug_flags "")
	set(common_compiler_debug_flags "${common_compiler_debug_flags} -fno-omit-frame-pointer")
	set(common_compiler_debug_flags "${common_compiler_debug_flags} -fno-strict-aliasing")
	set(CMAKE_ASM_FLAGS_DEBUG "${CMAKE_ASM_FLAGS_DEBUG} ${common_compiler_debug_flags}")
	set(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} ${common_compiler_debug_flags}")
	set(CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG} ${common_compiler_debug_flags}")

	set(common_linker_flags "")
	set(common_linker_flags "${common_linker_flags} -no-canonical-prefixes")
	if (CMAKE_TARGET_CPU_ARCH STREQUAL "armeabi-v7a")
		set(common_linker_flags "${common_linker_flags} -march=armv7-a")
		set(common_linker_flags "${common_linker_flags} -Wl,--fix-cortex-a8")
	endif()
	set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} ${common_linker_flags}")
	set(CMAKE_MODULE_LINKER_FLAGS "${CMAKE_MODULE_LINKER_FLAGS} ${common_linker_flags}")
	set(CMAKE_SHARED_LINKER_FLAGS "${CMAKE_SHARED_LINKER_FLAGS} ${common_linker_flags}")

elseif (CMAKE_TARGET_CPU_ARCH_FAMILY STREQUAL "arm64")
	set(common_compiler_flags "")
	if (CMAKE_TARGET_CPU_ARCH STREQUAL "arm64-v8a")
		set(common_compiler_flags "${common_compiler_flags} -march=armv8-a")
		set(common_compiler_flags "${common_compiler_flags} -mfpu=vfpv3-d16")
		set(common_compiler_flags "${common_compiler_flags} -mfloat-abi=softfp")
	endif()
	set(CMAKE_ASM_FLAGS "${CMAKE_ASM_FLAGS} ${common_compiler_flags}")
	set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${common_compiler_flags}")
	set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${common_compiler_flags}")
	
	set(common_compiler_release_flags "")
	set(common_compiler_release_flags "${common_compiler_release_flags} -fomit-frame-pointer")
	set(common_compiler_release_flags "${common_compiler_release_flags} -fstrict-aliasing")
	set(common_compiler_release_flags "${common_compiler_release_flags} -funswitch-loops")
	set(common_compiler_release_flags "${common_compiler_release_flags} -finline-limit=300")
	set(CMAKE_ASM_FLAGS_RELEASE "${CMAKE_ASM_FLAGS_RELEASE} ${common_compiler_release_flags}")
	set(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} ${common_compiler_release_flags}")
	set(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE} ${common_compiler_release_flags}")
	
	set(common_compiler_relwithdebuginfo_flags "")
	set(CMAKE_ASM_FLAGS_RELWITHDEBINFO "${CMAKE_ASM_FLAGS_RELWITHDEBINFO} ${common_compiler_release_flags} ${common_compiler_relwithdebuginfo_flags}")
	set(CMAKE_C_FLAGS_RELWITHDEBINFO "${CMAKE_C_FLAGS_RELWITHDEBINFO} ${common_compiler_release_flags} ${common_compiler_relwithdebuginfo_flags}")
	set(CMAKE_CXX_FLAGS_RELWITHDEBINFO "${CMAKE_CXX_FLAGS_RELWITHDEBINFO} ${common_compiler_release_flags} ${common_compiler_relwithdebuginfo_flags}")
	
	set(common_compiler_minsizerel_flags "")
	set(CMAKE_ASM_FLAGS_MINSIZEREL "${CMAKE_ASM_FLAGS_MINSIZEREL} ${common_compiler_release_flags} ${common_compiler_minsizerel_flags}")
	set(CMAKE_C_FLAGS_MINSIZEREL "${CMAKE_C_FLAGS_MINSIZEREL} ${common_compiler_release_flags} ${common_compiler_minsizerel_flags}")
	set(CMAKE_CXX_FLAGS_MINSIZEREL "${CMAKE_CXX_FLAGS_MINSIZEREL} ${common_compiler_release_flags} ${common_compiler_minsizerel_flags}")
	
	set(common_compiler_debug_flags "")
	set(common_compiler_debug_flags "${common_compiler_debug_flags} -fno-omit-frame-pointer")
	set(common_compiler_debug_flags "${common_compiler_debug_flags} -fno-strict-aliasing")
	set(CMAKE_ASM_FLAGS_DEBUG "${CMAKE_ASM_FLAGS_DEBUG} ${common_compiler_debug_flags}")
	set(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} ${common_compiler_debug_flags}")
	set(CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG} ${common_compiler_debug_flags}")

	set(common_linker_flags "")
	set(common_linker_flags "${common_linker_flags} -no-canonical-prefixes")
	set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} ${common_linker_flags}")
	set(CMAKE_MODULE_LINKER_FLAGS "${CMAKE_MODULE_LINKER_FLAGS} ${common_linker_flags}")
	set(CMAKE_SHARED_LINKER_FLAGS "${CMAKE_SHARED_LINKER_FLAGS} ${common_linker_flags}")

elseif (CMAKE_TARGET_CPU_ARCH_FAMILY STREQUAL "x86")
	set(common_compiler_flags "")
	set(common_compiler_flags "${common_compiler_flags} -ffunction-sections")
	set(common_compiler_flags "${common_compiler_flags} -funwind-tables")
	set(common_compiler_flags "${common_compiler_flags} -no-canonical-prefixes")
	set(common_compiler_flags "${common_compiler_flags} -fstack-protector")
	set(CMAKE_ASM_FLAGS "${CMAKE_ASM_FLAGS} ${common_compiler_flags}")
	set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${common_compiler_flags}")
	set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${common_compiler_flags}")
	
	set(common_compiler_release_flags "")
	set(common_compiler_release_flags "${common_compiler_release_flags} -fomit-frame-pointer")
	set(common_compiler_release_flags "${common_compiler_release_flags} -fstrict-aliasing")
	set(common_compiler_release_flags "${common_compiler_release_flags} -funswitch-loops")
	set(common_compiler_release_flags "${common_compiler_release_flags} -finline-limit=300")
	set(CMAKE_ASM_FLAGS_RELEASE "${CMAKE_ASM_FLAGS_RELEASE} ${common_compiler_release_flags}")
	set(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} ${common_compiler_release_flags}")
	set(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE} ${common_compiler_release_flags}")
	
	set(common_compiler_relwithdebuginfo_flags "")
	set(CMAKE_ASM_FLAGS_RELWITHDEBINFO "${CMAKE_ASM_FLAGS_RELWITHDEBINFO} ${common_compiler_release_flags} ${common_compiler_relwithdebuginfo_flags}")
	set(CMAKE_C_FLAGS_RELWITHDEBINFO "${CMAKE_C_FLAGS_RELWITHDEBINFO} ${common_compiler_release_flags} ${common_compiler_relwithdebuginfo_flags}")
	set(CMAKE_CXX_FLAGS_RELWITHDEBINFO "${CMAKE_CXX_FLAGS_RELWITHDEBINFO} ${common_compiler_release_flags} ${common_compiler_relwithdebuginfo_flags}")
	
	set(common_compiler_minsizerel_flags "")
	set(CMAKE_ASM_FLAGS_MINSIZEREL "${CMAKE_ASM_FLAGS_MINSIZEREL} ${common_compiler_release_flags} ${common_compiler_minsizerel_flags}")
	set(CMAKE_C_FLAGS_MINSIZEREL "${CMAKE_C_FLAGS_MINSIZEREL} ${common_compiler_release_flags} ${common_compiler_minsizerel_flags}")
	set(CMAKE_CXX_FLAGS_MINSIZEREL "${CMAKE_CXX_FLAGS_MINSIZEREL} ${common_compiler_release_flags} ${common_compiler_minsizerel_flags}")
	
	set(common_compiler_debug_flags "")
	set(common_compiler_debug_flags "${common_compiler_debug_flags} -fno-omit-frame-pointer")
	set(common_compiler_debug_flags "${common_compiler_debug_flags} -fno-strict-aliasing")
	set(CMAKE_ASM_FLAGS_DEBUG "${CMAKE_ASM_FLAGS_DEBUG} ${common_compiler_debug_flags}")
	set(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} ${common_compiler_debug_flags}")
	set(CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG} ${common_compiler_debug_flags}")

	set(common_linker_flags "")
	set(common_linker_flags "${common_linker_flags} -no-canonical-prefixes")
	set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} ${common_linker_flags}")
	set(CMAKE_MODULE_LINKER_FLAGS "${CMAKE_MODULE_LINKER_FLAGS} ${common_linker_flags}")
	set(CMAKE_SHARED_LINKER_FLAGS "${CMAKE_SHARED_LINKER_FLAGS} ${common_linker_flags}")
endif()

# Finalize settings
set(CMAKE_ASM_FLAGS "${CMAKE_ASM_FLAGS}" CACHE STRING "ASM compiler flags")
set(CMAKE_ASM_FLAGS_DEBUG "${CMAKE_ASM_FLAGS_DEBUG}" CACHE STRING "ASM compiler flags (debug)")
set(CMAKE_ASM_FLAGS_RELEASE "${CMAKE_ASM_FLAGS_RELEASE}" CACHE STRING "ASM compiler flags (release)")
set(CMAKE_ASM_FLAGS_RELWITHDEBINFO "${CMAKE_ASM_FLAGS_RELWITHDEBINFO}" CACHE STRING "ASM compiler flags (release-with-debug-info)")
set(CMAKE_ASM_FLAGS_MINSIZEREL "${CMAKE_ASM_FLAGS_MINSIZEREL}" CACHE STRING "ASM compiler flags (min-size-release)")
set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS}" CACHE STRING "C compiler flags")
set(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG}" CACHE STRING "C compiler flags (debug)")
set(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE}" CACHE STRING "C compiler flags (release)")
set(CMAKE_C_FLAGS_RELWITHDEBINFO "${CMAKE_C_FLAGS_RELWITHDEBINFO}" CACHE STRING "C compiler flags (release-with-debug-info)")
set(CMAKE_C_FLAGS_MINSIZEREL "${CMAKE_C_FLAGS_MINSIZEREL}" CACHE STRING "C compiler flags (min-size-release)")
set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS}" CACHE STRING "CXX compiler flags")
set(CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG}" CACHE STRING "CXX compiler flags (debug)")
set(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE}" CACHE STRING "CXX compiler flags (release)")
set(CMAKE_CXX_FLAGS_RELWITHDEBINFO "${CMAKE_CXX_FLAGS_RELWITHDEBINFO}" CACHE STRING "CXX compiler flags (release-with-debug-info)")
set(CMAKE_CXX_FLAGS_MINSIZEREL "${CMAKE_CXX_FLAGS_MINSIZEREL}" CACHE STRING "CXX compiler flags (min-size-release)")
set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS}" CACHE STRING "Executable linker flags")
set(CMAKE_MODULE_LINKER_FLAGS "${CMAKE_MODULE_LINKER_FLAGS}" CACHE STRING "Module linker flags")
set(CMAKE_SHARED_LINKER_FLAGS "${CMAKE_SHARED_LINKER_FLAGS}" CACHE STRING "Shared linker flags")
set(CMAKE_STATIC_LINKER_FLAGS "${CMAKE_STATIC_LINKER_FLAGS}" CACHE STRING "Static linker flags")

# Configure search paths
#include_directories(SYSTEM ${system_include_dirs})
#set(CMAKE_SYSTEM_INCLUDE_PATH ${system_include_dirs})
#set(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)

#link_directories(${system_lib_dirs})
#set(CMAKE_SYSTEM_LIBRARY_PATH ${system_lib_dirs})
#set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
