/*
 *******************************************************************************
 * Copyright (C) 2001-2012, International Business Machines Corporation and    *
 * others. All Rights Reserved.                                                *
 *******************************************************************************
 */

/** 
 * Port From:   ICU4C v1.8.1 : format : DateIntervalFormatTest
 * Source File: $ICU4CRoot/source/test/intltest/dtifmtts.cpp
 **/

package com.ibm.icu.dev.test.format;

import java.text.FieldPosition;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateIntervalFormat;
import com.ibm.icu.text.DateIntervalInfo;
import com.ibm.icu.text.DateIntervalInfo.PatternInfo;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.DateInterval;
import com.ibm.icu.util.ULocale;

public class DateIntervalFormatTest extends com.ibm.icu.dev.test.TestFmwk {

    public static void main(String[] args) throws Exception {
        new DateIntervalFormatTest().run(args);
    }


    /**
     * Test format
     */
    public void TestFormat() {
        // first item is date pattern
        // followed by a group of locale/from_data/to_data/skeleton/interval_data
        String[] DATA = {
            "yyyy MM dd HH:mm:ss",    
            // test root
            "root", "2007 11 10 10:10:10", "2007 12 10 10:10:10", "yM", "2007-11 \\u2013 12",
         
            // test 'H' and 'h', using availableFormat in fallback
            "en", "2007 11 10 10:10:10", "2007 11 10 15:10:10", "Hms", "10:10:10 \\u2013 15:10:10",
            "en", "2007 11 10 10:10:10", "2007 11 10 15:10:10", "hms", "10:10:10 AM \\u2013 3:10:10 PM",

            // test skeleton with both date and time
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "dMMMyhm", "Nov 10, 2007, 10:10 AM \\u2013 Nov 20, 2007, 10:10 AM", 
            
            "en", "2007 11 10 10:10:10", "2007 11 10 11:10:10", "dMMMyhm", "Nov 10, 2007, 10:10\\u201311:10 AM", 
            
            "en", "2007 11 10 10:10:10", "2007 11 10 11:10:10", "hms", "10:10:10 AM \\u2013 11:10:10 AM", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "EEEEdMMMMy", "Wednesday, October 10, 2007 \\u2013 Friday, October 10, 2008", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "dMMMMy", "October 10, 2007 \\u2013 October 10, 2008", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "dMMMM", "October 10, 2007 \\u2013 October 10, 2008", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "MMMMy", "October 2007 \\u2013 October 2008", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "EEEEdMMMM", "Wednesday, October 10, 2007 \\u2013 Friday, October 10, 2008", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "EdMMMy", "Wed, Oct 10, 2007 \\u2013 Fri, Oct 10, 2008", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "dMMMy", "Oct 10, 2007 \\u2013 Oct 10, 2008", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "dMMM", "Oct 10, 2007 \\u2013 Oct 10, 2008", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "MMMy", "Oct 2007 \\u2013 Oct 2008", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "EdMMM", "Wed, Oct 10, 2007 \\u2013 Fri, Oct 10, 2008", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "EdMy", "Wed, 10/10/07 \\u2013 Fri, 10/10/08", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "dMy", "10/10/07 \\u2013 10/10/08", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "dM", "10/10/07 \\u2013 10/10/08", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "My", "10/07 \\u2013 10/08", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "EdM", "Wed, 10/10/07 \\u2013 Fri, 10/10/08", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "d", "10/10/07 \\u2013 10/10/08", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "Ed", "10 Wed \\u2013 10 Fri", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "y", "2007\\u20132008", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "M", "10/07 \\u2013 10/08", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "MMM", "Oct 2007 \\u2013 Oct 2008", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "MMMM", "October 2007 \\u2013 October 2008", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "hm", "10/10/2007, 10:10 AM \\u2013 10/10/2008, 10:10 AM", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "hmv", "10/10/2007, 10:10 AM PT \\u2013 10/10/2008, 10:10 AM PT", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "hmz", "10/10/2007, 10:10 AM PDT \\u2013 10/10/2008, 10:10 AM PDT", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "h", "10/10/2007, 10 AM \\u2013 10/10/2008, 10 AM", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "hv", "10/10/2007, 10 AM PT \\u2013 10/10/2008, 10 AM PT", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "hz", "10/10/2007, 10 AM PDT \\u2013 10/10/2008, 10 AM PDT", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "EEddMMyyyy", "Wed, 10/10/07 \\u2013 Fri, 10/10/08", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "EddMMy", "Wed, 10/10/07 \\u2013 Fri, 10/10/08", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "hhmm", "10/10/2007, 10:10 AM \\u2013 10/10/2008, 10:10 AM", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "hhmmzz", "10/10/2007, 10:10 AM PDT \\u2013 10/10/2008, 10:10 AM PDT", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "hms", "10/10/2007, 10:10:10 AM \\u2013 10/10/2008, 10:10:10 AM", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "dMMMMMy", "O 10, 2007 \\u2013 O 10, 2008", 
            
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "EEEEEdM", "W, 10/10/07 \\u2013 F, 10/10/08", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "EEEEdMMMMy", "Wednesday, October 10 \\u2013 Saturday, November 10, 2007", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "dMMMMy", "October 10 \\u2013 November 10, 2007", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "dMMMM", "October 10 \\u2013 November 10", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "MMMMy", "October\\u2013November 2007", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "EEEEdMMMM", "Wednesday, October 10 \\u2013 Saturday, November 10", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "EdMMMy", "Wed, Oct 10 \\u2013 Sat, Nov 10, 2007", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "dMMMy", "Oct 10 \\u2013 Nov 10, 2007", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "dMMM", "Oct 10 \\u2013 Nov 10", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "MMMy", "Oct\\u2013Nov 2007", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "EdMMM", "Wed, Oct 10 \\u2013 Sat, Nov 10", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "EdMy", "Wed, 10/10/07 \\u2013 Sat, 11/10/07", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "dMy", "10/10/07 \\u2013 11/10/07", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "dM", "10/10 \\u2013 11/10", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "My", "10/07 \\u2013 11/07", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "EdM", "Wed, 10/10 \\u2013 Sat, 11/10", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "d", "10/10 \\u2013 11/10", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "Ed", "10 Wed \\u2013 10 Sat", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "y", "2007", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "M", "10\\u201311", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "MMM", "Oct\\u2013Nov", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "MMMM", "October\\u2013November", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "hm", "10/10/2007, 10:10 AM \\u2013 11/10/2007, 10:10 AM", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "hmv", "10/10/2007, 10:10 AM PT \\u2013 11/10/2007, 10:10 AM PT", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "hmz", "10/10/2007, 10:10 AM PDT \\u2013 11/10/2007, 10:10 AM PST", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "h", "10/10/2007, 10 AM \\u2013 11/10/2007, 10 AM", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "hv", "10/10/2007, 10 AM PT \\u2013 11/10/2007, 10 AM PT", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "hz", "10/10/2007, 10 AM PDT \\u2013 11/10/2007, 10 AM PST", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "EEddMMyyyy", "Wed, 10/10/07 \\u2013 Sat, 11/10/07", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "EddMMy", "Wed, 10/10/07 \\u2013 Sat, 11/10/07", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "hhmm", "10/10/2007, 10:10 AM \\u2013 11/10/2007, 10:10 AM", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "hhmmzz", "10/10/2007, 10:10 AM PDT \\u2013 11/10/2007, 10:10 AM PST", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "hms", "10/10/2007, 10:10:10 AM \\u2013 11/10/2007, 10:10:10 AM", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "dMMMMMy", "O 10 \\u2013 N 10, 2007", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "EEEEEdM", "W, 10/10 \\u2013 S, 11/10", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EEEEdMMMMy", "Saturday, November 10 \\u2013 Tuesday, November 20, 2007", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "dMMMMy", "November 10\\u201320, 2007", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "dMMMM", "November 10\\u201320", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "MMMMy", "November 2007", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EEEEdMMMM", "Saturday, November 10 \\u2013 Tuesday, November 20", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EdMMMy", "Sat, Nov 10 \\u2013 Tue, Nov 20, 2007", 
            
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "dMMM", "Nov 10\\u201320", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "MMMy", "Nov 2007", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EdMMM", "Sat, Nov 10 \\u2013 Tue, Nov 20", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EdMy", "Sat, 11/10/07 \\u2013 Tue, 11/20/07", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "dMy", "11/10/07 \\u2013 11/20/07", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "dM", "11/10 \\u2013 11/20", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "My", "11/2007", 
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EdM", "Sat, 11/10 \\u2013 Tue, 11/20", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "d", "10\\u201320", 
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "Ed", "10 Sat \\u2013 20 Tue", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "M", "11", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "MMM", "Nov", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "hm", "11/10/2007, 10:10 AM \\u2013 11/20/2007, 10:10 AM", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "hmv", "11/10/2007, 10:10 AM PT \\u2013 11/20/2007, 10:10 AM PT", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "hmz", "11/10/2007, 10:10 AM PST \\u2013 11/20/2007, 10:10 AM PST", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "hz", "11/10/2007, 10 AM PST \\u2013 11/20/2007, 10 AM PST", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EEddMMyyyy", "Sat, 11/10/07 \\u2013 Tue, 11/20/07", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EddMMy", "Sat, 11/10/07 \\u2013 Tue, 11/20/07", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "hhmm", "11/10/2007, 10:10 AM \\u2013 11/20/2007, 10:10 AM", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "hms", "11/10/2007, 10:10:10 AM \\u2013 11/20/2007, 10:10:10 AM", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "dMMMMMy", "N 10\\u201320, 2007", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EEEEEdM", "S, 11/10 \\u2013 T, 11/20", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "EEEEdMMMMy", "Wednesday, January 10, 2007", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "dMMMMy", "January 10, 2007", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "dMMMM", "January 10", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "MMMMy", "January 2007", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "EEEEdMMMM", "Wednesday, January 10", 
            
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "dMMMy", "Jan 10, 2007", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "dMMM", "Jan 10", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "MMMy", "Jan 2007", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "EdMMM", "Wed, Jan 10", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "EdMy", "Wed, 1/10/2007", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "dMy", "1/10/2007", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "dM", "1/10", 
            
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "EdM", "Wed, 1/10", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "d", "10", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "Ed", "10 Wed", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "y", "2007", 
            
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "MMM", "Jan", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "MMMM", "January", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "hm", "10:00 AM \\u2013 2:10 PM", 
            
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "hmz", "10:00 AM \\u2013 2:10 PM PST", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "h", "10 AM \\u2013 2 PM", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "hv", "10 AM \\u2013 2 PM PT", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "hz", "10 AM \\u2013 2 PM PST", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "EEddMMyyyy", "Wed, 01/10/2007", 
            
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "hhmm", "10:00 AM \\u2013 2:10 PM", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "hhmmzz", "10:00 AM \\u2013 2:10 PM PST", 
            
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "dMMMMMy", "J 10, 2007", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "EEEEEdM", "W, 1/10", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "EEEEdMMMMy", "Wednesday, January 10, 2007", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "dMMMMy", "January 10, 2007", 
            
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "MMMMy", "January 2007", 
            
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "EdMMMy", "Wed, Jan 10, 2007", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "dMMMy", "Jan 10, 2007", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "dMMM", "Jan 10", 
            
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "EdMMM", "Wed, Jan 10", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "EdMy", "Wed, 1/10/2007", 
            
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "dM", "1/10", 
            
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "EdM", "Wed, 1/10", 
            
            
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "y", "2007", 
            
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "MMM", "Jan", 
            
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "hm", "10:00\\u201310:20 AM", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "hmv", "10:00\\u201310:20 AM PT", 
            
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "h", "10 AM", 
            
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "hz", "10 AM PST", 
            
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "EddMMy", "Wed, 01/10/2007", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "hhmm", "10:00\\u201310:20 AM", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "hhmmzz", "10:00\\u201310:20 AM PST", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "hms", "10:00:10 AM \\u2013 10:20:10 AM", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "dMMMM", "January 10", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "EEEEdMMMM", "Wednesday, January 10", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "EdMMMy", "Wed, Jan 10, 2007", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "dMMM", "Jan 10", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "EdMMM", "Wed, Jan 10", 
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "dM", "1/10", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "My", "1/2007", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "EdM", "Wed, 1/10", 
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "d", "10", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "Ed", "10 Wed", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "y", "2007", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "M", "1", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "MMM", "Jan", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "MMMM", "January", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "hm", "10:10 AM", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "hmv", "10:10 AM PT", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "hmz", "10:10 AM PST", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "h", "10 AM", 
            
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "hz", "10 AM PST", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "hhmmzz", "10:10 AM PST", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "hms", "10:10:10 AM", 
            
            
            
            "zh", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "EEEEdMMMMy", "2007\\u5e7410\\u670810\\u65e5\\u661f\\u671f\\u4e09\\u81f32008\\u5e7410\\u670810\\u65e5\\u661f\\u671f\\u4e94", 
            
            "zh", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "hm", "2007/10/10 \\u4e0a\\u534810:10 \\u2013 2008/10/10 \\u4e0a\\u534810:10", 
            
            "zh", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "dMMMMy", "2007\\u5e7410\\u670810\\u65e5\\u81f311\\u670810\\u65e5", 
            
            "zh", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "dMMMM", "10\\u670810\\u65e5\\u81f311\\u670810\\u65e5", 
            
            "zh", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "MMMMy", "2007\\u5e7410\\u6708\\u81f311\\u6708", 
            
            "zh", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "EEEEdMMMM", "10\\u670810\\u65e5\\u661f\\u671f\\u4e09\\u81f311\\u670810\\u65e5\\u661f\\u671f\\u516d", 
            
            "zh", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "hmv", "2007/10/10 \\u4E0A\\u534810:10 \\u6D1B\\u6749\\u77F6\\u65F6\\u95F4 \\u2013 2007/11/10 \\u4E0A\\u534810:10 \\u6D1B\\u6749\\u77F6\\u65F6\\u95F4", 
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EEEEdMMMMy", "2007\\u5e7411\\u670810\\u65e5\\u661f\\u671f\\u516d\\u81f320\\u65e5\\u661f\\u671f\\u4e8c", 
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "dMMMMy", "2007\\u5e7411\\u670810\\u65e5\\u81f320\\u65e5", 
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "dMMMM", "11\\u670810\\u65e5\\u81f320\\u65e5", 
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "MMMMy", "2007\\u5E7411\\u6708", // (fixed expected result per ticket 6872<-6626)
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EEEEdMMMM", "11\\u670810\\u65e5\\u661f\\u671f\\u516d\\u81f320\\u65e5\\u661f\\u671f\\u4e8c", 
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EdMMM", "11\\u670810\\u65e5\\u5468\\u516d\\u81f320\\u65e5\\u5468\\u4e8c", 
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EdMy", "07/11/10\\u5468\\u516d\\u81f307/11/20\\u5468\\u4e8c",
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "dMy", "07/11/10 \\u2013 07/11/20", 
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "dM", "11/10 \\u2013 11/20",
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "My", "2007/11", 
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EdM", "11/10\\u5468\\u516d\\u81f311/20\\u5468\\u4e8c", 
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "d", "10\\u65e5\\u81f320\\u65e5", 
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "y", "2007\\u5E74", // (fixed expected result per ticket:6626:)
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "M", "11\\u6708", 
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "MMM", "11\\u6708", // (fixed expected result per ticket 6872<-6626 and others)
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "MMMM", "\\u5341\\u4E00\\u6708", // (fixed expected result per ticket 6872<-6626 and others)
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "hmz", "2007/11/10 \\u4e0a\\u534810:10 GMT-0800 \\u2013 2007/11/20 \\u4e0a\\u534810:10 GMT-0800", 
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "h", "2007/11/10 \\u4e0a\\u534810\\u65f6 \\u2013 2007/11/20 \\u4e0a\\u534810\\u65f6", 
            
            "zh", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "EEEEdMMMMy", "2007\\u5e741\\u670810\\u65e5\\u661f\\u671f\\u4e09", // (fixed expected result per ticket 6872<-6626)
            
            "zh", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "hm", "\\u4e0a\\u534810:00\\u81f3\\u4e0b\\u53482:10", 
            
            "zh", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "hmv", "\\u6D1B\\u6749\\u77F6\\u65F6\\u95F4\\u4E0A\\u534810:00\\u81F3\\u4E0B\\u53482:10", 
            
            "zh", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "hmz", "GMT-0800\\u4e0a\\u534810:00\\u81f3\\u4e0b\\u53482:10", 
            
            "zh", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "h", "\\u4e0a\\u534810\\u65F6\\u81f3\\u4e0b\\u53482\\u65f6", 
            
            "zh", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "hv", "\\u6D1B\\u6749\\u77F6\\u65F6\\u95F4\\u4E0A\\u534810\\u65F6\\u81F3\\u4E0B\\u53482\\u65F6", 
            
            "zh", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "hz", "GMT-0800\\u4e0a\\u534810\\u65F6\\u81f3\\u4e0b\\u53482\\u65f6", 
            
            "zh", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "dMMMM", "1\\u670810\\u65e5", // (fixed expected result per ticket 6872<-6626)
            
            "zh", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "hm", "\\u4e0a\\u534810:00\\u81f310:20", 
            
            "zh", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "hmv", "\\u6D1B\\u6749\\u77F6\\u65F6\\u95F4\\u4E0A\\u534810:00\\u81F310:20", 
            
            "zh", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "h", "\\u4e0a\\u534810\\u65f6", 
            
            "zh", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "hz", "\\u4e0a\\u534810\\u65f6 GMT-0800", 
            
            "zh", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "EEEEdMMMMy", "2007\\u5e741\\u670810\\u65e5\\u661f\\u671f\\u4e09", // (fixed expected result per ticket 6872<-6626)
            
            "zh", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "hm", "\\u4e0a\\u534810:10", 
            
            "zh", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "h", "\\u4e0a\\u534810\\u65f6", 
            
            "de", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "EEEEdMMMy", "Mittwoch, 10. Okt. 2007 - Freitag, 10. Okt. 2008", 
            
            "de", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "dMMMy", "10. Okt. 2007 - 10. Okt. 2008", 
            
            "de", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "dMMM", "10. Okt. 2007 - 10. Okt. 2008", 
            
            "de", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "MMMy", "Okt. 2007 - Okt. 2008", 
            
            "de", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "EEEdMMM", "Mi., 10. Okt. 2007 - Fr., 10. Okt. 2008", 
            
            "de", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "EdMy", "Mi., 10.10.07 - Fr., 10.10.08", 
            
            "de", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "dMy", "10.10.07 - 10.10.08", 
            
            "de", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "dM", "10.10.07 - 10.10.08", 
            
            "de", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "My", "10.07 - 10.08", 
            
            "de", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "EdM", "Mi., 10.10.07 - Fr., 10.10.08", 
            
            "de", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "d", "10.10.07 - 10.10.08", 
            
            "de", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "y", "2007-2008", 
            
            "de", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "M", "10.07 - 10.08", 
            
            "de", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "MMM", "Okt. 2007 - Okt. 2008", 
            
            "de", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "hm", "10.10.2007 10:10 vorm. - 10.10.2008 10:10 vorm.", 
            
            "de", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "jm", "10.10.2007 10:10 - 10.10.2008 10:10", 

            "de", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "EEEEdMMMy", "Mittwoch, 10. Okt. - Samstag, 10. Nov. 2007", 
            
            "de", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "dMMMy", "10. Okt. - 10. Nov. 2007", 
            
            "de", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "dMMM", "10. Okt. - 10. Nov.", 
            
            "de", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "MMMy", "Okt.-Nov. 2007", 
            
            "de", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "EEEEdMMM", "Mittwoch, 10. Okt. - Samstag, 10. Nov.", 
            
            "de", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "EdMy", "Mi., 10.10.07 - Sa., 10.11.07", 
            
            "de", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "dM", "10.10. - 10.11.", 
            
            "de", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "My", "10.07 - 11.07", 
            
            "de", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "EdM", "Mi., 10.10. - Sa., 10.11.", 
            
            "de", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "d", "10.10. - 10.11.", 
            
            
            "de", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "M", "10.-11.", 
            
            "de", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "MMM", "Okt.-Nov.", 
            
            "de", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "hmv", "10.10.2007 10:10 vorm. Los Angeles Zeit - 10.11.2007 10:10 vorm. Los Angeles Zeit", 
            
            "de", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "jmv", "10.10.2007 10:10 Los Angeles Zeit - 10.11.2007 10:10 Los Angeles Zeit", 

            "de", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "hms", "10.10.2007 10:10:10 vorm. - 10.11.2007 10:10:10 vorm.", 
            
            "de", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EEEEdMMMy", "Samstag, 10. - Dienstag, 20. Nov. 2007", 
            
            "de", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "dMMMy", "10.-20. Nov. 2007", 
            
            "de", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "dMMM", "10.-20. Nov.", 
            
            "de", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "MMMy", "Nov. 2007", 
            
            "de", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EEEEdMMM", "Samstag, 10. - Dienstag, 20. Nov.", 
            
            "de", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EdMy", "Sa., 10.11.07 - Di., 20.11.07", 
            
            "de", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "dMy", "10.11.07 - 20.11.07", 
            
            "de", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "dM", "10.11. - 20.11.", 
            
            "de", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "My", "11.2007", 
            
            "de", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "EdM", "Sa., 10.11. - Di., 20.11.", 
            
            "de", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "d", "10.-20.", 
            
            "de", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "y", "2007", 
            
            "de", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "M", "11", 
            
            "de", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "hmv", "10.11.2007 10:10 vorm. Los Angeles Zeit - 20.11.2007 10:10 vorm. Los Angeles Zeit", 
            
            "de", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "jmv", "10.11.2007 10:10 Los Angeles Zeit - 20.11.2007 10:10 Los Angeles Zeit", 

            "de", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "EEEEdMMMy", "Mittwoch, 10. Jan. 2007", 
            
            "de", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "dMMMy", "10. Jan. 2007", 
            
            "de", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "dMMM", "10. Jan.", 
            
            "de", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "MMMy", "Jan. 2007", 
            
            "de", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "EEEEdMMM", "Mittwoch, 10. Jan.", 
            
            "de", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "hmz", "10:00 vorm. - 2:10 nachm. GMT-08:00", 
            
            "de", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "h", "10 vorm. - 2 nachm.", 
            
            "de", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "EEEEdMMM", "Mittwoch, 10. Jan.", 
            
            "de", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "hm", "10:00-10:20 vorm.", 
            
            "de", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "hmv", "10:00-10:20 vorm. Los Angeles Zeit", 
            
            "de", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "hmz", "10:00-10:20 vorm. GMT-08:00", 
            
            "de", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "h", "10 vorm.", 
            
            "de", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "hv", "10 vorm. Los Angeles Zeit", 
            
            "de", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "hz", "10 vorm. GMT-08:00", 
            
            "de", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "EEEEdMMMy", "Mittwoch, 10. Jan. 2007", 
            
            "de", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "hm", "10:10 vorm.", 

            "de", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "jm", "10:10", 

            "de", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "hmv", "10:10 vorm. Los Angeles Zeit", 
            
            "de", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "jmv", "10:10 Los Angeles Zeit", 

            "de", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "hmz", "10:10 vorm. GMT-08:00", 
            
            "de", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "jmz", "10:10 GMT-08:00", 

            "de", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "h", "10 vorm.", 
            
            "de", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "hv", "10 vorm. Los Angeles Zeit", 
            
            "de", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "hz", "10 vorm. GMT-08:00", 
        
            // Thai (default calendar buddhist)

            "th", "2550 10 10 10:10:10", "2551 10 10 10:10:10", "EEEEdMMMy", "\\u0E27\\u0E31\\u0E19\\u0E1E\\u0E38\\u0E18 10 \\u0E15.\\u0E04. 2550 \\u2013 \\u0E27\\u0E31\\u0E19\\u0E28\\u0E38\\u0E01\\u0E23\\u0E4C 10 \\u0E15.\\u0E04. 2551", 
        
        
            "th", "2550 10 10 10:10:10", "2551 10 10 10:10:10", "dMMM", "10 \\u0E15.\\u0E04. 2550 \\u2013 10 \\u0E15.\\u0E04. 2551", 
        
            "th", "2550 10 10 10:10:10", "2551 10 10 10:10:10", "MMMy", "\\u0E15.\\u0E04. 2550 - \\u0E15.\\u0E04. 2551", 
        
        
            "th", "2550 10 10 10:10:10", "2551 10 10 10:10:10", "EdMy", "\\u0E1E. 10/10/50 \\u2013 \\u0E28. 10/10/51", 
        
            "th", "2550 10 10 10:10:10", "2551 10 10 10:10:10", "dMy", "10/10/50 \\u2013 10/10/51", 
        
        
            "th", "2550 10 10 10:10:10", "2551 10 10 10:10:10", "My", "10/50 \\u2013 10/51", 
        
            "th", "2550 10 10 10:10:10", "2551 10 10 10:10:10", "EdM", "\\u0E1E. 10/10/50 \\u2013 \\u0E28. 10/10/51", 
        
        
            "th", "2550 10 10 10:10:10", "2551 10 10 10:10:10", "y", "2550-2551", 
        
            "th", "2550 10 10 10:10:10", "2551 10 10 10:10:10", "M", "10/50 \\u2013 10/51", 
        
        
            "th", "2550 10 10 10:10:10", "2550 11 10 10:10:10", "EEEEdMMMy", "\\u0E27\\u0E31\\u0E19\\u0E1E\\u0E38\\u0E18 10 \\u0E15.\\u0E04. \\u2013 \\u0E27\\u0E31\\u0E19\\u0E40\\u0E2A\\u0E32\\u0E23\\u0E4C 10 \\u0E1E.\\u0E22. 2550", 
        
        
            "th", "2550 10 10 10:10:10", "2550 11 10 10:10:10", "dMMM", "10 \\u0E15.\\u0E04. \\u2013 10 \\u0E1E.\\u0E22.", 
        
            "th", "2550 10 10 10:10:10", "2550 11 10 10:10:10", "MMMy", "\\u0E15.\\u0E04.-\\u0E1E.\\u0E22. 2550", 
        
            "th", "2550 10 10 10:10:10", "2550 11 10 10:10:10", "dM", "10/10 - 10/11", 
        
            "th", "2550 10 10 10:10:10", "2550 11 10 10:10:10", "My", "10/50 \\u2013 11/50", 
        
        
            "th", "2550 10 10 10:10:10", "2550 11 10 10:10:10", "d", "10/10 - 10/11", 
        
            "th", "2550 10 10 10:10:10", "2550 11 10 10:10:10", "y", "\u0E1E.\u0E28. 2550", 
        
        
            "th", "2550 10 10 10:10:10", "2550 11 10 10:10:10", "MMM", "\\u0E15.\\u0E04.-\\u0E1E.\\u0E22.", 

        };
        expect(DATA, DATA.length);
    }


    private void expect(String[] data, int data_length) {
        int i = 1;
        while (i<data_length) {
            String locName = data[i++];
            ULocale loc = new ULocale(locName);
            SimpleDateFormat ref = new SimpleDateFormat(data[0], loc);
            // 'f'
            String datestr = data[i++];
            String datestr_2 = data[i++];
            Date date, date_2;
            try {
                date = ref.parse(datestr);
                date_2 = ref.parse(datestr_2);
            } catch ( ParseException e ) {
                errln("parse exception" + e);
                continue;
            }
            DateInterval dtitv = new DateInterval(date.getTime(), 
                                                  date_2.getTime());
            String oneSkeleton = data[i++];
            DateIntervalFormat dtitvfmt = DateIntervalFormat.getInstance(
                                              oneSkeleton, loc);
            String expected = data[i++];
            String formatted = dtitvfmt.format(dtitv);
            if ( !formatted.equals(Utility.unescape(expected)) )  {
                errln("\"" + locName + "\\" + oneSkeleton + "\\" + datestr + "\\" + datestr_2 + "\"\t expected: " + expected +"\tgot: " + formatted + "\n");
            }
        }
    }


    /* 
     * Test format using user defined DateIntervalInfo
     */
    public void TestFormatUserDII() {
        // first item is date pattern
        // followed by a group of locale/from_data/to_data/interval_data
        String[] DATA = {
            "yyyy MM dd HH:mm:ss",
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "Oct 10, 2007 --- Oct 10, 2008", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "2007 Oct 10 - Nov 2007", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "Nov 10, 2007 --- Nov 20, 2007", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "Jan 10, 2007", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "Jan 10, 2007", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "Jan 10, 2007", 
            
            "zh", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "2007\\u5e7410\\u670810\\u65e5 --- 2008\\u5e7410\\u670810\\u65e5", 
            
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "2007\\u5e7411\\u670810\\u65e5 --- 2007\\u5e7411\\u670820\\u65e5", 
            
            "zh", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "2007\\u5e741\\u670810\\u65e5", // (fixed expected result per ticket 6872<-6626)
            
            "zh", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "2007\\u5e741\\u670810\\u65e5", // (fixed expected result per ticket 6872<-6626)
            
            "zh", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "2007\\u5e741\\u670810\\u65e5", // (fixed expected result per ticket 6872<-6626)
            
            "de", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "10. Okt. 2007 --- 10. Okt. 2008", 
            
            "de", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "2007 Okt. 10 - Nov. 2007", 
            
            "de", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "10. Nov. 2007 --- 20. Nov. 2007", 
            
            "de", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "10. Jan. 2007", 
            
            "de", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "10. Jan. 2007", 
            
            "de", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "10. Jan. 2007", 
            
            "es", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "10 oct 2007 --- 10 oct 2008", 
            
            "es", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "2007 oct 10 - nov 2007", 
            
            "es", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "10 nov 2007 --- 20 nov 2007", 
            
            "es", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "10 ene 2007", 
            
            "es", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "10 ene 2007", 
            
            "es", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "10 ene 2007", 
        };
        expectUserDII(DATA, DATA.length);
    }
    
    
    private void expectUserDII(String[] data, int data_length) {
        int i = 1;
        while (i<data_length) {
            String locName = data[i++];
            ULocale loc = new ULocale(locName);
            SimpleDateFormat ref = new SimpleDateFormat(data[0], loc);
            // 'f'
            String datestr = data[i++];
            String datestr_2 = data[i++];
            Date date, date_2;
            try {
                date = ref.parse(datestr);
                date_2 = ref.parse(datestr_2);
            } catch ( ParseException e ) {
                errln("parse exception" + e);
                continue;
            }
            DateInterval dtitv = new DateInterval(date.getTime(), 
                                                  date_2.getTime());

            DateIntervalInfo dtitvinf = new DateIntervalInfo();
            dtitvinf.setFallbackIntervalPattern("{0} --- {1}");
            dtitvinf.setIntervalPattern("yMMMd", Calendar.MONTH, "yyyy MMM d - MMM y");
            dtitvinf.setIntervalPattern("yMMMd", Calendar.HOUR_OF_DAY, "yyyy MMM d HH:mm - HH:mm");
            DateIntervalFormat dtitvfmt = DateIntervalFormat.getInstance(
                        DateFormat.YEAR_ABBR_MONTH_DAY,
                        loc, dtitvinf);
            String expected = data[i++];
            String formatted = dtitvfmt.format(dtitv);
            if ( !formatted.equals(Utility.unescape(expected)) )  {
                errln("userDII: \"" + locName + "\\" + datestr + "\\" + datestr_2 + "\"\t expected: " + expected +"\tgot: " + formatted + "\n");
            }
        }
    }



    /* 
     * Test format using user defined DateIntervalInfo
     */
    public void TestFormatCLDR() {
        // first item is date pattern
        // followed by a group of locale/from_data/to_data/interval_data
        String[] DATA = {
            "yyyy MM dd HH:mm:ss",    
            "en", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "all diff", 
            
            "en", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "2007 diff Oct 10 - Nov 2007", 
            
            "en", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "2007 Nov 10 ~ 20", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "Jan 10, 2007", 
            
            "en", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "Jan 10, 2007", 
            
            "en", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "Jan 10, 2007", 
            
            "zh", "2007 10 10 10:10:10", "2008 10 10 10:10:10", "all diff", 
            
            "zh", "2007 10 10 10:10:10", "2007 11 10 10:10:10", "2007 diff 10\\u6708 10 - 11\\u6708 2007", 
            
            "zh", "2007 11 10 10:10:10", "2007 11 20 10:10:10", "2007 11\\u6708 10 ~ 20", 
            
            "zh", "2007 01 10 10:00:10", "2007 01 10 14:10:10", "2007\u5E741\\u670810\u65E5", // (fixed expected result per ticket 6872<-6626)
            
            "zh", "2007 01 10 10:00:10", "2007 01 10 10:20:10", "2007\u5E741\\u670810\u65E5", // (fixed expected result per ticket 6872<-6626)
            
            "zh", "2007 01 10 10:10:10", "2007 01 10 10:10:20", "2007\u5E741\\u670810\u65E5", // (fixed expected result per ticket 6872<-6626)
        };
        expectUserCLDR(DATA, DATA.length);
    }
    
    
    private void expectUserCLDR(String[] data, int data_length) {
        int i = 1;
        while (i<data_length) {
            String locName = data[i++];
            ULocale loc = new ULocale(locName);
            SimpleDateFormat ref = new SimpleDateFormat(data[0], loc);
            // 'f'
            String datestr = data[i++];
            String datestr_2 = data[i++];
            Date date, date_2;
            try {
                date = ref.parse(datestr);
                date_2 = ref.parse(datestr_2);
            } catch ( ParseException e ) {
                errln("parse exception" + e);
                continue;
            }
            DateInterval dtitv = new DateInterval(date.getTime(), 
                                                  date_2.getTime());

            DateIntervalFormat dtitvfmt = DateIntervalFormat.getInstance("yyyyMMMdd", loc);
            //DateIntervalFormat dtitvfmt = DateIntervalFormat.getInstance("yMd");
            //SimpleDateFormat dtfmt = new SimpleDateFormat("yyyy 'year' MMM 'month' dd 'day'", loc);
            //dtitvfmt.setDateFormat(dtfmt);
            DateIntervalInfo dtitvinf = new DateIntervalInfo();
            dtitvinf.setFallbackIntervalPattern("{0} --- {1}");
            dtitvinf.setIntervalPattern("yMMMd", Calendar.YEAR, "'all diff'");
            dtitvinf.setIntervalPattern("yMMMd", Calendar.MONTH, "yyyy 'diff' MMM d - MMM y");
            dtitvinf.setIntervalPattern("yMMMd", Calendar.DATE, "yyyy MMM d ~ d");
            dtitvinf.setIntervalPattern("yMMMd", Calendar.HOUR_OF_DAY, "yyyy MMMd HH:mm ~ HH:mm");
            dtitvfmt.setDateIntervalInfo(dtitvinf);
            FieldPosition pos = new FieldPosition(0);
            StringBuffer str = new StringBuffer("");
            DateFormat dtfmt = dtitvfmt.getDateFormat();
            Calendar fromCalendar = (Calendar) dtfmt.getCalendar().clone();
            Calendar toCalendar = (Calendar) dtfmt.getCalendar().clone();
            fromCalendar.setTimeInMillis(dtitv.getFromDate());
            toCalendar.setTimeInMillis(dtitv.getToDate());
            dtitvfmt.format(fromCalendar, toCalendar, str, pos);

            String expected = data[i++];
            String formatted = dtitvfmt.format(dtitv).toString();
            if ( !formatted.equals(Utility.unescape(expected)) )  {
                errln("CLDR: \"" + locName + "\\" + datestr + "\\" + datestr_2 + "\"\t expected: " + expected +"\tgot: " + formatted + "\n");
            }
        }
    }


    /**
     * Stress test
     */
    public void TestStress() {
        if (getInclusion() <= 5) {
            logln("INFO: Skipping test");
            return;
        }

        // test data.
        // The 1st is the format pattern,
        // Next are pairs in which the 1st in the pair is the earlier date
        // and the 2nd in the pair is the later date
        String[] DATA = {
            "yyyy MM dd HH:mm:ss",
            "2007 10 10 10:10:10", "2008 10 10 10:10:10", 
            "2007 10 10 10:10:10", "2007 11 10 10:10:10", 
            "2007 11 10 10:10:10", "2007 11 20 10:10:10", 
            "2007 01 10 10:00:10", "2007 01 10 14:10:10", 
            "2007 01 10 10:00:10", "2007 01 10 10:20:10", 
            "2007 01 10 10:10:10", "2007 01 10 10:10:20", 
        };


        String[][] testLocale = {
            {"en", "", ""},
            {"zh", "", ""},
            {"de", "", ""},
            {"ar", "", ""},
            {"en", "GB",  ""},
            {"fr", "", ""},
            {"it", "", ""},
            {"nl", "", ""},
            {"zh", "TW",  ""},
            {"ja", "", ""},
            {"pt", "BR", ""},
            {"ru", "", ""},
            {"tr", "", ""},
            {"es", "", ""},
            {"ko", "", ""},
            //{"th", "", ""},
            {"sv", "", ""},
            {"pl", "", ""},
            {"fi", "", ""},
            {"da", "", ""},
            {"pt", "PT", ""},
            {"ro", "", ""},
            {"hu", "", ""},
            {"he", "", ""},
            {"in", "", ""},
            {"cs", "", ""},
            {"el", "", ""},
            {"no", "", ""},
            {"vi", "", ""},
            {"bg", "", ""},
            {"hr", "", ""},
            {"lt", "", ""},
            {"sk", "", ""},
            {"sl", "", ""},
            {"sr", "", ""},
            {"ca", "", ""},
            {"lv", "", ""},
            {"uk", "", ""},
            {"hi", "", ""},
        };

        int localeIndex;
        for ( localeIndex = 0; localeIndex < testLocale.length; ++localeIndex) {
            stress(DATA, DATA.length, new Locale(testLocale[localeIndex][0], 
                   testLocale[localeIndex][1], testLocale[localeIndex][2]), 
                   testLocale[localeIndex][0]+testLocale[localeIndex][1]);
        }
    }

    private void stress(String[] data, int data_length, Locale loc, String locName) {
        String[] skeleton = {
            "EEEEdMMMMy",
            "dMMMMy",
            "dMMMM",
            "MMMMy",
            "EEEEdMMMM",
            "EEEdMMMy",
            "dMMMy",
            "dMMM",
            "MMMy",
            "EEEdMMM",
            "EEEdMy",
            "dMy",
            "dM",
            "My",
            "EEEdM",
            "d",
            "EEEd",
            "y",
            "M",
            "MMM",
            "MMMM",
            "hm",
            "hmv",
            "hmz",
            "h",
            "hv",
            "hz",
            "EEddMMyyyy", // following could be normalized
            "EddMMy", 
            "hhmm",
            "hhmmzz",
            "hms",  // following could not be normalized
            "dMMMMMy",
            "EEEEEdM",
        };

        int i = 0;

        SimpleDateFormat ref = new SimpleDateFormat(data[i++], loc);

        while (i<data_length) {
            // 'f'
            String datestr = data[i++];
            String datestr_2 = data[i++];
            Date date;
            Date date_2;
            try {
                date = ref.parse(datestr);
                date_2 = ref.parse(datestr_2);
            } catch ( ParseException e ) {
                errln("parse exception" + e);
                continue;
            }
            DateInterval dtitv = new DateInterval(date.getTime(), date_2.getTime());

            for ( int skeletonIndex = 0; 
                  skeletonIndex < skeleton.length; 
                  ++skeletonIndex ) {
                String oneSkeleton = skeleton[skeletonIndex];
                // need special handle of "Thai" since the default calendar
                // of "Thai" is "Budd", not "Gregorian".
                DateIntervalFormat dtitvfmt = DateIntervalFormat.getInstance(oneSkeleton, loc);
                /*
                if ( locName.equals("th") ) {
                    // reset calendar to be Gregorian
                    GregorianCalendar gregCal = new GregorianCalendar(loc);
                    DateFormat dformat = dtitvfmt.getDateFormat();
                    DateFormat newOne = (DateFormat)dformat.clone();
                    newOne.setCalendar(gregCal);
                    dtitvfmt.setDateFormat(newOne);
                }
                */
                dtitvfmt.format(dtitv);
            }


            // test interval format by algorithm 
            for ( int style = DateFormat.FULL; style  < 4; ++style ) {
                SimpleDateFormat dtfmt = (SimpleDateFormat) DateFormat.getDateInstance(style, loc);
                FieldPosition pos = new FieldPosition(0);
                StringBuffer str = new StringBuffer("");
                Calendar fromCalendar = (Calendar) dtfmt.getCalendar().clone();
                Calendar toCalendar = (Calendar) dtfmt.getCalendar().clone();
                fromCalendar.setTimeInMillis(dtitv.getFromDate());
                toCalendar.setTimeInMillis(dtitv.getToDate());
                dtfmt.intervalFormatByAlgorithm(fromCalendar, toCalendar, str, pos);
            } 
        } 
    }

    /*
     * Ticket#6396 DateIntervalInfo of ICU4J 4.0d3 throw NullPointerException 
     */
    public void TestT6396() {
        DateIntervalInfo dii = new DateIntervalInfo(new ULocale("th_TH"));
        try {
            // ticket#6396 reported toString() throws NullPointerException
            String diiStr = dii.toString();
            logln("new DateIntervalInfo(new ULocale(\"th_TH\")).toString() - " + diiStr);

            // equals also had the similar problem
            DateIntervalInfo dii1 = (DateIntervalInfo)dii.clone();
            if (!dii.equals(dii1)) {
                errln("FAIL: Cloned DateIntervalInfo is not equal to the source");
            }
        } catch (Exception e) {
            errln("FAIL: Exception - " + e.getClass().getName());
        }
    }
    
    /* Tests the method
     *      public boolean equals(Object a)
     */
    public void TestDateIntervalInfoEquals(){
        // Tests when "if ( a instanceof PatternInfo )" is false
        DateIntervalInfo diia = new DateIntervalInfo();
        if(diia.equals("dummy")){
            errln("DateIntervalInfo.equals(Object a) was suppose to return " +
                    "false for a String object.");
        }
        if(diia.equals(0)){
            errln("DateIntervalInfo.equals(Object a) was suppose to return " +
                    "false for an Integer object.");
        }
        if(diia.equals(0.0)){
            errln("DateIntervalInfo.equals(Object a) was suppose to return " +
                    "false for an Integer object.");
        }
        if(diia.equals(new Object())){
            errln("DateIntervalInfo.equals(Object a) was suppose to return " +
                    "false for an Integer object.");
        }
    }
    
    /* Tests the method
     *      public Object cloneAsThawed()
     */
    public void TestCloseAsThawed(){
        DateIntervalInfo dii = new DateIntervalInfo();
        try{
            dii.cloneAsThawed();
        } catch(Exception e){
            errln("DateIntervalInfo.closeAsThawed() was not suppose to return " +
                    "an exception.");
        }
    }
    
    /* Tests the method
     *      public boolean isFrozen()
     */
    public void TestIsFrozen(){
        DateIntervalInfo dii = new DateIntervalInfo();
        if(dii.isFrozen() != false){
            errln("DateIntervalInfo.isFrozen() is suppose to return false.");
        }
        dii.freeze();
        
        if(dii.isFrozen() != true){
            errln("DateIntervalInfo.isFrozen() is suppose to return true.");
        }
    }
    
    /* Tests the method
     *      public boolean clone()
     */
    public void TestClone(){
        DateIntervalInfo dii = new DateIntervalInfo(new ULocale("en_US"));
        DateIntervalInfo dii_clone = (DateIntervalInfo) dii.clone();
        dii_clone.freeze();
        
        // Tests when "if ( frozen )" is true
        if(!dii.equals(dii_clone)){
            errln("DateIntervalInfo.clone() is suppose to return true for " +
                    "an original DateIntervalInfo object and a clone of the " +
                    "original DateIntervalInfo object.");
        }
    }
    
    /* Tests the method
     *      public void setFallbackIntervalPattern(String fallbackPattern)
     */
    public void TestSetFallbackIntervalPattern(){
        DateIntervalInfo dii = new DateIntervalInfo(new ULocale("en_US"));
        // Tests when "if ( frozen )" is true
        try{
            dii.freeze();
            dii.setFallbackIntervalPattern("");
            errln("DateIntervalInfo.setFallbackIntervalPattern(String fallbackPattern) " +
                    "was suppose to return an exception for a frozen object.");
        } catch (Exception e){}
        
        // Tests when "if ( firstPatternIndex == -1 || secondPatternIndex == -1 )" is true
        dii = (DateIntervalInfo) dii.cloneAsThawed();
        try{
            dii.setFallbackIntervalPattern("");
            errln("DateIntervalInfo.setFallbackIntervalPattern(String fallbackPattern) " +
                    "was suppose to return an exception for a string object of ''.");
        } catch(Exception e){}
        
        try{
            dii.setFallbackIntervalPattern("0");
            errln("DateIntervalInfo.setFallbackIntervalPattern(String fallbackPattern) " +
                    "was suppose to return an exception for a string object of 0.");
        } catch(Exception e){}
        
        // Tests when "if ( firstPatternIndex > secondPatternIndex )" is true
        dii.setFallbackIntervalPattern("{1}{0}");
        if(dii.getDefaultOrder() != true)
            errln("DateIntervalInfo.setFallbackIntervalPattern(String fallbackPattern) " +
                    "was suppose to change the variable 'fFirstDateInPtnIsLaterDate' " +
                    "to true.");
    }
    
    /* Tests the method
     *      public PatternInfo getIntervalPattern(String skeleton, int field)
     */
    public void TestGetIntervalPattern(){
        // Tests when "if ( field > MINIMUM_SUPPORTED_CALENDAR_FIELD )" is true
        // MINIMUM_SUPPORTED_CALENDAR_FIELD = Calendar.MINUTE;
        DateIntervalInfo dii = new DateIntervalInfo();
        try{
            dii.getIntervalPattern("", Calendar.MINUTE+1);
            errln("DateIntervalInfo.getIntervalPattern(String,int) was suppose " +
                    "to return an exception for the 'int field' parameter " +
                    "when it exceeds MINIMUM_SUPPORTED_CALENDAR_FIELD.");
        } catch(Exception e){}
    }
    
    /* Tests the method
     *      public void setIntervalPattern(String skeleton, int lrgDiffCalUnit, String intervalPattern)
     */
    public void TestSetIntervalPattern(){
        DateIntervalInfo dii = new DateIntervalInfo();
        // Tests when "if ( frozen )" is true
        try{
            dii.freeze();
            dii.setIntervalPattern("", 0, "");
            errln("DateIntervalInfo.setIntervalPattern(String,int,String) " +
                    "was suppose to return an exception when the " +
                    "DateIntervalInfo object is frozen.");
        } catch(Exception e){}
        
        // Tests when "if ( lrgDiffCalUnit > MINIMUM_SUPPORTED_CALENDAR_FIELD )" is true
        // MINIMUM_SUPPORTED_CALENDAR_FIELD = Calendar.MINUTE;
        try{
            dii = (DateIntervalInfo) dii.cloneAsThawed();
            dii.setIntervalPattern("", Calendar.MINUTE+1, "");
            errln("DateIntervalInfo.setIntervalPattern(String,int,String) " +
                    "was suppose to return an exception when the " +
                    "variable 'lrgDiffCalUnit' is greater than " + 
                    "MINIMUM_SUPPORTED_CALENDAR_FIELD.");
        } catch(Exception e){}
    }
    
    /* Tests the method
     *      public int hashCode()
     */
    public void TestHashCode(){
        // Tests when
        //      "int hash = fIntervalPatternFirstPart != null ? fIntervalPatternFirstPart.hashCode() : 0;"
        // is false
        PatternInfo dp = new PatternInfo(null, null, false);
        if(dp.hashCode() != 0){
            errln("PatternInfo.hashCode() was suppose to return 0 for a null " +
                    "paramter in the constructor.");
        }
    }
    
    /* Tests the method
     *      public boolean equals(Object a)
     * in PatternInfo
     */
    public void TestPattternInfoEquals(){
        // Tests when "if ( a instanceof PatternInfo )" is false
        PatternInfo pi = new PatternInfo("","", false);
        if(pi.equals(new Object())){
            errln("PatternInfo.equals(Object) is suppose to return false " +
                    "when it is not an instance of PatternInfo.");
        }
        if(pi.equals("")){
            errln("PatternInfo.equals(Object) is suppose to return false " +
                    "when it is not an instance of PatternInfo.");
        }
        if(pi.equals(0)){
            errln("PatternInfo.equals(Object) is suppose to return false " +
                    "when it is not an instance of PatternInfo.");
        }
        if(pi.equals(0.0)){
            errln("PatternInfo.equals(Object) is suppose to return false " +
                    "when it is not an instance of PatternInfo.");
        }
    }
    
    public void TestDateIntervalCoverage() {
        DateInterval di = new DateInterval(0, 1);
        
        if (di.equals("Test")) {
            errln("Comparison test should fail.");
        }
        
        if (di.toString() == null) {
            errln("toString should not return null.");
        }
        
        if (di.hashCode() != 1) {
            errln("hasCode() should return 1.");
        }
    }
}
