package net.osmand.plus.settings.backend.backup.exporttype;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import net.osmand.plus.OsmandApplication;
import net.osmand.plus.R;
import net.osmand.plus.download.local.LocalItemType;
import net.osmand.plus.settings.backend.ApplicationMode;
import net.osmand.plus.settings.backend.ApplicationModeBean;
import net.osmand.plus.settings.backend.ExportCategory;
import net.osmand.plus.settings.backend.backup.SettingsItemType;
import net.osmand.plus.settings.backend.backup.items.FileSettingsItem.FileSubtype;
import net.osmand.plus.settings.backend.backup.items.ProfileSettingsItem;
import net.osmand.plus.settings.backend.backup.items.SettingsItem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ProfileExportType extends AbstractExportType {

	@Override
	public int getTitleId() {
		return R.string.shared_string_profiles;
	}

	@Override
	public int getIconId() {
		return R.drawable.ic_action_manage_profiles;
	}

	@NonNull
	@Override
	public List<?> fetchExportData(@NonNull OsmandApplication app, boolean offlineBackup) {
		List<ApplicationModeBean> appModeBeans = new ArrayList<>();
		for (ApplicationMode appMode : ApplicationMode.allPossibleValues()) {
			if (!shouldSkip(app, appMode)) {
				appModeBeans.add(appMode.toModeBean());
			}
		}
		return appModeBeans;
	}

	private boolean shouldSkip(@NonNull OsmandApplication app, @NonNull ApplicationMode appMode) {
		return !appMode.isCustomProfile() && !app.getSettings().isProfileModified(appMode);
	}

	@NonNull
	@Override
	public List<?> fetchImportData(@NonNull SettingsItem settingsItem, boolean importCompleted) {
		ProfileSettingsItem profileSettingsItem = (ProfileSettingsItem) settingsItem;
		return Collections.singletonList(profileSettingsItem.getModeBean());
	}

	@Override
	public boolean isRelatedObject(@NonNull OsmandApplication app, @NonNull Object object) {
		return object instanceof ApplicationModeBean;
	}

	@Override
	public boolean isAvailableInFreeVersion() {
		return true;
	}

	@NonNull
	@Override
	public ExportCategory getRelatedExportCategory() {
		return ExportCategory.SETTINGS;
	}

	@NonNull
	@Override
	public SettingsItemType getRelatedSettingsItemType() {
		return SettingsItemType.PROFILE;
	}

	@NonNull
	@Override
	public List<FileSubtype> getRelatedFileSubtypes() {
		return Collections.emptyList();
	}

	@Nullable
	@Override
	public LocalItemType getRelatedLocalItemType() {
		return LocalItemType.PROFILES;
	}
}
