package net.osmand.plus.plugins.externalsensors;

import java.util.ArrayList;
import java.util.UUID;

public class GattAttributes {
	public static final ArrayList<UUID> SUPPORTED_CHARACTERISTICS = new ArrayList<>();

	public static String CLIENT_CHARACTERISTIC_CONFIG = "00002902-0000-1000-8000-00805f9b34fb";
	public static final String SERVICE_HEART_RATE = "0000180d-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_SERVICE_HEART_RATE = UUID.fromString(SERVICE_HEART_RATE);
	public static final String SERVICE_CYCLING_POWER = "00001818-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_SERVICE_CYCLING_POWER = UUID.fromString(SERVICE_CYCLING_POWER);
	public static final String CHARACTERISTIC_CYCLING_POWER_MEASUREMENT = "00002a63-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_CHARACTERISTIC_CYCLING_POWER_MEASUREMENT = UUID.fromString(CHARACTERISTIC_CYCLING_POWER_MEASUREMENT);

	public static final String SERVICE_BLOOD_PRESSURE = "00001810-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_SERVICE_BLOOD_PRESSURE = UUID.fromString(SERVICE_BLOOD_PRESSURE);
	public static final String SERVICE_CYCLING_SPEED_AND_CADENCE = "00001816-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_SERVICE_CYCLING_SPEED_AND_CADENCE = UUID.fromString(SERVICE_CYCLING_SPEED_AND_CADENCE);
	public static final String SERVICE_RUNNING_SPEED_AND_CADENCE = "00001814-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_SERVICE_RUNNING_SPEED_AND_CADENCE = UUID.fromString(SERVICE_RUNNING_SPEED_AND_CADENCE);

	public static final String CHARACTERISTIC_RUNNING_SPEED_AND_CADENCE_MEASUREMENT = "00002a53-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_CHARACTERISTIC_RUNNING_SPEED_AND_CADENCE_MEASUREMENT = UUID.fromString(CHARACTERISTIC_RUNNING_SPEED_AND_CADENCE_MEASUREMENT);


	public static final UUID UUID_SERVICE_TEMPERATURE_UUID = UUID.fromString("00001809-0000-1000-8000-00805F9B34FB");
	public static final String CHAR_TEMPERATURE_MEASUREMENT = "00002a1c-0000-1000-8000-00805F9B34FB";
	public static final UUID UUID_CHAR_TEMPERATURE_UUID = UUID.fromString(CHAR_TEMPERATURE_MEASUREMENT);
	public static final String SERVICE_TEMPERATURE = "00001809-0000-1000-8000-00805F9B34FB";
	public static final UUID UUID_SERVICE_TEMPERATURE = UUID.fromString(SERVICE_TEMPERATURE);
	public static final String CHARACTERISTIC_HEART_RATE_BODY_PART = "00002a38-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_CHARACTERISTIC_HEART_RATE_BODY_PART = UUID.fromString(CHARACTERISTIC_HEART_RATE_BODY_PART);
	public static final String CHARACTERISTIC_BP_MEASUREMENT = "00002a35-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_CHARACTERISTIC_BP_MEASUREMENT = UUID.fromString(CHARACTERISTIC_BP_MEASUREMENT);
	public static final String CHARACTERISTIC_ICP_MEASUREMENT = "00002a36-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_CHARACTERISTIC_ICP_MEASUREMENT = UUID.fromString(CHARACTERISTIC_ICP_MEASUREMENT);
	public static final String CHARACTERISTIC_HEART_RATE_MEASUREMENT = "00002a37-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_CHARACTERISTIC_HEART_RATE_MEASUREMENT = UUID.fromString(CHARACTERISTIC_HEART_RATE_MEASUREMENT);
	public static final String CHARACTERISTIC_CYCLING_SPEED_AND_CADENCE_MEASUREMENT = "00002a5b-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_CHARACTERISTIC_CYCLING_SPEED_AND_CADENCE_MEASUREMENT = UUID.fromString(CHARACTERISTIC_CYCLING_SPEED_AND_CADENCE_MEASUREMENT);
	public static final String SERVICE_DEVICE_INFORMATION = "0000180a-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_SERVICE_DEVICE_INFORMATION = UUID.fromString(SERVICE_DEVICE_INFORMATION);
	public static final String SERVICE_BATTERY = "0000180f-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_SERVICE_BATTERY = UUID.fromString(SERVICE_BATTERY);
	public static final String CHARACTERISTIC_CLIENT_CONFIG = "00002902-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_CHARACTERISTIC_CLIENT_CONFIG = UUID.fromString(CHARACTERISTIC_CLIENT_CONFIG);
	public static final String CHARACTERISTIC_BATTERY = "00002a19-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_CHARACTERISTIC_BATTERY_LEVEL = UUID.fromString(CHARACTERISTIC_BATTERY);
	public static final String CHARACTERISTIC_MANUFACTURER_NAME = "00002a29-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_CHARACTERISTIC_MANUFACTURER_NAME = UUID.fromString(CHARACTERISTIC_MANUFACTURER_NAME);
	public static final String CHARACTERISTIC_CYCLING_SPEED_AND_CADENCE_FEATURE = "00002a5c-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_CHARACTERISTIC_CYCLING_SPEED_AND_CADENCE_FEATURE = UUID.fromString(CHARACTERISTIC_CYCLING_SPEED_AND_CADENCE_FEATURE);
	public static final String CHARACTERISTIC_CYCLING_POWER_FEATURE = "00002a65-0000-1000-8000-00805f9b34fb";
	public static final UUID UUID_CHARACTERISTIC_CYCLING_POWER_FEATURE = UUID.fromString(CHARACTERISTIC_CYCLING_POWER_FEATURE);

	public static final String CHARACTERISTIC_UNDEFINED = "00000000-0000-0000-0000-000000000000";
	public static final UUID UUID_CHARACTERISTIC_UNDEFINED = UUID.fromString(CHARACTERISTIC_UNDEFINED);

	static {
		SUPPORTED_CHARACTERISTICS.add(UUID.fromString(CHARACTERISTIC_CYCLING_SPEED_AND_CADENCE_MEASUREMENT));
		SUPPORTED_CHARACTERISTICS.add(UUID.fromString(CHARACTERISTIC_HEART_RATE_MEASUREMENT));
		SUPPORTED_CHARACTERISTICS.add(UUID.fromString(CHARACTERISTIC_BP_MEASUREMENT));
		SUPPORTED_CHARACTERISTICS.add(UUID.fromString(CHARACTERISTIC_ICP_MEASUREMENT));
		SUPPORTED_CHARACTERISTICS.add(UUID.fromString(CHARACTERISTIC_RUNNING_SPEED_AND_CADENCE_MEASUREMENT));
		SUPPORTED_CHARACTERISTICS.add(UUID.fromString(CHARACTERISTIC_BATTERY));
		SUPPORTED_CHARACTERISTICS.add(UUID.fromString(SERVICE_CYCLING_SPEED_AND_CADENCE));
		SUPPORTED_CHARACTERISTICS.add(UUID.fromString(SERVICE_RUNNING_SPEED_AND_CADENCE));
		SUPPORTED_CHARACTERISTICS.add(UUID.fromString(SERVICE_HEART_RATE));
		SUPPORTED_CHARACTERISTICS.add(UUID.fromString(SERVICE_BLOOD_PRESSURE));
		SUPPORTED_CHARACTERISTICS.add(UUID.fromString(SERVICE_RUNNING_SPEED_AND_CADENCE));
		SUPPORTED_CHARACTERISTICS.add(UUID.fromString(SERVICE_BATTERY));
	}
}
