#!/bin/bash

if [ -z "$BASH_VERSION" ]; then
	echo "Invalid shell, re-running using bash..."
	exec bash "$0" "$@"
	exit $?
fi
SRCLOC="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
source "$SRCLOC/../../../build/utils/functions.sh"

prepareUpstreamFromZipArchive "$SRCLOC" "https://www.sqlite.org/2021/sqlite-amalgamation-3370000.zip"
        echo a443aaf5cf345613492efa679ef1c9cc31ba109dcdf37ee377f61ab500d042fe "$SRCLOC/upstream.pack" | sha256sum --check -        || { echo 'Failed checksum' 1>&2; exit; }
patchUpstream "$SRCLOC"
