// IMPLEMENTED (X) or MISSING ( ) FEATURES, (N/A) if not needed in this language:
//
// (X) Basic navigation prompts: route (re)calculated (with distance and time support), turns, roundabouts, u-turns, straight/follow, arrival
// (X) Announce nearby point names (destination / intermediate / GPX waypoint / favorites / POI)
// (X) Attention prompts: SPEED_CAMERA; SPEED_LIMIT; BORDER_CONTROL; RAILWAY; TRAFFIC_CALMING; TOLL_BOOTH; STOP; PEDESTRIAN; MAXIMUM; TUNNEL
// (X) Other prompts: gps lost, off route, back to route
// (X) Street name and prepositions (onto / on / to) and street destination (toward) support
// (X) Distance unit support (meters / feet / yard)
// (X) Special grammar: special treating of 2, 22, 32, etc. numbers in female form (minutes, hours)
// (X) Special grammar: plural forms for minutes and hours word when numbers are in 2-4 range
// (X) Support announcing highway exits

var metricConst;
var dictionary = {};
var tts;

//// STRINGS
////////////////////////////////////////////////////////////////
function populateDictionary(tts) {
	// ROUTE CALCULATED
	dictionary["route_is"] = tts ? "Długość trasy to" : "route_is.ogg";
	dictionary["route_calculate"] = tts ? "Nowa trasa wyznaczona" : "route_calculate.ogg";
	dictionary["distance"] = tts ? "jej długość to" : "distance.ogg";
	
	// LEFT/RIGHT
	dictionary["after"] = tts ? "za" : "after.ogg";
	
	dictionary["left"] = tts ? "skręć w lewo" : "left.ogg";
	dictionary["left_sh"] = tts ? "skręć ostro w lewo" : "left_sh.ogg";
	dictionary["left_sl"] = tts ? "skręć lekko w lewo" : "left_sl.ogg";
	dictionary["right"] = tts ? "skręć w prawo" : "right.ogg";
	dictionary["right_sh"] = tts ? "skręć ostro w prawo" : "right_sh.ogg";
	dictionary["right_sl"] = tts ? "skręć lekko w prawo" : "right_sl.ogg";
	// Note: "left_keep"/"right_keep" is a turn type aiding lane selection, while "left_bear"/"right_bear" is as brief "then..." preparation for the turn-after-next. In some languages l/r_keep may not differ from l/r_bear.
	dictionary["left_keep"] = tts ? "zajmij lewy pas" : "left_keep.ogg";
	dictionary["right_keep"] = tts ? "zajmij prawy pas" : "right_keep.ogg";
	dictionary["left_bear"] = tts ? "trzymaj się lewej strony" : "left_bear.ogg";    // in English the same as left_keep, may be different in other languages
	dictionary["right_bear"] = tts ? "trzymaj się prawej strony" : "right_bear.ogg";  // in English the same as right_keep, may be different in other languages
	
	// U-TURNS
	dictionary["make_uturn"] = tts ? "Zawróć" : "make_uturn.ogg";
	dictionary["make_uturn_wp"] = tts ? "Jeśli to możliwe, zawróć" : "make_uturn_wp.ogg";
	
	// ROUNDABOUTS
	dictionary["prepare_roundabout"] = tts ? "Przygotuj się do wjazdu na rondo" : "prepare_roundabout.ogg";
	dictionary["roundabout"] = tts ? "wjedź na rondo" : "roundabout.ogg";
	dictionary["then"] = tts ? "następnie" : "then.ogg";
	dictionary["and"] = tts ? "i" : "and.ogg";
	dictionary["take"] = tts ? "wybierz" : "take.ogg";
	dictionary["exit"] = tts ? "zjazd" : "exit.ogg";
	
	dictionary["1st"] = tts ? "pierwszy" : "1st.ogg";
	dictionary["2nd"] = tts ? "drugi" : "2nd.ogg";
	dictionary["3rd"] = tts ? "trzeci" : "3rd.ogg";
	dictionary["4th"] = tts ? "czwarty" : "4th.ogg";
	dictionary["5th"] = tts ? "piąty" : "5th.ogg";
	dictionary["6th"] = tts ? "szósty" : "6th.ogg";
	dictionary["7th"] = tts ? "siódmy" : "7th.ogg";
	dictionary["8th"] = tts ? "ósmy" : "8th.ogg";
	dictionary["9th"] = tts ? "dziewiąty" : "9th.ogg";
	dictionary["10th"] = tts ? "dziesiąty" : "10th.ogg";
	dictionary["11th"] = tts ? "jedenasty" : "11th.ogg";
	dictionary["12th"] = tts ? "dwunasty" : "12th.ogg";
	dictionary["13th"] = tts ? "trzynasty" : "13th.ogg";
	dictionary["14th"] = tts ? "czternasty" : "14th.ogg";
	dictionary["15th"] = tts ? "piętnasty" : "15th.ogg";
	dictionary["16th"] = tts ? "szesnasty" : "16th.ogg";
	dictionary["17th"] = tts ? "siedemnasty" : "17th.ogg";
	
	// STRAIGHT/FOLLOW
	dictionary["go_ahead"] = tts ? "Prosto" : "go_ahead.ogg";
	dictionary["follow"] = tts ? "Prosto przez" : "follow.ogg";
	
	// ARRIVE
	dictionary["and_arrive_destination"] = tts ? "następnie dotrzesz do celu podróży" : "and_arrive_destination.ogg";
	dictionary["reached_destination"] = tts ? "jesteś u celu podróży" : "reached_destination.ogg";
	dictionary["and_arrive_intermediate"] = tts ? "następnie dotrzesz do punktu pośredniego" : "and_arrive_intermediate.ogg";
	dictionary["reached_intermediate"] = tts ? "jesteś przy punkcie pośrednim" : "reached_intermediate.ogg";
	
	// NEARBY POINTS
	dictionary["and_arrive_waypoint"] = tts ? "następnie miniesz punkt GPX" : "and_arrive_waypoint.ogg";
	dictionary["reached_waypoint"] = tts ? "mijasz punkt GPX" : "reached_waypoint.ogg";
	dictionary["and_arrive_favorite"] = tts ? "następnie miniesz ulubiony punkt" : "and_arrive_favorite.ogg";
	dictionary["reached_favorite"] = tts ? "mijasz ulubiony punkt" : "reached_favorite.ogg";
	dictionary["and_arrive_poi"] = tts ? "następnie miniesz użyteczne miejsce" : "and_arrive_poi.ogg";
	dictionary["reached_poi"] = tts ? "mijasz użyteczne miejsce" : "reached_poi.ogg";
	
	// ATTENTION
	//dictionary["exceed_limit"] = tts ? "przekraczasz dozwoloną prędkość" : "exceed_limit.ogg";
	dictionary["exceed_limit"] = tts ? "ograniczenie prędkości do" : "exceed_limit.ogg";
	dictionary["attention"] = tts ? "uwaga" : "attention.ogg";
	dictionary["speed_camera"] = tts ? "fotoradar" : "speed_camera.ogg";
	dictionary["border_control"] = tts ? "kontrola graniczna" : "border_control.ogg";
	dictionary["railroad_crossing"] = tts ? "przejazd kolejowy" : "railroad_crossing.ogg";
	dictionary["traffic_calming"] = tts ? "próg zwalniający" : "traffic_calming.ogg";
	dictionary["toll_booth"] = tts ? "punkt pobierania opłat" : "toll_booth.ogg";
	dictionary["stop"] = tts ? "znak stop" : "stop.ogg";
	dictionary["pedestrian_crosswalk"] = tts ? "przejście dla pieszych" : "pedestrian_crosswalk.ogg";
	dictionary["tunnel"] = tts ? "tunel" : "tunnel.ogg";
	
	// OTHER PROMPTS
	dictionary["location_lost"] = tts ? "Utracono sygnał GPS" : "location_lost.ogg";
	dictionary["location_recovered"] = tts ? "Odzyskano sygnał GPS" : "location_recovered.ogg";
	dictionary["off_route"] = tts ? "znajdowałeś się poza trasą przez" : "off_route.ogg";
	dictionary["back_on_route"] = tts ? "wróciłeś na trasę" : "back_on_route.ogg";
	
	// STREET NAME PREPOSITIONS
	dictionary["onto"] = tts ? "w" : "onto.ogg";
	dictionary["on"] = tts ? "na" : "on.ogg";
	dictionary["to"] = tts ? "do" : "to.ogg";
	dictionary["toward"] = tts ? "w kierunku" : "toward.ogg";
	
	// DISTANCE UNIT SUPPORT
	// Some TTS engines get declinations right if abbreviated distance and time units are used.
	dictionary["meters"] = tts ? "metrów" : "meters.ogg";
	dictionary["around_1_kilometer"] = tts ? "około jeden kilometr" : "around_1_kilometer.ogg";
	dictionary["around"] = tts ? "około" : "around.ogg";
	dictionary["kilometers"] = tts ? "kilometrów" : "kilometers.ogg";
	dictionary["kilometers_2-4"] = tts ? "kilometry" : "kilometers.ogg";

	dictionary["feet"] = tts ? "stóp" : "feet.ogg";
	dictionary["tenths_of_a_mile"] = tts ? "dziesiątych mili" : "tenths_of_a_mile.ogg";
	dictionary["around_1_mile"] = tts ? "około jedną milę" : "around_1_mile.ogg";
	dictionary["miles"] = tts ? "mil" : "miles.ogg";
	
	dictionary["yards"] = tts ? "jardów" : "yards.ogg";
	
	// TIME SUPPORT
	dictionary["time"] = tts ? ", przewidywany czas to" : "time.ogg";
	dictionary["1_hour"] = tts ? "jedna godzina" : "1_hour.ogg";
	dictionary["hours_2-4"] = tts ? "godziny" : "hours.ogg";
	dictionary["hours"] = tts ? "godzin" : "hours.ogg";

	dictionary["less_a_minute"] = tts ? "mniej niż minuta" : "less_a_minute.ogg";
	dictionary["1_minute"] = tts ? "jedna minuta" : "1_minute.ogg";
	dictionary["minutes_2-4"] = tts ? "minuty" : "minutes.ogg";
	dictionary["minutes"] = tts ? "minut" : "minutes.ogg";

	dictionary["2_f"] = tts ? "dwie" : "2.ogg";
}


//// COMMAND BUILDING / WORD ORDER
////////////////////////////////////////////////////////////////
/**
*	special treating of 2, 22, 32, etc. numbers in female form
*/
function num_fe_str(number) {
	var ones = number % 10;
	if (ones !== 2) {
		return number.toString();
	}
	var tens = number % 100 - ones;
	if (tens == 10) {
		return number.toString();
	}
	var numberWithoutOnes = Math.floor(number / 10) * 10;

	var onesPhrase = dictionary[ones.toString() + "_f"] || ones.toString();
	return (numberWithoutOnes ? numberWithoutOnes.toString() + " " : "") + onesPhrase;
}

function plural_str_form(value, pluralTimeForm, pluralTimeFormBetweenTwoAndFour) {
	var ones = value % 10;
	var tens = value % 100 - ones;
	if (tens == 10) {
		return pluralTimeForm;
	}
	if (ones > 1 && ones < 5) {
		return pluralTimeFormBetweenTwoAndFour;
	}
	return pluralTimeForm;
}

function hours_str(hours) {
	return plural_str_form(hours, dictionary["hours"], dictionary["hours_2-4"])
}

function minutes_str(minutes) {
	return plural_str_form(minutes, dictionary["minutes"], dictionary["minutes_2-4"])
}

function kilometers_str(kilometers) {
	return plural_str_form(kilometers, dictionary["kilometers"], dictionary["kilometers_2-4"])
}

function setMetricConst(metrics) {
	metricConst = metrics;
}

function setMode(mode) {
	tts = mode;
	populateDictionary(mode);
}

function route_new_calc(dist, timeVal) {
	return dictionary["route_is"] + " " + distance(dist) + " " + dictionary["time"] + " " + time(timeVal) + (tts ? ". " : " ");
}

function distance(dist) {
	switch (metricConst) {
		case "km-m":
			if (dist < 17 ) {
				return (tts ? Math.round(dist).toString() : ogg_dist(Math.round(dist))) + " " + dictionary["meters"];
			} else if (dist < 100) {
				return (tts ? (Math.round(dist/10.0)*10).toString() : ogg_dist(Math.round(dist/10.0)*10)) + " " + dictionary["meters"];
			} else if (dist < 1000) {
				return (tts ? (Math.round(2*dist/100.0)*50).toString() : ogg_dist(Math.round(2*dist/100.0)*50)) + " " + dictionary["meters"];
			} else if (dist < 1500) {
				return dictionary["around_1_kilometer"];
			} else if (dist < 10000) {
				var distInKm = Math.round(dist / 1000.0);
				return dictionary["around"] + " : " + (tts ? distInKm.toString() : ogg_dist(distInKm)) + " " + kilometers_str(distInKm);
			} else {
				var distInKm = Math.round(dist / 1000.0);
				return (tts ? distInKm.toString() : ogg_dist(distInKm)) + " " + kilometers_str(distInKm);
			}
			break;
		case "mi-f":
			if (dist < 91) {
				return (tts ? (Math.round(2*dist/100.0/0.3048)*50).toString() : ogg_dist(Math.round(2*dist/100.0/0.3048)*50)) + " " + dictionary["feet"];
			} else if (dist < 320) {
				return (tts ? (Math.round(dist/100.0/0.3048)*100).toString() : ogg_dist(Math.round(dist/100.0/0.3048)*100)) + " " + dictionary["feet"];
			} else if (dist < 1367) {
				return (tts ? Math.round(dist/161.0).toString() : ogg_dist(Math.round(dist/161.0))) + " " + dictionary["tenths_of_a_mile"];
			} else if (dist < 2414) {
				return dictionary["around_1_mile"];
			} else if (dist < 16093) {
				return dictionary["around"] + " " + (tts ? Math.round(dist/1609.3).toString() : ogg_dist(Math.round(dist/1609.3))) + " " + dictionary["miles"];
			} else {
				return (tts ? Math.round(dist/1609.3).toString() : ogg_dist(Math.round(dist/1609.3))) + " " + dictionary["miles"];
			}
			break;
		case "mi-m":
			if (dist < 17) {
				return (tts ? Math.round(dist).toString() : ogg_dist(Math.round(dist))) + " " + dictionary["meters"];
			} else if (dist < 100) {
				return (tts ? (Math.round(dist/10.0)*10).toString() : ogg_dist(Math.round(dist/10.0)*10)) + " " + dictionary["meters"];
			} else if (dist < 1300) {
				return (tts ? (Math.round(2*dist/100.0)*50).toString() : ogg_dist(Math.round(2*dist/100.0)*50)) + " " + dictionary["meters"];
			} else if (dist < 2414) {
				return dictionary["around_1_mile"];
			} else if (dist < 16093) {
				return dictionary["around"] + " " + (tts ? Math.round(dist/1609.3).toString() : ogg_dist(Math.round(dist/1609.3))) + " " + dictionary["miles"];
			} else {
				return (tts ? Math.round(dist/1609.3).toString() : ogg_dist(Math.round(dist/1609.3))) + " " + dictionary["miles"];
			}
			break;
		case "mi-y":
			if (dist < 17) {
				return (tts ? Math.round(dist/0.9144).toString() : ogg_dist(Math.round(dist/0.9144))) + " " + dictionary["yards"];
			} else if (dist < 100) {
				return (tts ? (Math.round(dist/10.0/0.9144)*10).toString() : ogg_dist(Math.round(dist/10.0/0.9144)*10)) + " " + dictionary["yards"];
			} else if (dist < 1300) {
				return (tts ? (Math.round(2*dist/100.0/0.9144)*50).toString() : ogg_dist(Math.round(2*dist/100.0/0.9144)*50)) + " " + dictionary["yards"];
			} else if (dist < 2414) {
				return dictionary["around_1_mile"];
			} else if (dist < 16093) {
				return dictionary["around"] + " " + (tts ? Math.round(dist/1609.3).toString() : ogg_dist(Math.round(dist/1609.3))) + " " + dictionary["miles"];
			} else {
				return (tts ? Math.round(dist/1609.3).toString() : ogg_dist(Math.round(dist/1609.3))) + " " + dictionary["miles"];
			}
			break;
	}
}

function time(seconds) {
	var minutes = Math.round(seconds/60.0);
	var oggMinutes = Math.round(((seconds/300.0) * 5));
	if (seconds < 30) {
		return dictionary["less_a_minute"];
	} else if (minutes % 60 == 0 && tts) {
		return hours(minutes);
	} else if (minutes % 60 == 1 && tts) {
		return hours(minutes) + " " + dictionary["1_minute"];
	} else if (tts) {
		return hours(minutes) + ", " + num_fe_str(minutes % 60) + " " + minutes_str(minutes % 60);
	} else if (!tts && seconds < 300) {
		return ogg_dist(minutes) + dictionary["minutes"];
	} else if (!tts && oggMinutes % 60 > 0) {
		return hours(oggMinutes) + " " + ogg_dist(oggMinutes % 60) + minutes_str(minutes % 60);
	} else if (!tts) {
		return hours(oggMinutes);
	}
}

function hours(minutes) {
	if (minutes < 60) {
		return "";
	} else if (minutes < 120) {
		return dictionary["1_hour"];
	} else {
		var hours = Math.floor(minutes / 60);
		return (tts ? num_fe_str(hours, "f") : ogg_dist(hours)) + " " + hours_str(hours);
	}
}

function route_recalc(dist, seconds) {
	return dictionary["route_calculate"] + (tts ? ", " : " ") + distance(dist) + " " + dictionary["time"] + " " + time(seconds) + (tts ? ". " : " ");
}

function go_ahead(dist, streetName) {
	if (dist == -1) {
		return dictionary["go_ahead"];
	} else {
		return dictionary["follow"] + " " + distance(dist) + " " + follow_street(streetName);
	}
}

function follow_street(streetName) {
	if ((streetName["toDest"] == "" && streetName["toStreetName"] == "" && streetName["toRef"] == "") || Object.keys(streetName).length == 0 || !tts) {
		return "";
	} else if (streetName["toStreetName"] == "" && streetName["toRef"] == "") {
		return dictionary["to"] + " " + toDest(streetName);
	} else if (streetName["toRef"] == streetName["fromRef"] && streetName["toStreetName"] == streetName["fromStreetName"] || 
			(streetName["toRef"] == streetName["fromRef"] && streetName["toStreetName"] == "")) {
		return dictionary["on"] + " " + assemble_street_name(streetName);
	} else if (!(streetName["toRef"] == streetName["fromRef"] && streetName["toStreetName"] == streetName["fromStreetName"])) {
		return dictionary["to"] + " " + assemble_street_name(streetName);
	}
}

function turn(turnType, dist, streetName) {
	if (dist == -1) {
		return getTurnType(turnType) + " " + turn_street(streetName);
	} else {
		return dictionary["after"] + " " + distance(dist) + " " + getTurnType(turnType) + " " + turn_street(streetName); 
	}
}

function take_exit(turnType, dist, exitString, exitInt, streetName) {
	if (dist == -1) {
		return getTurnType(turnType) + " " + dictionary["onto"] + " : " + getExitNumber(exitString, exitInt) + " " + take_exit_name(streetName);
	} else {
		return dictionary["after"] + " " + distance(dist) + " "
			+ getTurnType(turnType) + " " + dictionary["onto"] + " : " + getExitNumber(exitString, exitInt) + " " + take_exit_name(streetName);
	}
}

function take_exit_name(streetName) {
	if (Object.keys(streetName).length == 0 || (streetName["toDest"] == "" && streetName["toStreetName"] == "") || !tts) {
		return "";
	} else if (streetName["toDest"] != "") {
		return (tts ? ", " : " ") + streetName["toStreetName"] + " " + dictionary["toward"] + " " + toDest(streetName);
	} else if (streetName["toStreetName"] != "") {
		return (tts ? ", " : " ") + streetName["toStreetName"];
	} else {
		return "";
	}
}

function getExitNumber(exitString, exitInt) {
	if (!tts && exitInt > 0 && exitInt < 18) {
		return nth(exitInt) + " " + dictionary["exit"];
	// Issue #7570: Next case for correct tts number declination for numerical exits 1-17 
	} else if (tts && exitInt > 0 && exitInt < 18 && exitInt.toString() == exitString) {
		return nth(exitInt) + " " + dictionary["exit"];
	} else if (tts) {
		return dictionary["exit"] + " " + exitString;
	} else {
		return dictionary["exit"];
	}
}

function getTurnType(turnType) {
	switch (turnType) {
		case "left":
			return dictionary["left"];
			break;
		case "left_sh":
			return dictionary["left_sh"];
			break;
		case "left_sl":
			return dictionary["left_sl"];
			break;
		case "right":
			return dictionary["right"];
			break;
		case "right_sh":
			return dictionary["right_sh"];
			break;
		case "right_sl":
			return dictionary["right_sl"];
			break;
		case "left_keep":
			return dictionary["left_keep"];
			break;
		case "right_keep":
			return dictionary["right_keep"];
			break;
	}
}

function then() {
	return (tts ? ", " : " ") + dictionary["then"] + " ";
}

function roundabout(dist, angle, exit, streetName) {
	if (dist == -1) {
		return dictionary["take"] + " " + nth(exit) + " " + dictionary["exit"] + " " + turn_street(streetName);
	} else {
		return dictionary["after"] + " " + distance(dist) + " " + dictionary["roundabout"] + (tts ? ", " : " ") + dictionary["and"] + " " + dictionary["take"] + " " + nth(exit) + " " + dictionary["exit"] + " " + turn_street(streetName);
	}

}

function turn_street(streetName) {
	if ((streetName["toDest"] == "" && streetName["toStreetName"] == "" && streetName["toRef"] == "") || Object.keys(streetName).length == 0 || !tts) {
		return "";
	} else if (streetName["toStreetName"] == "" && streetName["toRef"] == "") {
		return dictionary["toward"] + " " + toDest(streetName);
	} else if (streetName["toRef"] == streetName["fromRef"] && streetName["toStreetName"] == streetName["fromStreetName"]) {
		return dictionary["on"] + " " + assemble_street_name(streetName);
	} else if ((streetName["toRef"] == streetName["fromRef"] && streetName["toStreetName"] == streetName["fromStreetName"]) 
		|| (streetName["toStreetName"] == "" && streetName["toRef"] == streetName["fromRef"])) {
		return dictionary["on"] + " " + assemble_street_name(streetName);
	} else if (!(streetName["toRef"] == streetName["fromRef"] && streetName["toStreetName"] == streetName["fromStreetName"])) {
		return dictionary["onto"] + ": " + assemble_street_name(streetName);
	}
	return "";
}

function assemble_street_name(streetName) {
	if (streetName["toDest"] == "") {
		return toRef(streetName) + " " + streetName["toStreetName"];
	} else if (streetName["toRef"] == "") {
		return streetName["toStreetName"] + ": " + dictionary["toward"] + " " + streetName["toDest"].replace(/\b\d+\b/g, function(match) { return "'" + match + "'";});
	} else if (streetName["toRef"] != "") {
		return toRef(streetName) + " " + dictionary["toward"] + " " + toDest(streetName);
	}
}

function nth(exit) {
	switch (exit) {
		case (1):
			return dictionary["1st"];
		case (2):
			return dictionary["2nd"];
		case (3):
			return dictionary["3rd"];
		case (4):
			return dictionary["4th"];
		case (5):
			return dictionary["5th"];
		case (6):
			return dictionary["6th"];
		case (7):
			return dictionary["7th"];
		case (8):
			return dictionary["8th"];
		case (9):
			return dictionary["9th"];
		case (10):
			return dictionary["10th"];
		case (11):
			return dictionary["11th"];
		case (12):
			return dictionary["12th"];
		case (13):
			return dictionary["13th"];
		case (14):
			return dictionary["14th"];
		case (15):
			return dictionary["15th"];
		case (16):
			return dictionary["16th"];
		case (17):
			return dictionary["17th"];
	}
}

function make_ut(dist, streetName) {
	if (dist == -1) {
		return dictionary["make_uturn"] + " " + turn_street(streetName);
	} else {
		return dictionary["after"] + " " + distance(dist) + " " + dictionary["make_uturn"] + " " + turn_street(streetName);
	}
}

function bear_left(streetName) {
	return dictionary["left_bear"];
}

function bear_right(streetName) {
	return dictionary["right_bear"];
}

function prepare_make_ut(dist, streetName) {
	return dictionary["after"] + " " + distance(dist) + " " + dictionary["make_uturn"] + " " + turn_street(streetName);
}

function prepare_turn(turnType, dist, streetName) {
	return dictionary["after"] + " " + distance(dist) + " " + getTurnType(turnType) + " " + turn_street(streetName);
}

function prepare_roundabout(dist, exit, streetName) {
	return dictionary["after"] + " " + distance(dist) + " " + dictionary["prepare_roundabout"]; 
}

function and_arrive_destination(dest) {
	return (tts ? ", " : " ") + dictionary["and_arrive_destination"] + " " + dest;
}

function and_arrive_intermediate(dest) {
	return (tts ? ", " : " ") + dictionary["and_arrive_intermediate"] + " " + dest;
}

function and_arrive_waypoint(dest) {
	return (tts ? ", " : " ") + dictionary["and_arrive_waypoint"] + " " + dest;
}

function and_arrive_favorite(dest) {
	return (tts ? ", " : " ") + dictionary["and_arrive_favorite"] + " " + dest;
}

function and_arrive_poi(dest) {
	return (tts ? ", " : " ") + dictionary["and_arrive_poi"] + " " + dest;
}

function reached_destination(dest) {
	return dictionary["reached_destination"] + " " + dest;
}

function reached_waypoint(dest) {
	return dictionary["reached_waypoint"] + " " + dest;
}

function reached_intermediate(dest) {
	return dictionary["reached_intermediate"] + " " + dest;
}

function reached_favorite(dest) {
	return dictionary["reached_favorite"] + " " + dest;
}

function reached_poi(dest) {
	return dictionary["reached_poi"] + " " + dest;
}

function location_lost() {
	return dictionary["location_lost"];
}

function location_recovered() {
	return dictionary["location_recovered"];
}

function off_route(dist) {
	return dictionary["off_route"] + " " + distance(dist);
}

function back_on_route() {
	return dictionary["back_on_route"];
}

function make_ut_wp() {
	return dictionary["make_uturn_wp"];
}

// TRAFFIC WARNINGS
function speed_alarm(maxSpeed, speed) {
	return dictionary["exceed_limit"] + " " + maxSpeed.toString();
}

function attention(type) {
	return dictionary["attention"] + (tts ? ", " : " ") + getAttentionString(type);
}

function getAttentionString(type) {
	switch (type) {
		case "SPEED_CAMERA":
			return dictionary["speed_camera"];
			break;
		case "SPEED_LIMIT":
			return "";
			break
		case "BORDER_CONTROL":
			return dictionary["border_control"];
			break;
		case "RAILWAY":
			return dictionary["railroad_crossing"];
			break;
		case "TRAFFIC_CALMING":
			return dictionary["traffic_calming"];
			break;
		case "TOLL_BOOTH":
			return dictionary["toll_booth"];
			break;
		case "STOP":
			return dictionary["stop"];
			break;
		case "PEDESTRIAN":
			return dictionary["pedestrian_crosswalk"];
			break;
		case "MAXIMUM":
			return "";
			break;
		case "TUNNEL":
			return dictionary["tunnel"];
			break;
		default:
			return "";
			break;
	}
}

function ogg_dist(distance) {
	if (distance == 0) {
		return "";
	} else if (distance < 20) {
		return Math.floor(distance).toString() + ".ogg ";
	} else if (distance < 1000 && (distance % 50) == 0) {
		return distance.toString() + ".ogg ";
	} else if (distance < 30) {
		return "20.ogg " + ogg_dist(distance - 20);
	} else if (distance < 40) {
		return "30.ogg " + ogg_dist(distance - 30);
	} else if (distance < 50) {
		return "40.ogg " + ogg_dist(distance - 40);
	} else if (distance < 60) {
		return "50.ogg " + ogg_dist(distance - 50);
	} else if (distance < 70) {
		return "60.ogg " + ogg_dist(distance - 60);
	} else if (distance < 80) {
		return "70.ogg " + ogg_dist(distance - 70);
	} else if (distance < 90) {
		return "80.ogg " + ogg_dist(distance - 80);
	} else if (distance < 100) {
		return "90.ogg " + ogg_dist(distance - 90);
	} else if (distance < 200) {
		return "100.ogg " + ogg_dist(distance - 100);
	} else if (distance < 300) {
		return "200.ogg " + ogg_dist(distance - 200);
	} else if (distance < 400) {
		return "300.ogg " + ogg_dist(distance - 300);
	} else if (distance < 500) {
		return "400.ogg " + ogg_dist(distance - 400);
	} else if (distance < 600) {
		return "500.ogg " + ogg_dist(distance - 500);
	} else if (distance < 700) {
		return "600.ogg " + ogg_dist(distance - 600);
	} else if (distance < 800) {
		return "700.ogg " + ogg_dist(distance - 700);
	} else if (distance < 900) {
		return "800.ogg " + ogg_dist(distance - 800);
	} else if (distance < 1000) {
		return "900.ogg " + ogg_dist(distance - 900);
	} else {
		return ogg_dist(distance/1000) + "1000.ogg " + ogg_dist(distance % 1000);
	}
}

var numberRegex = /\b\d+\b/g

function toRef(streetName) {
	return numbersAsText(streetName["toRef"]);
}

function toDest(streetName) {
	return numbersAsText(streetName["toDest"]);
}

function numbersAsText(destName) {
	return destName.replace(numberRegex, function(match) { return numberToWords(match);});
}

var ones = [
	"", "jeden", "dwa", "trzy", "cztery", "pięć", "sześć", "siedem", "osiem", "dziewięć",
	"dziesięć", "jedenaście", "dwanaście", "trzynaście", "czternaście", "piętnaście", 
	"szesnaście", "siedemnaście", "osiemnaście", "dziewiętnaście"
];

var tens = [
	"", "", "dwadzieścia", "trzydzieści", "czterdzieści", "pięćdziesiąt", 
	"sześćdziesiąt", "siedemdziesiąt", "osiemdziesiąt", "dziewięćdziesiąt"
];

var hundreds = [
	"", "sto", "dwieście", "trzysta", "czterysta", "pięćset", 
	"sześćset", "siedemset", "osiemset", "dziewięćset"
];

function numberToWords(input) {
	var num = parseInt(input, 10);

	if (isNaN(num)) {
			return input;
	}

	if (num < 1 || num > 999) {
			return input;
	}

	var result = "";

	// Handle hundreds
	if (Math.floor(num / 100) > 0) {
			result += hundreds[Math.floor(num / 100)] + " ";
	}

	// Handle tens and ones
	var remainder = num % 100;
	if (remainder < 20) {
			result += ones[remainder];
	} else {
			result += tens[Math.floor(remainder / 10)] + " ";
			if (remainder % 10 !== 0) {
					result += ones[remainder % 10];
			}
	}

	return result.trim();
}
