#!/bin/bash
STYLE_ICONS_FOLDER=../../rendering_styles/style-icons
MAP_SHADERS_SVG="$STYLE_ICONS_FOLDER/map-shaders-svg/"

mkdir -p "$MAP_SHADERS_SVG"

#COPY_CMD=rsync
#CF=-a
COPY_CMD=cp
icon_alias() {
	if [[ -f "../svg-res/${2}.svg" ]]; then
		$COPY_CMD $CF "../svg-res/${2}.svg" "${STYLE_ICONS_FOLDER}/map-icons-svg/mx_${1}.svg"
	else
		$COPY_CMD $CF "../svg-res/c_${2}.svg" "${STYLE_ICONS_FOLDER}/map-icons-svg/c_mx_${1}.svg"
	fi
	$COPY_CMD $CF ../svg-web-res/${2}.svg $STYLE_ICONS_FOLDER/poi-icons-svg/mx_${1}.svg
	# $1 icon target name in app
	# $2 generated icon name from svg
 	# echo "${2}.png   style-icons/mm_${1}.png"
 	$COPY_CMD $CF ../png/mdpi/${2}.png $STYLE_ICONS_FOLDER/map-icons-png/drawable-mdpi/mm_${1}.png
	$COPY_CMD $CF ../png/hdpi/${2}.png $STYLE_ICONS_FOLDER/map-icons-png/drawable-hdpi/mm_${1}.png
 	$COPY_CMD $CF ../png/xhdpi/${2}.png $STYLE_ICONS_FOLDER/map-icons-png/drawable-xhdpi/mm_${1}.png
 	$COPY_CMD $CF ../png/xxhdpi/${2}.png $STYLE_ICONS_FOLDER/map-icons-png/drawable-xxhdpi/mm_${1}.png
	$COPY_CMD $CF ../png/xxhdpi/${2}.png $STYLE_ICONS_FOLDER/map-icons-png/drawable-xxhdpi/mm_${1}.png
	$COPY_CMD $CF ../vd/map/${2}.xml $STYLE_ICONS_FOLDER/map-icons-vector/mm_${1}.xml
	if [ -z "$3" ] && [ -f ../vd/poi/${2}.xml ] ; then
		$COPY_CMD $CF ../vd/poi/${2}.xml $STYLE_ICONS_FOLDER/poi-icons-vector/mx_${1}.xml
 		$COPY_CMD $CF ../png/big-mdpi/${2}.png $STYLE_ICONS_FOLDER/poi-icons-png/drawable-mdpi/mx_${1}.png
 		$COPY_CMD $CF ../png/big-hdpi/${2}.png $STYLE_ICONS_FOLDER/poi-icons-png/drawable-hdpi/mx_${1}.png
 		$COPY_CMD $CF ../png/big-xhdpi/${2}.png $STYLE_ICONS_FOLDER/poi-icons-png/drawable-xhdpi/mx_${1}.png
 		$COPY_CMD $CF ../png/big-xxhdpi/${2}.png $STYLE_ICONS_FOLDER/poi-icons-png/drawable-xxhdpi/mx_${1}.png
	fi
}

icon_alias_no_mx() {
	icon_alias ${1} ${2} --no-mx
}

icon() {
	icon_alias ${1} ${1}
}

### UNCOMMENT TO COPY ONLY COUPLE OF ICONS
# icon_alias transportation transport_taxi_rank
# icon_alias road_obstacle transport_speedbump
# icon_alias personal_transport shopping_car
# exit 0;

## Shaders ! # copy all shaders untouched
$COPY_CMD $CF ../svg-res/h_*.svg $MAP_SHADERS_SVG
$COPY_CMD $CF ../svg-res/c_h_*.svg $MAP_SHADERS_SVG
$COPY_CMD $CF ../vd/map/h_*.xml $STYLE_ICONS_FOLDER/map-shaders-vector/
$COPY_CMD $CF ../png/mdpi/h_* $STYLE_ICONS_FOLDER/map-shaders-png/drawable-mdpi/
$COPY_CMD $CF ../png/hdpi/h_* $STYLE_ICONS_FOLDER/map-shaders-png/drawable-hdpi/
$COPY_CMD $CF ../png/xhdpi/h_* $STYLE_ICONS_FOLDER/map-shaders-png/drawable-xhdpi/
$COPY_CMD $CF ../png/xxhdpi/h_* $STYLE_ICONS_FOLDER/map-shaders-png/drawable-xxhdpi/

icon_alias grass landuse_grass
icon_alias forest landuse_colored_forest               # Keep shaders with background color, cannot be replaced by icons!
icon_alias wood landuse_colored_forest
icon_alias beach tourist_beach2                     # Keep shaders with background color, cannot be replaced by icons!
#icon_alias natural_scrub landuse_scrub                     # Keep shaders with background color, cannot be replaced by icons!
#icon_alias natural_swamp landuse_swamp                     # Keep shaders with background color, cannot be replaced by icons!
icon_alias zoo tourist_zoo                         # Keep shaders with background color, cannot be replaced by icons!
icon_alias military_danger_area poi_colored_danger_area
icon_alias military_nuclear_explosion_site poi_colored_nuclear_explosion_site
icon_alias glacier poi_colored_peak2                       # Keep shaders with background color, cannot be replaced by icons!
icon_alias landfill landuse_colored_landfill
icon_alias wetland landuse_wetland
icon_alias cemetery landuse_cemetery
icon_alias grave_yard landuse_cemetery
icon_alias military_landuse landuse_military
icon_alias industrial landuse_industrial
icon_alias construction landuse_construction
icon_alias garages landuse_garages
icon_alias quarry landuse_quarry
icon_alias allotments landuse_allotments
icon_alias place_allotments poi_colored_hamlet
icon_alias village_green landuse_village_green
icon_alias recreation_ground landuse_recreation_ground
icon_alias residential landuse_residential
icon_alias commercial landuse_commercial
icon_alias retail landuse_retail
icon_alias religious landuse_religious
icon_alias orchard landuse_orchard
icon_alias vineyard landuse_vineyard
icon_alias garden landuse_colored_garden
icon_alias farmland landuse_farmland
icon_alias nature_reserve landuse_nature_reserve
icon_alias logging landuse_logging
icon_alias sand landuse_sand
icon_alias meadow landuse_meadow
icon_alias salt_pond landuse_salt_pond
icon_alias farmyard landuse_farmyard
icon_alias landuse_railway landuse_railway
icon_alias scrub landuse_scrub2
icon_alias heath landuse_heath
icon_alias grassland landuse_grassland
icon_alias greenfield landuse_greenfield
icon_alias brownfield landuse_brownfield
icon_alias protected_area landuse_protected_area
icon_alias plant_nursery landuse_plant_nursery
icon_alias greenhouse_horticulture landuse_greenhouse_horticulture
icon_alias aquaculture landuse_aquaculture
icon_alias dune landuse_colored_dune
icon_alias plateau poi_plateau
icon_alias arch poi_colored_arch

icon_alias_no_mx stroke_black functional-icons_black_stroke
icon_alias_no_mx stroke_darkgreen functional-icons_darkgreen_stroke
icon_alias_no_mx stroke_gray functional-icons_gray_stroke
icon_alias_no_mx stroke_gray_triangle functional-icons_gray_stroke_triangle
icon_alias_no_mx stroke_lightorange_left functional-icons_lightorange_left_stroke
icon_alias_no_mx stroke_white functional-icons_white_stroke
icon_alias_no_mx stroke_brown_right functional-icons_brown_right_stroke
icon_alias_no_mx stroke_brown_left functional-icons_brown_left_stroke
icon_alias_no_mx stroke_dark_brown_left functional-icons_dark_brown_left_stroke
icon_alias_no_mx stroke_light_brown_left functional-icons_light_brown_left_stroke
icon_alias_no_mx stroke_white_left functional-icons_white_left_stroke
icon_alias_no_mx stroke_yellow_left functional-icons_yellow_left_stroke
icon_alias_no_mx stroke_green_left functional-icons_green_left_stroke
icon_alias_no_mx stroke_red_left functional-icons_red_left_stroke

## Natural
icon_alias natural poi_colored_peak2
icon_alias natural_cave_entrance poi_cave
icon_alias topo_cave topo_topo_cave
icon_alias natural_geyser water_geyser  #scale 0.375
icon_alias natural_hot_spring water_hot_spring  #scale 0.375
icon_alias natural_peak_big poi_colored_peak_big
icon_alias natural_peak_cross poi_colored_peak_cross
icon_alias natural_peak_cross_big poi_colored_peak_cross_big
icon_alias natural_peak poi_colored_peak
icon_alias natural_peak_night_big functional-icons_peak_night_big  #For night orienteering use orange similar to contour lines (=day version with color #CC6600)  #scale 0.5
icon_alias natural_peak_night functional-icons_peak_night  #For night orienteering use orange similar to contour lines (=day version with color #CC6600)  #scale 0.5
icon_alias natural_saddle poi_colored_saddle
icon_alias natural_sinkhole poi_colored_sinkhole
icon_alias natural_spring water_spring  #scale 0.375
icon_alias topo_spring topo_water_spring  #scale 0.375
icon_alias natural_stone poi_colored_stone  #scale 0.375
icon_alias natural_blowhole water_blowhole
icon_alias natural_tree_broadleaved functional-icons_tree_broadleaved
icon_alias topo_tree_broadleaved functional-icons-x2_topo_tree_broadleaved
icon_alias natural_tree_cypress functional-icons_tree_cypress
icon_alias natural_tree functional-icons_tree  #scale 0.25
icon_alias natural_tree_leafless functional-icons_tree_leafless
icon_alias natural_tree_needleleaved functional-icons_tree_needleleaved
icon_alias topo_tree_needleleaved functional-icons-x2_topo_tree_needleleaved
icon_alias natural_tree_palm functional-icons_tree_palm
icon_alias topo_tree_palm functional-icons-x2_topo_tree_palm
icon_alias tree_dot functional-icons_tree
icon_alias shrub_dot functional-icons_shrub
icon_alias tree poi_colored_tree
icon_alias shrub poi_colored_shrub
icon_alias natural_volcano_active_big functional-icons_volcano_active_big
icon_alias natural_volcano_active functional-icons_volcano_active
icon_alias natural_volcano_big functional-icons_volcano_big
icon_alias natural_volcano_map functional-icons_volcano  #Is poi_colored_peak with color #D40000  #scale 0.5
icon_alias volcano poi_colored_volcano_active
icon_alias waterway_rapids barrier_colored_rapids  #scale 0.375
icon_alias rapid_white barrier_rapid  #scale 0.375
icon_alias waterfall water_waterfall  #scale 0.375
icon_alias topo_waterfall topo_water_waterfall  #scale 0.375
icon_alias dam water_dam
icon_alias weir water_weir
icon_alias stream water_stream
icon_alias river water_river
icon_alias water water_water
icon_alias canal water_canal
icon_alias crater poi_colored_crater
icon_alias cape poi_colored_cape
icon_alias bay poi_colored_bay
icon_alias reef water_reef
icon_alias reservoir water_reservoir
icon_alias basin water_reservoir
icon_alias ridge poi_colored_ridge
icon_alias strait poi_colored_strait
icon_alias fjord poi_colored_fjord
icon_alias cliff poi_colored_cliff
icon_alias hill poi_colored_hill
icon_alias hill_night functional-icons_hill_night
icon_alias fumarole poi_colored_fumarole
icon_alias topo_fumarole topo_fumarole
icon_alias birds_nest poi_colored_birds_nest
icon_alias topo_birds_nest topo_birds_nest
icon_alias termite_mound poi_termite_mound
icon_alias topo_termite_mound topo_termite_mound
icon_alias anthill poi_anthill
icon_alias topo_anthill topo_anthill

## Location dots
icon_alias administrative poi_colored_boundary_administrative
icon_alias place_city_dot_night functional-icons_city_night  #scale 0.375
icon_alias place_city_dot_small functional-icons_city_small  #scale 0.375
icon_alias place_city_dot_small_night functional-icons_city_small_night  #scale 0.375
icon_alias place_city_dot functional-icons_city  #scale 0.375
icon_alias place_capital_dot_night functional-icons_capital_night  #scale 0.375
icon_alias place_capital_dot_small_night functional-icons_capital_small_night  #scale 0.375
icon_alias place_capital_dot functional-icons_capital  #scale 0.375
icon_alias place_capital_dot_small functional-icons_capital_small  #scale 0.375
icon_alias place_town_dot_night functional-icons_town_night  #scale 0.25
icon_alias place_town_dot functional-icons_town  #scale .25
icon_alias place_city poi_colored_city  #scale 0.375
icon_alias place_town poi_colored_town
icon_alias hamlet poi_colored_hamlet
icon_alias village poi_colored_village
icon_alias locality poi_colored_place_locality
icon_alias suburb poi_colored_suburb
icon_alias neighbourhood poi_colored_suburb
icon_alias isolated_dwelling poi_colored_isolated_dwelling
icon_alias neighborhood poi_colored_place_neighborhood
icon_alias island poi_colored_island
icon_alias country poi_colored_country
icon_alias quarter poi_colored_quarter
icon_alias place_farm poi_colored_place_farm
icon_alias islet poi_colored_islet

## Barrier dots
icon_alias barrier_small_black_1 functional-icons_point_black_1  #scale 0.25
icon_alias barrier_small_black_2 functional-icons_point_black_2  #scale 0.25
icon_alias barrier_small_black_3 functional-icons_point_black_3  #scale 0.25
icon_alias barrier_small_black_4 functional-icons_point_black_4  #scale 0.25
icon_alias barrier_small_black_bold_1 functional-icons_point_black_bold_1  #scale 0.25
icon_alias barrier_small_black_bold_2 functional-icons_point_black_bold_2  #scale 0.25
icon_alias barrier_small_black_bold_3 functional-icons_point_black_bold_3  #scale 0.25
icon_alias barrier_small_black_bold_4 functional-icons_point_black_bold_4  #scale 0.25
icon_alias barrier_small_white_1 functional-icons_point_white_1  #scale 0.25
icon_alias barrier_small_white_2 functional-icons_point_white_2  #scale 0.25
icon_alias barrier_small_white_3 functional-icons_point_white_3  #scale 0.25
icon_alias barrier_small_white_4 functional-icons_point_white_4  #scale 0.25
icon_alias barrier_small_red_1 functional-icons_point_red_1  #scale 0.25
icon_alias barrier_small_red_2 functional-icons_point_red_2  #scale 0.25
icon_alias barrier_small_red_3 functional-icons_point_red_3  #scale 0.25
icon_alias barrier_small_red_4 functional-icons_point_red_4  #scale 0.25
icon_alias barrier_small_red_bold_1 functional-icons_point_red_bold_1  #scale 0.25
icon_alias barrier_small_red_bold_2 functional-icons_point_red_bold_2  #scale 0.25
icon_alias barrier_small_red_bold_3 functional-icons_point_red_bold_3  #scale 0.25
icon_alias barrier_small_red_bold_4 functional-icons_point_red_bold_4  #scale 0.25
icon_alias barrier_small_brown_bold_1 functional-icons_point_brown_bold_1  #scale 0.25
icon_alias barrier_small_brown_bold_2 functional-icons_point_brown_bold_2  #scale 0.25
icon_alias rungs_dot functional-icons_point_purple_1
icon_alias ladder functional-icons_ladder
icon_alias rungs functional-icons_rungs

## Emergency + Health
icon_alias emergency emergency_ambulance_station
icon_alias emergency_infrastructure emergency_emergency_phone
icon_alias amenity_fire_station emergency_firestation4
icon_alias amenity_police amenity_police2
icon_alias emergency_fire_hydrant emergency_colored_fire_hydrant
icon_alias fire_hydrant_type_underground emergency_colored_fire_hydrant_underground
icon_alias fire_hydrant_type_pillar emergency_colored_fire_hydrant
icon_alias suction_point emergency_suction_point
icon_alias emergency_phone emergency_emergency_phone
icon_alias emergency_access_point emergency_emergency_access_point
icon_alias assembly_point emergency_assembly_point
icon_alias defibrillator emergency_defibrillator
icon_alias ambulance_station emergency_ambulance_station
icon_alias fire_extinguisher emergency_fire_extinguisher
icon_alias life_ring emergency_life_ring
icon_alias rescue_box emergency_rescue_box
icon_alias topo_rescue_box topo_emergency_rescue_box
icon_alias mountain_rescue emergency_mountain_rescue
icon_alias lifeguard_base emergency_lifeguard_base
icon_alias lifeguard_tower emergency_lifeguard_tower
icon_alias health_post health_health_post
icon_alias avalanche_transceiver emergency_avalanche_transceiver
icon_alias avalanche_transceiver_training emergency_avalanche_transceiver_training
icon_alias siren emergency_siren
icon_alias disaster_response emergency_disaster_response

icon_alias healthcare health_healthcare
icon_alias amenity_dentist health_dentist
icon_alias amenity_doctors health_doctors3
icon_alias amenity_hospital health_hospital2
icon_alias clinic health_clinic
icon_alias amenity_nursing_home health_nursing_home
icon_alias amenity_pharmacy health_pharmacy2
icon_alias amenity_veterinary health_veterinary
icon_alias social_facility health_nursing_home
icon_alias sanatorium health_sanatorium
icon_alias health_amenity_type_first_aid_kit health_health_amenity_type_first_aid_kit
icon_alias laboratory health_laboratory
icon_alias blood_donation health_blood_donation
icon_alias occupational_therapist health_occupational_therapist
icon_alias nurse health_nurse
icon_alias vaccination health_vaccination
icon_alias physiotherapist health_physiotherapist
icon_alias hospice health_hospice

## Overlays
icon_alias fixme_tag_yes overlays_fixme
icon_alias fixme_tag_lowzoom_yes overlays_fixme_dot
icon_alias fixme_tag_lowzoom2_yes overlays_fixme_dot_2
icon_alias note_tag_yes overlays_note
icon_alias osm_note_dot overlays_osm_note_dot
icon_alias osm_note_dot_2 overlays_osm_note_dot_2
icon_alias drinking_water_yes_map overlays_drinking_water_yes
icon_alias drinking_water_no_map overlays_drinking_water_no
icon_alias topo_drinking_water_yes_map overlays_water_drinking_water_yes
icon_alias topo_drinking_water_no_map overlays_water_drinking_water_no
icon_alias access_private_overlay overlays_access_private
icon_alias access_private_red_overlay overlays_access_private_red
icon_alias nfs_access_overlay_closed overlays_nfs_access_overlay_closed
icon_alias nfs_access_overlay_open overlays_nfs_access_overlay_open
icon_alias nfs_access_overlay_temporarily_closed overlays_nfs_access_overlay_temporarily_closed
icon_alias nfs_access_overlay_unreachable overlays_nfs_access_overlay_unreachable


## Traffic + Transportation
icon_alias transportation transport_taxi_rank
icon_alias road_obstacle transport_speedbump
icon_alias personal_transport shopping_car
icon_alias air_transport transport_aerodrome
icon_alias water_transport transport_ferry_terminal
icon_alias bicycle_transport shopping_bicycle
icon_alias aerialway_transport transport_aerialway_station
# icon_alias highway_crossing_bg functional-icons_highway_crossing_bg # Missing
icon_alias highway_crossing transport_zebra_crossing2
icon_alias highway_crossing_map functional-icons_highway_crossing
icon_alias crossing_traffic_signals_map functional-icons_highway_crossing_traffic_signals
icon_alias crossing_uncontrolled_map functional-icons_highway_crossing_uncontrolled
icon_alias crossing_unmarked_map functional-icons_highway_crossing_unmarked
icon_alias stop functional-icons_stop
icon_alias give_way functional-icons_give_way
icon_alias car_pooling transport_car_pooling

icon_alias ford transport_colored_ford
icon_alias topo_ford topo_topo_ford
icon_alias highway_milestone functional-icons_milestone
icon_alias highway_mini_roundabout transport_colored_miniroundabout_anticlockwise
icon_alias mini_roundabout_lhn transport_colored_miniroundabout_clockwise
icon_alias highway_noexit functional-icons_noexit
icon_alias deadlock poi_colored_noexit
icon_alias toll_gantry transport_colored_toll_gantry
icon_alias highway_passing_place functional-icons_passing_place
icon_alias highway_speed_camera transport_speedcamera
icon_alias maxspeed transport_maxspeed
icon_alias mindistance transport_mindistance
icon_alias highway_steps transport_colored_highway_steps
icon_alias osmand_steps functional-icons_osmand_steps
icon_alias highway_traffic_signals_map functional-icons_traffic_lights
icon_alias highway_traffic_signals transport_traffic_lights
icon_alias motorway_junction transport_motorway_junction
icon_alias junction transport_junction
icon_alias rest_area transport_rest_area
icon_alias traffic_calming_bump transport_speedbump
icon_alias traffic_calming_rumble_strip transport_rumble_strip
icon_alias traffic_calming_chicane transport_chicane
icon_alias traffic_calming_choker transport_choker
icon_alias traffic_calming_cushion transport_cushion
icon_alias traffic_calming_hump transport_hump
icon_alias traffic_calming_island transport_traffic_island
icon_alias traffic_calming_table transport_table
icon_alias oneway_blue functional-icons_oneway_blue
icon_alias oneway_reverse_blue functional-icons_oneway_reverse_blue
icon_alias oneway_blue_big functional-icons_oneway_blue_big
icon_alias oneway_reverse_blue_big functional-icons_oneway_reverse_blue_big
icon_alias oneway_black_semitransparent functional-icons_oneway_black_semitransparent
icon_alias oneway_reverse_black_semitransparent functional-icons_oneway_reverse_black_semitransparent
icon_alias oneway_black_semitransparent_big functional-icons_oneway_black_semitransparent_big
icon_alias oneway_reverse_black_semitransparent_big functional-icons_oneway_reverse_black_semitransparent_big
icon_alias oneway_gray functional-icons_oneway_gray
icon_alias oneway_gray_big functional-icons_oneway_gray_big
icon_alias oneway_reverse_gray functional-icons_oneway_reverse_gray
icon_alias oneway_reverse_gray_big functional-icons_oneway_reverse_gray_big
icon_alias arrow_blue_big functional-icons_arrow_blue_big
icon_alias arrow_blue_big_night functional-icons_arrow_blue_big_night
icon_alias arrow_red_up_big functional-icons_arrow_red_up_big
icon_alias arrow_red_down_big functional-icons_arrow_red_down_big
icon_alias arrow_triangle_black functional-icons_arrow_triangle_black
icon_alias arrow_triangle_black_reverse functional-icons_arrow_triangle_black_reverse
icon_alias arrow_triangle_black_big functional-icons_arrow_triangle_black_big
icon_alias arrow_triangle_black_reverse_big functional-icons_arrow_triangle_black_reverse_big
icon_alias arrow_triangle_black_small functional-icons_arrow_triangle_black_small
icon_alias arrow_triangle_black_nobg functional-icons_arrow_triangle_black_nobg
icon_alias arrow_triangle_black_big_nobg functional-icons_arrow_triangle_black_big_nobg
icon_alias arrow_triangle_black_small_nobg functional-icons_arrow_triangle_black_small_nobg
icon_alias arrow_triangle_white_nobg functional-icons_arrow_triangle_white_nobg
icon_alias arrow_triangle_white_big_nobg functional-icons_arrow_triangle_white_big_nobg
icon_alias arrow_triangle_white_small_nobg functional-icons_arrow_triangle_white_small_nobg
icon_alias arrow_triangle_blue functional-icons_arrow_triangle_blue
icon_alias arrow_triangle_blue_big functional-icons_arrow_triangle_blue_big
icon_alias arrow_triangle_blue_small functional-icons_arrow_triangle_blue_small
icon_alias arrow_triangle_darkblue functional-icons_arrow_triangle_darkblue
icon_alias arrow_triangle_darkblue_big functional-icons_arrow_triangle_darkblue_big
icon_alias arrow_triangle_darkblue_small functional-icons_arrow_triangle_darkblue_small
icon_alias arrow_2triangles_black functional-icons_arrow_2triangles_black
icon_alias arrow_2triangles_white functional-icons_arrow_2triangles_white
icon_alias arrow_triangle_white2 functional-icons_arrow_triangle_white2
icon_alias arrow_triangle_black2 functional-icons_arrow_triangle_black2
icon_alias skimap_arrow_2triangles_black skimap_arrow_2triangles_black
icon_alias skimap_arrow_2triangles_black_big skimap_arrow_2triangles_black_big
icon_alias skimap_arrow_2triangles_black_big_nobg skimap_arrow_2triangles_black_big_nobg
icon_alias skimap_arrow_2triangles_white_big_nobg skimap_arrow_2triangles_white_big_nobg
icon_alias skimap_arrow_2triangles_black_nobg skimap_arrow_2triangles_black_nobg
icon_alias skimap_arrow_2triangles_white_nobg skimap_arrow_2triangles_white_nobg
icon_alias skimap_arrow_2triangles_black_small skimap_arrow_2triangles_black_small
icon_alias skimap_arrow_2triangles_black_small_nobg skimap_arrow_2triangles_black_small_nobg
icon_alias skimap_arrow_2triangles_white_small_nobg skimap_arrow_2triangles_white_small_nobg
icon_alias harbour_yes poi_colored_harbour
icon_alias historic_milestone tourist_historic_milestone
icon_alias topo_milestone topo_topo_historic_milestone # ? functional-icons_milestone
icon_alias runway transport_runway
icon_alias ford_stepping_stones transport_colored_ford_stepping_stones
icon_alias topo_ford_stepping_stones topo_topo_ford_stepping_stones
icon_alias traffic_mirror poi_colored_traffic_mirror
icon_alias via_ferrata_map functional-icons_via_ferrata
icon_alias via_ferrata sport_via_ferrata

icon_alias fuel transport_fuel
icon_alias filling_station transport_fuel
icon_alias charging_station transport_charging_station
icon_alias electricity_combined_charging transport_charging_station
icon_alias charging_station_filter transport_charging_station
icon_alias amenity_fuel_lpg transport_fuel_lpg
icon_alias amenity_fuel transport_fuel
icon_alias aeroway_fuel transport_aeroway_fuel
icon_alias turning_circle transport_turning_circle
icon_alias turning_circle_night transport_colored_turning_circle_night
icon_alias turning_circle_2 transport_colored_turning_circle2
icon_alias waterway_fuel transport_waterway_fuel

icon_alias osmand_access_private functional-icons_osmand_access_private
icon_alias osmand_access_private_poi poi_osmand_access_private_poi

icon_alias parking transport_parking
icon_alias amenity_parking transport_parking
icon_alias amenity_parking_private transport_parking_private2
icon_alias amenity_parking_paid transport_parking_car_paid
icon_alias parking_multi_storey transport_parking_multi-storey
icon_alias amenity_parking_multi_storey_paid transport_parking_multi-storey_paid
icon_alias parking_underground transport_parking_underground
icon_alias amenity_parking_underground_paid transport_parking_underground_paid
icon_alias bicycle_parking transport_parking_bicycle
icon_alias bicycle_parking_stands transport_bicycle_parking_stands
icon_alias bicycle_parking_wall_loops transport_bicycle_parking_wall_loops
icon_alias bicycle_parking_rack transport_bicycle_parking_rack
icon_alias bicycle_parking_anchors transport_bicycle_parking_anchors
icon_alias bicycle_parking_building transport_bicycle_parking_building
icon_alias bicycle_parking_shed transport_bicycle_parking_building
icon_alias bicycle_parking_bollard transport_bicycle_parking_bollard
icon_alias bicycle_parking_informal transport_bicycle_parking_informal
icon_alias bicycle_parking_lockers transport_bicycle_parking_lockers
icon_alias bicycle_parking_tree transport_bicycle_parking_tree
icon_alias bicycle_parking_streetpod transport_bicycle_parking_streetpod
icon_alias amenity_motorcycle_parking transport_parking_motorcycle
icon_alias amenity_motorcycle_parking_paid transport_parking_motorcycle_paid
icon_alias parking_space transport_parking_space
icon_alias amenity_parking_disabled transport_parking_disabled


icon_alias public_transport transport_bus_stop
icon_alias amenity_bus_station transport_bus_station2
icon_alias public_transport_station transport_bus_station
icon_alias public_transport_stop_position transport_bus_stop2
icon_alias highway_bus_stop transport_bus_stop
icon_alias topo_bus_stop topo_topo_bus_stop
icon_alias highway_bus_stop_small functional-icons_bus_stop_small
icon_alias highway_bus_stop_small_night functional-icons_bus_stop_small_night
icon_alias topo_bus_stop_small topo_topo_bus_stop_small
icon_alias highway_bus_stop_round_small functional-icons_bus_stop_round_small
icon_alias highway_bus_stop_round_big functional-icons_bus_stop_round_big
icon_alias highway_bus_stop_round_small_night functional-icons_bus_stop_round_small_night
icon_alias highway_bus_stop_round_big_night functional-icons_bus_stop_round_big_night
icon_alias bus_station_small functional-icons_bus_station_small
icon_alias public_transport_platform transport_bus_stop
icon_alias amenity_ferry_terminal transport_ferry_terminal
icon_alias ferry_terminal_small functional-icons_ferry_terminal_small
icon_alias ferry_terminal_small_night functional-icons_ferry_terminal_small_night
icon_alias amenity_taxi transport_taxi_rank
icon_alias highway_services transport_services
icon_alias mountain_pass poi_mountain_pass
icon_alias topo_mountain_pass topo_topo_mountain_pass

icon_alias amenity_bicycle_rental transport_rental_bicycle
icon_alias amenity_boat_sharing transport_boat_sharing
icon_alias boat_rental transport_boat_rental
icon_alias amenity_car_rental transport_rental_car
icon_alias amenity_car_sharing transport_car_share
icon_alias amenity_ski_rental transport_ski_rental

icon_alias leisure_marina transport_marina
icon_alias leisure_marina_private transport_marina_private
icon_alias leisure_slipway transport_slipway
icon_alias man_made_lighthouse transport_lighthouse
icon_alias topo_lighthouse topo_lighthouse
icon_alias waterway_lock_gate_small functional-icons_lock_gate  #scale 0.5
icon_alias lock_gate poi_colored_lock_gate  #scale 0.25
icon_alias lock poi_lock_gate
icon_alias lock_basin seamark_small_poi_lock_basin  #scale 0.25
icon_alias waterway_dock transport_dock

icon_alias halt_small functional-icons_halt_small  #scale 0.25
icon_alias halt_small_night functional-icons_halt_small_night
icon_alias halt_small_2 functional-icons_halt_small_2  #scale 0.25
icon_alias halt_small_2_night functional-icons_halt_small_2_night
icon_alias topo_railway_halt_small functional-icons_topo_railway_halt_small
icon_alias halt transport_halt  #scale 0.25
icon_alias level_crossing_map functional-icons_level_crossing  #scale 0.5
icon_alias level_crossing poi_colored_level_crossing  #scale 0.5
icon_alias railway_yard transport_railway_yard  #scale 0.25
icon_alias railway_platform transport_train_station2
icon_alias railway_station_disused functional-icons_train_station_disused
icon_alias railway_station_small_disused functional-icons_railway_station_small_disused
icon_alias railway_station_small_disused_night functional-icons_railway_station_small_disused_night
icon_alias railway_station_small functional-icons_railway_station_small  #scale 0.375
icon_alias railway_station_small_night functional-icons_railway_station_small_night
icon_alias topo_railway_station_small functional-icons_topo_railway_station_small
icon_alias railway_station_subway_map transport_station_subway
icon_alias railway_station_subway_small functional-icons_railway_station_subway_small
icon_alias railway_station_subway_small_night functional-icons_railway_station_subway_small_night
icon_alias railway_station transport_train_station
icon_alias railway_tram_stop_round_big functional-icons_blue_stop_round_big
icon_alias railway_tram_stop_round_big_night functional-icons_blue_stop_round_big_night
icon_alias railway_tram_stop_round_small functional-icons_blue_stop_round_small
icon_alias railway_tram_stop_round_small_night functional-icons_blue_stop_round_small_night
icon_alias railway_tram_stop transport_tram_stop
icon_alias tram_stop_small functional-icons_tram_stop_small
icon_alias tram_stop_small_night functional-icons_tram_stop_small_night
icon_alias subway_station transport_colored_subway_station
icon_alias funicular transport_funicular
icon_alias escape_lane transport_escape_lane
icon_alias emergency_bay transport_emergency_bay

icon_alias subway_entrance_map subway_subway_entrance_map
icon_alias subway_entrance poi_colored_subway_entrance
icon_alias subway_entrance transport_subway_entrance
icon_alias railway_subway_entrance_red functional-icons_subway_entrance_red
icon_alias railway_subway_entrance_brown functional-icons_subway_entrance_brown
icon_alias railway_subway_entrance_orange functional-icons_subway_entrance_orange
icon_alias railway_subway_entrance_darkyellow functional-icons_subway_entrance_darkyellow
icon_alias railway_subway_entrance_yellow functional-icons_subway_entrance_yellow
icon_alias railway_subway_entrance_lightgreen functional-icons_subway_entrance_lightgreen
icon_alias railway_subway_entrance_green functional-icons_subway_entrance_green
icon_alias railway_subway_entrance_lightblue functional-icons_subway_entrance_lightblue
icon_alias railway_subway_entrance_blue functional-icons_subway_entrance_blue
icon_alias railway_subway_entrance_purple functional-icons_subway_entrance_purple
icon_alias railway_subway_entrance_gray functional-icons_subway_entrance_gray
icon_alias railway_subway_entrance_black functional-icons_subway_entrance_black

icon_alias railway_subway_station_small_default functional-icons_subway_station_small_default
icon_alias railway_subway_station_small_default2 functional-icons_subway_station_small_default2
icon_alias railway_subway_station_small_red functional-icons_subway_station_small_red
icon_alias railway_subway_station_small_brown functional-icons_subway_station_small_brown
icon_alias railway_subway_station_small_orange functional-icons_subway_station_small_orange
icon_alias railway_subway_station_small_orange2 functional-icons_subway_station_small_orange2
icon_alias railway_subway_station_small_darkyellow functional-icons_subway_station_small_darkyellow
icon_alias railway_subway_station_small_darkyellow2 functional-icons_subway_station_small_darkyellow2
icon_alias railway_subway_station_small_yellow functional-icons_subway_station_small_yellow
icon_alias railway_subway_station_small_yellow2 functional-icons_subway_station_small_yellow2
icon_alias railway_subway_station_small_lightgreen functional-icons_subway_station_small_lightgreen
icon_alias railway_subway_station_small_lightgreen2 functional-icons_subway_station_small_lightgreen2
icon_alias railway_subway_station_small_green functional-icons_subway_station_small_green
icon_alias railway_subway_station_small_green2 functional-icons_subway_station_small_green2
icon_alias railway_subway_station_small_lightblue functional-icons_subway_station_small_lightblue
icon_alias railway_subway_station_small_lightblue2 functional-icons_subway_station_small_lightblue2
icon_alias railway_subway_station_small_blue functional-icons_subway_station_small_blue
icon_alias railway_subway_station_small_blue2 functional-icons_subway_station_small_blue2
icon_alias railway_subway_station_small_purple functional-icons_subway_station_small_purple
icon_alias railway_subway_station_small_purple2 functional-icons_subway_station_small_purple2
icon_alias railway_subway_station_small_gray functional-icons_subway_station_small_gray
icon_alias railway_subway_station_small_gray2 functional-icons_subway_station_small_gray2
icon_alias railway_subway_station_small_black functional-icons_subway_station_small_black
icon_alias railway_subway_station_small_black2 functional-icons_subway_station_small_black2
icon_alias railway_subway_station_small_white functional-icons_subway_station_small_white

icon_alias subway_moscow subway_subway_moscow
icon_alias subway_samara subway_subway_samara
icon_alias subway_budapest subway_subway_budapest
icon_alias subway_spb subway_subway_spb
icon_alias subway_kazan subway_subway_kazan
icon_alias subway_baku subway_subway_baku
icon_alias subway_tbilisi subway_subway_tbilisi
icon_alias subway_yerevan subway_subway_yerevan
icon_alias subway_minsk subway_subway_minsk
icon_alias subway_nnovgorod subway_subway_nnovgorod
icon_alias subway_novosibirsk subway_subway_novosibirsk
icon_alias subway_yekaterinburg subway_subway_yekaterinburg
icon_alias subway_germany subway_subway_germany
icon_alias subway_wien subway_subway_wien
icon_alias subway_madrid subway_subway_madrid
icon_alias subway_paris subway_subway_paris
icon_alias subway_london subway_subway_london
icon_alias subway_barcelona subway_subway_barcelona
icon_alias subway_stockholm subway_subway_stockholm
icon_alias subway_praha subway_subway_praha
icon_alias subway_athens subway_subway_athens
icon_alias subway_italy subway_subway_italy
icon_alias subway_italy_catania subway_subway_italy_catania
#icon_alias subway_italy_brescia subway_subway_italy_brescia
icon_alias subway_rotterdam subway_subway_rotterdam
icon_alias subway_amsterdam subway_subway_amsterdam
icon_alias subway_brussels subway_subway_brussels
icon_alias subway_lyon subway_subway_lyon
icon_alias subway_chicago subway_subway_chicago
icon_alias subway_newyork subway_subway_newyork
icon_alias subway_tokyo subway_subway_tokyo
icon_alias subway_osaka subway_subway_osaka
icon_alias subway_nagoya subway_subway_nagoya
icon_alias subway_singapore subway_subway_singapore
icon_alias subway_kolkata subway_subway_kolkata
icon_alias subway_delhi subway_subway_delhi
icon_alias subway_tehran subway_subway_tehran
icon_alias subway_cairo subway_subway_cairo
icon_alias subway_riodejaneiro subway_subway_riodejaneiro
icon_alias subway_tashkent subway_subway_tashkent
icon_alias subway_almaty subway_subway_almaty
icon_alias subway_manila subway_subway_manila
icon_alias subway_toronto subway_subway_toronto
icon_alias subway_montreal subway_subway_montreal
icon_alias subway_kyiv subway_subway_kyiv
icon_alias subway_kharkiv subway_subway_kharkiv
icon_alias subway_buenosaires subway_subway_buenosaires
icon_alias subway_boston subway_subway_boston
icon_alias subway_washington subway_subway_washington
icon_alias subway_bucharest subway_subway_bucharest
icon_alias subway_losangeles subway_subway_losangeles
icon_alias subway_sofia subway_subway_sofia
icon_alias subway_taipei subway_subway_taipei
icon_alias subway_santiago subway_subway_santiago
icon_alias subway_valparaiso subway_subway_valparaiso
icon_alias subway_seoul subway_subway_seoul
icon_alias subway_philadelphia subway_subway_philadelphia
icon_alias subway_philadelphia_patco subway_subway_philadelphia_patco
icon_alias subway_istanbul subway_subway_istanbul
icon_alias subway_san_francisco subway_subway_san_francisco
icon_alias subway_atlanta subway_subway_atlanta
icon_alias subway_baltimore subway_subway_baltimore
icon_alias subway_cleveland subway_subway_cleveland
icon_alias subway_miami subway_subway_miami
icon_alias subway_newyork_path subway_subway_newyork_path
icon_alias subway_puerto_rico subway_subway_puerto_rico
icon_alias subway_mexico subway_subway_mexico
icon_alias subway_sanpaulo subway_subway_sanpaulo
icon_alias subway_caracas subway_subway_caracas
icon_alias subway_yokohama subway_subway_yokohama
icon_alias subway_yokohama_minatomirai subway_subway_yokohama_minatomirai
icon_alias subway_sapporo subway_subway_sapporo
icon_alias subway_medellin subway_subway_medellin
icon_alias subway_monterrey subway_subway_monterrey
icon_alias subway_warsaw subway_subway_warsaw
icon_alias subway_lisbon subway_subway_lisbon
icon_alias subway_fukuoka subway_subway_fukuoka
icon_alias subway_suzhou subway_subway_suzhou
icon_alias subway_shanghai subway_subway_shanghai
icon_alias subway_guangzhou subway_subway_guangzhou

icon_alias aerialway_station_small functional-icons_aerialway_station_small  #scale 0.25
icon_alias aerialway_station_small_night functional-icons_aerialway_station_small_night
icon_alias aerialway_station transport_aerialway_station  #scale 0.375
icon_alias aerialway_cable_car transport_aerialway_cable_car
icon_alias aerialway_chair_lift transport_aerialway_chair_lift
icon_alias aerialway_pylon transport_aerialway_pylon
icon_alias aerialway_pylon_small functional-icons_aerialway_pylon_small
icon_alias aerialway_drag_lift transport_aerialway_drag_lift
icon_alias aerialway_platter transport_aerialway_platter
icon_alias aerialway_j_bar transport_aerialway_j_bar
icon_alias aerialway_t_bar transport_aerialway_t_bar
icon_alias aerialway_goods transport_aerialway_goods
icon_alias aerialway_magic_carpet transport_aerialway_magic_carpet
icon_alias aerialway_gondola transport_aerialway_gondola
icon_alias aerialway_rope_tow transport_aerialway_rope_tow

icon_alias aeroway_aerodrome_abandoned functional-icons_aerodrome_abandoned
icon_alias topo_aerodrome_abandoned topo_topo_aerodrome_abandoned
icon_alias aeroway_aerodrome transport_aerodrome
icon_alias aeroway_aerodrome_small transport_colored_aerodrome
icon_alias topo_aerodrome topo_topo_aerodrome
icon_alias aeroway_airport transport_airport
icon_alias aeroway_gate transport_colored_airport_gate
icon_alias aeroway_helipad transport_helicopter_pad
icon_alias aeroway_terminal transport_airport_terminal
icon_alias spaceport transport_spaceport

icon_alias put_in functional-icons-x2_whitewater_put_in
icon_alias egress functional-icons-x2_whitewater_egress
icon_alias put_in_egress functional-icons-x2_whitewater_put_in_egress
icon_alias whitewater_hazard functional-icons-x2_whitewater_hazard


## Barrier
icon_alias barrier barrier_colored_bollard
icon_alias barrier_block barrier_colored_blocks
icon_alias barrier_bollard barrier_colored_bollard
icon_alias barrier_border_control barrier_border_control
icon_alias barrier_bump_gate barrier_colored_bump_gate
icon_alias barrier_bus_trap barrier_colored_bus_trap
icon_alias barrier_cattle_grid barrier_colored_cattle_grid2
icon_alias barrier_chain barrier_colored_chain
icon_alias barrier_cycle_barrier barrier_colored_cycle_barrier2
icon_alias barrier_entrance barrier_colored_entrance
icon_alias barrier_gate barrier_colored_gate
icon_alias barrier_height_restrictor barrier_colored_height_restrictor
icon_alias barrier_kissing_gate barrier_colored_kissing_gate
icon_alias barrier_lift_gate barrier_colored_lift_gate
icon_alias barrier_motorcycle_barrier barrier_colored_cycle_barrier
icon_alias barrier_sally_port barrier_colored_sally_port
icon_alias barrier_stile barrier_colored_stile
icon_alias barrier_swing_gate barrier_colored_swing_gate
icon_alias toll_booth barrier_colored_toll_booth
icon_alias military_checkpoint barrier_colored_military_checkpoint
icon_alias barrier_turnstile barrier_colored_turnstile
icon_alias entrance_yes barrier_colored_entrance2
icon_alias entrance_exit_map functional-icons_entrance_exit
icon_alias entrance_main_map functional-icons_entrance3
icon_alias entrance_service functional-icons_entrance_service
icon_alias entrance_exit poi_colored_entrance_exit
icon_alias entrance_main barrier_colored_entrance2
icon_alias amenity_parking_entrance transport_parking_entrance
icon_alias building_entrance barrier_colored_entrance
icon_alias barrier_colored_debris barrier_colored_debris
icon_alias barrier_colored_horse_stile barrier_colored_horse_stile
icon_alias barrier_colored_jersey_barrier barrier_colored_jersey_barrier
icon_alias barrier_colored_log barrier_colored_log
icon_alias barrier_hampshire_gate barrier_colored_hampshire_gate
icon_alias barrier_coupure barrier_colored_coupure
icon_alias barrier_planter barrier_colored_planter
icon_alias barrier_spikes barrier_colored_spikes
icon_alias barrier_sump_buster barrier_colored_sump_buster
icon_alias barrier_wedge barrier_colored_wedge
icon_alias barrier_bar barrier_colored_bar
icon_alias barrier_tyres barrier_colored_tyres
icon_alias barrier_barrier_board barrier_colored_barrier_board
icon_alias barrier_tank_trap barrier_colored_tank_trap


## Accommodation
icon_alias accomodation accommodation_hotel
icon_alias amenity_shelter accommodation_shelter2
icon_alias topo_shelter topo_topo_shelter
icon_alias tourism_alpine_hut accommodation_alpinehut
icon_alias topo_alpine_hut topo_topo_alpine_hut
icon_alias cabin accommodation_cabin
icon_alias topo_cabin topo_topo_cabin
icon_alias lean_to accommodation_lean_to
icon_alias topo_lean_to topo_topo_lean_to
icon_alias tourism_apartment accommodation_apartment
icon_alias topo_apartment topo_topo_apartment
icon_alias tourism_camp_site accommodation_camping
icon_alias camp_pitch tourist_camp_pitch
icon_alias topo_camp_site topo_topo_camp_site
icon_alias tourism_caravan_site accommodation_caravan
icon_alias topo_caravan_site topo_topo_caravan_site
icon_alias tourism_chalet accommodation_chalet
icon_alias topo_chalet topo_topo_chalet
icon_alias tourism_guest_house accommodation_bed_and_breakfast
icon_alias topo_guest_house topo_topo_guest_house
icon_alias tourism_hostel accommodation_hostel
icon_alias topo_hostel topo_topo_hostel
icon_alias tourism_hotel accommodation_hotel
icon_alias topo_hotel topo_topo_hotel
icon_alias tourism_motel accommodation_motel
icon_alias topo_motel topo_topo_motel
icon_alias wilderness_hut accommodation_wilderness_hut
icon_alias topo_wilderness_hut topo_topo_wilderness_hut
icon_alias summer_camp accommodation_summer_camp
icon_alias refugee_site accommodation_refugee_site
icon_alias group_camping tourist_group_camping

## Tourism
icon_alias sightseeing tourist_castle2
icon_alias tourism tourist_museum
icon_alias for_tourists tourist_view_point
icon_alias attraction tourist_attraction
icon_alias attraction_map poi_attraction_map
icon_alias attraction_amusement_ride tourist_amusement_ride
icon_alias attraction_animal tourist_animal
icon_alias attraction_big_wheel tourist_big_wheel
icon_alias topo_big_wheel topo_topo_big_wheel
icon_alias attraction_carousel tourist_carousel
icon_alias attraction_maze tourist_maze
icon_alias attraction_roller_coaster tourist_roller_coaster
icon_alias attraction_slide tourist_slide
icon_alias attraction_summer_toboggan tourist_summer_toboggan
icon_alias attraction_swing_carousel tourist_swing_carousel
icon_alias attraction_train tourist_train
icon_alias attraction_water_slide entertainment_water_slide
icon_alias tourism_aquarium tourist_aquarium
icon_alias tourism_artwork tourist_artwork
icon_alias tourism_attraction tourist_attraction
icon_alias tourism_information tourist_colored_information
icon_alias information_office tourist_colored_information_office
icon_alias information_board tourist_colored_information_board
icon_alias information_guidepost tourist_colored_information_guidepost
icon_alias information_map tourist_colored_information_map
icon_alias information_terminal tourist_colored_information_terminal
icon_alias information_audioguide tourist_colored_information_audioguide
icon_alias information_route_marker tourist_colored_information_route_marker
icon_alias board_type_nature tourist_colored_board_type_nature
icon_alias board_type_wildlife tourist_colored_board_type_wildlife
icon_alias board_type_plants tourist_colored_board_type_plants
icon_alias tourism_museum tourist_museum
icon_alias tourism_picnic_site tourist_colored_picnic
icon_alias topo_picnic_site topo_topo_picnic_site
icon_alias picnicking tourist_picnicking
icon_alias picnic_table tourist_colored_picnic_table
icon_alias topo_picnic_table topo_topo_picnic_table
icon_alias tourism_theme_park tourist_theme_park
icon_alias tourism_viewpoint tourist_view_point
icon_alias topo_viewpoint topo_topo_view_point
icon_alias tourism_zoo tourist_zoo
icon_alias city_wall tourist_city_wall
icon_alias clock tourist_clock
icon_alias route_hiking_iwn_poi tourist_route_hiking_iwn_poi
icon_alias route_hiking_nwn_poi tourist_route_hiking_nwn_poi
icon_alias route_hiking_rwn_poi tourist_route_hiking_rwn_poi
icon_alias route_hiking_lwn_poi tourist_route_hiking_lwn_poi
icon_alias icn_ref tourist_icn_ref
icon_alias ncn_ref tourist_ncn_ref
icon_alias rcn_ref tourist_rcn_ref
icon_alias lcn_ref tourist_lcn_ref
icon_alias iwn_ref tourist_iwn_ref
icon_alias nwn_ref tourist_nwn_ref
icon_alias rwn_ref tourist_rwn_ref
icon_alias lwn_ref tourist_lwn_ref
icon_alias gallery tourist_gallery
icon_alias firepit tourist_colored_firepit
icon_alias topo_firepit topo_topo_firepit
icon_alias checkpoint_hiking tourist_checkpoint_hiking
icon_alias geoglyph tourist_geoglyph
icon_alias topo_geoglyph topo_topo_geoglyph
icon_alias trailhead tourist_trailhead
icon_alias trail_riding_station tourist_trail_riding_station
icon_alias topo_trailhead topo_topo_trailhead
icon_alias ranger_station amenity_ranger_station
icon_alias mountain tourist_mountain
icon_alias cabin_rentals tourist_cabin_rentals
icon_alias nfs_default_icon tourist_nfs_default_icon
icon_alias dispersed_camping tourist_dispersed_camping
icon_alias viewing_wildlife tourist_viewing_wildlife
icon_alias group_picnicking tourist_group_picnicking
icon_alias visitor_programs tourist_visitor_programs
icon_alias interpretive_areas tourist_interpretive_areas
icon_alias target_shooting tourist_target_shooting
icon_alias mountain_biking tourist_mountain_biking
icon_alias birdwatching tourist_birdwatching
icon_alias horse_camping tourist_horse_camping
icon_alias gold_panning tourist_gold_panning
icon_alias ohv_camping tourist_ohv_camping
icon_alias rockhounding tourist_rockhounding
icon_alias viewing_plants tourist_viewing_plants
icon_alias tubing tourist_tubing
icon_alias sledding_tubing tourist_sledding_tubing
icon_alias tidepooling tourist_tidepooling
icon_alias metal_detecting tourist_metal_detecting
icon_alias dog_sledding tourist_dog_sledding
icon_alias ranger_station_office tourist_ranger_station_office
icon_alias fire_lookout tourist_fire_lookout
icon_alias natural_endangered_area tourist_natural_endangered_area

## Entertainment
icon_alias entertainment tourist_cinema3
icon_alias club tourist_night_club
icon_alias amenity_arts_centre tourist_art_gallery
icon_alias amenity_casino tourist_casino
icon_alias amenity_cinema tourist_cinema3
icon_alias amenity_nightclub tourist_night_club
icon_alias amenity_stripclub amenity_stripclub
icon_alias amenity_theatre tourist_theatre
icon_alias hackerspace entertainment_hackerspace
icon_alias leisure_common entertainment_leisure_common
icon_alias love_hotel entertainment_love_hotel
icon_alias gambling entertainment_gambling
icon_alias adult_gaming_centre entertainment_gambling
icon_alias amusement_arcade entertainment_amusement_arcade
icon_alias amenity_nightclub tourist_night_club
icon_alias mobile_library amenity_mobile_library
icon_alias planetarium amenity_planetarium
icon_alias conference_centre amenity_conference_centre
icon_alias escape_game entertainment_escape_game
icon_alias toy_library amenity_toy_library
icon_alias photo_booth amenity_photo_booth

## Historic
icon_alias historic tourist_archaeological2
icon_alias historic_archaeological_site tourist_archaeological2
icon_alias topo_archaeological_site topo_topo_archaeological2
icon_alias historic_battlefield tourist_battlefield
icon_alias historic_boundary_stone tourist_boundary_stone
icon_alias topo_boundary_stone topo_topo_boundary_stone
icon_alias historic_cannon tourist_colored_cannon
icon_alias historic_castle tourist_castle2
icon_alias topo_castle topo_topo_castle2
icon_alias city_gate barrier_colored_sally_port
icon_alias historic_memorial tourist_memorial
icon_alias topo_memorial topo_topo_memorial
icon_alias historic_mine tourist_mine_abandoned
icon_alias monument tourist_monument2
icon_alias topo_monument topo_topo_monument
icon_alias historic_ruins tourist_ruin
icon_alias topo_ruins topo_topo_ruins
icon_alias historic_rune_stone tourist_colored_rune_stone
icon_alias historic_ship tourist_ship
icon_alias topo_ship topo_topo_ship
icon_alias historic_wayside_cross tourist_wayside_cross
icon_alias topo_wayside_shrine topo_topo_wayside_shrine
icon_alias historic_wayside_shrine tourist_wayside_shrine
icon_alias wreck tourist_wreck
icon_alias topo_wreck topo_topo_wreck
icon_alias palaeontological_site tourist_palaeontological_site
icon_alias topo_palaeontological_site topo_topo_palaeontological_site
icon_alias building_pyramid tourist_pyramid
icon_alias topo_building_pyramid topo_topo_pyramid
icon_alias tomb tourist_tomb
icon_alias topo_tomb topo_topo_tomb
icon_alias historic_aircraft tourist_historic_aircraft
icon_alias topo_aircraft topo_topo_historic_aircraft
icon_alias technical_monument tourist_technical_monument
icon_alias topo_technical_monument topo_topo_technical_monument
icon_alias memorial_stolperstein tourist_memorial_stolperstein
icon_alias memorial_bust tourist_bust
icon_alias memorial_obelisk tourist_obelisk
icon_alias memorial_plaque tourist_plaque
icon_alias memorial_statue tourist_statue
icon_alias memorial_stele tourist_stele
icon_alias memorial_war tourist_war_memorial
icon_alias historic_manor tourist_historic_manor
icon_alias historic_stone tourist_historic_stone
icon_alias prison_camp tourist_prison_camp
icon_alias locomotive tourist_locomotive
icon_alias outcrop tourist_outcrop
icon_alias topo_outcrop topo_topo_outcrop
icon_alias charcoal_pile tourist_charcoal_pile
icon_alias topo_charcoal_pile topo_charcoal_pile
icon_alias historic_tank tourist_historic_tank
icon_alias topo_tank topo_topo_historic_tank
icon_alias pillory tourist_pillory
icon_alias spacecraft tourist_spacecraft
icon_alias point_of_interest poi_point_of_interest

## Special POI icons
icon_alias special_poi_big_ben special_poi_big_ben
icon_alias special_poi_brandenburg_gate special_poi_brandenburg_gate
icon_alias special_poi_chichen_itza special_poi_chichen_itza
icon_alias special_poi_colosseum special_poi_colosseum
icon_alias special_poi_eiffel_tower special_poi_eiffel_tower
icon_alias special_poi_sagrada_familia special_poi_sagrada_familia
icon_alias special_poi_statue_of_liberty special_poi_statue_of_liberty
icon_alias special_poi_taj_mahal special_poi_taj_mahal
icon_alias special_poi_us_capitol special_poi_us_capitol

## Sport
icon_alias sport sport_swimming_outdoor
icon_alias leisure_stadium sport_stadium
icon_alias sport_10pin sport_bowling
icon_alias sport_9pin sport_bowling
icon_alias sport_archery sport_archery
icon_alias sport_athletics sport_athletics
icon_alias sport_baseball sport_baseball2
icon_alias sport_base sport_basejumping
icon_alias sport_basketball sport_basketball
icon_alias sport_billiard sport_snooker
icon_alias sport_bmx sport_bmx
icon_alias sport_canoe sport_canoe
icon_alias sport_climbing sport_hillclimbing
icon_alias sport_climbing_adventure sport_climbing_adventure
icon_alias sport_cricket sport_cricket
icon_alias sport_cycling sport_cycling
icon_alias sport_diving sport_diving
icon_alias sport_golf sport_golf
icon_alias sport_disc_golf sport_disc_golf
icon_alias sport_gymnastics sport_gymnasium
icon_alias sport_handball sport_handball
icon_alias ice_hockey sport_ice_hockey
icon_alias field_hockey sport_field_hockey
icon_alias equestrian sport_horse_racing
icon_alias sport_motor sport_motorracing
icon_alias sport_free_flying sport_free_flying
icon_alias sport_rugby_league sport_rugby_league
icon_alias sport_rugby_union sport_rugby_union
icon_alias sport_sailing sport_sailing
icon_alias sport_scuba_diving sport_scuba_diving  #derived from NPS public library
icon_alias sport_shooting sport_shooting
icon_alias sport_skateboard sport_skateboard
icon_alias sport_skiing sport_skiing_downhill
icon_alias sport_soccer sport_soccer
icon_alias sport_stadium sport_stadium
icon_alias sport_surfing sport_surfing
icon_alias sport_swimming sport_swimming_outdoor
icon_alias sport_table_tennis sport_table_tennis
icon_alias sport_tennis sport_tennis
icon_alias sport_volleyball sport_volleyball
icon_alias beachvolleyball sport_beachvolleyball
icon_alias pitch sport_pitch
icon_alias swimming_pool sport_swimming_outdoor
icon_alias leisure_track sport_leisure_track
icon_alias ice_skating sport_iceskating
icon_alias orienteering sport_orienteering
icon_alias golf_course sport_golf
icon_alias horse_riding sport_horse_riding
icon_alias model_aerodrome sport_model_aerodrome
icon_alias american_football sport_american_football
icon_alias raceway sport_raceway
icon_alias fitness_centre sport_fitness_centre
icon_alias billiards sport_billiards
icon_alias chess sport_chess
icon_alias gaelic_games sport_gaelic_games
icon_alias running sport_running
icon_alias karting sport_karting
icon_alias badminton sport_badminton
icon_alias ice_stock sport_ice_stock
icon_alias korfball sport_korfball
icon_alias judo sport_judo
icon_alias rc_car sport_rc_car
icon_alias bandy sport_bandy
icon_alias sport_multi sport_multi
icon_alias dive_centre sport_dive_centre
icon_alias ultralight_aviation sport_ultralight_aviation
icon_alias golf_pin functional-icons-x2_golf_pin
icon_alias hang_gliding sport_hang_gliding
icon_alias windsurfing sport_windsurfing
icon_alias waterskiing sport_waterskiing
icon_alias dojo sport_dojo

icon_alias climbing_route sport_climbing_route
icon_alias climbing_route_bottom sport_climbing_route_bottom
icon_alias climbing_area sport_climbing_area
icon_alias climbing_crag sport_climbing_crag


## Leisure
icon_alias leisure sport_playground
icon_alias leisure_beach_resort tourist_beach_resort
icon_alias leisure_bird_hide entertainment_bird_hide
icon_alias leisure_fishing sport_fishing  #used shop=fish turned by 45 degrees for now
icon_alias leisure_ice_rink sport_iceskating
icon_alias leisure_miniature_golf sport_miniature_golf
icon_alias leisure_playground sport_colored_playground
icon_alias playground_swing sport_colored_swing
icon_alias playground_slide sport_colored_slide
icon_alias playground_structure sport_colored_structure
icon_alias playground_sandpit sport_colored_sandpit
icon_alias playground_springy sport_colored_springy
icon_alias playground_climbingframe sport_colored_climbingframe
icon_alias playground_seesaw sport_colored_seesaw
icon_alias playground_roundabout sport_colored_roundabout
icon_alias playground_playhouse sport_colored_playhouse
icon_alias playground_basketswing sport_colored_basketswing
icon_alias playground_zipwire sport_colored_zipwire
icon_alias playground_balancebeam sport_colored_balancebeam
icon_alias playground_horizontal_bar sport_colored_horizontal_bar
icon_alias playground_hopscotch sport_colored_hopscotch
icon_alias playground_trampoline sport_colored_trampoline
icon_alias leisure_sports_centre sport_leisure_centre2
icon_alias leisure_water_park entertainment_water_slide
icon_alias sauna sport_sauna
icon_alias public_bath amenity_public_bath
icon_alias fitness_station sport_fitness_station
icon_alias tanning_salon sport_tanning_salon
icon_alias sports_hall sport_sports_hall
icon_alias trampoline_park sport_trampoline_park

icon_alias geocache poi_colored_point_of_interest
icon_alias geocache_not_found poi_colored_geocache_not_found
icon_alias geocache_found poi_colored_point_of_interest


## Other amenities
icon_alias other amenity_post_office
icon_alias place_of_worship place_of_worship_unknown
icon_alias internet_access amenity_internet_access
icon_alias amenity_car_wash amenity_car_wash
icon_alias car_wash_self_service amenity_car_wash_self_service
icon_alias vehicle_inspection amenity_vehicle_inspection
icon_alias amenity_fountain water_colored_fountain2
# icon_alias amenity_fountain_night functional-icons_fountain2_night # Missing
icon_alias amenity_monastery place_of_worship_monastery
icon_alias historic_monastery place_of_worship_monastery
icon_alias amenity_place_of_worship place_of_worship_unknown
icon_alias topo_religion_unknown topo_topo_religion_unknown
icon_alias amenity_post_box amenity_post_box
icon_alias letter_box amenity_letter_box
icon_alias amenity_post_office amenity_post_office2
icon_alias amenity_prison amenity_prison
icon_alias amenity_recycling amenity_colored_recycling
icon_alias amenity_telephone amenity_telephone
icon_alias amenity_toilets amenity_toilets
icon_alias amenity_vehicle_ramp amenity_vehicle_ramp
icon_alias service_tyres shopping_service_tyres
icon_alias religion_christian place_of_worship_christian3
icon_alias topo_christian topo_topo_christian
icon_alias religion_jewish place_of_worship_jewish3
icon_alias topo_jewish topo_topo_jewish
icon_alias religion_muslim place_of_worship_islamic3
icon_alias topo_muslim topo_topo_muslim
icon_alias religion_sikh place_of_worship_sikh3
icon_alias religion_buddhist place_of_worship_buddhist3
icon_alias topo_buddhist topo_topo_buddhist
icon_alias religion_hindu place_of_worship_hindu3
icon_alias topo_hindu topo_topo_hindu
icon_alias religion_shinto place_of_worship_shinto3
icon_alias religion_taoist place_of_worship_taoist
icon_alias brothel amenity_brothel
icon_alias smoking_area amenity_smoking_area
icon_alias studio amenity_studio
icon_alias waste_basket amenity_waste_bin
icon_alias waste_basket2 amenity_colored_waste_basket
icon_alias waste_disposal amenity_colored_waste_disposal
icon_alias shower amenity_shower
icon_alias dressing_room amenity_dressing_room
icon_alias bench amenity_colored_bench
icon_alias lounger amenity_colored_lounger
icon_alias dry_cleaning amenity_dry_cleaning
icon_alias massage amenity_massage
icon_alias funeral_directors amenity_funeral_directors
icon_alias internet_access_wlan amenity_internet_access_wlan
icon_alias internet_access_wired amenity_internet_access_wired
#! icon_alias amenity_grave_yard place_of_worship_christian3  #already defined as icon in the shader section
icon_alias watering_place amenity_watering_place
icon_alias animal_shelter amenity_animal_shelter
icon_alias animal_boarding amenity_animal_boarding
icon_alias baby_hatch amenity_baby_hatch
icon_alias boat_storage amenity_boat_storage
icon_alias crematorium amenity_crematorium
icon_alias mortuary amenity_mortuary
icon_alias internet_access_yes amenity_internet_access_wlan
icon_alias customs amenity_customs
icon_alias dojo amenity_dojo
icon_alias social_centre amenity_social_centre
icon_alias compressed_air amenity_compressed_air
icon_alias amenity_vacuum_cleaner amenity_vacuum_cleaner
icon_alias bicycle_repair_station amenity_bicycle_repair_station
icon_alias water_tap amenity_water_tap
icon_alias topo_water_tap topo_water_water_tap
icon_alias recycling_centre_map amenity_recycling_centre_map
icon_alias recycling_container amenity_colored_recycling_container
icon_alias barbecue amenity_barbecue
icon_alias public_bookcase amenity_public_bookcase
icon_alias internet_cafe amenity_internet_cafe
icon_alias feeding_place amenity_colored_feeding_place
icon_alias animal_keeping amenity_animal_keeping
icon_alias coworking_space amenity_coworking
icon_alias trolley_bay poi_colored_trolley_bay
icon_alias research_institute amenity_research_institute
icon_alias parcel_locker amenity_parcel_locker

icon_alias craft craft_tailor
icon_alias craft_default craft_craft_default
icon_alias craft_beekeeper craft_beekeeper
icon_alias craft_blacksmith craft_blacksmith
icon_alias craft_brewery craft_brewery
icon_alias craft_locksmith craft_locksmith
icon_alias craft_painter craft_painter
icon_alias craft_tailor craft_tailor
icon_alias craft_shoemaker craft_shoemaker
icon_alias craft_jeweller craft_jeweller
icon_alias craft_agricultural_engines craft_agricultural_engines
icon_alias craft_boatbuilder craft_boatbuilder
icon_alias craft_electrician craft_electrician
icon_alias craft_handicraft craft_handicraft
icon_alias craft_hvac craft_hvac
icon_alias craft_insulation craft_insulation
icon_alias craft_photographic_laboratory craft_photographic_laboratory
icon_alias craft_clockmaker craft_clockmaker
icon_alias craft_key_cutter craft_key_cutter
icon_alias craft_plasterer craft_plasterer
icon_alias craft_plumber craft_plumber
icon_alias craft_roofer craft_roofer
icon_alias craft_stonemason craft_stonemason
icon_alias craft_carpenter craft_carpenter
icon_alias craft_sawmill craft_sawmill
icon_alias craft_pottery craft_pottery
icon_alias craft_winery craft_winery
icon_alias craft_metal_construction craft_metal_construction
icon_alias craft_window_construction craft_window_construction
icon_alias craft_builder craft_builder
icon_alias craft_photographer craft_photographer
icon_alias craft_caterer craft_caterer
icon_alias craft_electronics_repair craft_electronics_repair
icon_alias craft_gardener craft_gardener

icon_alias finance money_bank2
icon_alias amenity_atm money_atm
icon_alias payment_terminal money_payment_terminal
icon_alias payment_centre money_payment_centre
icon_alias money_transfer money_money_transfer
icon_alias amenity_bank money_bank2
icon_alias amenity_bureau_de_change money_currency_exchange
icon_alias bitcoin_yes money_bitcoin
icon_alias money_lender money_money_lender
icon_alias mobile_money_agent money_mobile_money_agent

icon_alias office office_office
icon_alias amenity_community_centre amenity_public_building
icon_alias amenity_courthouse amenity_court
icon_alias amenity_embassy amenity_embassy
icon_alias amenity_library amenity_library
icon_alias amenity_public_building amenity_public_building
icon_alias amenity_social_centre amenity_public_building
icon_alias amenity_townhall amenity_town_hall2
icon_alias register_office amenity_register_office
icon_alias geodesist office_geodesist


icon_alias service amenity_service
icon_alias landuse landuse_landuse

## Education
icon_alias education education_university
icon_alias amenity_college education_college
icon_alias kindergarten education_kindergarten
icon_alias amenity_school education_school
icon_alias amenity_university education_university
icon_alias driving_school education_driving_school
icon_alias training education_training
icon_alias training_yoga education_training_yoga
icon_alias music_school education_music_school
icon_alias language_school education_language_school
icon_alias childcare education_childcare
icon_alias prep_school education_prep_school
icon_alias driver_training education_driver_training

## Man made
icon_alias man_made power_generator_wind2
icon_alias transport_construction poi_colored_bridge
icon_alias water_supply poi_colored_water_tower
icon_alias power power_generator
icon_alias power_terminal power_power_terminal
icon_alias power_portal poi_colored_power_portal
icon_alias communication amenity_telephone
icon_alias trash_disposal amenity_colored_waste_disposal
icon_alias bridge poi_colored_bridge
icon_alias tunnel poi_colored_tunnel
icon_alias osmand_tunnel poi_osmand_tunnel
icon_alias amenity_hunting_stand poi_colored_hunting_stand
icon_alias highway_street_lamp functional-icons_street_lamp
icon_alias highway_street_lamp_lit functional-icons_street_lamp_lit
icon_alias man_made_adit poi_adit
icon_alias man_made_antenna poi_colored_antenna
icon_alias man_made_chimney poi_colored_chimney
icon_alias topo_chimney topo_big_topo_chimney
icon_alias crane poi_colored_crane
icon_alias man_made_mast poi_colored_mast
icon_alias topo_mast topo_big_topo_mast
icon_alias man_made_mineshaft poi_colored_mine
icon_alias topo_mine topo_topo_mine
icon_alias topo_mine_abandoned topo_topo_mine_abandoned
icon_alias radar poi_colored_monitoring_station_radar
icon_alias astronomical_observatory poi_colored_observatory_astronomical
icon_alias telescope poi_colored_telescope
icon_alias man_made_observatory poi_colored_observatory
icon_alias observation_tower poi_colored_observatory
icon_alias man_made_petroleum_well poi_colored_petroleum_well
icon_alias man_made_survey_point poi_colored_survey_point
icon_alias topo_survey_point topo_topo_survey_point
icon_alias man_made_tower poi_colored_tower
icon_alias topo_tower topo_big_topo_tower
icon_alias bell_tower poi_colored_tower_bell_tower
icon_alias communication_tower poi_colored_tower_communications2
icon_alias topo_communication_tower topo_big_topo_communication_tower
icon_alias cooling_tower poi_colored_tower_cooling
icon_alias lighting_tower poi_colored_tower_lighting
icon_alias man_made_water_tower poi_colored_water_tower
icon_alias man_made_windmill poi_colored_windmill
icon_alias topo_windmill topo_big_topo_windmill
icon_alias no_icon functional-icons_no_icon
icon_alias generator_source_coal power_generator_coal
icon_alias generator_source_gas power_generator_gas
icon_alias generator_source_geothermal power_generator_geothermal
icon_alias generator_source_nuclear power_generator_nuclear
icon_alias generator_source_oil power_generator_oil
icon_alias generator_source_diesel power_generator_diesel
icon_alias generator_source_solar power_generator_solar
icon_alias generator_source_hydro power_generator_water2
icon_alias generator_source_wind power_generator_wind
icon_alias power_generator power_generator
icon_alias power_plant power_plant
icon_alias power_substation power_transformer2
icon_alias power_tower poi_colored_power_tower
icon_alias power_tower_square functional-icons_power_tower
icon_alias power_tower_small functional-icons_power_tower_small
icon_alias power_tower_small2 functional-icons_power_tower_small2
icon_alias power_generator power_generator
icon_alias railway_buffer_stop poi_colored_buffer_stop
icon_alias power_transformer power_transformer_small
icon_alias topo_transformer topo_big_topo_transformer
icon_alias works poi_colored_works
icon_alias military_bunker poi_colored_military_bunker
icon_alias topo_bunker topo_topo_bunker
icon_alias abandoned_poi poi_colored_abandoned_poi
icon_alias surveillance poi_colored_surveillance
icon_alias pier poi_colored_pier
icon_alias beacon poi_colored_beacon
icon_alias breakwater poi_colored_breakwater
icon_alias military_range poi_colored_military_range
icon_alias power_cable_distribution_cabinet power_cable_distribution_cabinet
icon_alias kiln poi_colored_kiln
icon_alias cairn poi_colored_cairn
icon_alias groyne poi_colored_groyne
icon_alias military_naval_base poi_colored_military_naval_base
icon_alias building_map functional-icons_building_map
icon_alias square poi_colored_square
icon_alias building poi_colored_building
icon_alias cross poi_colored_cross
icon_alias grave poi_colored_grave
icon_alias storage_tank poi_colored_storage_tank
icon_alias wastewater_plant poi_colored_wastewater_plant
icon_alias water_works poi_colored_water_works
icon_alias watermill poi_watermill
icon_alias topo_watermill topo_topo_watermill
icon_alias monitoring_station poi_colored_monitoring_station
icon_alias dolphin poi_colored_dolphin
icon_alias street_cabinet poi_colored_street_cabinet
icon_alias sanitary_dump_station poi_colored_sanitary_dump_station
icon_alias sanitary_dump_station_white poi_sanitary_dump_station
icon_alias spoil_heap poi_colored_spoil_heap
icon_alias ventilation_shaft poi_colored_ventilation_shaft
icon_alias weighbridge transport_weighbridge
icon_alias pumping_station poi_colored_pumping_station
icon_alias mdf poi_colored_mdf
icon_alias topo_power_plant topo_topo_power_plant
icon_alias pipeline_substation poi_colored_pipeline_substation
icon_alias flare poi_colored_flare
icon_alias cellar_entrance poi_cellar_entrance
icon_alias topo_cellar_entrance topo_cellar_entrance
icon_alias windsock poi_windsock
icon_alias grit_bin poi_colored_grit_bin
icon_alias ticket_validator poi_colored_ticket_validator

icon_alias military poi_colored_military_bunker
icon_alias beehive poi_colored_beehive
icon_alias wildlife_crossing poi_wildlife_crossing
icon_alias satellite_dish poi_colored_satellite_dish
icon_alias waste_transfer_station amenity_waste_transfer_station
icon_alias lavoir amenity_lavoir
icon_alias dovecote poi_dovecote
icon_alias fish_pass poi_fish_pass

## Food and Drink
icon_alias restaurants food_restaurant
icon_alias sustenance food_fastfood
icon_alias cafe_and_restaurant food_restaurant
icon_alias amenity_bar food_bar
icon_alias amenity_biergarten food_biergarten
icon_alias amenity_cafe food_cafe
icon_alias amenity_drinking_water food_drinkingtap
icon_alias topo_drinking_water topo_water_drinking_water
icon_alias amenity_fast_food food_fastfood
icon_alias amenity_food_court food_food_court
icon_alias amenity_pub food_pub
icon_alias amenity_restaurant food_restaurant
icon_alias man_made_water_well food_water_well
icon_alias topo_water_well topo_water_water_well
icon_alias water_point food_water_point
icon_alias outdoor_seating food_outdoor_seating
icon_alias hookah_lounge food_hookah_lounge

## Seamarks
icon_alias seamark transport_sail_boat
icon seamark_buoy_conical 
icon seamark_buoy_barrel 
icon seamark_buoy_can 
icon seamark_buoy_spherical 
icon seamark_buoy_pillar 

icon seamark_buoy_blackredblack_conical 
icon seamark_buoy_blackredblack_pillar 
icon seamark_buoy_blackredblack_spar 
icon seamark_buoy_blackredblack_spherical 

icon seamark_buoy_red_conical 
icon seamark_buoy_red_barrel 
icon seamark_buoy_red_can 
icon seamark_buoy_red_pillar 
icon seamark_buoy_red_spar 
icon seamark_buoy_red_spherical 
icon seamark_buoy_green_conical 
icon seamark_buoy_green_barrel 
icon seamark_buoy_green_can 
icon seamark_buoy_green_pillar 
icon seamark_buoy_green_spar 
icon seamark_buoy_green_spherical 
icon seamark_buoy_orange_spherical 
icon seamark_buoy_yellow_conical 
icon seamark_buoy_yellow_barrel 
icon seamark_buoy_yellow_can 
icon seamark_buoy_yellow_pillar 
icon seamark_buoy_yellow_spar 
icon seamark_buoy_yellow_spherical 
icon seamark_buoy_yellow_super_buoy 
icon seamark_buoy_white_conical 
icon seamark_buoy_white_barrel 
icon seamark_buoy_white_can 
icon seamark_buoy_white_pillar 
icon seamark_buoy_white_spar 
icon seamark_buoy_white_spherical 
icon seamark_buoy_white_super_buoy 
icon seamark_buoy_whiteyellow_spherical_cross
icon seamark_buoy_yellow_installation

icon seamark_buoy_redwhite_pillar_vertical 
icon seamark_buoy_redwhite_spherical_vertical 
icon seamark_buoy_redwhite_spar_vertical 
icon seamark_buoy_redwhite_spar_horizontal 
icon seamark_buoy_redgreen_spherical_horizontal 
icon seamark_buoy_redgreen_spar_horizontal 
icon seamark_buoy_redwhite_pillar_horizontal 
icon seamark_buoy_blackyellowblack_can 
icon seamark_buoy_blackyellowblack_conical 
icon seamark_buoy_blackyellowblack_pillar 
icon seamark_buoy_blackyellowblack_spar 
icon seamark_buoy_blackyellow_can 
icon seamark_buoy_blackyellow_conical 
icon seamark_buoy_blackyellow_pillar 
icon seamark_buoy_blackyellow_spar 
icon seamark_buoy_yellowblack_can 
icon seamark_buoy_yellowblack_conical 
icon seamark_buoy_yellowblack_pillar 
icon seamark_buoy_yellowblack_spar 
icon seamark_buoy_yellowblackyellow_can 
icon seamark_buoy_yellowblackyellow_conical 
icon seamark_buoy_yellowblackyellow_pillar 
icon seamark_buoy_yellowblackyellow_spar 

icon seamark_buoy_redgreenred_pillar_horizontal 
icon seamark_buoy_redgreenred_can_horizontal 
icon seamark_buoy_redgreenred_spar_horizontal 
icon seamark_buoy_redgreenred_spherical_horizontal 
icon seamark_buoy_redwhiteredwhite_spar_horizontal 
icon seamark_buoy_redwhiteredwhite_can_horizontal 
icon seamark_buoy_redgreenredgreen_spar_horizontal 
icon seamark_buoy_redgreenredgreen_spherical_horizontal 
icon seamark_buoy_redwhitered_can_horizontal 

icon seamark_buoy_whiteredwhitered_spar_horizontal 
icon seamark_buoy_whitegreenwhitegreen_spar_horizontal 
icon seamark_buoy_greenwhite_spar_horizontal 
icon seamark_buoy_greenwhitegreenwhite_conical_horizontal 
icon seamark_buoy_greenwhitegreenwhite_spar_horizontal 

icon seamark_buoy_greenredgreen_conical_horizontal 
icon seamark_buoy_greenredgreen_can_horizontal 
icon seamark_buoy_greenredgreen_pillar_horizontal 
icon seamark_buoy_greenredgreen_spar_horizontal 
icon seamark_buoy_greenredgreen_spherical_horizontal 
icon seamark_buoy_greenred_spar_horizontal 
icon seamark_buoy_greenred_spherical_horizontal 

icon seamark_beacon_pile 
icon seamark_beacon_stake 
icon seamark_beacon_tower 
icon seamark_beacon_cairn 
icon seamark_beacon_pillar 
icon seamark_beacon_perch_port 
icon seamark_beacon_perch_starboard 

icon seamark_beacon_red_perch_port 
icon seamark_beacon_green_perch_port 
icon seamark_beacon_red_perch_starboard 
icon seamark_beacon_green_perch_starboard 

icon seamark_beacon_black_pillar 
icon seamark_beacon_green_pillar 
icon seamark_beacon_green_stake 
icon seamark_beacon_green_tower 
icon seamark_beacon_greenwhitegreenwhite_stake 
icon seamark_beacon_greenwhitegreenwhite_tower 
icon seamark_beacon_greenwhite_stake 
icon seamark_beacon_greenwhite_tower 
icon seamark_beacon_red_pillar 
icon seamark_beacon_red_stake 
icon seamark_beacon_red_tower 
icon seamark_beacon_redwhite_stake 
icon seamark_beacon_redwhite_tower 
icon seamark_beacon_whitegreen_stake 
icon seamark_beacon_whitegreen_tower 
icon seamark_beacon_whitegreenwhitegreen_tower 
icon seamark_beacon_whitered_stake 
icon seamark_beacon_whitered_tower 

icon seamark_beacon_blackyellowblack_tower 
icon seamark_beacon_yellowblackyellow_tower 
icon seamark_beacon_blackyellow_tower 
icon seamark_beacon_yellowblack_tower 
icon seamark_beacon_blackyellowblack_stake 
icon seamark_beacon_yellowblackyellow_stake 
icon seamark_beacon_blackyellow_stake 
icon seamark_beacon_yellowblack_stake 

icon seamark_beacon_blackredblack_tower 
icon seamark_beacon_blackredblack_stake 
icon seamark_beacon_blackredblack_pile 

icon seamark_beacon_yellow_tower 
icon seamark_beacon_yellow_stake 
icon seamark_beacon_yellow_pile 

icon seamark_beacon_white_tower 
icon seamark_beacon_white_stake 
icon seamark_beacon_white_pile 

icon seamark_beacon_black_tower
icon seamark_beacon_whiteredwhiteorange_pile

icon seamark_beacon_redwhite_tower_vertical 
icon seamark_beacon_redwhite_pole_vertical 

icon seamark_light_float_red 
icon seamark_light_float_green 
icon seamark_light_float_redwhite_vertical 
icon seamark_light_minor 
icon seamark_light_major 
icon seamark_light_major_small 
icon seamark_light_vessel 

icon seamark_fog_signal 
icon seamark_radar_transponder 
icon seamark_radio_station 
icon seamark_platform 

icon_alias seamark_platform_small seamark_small_platform_small
icon_alias seamark_landmark_tower seamark_big_landmark_tower
icon_alias seamark_landmark_windmotor seamark_big_landmark_windmotor
icon_alias seamark_landmark_mast seamark_big_landmark_mast
icon_alias seamark_landmark_chimney seamark_big_landmark_chimney
icon_alias seamark_landmark_monument seamark_big_landmark_monument
icon_alias seamark_landmark_flagstaff seamark_big_landmark_flagstaff
icon_alias seamark_landmark_water_tower seamark_big_landmark_water_tower
icon_alias seamark_landmark_dish_aerial seamark_big_landmark_dish_aerial
icon_alias seamark_landmark_windsock seamark_big_landmark_windsock
icon_alias seamark_landmark_cemetery seamark_big_landmark_cemetery
icon_alias seamark_landmark_cross seamark_big_landmark_cross
icon_alias seamark_landmark_statue seamark_big_landmark_statue
icon_alias seamark_landmark_minaret seamark_big_landmark_minaret
icon_alias seamark_landmark_spire_big seamark_big_landmark_spire_big
icon_alias seamark_landmark_dome_big seamark_big_landmark_dome_big
icon_alias seamark_landmark_cairn seamark_big_landmark_cairn

icon_alias seamark_landmark_communication_additional seamark_big_landmark_communication_additional
icon_alias seamark_landmark_church seamark_big_landmark_church
icon_alias seamark_landmark_tower_church_additional seamark_big_landmark_tower_church_additional
icon_alias seamark_landmark_dome seamark_big_landmark_dome
icon_alias seamark_landmark_mosque seamark_big_landmark_mosque
icon_alias seamark_landmark_spire seamark_big_landmark_spire

icon seamark_harbour_default 
icon seamark_harbour_default_small 
icon seamark_harbour_marina 
icon seamark_harbour_fishing 
icon seamark_harbour_container 
icon seamark_harbour_shipyard 
icon seamark_harbour_ferry 

icon seamark_topmark_oblique_red_board 
icon seamark_topmark_oblique_red_conepointdown 
icon seamark_topmark_oblique_red_conepointup 
icon seamark_topmark_oblique_red_cylinder 
icon seamark_topmark_oblique_red_rhombus 
icon seamark_topmark_oblique_red_sphere 
icon seamark_topmark_oblique_red_xshape 
# icon seamark_topmark_oblique_red_conepointupoversphere # Missing
icon seamark_topmark_oblique_red_cylinderoversphere 

icon seamark_topmark_oblique_green_board 
icon seamark_topmark_oblique_green_conepointdown 
icon seamark_topmark_oblique_green_conepointup 
icon seamark_topmark_oblique_green_cylinder 
icon seamark_topmark_oblique_green_sphere 
icon seamark_topmark_oblique_green_xshape 

icon seamark_topmark_oblique_black_conepointdown 
icon seamark_topmark_oblique_black_conepointup 
icon seamark_topmark_oblique_black_cylinder 
icon seamark_topmark_oblique_black_rhombus 
icon seamark_topmark_oblique_black_sphere 
icon seamark_topmark_oblique_black_xshape 

icon seamark_topmark_oblique_yellow_conepointdown 
icon seamark_topmark_oblique_yellow_conepointup 
icon seamark_topmark_oblique_yellow_cylinder 
icon seamark_topmark_oblique_yellow_rhombus 
icon seamark_topmark_oblique_yellow_sphere 
icon seamark_topmark_oblique_yellow_xshape 

icon seamark_topmark_oblique_redwhitered_board 
icon seamark_topmark_oblique_redwhitered_conepointdown 
icon seamark_topmark_oblique_redwhitered_cylinder 
icon seamark_topmark_oblique_whitered_board_border 

icon seamark_topmark_oblique_black_2conesbasetogether
icon seamark_topmark_oblique_black_2conesdown
icon seamark_topmark_oblique_black_2conespointtogether
icon seamark_topmark_oblique_black_2conesup
icon seamark_topmark_oblique_black_2spheres
icon seamark_topmark_oblique_yellow_2conespointtogether

icon seamark_topmark_vertical_black_2conesbasetogether 
icon seamark_topmark_vertical_black_2conesdown 
icon seamark_topmark_vertical_black_2conespointtogether 
icon seamark_topmark_vertical_black_2conesup 

icon seamark_topmark_vertical_black_2spheres 
icon seamark_topmark_vertical_black_conepointdown 
icon seamark_topmark_vertical_black_conepointup 
icon seamark_topmark_vertical_black_cylinder 
icon seamark_topmark_vertical_black_rhombus 
icon seamark_topmark_vertical_black_sphere 
icon seamark_topmark_vertical_black_xshape 

icon seamark_topmark_vertical_green_board
icon seamark_topmark_vertical_green_conepointdown
icon seamark_topmark_vertical_green_conepointup
icon seamark_topmark_vertical_green_cylinder
icon seamark_topmark_vertical_green_sphere
icon seamark_topmark_vertical_green_xshape

icon seamark_topmark_vertical_greenwhite_rhombus_vertical

icon seamark_topmark_vertical_red_board 
icon seamark_topmark_vertical_red_conepointdown 
icon seamark_topmark_vertical_red_conepointup 
icon seamark_topmark_vertical_red_cylinder 
icon seamark_topmark_vertical_red_rhombus 
icon seamark_topmark_vertical_red_sphere 
icon seamark_topmark_vertical_red_xshape 
icon seamark_topmark_vertical_redwhitered_board 
icon seamark_topmark_vertical_redwhitered_conepointdown 
icon seamark_topmark_vertical_redwhitered_cylinder 

icon seamark_topmark_vertical_whitered_board_border 
icon seamark_topmark_vertical_whitered_conepointdown_border 
icon seamark_topmark_vertical_whitegreen_rhombus_border 
icon seamark_topmark_vertical_whiteblack_board_border 
icon seamark_topmark_vertical_whiteblackwhite_rhombus_vertical 

icon seamark_topmark_vertical_yellow_2conespointtogether 
icon seamark_topmark_vertical_yellow_conepointdown 
icon seamark_topmark_vertical_yellow_conepointup 
icon seamark_topmark_vertical_yellow_cylinder 
icon seamark_topmark_vertical_yellow_rhombus 
icon seamark_topmark_vertical_yellow_sphere 
icon seamark_topmark_vertical_yellow_xshape 
icon seamark_topmark_vertical_yellow_cross 

icon_alias seamark_topmark_vertical_black_2conesbasetogether_big seamark_big_topmark_vertical_black_2conesbasetogether_big
icon_alias seamark_topmark_vertical_black_2conesdown_big seamark_big_topmark_vertical_black_2conesdown_big
icon_alias seamark_topmark_vertical_black_2conespointtogether_big seamark_big_topmark_vertical_black_2conespointtogether_big
icon_alias seamark_topmark_vertical_black_2conesup_big seamark_big_topmark_vertical_black_2conesup_big

icon_alias seamark_topmark_vertical_black_2spheres_big seamark_big_topmark_vertical_black_2spheres_big
icon_alias seamark_topmark_vertical_black_conepointdown_big seamark_big_topmark_vertical_black_conepointdown_big
icon_alias seamark_topmark_vertical_black_conepointup_big seamark_big_topmark_vertical_black_conepointup_big
icon_alias seamark_topmark_vertical_black_cylinder_big seamark_big_topmark_vertical_black_cylinder_big
icon_alias seamark_topmark_vertical_black_rhombus_big seamark_big_topmark_vertical_black_rhombus_big
icon_alias seamark_topmark_vertical_black_sphere_big seamark_big_topmark_vertical_black_sphere_big
icon_alias seamark_topmark_vertical_black_xshape_big seamark_big_topmark_vertical_black_xshape_big

icon_alias seamark_fog_signal_additional_big seamark_big_fog_signal_additional_big
icon_alias seamark_fog_signal_additional_big_night seamark_big_fog_signal_additional_big_night
icon_alias seamark_fog_signal_additional_center_big seamark_big_fog_signal_additional_center_big
icon_alias seamark_fog_signal_additional_center_big_night seamark_big_fog_signal_additional_center_big_night
icon_alias seamark_fog_signal_additional seamark_fog_signal_additional
icon_alias seamark_fog_signal_additional_night seamark_fog_signal_additional_night

icon seamark_radar_reflector_additional
icon seamark_radar_reflector_additional_night 
icon_alias seamark_radar_reflector_additional_big seamark_big_radar_reflector_additional_big
icon_alias seamark_radar_reflector_additional_big_night seamark_big_radar_reflector_additional_big_night
icon_alias seamark_radar_reflector_additional_center_big seamark_big_radar_reflector_additional_center_big
icon_alias seamark_radar_reflector_additional_center_big_night seamark_big_radar_reflector_additional_center_big_night

icon seamark_radar_transponder_additional
icon seamark_radar_transponder_additional_night
icon_alias seamark_radar_transponder_additional_big seamark_big_radar_transponder_additional_big
icon_alias seamark_radar_transponder_additional_big_night seamark_big_radar_transponder_additional_big_night
icon_alias seamark_radar_transponder_additional_center_big seamark_big_radar_transponder_additional_center_big
icon_alias seamark_radar_transponder_additional_center_big_night seamark_big_radar_transponder_additional_center_big_night
icon_alias seamark_radio_station_ais_additional seamark_big_radio_station_ais_additional
icon_alias seamark_radio_station_omnidirectional_additional seamark_big_radio_station_omnidirectional_additional
icon_alias seamark_radio_station_aeronautical_additional seamark_big_radio_station_aeronautical_additional
icon_alias seamark_radio_station_dgps_additional seamark_big_radio_station_dgps_additional
icon_alias seamark_radio_station_vais_additional seamark_big_radio_station_vais_additional
icon_alias seamark_signal_station_additional seamark_big_signal_station_additional
icon_alias seamark_radar_station_additional seamark_big_radar_station_additional
icon_alias seamark_radar_station_additional_night seamark_big_radar_station_additional_night
icon_alias seamark_radar_station_coast_additional seamark_big_radar_station_coast_additional
icon_alias seamark_radar_station_surveillance_additional seamark_big_radar_station_surveillance_additional
icon_alias seamark_radar_station_surveillance_additional_night seamark_big_radar_station_surveillance_additional_night

icon seamark_platform_production_additional 
icon seamark_platform_fpso_additional 

icon seamark_separation_line_arrow 
icon seamark_separation_line_arrow_night 
icon seamark_separation_line_arrow_small 
icon seamark_separation_line_arrow_small_night 

icon seamark_gate 
icon seamark_lock_gate 
icon seamark_hulk 
icon seamark_hulk_restaurant_additional 

icon seamark_anchorage 
icon seamark_anchorage_small_craft 
icon seamark_anchorage_tanker 
icon seamark_anchor_berth 
icon seamark_berth 

icon seamark_bridge 
icon seamark_bridge_opening 
icon seamark_bridge_lifting 
icon seamark_bridge_suspension 

icon seamark_building 
icon seamark_building_church 
icon seamark_building_customs 
icon seamark_building_harbour_master 
icon seamark_building_water_police_station 

icon seamark_notice_prohibition_bg 
icon seamark_notice_prohibition_bg_plus 
icon seamark_notice_prohibition_bg_night 
icon seamark_notice_prohibition_bg_plus_night 
icon seamark_notice_prohibition_noentry 
icon seamark_notice_prohibition_closedarea 
icon seamark_notice_prohibition_noovertaking 
icon seamark_notice_prohibition_noconvoyovertaking 
icon seamark_notice_prohibition_nopassing 
icon seamark_notice_prohibition_noconvoypassing 
icon seamark_notice_prohibition_noberthing 
icon seamark_notice_prohibition_noanchoring 
icon seamark_notice_prohibition_nomooring 
icon seamark_notice_prohibition_noturning 
icon seamark_notice_prohibition_nowash 
icon seamark_notice_prohibition_nopassageleft 
icon seamark_notice_prohibition_nopassageright 
icon seamark_notice_prohibition_nomotorcraft 
icon seamark_notice_prohibition_nosportcraft 
icon seamark_notice_prohibition_nowaterskiing 
icon seamark_notice_prohibition_nosailingcraft 
icon seamark_notice_prohibition_nounpoweredcraft 
icon seamark_notice_prohibition_nosailboards 
icon seamark_notice_prohibition_nohighspeeds 
icon seamark_notice_prohibition_nolaunchingbeaching 
icon seamark_notice_prohibition_nowaterbikes 

icon seamark_notice_regulation_bg 
icon seamark_notice_regulation_bg_plus 
icon seamark_notice_regulation_bg_night 
icon seamark_notice_regulation_bg_plus_night 
icon seamark_notice_regulation_crosstoport 
icon seamark_notice_regulation_crosstostarboard 
icon seamark_notice_regulation_givewaycrossing 
icon seamark_notice_regulation_givewayjunction 
icon seamark_notice_regulation_keeplookout 
icon seamark_notice_regulation_keeptoport 
icon seamark_notice_regulation_keeptostarboard 
icon seamark_notice_regulation_makeradiocontact 
icon seamark_notice_regulation_movetoleft 
icon seamark_notice_regulation_movetoport 
icon seamark_notice_regulation_movetoright 
icon seamark_notice_regulation_movetostarboard 
icon seamark_notice_regulation_speedlimit 
icon seamark_notice_regulation_soundhorn 
icon seamark_notice_regulation_stop 

icon seamark_notice_restriction_channeldistanceleft 
icon seamark_notice_restriction_channeldistanceright 
icon seamark_notice_restriction_limiteddepth 
icon seamark_notice_restriction_limitedheadroom 
icon seamark_notice_restriction_limitedwidth 

icon seamark_notice_recommendation_channeltwoway 
icon seamark_notice_recommendation_channeloneway 
icon seamark_notice_recommendation_openingtoleft 
icon seamark_notice_recommendation_openingtoright 
icon seamark_notice_recommendation_proceedtoleft 
icon seamark_notice_recommendation_proceedtoright 

icon seamark_notice_information_bg 
icon seamark_notice_information_bg_plus 
icon seamark_notice_information_entrypermitted 
icon seamark_notice_information_overheadcable 
icon seamark_notice_information_weir 
icon seamark_notice_information_ferrynonindependent 
icon seamark_notice_information_ferryindependent 
icon seamark_notice_information_berthingpermitted 
icon seamark_notice_information_berthingunmarkedpushing 
icon seamark_notice_information_berthingmarkedpushing1 
icon seamark_notice_information_berthingmarkedpushing2 
icon seamark_notice_information_berthingmarkedpushing3 
icon seamark_notice_information_berthingunmarkednonpushing 
icon seamark_notice_information_berthingmarkednonpushing1 
icon seamark_notice_information_berthingmarkednonpushing2 
icon seamark_notice_information_berthingmarkednonpushing3 
icon seamark_notice_information_berthingunmarked 
icon seamark_notice_information_berthingmarked1 
icon seamark_notice_information_berthingmarked2 
icon seamark_notice_information_berthingmarked3 
icon seamark_notice_information_anchoringpermitted 
icon seamark_notice_information_mooringpermitted 
icon seamark_notice_information_vehicleloadingberth 
icon seamark_notice_information_turningarea 
icon seamark_notice_information_secondarywaterwaycrossing 
icon seamark_notice_information_secondarywaterwayright 
icon seamark_notice_information_secondarywaterwayleft 
icon seamark_notice_information_mainwaterwayleftsecondaryahead 
icon seamark_notice_information_mainwaterwayrightsecondaryleft 
icon seamark_notice_information_mainwaterwayleftsecondaryright 
icon seamark_notice_information_mainwaterwayrightsecondaryahead 
icon seamark_notice_information_mainwaterwayleftsecondaryaheadright 
icon seamark_notice_information_mainwaterwayrightsecondaryaheadleft 
icon seamark_notice_information_mainwaterwaycrossing 
icon seamark_notice_information_mainwaterwayjunction 
icon seamark_notice_information_mainwaterwayaheadright 
icon seamark_notice_information_mainwaterwayaheadleft 
icon seamark_notice_information_mainwaterwayaheadrightsecondaryleft 
icon seamark_notice_information_mainwaterwayaheadleftsecondaryright 
icon seamark_notice_information_prohibitionends 
icon seamark_notice_information_drinkingwater 
icon seamark_notice_information_telephone 
icon seamark_notice_information_motorcraftpermitted 
icon seamark_notice_information_sportcraftpermitted 
icon seamark_notice_information_waterskiingpermitted 
icon seamark_notice_information_sailingcraftpermitted 
icon seamark_notice_information_unpoweredcraftpermitted 
icon seamark_notice_information_sailboardspermitted 
icon seamark_notice_information_highspeedspermitted 
icon seamark_notice_information_launchingbeachingpermitted 
icon seamark_notice_information_radioinformation 
icon seamark_notice_information_waterbikespermitted 

icon seamark_notice_addition_leftboard 
icon seamark_notice_addition_lefttriangle 
icon seamark_notice_addition_topboard 
icon seamark_notice_addition_toptriangle 
icon seamark_notice_addition_rightboard 
icon seamark_notice_addition_righttriangle 
icon seamark_notice_addition_bottomboard 
icon seamark_notice_addition_bottomtriangle 

icon seamark_notice_impact_banktobank 
icon seamark_notice_impact_downstream 
icon seamark_notice_impact_leftbank 
icon seamark_notice_impact_rightbank 
icon seamark_notice_impact_upstream 
icon seamark_notice_impact_upstreamdownstream 
icon seamark_notice_impact_upstreamdownstreamleftbank 
icon seamark_notice_impact_upstreamdownstreamrightbank 
icon seamark_notice_impact_downstreamleftbank 

icon seamark_notice_orientation_0 
icon seamark_notice_orientation_45 
icon seamark_notice_orientation_90 
icon seamark_notice_orientation_135 
icon seamark_notice_orientation_180 
icon seamark_notice_orientation_225 
icon seamark_notice_orientation_270 
icon seamark_notice_orientation_315 

icon seamark_mooring_bollard 
icon seamark_mooring_deviationdolphin 
icon seamark_mooring_dolphin 
icon seamark_mooring_pile 
icon seamark_mooring_pylon 
icon seamark_mooring_wall 
icon seamark_mooring_additional_for_buoy 

icon_alias seamark_small_craft_facility_boat_hoist seamark_big_small_craft_facility_boat_hoist
icon_alias seamark_small_craft_facility_boatyard seamark_big_small_craft_facility_boatyard
icon_alias seamark_small_craft_facility_chandler seamark_big_small_craft_facility_chandler
icon_alias seamark_small_craft_facility_electricity seamark_big_small_craft_facility_electricity
icon_alias seamark_small_craft_facility_fuel_station seamark_big_small_craft_facility_fuel_station
icon_alias seamark_small_craft_facility_laundrette seamark_big_small_craft_facility_laundrette
icon_alias seamark_small_craft_facility_nautical_club seamark_big_small_craft_facility_nautical_club
icon_alias seamark_small_craft_facility_public_inn seamark_big_small_craft_facility_public_inn
icon_alias seamark_small_craft_facility_pump_out seamark_big_small_craft_facility_pump_out
icon_alias seamark_small_craft_facility_pump_out2 seamark_big_small_craft_facility_pump_out2
icon_alias seamark_small_craft_facility_restaurant seamark_big_small_craft_facility_restaurant
icon_alias seamark_small_craft_facility_showers seamark_big_small_craft_facility_showers
icon_alias seamark_small_craft_facility_slipway seamark_big_small_craft_facility_slipway
icon_alias seamark_small_craft_facility_toilets seamark_big_small_craft_facility_toilets
icon_alias seamark_small_craft_facility_toilets2 seamark_big_small_craft_facility_toilets2
icon_alias seamark_small_craft_facility_visitor_berth seamark_big_small_craft_facility_visitor_berth
icon_alias seamark_small_craft_facility_visitors_mooring seamark_big_small_craft_facility_visitors_mooring
icon_alias seamark_small_craft_facility_water_tap seamark_big_small_craft_facility_water_tap
icon_alias seamark_small_craft_facility_shield2 seamark_big_small_craft_facility_shield2

icon_alias seamark_restricted_area_kite_surfing seamark_small_restricted_area_kite_surfing
icon_alias seamark_restricted_area_swimming seamark_small_restricted_area_swimming
icon_alias seamark_restricted_area_fish_sanctuary seamark_small_restricted_area_fish_sanctuary
icon_alias seamark_restricted_area_water_skiing seamark_small_restricted_area_water_skiing
icon seamark_restriction_fishing 
icon seamark_restriction_drilling 
icon seamark_restriction_to_be_avoided 
icon seamark_restriction_discharging 
icon seamark_restriction_exploration_development 

## Seamarks int1
icon_alias seamark_j132_weedkelp seamark_int1_seamark_j132_weedkelp
icon_alias seamark_j134_seagrass seamark_int1_seamark_j134_seagrass
icon_alias seamark_j14_sand_waves seamark_int1_seamark_j14_sand_waves
icon_alias seamark_j15_spring seamark_int1_seamark_j15_spring
icon_alias seamark_j21_rocky seamark_int1_seamark_j21_rocky
icon_alias seamark_j22_coral seamark_int1_seamark_j22_coral
icon_alias seamark_k311_foul_ground seamark_int1_seamark_k311_foul_ground

icon_alias seamark_j14_sand_waves_night seamark_int1_seamark_j14_sand_waves_night
icon_alias seamark_j15_spring_night seamark_int1_seamark_j15_spring_night
icon_alias seamark_k311_foul_ground_night seamark_int1_seamark_k311_foul_ground_night

icon_alias seamark_obstruction_foul_ground seamark_small_obstruction_foul_ground
icon_alias seamark_obstruction_boom seamark_small_obstruction_boom
icon_alias seamark_obstruction_construction seamark_small_obstruction_construction
icon_alias seamark_distance_mark seamark_small_distance_mark
icon_alias seamark_distance_mark_installed seamark_small_distance_mark_installed
icon seamark_fishing_facility 
icon seamark_marine_farm 
icon seamark_marine_farm_crustaceans_additional 
icon seamark_marine_farm_fish_additional 
icon seamark_marine_farm_oysters_mussels_additional 
icon seamark_marine_farm_seaweed_additional 
icon seamark_pilot_boarding 
icon seamark_pylon 
icon seamark_pylon_power 
icon seamark_radar_reflector 
icon seamark_waterfall 
icon seamark_rescue_station 
icon_alias seamark_seaplane_landing_area seamark_small_seaplane_landing_area

icon seamark_rock_awash 
icon seamark_rock_covers 
icon seamark_rock_submerged 
icon seamark_waterway_gauge 
icon seamark_wreck 
icon seamark_wreck_hull_showing 
icon_alias seamark_power_line seamark_small_power_line
icon_alias seamark_submarine_cable seamark_small_submarine_cable
icon seamark_obstruction_stump 

## Skimap
icon skimap_overlay_advanced 
icon skimap_overlay_easy 
icon skimap_overlay_expert 
icon skimap_overlay_extreme 
icon skimap_overlay_freeride 
icon skimap_overlay_intermediate 
icon skimap_overlay_novice 
icon skimap_gray_black_round_shield 
icon skimap_white_black_round_shield 

icon_alias piste entertainment_piste
icon_alias piste_downhill skimap_piste_downhill
icon_alias piste_hike skimap_piste_hike
icon_alias piste_nordic skimap_piste_nordic
# icon_alias piste_nordic_black skimap_piste_nordic_black
# icon_alias piste_nordic_blue skimap_piste_nordic_blue
# icon_alias piste_nordic_brown skimap_piste_nordic_brown
# icon_alias piste_nordic_darkyellow skimap_piste_nordic_darkyellow
# icon_alias piste_nordic_gray skimap_piste_nordic_gray
# icon_alias piste_nordic_green skimap_piste_nordic_green
# icon_alias piste_nordic_lightblue skimap_piste_nordic_lightblue
# icon_alias piste_nordic_lightgreen skimap_piste_nordic_lightgreen
# icon_alias piste_nordic_orange skimap_piste_nordic_orange
# icon_alias piste_nordic_purple skimap_piste_nordic_purple
# icon_alias piste_nordic_red skimap_piste_nordic_red
# icon_alias piste_nordic_yellow skimap_piste_nordic_yellow
icon_alias piste_skitour skimap_piste_skitour
icon_alias piste_sled skimap_piste_sled
icon_alias piste_intermediate_difficulty skimap_piste_intermediate_difficulty
icon_alias piste_high_difficulty skimap_piste_high_difficulty
icon_alias piste_gladed_yes skimap_piste_gladed_yes


## Shops
icon_alias car_aid shopping_car
icon_alias food_shop shopping_convenience
icon_alias shop shopping_department_store
icon_alias shop_food shopping_convenience
icon_alias amenity_marketplace shopping_marketplace
icon_alias amenity_vending_machine shopping_vending_machine
icon_alias shop_alcohol shopping_alcohol
icon_alias shop_baby_goods shopping_baby
icon_alias shop_bakery shopping_bakery
icon_alias shop_bicycle shopping_bicycle
icon_alias beverages shopping_beverages
icon_alias shop_books shopping_book2
icon_alias shop_boutique shopping_clothes
icon_alias shop_butcher shopping_butcher2
icon_alias shop_car_parts shopping_car_parts
icon_alias shop_car_repair shopping_car_repair
icon_alias shop_car shopping_car
icon_alias shop_clothes shopping_clothes
icon_alias clothes_children shopping_clothes_children
icon_alias shop_computer shopping_computer
icon_alias shop_confectionery shopping_confectionery
icon_alias shop_convenience shopping_convenience
icon_alias shop_copyshop shopping_copyshop
icon_alias shop_dairy shopping_dairy
icon_alias shop_department_store shopping_department_store
icon_alias shop_doityourself shopping_diy
icon_alias electronics shopping_electronics
icon_alias hifi shopping_hifi
icon_alias shop_fishing shopping_tackle
icon_alias shop_florist shopping_florist
icon_alias flooring shopping_flooring
icon_alias shop_furniture shopping_furniture
icon_alias shop_garden_centre shopping_garden_centre
icon_alias shop_yes shopping_general
icon_alias shop_gift shopping_gift
icon_alias shop_greengrocer shopping_greengrocer
icon_alias shop_hairdresser shopping_hairdresser
icon_alias shop_hardware shopping_diy
icon_alias shop_hearing_aids shopping_hearing_aids
icon_alias ice_cream food_ice_cream
icon_alias shop_jewelry shopping_jewelry2
icon_alias shop_kiosk shopping_kiosk
icon_alias shop_laundry shopping_laundrette
icon_alias shop_mall shopping_mall
icon_alias shop_mobile_phone shopping_mobile_phone
icon_alias shop_motorcycle shopping_motorcycle
icon_alias motorcycle_repair shopping_motorcycle_repair
icon_alias shop_musical_instrument shopping_musical_instrument
icon_alias shop_optician shopping_opticians
icon_alias shop_pet shopping_pet2
icon_alias photo shopping_photo
icon_alias shop_seafood shopping_fish
icon_alias shop_shoes shopping_shoes
icon_alias shop_sports shopping_sports
icon_alias shop_supermarket shopping_supermarket
icon_alias shop_ticket shopping_ticket
icon_alias shop_tobacco shopping_tobacco
icon_alias shop_toys shopping_toys
icon_alias shop_video shopping_video_rental
icon_alias wine shopping_wine
icon_alias outdoor shopping_outdoor
icon_alias tyres shopping_tyres
icon_alias cosmetics shopping_cosmetics
icon_alias leather shopping_leather
icon_alias medical_supply shopping_medical_supply
icon_alias cheese shopping_cheese
icon_alias chocolate shopping_chocolate
icon_alias coffee shopping_coffee
icon_alias farm shopping_farm
icon_alias tea shopping_tea
icon_alias telecommunication shopping_telecommunication
icon_alias pastry shopping_pastry
icon_alias antiques shopping_antiques
icon_alias bag shopping_bag
icon_alias bed shopping_bed
icon_alias boutique shopping_boutique
icon_alias bathroom_furnishing shopping_bathroom_furnishing
icon_alias camera shopping_camera
icon_alias carpet shopping_carpet
icon_alias chemist shopping_chemist
icon_alias curtain shopping_curtain
icon_alias fabric shopping_fabric
icon_alias bedding shopping_bedding
icon_alias erotic shopping_erotic
icon_alias frame shopping_frame
icon_alias free_flying shopping_free_flying
icon_alias furnace shopping_furnace
icon_alias gas shopping_gas
icon_alias glaziery shopping_glaziery
icon_alias herbalist shopping_herbalist
icon_alias houseware shopping_houseware
icon_alias hunting shopping_hunting
icon_alias beauty shopping_beauty
icon_alias interior_decoration shopping_interior_decoration
icon_alias art shopping_art
icon_alias model shopping_model
icon_alias music shopping_music
icon_alias newsagent shopping_newsagent
icon_alias paint shopping_paint
icon_alias radiotechnics shopping_radiotechnics
icon_alias scuba_diving_shop shopping_scuba_diving_shop
icon_alias stationery shopping_stationery
#icon_alias tableware shopping_tableware
icon_alias trophy shopping_trophy
icon_alias trade shopping_trade
icon_alias vacuum_cleaner shopping_vacuum_cleaner
icon_alias tattoo shopping_tattoo
icon_alias perfumery shopping_perfumery
icon_alias pawnbroker shopping_pawnbroker
icon_alias second_hand shopping_second_hand
icon_alias honey shopping_honey
icon_alias charity shopping_charity
icon_alias energy shopping_energy
icon_alias variety_store shopping_variety_store
icon_alias kitchen shopping_kitchen
icon_alias video_games shopping_video_games
icon_alias pyrotechnics shopping_pyrotechnics
icon_alias weapons shopping_weapons
icon_alias window_blind shopping_window_blind
icon_alias watches shopping_watches
icon_alias candles shopping_candles
icon_alias religion shopping_religion
icon_alias games shopping_games
icon_alias doors shopping_doors
icon_alias sewing shopping_sewing
icon_alias spices shopping_spices
icon_alias shop_craft shopping_craft
icon_alias party shopping_party
icon_alias deli shopping_deli
icon_alias electrical shopping_electrical
icon_alias locksmith shopping_locksmith
icon_alias lighting shopping_lighting
icon_alias lottery shopping_lottery
icon_alias e_cigarette shopping_e_cigarette
icon_alias nutrition_supplements shopping_nutrition_supplements
icon_alias photo_studio shopping_photo_studio
icon_alias frozen_food shopping_frozen_food
icon_alias agrarian shopping_agrarian
icon_alias shop_fireplace shopping_fireplace
icon_alias shop_boat shopping_boat
icon_alias cannabis shopping_cannabis
icon_alias pottery shopping_pottery
icon_alias outpost shopping_outpost
icon_alias appliance shopping_appliance
icon_alias shoe_repair shopping_shoe_repair
icon_alias shop_wholesale shopping_wholesale
icon_alias health_food shopping_health_food
icon_alias pet_grooming shopping_pet_grooming
icon_alias shop_security shopping_security
icon_alias dive shopping_dive
icon_alias nuts shopping_nuts
icon_alias pest_control shopping_pest_control
icon_alias groundskeeping shopping_groundskeeping
icon_alias country_store shopping_country_store
icon_alias tool_hire shopping_tool_hire
icon_alias collector shopping_collector
icon_alias skate shopping_skate
icon_alias tiles shopping_tiles
icon_alias hairdresser_supply shopping_hairdresser_supply
icon_alias shop_fuel shopping_fuel
icon_alias printer_ink shopping_printer_ink
icon_alias water_sports shopping_water_sports
icon_alias rice shopping_rice
icon_alias motorcycle_parts shopping_motorcycle_parts
icon_alias wool shopping_wool

## Office
icon_alias estate_agent office_estate_agent
icon_alias insurance office_insurance
icon_alias research office_research
icon_alias travel_agent office_travel_agent
icon_alias it office_it
icon_alias office_government office_government
icon_alias company office_company
icon_alias advertising_agency office_advertising_agency
icon_alias employment_agency office_employment_agency
icon_alias lawyer office_lawyer
icon_alias ngo office_ngo
icon_alias political_party office_political_party
icon_alias office_telecommunication office_telecommunication
icon_alias accountant office_accountant
icon_alias architect office_architect
icon_alias office_camping office_camping
icon_alias educational_institution office_educational_institution
icon_alias office_foundation office_foundation
icon_alias guide office_guide
icon_alias newspaper office_newspaper
icon_alias quango office_quango
icon_alias tax_advisor office_tax_advisor
icon_alias consulting office_consulting
icon_alias cooperative office_cooperative
icon_alias financial office_financial
icon_alias forestry office_forestry
icon_alias logistics office_logistics
icon_alias notary office_notary
icon_alias parish office_parish
icon_alias publisher office_publisher
icon_alias water_utility office_water_utility
icon_alias energy_supplier office_energy_supplier
icon_alias office_religion office_religion

## Entertainment
icon_alias park entertainment_colored_park
icon_alias dance_floor entertainment_dance_floor
icon_alias dog_park entertainment_dog_park
icon_alias ski_resort entertainment_ski_resort
icon_alias bandstand entertainment_bandstand
icon_alias stands entertainment_stands

## Club
icon_alias club_sport club_sport
icon_alias club_music club_music
icon_alias club_scout club_scout
icon_alias club_social club_social
icon_alias club_automobile club_automobile
icon_alias club_veterans club_veterans
icon_alias club_sailing club_sailing
icon_alias club_fishing club_fishing
icon_alias club_shooting club_shooting
icon_alias club_motorcycle club_motorcycle
icon_alias club_game club_game
icon_alias club_youth_movement club_youth_movement
icon_alias club_amateur_radio club_amateur_radio
icon_alias club_religion club_religion
icon_alias club_tourism club_tourism
icon_alias club_dog club_dog
icon_alias club_history club_history
icon_alias club_nature club_nature
icon_alias club_chess club_chess
icon_alias club_cinema club_cinema
icon_alias club_hunting club_hunting
icon_alias club_aviation club_aviation
icon_alias club_bicycle club_bicycle
icon_alias club_doityourself club_doityourself
icon_alias club_ethnic club_ethnic
icon_alias club_computer club_computer
icon_alias club_freemasonry club_freemasonry

icon_alias hazard_yes hazard_hazard
icon_alias hazard_nuclear_map hazard_hazard_nuclear
icon_alias hazard_erosion_map hazard_hazard_erosion
icon_alias hazard_slippery_road_map hazard_hazard_slippery_road
icon_alias hazard_flood_map hazard_hazard_flood
icon_alias hazard_avalanche_map hazard_hazard_avalanche
icon_alias hazard_minefield_map hazard_hazard_minefield
icon_alias hazard_nuclear poi_hazard_nuclear
icon_alias hazard_erosion poi_hazard_erosion
icon_alias hazard_slippery_road poi_hazard_slippery_road
icon_alias hazard_flood poi_hazard_flood
icon_alias hazard_avalanche poi_hazard_avalanche
icon_alias hazard_minefield poi_hazard_minefield
icon_alias hazard poi_hazard

# icon_alias custom_id icons8 
icon_alias user_defined special_person
icon_alias user_defined_other special_person
icon_alias osmwiki logos_wikipedia
icon_alias wiki_place poi_colored_wikipedia2
icon_alias name_finder special_search
icon_alias osmand_waypoint functional-icons_waypoint
icon_alias osmand_fav functional-icons_fav
icon_alias null special_worldwide_location

icon_alias stub_amenity functional-icons_stub_amenity
icon_alias stub_club functional-icons_stub_club
icon_alias stub_craft functional-icons_stub_craft
icon_alias stub_emergency functional-icons_stub_emergency
icon_alias stub_healthcare functional-icons_stub_healthcare
icon_alias stub_historic functional-icons_stub_historic
icon_alias stub_office functional-icons_stub_office
icon_alias stub_man_made functional-icons_stub_man_made
icon_alias stub_shop functional-icons_stub_shop
icon_alias stub_tourism functional-icons_stub_tourism

#OSMC
icon_alias_no_mx osmc_black_arch osmc_black_arch
icon_alias_no_mx osmc_black_arrow osmc_black_arrow
icon_alias_no_mx osmc_black_backslash osmc_black_backslash
icon_alias_no_mx osmc_black_bar osmc_black_bar
icon_alias_no_mx osmc_black_bar_2 osmc_black_bar_2
icon_alias_no_mx osmc_black_bar_3 osmc_black_bar_3
icon_alias_no_mx osmc_black_bar_4 osmc_black_bar_4
icon_alias_no_mx osmc_black_bicycle osmc_black_bicycle
icon_alias_no_mx osmc_black_bowl osmc_black_bowl
icon_alias_no_mx osmc_black_circle osmc_black_circle
icon_alias_no_mx osmc_black_circle_arrow osmc_black_circle_arrow
icon_alias_no_mx osmc_black_corner osmc_black_corner
icon_alias_no_mx osmc_black_corner_left osmc_black_corner_left
icon_alias_no_mx osmc_black_cross osmc_black_cross
icon_alias_no_mx osmc_black_cross_2 osmc_black_cross_2
icon_alias_no_mx osmc_black_cross_3 osmc_black_cross_3
icon_alias_no_mx osmc_black_cross_4 osmc_black_cross_4
icon_alias_no_mx osmc_black_diamond osmc_black_diamond
icon_alias_no_mx osmc_black_diamond_corner osmc_black_diamond_corner
icon_alias_no_mx osmc_black_diamond_line osmc_black_diamond_line
icon_alias_no_mx osmc_black_diamond_left osmc_black_diamond_left
icon_alias_no_mx osmc_black_diamond_right osmc_black_diamond_right
icon_alias_no_mx osmc_black_dot osmc_black_dot
icon_alias_no_mx osmc_black_dot_2 osmc_black_dot_2
icon_alias_no_mx osmc_black_dot_3 osmc_black_dot_3
icon_alias_no_mx osmc_black_dot_4 osmc_black_dot_4
icon_alias_no_mx osmc_black_drop_line osmc_black_drop_line
icon_alias_no_mx osmc_black_drop osmc_black_drop
icon_alias_no_mx osmc_black_crest osmc_black_crest
icon_alias_no_mx osmc_black_fork osmc_black_fork
icon_alias_no_mx osmc_black_hexagon osmc_black_hexagon
icon_alias_no_mx osmc_black_hiker osmc_black_hiker
icon_alias_no_mx osmc_black_house osmc_black_house
icon_alias_no_mx osmc_black_l osmc_black_l
icon_alias_no_mx osmc_black_left osmc_black_left
icon_alias_no_mx osmc_black_left_pointer osmc_black_left_pointer
icon_alias_no_mx osmc_black_left_pointer_2 osmc_black_left_pointer_2
icon_alias_no_mx osmc_black_left_pointer_3 osmc_black_left_pointer_3
icon_alias_no_mx osmc_black_left_pointer_4 osmc_black_left_pointer_4
icon_alias_no_mx osmc_black_m osmc_black_m
icon_alias_no_mx osmc_black_lower osmc_black_lower
icon_alias_no_mx osmc_black_lower_2 osmc_black_lower_2
icon_alias_no_mx osmc_black_lower_3 osmc_black_lower_3
icon_alias_no_mx osmc_black_lower_4 osmc_black_lower_4
icon_alias_no_mx osmc_black_pointer osmc_black_pointer
icon_alias_no_mx osmc_black_pointer_2 osmc_black_pointer_2
icon_alias_no_mx osmc_black_pointer_3 osmc_black_pointer_3
icon_alias_no_mx osmc_black_pointer_4 osmc_black_pointer_4
icon_alias_no_mx osmc_black_pointer_line osmc_black_pointer_line
icon_alias_no_mx osmc_black_pointer_line_2 osmc_black_pointer_line_2
icon_alias_no_mx osmc_black_pointer_line_3 osmc_black_pointer_line_3
icon_alias_no_mx osmc_black_pointer_line_4 osmc_black_pointer_line_4
icon_alias_no_mx osmc_black_red_diamond osmc_black_red_diamond
icon_alias_no_mx osmc_black_rectangle osmc_black_rectangle
icon_alias_no_mx osmc_black_rectangle_2 osmc_black_rectangle_2
icon_alias_no_mx osmc_black_rectangle_3 osmc_black_rectangle_3
icon_alias_no_mx osmc_black_rectangle_4 osmc_black_rectangle_4
icon_alias_no_mx osmc_black_rectangle_line osmc_black_rectangle_line
icon_alias_no_mx osmc_black_rectangle_lower osmc_black_rectangle_lower
icon_alias_no_mx osmc_black_rectangle_lower_2 osmc_black_rectangle_lower_2
icon_alias_no_mx osmc_black_rectangle_lower_3 osmc_black_rectangle_lower_3
icon_alias_no_mx osmc_black_rectangle_lower_4 osmc_black_rectangle_lower_4
icon_alias_no_mx osmc_black_right osmc_black_right
icon_alias_no_mx osmc_black_right_arrow osmc_black_arrow
icon_alias_no_mx osmc_black_right_pointer osmc_black_pointer
icon_alias_no_mx osmc_black_right_pointer_2 osmc_black_pointer_2
icon_alias_no_mx osmc_black_right_pointer_3 osmc_black_pointer_3
icon_alias_no_mx osmc_black_right_pointer_4 osmc_black_pointer_4
icon_alias_no_mx osmc_black_slash osmc_black_slash
icon_alias_no_mx osmc_black_stripe osmc_black_stripe
icon_alias_no_mx osmc_black_stripe_2 osmc_black_stripe_2
icon_alias_no_mx osmc_black_stripe_3 osmc_black_stripe_3
icon_alias_no_mx osmc_black_stripe_4 osmc_black_stripe_4
icon_alias_no_mx osmc_black_t osmc_black_t
icon_alias_no_mx osmc_black_triangle osmc_black_triangle
icon_alias_no_mx osmc_black_triangle_2 osmc_black_triangle_2
icon_alias_no_mx osmc_black_triangle_3 osmc_black_triangle_3
icon_alias_no_mx osmc_black_triangle_4 osmc_black_triangle_4
icon_alias_no_mx osmc_black_triangle_line osmc_black_triangle_line
icon_alias_no_mx osmc_black_triangle_line_2 osmc_black_triangle_line_2
icon_alias_no_mx osmc_black_triangle_line_3 osmc_black_triangle_line_3
icon_alias_no_mx osmc_black_triangle_line_4 osmc_black_triangle_line_4
icon_alias_no_mx osmc_black_triangle_turned osmc_black_triangle_turned
icon_alias_no_mx osmc_black_triangle_turned_2 osmc_black_triangle_turned_2
icon_alias_no_mx osmc_black_triangle_turned_3 osmc_black_triangle_turned_3
icon_alias_no_mx osmc_black_triangle_turned_4 osmc_black_triangle_turned_4
icon_alias_no_mx osmc_black_turned_t osmc_black_turned_t
icon_alias_no_mx osmc_black_upper osmc_black_upper
icon_alias_no_mx osmc_black_upper_2 osmc_black_upper_2
icon_alias_no_mx osmc_black_upper_3 osmc_black_upper_3
icon_alias_no_mx osmc_black_upper_4 osmc_black_upper_4
icon_alias_no_mx osmc_black_x osmc_black_x
icon_alias_no_mx osmc_black_x_2 osmc_black_x_2
icon_alias_no_mx osmc_black_x_3 osmc_black_x_3
icon_alias_no_mx osmc_black_x_4 osmc_black_x_4
icon_alias_no_mx osmc_black_wheel osmc_black_wheel

icon_alias_no_mx osmc_blue_arch osmc_blue_arch
icon_alias_no_mx osmc_blue_arrow osmc_blue_arrow
icon_alias_no_mx osmc_blue_backslash osmc_blue_backslash
icon_alias_no_mx osmc_blue_bar osmc_blue_bar
icon_alias_no_mx osmc_blue_bar_2 osmc_blue_bar_2
icon_alias_no_mx osmc_blue_bar_3 osmc_blue_bar_3
icon_alias_no_mx osmc_blue_bar_4 osmc_blue_bar_4
icon_alias_no_mx osmc_blue_bicycle osmc_blue_bicycle
icon_alias_no_mx osmc_blue_bowl osmc_blue_bowl
icon_alias_no_mx osmc_blue_circle osmc_blue_circle
icon_alias_no_mx osmc_blue_circle_arrow osmc_blue_circle_arrow
icon_alias_no_mx osmc_blue_corner osmc_blue_corner
icon_alias_no_mx osmc_blue_corner_left osmc_blue_corner_left
icon_alias_no_mx osmc_blue_cross osmc_blue_cross
icon_alias_no_mx osmc_blue_cross_2 osmc_blue_cross_2
icon_alias_no_mx osmc_blue_cross_3 osmc_blue_cross_3
icon_alias_no_mx osmc_blue_cross_4 osmc_blue_cross_4
icon_alias_no_mx osmc_blue_diamond osmc_blue_diamond
icon_alias_no_mx osmc_blue_diamond_corner osmc_blue_diamond_corner
icon_alias_no_mx osmc_blue_diamond_line osmc_blue_diamond_line
icon_alias_no_mx osmc_blue_diamond_right osmc_blue_diamond_right
icon_alias_no_mx osmc_blue_diamond_left osmc_blue_diamond_left
icon_alias_no_mx osmc_blue_dot osmc_blue_dot
icon_alias_no_mx osmc_blue_dot_2 osmc_blue_dot_2
icon_alias_no_mx osmc_blue_dot_3 osmc_blue_dot_3
icon_alias_no_mx osmc_blue_dot_4 osmc_blue_dot_4
icon_alias_no_mx osmc_blue_drop_line osmc_blue_drop_line
icon_alias_no_mx osmc_blue_drop osmc_blue_drop
icon_alias_no_mx osmc_blue_crest osmc_blue_crest
icon_alias_no_mx osmc_blue_fork osmc_blue_fork
icon_alias_no_mx osmc_blue_hexagon osmc_blue_hexagon
icon_alias_no_mx osmc_blue_hiker osmc_blue_hiker
icon_alias_no_mx osmc_blue_house osmc_blue_house
icon_alias_no_mx osmc_blue_l osmc_blue_l
icon_alias_no_mx osmc_blue_left osmc_blue_left
icon_alias_no_mx osmc_blue_left_arrow osmc_blue_left_arrow
icon_alias_no_mx osmc_blue_left_pointer osmc_blue_left_pointer
icon_alias_no_mx osmc_blue_left_pointer_2 osmc_blue_left_pointer_2
icon_alias_no_mx osmc_blue_left_pointer_3 osmc_blue_left_pointer_3
icon_alias_no_mx osmc_blue_left_pointer_4 osmc_blue_left_pointer_4
icon_alias_no_mx osmc_blue_m osmc_blue_m
icon_alias_no_mx osmc_blue_lower osmc_blue_lower
icon_alias_no_mx osmc_blue_lower_2 osmc_blue_lower_2
icon_alias_no_mx osmc_blue_lower_3 osmc_blue_lower_3
icon_alias_no_mx osmc_blue_lower_4 osmc_blue_lower_4
icon_alias_no_mx osmc_blue_pointer osmc_blue_pointer
icon_alias_no_mx osmc_blue_pointer_2 osmc_blue_pointer_2
icon_alias_no_mx osmc_blue_pointer_3 osmc_blue_pointer_3
icon_alias_no_mx osmc_blue_pointer_4 osmc_blue_pointer_4
icon_alias_no_mx osmc_blue_pointer_line osmc_blue_pointer_line
icon_alias_no_mx osmc_blue_pointer_line_2 osmc_blue_pointer_line_2
icon_alias_no_mx osmc_blue_pointer_line_3 osmc_blue_pointer_line_3
icon_alias_no_mx osmc_blue_pointer_line_4 osmc_blue_pointer_line_4
icon_alias_no_mx osmc_blue_red_diamond osmc_blue_red_diamond
icon_alias_no_mx osmc_blue_rectangle osmc_blue_rectangle
icon_alias_no_mx osmc_blue_rectangle_2 osmc_blue_rectangle_2
icon_alias_no_mx osmc_blue_rectangle_3 osmc_blue_rectangle_3
icon_alias_no_mx osmc_blue_rectangle_4 osmc_blue_rectangle_4
icon_alias_no_mx osmc_blue_rectangle_line osmc_blue_rectangle_line
icon_alias_no_mx osmc_blue_rectangle_lower osmc_blue_rectangle_lower
icon_alias_no_mx osmc_blue_rectangle_lower_2 osmc_blue_rectangle_lower_2
icon_alias_no_mx osmc_blue_rectangle_lower_3 osmc_blue_rectangle_lower_3
icon_alias_no_mx osmc_blue_rectangle_lower_4 osmc_blue_rectangle_lower_4
icon_alias_no_mx osmc_blue_right osmc_blue_right
icon_alias_no_mx osmc_blue_right_arrow osmc_blue_arrow
icon_alias_no_mx osmc_blue_right_pointer osmc_blue_pointer
icon_alias_no_mx osmc_blue_right_pointer_2 osmc_blue_pointer_2
icon_alias_no_mx osmc_blue_right_pointer_3 osmc_blue_pointer_3
icon_alias_no_mx osmc_blue_right_pointer_4 osmc_blue_pointer_4
icon_alias_no_mx osmc_blue_slash osmc_blue_slash
icon_alias_no_mx osmc_blue_stripe osmc_blue_stripe
icon_alias_no_mx osmc_blue_stripe_2 osmc_blue_stripe_2
icon_alias_no_mx osmc_blue_stripe_3 osmc_blue_stripe_3
icon_alias_no_mx osmc_blue_stripe_4 osmc_blue_stripe_4
icon_alias_no_mx osmc_blue_t osmc_blue_t
icon_alias_no_mx osmc_blue_triangle osmc_blue_triangle
icon_alias_no_mx osmc_blue_triangle_2 osmc_blue_triangle_2
icon_alias_no_mx osmc_blue_triangle_3 osmc_blue_triangle_3
icon_alias_no_mx osmc_blue_triangle_4 osmc_blue_triangle_4
icon_alias_no_mx osmc_blue_triangle_line osmc_blue_triangle_line
icon_alias_no_mx osmc_blue_triangle_line_2 osmc_blue_triangle_line_2
icon_alias_no_mx osmc_blue_triangle_line_3 osmc_blue_triangle_line_3
icon_alias_no_mx osmc_blue_triangle_line_4 osmc_blue_triangle_line_4
icon_alias_no_mx osmc_blue_triangle_turned osmc_blue_triangle_turned
icon_alias_no_mx osmc_blue_triangle_turned_2 osmc_blue_triangle_turned_2
icon_alias_no_mx osmc_blue_triangle_turned_3 osmc_blue_triangle_turned_3
icon_alias_no_mx osmc_blue_triangle_turned_4 osmc_blue_triangle_turned_4
icon_alias_no_mx osmc_blue_turned_t osmc_blue_turned_t
icon_alias_no_mx osmc_blue_upper osmc_blue_upper
icon_alias_no_mx osmc_blue_upper_2 osmc_blue_upper_2
icon_alias_no_mx osmc_blue_upper_3 osmc_blue_upper_3
icon_alias_no_mx osmc_blue_upper_4 osmc_blue_upper_4
icon_alias_no_mx osmc_blue_upper_bowl osmc_blue_upper_bowl
icon_alias_no_mx osmc_blue_x osmc_blue_x
icon_alias_no_mx osmc_blue_x_2 osmc_blue_x_2
icon_alias_no_mx osmc_blue_x_3 osmc_blue_x_3
icon_alias_no_mx osmc_blue_x_4 osmc_blue_x_4
icon_alias_no_mx osmc_blue_wheel osmc_blue_wheel

icon_alias_no_mx osmc_green_arch osmc_green_arch
icon_alias_no_mx osmc_green_arrow osmc_green_arrow
icon_alias_no_mx osmc_green_backslash osmc_green_backslash
icon_alias_no_mx osmc_green_bar osmc_green_bar
icon_alias_no_mx osmc_green_bar_2 osmc_green_bar_2
icon_alias_no_mx osmc_green_bar_3 osmc_green_bar_3
icon_alias_no_mx osmc_green_bar_4 osmc_green_bar_4
icon_alias_no_mx osmc_green_bicycle osmc_green_bicycle
icon_alias_no_mx osmc_green_bowl osmc_green_bowl
icon_alias_no_mx osmc_green_circle osmc_green_circle
icon_alias_no_mx osmc_green_circle_arrow osmc_green_circle_arrow
icon_alias_no_mx osmc_green_corner osmc_green_corner
icon_alias_no_mx osmc_green_corner_left osmc_green_corner_left
icon_alias_no_mx osmc_green_cross osmc_green_cross
icon_alias_no_mx osmc_green_cross_2 osmc_green_cross_2
icon_alias_no_mx osmc_green_cross_3 osmc_green_cross_3
icon_alias_no_mx osmc_green_cross_4 osmc_green_cross_4
icon_alias_no_mx osmc_green_diamond osmc_green_diamond
icon_alias_no_mx osmc_green_diamond_corner osmc_green_diamond_corner
icon_alias_no_mx osmc_green_diamond_line osmc_green_diamond_line
icon_alias_no_mx osmc_green_diamond_right osmc_green_diamond_right
icon_alias_no_mx osmc_green_diamond_left osmc_green_diamond_left
icon_alias_no_mx osmc_green_dot osmc_green_dot
icon_alias_no_mx osmc_green_dot_2 osmc_green_dot_2
icon_alias_no_mx osmc_green_dot_3 osmc_green_dot_3
icon_alias_no_mx osmc_green_dot_4 osmc_green_dot_4
icon_alias_no_mx osmc_green_drop_line osmc_green_drop_line
icon_alias_no_mx osmc_green_drop osmc_green_drop
icon_alias_no_mx osmc_green_crest osmc_green_crest
icon_alias_no_mx osmc_green_fork osmc_green_fork
icon_alias_no_mx osmc_green_hexagon osmc_green_hexagon
icon_alias_no_mx osmc_green_hiker osmc_green_hiker
icon_alias_no_mx osmc_green_house osmc_green_house
icon_alias_no_mx osmc_green_l osmc_green_l
icon_alias_no_mx osmc_green_left osmc_green_left
icon_alias_no_mx osmc_green_left_arrow osmc_green_left_arrow
icon_alias_no_mx osmc_green_left_pointer osmc_green_left_pointer
icon_alias_no_mx osmc_green_left_pointer_2 osmc_green_left_pointer_2
icon_alias_no_mx osmc_green_left_pointer_3 osmc_green_left_pointer_3
icon_alias_no_mx osmc_green_left_pointer_4 osmc_green_left_pointer_4
icon_alias_no_mx osmc_green_m osmc_green_m
icon_alias_no_mx osmc_green_lower osmc_green_lower
icon_alias_no_mx osmc_green_lower_2 osmc_green_lower_2
icon_alias_no_mx osmc_green_lower_3 osmc_green_lower_3
icon_alias_no_mx osmc_green_lower_4 osmc_green_lower_4
icon_alias_no_mx osmc_green_pointer osmc_green_pointer
icon_alias_no_mx osmc_green_pointer_2 osmc_green_pointer_2
icon_alias_no_mx osmc_green_pointer_3 osmc_green_pointer_3
icon_alias_no_mx osmc_green_pointer_4 osmc_green_pointer_4
icon_alias_no_mx osmc_green_pointer_line osmc_green_pointer_line
icon_alias_no_mx osmc_green_pointer_line_2 osmc_green_pointer_line_2
icon_alias_no_mx osmc_green_pointer_line_3 osmc_green_pointer_line_3
icon_alias_no_mx osmc_green_pointer_line_4 osmc_green_pointer_line_4
icon_alias_no_mx osmc_green_red_diamond osmc_green_red_diamond
icon_alias_no_mx osmc_green_rectangle osmc_green_rectangle
icon_alias_no_mx osmc_green_rectangle_2 osmc_green_rectangle_2
icon_alias_no_mx osmc_green_rectangle_3 osmc_green_rectangle_3
icon_alias_no_mx osmc_green_rectangle_4 osmc_green_rectangle_4
icon_alias_no_mx osmc_green_rectangle_line osmc_green_rectangle_line
icon_alias_no_mx osmc_green_rectangle_lower osmc_green_rectangle_lower
icon_alias_no_mx osmc_green_rectangle_lower_2 osmc_green_rectangle_lower_2
icon_alias_no_mx osmc_green_rectangle_lower_3 osmc_green_rectangle_lower_3
icon_alias_no_mx osmc_green_rectangle_lower_4 osmc_green_rectangle_lower_4
icon_alias_no_mx osmc_green_right osmc_green_right
icon_alias_no_mx osmc_green_right_arrow osmc_green_arrow
icon_alias_no_mx osmc_green_right_pointer osmc_green_pointer
icon_alias_no_mx osmc_green_right_pointer_2 osmc_green_pointer_2
icon_alias_no_mx osmc_green_right_pointer_3 osmc_green_pointer_3
icon_alias_no_mx osmc_green_right_pointer_4 osmc_green_pointer_4
icon_alias_no_mx osmc_green_slash osmc_green_slash
icon_alias_no_mx osmc_green_stripe osmc_green_stripe
icon_alias_no_mx osmc_green_stripe_2 osmc_green_stripe_2
icon_alias_no_mx osmc_green_stripe_3 osmc_green_stripe_3
icon_alias_no_mx osmc_green_stripe_4 osmc_green_stripe_4
icon_alias_no_mx osmc_green_t osmc_green_t
icon_alias_no_mx osmc_green_triangle osmc_green_triangle
icon_alias_no_mx osmc_green_triangle_2 osmc_green_triangle_2
icon_alias_no_mx osmc_green_triangle_3 osmc_green_triangle_3
icon_alias_no_mx osmc_green_triangle_4 osmc_green_triangle_4
icon_alias_no_mx osmc_green_triangle_line osmc_green_triangle_line
icon_alias_no_mx osmc_green_triangle_line_2 osmc_green_triangle_line_2
icon_alias_no_mx osmc_green_triangle_line_3 osmc_green_triangle_line_3
icon_alias_no_mx osmc_green_triangle_line_4 osmc_green_triangle_line_4
icon_alias_no_mx osmc_green_triangle_turned osmc_green_triangle_turned
icon_alias_no_mx osmc_green_triangle_turned_2 osmc_green_triangle_turned_2
icon_alias_no_mx osmc_green_triangle_turned_3 osmc_green_triangle_turned_3
icon_alias_no_mx osmc_green_triangle_turned_4 osmc_green_triangle_turned_4
icon_alias_no_mx osmc_green_turned_t osmc_green_turned_t
icon_alias_no_mx osmc_green_upper osmc_green_upper
icon_alias_no_mx osmc_green_upper_2 osmc_green_upper_2
icon_alias_no_mx osmc_green_upper_3 osmc_green_upper_3
icon_alias_no_mx osmc_green_upper_4 osmc_green_upper_4
icon_alias_no_mx osmc_green_upper_bowl osmc_green_upper_bowl
icon_alias_no_mx osmc_green_x osmc_green_x
icon_alias_no_mx osmc_green_x_2 osmc_green_x_2
icon_alias_no_mx osmc_green_x_3 osmc_green_x_3
icon_alias_no_mx osmc_green_x_4 osmc_green_x_4
icon_alias_no_mx osmc_green_wheel osmc_green_wheel

icon_alias_no_mx osmc_orange_arch osmc_orange_arch
icon_alias_no_mx osmc_orange_arrow osmc_orange_arrow
icon_alias_no_mx osmc_orange_backslash osmc_orange_backslash
icon_alias_no_mx osmc_orange_bar osmc_orange_bar
icon_alias_no_mx osmc_orange_bar_2 osmc_orange_bar_2
icon_alias_no_mx osmc_orange_bar_3 osmc_orange_bar_3
icon_alias_no_mx osmc_orange_bar_4 osmc_orange_bar_4
icon_alias_no_mx osmc_orange_bicycle osmc_orange_bicycle
icon_alias_no_mx osmc_orange_bowl osmc_orange_bowl
icon_alias_no_mx osmc_orange_circle osmc_orange_circle
icon_alias_no_mx osmc_orange_circle_arrow osmc_orange_circle_arrow
icon_alias_no_mx osmc_orange_corner osmc_orange_corner
icon_alias_no_mx osmc_orange_corner_left osmc_orange_corner_left
icon_alias_no_mx osmc_orange_cross osmc_orange_cross
icon_alias_no_mx osmc_orange_cross_2 osmc_orange_cross_2
icon_alias_no_mx osmc_orange_cross_3 osmc_orange_cross_3
icon_alias_no_mx osmc_orange_cross_4 osmc_orange_cross_4
icon_alias_no_mx osmc_orange_diamond osmc_orange_diamond
icon_alias_no_mx osmc_orange_diamond_corner osmc_orange_diamond_corner
icon_alias_no_mx osmc_orange_diamond_line osmc_orange_diamond_line
icon_alias_no_mx osmc_orange_diamond_right osmc_orange_diamond_right
icon_alias_no_mx osmc_orange_diamond_left osmc_orange_diamond_left
icon_alias_no_mx osmc_orange_dot osmc_orange_dot
icon_alias_no_mx osmc_orange_dot_2 osmc_orange_dot_2
icon_alias_no_mx osmc_orange_dot_3 osmc_orange_dot_3
icon_alias_no_mx osmc_orange_dot_4 osmc_orange_dot_4
icon_alias_no_mx osmc_orange_drop_line osmc_orange_drop_line
icon_alias_no_mx osmc_orange_drop osmc_orange_drop
icon_alias_no_mx osmc_orange_crest osmc_orange_crest
icon_alias_no_mx osmc_orange_fork osmc_orange_fork
icon_alias_no_mx osmc_orange_hexagon osmc_orange_hexagon
icon_alias_no_mx osmc_orange_hiker osmc_orange_hiker
icon_alias_no_mx osmc_orange_house osmc_orange_house
icon_alias_no_mx osmc_orange_l osmc_orange_l
icon_alias_no_mx osmc_orange_left osmc_orange_left
icon_alias_no_mx osmc_orange_left_arrow osmc_orange_left_arrow
icon_alias_no_mx osmc_orange_left_pointer osmc_orange_left_pointer
icon_alias_no_mx osmc_orange_left_pointer_2 osmc_orange_left_pointer_2
icon_alias_no_mx osmc_orange_left_pointer_3 osmc_orange_left_pointer_3
icon_alias_no_mx osmc_orange_left_pointer_4 osmc_orange_left_pointer_4
icon_alias_no_mx osmc_orange_m osmc_orange_m
icon_alias_no_mx osmc_orange_lower osmc_orange_lower
icon_alias_no_mx osmc_orange_lower_2 osmc_orange_lower_2
icon_alias_no_mx osmc_orange_lower_3 osmc_orange_lower_3
icon_alias_no_mx osmc_orange_lower_4 osmc_orange_lower_4
icon_alias_no_mx osmc_orange_pointer osmc_orange_pointer
icon_alias_no_mx osmc_orange_pointer_2 osmc_orange_pointer_2
icon_alias_no_mx osmc_orange_pointer_3 osmc_orange_pointer_3
icon_alias_no_mx osmc_orange_pointer_4 osmc_orange_pointer_4
icon_alias_no_mx osmc_orange_pointer_line osmc_orange_pointer_line
icon_alias_no_mx osmc_orange_pointer_line_2 osmc_orange_pointer_line_2
icon_alias_no_mx osmc_orange_pointer_line_3 osmc_orange_pointer_line_3
icon_alias_no_mx osmc_orange_pointer_line_4 osmc_orange_pointer_line_4
icon_alias_no_mx osmc_orange_red_diamond osmc_orange_red_diamond
icon_alias_no_mx osmc_orange_rectangle osmc_orange_rectangle
icon_alias_no_mx osmc_orange_rectangle_2 osmc_orange_rectangle_2
icon_alias_no_mx osmc_orange_rectangle_3 osmc_orange_rectangle_3
icon_alias_no_mx osmc_orange_rectangle_4 osmc_orange_rectangle_4
icon_alias_no_mx osmc_orange_rectangle_line osmc_orange_rectangle_line
icon_alias_no_mx osmc_orange_rectangle_lower osmc_orange_rectangle_lower
icon_alias_no_mx osmc_orange_rectangle_lower_2 osmc_orange_rectangle_lower_2
icon_alias_no_mx osmc_orange_rectangle_lower_3 osmc_orange_rectangle_lower_3
icon_alias_no_mx osmc_orange_rectangle_lower_4 osmc_orange_rectangle_lower_4
icon_alias_no_mx osmc_orange_right osmc_orange_right
icon_alias_no_mx osmc_orange_right_arrow osmc_orange_arrow
icon_alias_no_mx osmc_orange_right_pointer osmc_orange_pointer
icon_alias_no_mx osmc_orange_right_pointer_2 osmc_orange_pointer_2
icon_alias_no_mx osmc_orange_right_pointer_3 osmc_orange_pointer_3
icon_alias_no_mx osmc_orange_right_pointer_4 osmc_orange_pointer_4
icon_alias_no_mx osmc_orange_slash osmc_orange_slash
icon_alias_no_mx osmc_orange_stripe osmc_orange_stripe
icon_alias_no_mx osmc_orange_stripe_2 osmc_orange_stripe_2
icon_alias_no_mx osmc_orange_stripe_3 osmc_orange_stripe_3
icon_alias_no_mx osmc_orange_stripe_4 osmc_orange_stripe_4
icon_alias_no_mx osmc_orange_t osmc_orange_t
icon_alias_no_mx osmc_orange_triangle osmc_orange_triangle
icon_alias_no_mx osmc_orange_triangle_2 osmc_orange_triangle_2
icon_alias_no_mx osmc_orange_triangle_3 osmc_orange_triangle_3
icon_alias_no_mx osmc_orange_triangle_4 osmc_orange_triangle_4
icon_alias_no_mx osmc_orange_triangle_line osmc_orange_triangle_line
icon_alias_no_mx osmc_orange_triangle_line_2 osmc_orange_triangle_line_2
icon_alias_no_mx osmc_orange_triangle_line_3 osmc_orange_triangle_line_3
icon_alias_no_mx osmc_orange_triangle_line_4 osmc_orange_triangle_line_4
icon_alias_no_mx osmc_orange_triangle_turned osmc_orange_triangle_turned
icon_alias_no_mx osmc_orange_triangle_turned_2 osmc_orange_triangle_turned_2
icon_alias_no_mx osmc_orange_triangle_turned_3 osmc_orange_triangle_turned_3
icon_alias_no_mx osmc_orange_triangle_turned_4 osmc_orange_triangle_turned_4
icon_alias_no_mx osmc_orange_turned_t osmc_orange_turned_t
icon_alias_no_mx osmc_orange_upper osmc_orange_upper
icon_alias_no_mx osmc_orange_upper_2 osmc_orange_upper_2
icon_alias_no_mx osmc_orange_upper_3 osmc_orange_upper_3
icon_alias_no_mx osmc_orange_upper_4 osmc_orange_upper_4
icon_alias_no_mx osmc_orange_upper_bowl osmc_orange_upper_bowl
icon_alias_no_mx osmc_orange_x osmc_orange_x
icon_alias_no_mx osmc_orange_x_2 osmc_orange_x_2
icon_alias_no_mx osmc_orange_x_3 osmc_orange_x_3
icon_alias_no_mx osmc_orange_x_4 osmc_orange_x_4
icon_alias_no_mx osmc_orange_wheel osmc_orange_wheel

icon_alias_no_mx osmc_red_arch osmc_red_arch
icon_alias_no_mx osmc_red_arrow osmc_red_arrow
icon_alias_no_mx osmc_red_backslash osmc_red_backslash
icon_alias_no_mx osmc_red_bar osmc_red_bar
icon_alias_no_mx osmc_red_bar_2 osmc_red_bar_2
icon_alias_no_mx osmc_red_bar_3 osmc_red_bar_3
icon_alias_no_mx osmc_red_bar_4 osmc_red_bar_4
icon_alias_no_mx osmc_red_bicycle osmc_red_bicycle
icon_alias_no_mx osmc_red_bowl osmc_red_bowl
icon_alias_no_mx osmc_red_circle osmc_red_circle
icon_alias_no_mx osmc_red_circle_arrow osmc_red_circle_arrow
icon_alias_no_mx osmc_red_corner osmc_red_corner
icon_alias_no_mx osmc_red_corner_left osmc_red_corner_left
icon_alias_no_mx osmc_red_cross osmc_red_cross
icon_alias_no_mx osmc_red_cross_2 osmc_red_cross_2
icon_alias_no_mx osmc_red_cross_3 osmc_red_cross_3
icon_alias_no_mx osmc_red_cross_4 osmc_red_cross_4
icon_alias_no_mx osmc_red_diamond osmc_red_diamond
icon_alias_no_mx osmc_red_diamond_corner osmc_red_diamond_corner
icon_alias_no_mx osmc_red_diamond_line osmc_red_diamond_line
icon_alias_no_mx osmc_red_diamond_right osmc_red_diamond_right
icon_alias_no_mx osmc_red_diamond_left osmc_red_diamond_left
icon_alias_no_mx osmc_red_dot osmc_red_dot
icon_alias_no_mx osmc_red_dot_2 osmc_red_dot_2
icon_alias_no_mx osmc_red_dot_3 osmc_red_dot_3
icon_alias_no_mx osmc_red_dot_4 osmc_red_dot_4
icon_alias_no_mx osmc_red_drop osmc_red_drop
icon_alias_no_mx osmc_red_drop_line osmc_red_drop_line
icon_alias_no_mx osmc_red_drop osmc_red_drop
icon_alias_no_mx osmc_red_crest osmc_red_crest
icon_alias_no_mx osmc_red_fork osmc_red_fork
icon_alias_no_mx osmc_red_hexagon osmc_red_hexagon
icon_alias_no_mx osmc_red_hiker osmc_red_hiker
icon_alias_no_mx osmc_red_house osmc_red_house
icon_alias_no_mx osmc_red_l osmc_red_l
icon_alias_no_mx osmc_red_left osmc_red_left
icon_alias_no_mx osmc_red_left_arrow osmc_red_left_arrow
icon_alias_no_mx osmc_red_left_pointer osmc_red_left_pointer
icon_alias_no_mx osmc_red_left_pointer_2 osmc_red_left_pointer_2
icon_alias_no_mx osmc_red_left_pointer_3 osmc_red_left_pointer_3
icon_alias_no_mx osmc_red_left_pointer_4 osmc_red_left_pointer_4
icon_alias_no_mx osmc_red_m osmc_red_m
icon_alias_no_mx osmc_red_lower osmc_red_lower
icon_alias_no_mx osmc_red_lower_2 osmc_red_lower_2
icon_alias_no_mx osmc_red_lower_3 osmc_red_lower_3
icon_alias_no_mx osmc_red_lower_4 osmc_red_lower_4
icon_alias_no_mx osmc_red_pointer osmc_red_pointer
icon_alias_no_mx osmc_red_pointer_2 osmc_red_pointer_2
icon_alias_no_mx osmc_red_pointer_3 osmc_red_pointer_3
icon_alias_no_mx osmc_red_pointer_4 osmc_red_pointer_4
icon_alias_no_mx osmc_red_pointer_line osmc_red_pointer_line
icon_alias_no_mx osmc_red_pointer_line_2 osmc_red_pointer_line_2
icon_alias_no_mx osmc_red_pointer_line_3 osmc_red_pointer_line_3
icon_alias_no_mx osmc_red_pointer_line_4 osmc_red_pointer_line_4
icon_alias_no_mx osmc_red_red_diamond osmc_red_red_diamond
icon_alias_no_mx osmc_red_rectangle osmc_red_rectangle
icon_alias_no_mx osmc_red_rectangle_2 osmc_red_rectangle_2
icon_alias_no_mx osmc_red_rectangle_3 osmc_red_rectangle_3
icon_alias_no_mx osmc_red_rectangle_4 osmc_red_rectangle_4
icon_alias_no_mx osmc_red_rectangle_line osmc_red_rectangle_line
icon_alias_no_mx osmc_red_rectangle_lower osmc_red_rectangle_lower
icon_alias_no_mx osmc_red_rectangle_lower_2 osmc_red_rectangle_lower_2
icon_alias_no_mx osmc_red_rectangle_lower_3 osmc_red_rectangle_lower_3
icon_alias_no_mx osmc_red_rectangle_lower_4 osmc_red_rectangle_lower_4
icon_alias_no_mx osmc_red_right osmc_red_right
icon_alias_no_mx osmc_red_right_arrow osmc_red_arrow
icon_alias_no_mx osmc_red_right_pointer osmc_red_pointer
icon_alias_no_mx osmc_red_right_pointer_2 osmc_red_pointer_2
icon_alias_no_mx osmc_red_right_pointer_3 osmc_red_pointer_3
icon_alias_no_mx osmc_red_right_pointer_4 osmc_red_pointer_4
icon_alias_no_mx osmc_red_slash osmc_red_slash
icon_alias_no_mx osmc_red_stripe osmc_red_stripe
icon_alias_no_mx osmc_red_stripe_2 osmc_red_stripe_2
icon_alias_no_mx osmc_red_stripe_3 osmc_red_stripe_3
icon_alias_no_mx osmc_red_stripe_4 osmc_red_stripe_4
icon_alias_no_mx osmc_red_t osmc_red_t
icon_alias_no_mx osmc_red_triangle osmc_red_triangle
icon_alias_no_mx osmc_red_triangle_2 osmc_red_triangle_2
icon_alias_no_mx osmc_red_triangle_3 osmc_red_triangle_3
icon_alias_no_mx osmc_red_triangle_4 osmc_red_triangle_4
icon_alias_no_mx osmc_red_triangle_line osmc_red_triangle_line
icon_alias_no_mx osmc_red_triangle_line_2 osmc_red_triangle_line_2
icon_alias_no_mx osmc_red_triangle_line_3 osmc_red_triangle_line_3
icon_alias_no_mx osmc_red_triangle_line_4 osmc_red_triangle_line_4
icon_alias_no_mx osmc_red_triangle_turned osmc_red_triangle_turned
icon_alias_no_mx osmc_red_triangle_turned_2 osmc_red_triangle_turned_2
icon_alias_no_mx osmc_red_triangle_turned_3 osmc_red_triangle_turned_3
icon_alias_no_mx osmc_red_triangle_turned_4 osmc_red_triangle_turned_4
icon_alias_no_mx osmc_red_turned_t osmc_red_turned_t
icon_alias_no_mx osmc_red_upper osmc_red_upper
icon_alias_no_mx osmc_red_upper_2 osmc_red_upper_2
icon_alias_no_mx osmc_red_upper_3 osmc_red_upper_3
icon_alias_no_mx osmc_red_upper_4 osmc_red_upper_4
icon_alias_no_mx osmc_red_upper_bowl osmc_red_upper_bowl
icon_alias_no_mx osmc_red_x osmc_red_x
icon_alias_no_mx osmc_red_x_2 osmc_red_x_2
icon_alias_no_mx osmc_red_x_3 osmc_red_x_3
icon_alias_no_mx osmc_red_x_4 osmc_red_x_4
icon_alias_no_mx osmc_red_wheel osmc_red_wheel

icon_alias_no_mx osmc_white_arch osmc_white_arch
icon_alias_no_mx osmc_white_arrow osmc_white_arrow
icon_alias_no_mx osmc_white_backslash osmc_white_backslash
icon_alias_no_mx osmc_white_bar osmc_white_bar
icon_alias_no_mx osmc_white_bar_2 osmc_white_bar_2
icon_alias_no_mx osmc_white_bar_3 osmc_white_bar_3
icon_alias_no_mx osmc_white_bar_4 osmc_white_bar_4
icon_alias_no_mx osmc_white_bicycle osmc_white_bicycle
icon_alias_no_mx osmc_white_bowl osmc_white_bowl
icon_alias_no_mx osmc_white_circle osmc_white_circle
icon_alias_no_mx osmc_white_circle_arrow osmc_white_circle_arrow
icon_alias_no_mx osmc_white_corner osmc_white_corner
icon_alias_no_mx osmc_white_corner_left osmc_white_corner_left
icon_alias_no_mx osmc_white_cross osmc_white_cross
icon_alias_no_mx osmc_white_cross_2 osmc_white_cross_2
icon_alias_no_mx osmc_white_cross_3 osmc_white_cross_3
icon_alias_no_mx osmc_white_cross_4 osmc_white_cross_4
icon_alias_no_mx osmc_white_diamond osmc_white_diamond
icon_alias_no_mx osmc_white_diamond_corner osmc_white_diamond_corner
icon_alias_no_mx osmc_white_diamond_line osmc_white_diamond_line
icon_alias_no_mx osmc_white_diamond_right osmc_white_diamond_right
icon_alias_no_mx osmc_white_diamond_left osmc_white_diamond_left
icon_alias_no_mx osmc_white_dot osmc_white_dot
icon_alias_no_mx osmc_white_dot_2 osmc_white_dot_2
icon_alias_no_mx osmc_white_dot_3 osmc_white_dot_3
icon_alias_no_mx osmc_white_dot_4 osmc_white_dot_4
icon_alias_no_mx osmc_white_drop_line osmc_white_drop_line
icon_alias_no_mx osmc_white_drop osmc_white_drop
icon_alias_no_mx osmc_white_crest osmc_white_crest
icon_alias_no_mx osmc_white_fork osmc_white_fork
icon_alias_no_mx osmc_white_hexagon osmc_white_hexagon
icon_alias_no_mx osmc_white_hiker osmc_white_hiker
icon_alias_no_mx osmc_white_house osmc_white_house
icon_alias_no_mx osmc_white_l osmc_white_l
icon_alias_no_mx osmc_white_left osmc_white_left
icon_alias_no_mx osmc_white_left_arrow osmc_white_left_arrow
icon_alias_no_mx osmc_white_left_pointer osmc_white_left_pointer
icon_alias_no_mx osmc_white_left_pointer_2 osmc_white_left_pointer_2
icon_alias_no_mx osmc_white_left_pointer_3 osmc_white_left_pointer_3
icon_alias_no_mx osmc_white_left_pointer_4 osmc_white_left_pointer_4
icon_alias_no_mx osmc_white_m osmc_white_m
icon_alias_no_mx osmc_white_lower osmc_white_lower
icon_alias_no_mx osmc_white_lower_2 osmc_white_lower_2
icon_alias_no_mx osmc_white_lower_3 osmc_white_lower_3
icon_alias_no_mx osmc_white_lower_4 osmc_white_lower_4
icon_alias_no_mx osmc_white_pointer osmc_white_pointer
icon_alias_no_mx osmc_white_pointer_2 osmc_white_pointer_2
icon_alias_no_mx osmc_white_pointer_3 osmc_white_pointer_3
icon_alias_no_mx osmc_white_pointer_4 osmc_white_pointer_4
icon_alias_no_mx osmc_white_pointer_line osmc_white_pointer_line
icon_alias_no_mx osmc_white_pointer_line_2 osmc_white_pointer_line_2
icon_alias_no_mx osmc_white_pointer_line_3 osmc_white_pointer_line_3
icon_alias_no_mx osmc_white_pointer_line_4 osmc_white_pointer_line_4
icon_alias_no_mx osmc_white_red_diamond osmc_white_red_diamond
icon_alias_no_mx osmc_white_rectangle osmc_white_rectangle
icon_alias_no_mx osmc_white_rectangle_2 osmc_white_rectangle_2
icon_alias_no_mx osmc_white_rectangle_3 osmc_white_rectangle_3
icon_alias_no_mx osmc_white_rectangle_4 osmc_white_rectangle_4
icon_alias_no_mx osmc_white_rectangle_line osmc_white_rectangle_line
icon_alias_no_mx osmc_white_rectangle_lower osmc_white_rectangle_lower
icon_alias_no_mx osmc_white_rectangle_lower_2 osmc_white_rectangle_lower_2
icon_alias_no_mx osmc_white_rectangle_lower_3 osmc_white_rectangle_lower_3
icon_alias_no_mx osmc_white_rectangle_lower_4 osmc_white_rectangle_lower_4
icon_alias_no_mx osmc_white_right osmc_white_right
icon_alias_no_mx osmc_white_right_arrow osmc_white_arrow
icon_alias_no_mx osmc_white_right_pointer osmc_white_pointer
icon_alias_no_mx osmc_white_right_pointer_2 osmc_white_pointer_2
icon_alias_no_mx osmc_white_right_pointer_3 osmc_white_pointer_3
icon_alias_no_mx osmc_white_right_pointer_4 osmc_white_pointer_4
icon_alias_no_mx osmc_white_slash osmc_white_slash
icon_alias_no_mx osmc_white_stripe osmc_white_stripe
icon_alias_no_mx osmc_white_stripe_2 osmc_white_stripe_2
icon_alias_no_mx osmc_white_stripe_3 osmc_white_stripe_3
icon_alias_no_mx osmc_white_stripe_4 osmc_white_stripe_4
icon_alias_no_mx osmc_white_t osmc_white_t
icon_alias_no_mx osmc_white_triangle osmc_white_triangle
icon_alias_no_mx osmc_white_triangle_2 osmc_white_triangle_2
icon_alias_no_mx osmc_white_triangle_3 osmc_white_triangle_3
icon_alias_no_mx osmc_white_triangle_4 osmc_white_triangle_4
icon_alias_no_mx osmc_white_triangle_line osmc_white_triangle_line
icon_alias_no_mx osmc_white_triangle_line_2 osmc_white_triangle_line_2
icon_alias_no_mx osmc_white_triangle_line_3 osmc_white_triangle_line_3
icon_alias_no_mx osmc_white_triangle_line_4 osmc_white_triangle_line_4
icon_alias_no_mx osmc_white_triangle_turned osmc_white_triangle_turned
icon_alias_no_mx osmc_white_triangle_turned_2 osmc_white_triangle_turned_2
icon_alias_no_mx osmc_white_triangle_turned_3 osmc_white_triangle_turned_3
icon_alias_no_mx osmc_white_triangle_turned_4 osmc_white_triangle_turned_4
icon_alias_no_mx osmc_white_turned_t osmc_white_turned_t
icon_alias_no_mx osmc_white_upper osmc_white_upper
icon_alias_no_mx osmc_white_upper_2 osmc_white_upper_2
icon_alias_no_mx osmc_white_upper_3 osmc_white_upper_3
icon_alias_no_mx osmc_white_upper_4 osmc_white_upper_4
icon_alias_no_mx osmc_white_upper_bowl osmc_white_upper_bowl
icon_alias_no_mx osmc_white_x osmc_white_x
icon_alias_no_mx osmc_white_x_2 osmc_white_x_2
icon_alias_no_mx osmc_white_x_3 osmc_white_x_3
icon_alias_no_mx osmc_white_x_4 osmc_white_x_4
icon_alias_no_mx osmc_white_wheel osmc_white_wheel

icon_alias_no_mx osmc_yellow_arch osmc_yellow_arch
icon_alias_no_mx osmc_yellow_arrow osmc_yellow_arrow
icon_alias_no_mx osmc_yellow_backslash osmc_yellow_backslash
icon_alias_no_mx osmc_yellow_bar osmc_yellow_bar
icon_alias_no_mx osmc_yellow_bar_2 osmc_yellow_bar_2
icon_alias_no_mx osmc_yellow_bar_3 osmc_yellow_bar_3
icon_alias_no_mx osmc_yellow_bar_4 osmc_yellow_bar_4
icon_alias_no_mx osmc_yellow_bicycle osmc_yellow_bicycle
icon_alias_no_mx osmc_yellow_bowl osmc_yellow_bowl
icon_alias_no_mx osmc_yellow_circle osmc_yellow_circle
icon_alias_no_mx osmc_yellow_circle_arrow osmc_yellow_circle_arrow
icon_alias_no_mx osmc_yellow_corner osmc_yellow_corner
icon_alias_no_mx osmc_yellow_corner_left osmc_yellow_corner_left
icon_alias_no_mx osmc_yellow_cross osmc_yellow_cross
icon_alias_no_mx osmc_yellow_cross_2 osmc_yellow_cross_2
icon_alias_no_mx osmc_yellow_cross_3 osmc_yellow_cross_3
icon_alias_no_mx osmc_yellow_cross_4 osmc_yellow_cross_4
icon_alias_no_mx osmc_yellow_diamond osmc_yellow_diamond
icon_alias_no_mx osmc_yellow_diamond_corner osmc_yellow_diamond_corner
icon_alias_no_mx osmc_yellow_diamond_line osmc_yellow_diamond_line
icon_alias_no_mx osmc_yellow_diamond_right osmc_yellow_diamond_right
icon_alias_no_mx osmc_yellow_diamond_left osmc_yellow_diamond_left
icon_alias_no_mx osmc_yellow_dot osmc_yellow_dot
icon_alias_no_mx osmc_yellow_dot_2 osmc_yellow_dot_2
icon_alias_no_mx osmc_yellow_dot_3 osmc_yellow_dot_3
icon_alias_no_mx osmc_yellow_dot_4 osmc_yellow_dot_4
icon_alias_no_mx osmc_yellow_drop_line osmc_yellow_drop_line
icon_alias_no_mx osmc_yellow_drop osmc_yellow_drop
icon_alias_no_mx osmc_yellow_crest osmc_yellow_crest
icon_alias_no_mx osmc_yellow_fork osmc_yellow_fork
icon_alias_no_mx osmc_yellow_hexagon osmc_yellow_hexagon
icon_alias_no_mx osmc_yellow_hiker osmc_yellow_hiker
icon_alias_no_mx osmc_yellow_house osmc_yellow_house
icon_alias_no_mx osmc_yellow_l osmc_yellow_l
icon_alias_no_mx osmc_yellow_left osmc_yellow_left
icon_alias_no_mx osmc_yellow_left_arrow osmc_yellow_left_arrow
icon_alias_no_mx osmc_yellow_left_pointer osmc_yellow_left_pointer
icon_alias_no_mx osmc_yellow_left_pointer_2 osmc_yellow_left_pointer_2
icon_alias_no_mx osmc_yellow_left_pointer_3 osmc_yellow_left_pointer_3
icon_alias_no_mx osmc_yellow_left_pointer_4 osmc_yellow_left_pointer_4
icon_alias_no_mx osmc_yellow_m osmc_yellow_m
icon_alias_no_mx osmc_yellow_lower osmc_yellow_lower
icon_alias_no_mx osmc_yellow_lower_2 osmc_yellow_lower_2
icon_alias_no_mx osmc_yellow_lower_3 osmc_yellow_lower_3
icon_alias_no_mx osmc_yellow_lower_4 osmc_yellow_lower_4
icon_alias_no_mx osmc_yellow_pointer osmc_yellow_pointer
icon_alias_no_mx osmc_yellow_pointer_2 osmc_yellow_pointer_2
icon_alias_no_mx osmc_yellow_pointer_3 osmc_yellow_pointer_3
icon_alias_no_mx osmc_yellow_pointer_4 osmc_yellow_pointer_4
icon_alias_no_mx osmc_yellow_pointer_line osmc_yellow_pointer_line
icon_alias_no_mx osmc_yellow_pointer_line_2 osmc_yellow_pointer_line_2
icon_alias_no_mx osmc_yellow_pointer_line_3 osmc_yellow_pointer_line_3
icon_alias_no_mx osmc_yellow_pointer_line_4 osmc_yellow_pointer_line_4
icon_alias_no_mx osmc_yellow_rectangle osmc_yellow_rectangle
icon_alias_no_mx osmc_yellow_red_diamond osmc_yellow_red_diamond
icon_alias_no_mx osmc_yellow_rectangle_2 osmc_yellow_rectangle_2
icon_alias_no_mx osmc_yellow_rectangle_3 osmc_yellow_rectangle_3
icon_alias_no_mx osmc_yellow_rectangle_4 osmc_yellow_rectangle_4
icon_alias_no_mx osmc_yellow_rectangle_line osmc_yellow_rectangle_line
icon_alias_no_mx osmc_yellow_rectangle_lower osmc_yellow_rectangle_lower
icon_alias_no_mx osmc_yellow_rectangle_lower_2 osmc_yellow_rectangle_lower_2
icon_alias_no_mx osmc_yellow_rectangle_lower_3 osmc_yellow_rectangle_lower_3
icon_alias_no_mx osmc_yellow_rectangle_lower_4 osmc_yellow_rectangle_lower_4
icon_alias_no_mx osmc_yellow_right osmc_yellow_right
icon_alias_no_mx osmc_yellow_right_arrow osmc_yellow_arrow
icon_alias_no_mx osmc_yellow_right_pointer osmc_yellow_pointer
icon_alias_no_mx osmc_yellow_right_pointer_2 osmc_yellow_pointer_2
icon_alias_no_mx osmc_yellow_right_pointer_3 osmc_yellow_pointer_3
icon_alias_no_mx osmc_yellow_right_pointer_4 osmc_yellow_pointer_4
icon_alias_no_mx osmc_yellow_slash osmc_yellow_slash
icon_alias_no_mx osmc_yellow_stripe osmc_yellow_stripe
icon_alias_no_mx osmc_yellow_stripe_2 osmc_yellow_stripe_2
icon_alias_no_mx osmc_yellow_stripe_3 osmc_yellow_stripe_3
icon_alias_no_mx osmc_yellow_stripe_4 osmc_yellow_stripe_4
icon_alias_no_mx osmc_yellow_t osmc_yellow_t
icon_alias_no_mx osmc_yellow_triangle osmc_yellow_triangle
icon_alias_no_mx osmc_yellow_triangle_2 osmc_yellow_triangle_2
icon_alias_no_mx osmc_yellow_triangle_3 osmc_yellow_triangle_3
icon_alias_no_mx osmc_yellow_triangle_4 osmc_yellow_triangle_4
icon_alias_no_mx osmc_yellow_triangle_line osmc_yellow_triangle_line
icon_alias_no_mx osmc_yellow_triangle_line_2 osmc_yellow_triangle_line_2
icon_alias_no_mx osmc_yellow_triangle_line_3 osmc_yellow_triangle_line_3
icon_alias_no_mx osmc_yellow_triangle_line_4 osmc_yellow_triangle_line_4
icon_alias_no_mx osmc_yellow_triangle_turned osmc_yellow_triangle_turned
icon_alias_no_mx osmc_yellow_triangle_turned_2 osmc_yellow_triangle_turned_2
icon_alias_no_mx osmc_yellow_triangle_turned_3 osmc_yellow_triangle_turned_3
icon_alias_no_mx osmc_yellow_triangle_turned_4 osmc_yellow_triangle_turned_4
icon_alias_no_mx osmc_yellow_turned_t osmc_yellow_turned_t
icon_alias_no_mx osmc_yellow_upper osmc_yellow_upper
icon_alias_no_mx osmc_yellow_upper_2 osmc_yellow_upper_2
icon_alias_no_mx osmc_yellow_upper_3 osmc_yellow_upper_3
icon_alias_no_mx osmc_yellow_upper_4 osmc_yellow_upper_4
icon_alias_no_mx osmc_yellow_upper_bowl osmc_yellow_upper_bowl
icon_alias_no_mx osmc_yellow_x osmc_yellow_x
icon_alias_no_mx osmc_yellow_x_2 osmc_yellow_x_2
icon_alias_no_mx osmc_yellow_x_3 osmc_yellow_x_3
icon_alias_no_mx osmc_yellow_x_4 osmc_yellow_x_4
icon_alias_no_mx osmc_yellow_wheel osmc_yellow_wheel

icon_alias_no_mx osmc_brown_arch osmc_brown_arch
icon_alias_no_mx osmc_brown_arrow osmc_brown_arrow
icon_alias_no_mx osmc_brown_backslash osmc_brown_backslash
icon_alias_no_mx osmc_brown_bar osmc_brown_bar
icon_alias_no_mx osmc_brown_bar_2 osmc_brown_bar_2
icon_alias_no_mx osmc_brown_bar_3 osmc_brown_bar_3
icon_alias_no_mx osmc_brown_bar_4 osmc_brown_bar_4
icon_alias_no_mx osmc_brown_bicycle osmc_brown_bicycle
icon_alias_no_mx osmc_brown_bowl osmc_brown_bowl
icon_alias_no_mx osmc_brown_circle osmc_brown_circle
icon_alias_no_mx osmc_brown_circle_arrow osmc_brown_circle_arrow
icon_alias_no_mx osmc_brown_corner osmc_brown_corner
icon_alias_no_mx osmc_brown_corner_left osmc_brown_corner_left
icon_alias_no_mx osmc_brown_cross osmc_brown_cross
icon_alias_no_mx osmc_brown_cross_2 osmc_brown_cross_2
icon_alias_no_mx osmc_brown_cross_3 osmc_brown_cross_3
icon_alias_no_mx osmc_brown_cross_4 osmc_brown_cross_4
icon_alias_no_mx osmc_brown_diamond osmc_brown_diamond
icon_alias_no_mx osmc_brown_diamond_corner osmc_brown_diamond_corner
icon_alias_no_mx osmc_brown_diamond_line osmc_brown_diamond_line
icon_alias_no_mx osmc_brown_diamond_right osmc_brown_diamond_right
icon_alias_no_mx osmc_brown_diamond_left osmc_brown_diamond_left
icon_alias_no_mx osmc_brown_dot osmc_brown_dot
icon_alias_no_mx osmc_brown_dot_2 osmc_brown_dot_2
icon_alias_no_mx osmc_brown_dot_3 osmc_brown_dot_3
icon_alias_no_mx osmc_brown_dot_4 osmc_brown_dot_4
icon_alias_no_mx osmc_brown_drop_line osmc_brown_drop_line
icon_alias_no_mx osmc_brown_drop osmc_brown_drop
icon_alias_no_mx osmc_brown_crest osmc_brown_crest
icon_alias_no_mx osmc_brown_fork osmc_brown_fork
icon_alias_no_mx osmc_brown_hexagon osmc_brown_hexagon
icon_alias_no_mx osmc_brown_hiker_house osmc_brown_house
icon_alias_no_mx osmc_brown_house osmc_brown_house
icon_alias_no_mx osmc_brown_l osmc_brown_l
icon_alias_no_mx osmc_brown_left osmc_brown_left
icon_alias_no_mx osmc_brown_left_arrow osmc_brown_left_arrow
icon_alias_no_mx osmc_brown_left_pointer osmc_brown_left_pointer
icon_alias_no_mx osmc_brown_left_pointer_2 osmc_brown_left_pointer_2
icon_alias_no_mx osmc_brown_left_pointer_3 osmc_brown_left_pointer_3
icon_alias_no_mx osmc_brown_left_pointer_4 osmc_brown_left_pointer_4
icon_alias_no_mx osmc_brown_m osmc_brown_m
icon_alias_no_mx osmc_brown_lower osmc_brown_lower
icon_alias_no_mx osmc_brown_lower_2 osmc_brown_lower_2
icon_alias_no_mx osmc_brown_lower_3 osmc_brown_lower_3
icon_alias_no_mx osmc_brown_lower_4 osmc_brown_lower_4
icon_alias_no_mx osmc_brown_pointer osmc_brown_pointer
icon_alias_no_mx osmc_brown_pointer_2 osmc_brown_pointer_2
icon_alias_no_mx osmc_brown_pointer_3 osmc_brown_pointer_3
icon_alias_no_mx osmc_brown_pointer_4 osmc_brown_pointer_4
icon_alias_no_mx osmc_brown_pointer_line osmc_brown_pointer_line
icon_alias_no_mx osmc_brown_pointer_line_2 osmc_brown_pointer_line_2
icon_alias_no_mx osmc_brown_pointer_line_3 osmc_brown_pointer_line_3
icon_alias_no_mx osmc_brown_pointer_line_4 osmc_brown_pointer_line_4
icon_alias_no_mx osmc_brown_red_diamond osmc_brown_red_diamond
icon_alias_no_mx osmc_brown_rectangle osmc_brown_rectangle
icon_alias_no_mx osmc_brown_rectangle_2 osmc_brown_rectangle_2
icon_alias_no_mx osmc_brown_rectangle_3 osmc_brown_rectangle_3
icon_alias_no_mx osmc_brown_rectangle_4 osmc_brown_rectangle_4
icon_alias_no_mx osmc_brown_rectangle_line osmc_brown_rectangle_line
icon_alias_no_mx osmc_brown_rectangle_lower osmc_brown_rectangle_lower
icon_alias_no_mx osmc_brown_rectangle_lower_2 osmc_brown_rectangle_lower_2
icon_alias_no_mx osmc_brown_rectangle_lower_3 osmc_brown_rectangle_lower_3
icon_alias_no_mx osmc_brown_rectangle_lower_4 osmc_brown_rectangle_lower_4
icon_alias_no_mx osmc_brown_right osmc_brown_right
icon_alias_no_mx osmc_brown_right_arrow osmc_brown_arrow
icon_alias_no_mx osmc_brown_right_pointer osmc_brown_pointer
icon_alias_no_mx osmc_brown_right_pointer_2 osmc_brown_pointer_2
icon_alias_no_mx osmc_brown_right_pointer_3 osmc_brown_pointer_3
icon_alias_no_mx osmc_brown_right_pointer_4 osmc_brown_pointer_4
icon_alias_no_mx osmc_brown_slash osmc_brown_slash
icon_alias_no_mx osmc_brown_stripe osmc_brown_stripe
icon_alias_no_mx osmc_brown_stripe_2 osmc_brown_stripe_2
icon_alias_no_mx osmc_brown_stripe_3 osmc_brown_stripe_3
icon_alias_no_mx osmc_brown_stripe_4 osmc_brown_stripe_4
icon_alias_no_mx osmc_brown_t osmc_brown_t
icon_alias_no_mx osmc_brown_triangle osmc_brown_triangle
icon_alias_no_mx osmc_brown_triangle_2 osmc_brown_triangle_2
icon_alias_no_mx osmc_brown_triangle_3 osmc_brown_triangle_3
icon_alias_no_mx osmc_brown_triangle_4 osmc_brown_triangle_4
icon_alias_no_mx osmc_brown_triangle_line osmc_brown_triangle_line
icon_alias_no_mx osmc_brown_triangle_line_2 osmc_brown_triangle_line_2
icon_alias_no_mx osmc_brown_triangle_line_3 osmc_brown_triangle_line_3
icon_alias_no_mx osmc_brown_triangle_line_4 osmc_brown_triangle_line_4
icon_alias_no_mx osmc_brown_triangle_turned osmc_brown_triangle_turned
icon_alias_no_mx osmc_brown_triangle_turned_2 osmc_brown_triangle_turned_2
icon_alias_no_mx osmc_brown_triangle_turned_3 osmc_brown_triangle_turned_3
icon_alias_no_mx osmc_brown_triangle_turned_4 osmc_brown_triangle_turned_4
icon_alias_no_mx osmc_brown_turned_t osmc_brown_turned_t
icon_alias_no_mx osmc_brown_upper osmc_brown_upper
icon_alias_no_mx osmc_brown_upper_2 osmc_brown_upper_2
icon_alias_no_mx osmc_brown_upper_3 osmc_brown_upper_3
icon_alias_no_mx osmc_brown_upper_4 osmc_brown_upper_4
icon_alias_no_mx osmc_brown_upper_bowl osmc_brown_upper_bowl
icon_alias_no_mx osmc_brown_x osmc_brown_x
icon_alias_no_mx osmc_brown_x_2 osmc_brown_x_2
icon_alias_no_mx osmc_brown_x_3 osmc_brown_x_3
icon_alias_no_mx osmc_brown_x_4 osmc_brown_x_4
icon_alias_no_mx osmc_brown_wheel osmc_brown_wheel

icon_alias_no_mx osmc_purple_arch osmc_purple_arch
icon_alias_no_mx osmc_purple_arrow osmc_purple_arrow
icon_alias_no_mx osmc_purple_backslash osmc_purple_backslash
icon_alias_no_mx osmc_purple_bar osmc_purple_bar
icon_alias_no_mx osmc_purple_bar_2 osmc_purple_bar_2
icon_alias_no_mx osmc_purple_bar_3 osmc_purple_bar_3
icon_alias_no_mx osmc_purple_bar_4 osmc_purple_bar_4
icon_alias_no_mx osmc_purple_bicycle osmc_purple_bicycle
icon_alias_no_mx osmc_purple_bowl osmc_purple_bowl
icon_alias_no_mx osmc_purple_circle osmc_purple_circle
icon_alias_no_mx osmc_purple_circle_arrow osmc_purple_circle_arrow
icon_alias_no_mx osmc_purple_corner osmc_purple_corner
icon_alias_no_mx osmc_purple_corner_left osmc_purple_corner_left
icon_alias_no_mx osmc_purple_crest osmc_purple_crest
icon_alias_no_mx osmc_purple_cross osmc_purple_cross
icon_alias_no_mx osmc_purple_cross_2 osmc_purple_cross_2
icon_alias_no_mx osmc_purple_cross_3 osmc_purple_cross_3
icon_alias_no_mx osmc_purple_cross_4 osmc_purple_cross_4
icon_alias_no_mx osmc_purple_diamond osmc_purple_diamond
icon_alias_no_mx osmc_purple_diamond_corner osmc_purple_diamond_corner
icon_alias_no_mx osmc_purple_diamond_left osmc_purple_diamond_left
icon_alias_no_mx osmc_purple_diamond_line osmc_purple_diamond_line
icon_alias_no_mx osmc_purple_diamond_right osmc_purple_diamond_right
icon_alias_no_mx osmc_purple_dot osmc_purple_dot
icon_alias_no_mx osmc_purple_dot_2 osmc_purple_dot_2
icon_alias_no_mx osmc_purple_dot_3 osmc_purple_dot_3
icon_alias_no_mx osmc_purple_dot_4 osmc_purple_dot_4
icon_alias_no_mx osmc_purple_drop osmc_purple_drop
icon_alias_no_mx osmc_purple_drop_line osmc_purple_drop_line
icon_alias_no_mx osmc_purple_fork osmc_purple_fork
icon_alias_no_mx osmc_purple_hexagon osmc_purple_hexagon
icon_alias_no_mx osmc_purple_hiker osmc_purple_hiker
icon_alias_no_mx osmc_purple_house osmc_purple_house
icon_alias_no_mx osmc_purple_l osmc_purple_l
icon_alias_no_mx osmc_purple_left osmc_purple_left
icon_alias_no_mx osmc_purple_left_arrow osmc_purple_left_arrow
icon_alias_no_mx osmc_purple_left_pointer osmc_purple_left_pointer
icon_alias_no_mx osmc_purple_left_pointer_2 osmc_purple_left_pointer_2
icon_alias_no_mx osmc_purple_left_pointer_3 osmc_purple_left_pointer_3
icon_alias_no_mx osmc_purple_left_pointer_4 osmc_purple_left_pointer_4
icon_alias_no_mx osmc_purple_lower osmc_purple_lower
icon_alias_no_mx osmc_purple_lower_2 osmc_purple_lower_2
icon_alias_no_mx osmc_purple_lower_3 osmc_purple_lower_3
icon_alias_no_mx osmc_purple_lower_4 osmc_purple_lower_4
icon_alias_no_mx osmc_purple_m osmc_purple_m
icon_alias_no_mx osmc_purple_pointer osmc_purple_pointer
icon_alias_no_mx osmc_purple_pointer_2 osmc_purple_pointer_2
icon_alias_no_mx osmc_purple_pointer_3 osmc_purple_pointer_3
icon_alias_no_mx osmc_purple_pointer_4 osmc_purple_pointer_4
icon_alias_no_mx osmc_purple_pointer_line osmc_purple_pointer_line
icon_alias_no_mx osmc_purple_pointer_line_2 osmc_purple_pointer_line_2
icon_alias_no_mx osmc_purple_pointer_line_3 osmc_purple_pointer_line_3
icon_alias_no_mx osmc_purple_pointer_line_4 osmc_purple_pointer_line_4
icon_alias_no_mx osmc_purple_rectangle osmc_purple_rectangle
icon_alias_no_mx osmc_purple_rectangle_2 osmc_purple_rectangle_2
icon_alias_no_mx osmc_purple_rectangle_3 osmc_purple_rectangle_3
icon_alias_no_mx osmc_purple_rectangle_4 osmc_purple_rectangle_4
icon_alias_no_mx osmc_purple_rectangle_line osmc_purple_rectangle_line
icon_alias_no_mx osmc_purple_rectangle_lower osmc_purple_rectangle_lower
icon_alias_no_mx osmc_purple_rectangle_lower_2 osmc_purple_rectangle_lower_2
icon_alias_no_mx osmc_purple_rectangle_lower_3 osmc_purple_rectangle_lower_3
icon_alias_no_mx osmc_purple_rectangle_lower_4 osmc_purple_rectangle_lower_4
icon_alias_no_mx osmc_purple_red_diamond osmc_purple_red_diamond
icon_alias_no_mx osmc_purple_right osmc_purple_right
icon_alias_no_mx osmc_purple_slash osmc_purple_slash
icon_alias_no_mx osmc_purple_stripe osmc_purple_stripe
icon_alias_no_mx osmc_purple_stripe_2 osmc_purple_stripe_2
icon_alias_no_mx osmc_purple_stripe_3 osmc_purple_stripe_3
icon_alias_no_mx osmc_purple_stripe_4 osmc_purple_stripe_4
icon_alias_no_mx osmc_purple_t osmc_purple_t
icon_alias_no_mx osmc_purple_triangle osmc_purple_triangle
icon_alias_no_mx osmc_purple_triangle_2 osmc_purple_triangle_2
icon_alias_no_mx osmc_purple_triangle_3 osmc_purple_triangle_3
icon_alias_no_mx osmc_purple_triangle_4 osmc_purple_triangle_4
icon_alias_no_mx osmc_purple_triangle_line osmc_purple_triangle_line
icon_alias_no_mx osmc_purple_triangle_line_2 osmc_purple_triangle_line_2
icon_alias_no_mx osmc_purple_triangle_line_3 osmc_purple_triangle_line_3
icon_alias_no_mx osmc_purple_triangle_line_4 osmc_purple_triangle_line_4
icon_alias_no_mx osmc_purple_triangle_turned osmc_purple_triangle_turned
icon_alias_no_mx osmc_purple_triangle_turned_2 osmc_purple_triangle_turned_2
icon_alias_no_mx osmc_purple_triangle_turned_3 osmc_purple_triangle_turned_3
icon_alias_no_mx osmc_purple_triangle_turned_4 osmc_purple_triangle_turned_4
icon_alias_no_mx osmc_purple_turned_t osmc_purple_turned_t
icon_alias_no_mx osmc_purple_upper osmc_purple_upper
icon_alias_no_mx osmc_purple_upper_2 osmc_purple_upper_2
icon_alias_no_mx osmc_purple_upper_3 osmc_purple_upper_3
icon_alias_no_mx osmc_purple_upper_4 osmc_purple_upper_4
icon_alias_no_mx osmc_purple_upper_bowl osmc_purple_upper_bowl
icon_alias_no_mx osmc_purple_wheel osmc_purple_wheel
icon_alias_no_mx osmc_purple_x osmc_purple_x
icon_alias_no_mx osmc_purple_x_2 osmc_purple_x_2
icon_alias_no_mx osmc_purple_x_3 osmc_purple_x_3
icon_alias_no_mx osmc_purple_x_4 osmc_purple_x_4

icon_alias_no_mx osmc_pink_arch osmc_pink_arch
icon_alias_no_mx osmc_pink_arrow osmc_pink_arrow
icon_alias_no_mx osmc_pink_backslash osmc_pink_backslash
icon_alias_no_mx osmc_pink_bar osmc_pink_bar
icon_alias_no_mx osmc_pink_bar_2 osmc_pink_bar_2
icon_alias_no_mx osmc_pink_bar_3 osmc_pink_bar_3
icon_alias_no_mx osmc_pink_bar_4 osmc_pink_bar_4
icon_alias_no_mx osmc_pink_bicycle osmc_pink_bicycle
icon_alias_no_mx osmc_pink_bowl osmc_pink_bowl
icon_alias_no_mx osmc_pink_circle osmc_pink_circle
icon_alias_no_mx osmc_pink_circle_arrow osmc_pink_circle_arrow
icon_alias_no_mx osmc_pink_corner osmc_pink_corner
icon_alias_no_mx osmc_pink_corner_left osmc_pink_corner_left
icon_alias_no_mx osmc_pink_crest osmc_pink_crest
icon_alias_no_mx osmc_pink_cross osmc_pink_cross
icon_alias_no_mx osmc_pink_cross_2 osmc_pink_cross_2
icon_alias_no_mx osmc_pink_cross_3 osmc_pink_cross_3
icon_alias_no_mx osmc_pink_cross_4 osmc_pink_cross_4
icon_alias_no_mx osmc_pink_diamond osmc_pink_diamond
icon_alias_no_mx osmc_pink_diamond_corner osmc_pink_diamond_corner
icon_alias_no_mx osmc_pink_diamond_left osmc_pink_diamond_left
icon_alias_no_mx osmc_pink_diamond_line osmc_pink_diamond_line
icon_alias_no_mx osmc_pink_diamond_right osmc_pink_diamond_right
icon_alias_no_mx osmc_pink_dot osmc_pink_dot
icon_alias_no_mx osmc_pink_dot_2 osmc_pink_dot_2
icon_alias_no_mx osmc_pink_dot_3 osmc_pink_dot_3
icon_alias_no_mx osmc_pink_dot_4 osmc_pink_dot_4
icon_alias_no_mx osmc_pink_drop osmc_pink_drop
icon_alias_no_mx osmc_pink_drop_line osmc_pink_drop_line
icon_alias_no_mx osmc_pink_fork osmc_pink_fork
icon_alias_no_mx osmc_pink_hexagon osmc_pink_hexagon
icon_alias_no_mx osmc_pink_hiker osmc_pink_hiker
icon_alias_no_mx osmc_pink_house osmc_pink_house
icon_alias_no_mx osmc_pink_l osmc_pink_l
icon_alias_no_mx osmc_pink_left osmc_pink_left
icon_alias_no_mx osmc_pink_left_arrow osmc_pink_left_arrow
icon_alias_no_mx osmc_pink_left_pointer osmc_pink_left_pointer
icon_alias_no_mx osmc_pink_left_pointer_2 osmc_pink_left_pointer_2
icon_alias_no_mx osmc_pink_left_pointer_3 osmc_pink_left_pointer_3
icon_alias_no_mx osmc_pink_left_pointer_4 osmc_pink_left_pointer_4
icon_alias_no_mx osmc_pink_lower osmc_pink_lower
icon_alias_no_mx osmc_pink_lower_2 osmc_pink_lower_2
icon_alias_no_mx osmc_pink_lower_3 osmc_pink_lower_3
icon_alias_no_mx osmc_pink_lower_4 osmc_pink_lower_4
icon_alias_no_mx osmc_pink_m osmc_pink_m
icon_alias_no_mx osmc_pink_pointer osmc_pink_pointer
icon_alias_no_mx osmc_pink_pointer_2 osmc_pink_pointer_2
icon_alias_no_mx osmc_pink_pointer_3 osmc_pink_pointer_3
icon_alias_no_mx osmc_pink_pointer_4 osmc_pink_pointer_4
icon_alias_no_mx osmc_pink_pointer_line osmc_pink_pointer_line
icon_alias_no_mx osmc_pink_pointer_line_2 osmc_pink_pointer_line_2
icon_alias_no_mx osmc_pink_pointer_line_3 osmc_pink_pointer_line_3
icon_alias_no_mx osmc_pink_pointer_line_4 osmc_pink_pointer_line_4
icon_alias_no_mx osmc_pink_rectangle osmc_pink_rectangle
icon_alias_no_mx osmc_pink_rectangle_2 osmc_pink_rectangle_2
icon_alias_no_mx osmc_pink_rectangle_3 osmc_pink_rectangle_3
icon_alias_no_mx osmc_pink_rectangle_4 osmc_pink_rectangle_4
icon_alias_no_mx osmc_pink_rectangle_line osmc_pink_rectangle_line
icon_alias_no_mx osmc_pink_rectangle_lower osmc_pink_rectangle_lower
icon_alias_no_mx osmc_pink_rectangle_lower_2 osmc_pink_rectangle_lower_2
icon_alias_no_mx osmc_pink_rectangle_lower_3 osmc_pink_rectangle_lower_3
icon_alias_no_mx osmc_pink_rectangle_lower_4 osmc_pink_rectangle_lower_4
icon_alias_no_mx osmc_pink_red_diamond osmc_pink_red_diamond
icon_alias_no_mx osmc_pink_right osmc_pink_right
icon_alias_no_mx osmc_pink_slash osmc_pink_slash
icon_alias_no_mx osmc_pink_stripe osmc_pink_stripe
icon_alias_no_mx osmc_pink_stripe_2 osmc_pink_stripe_2
icon_alias_no_mx osmc_pink_stripe_3 osmc_pink_stripe_3
icon_alias_no_mx osmc_pink_stripe_4 osmc_pink_stripe_4
icon_alias_no_mx osmc_pink_t osmc_pink_t
icon_alias_no_mx osmc_pink_triangle osmc_pink_triangle
icon_alias_no_mx osmc_pink_triangle_2 osmc_pink_triangle_2
icon_alias_no_mx osmc_pink_triangle_3 osmc_pink_triangle_3
icon_alias_no_mx osmc_pink_triangle_4 osmc_pink_triangle_4
icon_alias_no_mx osmc_pink_triangle_line osmc_pink_triangle_line
icon_alias_no_mx osmc_pink_triangle_line_2 osmc_pink_triangle_line_2
icon_alias_no_mx osmc_pink_triangle_line_3 osmc_pink_triangle_line_3
icon_alias_no_mx osmc_pink_triangle_line_4 osmc_pink_triangle_line_4
icon_alias_no_mx osmc_pink_triangle_turned osmc_pink_triangle_turned
icon_alias_no_mx osmc_pink_triangle_turned_2 osmc_pink_triangle_turned_2
icon_alias_no_mx osmc_pink_triangle_turned_3 osmc_pink_triangle_turned_3
icon_alias_no_mx osmc_pink_triangle_turned_4 osmc_pink_triangle_turned_4
icon_alias_no_mx osmc_pink_turned_t osmc_pink_turned_t
icon_alias_no_mx osmc_pink_upper osmc_pink_upper
icon_alias_no_mx osmc_pink_upper_2 osmc_pink_upper_2
icon_alias_no_mx osmc_pink_upper_3 osmc_pink_upper_3
icon_alias_no_mx osmc_pink_upper_4 osmc_pink_upper_4
icon_alias_no_mx osmc_pink_upper_bowl osmc_pink_upper_bowl
icon_alias_no_mx osmc_pink_wheel osmc_pink_wheel
icon_alias_no_mx osmc_pink_x osmc_pink_x
icon_alias_no_mx osmc_pink_x_2 osmc_pink_x_2
icon_alias_no_mx osmc_pink_x_3 osmc_pink_x_3
icon_alias_no_mx osmc_pink_x_4 osmc_pink_x_4

icon_alias_no_mx osmc_teal_arch osmc_teal_arch
icon_alias_no_mx osmc_teal_arrow osmc_teal_arrow
icon_alias_no_mx osmc_teal_backslash osmc_teal_backslash
icon_alias_no_mx osmc_teal_bar osmc_teal_bar
icon_alias_no_mx osmc_teal_bar_2 osmc_teal_bar_2
icon_alias_no_mx osmc_teal_bar_3 osmc_teal_bar_3
icon_alias_no_mx osmc_teal_bar_4 osmc_teal_bar_4
icon_alias_no_mx osmc_teal_bicycle osmc_teal_bicycle
icon_alias_no_mx osmc_teal_bowl osmc_teal_bowl
icon_alias_no_mx osmc_teal_circle osmc_teal_circle
icon_alias_no_mx osmc_teal_circle_arrow osmc_teal_circle_arrow
icon_alias_no_mx osmc_teal_corner osmc_teal_corner
icon_alias_no_mx osmc_teal_corner_left osmc_teal_corner_left
icon_alias_no_mx osmc_teal_crest osmc_teal_crest
icon_alias_no_mx osmc_teal_cross osmc_teal_cross
icon_alias_no_mx osmc_teal_cross_2 osmc_teal_cross_2
icon_alias_no_mx osmc_teal_cross_3 osmc_teal_cross_3
icon_alias_no_mx osmc_teal_cross_4 osmc_teal_cross_4
icon_alias_no_mx osmc_teal_diamond osmc_teal_diamond
icon_alias_no_mx osmc_teal_diamond_corner osmc_teal_diamond_corner
icon_alias_no_mx osmc_teal_diamond_left osmc_teal_diamond_left
icon_alias_no_mx osmc_teal_diamond_line osmc_teal_diamond_line
icon_alias_no_mx osmc_teal_diamond_right osmc_teal_diamond_right
icon_alias_no_mx osmc_teal_dot osmc_teal_dot
icon_alias_no_mx osmc_teal_dot_2 osmc_teal_dot_2
icon_alias_no_mx osmc_teal_dot_3 osmc_teal_dot_3
icon_alias_no_mx osmc_teal_dot_4 osmc_teal_dot_4
icon_alias_no_mx osmc_teal_drop osmc_teal_drop
icon_alias_no_mx osmc_teal_drop_line osmc_teal_drop_line
icon_alias_no_mx osmc_teal_fork osmc_teal_fork
icon_alias_no_mx osmc_teal_hexagon osmc_teal_hexagon
icon_alias_no_mx osmc_teal_hiker osmc_teal_hiker
icon_alias_no_mx osmc_teal_house osmc_teal_house
icon_alias_no_mx osmc_teal_l osmc_teal_l
icon_alias_no_mx osmc_teal_left osmc_teal_left
icon_alias_no_mx osmc_teal_left_arrow osmc_teal_left_arrow
icon_alias_no_mx osmc_teal_left_pointer osmc_teal_left_pointer
icon_alias_no_mx osmc_teal_left_pointer_2 osmc_teal_left_pointer_2
icon_alias_no_mx osmc_teal_left_pointer_3 osmc_teal_left_pointer_3
icon_alias_no_mx osmc_teal_left_pointer_4 osmc_teal_left_pointer_4
icon_alias_no_mx osmc_teal_lower osmc_teal_lower
icon_alias_no_mx osmc_teal_lower_2 osmc_teal_lower_2
icon_alias_no_mx osmc_teal_lower_3 osmc_teal_lower_3
icon_alias_no_mx osmc_teal_lower_4 osmc_teal_lower_4
icon_alias_no_mx osmc_teal_m osmc_teal_m
icon_alias_no_mx osmc_teal_pointer osmc_teal_pointer
icon_alias_no_mx osmc_teal_pointer_2 osmc_teal_pointer_2
icon_alias_no_mx osmc_teal_pointer_3 osmc_teal_pointer_3
icon_alias_no_mx osmc_teal_pointer_4 osmc_teal_pointer_4
icon_alias_no_mx osmc_teal_pointer_line osmc_teal_pointer_line
icon_alias_no_mx osmc_teal_pointer_line_2 osmc_teal_pointer_line_2
icon_alias_no_mx osmc_teal_pointer_line_3 osmc_teal_pointer_line_3
icon_alias_no_mx osmc_teal_pointer_line_4 osmc_teal_pointer_line_4
icon_alias_no_mx osmc_teal_rectangle osmc_teal_rectangle
icon_alias_no_mx osmc_teal_rectangle_2 osmc_teal_rectangle_2
icon_alias_no_mx osmc_teal_rectangle_3 osmc_teal_rectangle_3
icon_alias_no_mx osmc_teal_rectangle_4 osmc_teal_rectangle_4
icon_alias_no_mx osmc_teal_rectangle_line osmc_teal_rectangle_line
icon_alias_no_mx osmc_teal_rectangle_lower osmc_teal_rectangle_lower
icon_alias_no_mx osmc_teal_rectangle_lower_2 osmc_teal_rectangle_lower_2
icon_alias_no_mx osmc_teal_rectangle_lower_3 osmc_teal_rectangle_lower_3
icon_alias_no_mx osmc_teal_rectangle_lower_4 osmc_teal_rectangle_lower_4
icon_alias_no_mx osmc_teal_red_diamond osmc_teal_red_diamond
icon_alias_no_mx osmc_teal_right osmc_teal_right
icon_alias_no_mx osmc_teal_slash osmc_teal_slash
icon_alias_no_mx osmc_teal_stripe osmc_teal_stripe
icon_alias_no_mx osmc_teal_stripe_2 osmc_teal_stripe_2
icon_alias_no_mx osmc_teal_stripe_3 osmc_teal_stripe_3
icon_alias_no_mx osmc_teal_stripe_4 osmc_teal_stripe_4
icon_alias_no_mx osmc_teal_t osmc_teal_t
icon_alias_no_mx osmc_teal_triangle osmc_teal_triangle
icon_alias_no_mx osmc_teal_triangle_2 osmc_teal_triangle_2
icon_alias_no_mx osmc_teal_triangle_3 osmc_teal_triangle_3
icon_alias_no_mx osmc_teal_triangle_4 osmc_teal_triangle_4
icon_alias_no_mx osmc_teal_triangle_line osmc_teal_triangle_line
icon_alias_no_mx osmc_teal_triangle_line_2 osmc_teal_triangle_line_2
icon_alias_no_mx osmc_teal_triangle_line_3 osmc_teal_triangle_line_3
icon_alias_no_mx osmc_teal_triangle_line_4 osmc_teal_triangle_line_4
icon_alias_no_mx osmc_teal_triangle_turned osmc_teal_triangle_turned
icon_alias_no_mx osmc_teal_triangle_turned_2 osmc_teal_triangle_turned_2
icon_alias_no_mx osmc_teal_triangle_turned_3 osmc_teal_triangle_turned_3
icon_alias_no_mx osmc_teal_triangle_turned_4 osmc_teal_triangle_turned_4
icon_alias_no_mx osmc_teal_turned_t osmc_teal_turned_t
icon_alias_no_mx osmc_teal_upper osmc_teal_upper
icon_alias_no_mx osmc_teal_upper_2 osmc_teal_upper_2
icon_alias_no_mx osmc_teal_upper_3 osmc_teal_upper_3
icon_alias_no_mx osmc_teal_upper_4 osmc_teal_upper_4
icon_alias_no_mx osmc_teal_upper_bowl osmc_teal_upper_bowl
icon_alias_no_mx osmc_teal_wheel osmc_teal_wheel
icon_alias_no_mx osmc_teal_x osmc_teal_x
icon_alias_no_mx osmc_teal_x_2 osmc_teal_x_2
icon_alias_no_mx osmc_teal_x_3 osmc_teal_x_3
icon_alias_no_mx osmc_teal_x_4 osmc_teal_x_4

icon_alias_no_mx osmc_ammonit osmc_ammonit
icon_alias_no_mx osmc_black_horse osmc_black_horse
icon_alias_no_mx osmc_black_runner osmc_black_runner
icon_alias_no_mx osmc_blue_grape osmc_blue_grape
icon_alias_no_mx osmc_blue_wheelchair osmc_blue_wheelchair
icon_alias_no_mx osmc_brown_right osmc_brown_right
icon_alias_no_mx osmc_gray_pointer osmc_gray_pointer
icon_alias_no_mx osmc_gray_stripe osmc_gray_stripe
icon_alias_no_mx osmc_gray_wheel osmc_gray_wheel
icon_alias_no_mx osmc_gray_arrow osmc_gray_arrow
icon_alias_no_mx osmc_gray_triangle osmc_gray_triangle
icon_alias_no_mx osmc_green_wheelchair osmc_green_wheelchair
icon_alias_no_mx osmc_green_z osmc_green_z
icon_alias_no_mx osmc_heart osmc_heart
icon_alias_no_mx osmc_hiker osmc_hiker
icon_alias_no_mx osmc_mine osmc_mine
icon_alias_no_mx osmc_purple_bar osmc_purple_bar
icon_alias_no_mx osmc_purple_circle osmc_purple_circle
icon_alias_no_mx osmc_purple_diamond osmc_purple_diamond
icon_alias_no_mx osmc_purple_dot osmc_purple_dot
icon_alias_no_mx osmc_purple_l osmc_purple_l
icon_alias_no_mx osmc_purple_m osmc_purple_m
icon_alias_no_mx osmc_purple_pointer osmc_purple_pointer
icon_alias_no_mx osmc_purple_rectangle osmc_purple_rectangle
icon_alias_no_mx osmc_purple_stripe osmc_purple_stripe
icon_alias_no_mx osmc_red_blue_diamond osmc_red_blue_diamond
icon_alias_no_mx osmc_red_diamond_green_grape osmc_red_diamond_green_grape
icon_alias_no_mx osmc_red_diamond_yellow_grape osmc_red_diamond_yellow_grape
icon_alias_no_mx osmc_red_flower osmc_red_flower
icon_alias_no_mx osmc_red_grape osmc_red_grape
icon_alias_no_mx osmc_red_wheelchair osmc_red_wheelchair
icon_alias_no_mx osmc_shell_modern osmc_shell_modern
icon_alias_no_mx osmc_shell osmc_shell
icon_alias_no_mx osmc_tower osmc_tower
icon_alias_no_mx osmc_white_black_diamond osmc_white_black_diamond
icon_alias_no_mx osmc_white_shell osmc_white_shell
icon_alias_no_mx osmc_white_shell_modern osmc_white_shell_modern
icon_alias_no_mx osmc_white_wheelchair osmc_white_wheelchair
icon_alias_no_mx osmc_wolfshook osmc_wolfshook
icon_alias_no_mx osmc_yellow_mz osmc_yellow_mz
icon_alias_no_mx osmc_yellow_sg osmc_yellow_sg
icon_alias_no_mx osmc_yellow_shell osmc_yellow_shell
icon_alias_no_mx osmc_yellow_shell_modern osmc_yellow_shell_modern

# Additional
icon_alias cuisine additional_cuisine
icon_alias website additional_website
icon_alias email additional_email
icon_alias facebook additional_facebook
icon_alias twitter additional_twitter
icon_alias youtube additional_youtube
icon_alias vk additional_vk
icon_alias instagram additional_instagram
icon_alias fee_yes additional_fee_yes
icon_alias fee_no additional_fee_no
icon_alias ele additional_ele
icon_alias width additional_width
icon_alias height additional_height
icon_alias abandoned additional_abandoned
icon_alias disused additional_disused
icon_alias drinking_water_yes additional_drinking_water_yes
icon_alias drinking_water_no additional_drinking_water_no
icon_alias seasonal_no additional_seasonal_no
icon_alias seasonal_yes additional_seasonal_yes
icon_alias seasonal_summer additional_seasonal_summer
icon_alias seasonal_winter additional_seasonal_winter
icon_alias route_bus_ref transport_bus_stop
icon_alias route_tram_ref additional_tram
icon_alias route_trolleybus_ref additional_trolleybus
icon_alias route_train_ref transport_train_station2
icon_alias route_share_taxi_ref additional_share_taxi
icon_alias route_railway_ref transport_train_station
icon_alias route_ferry_ref transport_ferry_terminal
icon_alias route_funicular_ref transport_funicular
icon_alias route_monorail_ref additional_monorail
icon_alias route_light_rail_ref additional_light_rail
icon_alias shop_yes shopping_convenience
icon_alias beauty_salon_nails additional_beauty_salon_nails
icon_alias historic_yes tourist_archaeological2
icon_alias lit_yes additional_lit_yes
icon_alias lit_no additional_lit_no
icon_alias elevator_yes poi_colored_elevator
icon_alias elevator poi_colored_elevator
icon_alias theatre_genre_comedy additional_comedy
icon_alias temperature additional_temperature
icon_alias conveying_yes additional_conveying_yes
icon_alias shoes_women additional_shoes_women
icon_alias shoes_children additional_shoes_children
icon_alias shoes_men shopping_shoes
icon_alias cargo_vehicle additional_cargo_vehicle
icon_alias cargo_passengers additional_cargo_passengers
icon_alias bridge_movable_lift additional_bridge_movable_lift
icon_alias bridge_structure_arch additional_bridge_structure_arch
icon_alias bridge_structure_beam additional_bridge_structure_beam
icon_alias bridge_structure_suspension additional_bridge_structure_suspension
icon_alias bridge_type_movable additional_bridge_type_movable
icon_alias building_type_basilica additional_building_type_basilica
icon_alias building_type_cathedral additional_building_type_cathedral
icon_alias building_type_chapel additional_building_type_chapel
icon_alias building_type_church additional_building_type_church
icon_alias building_type_monastery additional_building_type_monastery
icon_alias building_type_mosque additional_building_type_mosque
icon_alias building_type_pyramid additional_building_type_pyramid
icon_alias building_type_synagogue additional_building_type_synagogue
icon_alias tourism_yes additional_tourism_yes
icon_alias supervised_yes additional_supervised_yes
icon_alias supervised_no additional_supervised_no
icon_alias access_no additional_access_no
icon_alias access_private additional_access_private
icon_alias smoking_yes additional_smoking_yes
icon_alias smoking_no additional_smoking_no
icon_alias covered_yes additional_covered_yes
icon_alias covered_no additional_covered_no
icon_alias male_yes additional_male_yes
icon_alias male_no additional_male_no
icon_alias female_yes additional_female_yes
icon_alias female_no additional_female_no
icon_alias wheelchair_yes additional_wheelchair
icon_alias wheelchair_designated additional_wheelchair
icon_alias wheelchair_no additional_wheelchair_no
icon_alias bench_yes additional_bench_yes
icon_alias bench_no additional_bench_no
icon_alias bin_yes additional_bin_yes
icon_alias bin_no additional_bin_no
icon_alias surface_sand additional_surface_sand
icon_alias recycling_container amenity_colored_waste_disposal
icon_alias recycling_centre additional_recycling_centre
icon_alias crossing_traffic_signals additional_crossing_traffic_lights
icon_alias crossing_unmarked additional_crossing_unmarked
icon_alias crossing_uncontrolled additional_crossing_uncontrolled
icon_alias vending_parking_tickets additional_vending_parking_tickets
icon_alias vending_cigarettes additional_vending_cigarettes
icon_alias vending_excrement_bags additional_vending_excrement_bags
icon_alias vending_public_transport_tickets additional_vending_public_transport_tickets
icon_alias vending_drinks additional_vending_drinks
icon_alias vending_sweets additional_vending_sweets
icon_alias vending_parcel_pickup_mail_in additional_vending_parcel_pickup_mail_in
icon_alias vending_condoms additional_vending_condoms
icon_alias vending_stamps additional_vending_stamps
icon_alias product_brick additional_product_brick
icon_alias backrest_yes additional_backrest_yes
icon_alias backrest_no additional_backrest_no
icon_alias construction_yes additional_construction_yes
icon_alias atm_yes additional_atm_yes
icon_alias atm_no additional_atm_no
icon_alias compressed_air_yes additional_compressed_air_yes
icon_alias compressed_air_no additional_compressed_air_no
icon_alias car_wash_yes additional_car_wash_yes
icon_alias car_wash_no additional_car_wash_no
icon_alias vacuum_cleaner_yes additional_vacuum_cleaner_yes
icon_alias button_operated_yes additional_button_operated_yes
icon_alias button_operated_no additional_button_operated_no
icon_alias shop_additional_yes additional_shop_additional_yes
icon_alias salt_yes additional_salt_yes
icon_alias dispensing_yes additional_dispensing_yes
icon_alias dispensing_no additional_dispensing_no
icon_alias aerodrome_type_military additional_aerodrome_type_military
icon_alias telescope_type_optical additional_telescope_type_optical
icon_alias telescope_type_radio additional_telescope_type_radio
icon_alias motorcycle_clothes_no additional_motorcycle_clothes_no
icon_alias motorcycle_clothes_yes additional_motorcycle_clothes_yes
icon_alias motorcycle_parts_no additional_motorcycle_parts_no
icon_alias motorcycle_parts_yes additional_motorcycle_parts_yes
icon_alias motorcycle_rental_no additional_motorcycle_rental_no
icon_alias motorcycle_rental_yes additional_motorcycle_rental_yes
icon_alias motorcycle_repair_no additional_motorcycle_repair_no
icon_alias motorcycle_repair_yes additional_motorcycle_repair_yes
icon_alias motorcycle_sales_no additional_motorcycle_sales_no
icon_alias motorcycle_sales_yes additional_motorcycle_sales_yes
icon_alias delivery_yes additional_delivery_yes
icon_alias delivery_no additional_delivery_no
icon_alias architect_name additional_architect_name
icon_alias start_date additional_start_date
icon_alias foot_yes additional_foot_yes
icon_alias foot_no additional_foot_no
icon_alias horse_no additional_horse_no
icon_alias bus_yes additional_bus_yes
icon_alias bicycle_no additional_bicycle_no
icon_alias hgv_yes additional_hgv_yes
icon_alias hgv_no additional_hgv_no
icon_alias mofa_yes additional_mofa_yes
icon_alias motorcar_no additional_motorcar_no
icon_alias motorcycle_no additional_motorcycle_no
icon_alias snowmobile_yes additional_snowmobile_yes
icon_alias snowmobile_no additional_snowmobile_no

#Additional category
icon_alias payment_type additional_category_payment_type
icon_alias park_ride additional_category_park_ride

#Xmas
icon_alias xmas xmas_tree
icon xmas_event
icon xmas_market
icon xmas_pyramid
icon xmas_shop
icon xmas_tree

#Special
icon special_building
icon special_building
icon special_flag_stroke
icon special_flag
icon special_house
icon special_marker
icon special_star_stroked
icon special_star
icon special_number_0
icon special_number_1
icon special_number_2
icon special_number_3
icon special_number_4
icon special_number_5
icon special_number_6
icon special_number_7
icon special_number_8
icon special_number_9
icon special_bookmark
icon special_flag_finish
icon special_flag_start
icon special_heart
icon special_bicycle
icon special_camper
icon special_campervan
icon special_helicopter
icon special_horse
icon special_monowheel
icon special_motorcycle
icon special_motor_scooter
icon special_enduro_motorcycle
icon special_offroad
icon special_openstreetmap
icon special_personal_transporter
icon special_pickup_truck
icon special_sail_boat 
icon special_scooter
icon special_shuttle_bus
icon special_ski_touring
icon special_skiing
icon special_snowmobile
icon special_subway
icon special_taxi
icon special_trekking
icon special_truck
icon special_utv
icon special_wagon
icon special_custom_category
icon special_parking_time_limited
icon special_arrow_left
icon special_arrow_right
icon special_arrow_up
icon special_arrow_down
icon special_arrow_right_arrow_left
icon special_arrow_up_arrow_down
icon special_arrow_right_and_left
icon special_arrow_up_and_down
icon special_arrow_down_left
icon special_arrow_down_right
icon special_arrow_up_left
icon special_arrow_up_right
icon special_symbol_number
icon special_symbol_plus
icon special_symbol_minus
icon special_symbol_question_mark
icon special_symbol_exclamation_mark
icon special_symbol_at_sign
icon special_letter_n
icon special_letter_s
icon special_letter_e
icon special_letter_w
icon special_symbol_remove
icon special_symbol_check_mark
icon special_microphone
icon special_photo_camera
icon special_video_camera
icon special_sun
icon special_sunset
icon special_video
icon special_audio
icon special_image
icon special_time_span
icon special_time_start
icon special_time_end
icon special_information
icon special_walking
icon special_kayak
icon_alias route_article_point special_route_article_point
icon_alias route_article special_route_article
icon_alias route_track special_route_track
icon_alias routes special_routes 
icon_alias special_person special_person
icon_alias special_people_group special_people_group
icon special_point_start_finish
icon special_point_start
icon special_point_finish osmc_brown_hiker
icon_alias_no_mx osmc_brown

#Activities
icon activities_aircraft
icon activities_baby_transport
icon activities_bicycle
icon activities_bus
icon activities_camper
icon activities_campervan
icon activities_car
icon activities_dirt_motorcycle
icon activities_electric_bike
icon activities_enduro_motorcycle
icon activities_go_cart
icon activities_hang_gliding
icon activities_helicopter
icon activities_hill_climbing
icon activities_horse
icon activities_ice_skating
icon activities_inline_skates
icon activities_kayak
icon activities_light_aircraft
icon activities_monowheel
icon activities_motor_scooter 
icon activities_motorboat
icon activities_motorcycle
icon activities_mountain_bike
icon activities_offroad
icon activities_paragliding
icon activities_pedestrian
icon activities_personal_transporter
icon activities_pickup_truck
icon activities_sail_boat
icon activities_scooter
icon activities_shuttle_bus
icon activities_ski_touring
icon activities_skiing
icon activities_snowboarding
icon activities_snowmobile
icon activities_snowshoeing
icon activities_subway
icon activities_suv
icon activities_train
icon activities_trekking
icon activities_truck
icon activities_utv
icon activities_wagon
icon activities_wheelchair
icon activities_wheelchair_forward
icon activities_scuba_diving
icon activities_windsurfing
icon activities_waterskiing
icon activities_swimming_outdoor
icon activities_surfing
icon activities_running
icon activities_horse_riding
icon activities_diving
icon activities_canoe

# routes_ (activities.json)
icon_alias routes_driving activities_car
icon_alias routes_motorcycling activities_motorcycle
icon_alias routes_foot activities_pedestrian
icon_alias routes_winter_sport activities_skiing
icon_alias routes_cycling activities_bicycle
icon_alias routes_air_sports activities_light_aircraft
icon_alias routes_water_sport activities_kayak
icon_alias routes_other special_route_track
icon_alias route_track_point special_marker

# route_activity_type_ (activities.json)
icon_alias route_activity_type_car activities_car
icon_alias route_activity_type_off_road activities_offroad
icon_alias route_activity_type_all_terrain_vehicle activities_utv
icon_alias route_activity_type_truck_hgv activities_truck
icon_alias route_activity_type_karting activities_go_cart
icon_alias route_activity_type_adventure_motorcycling activities_motorcycle
icon_alias route_activity_type_enduro_motorcycling activities_enduro_motorcycle
icon_alias route_activity_type_motocross activities_enduro_motorcycle
icon_alias route_activity_type_off_road_motorcycling_dirt_biking activities_dirt_motorcycle
icon_alias route_activity_type_road_motorcycling activities_motorcycle
icon_alias route_activity_type_motor_scooter activities_motor_scooter
icon_alias route_activity_type_backpacking activities_trekking
icon_alias route_activity_type_hiking activities_trekking
icon_alias route_activity_type_hill_climbing activities_hill_climbing
icon_alias route_activity_type_road_running activities_running
icon_alias route_activity_type_trail_running activities_running
icon_alias route_activity_type_trekking activities_trekking
icon_alias route_activity_type_walking activities_pedestrian
icon_alias route_activity_type_cross_country_skiing activities_skiing
icon_alias route_activity_type_ice_skating activities_ice_skating
icon_alias route_activity_type_ski_touring activities_ski_touring
icon_alias route_activity_type_skiing activities_skiing
icon_alias route_activity_type_snowboarding activities_snowboarding
icon_alias route_activity_type_snowmobiling activities_snowmobile
icon_alias route_activity_type_snowshoeing activities_snowshoeing
icon_alias route_activity_type_e_biking activities_electric_bike
icon_alias route_activity_type_e_mountain_bike activities_electric_bike
icon_alias route_activity_type_gravel_biking activities_mountain_bike
icon_alias route_activity_type_mountain_biking activities_mountain_bike
icon_alias route_activity_type_road_cycling activities_bicycle
icon_alias route_activity_type_touring activities_bicycle
icon_alias route_activity_type_aviation activities_light_aircraft
icon_alias route_activity_type_hang_gliding activities_hang_gliding
icon_alias route_activity_type_parachuting_skydiving activities_paragliding
icon_alias route_activity_type_paragliding activities_paragliding
icon_alias route_activity_type_canoe activities_canoe
icon_alias route_activity_type_diving activities_diving
icon_alias route_activity_type_scuba_diving activities_scuba_diving
icon_alias route_activity_type_kayak activities_kayak
icon_alias route_activity_type_surfing activities_surfing
icon_alias route_activity_type_swimming_outdoor activities_swimming_outdoor
icon_alias route_activity_type_waterskiing activities_waterskiing
icon_alias route_activity_type_windsurfing activities_windsurfing
icon_alias route_activity_type_motorboat activities_motorboat
icon_alias route_activity_type_horse_riding activities_horse_riding
icon_alias route_activity_type_train_riding activities_train
icon_alias route_activity_type_fitness sport_fitness_station
icon_alias route_activity_type_inline_skates activities_inline_skates

# AIS plugin icons
icon ais_aton_virt
icon ais_aton
icon ais_land
icon ais_plane
icon ais_sar
icon ais_vessel_cross
icon ais_vessel_red
icon ais_vessel