#!/bin/bash

if [ -z "$BASH_VERSION" ]; then
	echo "Invalid shell, re-running using bash..."
	exec bash "$0" "$@"
	exit $?
fi
SRCLOC="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
source "$SRCLOC/../../../build/utils/functions.sh"

prepareUpstreamFromTarArchive "$SRCLOC" "http://builder.osmand.net/dependencies-mirror/GeographicLib-1.46.tar.gz"
        echo d16cae735dc6fd58317cad39cce73f19808a99fa6054fa587bd3d6a3ab621cb4 "$SRCLOC/upstream.pack" | sha256sum --check -        || { echo 'Failed checksum' 1>&2; exit; }
patchUpstream "$SRCLOC"
