package net.osmand.plus.plugins.aistracker;

import java.util.Map;

public final class AisObjectConstants {

	public final static int INVALID_HEADING = 511;
	public final static int INVALID_NAV_STATUS = 15;
	public final static int INVALID_MANEUVER_INDICATOR = 0;
	public final static int INVALID_SHIP_TYPE = 0;
	public final static int INVALID_DIMENSION = 0;
	public final static int INVALID_ETA = 0;
	public final static int INVALID_ETA_HOUR = 24;
	public final static int INVALID_ETA_MIN = 60;
	public final static int INVALID_ALTITUDE = 4095;
	public final static int UNSPECIFIED_AID_TYPE = 0;
	public final static double INVALID_COG = 360.0;
	public final static double INVALID_SOG = 1023.0;
	public final static double INVALID_LAT = 91.0;
	public final static double INVALID_LON = 181.0;
	public final static double INVALID_ROT = 128.0;
	public final static double INVALID_DRAUGHT = 0.0;
	public final static double INVALID_TCPA = -10000.0d;
	public final static float INVALID_CPA = -1.0f;
	public final static int CPA_UPDATE_TIMEOUT_IN_SECONDS = 10;

	public static final Map<Integer, String> COUNTRY_CODES = Map.ofEntries(
			Map.entry(201, "Albania"),
			Map.entry(202, "Andorra"),
			Map.entry(203, "Austria"),
			Map.entry(204, "Portugal"),
			Map.entry(205, "Belgium"),
			Map.entry(206, "Belarus"),
			Map.entry(207, "Bulgaria"),
			Map.entry(208, "Vatican"),
			Map.entry(209, "Cyprus"),
			Map.entry(210, "Cyprus"),
			Map.entry(211, "Germany"),
			Map.entry(212, "Cyprus"),
			Map.entry(213, "Georgia"),
			Map.entry(214, "Moldova"),
			Map.entry(215, "Malta"),
			Map.entry(216, "Armenia"),
			Map.entry(218, "Germany"),
			Map.entry(219, "Denmark"),
			Map.entry(220, "Denmark"),
			Map.entry(224, "Spain"),
			Map.entry(225, "Spain"),
			Map.entry(226, "France"),
			Map.entry(227, "France"),
			Map.entry(228, "France"),
			Map.entry(229, "Malta"),
			Map.entry(230, "Finland"),
			Map.entry(231, "Faroe Is"),
			Map.entry(232, "United Kingdom"),
			Map.entry(233, "United Kingdom"),
			Map.entry(234, "United Kingdom"),
			Map.entry(235, "United Kingdom"),
			Map.entry(236, "Gibraltar"),
			Map.entry(237, "Greece"),
			Map.entry(238, "Croatia"),
			Map.entry(239, "Greece"),
			Map.entry(240, "Greece"),
			Map.entry(241, "Greece"),
			Map.entry(242, "Morocco"),
			Map.entry(243, "Hungary"),
			Map.entry(244, "Netherlands"),
			Map.entry(245, "Netherlands"),
			Map.entry(246, "Netherlands"),
			Map.entry(247, "Italy"),
			Map.entry(248, "Malta"),
			Map.entry(249, "Malta"),
			Map.entry(250, "Ireland"),
			Map.entry(251, "Iceland"),
			Map.entry(252, "Liechtenstein"),
			Map.entry(253, "Luxembourg"),
			Map.entry(254, "Monaco"),
			Map.entry(255, "Portugal"),
			Map.entry(256, "Malta"),
			Map.entry(257, "Norway"),
			Map.entry(258, "Norway"),
			Map.entry(259, "Norway"),
			Map.entry(261, "Poland"),
			Map.entry(262, "Montenegro"),
			Map.entry(263, "Portugal"),
			Map.entry(264, "Romania"),
			Map.entry(265, "Sweden"),
			Map.entry(266, "Sweden"),
			Map.entry(267, "Slovakia"),
			Map.entry(268, "San Marino"),
			Map.entry(269, "Switzerland"),
			Map.entry(270, "Czech Republic"),
			Map.entry(271, "Turkey"),
			Map.entry(272, "Ukraine"),
			Map.entry(273, "Russia"),
			Map.entry(274, "FYR Macedonia"),
			Map.entry(275, "Latvia"),
			Map.entry(276, "Estonia"),
			Map.entry(277, "Lithuania"),
			Map.entry(278, "Slovenia"),
			Map.entry(279, "Serbia"),
			Map.entry(301, "Anguilla"),
			Map.entry(303, "USA"),
			Map.entry(304, "Antigua Barbuda"),
			Map.entry(305, "Antigua Barbuda"),
			Map.entry(306, "Curacao"),
			Map.entry(307, "Aruba"),
			Map.entry(308, "Bahamas"),
			Map.entry(309, "Bahamas"),
			Map.entry(310, "Bermuda"),
			Map.entry(311, "Bahamas"),
			Map.entry(312, "Belize"),
			Map.entry(314, "Barbados"),
			Map.entry(316, "Canada"),
			Map.entry(319, "Cayman Is"),
			Map.entry(321, "Costa Rica"),
			Map.entry(323, "Cuba"),
			Map.entry(325, "Dominica"),
			Map.entry(327, "Dominican Rep"),
			Map.entry(329, "Guadeloupe"),
			Map.entry(330, "Grenada"),
			Map.entry(331, "Greenland"),
			Map.entry(332, "Guatemala"),
			Map.entry(334, "Honduras"),
			Map.entry(336, "Haiti"),
			Map.entry(338, "USA"),
			Map.entry(339, "Jamaica"),
			Map.entry(341, "St Kitts Nevis"),
			Map.entry(343, "St Lucia"),
			Map.entry(345, "Mexico"),
			Map.entry(347, "Martinique"),
			Map.entry(348, "Montserrat"),
			Map.entry(350, "Nicaragua"),
			Map.entry(351, "Panama"),
			Map.entry(352, "Panama"),
			Map.entry(353, "Panama"),
			Map.entry(354, "Panama"),
			Map.entry(355, "Panama"),
			Map.entry(356, "Panama"),
			Map.entry(357, "Panama"),
			Map.entry(358, "Puerto Rico"),
			Map.entry(359, "El Salvador"),
			Map.entry(361, "St Pierre Miquelon"),
			Map.entry(362, "Trinidad Tobago"),
			Map.entry(364, "Turks Caicos Is"),
			Map.entry(366, "USA"),
			Map.entry(367, "USA"),
			Map.entry(368, "USA"),
			Map.entry(369, "USA"),
			Map.entry(370, "Panama"),
			Map.entry(371, "Panama"),
			Map.entry(372, "Panama"),
			Map.entry(373, "Panama"),
			Map.entry(374, "Panama"),
			Map.entry(375, "St Vincent Grenadines"),
			Map.entry(376, "St Vincent Grenadines"),
			Map.entry(377, "St Vincent Grenadines"),
			Map.entry(378, "British Virgin Is"),
			Map.entry(379, "US Virgin Is"),
			Map.entry(401, "Afghanistan"),
			Map.entry(403, "Saudi Arabia"),
			Map.entry(405, "Bangladesh"),
			Map.entry(408, "Bahrain"),
			Map.entry(410, "Bhutan"),
			Map.entry(412, "China"),
			Map.entry(413, "China"),
			Map.entry(414, "China"),
			Map.entry(416, "Taiwan"),
			Map.entry(417, "Sri Lanka"),
			Map.entry(419, "India"),
			Map.entry(422, "Iran"),
			Map.entry(423, "Azerbaijan"),
			Map.entry(425, "Iraq"),
			Map.entry(428, "Israel"),
			Map.entry(431, "Japan"),
			Map.entry(432, "Japan"),
			Map.entry(434, "Turkmenistan"),
			Map.entry(436, "Kazakhstan"),
			Map.entry(437, "Uzbekistan"),
			Map.entry(438, "Jordan"),
			Map.entry(440, "Korea"),
			Map.entry(441, "Korea"),
			Map.entry(443, "Palestine"),
			Map.entry(445, "DPR Korea"),
			Map.entry(447, "Kuwait"),
			Map.entry(450, "Lebanon"),
			Map.entry(451, "Kyrgyz Republic"),
			Map.entry(453, "Macao"),
			Map.entry(455, "Maldives"),
			Map.entry(457, "Mongolia"),
			Map.entry(459, "Nepal"),
			Map.entry(461, "Oman"),
			Map.entry(463, "Pakistan"),
			Map.entry(466, "Qatar"),
			Map.entry(468, "Syria"),
			Map.entry(470, "UAE"),
			Map.entry(471, "UAE"),
			Map.entry(472, "Tajikistan"),
			Map.entry(473, "Yemen"),
			Map.entry(475, "Yemen"),
			Map.entry(477, "Hong Kong"),
			Map.entry(478, "Bosnia and Herzegovina"),
			Map.entry(501, "Antarctica"),
			Map.entry(503, "Australia"),
			Map.entry(506, "Myanmar"),
			Map.entry(508, "Brunei"),
			Map.entry(510, "Micronesia"),
			Map.entry(511, "Palau"),
			Map.entry(512, "New Zealand"),
			Map.entry(514, "Cambodia"),
			Map.entry(515, "Cambodia"),
			Map.entry(516, "Christmas Is"),
			Map.entry(518, "Cook Is"),
			Map.entry(520, "Fiji"),
			Map.entry(523, "Cocos Is"),
			Map.entry(525, "Indonesia"),
			Map.entry(529, "Kiribati"),
			Map.entry(531, "Laos"),
			Map.entry(533, "Malaysia"),
			Map.entry(536, "N Mariana Is"),
			Map.entry(538, "Marshall Is"),
			Map.entry(540, "New Caledonia"),
			Map.entry(542, "Niue"),
			Map.entry(544, "Nauru"),
			Map.entry(546, "French Polynesia"),
			Map.entry(548, "Philippines"),
			Map.entry(553, "Papua New Guinea"),
			Map.entry(555, "Pitcairn Is"),
			Map.entry(557, "Solomon Is"),
			Map.entry(559, "American Samoa"),
			Map.entry(561, "Samoa"),
			Map.entry(563, "Singapore"),
			Map.entry(564, "Singapore"),
			Map.entry(565, "Singapore"),
			Map.entry(566, "Singapore"),
			Map.entry(567, "Thailand"),
			Map.entry(570, "Tonga"),
			Map.entry(572, "Tuvalu"),
			Map.entry(574, "Vietnam"),
			Map.entry(576, "Vanuatu"),
			Map.entry(577, "Vanuatu"),
			Map.entry(578, "Wallis Futuna Is"),
			Map.entry(601, "South Africa"),
			Map.entry(603, "Angola"),
			Map.entry(605, "Algeria"),
			Map.entry(607, "St Paul Amsterdam Is"),
			Map.entry(608, "Ascension Is"),
			Map.entry(609, "Burundi"),
			Map.entry(610, "Benin"),
			Map.entry(611, "Botswana"),
			Map.entry(612, "Cen Afr Rep"),
			Map.entry(613, "Cameroon"),
			Map.entry(615, "Congo"),
			Map.entry(616, "Comoros"),
			Map.entry(617, "Cape Verde"),
			Map.entry(618, "Antarctica"),
			Map.entry(619, "Ivory Coast"),
			Map.entry(620, "Comoros"),
			Map.entry(621, "Djibouti"),
			Map.entry(622, "Egypt"),
			Map.entry(624, "Ethiopia"),
			Map.entry(625, "Eritrea"),
			Map.entry(626, "Gabon"),
			Map.entry(627, "Ghana"),
			Map.entry(629, "Gambia"),
			Map.entry(630, "Guinea-Bissau"),
			Map.entry(631, "Equ. Guinea"),
			Map.entry(632, "Guinea"),
			Map.entry(633, "Burkina Faso"),
			Map.entry(634, "Kenya"),
			Map.entry(635, "Antarctica"),
			Map.entry(636, "Liberia"),
			Map.entry(637, "Liberia"),
			Map.entry(642, "Libya"),
			Map.entry(644, "Lesotho"),
			Map.entry(645, "Mauritius"),
			Map.entry(647, "Madagascar"),
			Map.entry(649, "Mali"),
			Map.entry(650, "Mozambique"),
			Map.entry(654, "Mauritania"),
			Map.entry(655, "Malawi"),
			Map.entry(656, "Niger"),
			Map.entry(657, "Nigeria"),
			Map.entry(659, "Namibia"),
			Map.entry(660, "Reunion"),
			Map.entry(661, "Rwanda"),
			Map.entry(662, "Sudan"),
			Map.entry(663, "Senegal"),
			Map.entry(664, "Seychelles"),
			Map.entry(665, "St Helena"),
			Map.entry(666, "Somalia"),
			Map.entry(667, "Sierra Leone"),
			Map.entry(668, "Sao Tome Principe"),
			Map.entry(669, "Swaziland"),
			Map.entry(670, "Chad"),
			Map.entry(671, "Togo"),
			Map.entry(672, "Tunisia"),
			Map.entry(674, "Tanzania"),
			Map.entry(675, "Uganda"),
			Map.entry(676, "DR Congo"),
			Map.entry(677, "Tanzania"),
			Map.entry(678, "Zambia"),
			Map.entry(679, "Zimbabwe"),
			Map.entry(701, "Argentina"),
			Map.entry(710, "Brazil"),
			Map.entry(720, "Bolivia"),
			Map.entry(725, "Chile"),
			Map.entry(730, "Colombia"),
			Map.entry(735, "Ecuador"),
			Map.entry(740, "UK"),
			Map.entry(745, "Guiana"),
			Map.entry(750, "Guyana"),
			Map.entry(755, "Paraguay"),
			Map.entry(760, "Peru"),
			Map.entry(765, "Suriname"),
			Map.entry(770, "Uruguay"),
			Map.entry(775, "Venezuela"));
}

