package net.osmand.plus.help;

import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.appcompat.app.ActionBar;
import androidx.fragment.app.FragmentManager;

import net.osmand.plus.OsmandApplication;
import net.osmand.plus.R;
import net.osmand.plus.help.LoadArticlesTask.LoadArticlesListener;
import net.osmand.plus.plugins.development.BaseLogcatActivity;
import net.osmand.plus.utils.AndroidUtils;
import net.osmand.util.Algorithms;


public class HelpActivity extends BaseLogcatActivity implements LoadArticlesListener {

	private static final int LOGCAT_READ_MS = 5 * 1000;

	private HelpArticlesHelper articlesHelper;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		app.applyTheme(this);
		super.onCreate(savedInstanceState);

		articlesHelper = app.getHelpArticlesHelper();
		if (Algorithms.isEmpty(articlesHelper.getArticles()) && !articlesHelper.isLoadingArticles()) {
			articlesHelper.loadArticles();
		}

		ActionBar actionBar = getSupportActionBar();
		if (actionBar != null) {
			actionBar.setTitle(R.string.shared_string_help);
			actionBar.setElevation(5.0f);
		}
		setContentView(R.layout.help_activity);
		if (savedInstanceState == null) {
			HelpMainFragment.showInstance(getSupportFragmentManager());
		}
	}

	@Override
	protected void onResume() {
		super.onResume();
		articlesHelper.addListener(this);
	}

	@Override
	protected void onPause() {
		super.onPause();
		stopLogcatAsyncTask();
		articlesHelper.removeListener(this);
	}

	public void updateContent() {
		FragmentManager manager = getSupportFragmentManager();
		HelpMainFragment fragment = (HelpMainFragment) manager.findFragmentByTag(HelpMainFragment.TAG);
		if (fragment != null && fragment.isAdded()) {
			fragment.updateContent();
		}
	}

	protected void readAndSaveLogs() {
		logs.clear();

		startLogcatAsyncTask();
		setSupportProgressBarIndeterminateVisibility(true);

		app.runInUIThread(() -> {
			stopLogcatAsyncTask();
			startSaveLogsAsyncTask();
			setSupportProgressBarIndeterminateVisibility(false);
		}, LOGCAT_READ_MS);
	}

	@NonNull
	@Override
	protected String getFilterLevel() {
		return "";
	}

	@Override
	public void downloadStarted() {
		app.runInUIThread(() -> {
			if (AndroidUtils.isActivityNotDestroyed(this)) {
				setSupportProgressBarIndeterminateVisibility(true);
			}
		});
	}

	@Override
	public void downloadFinished() {
		app.runInUIThread(() -> {
			if (AndroidUtils.isActivityNotDestroyed(this)) {
				updateContent();
				setSupportProgressBarIndeterminateVisibility(false);
			}
		});
	}
}