package net.opendasharchive.openarchive.features.folders

import android.content.res.Configuration.UI_MODE_NIGHT_YES
import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.foundation.verticalScroll
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.ArrowForward
import androidx.compose.material.icons.filled.ArrowForward
import androidx.compose.material3.Card
import androidx.compose.material3.CardDefaults
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Scaffold
import androidx.compose.material3.Text
import androidx.compose.material3.TopAppBar
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalView
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import androidx.navigation.findNavController
import net.opendasharchive.openarchive.R
import net.opendasharchive.openarchive.core.presentation.theme.DefaultScaffoldPreview
import net.opendasharchive.openarchive.core.presentation.theme.SaveAppTheme

@Composable
fun AddFolderScreen() {

    val navController = LocalView.current.findNavController()

    SaveAppTheme {
        AddFolderScreenContent(
            onCreateFolder = {
                navController.navigate(R.id.fragment_add_folder_to_fragment_create_new_folder)
            },
            onBrowseFolders = {
                navController.navigate(R.id.fragment_add_folder_to_fragment_browse_folders)
            }
        )
    }

}


@Composable
fun AddFolderScreenContent(
    onCreateFolder: () -> Unit,
    onBrowseFolders: () -> Unit
) {


    Column(
        modifier = Modifier
            .fillMaxSize()
            .padding()
            .padding(vertical = 24.dp)
            .verticalScroll(rememberScrollState()),
        horizontalAlignment = Alignment.CenterHorizontally
    ) {
        Spacer(modifier = Modifier.height(32.dp))

        Text(
            text = stringResource(id = R.string.select_where_to_store_your_media),
            fontSize = 18.sp,
            color = MaterialTheme.colorScheme.onSurface,
            fontWeight = FontWeight.SemiBold,
            textAlign = TextAlign.Center,
            modifier = Modifier.padding(horizontal = 64.dp)
        )

        Spacer(modifier = Modifier.height(32.dp))

        FolderOption(
            iconRes = R.drawable.ic_create_new_folder,
            text = stringResource(id = R.string.create_a_new_folder),
            onClick = onCreateFolder
        )

        Spacer(modifier = Modifier.height(8.dp))

        FolderOption(
            iconRes = R.drawable.ic_browse_existing_folders,
            text = stringResource(id = R.string.browse_existing_folders),
            onClick = onBrowseFolders
        )
    }
}


@Composable
fun FolderOption(iconRes: Int, text: String, onClick: () -> Unit) {

    Card(
        modifier = Modifier.padding(horizontal = 24.dp, vertical = 12.dp),
        onClick = onClick,
        colors = CardDefaults.cardColors(
            containerColor = MaterialTheme.colorScheme.background
        ),
        shape = RoundedCornerShape(8.dp),
        border = BorderStroke(width = 1.dp, color = MaterialTheme.colorScheme.surfaceVariant),
    ) {
        Row(
            modifier = Modifier
                .fillMaxWidth()
                .padding(horizontal = 24.dp, vertical = 24.dp),
            verticalAlignment = Alignment.CenterVertically
        ) {
            Icon(
                painter = painterResource(id = iconRes),
                contentDescription = null,
                modifier = Modifier.size(24.dp),
                tint = MaterialTheme.colorScheme.tertiary
            )

            Spacer(modifier = Modifier.width(12.dp))

            Text(
                text = text,
                fontSize = 18.sp,
                fontWeight = FontWeight.SemiBold,
                modifier = Modifier.weight(1f)
            )

            Icon(
                painter = painterResource(R.drawable.ic_arrow_forward_ios),
                contentDescription = null,
                modifier = Modifier.size(24.dp)
            )
        }
    }
}


@Preview
@Preview(uiMode = UI_MODE_NIGHT_YES)
@Composable
private fun AddFolderScreenPreview() {
    DefaultScaffoldPreview {
        AddFolderScreenContent(
            onCreateFolder = {},
            onBrowseFolders = {}
        )
    }
}