# Save by OpenArchive: Secure Mobile Media Preservation

Save is an open-source app created by OpenArchive to help eyewitnesses and human rights defenders preserve truth to power by securely sharing, archiving, verifying, and encrypting their mobile media.

<details open="open">
  <summary>Table of Contents</summary>
  <ul>
    <li><a href="#about-openarchive"> About OpenArchive</a></li>
    <li><a href="#about-save"> About Save</a></li>
    <li><a href="#contribute"> Contribute</a></li>
    <li><a href="#translate"> Translate</a></li>
    <li><a href="#donate"> Donate</a></li>
    <li><a href="#contact"> Contact</a></li>
    <li><a href="#faq"> FAQ</a></li>
    <li><a href="#license"> License</a></li>
  </ul>
</details>
 
## About OpenArchive💡
OpenArchive is dedicated to protecting media freedom: preserving, amplifying, and securely routing mobile media to community-maintained collections in accessible public and private archives, outside the corporate walled gardens currently dominating the online media ecosystem.
Created by and for citizen reporters and human rights defenders in 2015, our distributed media ecosystem promotes freedom of expression by protecting, authenticating, and offering access to and long-term preservation of at-risk community media.
Visit our website to learn more: [open-archive.org](https://open-archive.org)

## About Save📲 
Save (share, archive, verify, encrypt) is an easy-to-use app designed by OpenArchive to help you store, share, and amplify your mobile media while ensuring your identity remains protected. 
Through the app, you can add metadata and Creative Commons licensing to your audio or visual mobile media, then send it over TLS and the privacy-focused Tor network to the Internet Archive or other private archives to be saved.
Download the app for [iOS](https://apps.apple.com/us/app/save-by-openarchive/id1462212414) or [Android](https://play.google.com/store/apps/details?id=net.opendasharchive.openarchive.release&hl=en).


## Contribute🤗
If you would like to contribute code, please consider the following:
*Contributions will only be considered when sent via a Git pull request.
*Stick to the general formatting of the rest of the source code. If you find inconsistencies, your improvements are welcome via pull requests.
*Stick to the naming conventions of the rest of code. Think hard about naming.
*Refactor early, don’t repeat yourself.
*Spaghetti code, 1k+ line methods and similar abominations won’t be accepted.
*Don’t be too clever. Code which isn’t understandable by anyone but you while writing it, won’t be accepted. Document the non-obvious!
*If you find violations of these rules in the existing code, again: Happy to see your pull requests!
*Contributor License Agreement: If you send pull requests, please state that you grant OpenArchive the non-revocable right to use your code for this project in any way OpenArchive deems necessary. This includes, re-licensing under another license.

Before contributing, please familiarize yourself with the Contributor Covenant [Code of Conduct](https://github.com/OpenArchive/Code-of-Conduct).

## Translate🌐
We aim to make the Save app accessible for people from various countries and communities. If you want to contribute by translating our app, you can join Localization Lab here: [https://www.transifex.com/otf/SAVE/](https://www.transifex.com/otf/SAVE/)

## Donate🤝
OpenArchive is a veteran research and development organization that collaborates with human rights defenders and at-risk communities to create responsive, secure, and ethical archiving technologies for mobile media.
Our work is critical, ongoing and solely funded by grants and individuals like you.
If you would like to help fund our efforts, you can [make a tax-deductible donation](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=MA7ZZG3DJL97E&source=url) thanks to our fiscal sponsor, [Media Alliance](https://media-alliance.org/).
There are other ways you can help, too! If you’re interested in volunteering or providing in-kind expertise to advance human rights through secure digital media preservation, please send us an email: info[at]open-archive.org. We’d love to hear from you!

## Contact💬
Join the OpenArchive community:
Email us [info@open-archive.org](mailto:info@open-archive.org)
Follow us on Twitter: [twitter.com/open_archive](https://twitter.com/open_archive) 
Follow us on Instagram: [instagram.com/open__archive](https://www.instagram.com/open__archive)

## FAQ❓
Need more information about the Save app, OpenArchive, and the work it does? Please check our [FAQ page](https://open-archive.org/faq).

## License📄
[GNU General Public License v3.0](https://github.com/OpenArchive/Save-app-ios/blob/master/LICENSE)

