// Copyright 2025 - Nym Technologies SA <contact@nymtech.net>
// SPDX-License-Identifier: GPL-3.0-only

use crate::service::{
    ConfigSetupError,
    config::{
        VpnServiceConfigExt,
        entry_exit::v1::{EntryPoint, ExitPoint},
    },
};
use serde::{Deserialize, Serialize};

#[derive(Clone, Debug, Serialize, Deserialize)]
pub struct VpnServiceConfig {
    pub entry_point: EntryPoint,
    pub exit_point: ExitPoint,
}

impl From<VpnServiceConfig> for VpnServiceConfigExt {
    fn from(v1: VpnServiceConfig) -> Self {
        VpnServiceConfigExt::V1(v1)
    }
}

impl TryFrom<VpnServiceConfig> for nym_vpn_lib_types::VpnServiceConfig {
    type Error = ConfigSetupError;

    fn try_from(value: VpnServiceConfig) -> Result<Self, Self::Error> {
        let config = nym_vpn_lib_types::VpnServiceConfig {
            entry_point: nym_vpn_lib_types::EntryPoint::try_from(value.entry_point)?,
            exit_point: nym_vpn_lib_types::ExitPoint::try_from(value.exit_point)?,
            ..Default::default()
        };
        Ok(config)
    }
}
