package net.nymtech.vpn.util

import android.content.Intent
import android.net.VpnService
import android.os.IBinder
import androidx.annotation.CallSuper
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleOwner
import androidx.lifecycle.ServiceLifecycleDispatcher

/**
 * A VpnService that is also a [LifecycleOwner]. See source:
 * https://cs.android.com/androidx/platform/frameworks/support/+/androidx-main:lifecycle/lifecycle-service/src/main/java/androidx/lifecycle/LifecycleService.kt?q=file:androidx%2Flifecycle%2FLifecycleService.kt%20class:androidx.lifecycle.LifecycleService
 */
open class LifecycleVpnService : VpnService(), LifecycleOwner {

	private val dispatcher = ServiceLifecycleDispatcher(this)

	@CallSuper
	override fun onCreate() {
		dispatcher.onServicePreSuperOnCreate()
		super.onCreate()
	}

	@CallSuper
	override fun onBind(intent: Intent?): IBinder? {
		dispatcher.onServicePreSuperOnBind()
		return super.onBind(intent)
	}

	@Deprecated("Deprecated in Java")
	@Suppress("DEPRECATION")
	@CallSuper
	override fun onStart(intent: Intent?, startId: Int) {
		dispatcher.onServicePreSuperOnStart()
		super.onStart(intent, startId)
	}

	// this method is added only to annotate it with @CallSuper.
	// In usual Service, super.onStartCommand is no-op, but in LifecycleService
	// it results in dispatcher.onServicePreSuperOnStart() call, because
	// super.onStartCommand calls onStart().
	@CallSuper
	override fun onStartCommand(intent: Intent?, flags: Int, startId: Int): Int {
		return super.onStartCommand(intent, flags, startId)
	}

	@CallSuper
	override fun onDestroy() {
		dispatcher.onServicePreSuperOnDestroy()
		super.onDestroy()
	}

	override val lifecycle: Lifecycle
		get() = dispatcher.lifecycle
}
