// Copyright 2025 - Nym Technologies SA <contact@nymtech.net>
// SPDX-License-Identifier: GPL-3.0-only

#[tokio::main]
async fn main() {
    use sqlx::{Connection, SqliteConnection};
    use std::env;

    #[allow(clippy::unwrap_used)]
    let out_dir = env::var("OUT_DIR").unwrap();
    let database_path = format!("{out_dir}/nym-vpn-store-example.sqlite");

    #[allow(clippy::expect_used)]
    let mut conn = SqliteConnection::connect(&format!("sqlite://{database_path}?mode=rwc"))
        .await
        .expect("Failed to create SQLx database connection");

    #[allow(clippy::expect_used)]
    sqlx::migrate!("./migrations")
        .run(&mut conn)
        .await
        .expect("Failed to perform SQLx migrations");

    #[cfg(target_family = "unix")]
    println!("cargo:rustc-env=DATABASE_URL=sqlite://{}", &database_path);

    #[cfg(target_family = "windows")]
    // for some strange reason we need to add a leading `/` to the windows path even though it's
    // not a valid windows path... but hey, it works...
    println!("cargo:rustc-env=DATABASE_URL=sqlite:///{}", &database_path);
}
