// Copyright 2024 - Nym Technologies SA <contact@nymtech.net>
// SPDX-License-Identifier: GPL-3.0-only

// The account controller is responsible for
// 1. checking if the account exists
// 2. register the device
// 3. request ticketbooks and top up the local credential store

mod command_sender;
mod commands;
mod config;
mod controller;
mod error;
mod shared_state;
mod state_machine;
mod state_receiver;
mod storage;
mod ticketbooks;

pub(crate) use shared_state::SharedAccountState;

pub use command_sender::AccountCommandSender;
pub use config::AccountControllerConfig;
pub use controller::AccountController;
pub use error::Error;
pub use state_receiver::AccountStateReceiver;
pub use storage::remove_files_for_account;
pub use ticketbooks::AvailableTicketbooks;
