package net.mullvad.mullvadvpn.lib.theme.dimensions

import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp

data class Dimensions(
    val accountRowMinHeight: Dp = 48.dp,
    val accountRowSpacing: Dp = 24.dp,
    val addIconSize: Dp = 24.dp,
    val bigIconSize: Dp = 40.dp,
    val borderWidth: Dp = 2.dp,
    val bottomPadding: Dp = 4.dp,
    val buttonHeight: Dp = 44.dp,
    val buttonSpacing: Dp = 8.dp,
    val cellEndPadding: Dp = 16.dp,
    val cellFooterTopPadding: Dp = 4.dp,
    val cellHeight: Dp = 56.dp,
    val cellHeightTwoRows: Dp = 72.dp,
    val cellStartPadding: Dp = 16.dp,
    val cellVerticalSpacing: Dp = 24.dp,
    val chipSpace: Dp = 8.dp,
    val chipVerticalPadding: Dp = 4.dp,
    val circularProgressBarLargeSize: Dp = 40.dp,
    val circularProgressBarLargeStrokeWidth: Dp = 8.dp,
    val circularProgressBarMediumSize: Dp = 32.dp,
    val circularProgressBarMediumStrokeWidth: Dp = 4.dp,
    val circularProgressBarSmallSize: Dp = 24.dp,
    val circularProgressBarSmallStrokeWidth: Dp = 4.dp,
    val connectButtonExtraPadding: Dp = 4.dp,
    val connectionCardMaxWidth: Dp = 480.dp,
    val customPortBoxMinWidth: Dp = 56.dp,
    val deleteIconSize: Dp = 24.dp,
    val dialogIconHeight: Dp = 48.dp,
    val formTextFieldMinHeight: Dp = 72.dp,
    val indentedCellStartPadding: Dp = 48.dp,
    val indicatorPadding: Dp = 4.dp,
    val indicatorSize: Dp = 8.dp,
    val largePadding: Dp = 32.dp,
    val listIconSize: Dp = 24.dp,
    val listItemDivider: Dp = 1.dp,
    val mediumIconSize: Dp = 32.dp,
    val mediumPadding: Dp = 16.dp,
    val mediumSpacer: Dp = 16.dp,
    val miniPadding: Dp = 4.dp,
    val notificationBannerEndPadding: Dp = 8.dp,
    val notificationBannerStartPadding: Dp = 16.dp,
    val notificationEndIconPadding: Dp = 4.dp,
    // This is according to the design, should be updated in the design to standard size
    val notificationStatusIconSize: Dp = 10.dp,
    val obfuscationNavigationBoxWidth: Dp = 56.dp,
    val outLineButtonBorderWidth: Dp = 1.dp,
    val privacyPolicyIconSize: Dp = 16.dp,
    val problemReportTextFieldMinHeight: Dp = 220.dp,
    val reconnectButtonMinInteractiveComponentSize: Dp = 40.dp,
    val relayCircleSize: Dp = 16.dp,
    val relayCirclePadding: Dp = 8.dp,
    val relayItemCornerRadius: Dp = 16.dp,
    val screenBottomMargin: Dp = 16.dp,
    val screenTopMargin: Dp = 24.dp,
    val searchFieldHeight: Dp = 42.dp,
    val searchFieldHeightExpanded: Dp = 72.dp,
    val searchFieldHorizontalPadding: Dp = 20.dp,
    val searchIconSize: Dp = 24.dp,
    val selectableCellTextMargin: Dp = 8.dp,
    val settingsDetailsImageMaxWidth: Dp = 480.dp,
    val sideMargin: Dp = 24.dp,
    val smallIconSize: Dp = 16.dp,
    val smallPadding: Dp = 8.dp,
    val smallSpacer: Dp = 8.dp,
    val splashLogoSize: Dp = 120.dp,
    // Required to get the logo to look visually correct
    val splashLogoTextHeight: Dp = 18.dp,
    val switchIconSize: Dp = 24.dp,
    val switchLocationRetryMinWidth: Dp = 48.dp,
    val thinBorderWidth: Dp = 1.dp,
    val tinyPadding: Dp = 4.dp,
    val titleIconSize: Dp = 48.dp,
    val tvDrawerHeaderStartPadding: Dp = 12.dp,
    val tvDrawerHeaderWithFocusStartPadding: Dp = 16.dp,
    val tvDrawerHorizontalPadding: Dp = 12.dp,
    // Required to get the logo to look visually correct on TV
    val tvMullvadLogoTextHeight: Dp = 13.dp,
    // Required to get the logo to look visually correct on TV
    val tvMullvadLogoTextStartPadding: Dp = 6.dp,
    val verticalDividerPadding: Dp = 16.dp,
    val verticalSpace: Dp = 16.dp,
    val verticalSpacer: Dp = 1.dp,
)

val defaultDimensions = Dimensions()
// Add more configurations here if needed
