# Changelog
All notable changes are recorded here.

### Format

The format is based on [Keep a Changelog](http://keepachangelog.com/en/1.0.0/).

Entries should have the imperative form, just like commit messages. Start each entry with words like
add, fix, increase, force etc.. Not added, fixed, increased, forced etc.

Line wrap the file at 100 chars.                                              That is over here -> |

### Categories each change fall into

* **Added**: for new features.
* **Changed**: for changes in existing functionality.
* **Deprecated**: for soon-to-be removed features.
* **Removed**: for now removed features.
* **Fixed**: for any bug fixes.
* **Security**: in case of vulnerabilities.

## [Unreleased]
### Changed
- Change how maybenot-ffi is included and built as a dependency to wireguard-go with DAITA support.


## [0.1.5] - 2024-12-12
### Changed
- Update `golang.org/x/crypto` to 0.31.

### Removed
- Remove unused pubkey field for DAITA events.

### Fixed
- Drop packets that cannot be received in netstack.


## [0.1.4] - 2024-11-11
### Added
- Add support for DAITA machine timers, and tunnel recv and send events.

### Changed
- Optimize handling of DAITA events by sending all available events in the channel to the Maybenot
  framework.

### Fixed
- Handle replace flag for padding packets.
- Fix keepalive flag not being reset for pooled packets. This could result in fewer client
  handshakes over time.


## [0.1.3] - 2024-10-29
### Changed
- Bump maybenot to 2.0.1.


## [0.1.2] - 2024-09-09
### Changed
- Bump golang to 1.21.
- Bump maybenot to 1.1.3.


## [0.1.1] - 2024-08-21
### Fixed
- Fix netstack tunnel leaking when closed.
- Fix race when closing the DAITA event channel, which could result in events being sent on the
  closed channel.


## [0.1.0] - 2024-07-25
### Added
- Initial DAITA release.
