/*
 * Copyright (c) 2025 Mullvad VPN AB. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 *
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
/* automatically generated by rust-bindgen 0.70.1 */

pub const PROX_FDTYPE_VNODE: u32 = 1;
pub const PROC_PIDFDVNODEPATHINFO: u32 = 2;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_longlong;
pub type __darwin_gid_t = __uint32_t;
pub type __darwin_off_t = __int64_t;
pub type __darwin_uid_t = __uint32_t;
pub type gid_t = __darwin_gid_t;
pub type off_t = __darwin_off_t;
pub type uid_t = __darwin_uid_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fsid {
    pub val: [i32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of fsid"][::std::mem::size_of::<fsid>() - 8usize];
    ["Alignment of fsid"][::std::mem::align_of::<fsid>() - 4usize];
    ["Offset of field: fsid::val"][::std::mem::offset_of!(fsid, val) - 0usize];
};
pub type fsid_t = fsid;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc_fileinfo {
    pub fi_openflags: u32,
    pub fi_status: u32,
    pub fi_offset: off_t,
    pub fi_type: i32,
    pub fi_guardflags: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of proc_fileinfo"][::std::mem::size_of::<proc_fileinfo>() - 24usize];
    ["Alignment of proc_fileinfo"][::std::mem::align_of::<proc_fileinfo>() - 8usize];
    ["Offset of field: proc_fileinfo::fi_openflags"]
        [::std::mem::offset_of!(proc_fileinfo, fi_openflags) - 0usize];
    ["Offset of field: proc_fileinfo::fi_status"]
        [::std::mem::offset_of!(proc_fileinfo, fi_status) - 4usize];
    ["Offset of field: proc_fileinfo::fi_offset"]
        [::std::mem::offset_of!(proc_fileinfo, fi_offset) - 8usize];
    ["Offset of field: proc_fileinfo::fi_type"]
        [::std::mem::offset_of!(proc_fileinfo, fi_type) - 16usize];
    ["Offset of field: proc_fileinfo::fi_guardflags"]
        [::std::mem::offset_of!(proc_fileinfo, fi_guardflags) - 20usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vinfo_stat {
    pub vst_dev: u32,
    pub vst_mode: u16,
    pub vst_nlink: u16,
    pub vst_ino: u64,
    pub vst_uid: uid_t,
    pub vst_gid: gid_t,
    pub vst_atime: i64,
    pub vst_atimensec: i64,
    pub vst_mtime: i64,
    pub vst_mtimensec: i64,
    pub vst_ctime: i64,
    pub vst_ctimensec: i64,
    pub vst_birthtime: i64,
    pub vst_birthtimensec: i64,
    pub vst_size: off_t,
    pub vst_blocks: i64,
    pub vst_blksize: i32,
    pub vst_flags: u32,
    pub vst_gen: u32,
    pub vst_rdev: u32,
    pub vst_qspare: [i64; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of vinfo_stat"][::std::mem::size_of::<vinfo_stat>() - 136usize];
    ["Alignment of vinfo_stat"][::std::mem::align_of::<vinfo_stat>() - 8usize];
    ["Offset of field: vinfo_stat::vst_dev"][::std::mem::offset_of!(vinfo_stat, vst_dev) - 0usize];
    ["Offset of field: vinfo_stat::vst_mode"]
        [::std::mem::offset_of!(vinfo_stat, vst_mode) - 4usize];
    ["Offset of field: vinfo_stat::vst_nlink"]
        [::std::mem::offset_of!(vinfo_stat, vst_nlink) - 6usize];
    ["Offset of field: vinfo_stat::vst_ino"][::std::mem::offset_of!(vinfo_stat, vst_ino) - 8usize];
    ["Offset of field: vinfo_stat::vst_uid"][::std::mem::offset_of!(vinfo_stat, vst_uid) - 16usize];
    ["Offset of field: vinfo_stat::vst_gid"][::std::mem::offset_of!(vinfo_stat, vst_gid) - 20usize];
    ["Offset of field: vinfo_stat::vst_atime"]
        [::std::mem::offset_of!(vinfo_stat, vst_atime) - 24usize];
    ["Offset of field: vinfo_stat::vst_atimensec"]
        [::std::mem::offset_of!(vinfo_stat, vst_atimensec) - 32usize];
    ["Offset of field: vinfo_stat::vst_mtime"]
        [::std::mem::offset_of!(vinfo_stat, vst_mtime) - 40usize];
    ["Offset of field: vinfo_stat::vst_mtimensec"]
        [::std::mem::offset_of!(vinfo_stat, vst_mtimensec) - 48usize];
    ["Offset of field: vinfo_stat::vst_ctime"]
        [::std::mem::offset_of!(vinfo_stat, vst_ctime) - 56usize];
    ["Offset of field: vinfo_stat::vst_ctimensec"]
        [::std::mem::offset_of!(vinfo_stat, vst_ctimensec) - 64usize];
    ["Offset of field: vinfo_stat::vst_birthtime"]
        [::std::mem::offset_of!(vinfo_stat, vst_birthtime) - 72usize];
    ["Offset of field: vinfo_stat::vst_birthtimensec"]
        [::std::mem::offset_of!(vinfo_stat, vst_birthtimensec) - 80usize];
    ["Offset of field: vinfo_stat::vst_size"]
        [::std::mem::offset_of!(vinfo_stat, vst_size) - 88usize];
    ["Offset of field: vinfo_stat::vst_blocks"]
        [::std::mem::offset_of!(vinfo_stat, vst_blocks) - 96usize];
    ["Offset of field: vinfo_stat::vst_blksize"]
        [::std::mem::offset_of!(vinfo_stat, vst_blksize) - 104usize];
    ["Offset of field: vinfo_stat::vst_flags"]
        [::std::mem::offset_of!(vinfo_stat, vst_flags) - 108usize];
    ["Offset of field: vinfo_stat::vst_gen"]
        [::std::mem::offset_of!(vinfo_stat, vst_gen) - 112usize];
    ["Offset of field: vinfo_stat::vst_rdev"]
        [::std::mem::offset_of!(vinfo_stat, vst_rdev) - 116usize];
    ["Offset of field: vinfo_stat::vst_qspare"]
        [::std::mem::offset_of!(vinfo_stat, vst_qspare) - 120usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vnode_info {
    pub vi_stat: vinfo_stat,
    pub vi_type: ::std::os::raw::c_int,
    pub vi_pad: ::std::os::raw::c_int,
    pub vi_fsid: fsid_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of vnode_info"][::std::mem::size_of::<vnode_info>() - 152usize];
    ["Alignment of vnode_info"][::std::mem::align_of::<vnode_info>() - 8usize];
    ["Offset of field: vnode_info::vi_stat"][::std::mem::offset_of!(vnode_info, vi_stat) - 0usize];
    ["Offset of field: vnode_info::vi_type"]
        [::std::mem::offset_of!(vnode_info, vi_type) - 136usize];
    ["Offset of field: vnode_info::vi_pad"][::std::mem::offset_of!(vnode_info, vi_pad) - 140usize];
    ["Offset of field: vnode_info::vi_fsid"]
        [::std::mem::offset_of!(vnode_info, vi_fsid) - 144usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vnode_info_path {
    pub vip_vi: vnode_info,
    pub vip_path: [::std::os::raw::c_char; 1024usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of vnode_info_path"][::std::mem::size_of::<vnode_info_path>() - 1176usize];
    ["Alignment of vnode_info_path"][::std::mem::align_of::<vnode_info_path>() - 8usize];
    ["Offset of field: vnode_info_path::vip_vi"]
        [::std::mem::offset_of!(vnode_info_path, vip_vi) - 0usize];
    ["Offset of field: vnode_info_path::vip_path"]
        [::std::mem::offset_of!(vnode_info_path, vip_path) - 152usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vnode_fdinfowithpath {
    pub pfi: proc_fileinfo,
    pub pvip: vnode_info_path,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of vnode_fdinfowithpath"][::std::mem::size_of::<vnode_fdinfowithpath>() - 1200usize];
    ["Alignment of vnode_fdinfowithpath"][::std::mem::align_of::<vnode_fdinfowithpath>() - 8usize];
    ["Offset of field: vnode_fdinfowithpath::pfi"]
        [::std::mem::offset_of!(vnode_fdinfowithpath, pfi) - 0usize];
    ["Offset of field: vnode_fdinfowithpath::pvip"]
        [::std::mem::offset_of!(vnode_fdinfowithpath, pvip) - 24usize];
};
