# 2022-10-14 - Atredis Partners security assessment of the Mullvad VPN app

Two people from [Atredis Partners](https://www.atredis.com/) performed a penetration test and
source code audit of the Mullvad VPN app over a four week period between 2022-09-06
and 2022-10-06, and the final audit report was handed over to Mullvad on 2022-10-14.
The security assessment included all five supported platforms:
Windows, Linux, macOS, Android and iOS.

For the desktop app, version [2022.4] was audited. On Android, version [2022.2-beta1]
was audited and on iOS the Test Flight version [2022.3 (build 1)] was audited.

[2022.4]: ../CHANGELOG.md#20224---2022-08-19
[2022.2-beta1]: ../android/CHANGELOG.md#android20222-beta1---2022-08-11
[2022.3 (build 1)]: https://github.com/mullvad/mullvadvpn-app/commit/b05f9c588f5c88e98a9d36af84765bbd1254be43

Quoting the key conclusions of the report:

> Overall, Atredis Partners found the Mullvad VPN clients to be well-architected from a security
perspective, with limited attack surface that could be reached by an external malicious party,
and important protection mechanisms were in place to prevent most unintended traffic leaks.
Atredis Partners detected a few edge cases where traffic could be accidentally leaked outside
the VPN tunnel. These leaks were either patched quickly by the Mullvad team or were due to
the operating system itself, in which case the Mullvad team updated documentation and
submitted issues to the operating system vendor where appropriate.
>
> As in any security assessment, some areas for improvement were noted, but overall Atredis
Partners would rate the Mullvad VPN clients as sound from a security perspective.

## High-Level Engagement Objectives

Atredis Partners were tasked with the following high-level engagement objectives for the audit:

* Enumerate and define key attack chains against the Mullvad platform
* Attempt to identify attack scenarios resulting in de-anonymization
* Valid potential for “fail open” scenarios such as split tunnels / kill switch / etc
* Attempt to identify scenarios impacting tunnel integrity or confidentiality
* Ensure Mullvad information assets and customer data are well protected
* Confirm applications and services are secured with typical industry best practices

## Read the report

The final report is available [on Atredis' website](https://www.atredis.com/s/Atredis-Partners-Mullvad-VPN-Platform-Security-Assessment-Report-v10.pdf)
as well as in this repository: [2022-10-atredis_partners_security_assessment.pdf](./2022-10-atredis_partners_security_assessment.pdf)

## Overview of findings

This chapter will present Mullvad's response to all the security findings from the report.
To read what the findings are about, see the report.

Out of the five findings, two are *medium* level, two are *low* level and one is *info* level.
This means that the auditors did not find anything of high or critical severity. Nothing
found could easily or substantially compromise the security or privacy of the app users.

Mullvad implemented fixes for two of the findings. Two findings resulted in updated security
documentation around limitations in Android. The last finding was classified
as not in scope for us to fix.

All fixes were merged and released before the final report was done and sent over to Mullvad.
Version `2022.5-beta1` (and newer) of the desktop app includes the fixes.

### __MUL22-01__ (Low): Out-of-Bounds Read in win-split-tunnel (Windows)

The access permissions on the device exposed by the `mullvad-split-tunnel` kernel driver
requires the connecting process to have administrator privileges. It also only allows a single
user space process to be connected to it at any point in time. So an attacker would need
to both have administrator privileges and stop the `mullvad-daemon` service before they
could connect to the driver and trigger the bug. Mullvad deems this both unlikely to
happen and not in scope of what the app should try to protect against. If an attacker
has administrator privileges already, they can do worse stuff than
exploiting this bug.

This bug will likely not enable privilege escalation. The attacker already needs to
be administrator, and we have no indication that an administrator could use this to gain
further privileges.

Regardless of the low severity, the bug has been fixed in the kernel driver.
[This PR](https://github.com/mullvad/win-split-tunnel/pull/34),
fixes the bug, and the patched driver was included in app version `2022.5-beta1`.

### __MUL22-02__ (Medium): Leak of Traffic During System Shutdown

A while before the audit started, Mullvad engineers discovered that there was a time window
during boot on both Linux and macOS where traffic could leak, even if "Launch app on start-up"
and "Auto-connect" was enabled. This was due to the fact that our system service (`mullvad-daemon`)
was not set up so it must be started before the OS initializes the network. If the OS decided
to start `mullvad-daemon` late in the boot process, other programs could communicate with the
network without a VPN for a few seconds. This was reported as known issues to Atredis just
before the start of the audit, and a fix was developed simultaneously.
The bootup leak was [fixed on Linux](https://github.com/mullvad/mullvadvpn-app/pull/3904)
at the same time as the audit started.

Just a week after the bootup leak was fixed, Atredis reported `MUL22-02`, where they found a
similar potential leak window during shutdown on Unix based platforms. Upon investigation,
Mullvad concluded that the issue was present on Windows as well.
The bug was mitigated on all three desktop operating systems in two different PRs.
[#3940 for Linux and macOS] and [#3942 for Windows]. All fixes were included in
app version `2022.5-beta1`, including the one for bootup leaks on Linux.

The only issue in this area that we have not been able to fully mitigate is the potential leak
during bootup on macOS. That is because macOS does not allow a system service to specify
dependencies or in which order they need to start. So there is no way known to us to force
macOS to start `mullvad-daemon` before the network is configured. We have [updated our
security documentation] to reflect this known issue, and we will work towards making it
more transparent towards our users.

[#3940 for Linux and macOS]: https://github.com/mullvad/mullvadvpn-app/pull/3940
[#3942 for Windows]: https://github.com/mullvad/mullvadvpn-app/pull/3942
[updated our security documentation]: https://github.com/mullvad/mullvadvpn-app/pull/4061

### __MUL22-03__ (Medium): Connectivity Checks Bypass VPN (Android)

In general there is not much Mullvad can do to prevent this traffic leak from happening.
We can only raise awareness of it and try to put pressure on Google to allow the user to disable
the connectivity check. We have done the following in response to this finding:

* [Blog about the leak more in depth](https://mullvad.net/blog/2022/10/10/android-leaks-connectivity-check-traffic)
* [Created a guide allowing more technical users to disable the connectivity check](https://mullvad.net/help/configure-connectivity-checks-on-android)
* [Reported that the Android documentation around *Block connections without VPN* is misleading](https://issuetracker.google.com/issues/249990229)
* [Requested a user facing setting for disabling the connectivity check](https://issuetracker.google.com/issues/250529027)
* [Updated our security documentation to mention this limitation](https://github.com/mullvad/mullvadvpn-app/pull/3996)

### __MUL22-04__ (Low): Permissive Inbound Network Filtering (Android)

As far as we can tell, there is nothing Mullvad or any other VPN app can do about this.
Android will not block incoming connections. However, this is still regarded as a low
severity issue. The device must actively expose some service to the network for
there to be anything to connect to.

We have [updated our security documentation](https://github.com/mullvad/mullvadvpn-app/pull/3966)
to mention this limitation.

### __MUL22-05__ (Info): Siri Shortcuts Susceptible to Manipulation (iOS)

The Siri shortcut integration is opt-in and not enabled by default. On top of that, Mullvad
thinks that the attack is more of an attack on Siri's authentication than on our app.
Siri is supposed to only listen to the owner's voice.

If this finding is a concern for any user, we recommend that user to disable the Siri integration
in the Mullvad app.


## Last words

We wish to thank Atredis Partners for the smooth collaboration, good communication and great
security assessment work!
