# 2020-06-12 - Cure53

Six people from [Cure53](https://cure53.de/) performed a penetration test and source code audit
of the Mullvad VPN app with a budget of twenty days. The audit included all five supported
platforms: Windows, Linux, macOS, Android and iOS. The audit work was carried out over a two
week period in late May and early June of 2020, and the final audit report was handed
over to Mullvad on 2020-06-12.

For the desktop app, version [2020.4] was audited. On Android version [2020.5-beta1]
was audited. And on iOS the test flight version that later became [ios/2020.3]
was audited.

A quote from the conclusions chapter of the report:

> The results of this May-June 2020 project targeting the Mullvad complex are quite
positive. After spending twenty days on the scope, six members of the Cure53 team
could only spot seven security-relevant items. Moreover, penetration tests and audits
against application branches of Mullvad exclusively pointed to issues with limited
severities, as demonstrated by the most impactful flaw scoring as Medium only.

> Bringing together evidence from different components clearly suggests that the Mullvad
complex came out victorious from this Cure53 external assessment. Despite thorough
penetration tests and dedicated audits against various Mullvad apps, clients and APIs,
Cure53 was unable to compromise the complex. Mullvad clearly represents a mature
design as a function of a sound development process. All findings found during this
engagement were patched before the final stages of the project, which is also a very
good indicator. The Mullvad complex is definitely on the right track from a security
standpoint.

## Read the report

The final report is available [on Cure53's website](https://cure53.de/pentest-report_mullvad_2020_v2.pdf).

Also public is the [initial report](https://cure53.de/pentest-report_mullvad_2020_v1.pdf) which is the
version that was initially presented to us. After a discussion with the auditors about the use of
certain terminology and being more specific about what app versions had been audited,
they adjusted the report to provide better clarity and produced the final version.
For full transparency we insist to publish both versions.

The reports are also available directly in this repository:
* Final version: [pentest-report_mullvad_2020_v2.pdf](./pentest-report_mullvad_2020_v2.pdf)
* Initial version: [pentest-report_mullvad_2020_v1.pdf](./pentest-report_mullvad_2020_v1.pdf)

## Overview of findings

This chapter will present a short summary of all security findings from the report and
Mullvad's response to them.

Out of the seven issues found, two were on *medium* level. Two issues had level *low*
and the remaining three had level *info*. This means that the auditors did not find anything
that they classified as very dangerous or could seriously or easily compromise
the security and anonymity of the app users.

Fixes were implemented for five of the seven issues. The remaining two
identified items are things Mullvad do not deem serious problems nor are they a threat
to us or our users. Furthermore, there was no way of patching those two as they
were outside of our control.

All issues that we implemented fixes for had their fixes merged before the final report
was done and sent over to Mullvad. Version [2020.5-beta2] of the app has all found
vulnerabilies fixed ([ios/2020.3] for iOS).

### Identified vulnerabilities

* __MUL-02-002 WP2__: Firewall allows deanonymization by eavesdropper (Medium)

  _Our comment_: This is a legitimate and fully possible deanonymization attack. However, as it is
  not trivial to execute, Cure53 classifies it as *Medium* only. This vulnerability is not
  an issue for any normal user. But as outlined in the report's conclusion, a
  "state-funded and persistent threat" could very well use it to identify users. Since
  anonymity for our users, including those with high threat models, is paramount to us, we regard
  this finding as a rather serious one. But not critical enough to justify rushing out a stable
  release.

  This issue is fixed in all desktop apps in the following PRs:
  * [Windows PR #1827](https://github.com/mullvad/mullvadvpn-app/pull/1827)
  * [Linux PR #1819](https://github.com/mullvad/mullvadvpn-app/pull/1819)
  * [macOS PR #1829](https://github.com/mullvad/mullvadvpn-app/pull/1829).

* __MUL-02-006 WP1__: Blind HTML Injection via Problem Report (Low)

  _Our comment_: This finding does not put any user or the service itself at risk.
  The problem reports are handled as plaintext and not HTML, all the way from the app to the
  support team. The pingback observed in the report comes from Google's Gmail servers
  which simply seem to query any URL they can parse in email bodies passing through their servers.
  As such, we do not agree with the classification as an HTML injection issue.
  There is likely no way for us to disable this, and even if it was exploitable, it would be
  Google that would be compromised and not Mullvad.

* __MUL-02-007 WP2__: Named Pipe exposed via SMB accessible to everyone (Medium)

  _Our comment_: This vulnerability allows for controlling Mullvad VPN on a Windows machine
  from the network. However, it requires the user to both enable "Local network sharing" in
  the app and disable Windows' "password protected sharing", neither of which is done by default.
  Mullvad would not recommend anyone who care about their security or privacy to ever disable
  "password protected sharing" at all.

  We do not see this as a large security flaw since the user
  must explicitly turn off important security settings for this to be exploitable to begin with.
  However, since the VPN is only supposed to be possible to control from the local computer
  and since the report presents an easy fix for the issue, we have addressed this in
  [PR #1830](https://github.com/mullvad/mullvadvpn-app/pull/1830).

### Miscellaneous issues

* __MUL-02-001 iOS__: Lack of filesystem protections (Info)

  _Our comment_: The app does not in any way need the cache file that was found. So we directly
  implemented the suggested fix to get rid of it in
  [PR #1808](https://github.com/mullvad/mullvadvpn-app/pull/1808).
  Since the exposed data is not very sensitive and getting the data out of the device is far
  from trivial, we agree with the auditors that this is not a serious leak.

* __MUL-02-003 WP1__: General hardening recommendations for Android app (Info)

  _Our comment_: These are good recommendations from Cure53 and we have implemented them
  in order to better practice defense-in-depth in
  [PR #1823](https://github.com/mullvad/mullvadvpn-app/pull/1823) and
  [PR #1822](https://github.com/mullvad/mullvadvpn-app/pull/1822).

* __MUL-02-004 WP2__: Firewall allows TCP connections to WireGuard gateway (Low)

  _Our comment_: This vulnerability is very similar to __MUL-02-002__ but is less dangerous
  since no custom token can be sent out, making it harder to identify a specific
  user. This issue was fixed for Windows in the same PR where __MUL-02-002__ was fixed.

* __MUL-02-005 WP1__: VpnService logs static internal IPs to Android’s syslog (Info)

  _Our comment_: Leaking the private tunnel IP in use is considered bad but not critical.
  We agree with the classification level of *Info* on this security finding since the attacker
  needs either `adb` access or the phone to be rooted. There is no way Mullvad can fix
  this potential information leak. The logging of the IP is done by the Android operating
  system as soon as any VPN app uses the system's VPN API. and as far as we can tell,
  there is no way to disable this nor for us to fix this potential information leak.
  All, and all Android VPN apps are subject to the same type of leak.

## Last words

We wish to thank Cure53 not only for their work but also for a smooth collaboration through
the entire process!

[2020.4]: ../CHANGELOG.md#20204---2020-05-12
[2020.5-beta1]: ../CHANGELOG.md#20205-beta1---2020-05-18
[ios/2020.3]: ../ios/CHANGELOG.md#20203---2020-06-12
[2020.5-beta2]: ../CHANGELOG.md#20205-beta2---2020-06-16
