# How to contribute to the Mullvad VPN app

The Mullvad VPN app is open sourced for many reasons, but primarily we want to
* allow users to verify that our app functions as we claim it does, giving them the option to build
  it from source without having to trust our released binaries
* receive contributions from third parties.


## Filing issues

If you find a bug in the app's code, please report it on GitHub in the issue tracker. Please send
all other problems or questions (those not directly related to the app's development) to
[support@mullvadvpn.net](mailto:support@mullvadvpn.net). This includes connection issues, questions
regarding your account, and problems with the Mullvad VPN infrastructure or servers.


## Submitting changes

If you would like to contribute to the development of the Mullvad VPN app, please carefully read the
following sections first and then feel free to submit a pull request on GitHub.

While we appreciate your interest in helping us to improve Mullvad VPN, please understand that
choosing which submitted changes to merge is fully at our discretion, based upon our development
plans for the app.

### Localization / translations

The app is translated and proofread via a third party company. We can't take in user improvements
to the translations directly, since we can't verify their correctness. All translations have to
go via the translation company. As a result, if you want to improve an existing
translation, please don't edit the PO files and submit to us. Instead fill in your suggested
improvement in [this form], and the translation company will pick it up and process the
suggestion after a while.

[this form]: https://docs.google.com/forms/d/e/1FAIpQLSeEFRe0ojdl6QdHPp7Z9qIvdGTc1uSgbswQT6d-VRQ98GBO2w/viewform

### Copyright and ownership of contributed code and changes

Any code, binaries, tools, documentation, graphics, or any other material that you submit to this
project will be licensed under GPL 3.0. Submitting to this project means that you are the original
author of the entire contribution and grant us the full right to use, publish, change or remove
the entire, or part of, your contribution under the terms defined by the GPL 3.0 license at any
point in time.

### Code style and design

Please follow the [coding guidelines](https://github.com/mullvad/coding-guidelines).
