package net.ivpn.core.rest.data.model;

/*
 IVPN Android app
 https://github.com/ivpn/android-app

 Created by Tamim Hossain.
 Copyright (c) 2025 IVPN Limited.

 This file is part of the IVPN Android app.

 The IVPN Android app is free software: you can redistribute it and/or
 modify it under the terms of the GNU General Public License as published by the Free
 Software Foundation, either version 3 of the License, or (at your option) any later version.

 The IVPN Android app is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License
 along with the IVPN Android app. If not, see <https://www.gnu.org/licenses/>.
*/

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class AntiTrackerConfig {

    @SerializedName("default")
    @Expose
    private AntiTrackerDefault defaultConfig;
    
    @SerializedName("hardcore")
    @Expose
    private AntiTrackerHardcore hardcoreConfig;

    public AntiTrackerDefault getDefaultConfig() {
        return defaultConfig;
    }

    public void setDefaultConfig(AntiTrackerDefault defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    public AntiTrackerHardcore getHardcoreConfig() {
        return hardcoreConfig;
    }

    public void setHardcoreConfig(AntiTrackerHardcore hardcoreConfig) {
        this.hardcoreConfig = hardcoreConfig;
    }

    @Override
    public String toString() {
        return "AntiTrackerConfig{" +
                "defaultConfig=" + defaultConfig +
                ", hardcoreConfig=" + hardcoreConfig +
                '}';
    }
} 