/*
 * Copyright (C) 2022 askmeaboutloom
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * --------------------------------------------------------------------
 *
 * This code is auto-generated by generators/protogen/protogen_drawdance.py
 * from generators/protogen/messages.c.jinja. Don't edit it directly.
 */
#include "messages.h"
#include "blend_mode.h"
#include "ids.h"
#include "message.h"
#include "text_reader.h"
#include "text_writer.h"
#include <dpcommon/binary.h>
#include <dpcommon/common.h>
#include <dpcommon/conversions.h>
#include <dpcommon/endianness.h>


bool DP_message_type_control(DP_MessageType type)
{
    switch (type) {
    case DP_MSG_SERVER_COMMAND:
    case DP_MSG_DISCONNECT:
    case DP_MSG_PING:
    case DP_MSG_KEEP_ALIVE:
    case DP_MSG_THUMBNAIL:
    case DP_MSG_INTERNAL:
        return true;
    default:
        return false;
    }
}

bool DP_message_type_server_meta(DP_MessageType type)
{
    switch (type) {
    case DP_MSG_JOIN:
    case DP_MSG_LEAVE:
    case DP_MSG_SESSION_OWNER:
    case DP_MSG_CHAT:
    case DP_MSG_TRUSTED_USERS:
    case DP_MSG_SOFT_RESET:
    case DP_MSG_PRIVATE_CHAT:
    case DP_MSG_RESET_STREAM:
        return true;
    default:
        return false;
    }
}

bool DP_message_type_client_meta(DP_MessageType type)
{
    switch (type) {
    case DP_MSG_INTERVAL:
    case DP_MSG_LASER_TRAIL:
    case DP_MSG_MOVE_POINTER:
    case DP_MSG_REMOVED_MARKER:
    case DP_MSG_USER_ACL:
    case DP_MSG_LAYER_ACL:
    case DP_MSG_FEATURE_ACCESS_LEVELS:
    case DP_MSG_DEFAULT_LAYER:
    case DP_MSG_REMOVED_FILTERED:
    case DP_MSG_EXTENSION:
    case DP_MSG_UNDO_DEPTH:
    case DP_MSG_DATA:
    case DP_MSG_LOCAL_CHANGE:
    case DP_MSG_FEATURE_LIMITS:
        return true;
    default:
        return false;
    }
}

bool DP_message_type_command(DP_MessageType type)
{
    switch (type) {
    case DP_MSG_UNDO_POINT:
    case DP_MSG_CANVAS_RESIZE:
    case DP_MSG_REMOVED_LAYER_CREATE:
    case DP_MSG_LAYER_ATTRIBUTES:
    case DP_MSG_LAYER_RETITLE:
    case DP_MSG_REMOVED_LAYER_ORDER:
    case DP_MSG_REMOVED_LAYER_DELETE:
    case DP_MSG_REMOVED_LAYER_VISIBILITY:
    case DP_MSG_PUT_IMAGE:
    case DP_MSG_FILL_RECT:
    case DP_MSG_REMOVED_TOOL_CHANGE:
    case DP_MSG_REMOVED_PEN_MOVE:
    case DP_MSG_PEN_UP:
    case DP_MSG_ANNOTATION_CREATE:
    case DP_MSG_ANNOTATION_RESHAPE:
    case DP_MSG_ANNOTATION_EDIT:
    case DP_MSG_ANNOTATION_DELETE:
    case DP_MSG_REMOVED_MOVE_REGION:
    case DP_MSG_PUT_TILE:
    case DP_MSG_CANVAS_BACKGROUND:
    case DP_MSG_DRAW_DABS_CLASSIC:
    case DP_MSG_DRAW_DABS_PIXEL:
    case DP_MSG_DRAW_DABS_PIXEL_SQUARE:
    case DP_MSG_DRAW_DABS_MYPAINT:
    case DP_MSG_DRAW_DABS_MYPAINT_BLEND:
    case DP_MSG_MOVE_RECT:
    case DP_MSG_SET_METADATA_INT:
    case DP_MSG_LAYER_TREE_CREATE:
    case DP_MSG_LAYER_TREE_MOVE:
    case DP_MSG_LAYER_TREE_DELETE:
    case DP_MSG_TRANSFORM_REGION:
    case DP_MSG_TRACK_CREATE:
    case DP_MSG_TRACK_RETITLE:
    case DP_MSG_TRACK_DELETE:
    case DP_MSG_TRACK_ORDER:
    case DP_MSG_KEY_FRAME_SET:
    case DP_MSG_KEY_FRAME_RETITLE:
    case DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES:
    case DP_MSG_KEY_FRAME_DELETE:
    case DP_MSG_SELECTION_PUT:
    case DP_MSG_SELECTION_CLEAR:
    case DP_MSG_LOCAL_MATCH:
    case DP_MSG_SYNC_SELECTION_TILE:
    case DP_MSG_PUT_IMAGE_ZSTD:
    case DP_MSG_PUT_TILE_ZSTD:
    case DP_MSG_CANVAS_BACKGROUND_ZSTD:
    case DP_MSG_MOVE_RECT_ZSTD:
    case DP_MSG_TRANSFORM_REGION_ZSTD:
    case DP_MSG_UNDO:
        return true;
    default:
        return false;
    }
}

bool DP_message_type_compatible(DP_MessageType type)
{
    switch (type) {
    case DP_MSG_SERVER_COMMAND:
    case DP_MSG_DISCONNECT:
    case DP_MSG_PING:
    case DP_MSG_KEEP_ALIVE:
    case DP_MSG_THUMBNAIL:
    case DP_MSG_INTERNAL:
    case DP_MSG_JOIN:
    case DP_MSG_LEAVE:
    case DP_MSG_SESSION_OWNER:
    case DP_MSG_CHAT:
    case DP_MSG_TRUSTED_USERS:
    case DP_MSG_SOFT_RESET:
    case DP_MSG_PRIVATE_CHAT:
    case DP_MSG_RESET_STREAM:
    case DP_MSG_INTERVAL:
    case DP_MSG_LASER_TRAIL:
    case DP_MSG_MOVE_POINTER:
    case DP_MSG_REMOVED_MARKER:
    case DP_MSG_USER_ACL:
    case DP_MSG_LAYER_ACL:
    case DP_MSG_FEATURE_ACCESS_LEVELS:
    case DP_MSG_DEFAULT_LAYER:
    case DP_MSG_REMOVED_FILTERED:
    case DP_MSG_EXTENSION:
    case DP_MSG_UNDO_DEPTH:
    case DP_MSG_DATA:
    case DP_MSG_LOCAL_CHANGE:
    case DP_MSG_UNDO_POINT:
    case DP_MSG_CANVAS_RESIZE:
    case DP_MSG_REMOVED_LAYER_CREATE:
    case DP_MSG_LAYER_ATTRIBUTES:
    case DP_MSG_LAYER_RETITLE:
    case DP_MSG_REMOVED_LAYER_ORDER:
    case DP_MSG_REMOVED_LAYER_DELETE:
    case DP_MSG_REMOVED_LAYER_VISIBILITY:
    case DP_MSG_PUT_IMAGE:
    case DP_MSG_FILL_RECT:
    case DP_MSG_REMOVED_TOOL_CHANGE:
    case DP_MSG_REMOVED_PEN_MOVE:
    case DP_MSG_PEN_UP:
    case DP_MSG_ANNOTATION_CREATE:
    case DP_MSG_ANNOTATION_RESHAPE:
    case DP_MSG_ANNOTATION_EDIT:
    case DP_MSG_ANNOTATION_DELETE:
    case DP_MSG_REMOVED_MOVE_REGION:
    case DP_MSG_PUT_TILE:
    case DP_MSG_CANVAS_BACKGROUND:
    case DP_MSG_DRAW_DABS_CLASSIC:
    case DP_MSG_DRAW_DABS_PIXEL:
    case DP_MSG_DRAW_DABS_PIXEL_SQUARE:
    case DP_MSG_DRAW_DABS_MYPAINT:
    case DP_MSG_MOVE_RECT:
    case DP_MSG_SET_METADATA_INT:
    case DP_MSG_LAYER_TREE_CREATE:
    case DP_MSG_LAYER_TREE_MOVE:
    case DP_MSG_LAYER_TREE_DELETE:
    case DP_MSG_TRANSFORM_REGION:
    case DP_MSG_TRACK_CREATE:
    case DP_MSG_TRACK_RETITLE:
    case DP_MSG_TRACK_DELETE:
    case DP_MSG_TRACK_ORDER:
    case DP_MSG_KEY_FRAME_SET:
    case DP_MSG_KEY_FRAME_RETITLE:
    case DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES:
    case DP_MSG_KEY_FRAME_DELETE:
    case DP_MSG_LOCAL_MATCH:
    case DP_MSG_UNDO:
        return true;
    default:
        return false;
    }
}

const char *DP_message_type_name(DP_MessageType type)
{
    switch (type) {
    case DP_MSG_SERVER_COMMAND:
        return "servercommand";
    case DP_MSG_DISCONNECT:
        return "disconnect";
    case DP_MSG_PING:
        return "ping";
    case DP_MSG_KEEP_ALIVE:
        return "keepalive";
    case DP_MSG_THUMBNAIL:
        return "thumbnail";
    case DP_MSG_INTERNAL:
        return "internal";
    case DP_MSG_JOIN:
        return "join";
    case DP_MSG_LEAVE:
        return "leave";
    case DP_MSG_SESSION_OWNER:
        return "sessionowner";
    case DP_MSG_CHAT:
        return "chat";
    case DP_MSG_TRUSTED_USERS:
        return "trusted";
    case DP_MSG_SOFT_RESET:
        return "softreset";
    case DP_MSG_PRIVATE_CHAT:
        return "privatechat";
    case DP_MSG_RESET_STREAM:
        return "resetstream";
    case DP_MSG_INTERVAL:
        return "interval";
    case DP_MSG_LASER_TRAIL:
        return "lasertrail";
    case DP_MSG_MOVE_POINTER:
        return "movepointer";
    case DP_MSG_REMOVED_MARKER:
        return "removedmarker";
    case DP_MSG_USER_ACL:
        return "useracl";
    case DP_MSG_LAYER_ACL:
        return "layeracl";
    case DP_MSG_FEATURE_ACCESS_LEVELS:
        return "featureaccess";
    case DP_MSG_DEFAULT_LAYER:
        return "defaultlayer";
    case DP_MSG_REMOVED_FILTERED:
        return "removedfiltered";
    case DP_MSG_EXTENSION:
        return "extension";
    case DP_MSG_UNDO_DEPTH:
        return "undodepth";
    case DP_MSG_DATA:
        return "data";
    case DP_MSG_LOCAL_CHANGE:
        return "localchange";
    case DP_MSG_FEATURE_LIMITS:
        return "featurelimits";
    case DP_MSG_UNDO_POINT:
        return "undopoint";
    case DP_MSG_CANVAS_RESIZE:
        return "resize";
    case DP_MSG_REMOVED_LAYER_CREATE:
        return "removedlayercreate";
    case DP_MSG_LAYER_ATTRIBUTES:
        return "layerattr";
    case DP_MSG_LAYER_RETITLE:
        return "retitlelayer";
    case DP_MSG_REMOVED_LAYER_ORDER:
        return "removedlayerorder";
    case DP_MSG_REMOVED_LAYER_DELETE:
        return "removedlayerdelete";
    case DP_MSG_REMOVED_LAYER_VISIBILITY:
        return "removedlayervisibility";
    case DP_MSG_PUT_IMAGE:
        return "putimage";
    case DP_MSG_FILL_RECT:
        return "fillrect";
    case DP_MSG_REMOVED_TOOL_CHANGE:
        return "removedtoolchange";
    case DP_MSG_REMOVED_PEN_MOVE:
        return "removedpenmove";
    case DP_MSG_PEN_UP:
        return "penup";
    case DP_MSG_ANNOTATION_CREATE:
        return "newannotation";
    case DP_MSG_ANNOTATION_RESHAPE:
        return "reshapeannotation";
    case DP_MSG_ANNOTATION_EDIT:
        return "editannotation";
    case DP_MSG_ANNOTATION_DELETE:
        return "deleteannotation";
    case DP_MSG_REMOVED_MOVE_REGION:
        return "removedmoveregion";
    case DP_MSG_PUT_TILE:
        return "puttile";
    case DP_MSG_CANVAS_BACKGROUND:
        return "background";
    case DP_MSG_DRAW_DABS_CLASSIC:
        return "classicdabs";
    case DP_MSG_DRAW_DABS_PIXEL:
        return "pixeldabs";
    case DP_MSG_DRAW_DABS_PIXEL_SQUARE:
        return "squarepixeldabs";
    case DP_MSG_DRAW_DABS_MYPAINT:
        return "mypaintdabs";
    case DP_MSG_DRAW_DABS_MYPAINT_BLEND:
        return "mypaintdabsblend";
    case DP_MSG_MOVE_RECT:
        return "moverect";
    case DP_MSG_SET_METADATA_INT:
        return "setmetadataint";
    case DP_MSG_LAYER_TREE_CREATE:
        return "layertreecreate";
    case DP_MSG_LAYER_TREE_MOVE:
        return "layertreemove";
    case DP_MSG_LAYER_TREE_DELETE:
        return "layertreedelete";
    case DP_MSG_TRANSFORM_REGION:
        return "transformregion";
    case DP_MSG_TRACK_CREATE:
        return "trackcreate";
    case DP_MSG_TRACK_RETITLE:
        return "trackretitle";
    case DP_MSG_TRACK_DELETE:
        return "trackdelete";
    case DP_MSG_TRACK_ORDER:
        return "trackorder";
    case DP_MSG_KEY_FRAME_SET:
        return "keyframeset";
    case DP_MSG_KEY_FRAME_RETITLE:
        return "keyframeretitle";
    case DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES:
        return "keyframelayerattributes";
    case DP_MSG_KEY_FRAME_DELETE:
        return "keyframedelete";
    case DP_MSG_SELECTION_PUT:
        return "selectionput";
    case DP_MSG_SELECTION_CLEAR:
        return "selectionclear";
    case DP_MSG_LOCAL_MATCH:
        return "localmatch";
    case DP_MSG_SYNC_SELECTION_TILE:
        return "syncselectiontile";
    case DP_MSG_PUT_IMAGE_ZSTD:
        return "putimagezstd";
    case DP_MSG_PUT_TILE_ZSTD:
        return "puttilezstd";
    case DP_MSG_CANVAS_BACKGROUND_ZSTD:
        return "canvasbackgroundzstd";
    case DP_MSG_MOVE_RECT_ZSTD:
        return "moverectzstd";
    case DP_MSG_TRANSFORM_REGION_ZSTD:
        return "transformregionzstd";
    case DP_MSG_UNDO:
        return "undo";
    default:
        return "unknown";
    }
}

const char *DP_message_type_enum_name(DP_MessageType type)
{
    switch (type) {
    case DP_MSG_SERVER_COMMAND:
        return "DP_MSG_SERVER_COMMAND";
    case DP_MSG_DISCONNECT:
        return "DP_MSG_DISCONNECT";
    case DP_MSG_PING:
        return "DP_MSG_PING";
    case DP_MSG_KEEP_ALIVE:
        return "DP_MSG_KEEP_ALIVE";
    case DP_MSG_THUMBNAIL:
        return "DP_MSG_THUMBNAIL";
    case DP_MSG_INTERNAL:
        return "DP_MSG_INTERNAL";
    case DP_MSG_JOIN:
        return "DP_MSG_JOIN";
    case DP_MSG_LEAVE:
        return "DP_MSG_LEAVE";
    case DP_MSG_SESSION_OWNER:
        return "DP_MSG_SESSION_OWNER";
    case DP_MSG_CHAT:
        return "DP_MSG_CHAT";
    case DP_MSG_TRUSTED_USERS:
        return "DP_MSG_TRUSTED_USERS";
    case DP_MSG_SOFT_RESET:
        return "DP_MSG_SOFT_RESET";
    case DP_MSG_PRIVATE_CHAT:
        return "DP_MSG_PRIVATE_CHAT";
    case DP_MSG_RESET_STREAM:
        return "DP_MSG_RESET_STREAM";
    case DP_MSG_INTERVAL:
        return "DP_MSG_INTERVAL";
    case DP_MSG_LASER_TRAIL:
        return "DP_MSG_LASER_TRAIL";
    case DP_MSG_MOVE_POINTER:
        return "DP_MSG_MOVE_POINTER";
    case DP_MSG_REMOVED_MARKER:
        return "DP_MSG_REMOVED_MARKER";
    case DP_MSG_USER_ACL:
        return "DP_MSG_USER_ACL";
    case DP_MSG_LAYER_ACL:
        return "DP_MSG_LAYER_ACL";
    case DP_MSG_FEATURE_ACCESS_LEVELS:
        return "DP_MSG_FEATURE_ACCESS_LEVELS";
    case DP_MSG_DEFAULT_LAYER:
        return "DP_MSG_DEFAULT_LAYER";
    case DP_MSG_REMOVED_FILTERED:
        return "DP_MSG_REMOVED_FILTERED";
    case DP_MSG_EXTENSION:
        return "DP_MSG_EXTENSION";
    case DP_MSG_UNDO_DEPTH:
        return "DP_MSG_UNDO_DEPTH";
    case DP_MSG_DATA:
        return "DP_MSG_DATA";
    case DP_MSG_LOCAL_CHANGE:
        return "DP_MSG_LOCAL_CHANGE";
    case DP_MSG_FEATURE_LIMITS:
        return "DP_MSG_FEATURE_LIMITS";
    case DP_MSG_UNDO_POINT:
        return "DP_MSG_UNDO_POINT";
    case DP_MSG_CANVAS_RESIZE:
        return "DP_MSG_CANVAS_RESIZE";
    case DP_MSG_REMOVED_LAYER_CREATE:
        return "DP_MSG_REMOVED_LAYER_CREATE";
    case DP_MSG_LAYER_ATTRIBUTES:
        return "DP_MSG_LAYER_ATTRIBUTES";
    case DP_MSG_LAYER_RETITLE:
        return "DP_MSG_LAYER_RETITLE";
    case DP_MSG_REMOVED_LAYER_ORDER:
        return "DP_MSG_REMOVED_LAYER_ORDER";
    case DP_MSG_REMOVED_LAYER_DELETE:
        return "DP_MSG_REMOVED_LAYER_DELETE";
    case DP_MSG_REMOVED_LAYER_VISIBILITY:
        return "DP_MSG_REMOVED_LAYER_VISIBILITY";
    case DP_MSG_PUT_IMAGE:
        return "DP_MSG_PUT_IMAGE";
    case DP_MSG_FILL_RECT:
        return "DP_MSG_FILL_RECT";
    case DP_MSG_REMOVED_TOOL_CHANGE:
        return "DP_MSG_REMOVED_TOOL_CHANGE";
    case DP_MSG_REMOVED_PEN_MOVE:
        return "DP_MSG_REMOVED_PEN_MOVE";
    case DP_MSG_PEN_UP:
        return "DP_MSG_PEN_UP";
    case DP_MSG_ANNOTATION_CREATE:
        return "DP_MSG_ANNOTATION_CREATE";
    case DP_MSG_ANNOTATION_RESHAPE:
        return "DP_MSG_ANNOTATION_RESHAPE";
    case DP_MSG_ANNOTATION_EDIT:
        return "DP_MSG_ANNOTATION_EDIT";
    case DP_MSG_ANNOTATION_DELETE:
        return "DP_MSG_ANNOTATION_DELETE";
    case DP_MSG_REMOVED_MOVE_REGION:
        return "DP_MSG_REMOVED_MOVE_REGION";
    case DP_MSG_PUT_TILE:
        return "DP_MSG_PUT_TILE";
    case DP_MSG_CANVAS_BACKGROUND:
        return "DP_MSG_CANVAS_BACKGROUND";
    case DP_MSG_DRAW_DABS_CLASSIC:
        return "DP_MSG_DRAW_DABS_CLASSIC";
    case DP_MSG_DRAW_DABS_PIXEL:
        return "DP_MSG_DRAW_DABS_PIXEL";
    case DP_MSG_DRAW_DABS_PIXEL_SQUARE:
        return "DP_MSG_DRAW_DABS_PIXEL_SQUARE";
    case DP_MSG_DRAW_DABS_MYPAINT:
        return "DP_MSG_DRAW_DABS_MYPAINT";
    case DP_MSG_DRAW_DABS_MYPAINT_BLEND:
        return "DP_MSG_DRAW_DABS_MYPAINT_BLEND";
    case DP_MSG_MOVE_RECT:
        return "DP_MSG_MOVE_RECT";
    case DP_MSG_SET_METADATA_INT:
        return "DP_MSG_SET_METADATA_INT";
    case DP_MSG_LAYER_TREE_CREATE:
        return "DP_MSG_LAYER_TREE_CREATE";
    case DP_MSG_LAYER_TREE_MOVE:
        return "DP_MSG_LAYER_TREE_MOVE";
    case DP_MSG_LAYER_TREE_DELETE:
        return "DP_MSG_LAYER_TREE_DELETE";
    case DP_MSG_TRANSFORM_REGION:
        return "DP_MSG_TRANSFORM_REGION";
    case DP_MSG_TRACK_CREATE:
        return "DP_MSG_TRACK_CREATE";
    case DP_MSG_TRACK_RETITLE:
        return "DP_MSG_TRACK_RETITLE";
    case DP_MSG_TRACK_DELETE:
        return "DP_MSG_TRACK_DELETE";
    case DP_MSG_TRACK_ORDER:
        return "DP_MSG_TRACK_ORDER";
    case DP_MSG_KEY_FRAME_SET:
        return "DP_MSG_KEY_FRAME_SET";
    case DP_MSG_KEY_FRAME_RETITLE:
        return "DP_MSG_KEY_FRAME_RETITLE";
    case DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES:
        return "DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES";
    case DP_MSG_KEY_FRAME_DELETE:
        return "DP_MSG_KEY_FRAME_DELETE";
    case DP_MSG_SELECTION_PUT:
        return "DP_MSG_SELECTION_PUT";
    case DP_MSG_SELECTION_CLEAR:
        return "DP_MSG_SELECTION_CLEAR";
    case DP_MSG_LOCAL_MATCH:
        return "DP_MSG_LOCAL_MATCH";
    case DP_MSG_SYNC_SELECTION_TILE:
        return "DP_MSG_SYNC_SELECTION_TILE";
    case DP_MSG_PUT_IMAGE_ZSTD:
        return "DP_MSG_PUT_IMAGE_ZSTD";
    case DP_MSG_PUT_TILE_ZSTD:
        return "DP_MSG_PUT_TILE_ZSTD";
    case DP_MSG_CANVAS_BACKGROUND_ZSTD:
        return "DP_MSG_CANVAS_BACKGROUND_ZSTD";
    case DP_MSG_MOVE_RECT_ZSTD:
        return "DP_MSG_MOVE_RECT_ZSTD";
    case DP_MSG_TRANSFORM_REGION_ZSTD:
        return "DP_MSG_TRANSFORM_REGION_ZSTD";
    case DP_MSG_UNDO:
        return "DP_MSG_UNDO";
    default:
        return "DP_MSG_UNKNOWN";
    }
}

const char *DP_message_type_enum_name_unprefixed(DP_MessageType type)
{
    return DP_message_type_enum_name(type) + 7;
}

DP_MessageType DP_message_type_from_name(const char *type_name,
                                         DP_MessageType not_found_value)
{
    if (DP_str_equal(type_name, "servercommand")) {
        return DP_MSG_SERVER_COMMAND;
    }
    else if (DP_str_equal(type_name, "disconnect")) {
        return DP_MSG_DISCONNECT;
    }
    else if (DP_str_equal(type_name, "ping")) {
        return DP_MSG_PING;
    }
    else if (DP_str_equal(type_name, "keepalive")) {
        return DP_MSG_KEEP_ALIVE;
    }
    else if (DP_str_equal(type_name, "thumbnail")) {
        return DP_MSG_THUMBNAIL;
    }
    else if (DP_str_equal(type_name, "join")) {
        return DP_MSG_JOIN;
    }
    else if (DP_str_equal(type_name, "leave")) {
        return DP_MSG_LEAVE;
    }
    else if (DP_str_equal(type_name, "sessionowner")) {
        return DP_MSG_SESSION_OWNER;
    }
    else if (DP_str_equal(type_name, "chat")) {
        return DP_MSG_CHAT;
    }
    else if (DP_str_equal(type_name, "trusted")) {
        return DP_MSG_TRUSTED_USERS;
    }
    else if (DP_str_equal(type_name, "softreset")) {
        return DP_MSG_SOFT_RESET;
    }
    else if (DP_str_equal(type_name, "privatechat")) {
        return DP_MSG_PRIVATE_CHAT;
    }
    else if (DP_str_equal(type_name, "resetstream")) {
        return DP_MSG_RESET_STREAM;
    }
    else if (DP_str_equal(type_name, "interval")) {
        return DP_MSG_INTERVAL;
    }
    else if (DP_str_equal(type_name, "lasertrail")) {
        return DP_MSG_LASER_TRAIL;
    }
    else if (DP_str_equal(type_name, "movepointer")) {
        return DP_MSG_MOVE_POINTER;
    }
    else if (DP_str_equal(type_name, "useracl")) {
        return DP_MSG_USER_ACL;
    }
    else if (DP_str_equal(type_name, "layeracl")) {
        return DP_MSG_LAYER_ACL;
    }
    else if (DP_str_equal(type_name, "featureaccess")) {
        return DP_MSG_FEATURE_ACCESS_LEVELS;
    }
    else if (DP_str_equal(type_name, "defaultlayer")) {
        return DP_MSG_DEFAULT_LAYER;
    }
    else if (DP_str_equal(type_name, "undodepth")) {
        return DP_MSG_UNDO_DEPTH;
    }
    else if (DP_str_equal(type_name, "data")) {
        return DP_MSG_DATA;
    }
    else if (DP_str_equal(type_name, "localchange")) {
        return DP_MSG_LOCAL_CHANGE;
    }
    else if (DP_str_equal(type_name, "featurelimits")) {
        return DP_MSG_FEATURE_LIMITS;
    }
    else if (DP_str_equal(type_name, "undopoint")) {
        return DP_MSG_UNDO_POINT;
    }
    else if (DP_str_equal(type_name, "resize")) {
        return DP_MSG_CANVAS_RESIZE;
    }
    else if (DP_str_equal(type_name, "layerattr")) {
        return DP_MSG_LAYER_ATTRIBUTES;
    }
    else if (DP_str_equal(type_name, "retitlelayer")) {
        return DP_MSG_LAYER_RETITLE;
    }
    else if (DP_str_equal(type_name, "putimage")) {
        return DP_MSG_PUT_IMAGE;
    }
    else if (DP_str_equal(type_name, "fillrect")) {
        return DP_MSG_FILL_RECT;
    }
    else if (DP_str_equal(type_name, "penup")) {
        return DP_MSG_PEN_UP;
    }
    else if (DP_str_equal(type_name, "newannotation")) {
        return DP_MSG_ANNOTATION_CREATE;
    }
    else if (DP_str_equal(type_name, "reshapeannotation")) {
        return DP_MSG_ANNOTATION_RESHAPE;
    }
    else if (DP_str_equal(type_name, "editannotation")) {
        return DP_MSG_ANNOTATION_EDIT;
    }
    else if (DP_str_equal(type_name, "deleteannotation")) {
        return DP_MSG_ANNOTATION_DELETE;
    }
    else if (DP_str_equal(type_name, "puttile")) {
        return DP_MSG_PUT_TILE;
    }
    else if (DP_str_equal(type_name, "background")) {
        return DP_MSG_CANVAS_BACKGROUND;
    }
    else if (DP_str_equal(type_name, "classicdabs")) {
        return DP_MSG_DRAW_DABS_CLASSIC;
    }
    else if (DP_str_equal(type_name, "pixeldabs")) {
        return DP_MSG_DRAW_DABS_PIXEL;
    }
    else if (DP_str_equal(type_name, "squarepixeldabs")) {
        return DP_MSG_DRAW_DABS_PIXEL_SQUARE;
    }
    else if (DP_str_equal(type_name, "mypaintdabs")) {
        return DP_MSG_DRAW_DABS_MYPAINT;
    }
    else if (DP_str_equal(type_name, "mypaintdabsblend")) {
        return DP_MSG_DRAW_DABS_MYPAINT_BLEND;
    }
    else if (DP_str_equal(type_name, "moverect")) {
        return DP_MSG_MOVE_RECT;
    }
    else if (DP_str_equal(type_name, "setmetadataint")) {
        return DP_MSG_SET_METADATA_INT;
    }
    else if (DP_str_equal(type_name, "layertreecreate")) {
        return DP_MSG_LAYER_TREE_CREATE;
    }
    else if (DP_str_equal(type_name, "layertreemove")) {
        return DP_MSG_LAYER_TREE_MOVE;
    }
    else if (DP_str_equal(type_name, "layertreedelete")) {
        return DP_MSG_LAYER_TREE_DELETE;
    }
    else if (DP_str_equal(type_name, "transformregion")) {
        return DP_MSG_TRANSFORM_REGION;
    }
    else if (DP_str_equal(type_name, "trackcreate")) {
        return DP_MSG_TRACK_CREATE;
    }
    else if (DP_str_equal(type_name, "trackretitle")) {
        return DP_MSG_TRACK_RETITLE;
    }
    else if (DP_str_equal(type_name, "trackdelete")) {
        return DP_MSG_TRACK_DELETE;
    }
    else if (DP_str_equal(type_name, "trackorder")) {
        return DP_MSG_TRACK_ORDER;
    }
    else if (DP_str_equal(type_name, "keyframeset")) {
        return DP_MSG_KEY_FRAME_SET;
    }
    else if (DP_str_equal(type_name, "keyframeretitle")) {
        return DP_MSG_KEY_FRAME_RETITLE;
    }
    else if (DP_str_equal(type_name, "keyframelayerattributes")) {
        return DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES;
    }
    else if (DP_str_equal(type_name, "keyframedelete")) {
        return DP_MSG_KEY_FRAME_DELETE;
    }
    else if (DP_str_equal(type_name, "selectionput")) {
        return DP_MSG_SELECTION_PUT;
    }
    else if (DP_str_equal(type_name, "selectionclear")) {
        return DP_MSG_SELECTION_CLEAR;
    }
    else if (DP_str_equal(type_name, "localmatch")) {
        return DP_MSG_LOCAL_MATCH;
    }
    else if (DP_str_equal(type_name, "syncselectiontile")) {
        return DP_MSG_SYNC_SELECTION_TILE;
    }
    else if (DP_str_equal(type_name, "putimagezstd")) {
        return DP_MSG_PUT_IMAGE_ZSTD;
    }
    else if (DP_str_equal(type_name, "puttilezstd")) {
        return DP_MSG_PUT_TILE_ZSTD;
    }
    else if (DP_str_equal(type_name, "canvasbackgroundzstd")) {
        return DP_MSG_CANVAS_BACKGROUND_ZSTD;
    }
    else if (DP_str_equal(type_name, "moverectzstd")) {
        return DP_MSG_MOVE_RECT_ZSTD;
    }
    else if (DP_str_equal(type_name, "transformregionzstd")) {
        return DP_MSG_TRANSFORM_REGION_ZSTD;
    }
    else if (DP_str_equal(type_name, "undo")) {
        return DP_MSG_UNDO;
    }
    else {
        return not_found_value;
    }
}


bool DP_message_dirties_canvas(DP_Message *msg)
{
    DP_ASSERT(msg);
    switch (DP_message_type(msg)) {
    case DP_MSG_LOCAL_CHANGE:
        switch (DP_msg_local_change_type(DP_message_internal(msg))) {
        case DP_MSG_LOCAL_CHANGE_TYPE_VIEW_MODE:
        case DP_MSG_LOCAL_CHANGE_TYPE_ACTIVE_LAYER:
        case DP_MSG_LOCAL_CHANGE_TYPE_ACTIVE_FRAME:
        case DP_MSG_LOCAL_CHANGE_TYPE_ONION_SKINS:
            return false;
        default:
            return true;
        }
    case DP_MSG_CANVAS_RESIZE:
    case DP_MSG_LAYER_ATTRIBUTES:
    case DP_MSG_LAYER_RETITLE:
    case DP_MSG_PUT_IMAGE:
    case DP_MSG_FILL_RECT:
    case DP_MSG_ANNOTATION_CREATE:
    case DP_MSG_ANNOTATION_RESHAPE:
    case DP_MSG_ANNOTATION_EDIT:
    case DP_MSG_ANNOTATION_DELETE:
    case DP_MSG_PUT_TILE:
    case DP_MSG_CANVAS_BACKGROUND:
    case DP_MSG_DRAW_DABS_CLASSIC:
    case DP_MSG_DRAW_DABS_PIXEL:
    case DP_MSG_DRAW_DABS_PIXEL_SQUARE:
    case DP_MSG_DRAW_DABS_MYPAINT:
    case DP_MSG_DRAW_DABS_MYPAINT_BLEND:
    case DP_MSG_MOVE_RECT:
    case DP_MSG_SET_METADATA_INT:
    case DP_MSG_LAYER_TREE_CREATE:
    case DP_MSG_LAYER_TREE_MOVE:
    case DP_MSG_LAYER_TREE_DELETE:
    case DP_MSG_TRANSFORM_REGION:
    case DP_MSG_TRACK_CREATE:
    case DP_MSG_TRACK_RETITLE:
    case DP_MSG_TRACK_DELETE:
    case DP_MSG_TRACK_ORDER:
    case DP_MSG_KEY_FRAME_SET:
    case DP_MSG_KEY_FRAME_RETITLE:
    case DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES:
    case DP_MSG_KEY_FRAME_DELETE:
    case DP_MSG_PUT_IMAGE_ZSTD:
    case DP_MSG_PUT_TILE_ZSTD:
    case DP_MSG_CANVAS_BACKGROUND_ZSTD:
    case DP_MSG_MOVE_RECT_ZSTD:
    case DP_MSG_TRANSFORM_REGION_ZSTD:
    case DP_MSG_UNDO:
        return true;
    default:
        return false;
    }
}

DP_Message *DP_message_deserialize_body(int type, unsigned int context_id,
                                        const unsigned char *buf, size_t length,
                                        bool decode_opaque)
{
    if (type < DP_MESSAGE_TYPE_RANGE_START_CLIENT || decode_opaque) {
        switch (type) {
        case DP_MSG_SERVER_COMMAND:
            return DP_msg_server_command_deserialize(context_id, buf, length);
        case DP_MSG_DISCONNECT:
            return DP_msg_disconnect_deserialize(context_id, buf, length);
        case DP_MSG_PING:
            return DP_msg_ping_deserialize(context_id, buf, length);
        case DP_MSG_KEEP_ALIVE:
            return DP_msg_keep_alive_deserialize(context_id, buf, length);
        case DP_MSG_THUMBNAIL:
            return DP_msg_thumbnail_deserialize(context_id, buf, length);
        case DP_MSG_INTERNAL:
            DP_error_set(
                "Can't deserialize reserved message type 31 DP_MSG_INTERNAL");
            return NULL;
        case DP_MSG_JOIN:
            return DP_msg_join_deserialize(context_id, buf, length);
        case DP_MSG_LEAVE:
            return DP_msg_leave_deserialize(context_id, buf, length);
        case DP_MSG_SESSION_OWNER:
            return DP_msg_session_owner_deserialize(context_id, buf, length);
        case DP_MSG_CHAT:
            return DP_msg_chat_deserialize(context_id, buf, length);
        case DP_MSG_TRUSTED_USERS:
            return DP_msg_trusted_users_deserialize(context_id, buf, length);
        case DP_MSG_SOFT_RESET:
            return DP_msg_soft_reset_deserialize(context_id, buf, length);
        case DP_MSG_PRIVATE_CHAT:
            return DP_msg_private_chat_deserialize(context_id, buf, length);
        case DP_MSG_RESET_STREAM:
            return DP_msg_reset_stream_deserialize(context_id, buf, length);
        case DP_MSG_INTERVAL:
            return DP_msg_interval_deserialize(context_id, buf, length);
        case DP_MSG_LASER_TRAIL:
            return DP_msg_laser_trail_deserialize(context_id, buf, length);
        case DP_MSG_MOVE_POINTER:
            return DP_msg_move_pointer_deserialize(context_id, buf, length);
        case DP_MSG_REMOVED_MARKER:
            DP_error_set("Can't deserialize reserved message type 67 "
                         "DP_MSG_REMOVED_MARKER");
            return NULL;
        case DP_MSG_USER_ACL:
            return DP_msg_user_acl_deserialize(context_id, buf, length);
        case DP_MSG_LAYER_ACL:
            return DP_msg_layer_acl_deserialize(context_id, buf, length);
        case DP_MSG_FEATURE_ACCESS_LEVELS:
            return DP_msg_feature_access_levels_deserialize(context_id, buf,
                                                            length);
        case DP_MSG_DEFAULT_LAYER:
            return DP_msg_default_layer_deserialize(context_id, buf, length);
        case DP_MSG_REMOVED_FILTERED:
            DP_error_set("Can't deserialize reserved message type 72 "
                         "DP_MSG_REMOVED_FILTERED");
            return NULL;
        case DP_MSG_EXTENSION:
            DP_error_set(
                "Can't deserialize reserved message type 73 DP_MSG_EXTENSION");
            return NULL;
        case DP_MSG_UNDO_DEPTH:
            return DP_msg_undo_depth_deserialize(context_id, buf, length);
        case DP_MSG_DATA:
            return DP_msg_data_deserialize(context_id, buf, length);
        case DP_MSG_LOCAL_CHANGE:
            return DP_msg_local_change_deserialize(context_id, buf, length);
        case DP_MSG_FEATURE_LIMITS:
            return DP_msg_feature_limits_deserialize(context_id, buf, length);
        case DP_MSG_UNDO_POINT:
            return DP_msg_undo_point_deserialize(context_id, buf, length);
        case DP_MSG_CANVAS_RESIZE:
            return DP_msg_canvas_resize_deserialize(context_id, buf, length);
        case DP_MSG_REMOVED_LAYER_CREATE:
            DP_error_set("Can't deserialize reserved message type 130 "
                         "DP_MSG_REMOVED_LAYER_CREATE");
            return NULL;
        case DP_MSG_LAYER_ATTRIBUTES:
            return DP_msg_layer_attributes_deserialize(context_id, buf, length);
        case DP_MSG_LAYER_RETITLE:
            return DP_msg_layer_retitle_deserialize(context_id, buf, length);
        case DP_MSG_REMOVED_LAYER_ORDER:
            DP_error_set("Can't deserialize reserved message type 133 "
                         "DP_MSG_REMOVED_LAYER_ORDER");
            return NULL;
        case DP_MSG_REMOVED_LAYER_DELETE:
            DP_error_set("Can't deserialize reserved message type 134 "
                         "DP_MSG_REMOVED_LAYER_DELETE");
            return NULL;
        case DP_MSG_REMOVED_LAYER_VISIBILITY:
            DP_error_set("Can't deserialize reserved message type 135 "
                         "DP_MSG_REMOVED_LAYER_VISIBILITY");
            return NULL;
        case DP_MSG_PUT_IMAGE:
            return DP_msg_put_image_deserialize(context_id, buf, length);
        case DP_MSG_FILL_RECT:
            return DP_msg_fill_rect_deserialize(context_id, buf, length);
        case DP_MSG_REMOVED_TOOL_CHANGE:
            DP_error_set("Can't deserialize reserved message type 138 "
                         "DP_MSG_REMOVED_TOOL_CHANGE");
            return NULL;
        case DP_MSG_REMOVED_PEN_MOVE:
            DP_error_set("Can't deserialize reserved message type 139 "
                         "DP_MSG_REMOVED_PEN_MOVE");
            return NULL;
        case DP_MSG_PEN_UP:
            return DP_msg_pen_up_deserialize(context_id, buf, length);
        case DP_MSG_ANNOTATION_CREATE:
            return DP_msg_annotation_create_deserialize(context_id, buf,
                                                        length);
        case DP_MSG_ANNOTATION_RESHAPE:
            return DP_msg_annotation_reshape_deserialize(context_id, buf,
                                                         length);
        case DP_MSG_ANNOTATION_EDIT:
            return DP_msg_annotation_edit_deserialize(context_id, buf, length);
        case DP_MSG_ANNOTATION_DELETE:
            return DP_msg_annotation_delete_deserialize(context_id, buf,
                                                        length);
        case DP_MSG_REMOVED_MOVE_REGION:
            DP_error_set("Can't deserialize reserved message type 145 "
                         "DP_MSG_REMOVED_MOVE_REGION");
            return NULL;
        case DP_MSG_PUT_TILE:
            return DP_msg_put_tile_deserialize(context_id, buf, length);
        case DP_MSG_CANVAS_BACKGROUND:
            return DP_msg_canvas_background_deserialize(context_id, buf,
                                                        length);
        case DP_MSG_DRAW_DABS_CLASSIC:
            return DP_msg_draw_dabs_classic_deserialize(context_id, buf,
                                                        length);
        case DP_MSG_DRAW_DABS_PIXEL:
            return DP_msg_draw_dabs_pixel_deserialize(context_id, buf, length);
        case DP_MSG_DRAW_DABS_PIXEL_SQUARE:
            return DP_msg_draw_dabs_pixel_square_deserialize(context_id, buf,
                                                             length);
        case DP_MSG_DRAW_DABS_MYPAINT:
            return DP_msg_draw_dabs_mypaint_deserialize(context_id, buf,
                                                        length);
        case DP_MSG_DRAW_DABS_MYPAINT_BLEND:
            return DP_msg_draw_dabs_mypaint_blend_deserialize(context_id, buf,
                                                              length);
        case DP_MSG_MOVE_RECT:
            return DP_msg_move_rect_deserialize(context_id, buf, length);
        case DP_MSG_SET_METADATA_INT:
            return DP_msg_set_metadata_int_deserialize(context_id, buf, length);
        case DP_MSG_LAYER_TREE_CREATE:
            return DP_msg_layer_tree_create_deserialize(context_id, buf,
                                                        length);
        case DP_MSG_LAYER_TREE_MOVE:
            return DP_msg_layer_tree_move_deserialize(context_id, buf, length);
        case DP_MSG_LAYER_TREE_DELETE:
            return DP_msg_layer_tree_delete_deserialize(context_id, buf,
                                                        length);
        case DP_MSG_TRANSFORM_REGION:
            return DP_msg_transform_region_deserialize(context_id, buf, length);
        case DP_MSG_TRACK_CREATE:
            return DP_msg_track_create_deserialize(context_id, buf, length);
        case DP_MSG_TRACK_RETITLE:
            return DP_msg_track_retitle_deserialize(context_id, buf, length);
        case DP_MSG_TRACK_DELETE:
            return DP_msg_track_delete_deserialize(context_id, buf, length);
        case DP_MSG_TRACK_ORDER:
            return DP_msg_track_order_deserialize(context_id, buf, length);
        case DP_MSG_KEY_FRAME_SET:
            return DP_msg_key_frame_set_deserialize(context_id, buf, length);
        case DP_MSG_KEY_FRAME_RETITLE:
            return DP_msg_key_frame_retitle_deserialize(context_id, buf,
                                                        length);
        case DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES:
            return DP_msg_key_frame_layer_attributes_deserialize(context_id,
                                                                 buf, length);
        case DP_MSG_KEY_FRAME_DELETE:
            return DP_msg_key_frame_delete_deserialize(context_id, buf, length);
        case DP_MSG_SELECTION_PUT:
            return DP_msg_selection_put_deserialize(context_id, buf, length);
        case DP_MSG_SELECTION_CLEAR:
            return DP_msg_selection_clear_deserialize(context_id, buf, length);
        case DP_MSG_LOCAL_MATCH:
            return DP_msg_local_match_deserialize(context_id, buf, length);
        case DP_MSG_SYNC_SELECTION_TILE:
            return DP_msg_sync_selection_tile_deserialize(context_id, buf,
                                                          length);
        case DP_MSG_PUT_IMAGE_ZSTD:
            return DP_msg_put_image_zstd_deserialize(context_id, buf, length);
        case DP_MSG_PUT_TILE_ZSTD:
            return DP_msg_put_tile_zstd_deserialize(context_id, buf, length);
        case DP_MSG_CANVAS_BACKGROUND_ZSTD:
            return DP_msg_canvas_background_zstd_deserialize(context_id, buf,
                                                             length);
        case DP_MSG_MOVE_RECT_ZSTD:
            return DP_msg_move_rect_zstd_deserialize(context_id, buf, length);
        case DP_MSG_TRANSFORM_REGION_ZSTD:
            return DP_msg_transform_region_zstd_deserialize(context_id, buf,
                                                            length);
        case DP_MSG_UNDO:
            return DP_msg_undo_deserialize(context_id, buf, length);
        default:
            DP_error_set("Can't deserialize unknown message type %d", type);
            return NULL;
        }
    }
    else {
        return DP_message_new_opaque((DP_MessageType)type, context_id, buf,
                                     length);
    }
}

DP_Message *DP_message_deserialize_body_compat(int type,
                                               unsigned int context_id,
                                               const unsigned char *buf,
                                               size_t length,
                                               bool decode_opaque)
{
    if (type < DP_MESSAGE_TYPE_RANGE_START_CLIENT || decode_opaque) {
        switch (type) {
        case DP_MSG_SERVER_COMMAND:
            return DP_msg_server_command_deserialize_compat(context_id, buf,
                                                            length);
        case DP_MSG_DISCONNECT:
            return DP_msg_disconnect_deserialize_compat(context_id, buf,
                                                        length);
        case DP_MSG_PING:
            return DP_msg_ping_deserialize_compat(context_id, buf, length);
        case DP_MSG_KEEP_ALIVE:
            return DP_msg_keep_alive_deserialize_compat(context_id, buf,
                                                        length);
        case DP_MSG_THUMBNAIL:
            return DP_msg_thumbnail_deserialize_compat(context_id, buf, length);
        case DP_MSG_INTERNAL:
            DP_error_set(
                "Can't deserialize reserved message type 31 DP_MSG_INTERNAL");
            return NULL;
        case DP_MSG_JOIN:
            return DP_msg_join_deserialize_compat(context_id, buf, length);
        case DP_MSG_LEAVE:
            return DP_msg_leave_deserialize_compat(context_id, buf, length);
        case DP_MSG_SESSION_OWNER:
            return DP_msg_session_owner_deserialize_compat(context_id, buf,
                                                           length);
        case DP_MSG_CHAT:
            return DP_msg_chat_deserialize_compat(context_id, buf, length);
        case DP_MSG_TRUSTED_USERS:
            return DP_msg_trusted_users_deserialize_compat(context_id, buf,
                                                           length);
        case DP_MSG_SOFT_RESET:
            return DP_msg_soft_reset_deserialize_compat(context_id, buf,
                                                        length);
        case DP_MSG_PRIVATE_CHAT:
            return DP_msg_private_chat_deserialize_compat(context_id, buf,
                                                          length);
        case DP_MSG_RESET_STREAM:
            return DP_msg_reset_stream_deserialize_compat(context_id, buf,
                                                          length);
        case DP_MSG_INTERVAL:
            return DP_msg_interval_deserialize_compat(context_id, buf, length);
        case DP_MSG_LASER_TRAIL:
            return DP_msg_laser_trail_deserialize_compat(context_id, buf,
                                                         length);
        case DP_MSG_MOVE_POINTER:
            return DP_msg_move_pointer_deserialize_compat(context_id, buf,
                                                          length);
        case DP_MSG_REMOVED_MARKER:
            DP_error_set("Can't deserialize reserved message type 67 "
                         "DP_MSG_REMOVED_MARKER");
            return NULL;
        case DP_MSG_USER_ACL:
            return DP_msg_user_acl_deserialize_compat(context_id, buf, length);
        case DP_MSG_LAYER_ACL:
            return DP_msg_layer_acl_deserialize_compat(context_id, buf, length);
        case DP_MSG_FEATURE_ACCESS_LEVELS:
            return DP_msg_feature_access_levels_deserialize_compat(context_id,
                                                                   buf, length);
        case DP_MSG_DEFAULT_LAYER:
            return DP_msg_default_layer_deserialize_compat(context_id, buf,
                                                           length);
        case DP_MSG_REMOVED_FILTERED:
            DP_error_set("Can't deserialize reserved message type 72 "
                         "DP_MSG_REMOVED_FILTERED");
            return NULL;
        case DP_MSG_EXTENSION:
            DP_error_set(
                "Can't deserialize reserved message type 73 DP_MSG_EXTENSION");
            return NULL;
        case DP_MSG_UNDO_DEPTH:
            return DP_msg_undo_depth_deserialize_compat(context_id, buf,
                                                        length);
        case DP_MSG_DATA:
            return DP_msg_data_deserialize_compat(context_id, buf, length);
        case DP_MSG_LOCAL_CHANGE:
            return DP_msg_local_change_deserialize_compat(context_id, buf,
                                                          length);
        case DP_MSG_FEATURE_LIMITS:
            DP_error_set("Can't deserialize incompatible message type 77 "
                         "DP_MSG_FEATURE_LIMITS");
            return NULL;
        case DP_MSG_UNDO_POINT:
            return DP_msg_undo_point_deserialize_compat(context_id, buf,
                                                        length);
        case DP_MSG_CANVAS_RESIZE:
            return DP_msg_canvas_resize_deserialize_compat(context_id, buf,
                                                           length);
        case DP_MSG_REMOVED_LAYER_CREATE:
            DP_error_set("Can't deserialize reserved message type 130 "
                         "DP_MSG_REMOVED_LAYER_CREATE");
            return NULL;
        case DP_MSG_LAYER_ATTRIBUTES:
            return DP_msg_layer_attributes_deserialize_compat(context_id, buf,
                                                              length);
        case DP_MSG_LAYER_RETITLE:
            return DP_msg_layer_retitle_deserialize_compat(context_id, buf,
                                                           length);
        case DP_MSG_REMOVED_LAYER_ORDER:
            DP_error_set("Can't deserialize reserved message type 133 "
                         "DP_MSG_REMOVED_LAYER_ORDER");
            return NULL;
        case DP_MSG_REMOVED_LAYER_DELETE:
            DP_error_set("Can't deserialize reserved message type 134 "
                         "DP_MSG_REMOVED_LAYER_DELETE");
            return NULL;
        case DP_MSG_REMOVED_LAYER_VISIBILITY:
            DP_error_set("Can't deserialize reserved message type 135 "
                         "DP_MSG_REMOVED_LAYER_VISIBILITY");
            return NULL;
        case DP_MSG_PUT_IMAGE:
            return DP_msg_put_image_deserialize_compat(context_id, buf, length);
        case DP_MSG_FILL_RECT:
            return DP_msg_fill_rect_deserialize_compat(context_id, buf, length);
        case DP_MSG_REMOVED_TOOL_CHANGE:
            DP_error_set("Can't deserialize reserved message type 138 "
                         "DP_MSG_REMOVED_TOOL_CHANGE");
            return NULL;
        case DP_MSG_REMOVED_PEN_MOVE:
            DP_error_set("Can't deserialize reserved message type 139 "
                         "DP_MSG_REMOVED_PEN_MOVE");
            return NULL;
        case DP_MSG_PEN_UP:
            return DP_msg_pen_up_deserialize_compat(context_id, buf, length);
        case DP_MSG_ANNOTATION_CREATE:
            return DP_msg_annotation_create_deserialize_compat(context_id, buf,
                                                               length);
        case DP_MSG_ANNOTATION_RESHAPE:
            return DP_msg_annotation_reshape_deserialize_compat(context_id, buf,
                                                                length);
        case DP_MSG_ANNOTATION_EDIT:
            return DP_msg_annotation_edit_deserialize_compat(context_id, buf,
                                                             length);
        case DP_MSG_ANNOTATION_DELETE:
            return DP_msg_annotation_delete_deserialize_compat(context_id, buf,
                                                               length);
        case DP_MSG_REMOVED_MOVE_REGION:
            DP_error_set("Can't deserialize reserved message type 145 "
                         "DP_MSG_REMOVED_MOVE_REGION");
            return NULL;
        case DP_MSG_PUT_TILE:
            return DP_msg_put_tile_deserialize_compat(context_id, buf, length);
        case DP_MSG_CANVAS_BACKGROUND:
            return DP_msg_canvas_background_deserialize_compat(context_id, buf,
                                                               length);
        case DP_MSG_DRAW_DABS_CLASSIC:
            return DP_msg_draw_dabs_classic_deserialize_compat(context_id, buf,
                                                               length);
        case DP_MSG_DRAW_DABS_PIXEL:
            return DP_msg_draw_dabs_pixel_deserialize_compat(context_id, buf,
                                                             length);
        case DP_MSG_DRAW_DABS_PIXEL_SQUARE:
            return DP_msg_draw_dabs_pixel_square_deserialize_compat(
                context_id, buf, length);
        case DP_MSG_DRAW_DABS_MYPAINT:
            return DP_msg_draw_dabs_mypaint_deserialize_compat(context_id, buf,
                                                               length);
        case DP_MSG_DRAW_DABS_MYPAINT_BLEND:
            DP_error_set("Can't deserialize incompatible message type 152 "
                         "DP_MSG_DRAW_DABS_MYPAINT_BLEND");
            return NULL;
        case DP_MSG_MOVE_RECT:
            return DP_msg_move_rect_deserialize_compat(context_id, buf, length);
        case DP_MSG_SET_METADATA_INT:
            return DP_msg_set_metadata_int_deserialize_compat(context_id, buf,
                                                              length);
        case DP_MSG_LAYER_TREE_CREATE:
            return DP_msg_layer_tree_create_deserialize_compat(context_id, buf,
                                                               length);
        case DP_MSG_LAYER_TREE_MOVE:
            return DP_msg_layer_tree_move_deserialize_compat(context_id, buf,
                                                             length);
        case DP_MSG_LAYER_TREE_DELETE:
            return DP_msg_layer_tree_delete_deserialize_compat(context_id, buf,
                                                               length);
        case DP_MSG_TRANSFORM_REGION:
            return DP_msg_transform_region_deserialize_compat(context_id, buf,
                                                              length);
        case DP_MSG_TRACK_CREATE:
            return DP_msg_track_create_deserialize_compat(context_id, buf,
                                                          length);
        case DP_MSG_TRACK_RETITLE:
            return DP_msg_track_retitle_deserialize_compat(context_id, buf,
                                                           length);
        case DP_MSG_TRACK_DELETE:
            return DP_msg_track_delete_deserialize_compat(context_id, buf,
                                                          length);
        case DP_MSG_TRACK_ORDER:
            return DP_msg_track_order_deserialize_compat(context_id, buf,
                                                         length);
        case DP_MSG_KEY_FRAME_SET:
            return DP_msg_key_frame_set_deserialize_compat(context_id, buf,
                                                           length);
        case DP_MSG_KEY_FRAME_RETITLE:
            return DP_msg_key_frame_retitle_deserialize_compat(context_id, buf,
                                                               length);
        case DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES:
            return DP_msg_key_frame_layer_attributes_deserialize_compat(
                context_id, buf, length);
        case DP_MSG_KEY_FRAME_DELETE:
            return DP_msg_key_frame_delete_deserialize_compat(context_id, buf,
                                                              length);
        case DP_MSG_SELECTION_PUT:
            DP_error_set("Can't deserialize incompatible message type 174 "
                         "DP_MSG_SELECTION_PUT");
            return NULL;
        case DP_MSG_SELECTION_CLEAR:
            DP_error_set("Can't deserialize incompatible message type 175 "
                         "DP_MSG_SELECTION_CLEAR");
            return NULL;
        case DP_MSG_LOCAL_MATCH:
            return DP_msg_local_match_deserialize_compat(context_id, buf,
                                                         length);
        case DP_MSG_SYNC_SELECTION_TILE:
            DP_error_set("Can't deserialize incompatible message type 177 "
                         "DP_MSG_SYNC_SELECTION_TILE");
            return NULL;
        case DP_MSG_PUT_IMAGE_ZSTD:
            DP_error_set("Can't deserialize incompatible message type 178 "
                         "DP_MSG_PUT_IMAGE_ZSTD");
            return NULL;
        case DP_MSG_PUT_TILE_ZSTD:
            DP_error_set("Can't deserialize incompatible message type 179 "
                         "DP_MSG_PUT_TILE_ZSTD");
            return NULL;
        case DP_MSG_CANVAS_BACKGROUND_ZSTD:
            DP_error_set("Can't deserialize incompatible message type 180 "
                         "DP_MSG_CANVAS_BACKGROUND_ZSTD");
            return NULL;
        case DP_MSG_MOVE_RECT_ZSTD:
            DP_error_set("Can't deserialize incompatible message type 181 "
                         "DP_MSG_MOVE_RECT_ZSTD");
            return NULL;
        case DP_MSG_TRANSFORM_REGION_ZSTD:
            DP_error_set("Can't deserialize incompatible message type 182 "
                         "DP_MSG_TRANSFORM_REGION_ZSTD");
            return NULL;
        case DP_MSG_UNDO:
            return DP_msg_undo_deserialize_compat(context_id, buf, length);
        default:
            DP_error_set("Can't deserialize unknown message type %d", type);
            return NULL;
        }
    }
    else {
        return DP_message_new_opaque((DP_MessageType)type, context_id, buf,
                                     length);
    }
}

DP_Message *DP_message_parse_body(DP_MessageType type, unsigned int context_id,
                                  DP_TextReader *reader)
{
    switch (type) {
    case DP_MSG_SERVER_COMMAND:
        return DP_msg_server_command_parse(context_id, reader);
    case DP_MSG_DISCONNECT:
        return DP_msg_disconnect_parse(context_id, reader);
    case DP_MSG_PING:
        return DP_msg_ping_parse(context_id, reader);
    case DP_MSG_KEEP_ALIVE:
        return DP_msg_keep_alive_parse(context_id, reader);
    case DP_MSG_THUMBNAIL:
        return DP_msg_thumbnail_parse(context_id, reader);
    case DP_MSG_INTERNAL:
        DP_error_set("Can't parse reserved message type 31 DP_MSG_INTERNAL");
        return NULL;
    case DP_MSG_JOIN:
        return DP_msg_join_parse(context_id, reader);
    case DP_MSG_LEAVE:
        return DP_msg_leave_parse(context_id, reader);
    case DP_MSG_SESSION_OWNER:
        return DP_msg_session_owner_parse(context_id, reader);
    case DP_MSG_CHAT:
        return DP_msg_chat_parse(context_id, reader);
    case DP_MSG_TRUSTED_USERS:
        return DP_msg_trusted_users_parse(context_id, reader);
    case DP_MSG_SOFT_RESET:
        return DP_msg_soft_reset_parse(context_id, reader);
    case DP_MSG_PRIVATE_CHAT:
        return DP_msg_private_chat_parse(context_id, reader);
    case DP_MSG_RESET_STREAM:
        return DP_msg_reset_stream_parse(context_id, reader);
    case DP_MSG_INTERVAL:
        return DP_msg_interval_parse(context_id, reader);
    case DP_MSG_LASER_TRAIL:
        return DP_msg_laser_trail_parse(context_id, reader);
    case DP_MSG_MOVE_POINTER:
        return DP_msg_move_pointer_parse(context_id, reader);
    case DP_MSG_REMOVED_MARKER:
        DP_error_set(
            "Can't parse reserved message type 67 DP_MSG_REMOVED_MARKER");
        return NULL;
    case DP_MSG_USER_ACL:
        return DP_msg_user_acl_parse(context_id, reader);
    case DP_MSG_LAYER_ACL:
        return DP_msg_layer_acl_parse(context_id, reader);
    case DP_MSG_FEATURE_ACCESS_LEVELS:
        return DP_msg_feature_access_levels_parse(context_id, reader);
    case DP_MSG_DEFAULT_LAYER:
        return DP_msg_default_layer_parse(context_id, reader);
    case DP_MSG_REMOVED_FILTERED:
        DP_error_set(
            "Can't parse reserved message type 72 DP_MSG_REMOVED_FILTERED");
        return NULL;
    case DP_MSG_EXTENSION:
        DP_error_set("Can't parse reserved message type 73 DP_MSG_EXTENSION");
        return NULL;
    case DP_MSG_UNDO_DEPTH:
        return DP_msg_undo_depth_parse(context_id, reader);
    case DP_MSG_DATA:
        return DP_msg_data_parse(context_id, reader);
    case DP_MSG_LOCAL_CHANGE:
        return DP_msg_local_change_parse(context_id, reader);
    case DP_MSG_FEATURE_LIMITS:
        return DP_msg_feature_limits_parse(context_id, reader);
    case DP_MSG_UNDO_POINT:
        return DP_msg_undo_point_parse(context_id, reader);
    case DP_MSG_CANVAS_RESIZE:
        return DP_msg_canvas_resize_parse(context_id, reader);
    case DP_MSG_REMOVED_LAYER_CREATE:
        DP_error_set("Can't parse reserved message type 130 "
                     "DP_MSG_REMOVED_LAYER_CREATE");
        return NULL;
    case DP_MSG_LAYER_ATTRIBUTES:
        return DP_msg_layer_attributes_parse(context_id, reader);
    case DP_MSG_LAYER_RETITLE:
        return DP_msg_layer_retitle_parse(context_id, reader);
    case DP_MSG_REMOVED_LAYER_ORDER:
        DP_error_set(
            "Can't parse reserved message type 133 DP_MSG_REMOVED_LAYER_ORDER");
        return NULL;
    case DP_MSG_REMOVED_LAYER_DELETE:
        DP_error_set("Can't parse reserved message type 134 "
                     "DP_MSG_REMOVED_LAYER_DELETE");
        return NULL;
    case DP_MSG_REMOVED_LAYER_VISIBILITY:
        DP_error_set("Can't parse reserved message type 135 "
                     "DP_MSG_REMOVED_LAYER_VISIBILITY");
        return NULL;
    case DP_MSG_PUT_IMAGE:
        return DP_msg_put_image_parse(context_id, reader);
    case DP_MSG_FILL_RECT:
        return DP_msg_fill_rect_parse(context_id, reader);
    case DP_MSG_REMOVED_TOOL_CHANGE:
        DP_error_set(
            "Can't parse reserved message type 138 DP_MSG_REMOVED_TOOL_CHANGE");
        return NULL;
    case DP_MSG_REMOVED_PEN_MOVE:
        DP_error_set(
            "Can't parse reserved message type 139 DP_MSG_REMOVED_PEN_MOVE");
        return NULL;
    case DP_MSG_PEN_UP:
        return DP_msg_pen_up_parse(context_id, reader);
    case DP_MSG_ANNOTATION_CREATE:
        return DP_msg_annotation_create_parse(context_id, reader);
    case DP_MSG_ANNOTATION_RESHAPE:
        return DP_msg_annotation_reshape_parse(context_id, reader);
    case DP_MSG_ANNOTATION_EDIT:
        return DP_msg_annotation_edit_parse(context_id, reader);
    case DP_MSG_ANNOTATION_DELETE:
        return DP_msg_annotation_delete_parse(context_id, reader);
    case DP_MSG_REMOVED_MOVE_REGION:
        DP_error_set(
            "Can't parse reserved message type 145 DP_MSG_REMOVED_MOVE_REGION");
        return NULL;
    case DP_MSG_PUT_TILE:
        return DP_msg_put_tile_parse(context_id, reader);
    case DP_MSG_CANVAS_BACKGROUND:
        return DP_msg_canvas_background_parse(context_id, reader);
    case DP_MSG_DRAW_DABS_CLASSIC:
        return DP_msg_draw_dabs_classic_parse(context_id, reader);
    case DP_MSG_DRAW_DABS_PIXEL:
        return DP_msg_draw_dabs_pixel_parse(context_id, reader);
    case DP_MSG_DRAW_DABS_PIXEL_SQUARE:
        return DP_msg_draw_dabs_pixel_square_parse(context_id, reader);
    case DP_MSG_DRAW_DABS_MYPAINT:
        return DP_msg_draw_dabs_mypaint_parse(context_id, reader);
    case DP_MSG_DRAW_DABS_MYPAINT_BLEND:
        return DP_msg_draw_dabs_mypaint_blend_parse(context_id, reader);
    case DP_MSG_MOVE_RECT:
        return DP_msg_move_rect_parse(context_id, reader);
    case DP_MSG_SET_METADATA_INT:
        return DP_msg_set_metadata_int_parse(context_id, reader);
    case DP_MSG_LAYER_TREE_CREATE:
        return DP_msg_layer_tree_create_parse(context_id, reader);
    case DP_MSG_LAYER_TREE_MOVE:
        return DP_msg_layer_tree_move_parse(context_id, reader);
    case DP_MSG_LAYER_TREE_DELETE:
        return DP_msg_layer_tree_delete_parse(context_id, reader);
    case DP_MSG_TRANSFORM_REGION:
        return DP_msg_transform_region_parse(context_id, reader);
    case DP_MSG_TRACK_CREATE:
        return DP_msg_track_create_parse(context_id, reader);
    case DP_MSG_TRACK_RETITLE:
        return DP_msg_track_retitle_parse(context_id, reader);
    case DP_MSG_TRACK_DELETE:
        return DP_msg_track_delete_parse(context_id, reader);
    case DP_MSG_TRACK_ORDER:
        return DP_msg_track_order_parse(context_id, reader);
    case DP_MSG_KEY_FRAME_SET:
        return DP_msg_key_frame_set_parse(context_id, reader);
    case DP_MSG_KEY_FRAME_RETITLE:
        return DP_msg_key_frame_retitle_parse(context_id, reader);
    case DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES:
        return DP_msg_key_frame_layer_attributes_parse(context_id, reader);
    case DP_MSG_KEY_FRAME_DELETE:
        return DP_msg_key_frame_delete_parse(context_id, reader);
    case DP_MSG_SELECTION_PUT:
        return DP_msg_selection_put_parse(context_id, reader);
    case DP_MSG_SELECTION_CLEAR:
        return DP_msg_selection_clear_parse(context_id, reader);
    case DP_MSG_LOCAL_MATCH:
        return DP_msg_local_match_parse(context_id, reader);
    case DP_MSG_SYNC_SELECTION_TILE:
        return DP_msg_sync_selection_tile_parse(context_id, reader);
    case DP_MSG_PUT_IMAGE_ZSTD:
        return DP_msg_put_image_zstd_parse(context_id, reader);
    case DP_MSG_PUT_TILE_ZSTD:
        return DP_msg_put_tile_zstd_parse(context_id, reader);
    case DP_MSG_CANVAS_BACKGROUND_ZSTD:
        return DP_msg_canvas_background_zstd_parse(context_id, reader);
    case DP_MSG_MOVE_RECT_ZSTD:
        return DP_msg_move_rect_zstd_parse(context_id, reader);
    case DP_MSG_TRANSFORM_REGION_ZSTD:
        return DP_msg_transform_region_zstd_parse(context_id, reader);
    case DP_MSG_UNDO:
        return DP_msg_undo_parse(context_id, reader);
    default:
        DP_error_set("Can't parse unknown message type %d", type);
        return NULL;
    }
}


static size_t zero_length_payload_length(DP_UNUSED DP_Message *msg)
{
    return 0;
}

static size_t zero_length_serialize_payload(DP_UNUSED DP_Message *msg,
                                            DP_UNUSED unsigned char *data)
{
    return 0;
}

static bool zero_length_write_payload_text(DP_UNUSED DP_Message *msg,
                                           DP_UNUSED DP_TextWriter *writer)
{
    return true;
}

static bool zero_length_equals(DP_UNUSED DP_Message *DP_RESTRICT msg,
                               DP_UNUSED DP_Message *DP_RESTRICT other)
{
    return true;
}

static const DP_MessageMethods zero_length_methods = {
    zero_length_payload_length,     zero_length_serialize_payload,
    zero_length_payload_length,     zero_length_serialize_payload,
    zero_length_write_payload_text, zero_length_equals,
};


static void assign_string(char *dst, const char *src, size_t len)
{
    memcpy(dst, src, len);
    dst[len] = '\0';
}

static int8_t read_int8(const unsigned char *buffer, size_t *read)
{
    *read += 1;
    return DP_read_bigendian_int8(buffer);
}

static int32_t read_int32(const unsigned char *buffer, size_t *read)
{
    *read += 4;
    return DP_read_bigendian_int32(buffer);
}

static uint8_t read_uint8(const unsigned char *buffer, size_t *read)
{
    *read += 1;
    return DP_read_bigendian_uint8(buffer);
}

static uint16_t read_uint16(const unsigned char *buffer, size_t *read)
{
    *read += 2;
    return DP_read_bigendian_uint16(buffer);
}

static uint32_t read_uint24(const unsigned char *buffer, size_t *read)
{
    *read += 3;
    return DP_read_bigendian_uint24(buffer);
}

static uint32_t read_uint32(const unsigned char *buffer, size_t *read)
{
    *read += 4;
    return DP_read_bigendian_uint32(buffer);
}

static bool read_bool(const unsigned char *buffer, size_t *read)
{
    return read_uint8(buffer, read) != 0;
}

static const char *read_string_with_length(const unsigned char *buffer,
                                           size_t len, size_t *read)
{
    *read += len;
    return (const char *)buffer;
}

static void read_bytes(size_t count, unsigned char *out, void *user)
{
    const unsigned char *buffer = user;
    memcpy(out, buffer, count);
}

static void read_uint8_array(int count, uint8_t *out, void *user)
{
    const unsigned char *buffer = user;
    memcpy(out, buffer, DP_int_to_size(count));
}

static void read_uint16_array(int count, uint16_t *out, void *user)
{
    const unsigned char *buffer = user;
#if defined(DP_BYTE_ORDER_LITTLE_ENDIAN)
    for (int i = 0; i < count; ++i) {
        out[i] = DP_read_bigendian_uint16(buffer + i * 2);
    }
#elif defined(DP_BYTE_ORDER_BIG_ENDIAN)
    memcpy(out, buffer, DP_int_to_size(count) * 2);
#else
#    error "Unknown byte order"
#endif
}

static void read_uint32_array(int count, uint32_t *out, void *user)
{
    const unsigned char *buffer = user;
#if defined(DP_BYTE_ORDER_LITTLE_ENDIAN)
    for (int i = 0; i < count; ++i) {
        out[i] = DP_read_bigendian_uint32(buffer + i * 4);
    }
#elif defined(DP_BYTE_ORDER_BIG_ENDIAN)
    memcpy(out, buffer, DP_int_to_size(count) * 4);
#else
#    error "Unknown byte order"
#endif
}

static void read_int32_array(int count, int32_t *out, void *user)
{
    const unsigned char *buffer = user;
#if defined(DP_BYTE_ORDER_LITTLE_ENDIAN)
    for (int i = 0; i < count; ++i) {
        out[i] = DP_read_bigendian_int32(buffer + i * 4);
    }
#elif defined(DP_BYTE_ORDER_BIG_ENDIAN)
    memcpy(out, buffer, DP_int_to_size(count) * 4);
#else
#    error "Unknown byte order"
#endif
}

static size_t write_bytes(const unsigned char *DP_RESTRICT x, int count,
                          unsigned char *DP_RESTRICT out)
{
    return DP_write_bytes(x, count, 1, out);
}

static size_t write_string_with_length(const char *DP_RESTRICT x, size_t len,
                                       unsigned char *DP_RESTRICT out)
{
    size_t written = DP_write_bigendian_uint8(DP_size_to_uint8(len), out);
    return written + DP_write_bytes(x, 1, len, out + written);
}

static const unsigned char *local_match_data(DP_Message *msg, size_t *out_size)
{
    switch (DP_message_type(msg)) {
    case DP_MSG_LOCAL_MATCH:
        return DP_msg_local_match_data(DP_message_internal(msg), out_size);
    case DP_MSG_PUT_IMAGE:
        return DP_msg_put_image_image(DP_message_internal(msg), out_size);
    default:
        DP_UNREACHABLE();
    }
}

static uint16_t serialize_layer_id_compat(uint32_t layer_id)
{
    return DP_uint32_to_uint16(
        ((layer_id & (uint32_t)0xff00u) >> (uint32_t)8u)
        | ((layer_id & (uint32_t)0xffu) << (uint32_t)8u));
}

static uint32_t deserialize_layer_id_compat(uint16_t layer_id)
{
    uint32_t u = DP_uint16_to_uint32(layer_id);
    return ((u & (uint32_t)0xffu) << (uint32_t)8u)
         | ((u & (uint32_t)0xff00u) >> (uint32_t)8u);
}

static uint16_t convert_other_id_compat(unsigned int id)
{
    return DP_uint_to_uint16(((id & 0xffu) << 8u) | ((id & 0xff00u) >> 8u));
}

static uint8_t get_draw_dabs_flags_compat(uint32_t color)
{
    if (color & (uint32_t)0xff000000u) {
        return (uint8_t)DP_PAINT_MODE_INDIRECT_SOFT;
    }
    else {
        return (uint8_t)DP_PAINT_MODE_DIRECT;
    }
}

static void read_track_ids_compat(int count, uint16_t *out, void *user)
{
    const unsigned char *buffer = user;
    for (int i = 0; i < count; ++i) {
        out[i] =
            convert_other_id_compat(DP_read_bigendian_uint16(buffer + i * 2));
    }
}

static size_t write_track_ids_compat(const uint16_t *DP_RESTRICT track_ids,
                                     int count, unsigned char *DP_RESTRICT out)
{
    if (count > 0) {
        size_t written = 0;
        for (int i = 0; i < count; ++i) {
            written += DP_write_bigendian_uint16(
                convert_other_id_compat(track_ids[i]), out + written);
        }
        return written;
    }
    else {
        return 0;
    }
}

static void read_key_frame_layer_flags_compat(int count, uint32_t *out,
                                              void *user)
{
    const unsigned char *buffer = user;
    for (int i = 0; i < count; ++i) {
        uint16_t layer_id = DP_read_bigendian_uint16(buffer + i * 4);
        uint16_t flags = DP_read_bigendian_uint16(buffer + i * 4 + 2);
        out[i] =
            deserialize_layer_id_compat(layer_id)
            | ((DP_uint16_to_uint32(flags) & (uint32_t)0xffu) << (uint32_t)24u);
    }
}

static size_t
write_key_frame_layer_flags_compat(const uint32_t *DP_RESTRICT id_flag_pairs,
                                   int count, unsigned char *DP_RESTRICT out)
{
    if (count > 0) {
        size_t written = 0;
        for (int i = 0; i < count; ++i) {
            written += DP_write_bigendian_uint16(
                serialize_layer_id_compat(id_flag_pairs[i]
                                          & (uint32_t)0xffffffu),
                out + written);
            written += DP_write_bigendian_uint16(
                DP_uint32_to_uint16((id_flag_pairs[i] & (uint32_t)0xff000000u)
                                    >> (uint32_t)24u),
                out + written);
        }
        return written;
    }
    else {
        return 0;
    }
}


/* DP_MSG_SERVER_COMMAND */

struct DP_MsgServerCommand {
    uint16_t msg_len;
    char msg[];
};

static size_t msg_server_command_payload_length(DP_Message *msg)
{
    DP_MsgServerCommand *msc = DP_message_internal(msg);
    return DP_uint16_to_size(msc->msg_len);
}

static size_t msg_server_command_serialize_payload(DP_Message *msg,
                                                   unsigned char *data)
{
    DP_MsgServerCommand *msc = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bytes(msc->msg, 1, msc->msg_len, data + written);
    DP_ASSERT(written == msg_server_command_payload_length(msg));
    return written;
}

static bool msg_server_command_write_payload_text(DP_Message *msg,
                                                  DP_TextWriter *writer)
{
    DP_MsgServerCommand *msc = DP_message_internal(msg);
    return DP_text_writer_write_string(writer, "msg", msc->msg);
}

static bool msg_server_command_equals(DP_Message *DP_RESTRICT msg,
                                      DP_Message *DP_RESTRICT other)
{
    DP_MsgServerCommand *a = DP_message_internal(msg);
    DP_MsgServerCommand *b = DP_message_internal(other);
    return a->msg_len == b->msg_len && memcmp(a->msg, b->msg, a->msg_len) == 0;
}

static const DP_MessageMethods msg_server_command_methods = {
    msg_server_command_payload_length,     msg_server_command_serialize_payload,
    msg_server_command_payload_length,     msg_server_command_serialize_payload,
    msg_server_command_write_payload_text, msg_server_command_equals,
};

DP_Message *DP_msg_server_command_new(unsigned int context_id,
                                      const char *msg_value, size_t msg_len)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_SERVER_COMMAND, context_id, &msg_server_command_methods,
        DP_FLEX_SIZEOF(DP_MsgServerCommand, msg, msg_len + 1));
    DP_MsgServerCommand *msc = DP_message_internal(msg);
    msc->msg_len = DP_size_to_uint16(msg_len);
    assign_string(msc->msg, msg_value, msc->msg_len);
    return msg;
}

DP_Message *DP_msg_server_command_deserialize(unsigned int context_id,
                                              const unsigned char *buffer,
                                              size_t length)
{
    if (length > 65535) {
        DP_error_set("Wrong length for servercommand message; "
                     "expected between 0 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    size_t msg_bytes = length - read;
    uint16_t msg_len = DP_size_to_uint16(msg_bytes);
    const char *msg = (const char *)buffer + read;
    return DP_msg_server_command_new(context_id, msg, msg_len);
}

DP_Message *DP_msg_server_command_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    DP_Message *msg =
        DP_msg_server_command_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_server_command_parse(unsigned int context_id,
                                        DP_TextReader *reader)
{
    uint16_t msg_len;
    const char *msg = DP_text_reader_get_string(reader, "msg", &msg_len);
    return DP_msg_server_command_new(context_id, msg, msg_len);
}

DP_MsgServerCommand *DP_msg_server_command_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_SERVER_COMMAND);
}

const char *DP_msg_server_command_msg(const DP_MsgServerCommand *msc,
                                      size_t *out_len)
{
    DP_ASSERT(msc);
    if (out_len) {
        *out_len = msc->msg_len;
    }
    return msc->msg;
}

size_t DP_msg_server_command_msg_len(const DP_MsgServerCommand *msc)
{
    return msc->msg_len;
}


/* DP_MSG_DISCONNECT */

const char *DP_msg_disconnect_reason_variant_name(unsigned int value)
{
    switch (value) {
    case DP_MSG_DISCONNECT_REASON_ERROR:
        return "Error";
    case DP_MSG_DISCONNECT_REASON_KICK:
        return "Kick";
    case DP_MSG_DISCONNECT_REASON_SHUTDOWN:
        return "Shutdown";
    case DP_MSG_DISCONNECT_REASON_OTHER:
        return "Other";
    default:
        return NULL;
    }
}

struct DP_MsgDisconnect {
    uint8_t reason;
    uint16_t message_len;
    char message[];
};

static size_t msg_disconnect_payload_length(DP_Message *msg)
{
    DP_MsgDisconnect *md = DP_message_internal(msg);
    return ((size_t)1) + DP_uint16_to_size(md->message_len);
}

static size_t msg_disconnect_serialize_payload(DP_Message *msg,
                                               unsigned char *data)
{
    DP_MsgDisconnect *md = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(md->reason, data + written);
    written += DP_write_bytes(md->message, 1, md->message_len, data + written);
    DP_ASSERT(written == msg_disconnect_payload_length(msg));
    return written;
}

static bool msg_disconnect_write_payload_text(DP_Message *msg,
                                              DP_TextWriter *writer)
{
    DP_MsgDisconnect *md = DP_message_internal(msg);
    return DP_text_writer_write_string(writer, "message", md->message)
        && DP_text_writer_write_uint(writer, "reason", md->reason);
}

static bool msg_disconnect_equals(DP_Message *DP_RESTRICT msg,
                                  DP_Message *DP_RESTRICT other)
{
    DP_MsgDisconnect *a = DP_message_internal(msg);
    DP_MsgDisconnect *b = DP_message_internal(other);
    return a->reason == b->reason && a->message_len == b->message_len
        && memcmp(a->message, b->message, a->message_len) == 0;
}

static const DP_MessageMethods msg_disconnect_methods = {
    msg_disconnect_payload_length,     msg_disconnect_serialize_payload,
    msg_disconnect_payload_length,     msg_disconnect_serialize_payload,
    msg_disconnect_write_payload_text, msg_disconnect_equals,
};

DP_Message *DP_msg_disconnect_new(unsigned int context_id, uint8_t reason,
                                  const char *message_value, size_t message_len)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_DISCONNECT, context_id, &msg_disconnect_methods,
        DP_FLEX_SIZEOF(DP_MsgDisconnect, message, message_len + 1));
    DP_MsgDisconnect *md = DP_message_internal(msg);
    md->reason = reason;
    md->message_len = DP_size_to_uint16(message_len);
    assign_string(md->message, message_value, md->message_len);
    return msg;
}

DP_Message *DP_msg_disconnect_deserialize(unsigned int context_id,
                                          const unsigned char *buffer,
                                          size_t length)
{
    if (length < 1 || length > 65535) {
        DP_error_set("Wrong length for disconnect message; "
                     "expected between 1 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t reason = read_uint8(buffer + read, &read);
    size_t message_bytes = length - read;
    uint16_t message_len = DP_size_to_uint16(message_bytes);
    const char *message = (const char *)buffer + read;
    return DP_msg_disconnect_new(context_id, reason, message, message_len);
}

DP_Message *DP_msg_disconnect_deserialize_compat(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length)
{
    DP_Message *msg = DP_msg_disconnect_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_disconnect_parse(unsigned int context_id,
                                    DP_TextReader *reader)
{
    uint8_t reason =
        (uint8_t)DP_text_reader_get_ulong(reader, "reason", UINT8_MAX);
    uint16_t message_len;
    const char *message =
        DP_text_reader_get_string(reader, "message", &message_len);
    return DP_msg_disconnect_new(context_id, reason, message, message_len);
}

DP_MsgDisconnect *DP_msg_disconnect_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_DISCONNECT);
}

uint8_t DP_msg_disconnect_reason(const DP_MsgDisconnect *md)
{
    DP_ASSERT(md);
    return md->reason;
}

const char *DP_msg_disconnect_message(const DP_MsgDisconnect *md,
                                      size_t *out_len)
{
    DP_ASSERT(md);
    if (out_len) {
        *out_len = md->message_len;
    }
    return md->message;
}

size_t DP_msg_disconnect_message_len(const DP_MsgDisconnect *md)
{
    return md->message_len;
}


/* DP_MSG_PING */

struct DP_MsgPing {
    bool is_pong;
};

static size_t msg_ping_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)1);
}

static size_t msg_ping_serialize_payload(DP_Message *msg, unsigned char *data)
{
    DP_MsgPing *mp = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(mp->is_pong, data + written);
    DP_ASSERT(written == msg_ping_payload_length(msg));
    return written;
}

static bool msg_ping_write_payload_text(DP_Message *msg, DP_TextWriter *writer)
{
    DP_MsgPing *mp = DP_message_internal(msg);
    return DP_text_writer_write_bool(writer, "is_pong", mp->is_pong);
}

static bool msg_ping_equals(DP_Message *DP_RESTRICT msg,
                            DP_Message *DP_RESTRICT other)
{
    DP_MsgPing *a = DP_message_internal(msg);
    DP_MsgPing *b = DP_message_internal(other);
    return a->is_pong == b->is_pong;
}

static const DP_MessageMethods msg_ping_methods = {
    msg_ping_payload_length,     msg_ping_serialize_payload,
    msg_ping_payload_length,     msg_ping_serialize_payload,
    msg_ping_write_payload_text, msg_ping_equals,
};

DP_Message *DP_msg_ping_new(unsigned int context_id, bool is_pong)
{
    DP_Message *msg = DP_message_new(DP_MSG_PING, context_id, &msg_ping_methods,
                                     sizeof(DP_MsgPing));
    DP_MsgPing *mp = DP_message_internal(msg);
    mp->is_pong = is_pong;
    return msg;
}

DP_Message *DP_msg_ping_deserialize(unsigned int context_id,
                                    const unsigned char *buffer, size_t length)
{
    if (length != 1) {
        DP_error_set("Wrong length for ping message; "
                     "expected 1, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    bool is_pong = read_bool(buffer + read, &read);
    return DP_msg_ping_new(context_id, is_pong);
}

DP_Message *DP_msg_ping_deserialize_compat(unsigned int context_id,
                                           const unsigned char *buffer,
                                           size_t length)
{
    DP_Message *msg = DP_msg_ping_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_ping_parse(unsigned int context_id, DP_TextReader *reader)
{
    bool is_pong = DP_text_reader_get_bool(reader, "is_pong");
    return DP_msg_ping_new(context_id, is_pong);
}

DP_MsgPing *DP_msg_ping_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_PING);
}

bool DP_msg_ping_is_pong(const DP_MsgPing *mp)
{
    DP_ASSERT(mp);
    return mp->is_pong;
}


/* DP_MSG_KEEP_ALIVE */

DP_Message *DP_msg_keep_alive_new(unsigned int context_id)
{
    return DP_message_new(DP_MSG_KEEP_ALIVE, context_id, &zero_length_methods,
                          0);
}

DP_Message *DP_msg_keep_alive_deserialize(unsigned int context_id,
                                          DP_UNUSED const unsigned char *buffer,
                                          size_t length)
{
    if (length != 0) {
        DP_error_set("Wrong length for keepalive message; "
                     "expected 0, got %zu",
                     length);
        return NULL;
    }
    return DP_msg_keep_alive_new(context_id);
}

DP_Message *DP_msg_keep_alive_deserialize_compat(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length)
{
    DP_Message *msg = DP_msg_keep_alive_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_keep_alive_parse(unsigned int context_id,
                                    DP_UNUSED DP_TextReader *reader)
{
    return DP_msg_keep_alive_new(context_id);
}


/* DP_MSG_THUMBNAIL */

struct DP_MsgThumbnail {
    uint16_t data_size;
    unsigned char data[];
};

static size_t msg_thumbnail_payload_length(DP_Message *msg)
{
    DP_MsgThumbnail *mt = DP_message_internal(msg);
    return mt->data_size;
}

static size_t msg_thumbnail_serialize_payload(DP_Message *msg,
                                              unsigned char *data)
{
    DP_MsgThumbnail *mt = DP_message_internal(msg);
    size_t written = 0;
    written += write_bytes(mt->data, mt->data_size, data + written);
    DP_ASSERT(written == msg_thumbnail_payload_length(msg));
    return written;
}

static bool msg_thumbnail_write_payload_text(DP_Message *msg,
                                             DP_TextWriter *writer)
{
    DP_MsgThumbnail *mt = DP_message_internal(msg);
    return DP_text_writer_write_base64(writer, "data", mt->data, mt->data_size);
}

static bool msg_thumbnail_equals(DP_Message *DP_RESTRICT msg,
                                 DP_Message *DP_RESTRICT other)
{
    DP_MsgThumbnail *a = DP_message_internal(msg);
    DP_MsgThumbnail *b = DP_message_internal(other);
    return a->data_size == b->data_size
        && memcmp(a->data, b->data, DP_uint16_to_size(a->data_size)) == 0;
}

static const DP_MessageMethods msg_thumbnail_methods = {
    msg_thumbnail_payload_length,     msg_thumbnail_serialize_payload,
    msg_thumbnail_payload_length,     msg_thumbnail_serialize_payload,
    msg_thumbnail_write_payload_text, msg_thumbnail_equals,
};

DP_Message *DP_msg_thumbnail_new(unsigned int context_id,
                                 void (*set_data)(size_t, unsigned char *,
                                                  void *),
                                 size_t data_size, void *data_user)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_THUMBNAIL, context_id, &msg_thumbnail_methods,
                       DP_FLEX_SIZEOF(DP_MsgThumbnail, data, data_size));
    DP_MsgThumbnail *mt = DP_message_internal(msg);
    mt->data_size = DP_size_to_uint16(data_size);
    if (set_data) {
        set_data(mt->data_size, mt->data, data_user);
    }
    return msg;
}

DP_Message *DP_msg_thumbnail_deserialize(unsigned int context_id,
                                         const unsigned char *buffer,
                                         size_t length)
{
    if (length > 65535) {
        DP_error_set("Wrong length for thumbnail message; "
                     "expected between 0 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    size_t data_bytes = length - read;
    uint16_t data_size = DP_size_to_uint16(data_bytes);
    void *data_user = (void *)(buffer + read);
    return DP_msg_thumbnail_new(context_id, read_bytes, data_size, data_user);
}

DP_Message *DP_msg_thumbnail_deserialize_compat(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length)
{
    DP_Message *msg = DP_msg_thumbnail_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_thumbnail_parse(unsigned int context_id,
                                   DP_TextReader *reader)
{
    size_t data_size;
    DP_TextReaderParseParams data_params =
        DP_text_reader_get_base64_string(reader, "data", &data_size);
    return DP_msg_thumbnail_new(context_id, DP_text_reader_parse_base64,
                                data_size, &data_params);
}

DP_MsgThumbnail *DP_msg_thumbnail_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_THUMBNAIL);
}

const unsigned char *DP_msg_thumbnail_data(const DP_MsgThumbnail *mt,
                                           size_t *out_size)
{
    DP_ASSERT(mt);
    if (out_size) {
        *out_size = mt->data_size;
    }
    return mt->data;
}

size_t DP_msg_thumbnail_data_size(const DP_MsgThumbnail *mt)
{
    return mt->data_size;
}


/* DP_MSG_JOIN */

const char *DP_msg_join_flags_flag_name(unsigned int value)
{
    switch (value) {
    case DP_MSG_JOIN_FLAGS_AUTH:
        return "auth";
    case DP_MSG_JOIN_FLAGS_MOD:
        return "mod";
    case DP_MSG_JOIN_FLAGS_BOT:
        return "bot";
    case DP_MSG_JOIN_FLAGS_OLD:
        return "old";
    default:
        return NULL;
    }
}

struct DP_MsgJoin {
    uint8_t flags;
    uint16_t name_len;
    uint16_t avatar_size;
    unsigned char name_avatar[];
};

static size_t msg_join_payload_length(DP_Message *msg)
{
    DP_MsgJoin *mj = DP_message_internal(msg);
    return ((size_t)2) + DP_uint16_to_size(mj->name_len) + mj->avatar_size;
}

static size_t msg_join_serialize_payload(DP_Message *msg, unsigned char *data)
{
    DP_MsgJoin *mj = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(mj->flags, data + written);
    written += write_string_with_length(((char *)mj->name_avatar), mj->name_len,
                                        data + written);
    written += write_bytes(mj->name_avatar + mj->name_len + 1, mj->avatar_size,
                           data + written);
    DP_ASSERT(written == msg_join_payload_length(msg));
    return written;
}

static bool msg_join_write_payload_text(DP_Message *msg, DP_TextWriter *writer)
{
    DP_MsgJoin *mj = DP_message_internal(msg);
    return DP_text_writer_write_base64(writer, "avatar",
                                       mj->name_avatar + mj->name_len + 1,
                                       mj->avatar_size)
        && DP_text_writer_write_flags(
               writer, "flags", mj->flags, 4,
               (const char *[]){"auth", "mod", "bot", "old"},
               (unsigned int[]){DP_MSG_JOIN_FLAGS_AUTH, DP_MSG_JOIN_FLAGS_MOD,
                                DP_MSG_JOIN_FLAGS_BOT, DP_MSG_JOIN_FLAGS_OLD})
        && DP_text_writer_write_string(writer, "name",
                                       ((char *)mj->name_avatar));
}

static bool msg_join_equals(DP_Message *DP_RESTRICT msg,
                            DP_Message *DP_RESTRICT other)
{
    DP_MsgJoin *a = DP_message_internal(msg);
    DP_MsgJoin *b = DP_message_internal(other);
    return a->flags == b->flags && a->name_len == b->name_len
        && memcmp(((char *)a->name_avatar), ((char *)b->name_avatar),
                  a->name_len)
               == 0
        && a->avatar_size == b->avatar_size
        && memcmp(a->name_avatar + a->name_len + 1,
                  b->name_avatar + b->name_len + 1,
                  DP_uint16_to_size(a->avatar_size))
               == 0;
}

static const DP_MessageMethods msg_join_methods = {
    msg_join_payload_length,     msg_join_serialize_payload,
    msg_join_payload_length,     msg_join_serialize_payload,
    msg_join_write_payload_text, msg_join_equals,
};

DP_Message *DP_msg_join_new(unsigned int context_id, uint8_t flags,
                            const char *name_value, size_t name_len,
                            void (*set_avatar)(size_t, unsigned char *, void *),
                            size_t avatar_size, void *avatar_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_JOIN, context_id, &msg_join_methods,
        DP_FLEX_SIZEOF(DP_MsgJoin, name_avatar, name_len + 1 + avatar_size));
    DP_MsgJoin *mj = DP_message_internal(msg);
    mj->flags = flags;
    mj->name_len = DP_size_to_uint16(name_len);
    assign_string(((char *)mj->name_avatar), name_value, mj->name_len);
    mj->avatar_size = DP_size_to_uint16(avatar_size);
    if (set_avatar) {
        set_avatar(mj->avatar_size, mj->name_avatar + mj->name_len + 1,
                   avatar_user);
    }
    return msg;
}

DP_Message *DP_msg_join_deserialize(unsigned int context_id,
                                    const unsigned char *buffer, size_t length)
{
    if (length < 2 || length > 65535) {
        DP_error_set("Wrong length for join message; "
                     "expected between 2 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t flags = read_uint8(buffer + read, &read);
    size_t name_bytes = read_uint8(buffer + read, &read);
    if (read + name_bytes > length) {
        DP_error_set("Wrong length for name field in join message; "
                     "field length %zu exceeds total length %zu",
                     name_bytes, length);
        return NULL;
    }
    uint16_t name_len = DP_size_to_uint16(name_bytes);
    const char *name = read_string_with_length(buffer + read, name_len, &read);
    size_t avatar_bytes = length - read;
    uint16_t avatar_size = DP_size_to_uint16(avatar_bytes);
    void *avatar_user = (void *)(buffer + read);
    return DP_msg_join_new(context_id, flags, name, name_len, read_bytes,
                           avatar_size, avatar_user);
}

DP_Message *DP_msg_join_deserialize_compat(unsigned int context_id,
                                           const unsigned char *buffer,
                                           size_t length)
{
    DP_Message *msg = DP_msg_join_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_join_parse(unsigned int context_id, DP_TextReader *reader)
{
    uint8_t flags = (uint8_t)DP_text_reader_get_flags(
        reader, "flags", 4, (const char *[]){"auth", "mod", "bot", "old"},
        (unsigned int[]){DP_MSG_JOIN_FLAGS_AUTH, DP_MSG_JOIN_FLAGS_MOD,
                         DP_MSG_JOIN_FLAGS_BOT, DP_MSG_JOIN_FLAGS_OLD});
    uint16_t name_len;
    const char *name = DP_text_reader_get_string(reader, "name", &name_len);
    size_t avatar_size;
    DP_TextReaderParseParams avatar_params =
        DP_text_reader_get_base64_string(reader, "avatar", &avatar_size);
    return DP_msg_join_new(context_id, flags, name, name_len,
                           DP_text_reader_parse_base64, avatar_size,
                           &avatar_params);
}

DP_MsgJoin *DP_msg_join_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_JOIN);
}

uint8_t DP_msg_join_flags(const DP_MsgJoin *mj)
{
    DP_ASSERT(mj);
    return mj->flags;
}

const char *DP_msg_join_name(const DP_MsgJoin *mj, size_t *out_len)
{
    DP_ASSERT(mj);
    if (out_len) {
        *out_len = mj->name_len;
    }
    return ((char *)mj->name_avatar);
}

size_t DP_msg_join_name_len(const DP_MsgJoin *mj)
{
    return mj->name_len;
}

const unsigned char *DP_msg_join_avatar(const DP_MsgJoin *mj, size_t *out_size)
{
    DP_ASSERT(mj);
    if (out_size) {
        *out_size = mj->avatar_size;
    }
    return mj->name_avatar + mj->name_len + 1;
}

size_t DP_msg_join_avatar_size(const DP_MsgJoin *mj)
{
    return mj->avatar_size;
}


/* DP_MSG_LEAVE */

DP_Message *DP_msg_leave_new(unsigned int context_id)
{
    return DP_message_new(DP_MSG_LEAVE, context_id, &zero_length_methods, 0);
}

DP_Message *DP_msg_leave_deserialize(unsigned int context_id,
                                     DP_UNUSED const unsigned char *buffer,
                                     size_t length)
{
    if (length != 0) {
        DP_error_set("Wrong length for leave message; "
                     "expected 0, got %zu",
                     length);
        return NULL;
    }
    return DP_msg_leave_new(context_id);
}

DP_Message *DP_msg_leave_deserialize_compat(unsigned int context_id,
                                            const unsigned char *buffer,
                                            size_t length)
{
    DP_Message *msg = DP_msg_leave_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_leave_parse(unsigned int context_id,
                               DP_UNUSED DP_TextReader *reader)
{
    return DP_msg_leave_new(context_id);
}


/* DP_MSG_SESSION_OWNER */

struct DP_MsgSessionOwner {
    uint16_t users_count;
    uint8_t users[];
};

static size_t msg_session_owner_payload_length(DP_Message *msg)
{
    DP_MsgSessionOwner *mso = DP_message_internal(msg);
    return DP_int_to_size(mso->users_count);
}

static size_t msg_session_owner_serialize_payload(DP_Message *msg,
                                                  unsigned char *data)
{
    DP_MsgSessionOwner *mso = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8_array(mso->users, mso->users_count,
                                              data + written);
    DP_ASSERT(written == msg_session_owner_payload_length(msg));
    return written;
}

static bool msg_session_owner_write_payload_text(DP_Message *msg,
                                                 DP_TextWriter *writer)
{
    DP_MsgSessionOwner *mso = DP_message_internal(msg);
    return DP_text_writer_write_uint8_list(writer, "users", mso->users,
                                           mso->users_count);
}

static bool msg_session_owner_equals(DP_Message *DP_RESTRICT msg,
                                     DP_Message *DP_RESTRICT other)
{
    DP_MsgSessionOwner *a = DP_message_internal(msg);
    DP_MsgSessionOwner *b = DP_message_internal(other);
    return a->users_count == b->users_count
        && memcmp(a->users, b->users, DP_uint16_to_size(a->users_count)) == 0;
}

static const DP_MessageMethods msg_session_owner_methods = {
    msg_session_owner_payload_length,     msg_session_owner_serialize_payload,
    msg_session_owner_payload_length,     msg_session_owner_serialize_payload,
    msg_session_owner_write_payload_text, msg_session_owner_equals,
};

DP_Message *DP_msg_session_owner_new(unsigned int context_id,
                                     void (*set_users)(int, uint8_t *, void *),
                                     int users_count, void *users_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_SESSION_OWNER, context_id, &msg_session_owner_methods,
        DP_FLEX_SIZEOF(DP_MsgSessionOwner, users, DP_int_to_size(users_count)));
    DP_MsgSessionOwner *mso = DP_message_internal(msg);
    mso->users_count = DP_int_to_uint16(users_count);
    if (set_users) {
        set_users(mso->users_count, mso->users, users_user);
    }
    return msg;
}

DP_Message *DP_msg_session_owner_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length)
{
    if (length > 255) {
        DP_error_set("Wrong length for sessionowner message; "
                     "expected between 0 and 255, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    size_t users_bytes = length - read;
    uint16_t users_count = DP_size_to_uint16(users_bytes);
    void *users_user = (void *)(buffer + read);
    return DP_msg_session_owner_new(context_id, read_uint8_array, users_count,
                                    users_user);
}

DP_Message *DP_msg_session_owner_deserialize_compat(unsigned int context_id,
                                                    const unsigned char *buffer,
                                                    size_t length)
{
    DP_Message *msg =
        DP_msg_session_owner_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_session_owner_parse(unsigned int context_id,
                                       DP_TextReader *reader)
{
    int users_count;
    DP_TextReaderParseParams users_params =
        DP_text_reader_get_array(reader, "users", &users_count);
    return DP_msg_session_owner_new(context_id,
                                    DP_text_reader_parse_uint8_array,
                                    users_count, &users_params);
}

DP_MsgSessionOwner *DP_msg_session_owner_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_SESSION_OWNER);
}

const uint8_t *DP_msg_session_owner_users(const DP_MsgSessionOwner *mso,
                                          int *out_count)
{
    DP_ASSERT(mso);
    if (out_count) {
        *out_count = mso->users_count;
    }
    return mso->users;
}

int DP_msg_session_owner_users_count(const DP_MsgSessionOwner *mso)
{
    return mso->users_count;
}


/* DP_MSG_CHAT */

const char *DP_msg_chat_tflags_flag_name(unsigned int value)
{
    switch (value) {
    case DP_MSG_CHAT_TFLAGS_BYPASS:
        return "bypass";
    default:
        return NULL;
    }
}

const char *DP_msg_chat_oflags_flag_name(unsigned int value)
{
    switch (value) {
    case DP_MSG_CHAT_OFLAGS_SHOUT:
        return "shout";
    case DP_MSG_CHAT_OFLAGS_ACTION:
        return "action";
    case DP_MSG_CHAT_OFLAGS_PIN:
        return "pin";
    case DP_MSG_CHAT_OFLAGS_ALERT:
        return "alert";
    case DP_MSG_CHAT_OFLAGS_ROLL:
        return "roll";
    default:
        return NULL;
    }
}

struct DP_MsgChat {
    uint8_t tflags;
    uint8_t oflags;
    uint16_t message_len;
    char message[];
};

static size_t msg_chat_payload_length(DP_Message *msg)
{
    DP_MsgChat *mc = DP_message_internal(msg);
    return ((size_t)2) + DP_uint16_to_size(mc->message_len);
}

static size_t msg_chat_serialize_payload(DP_Message *msg, unsigned char *data)
{
    DP_MsgChat *mc = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(mc->tflags, data + written);
    written += DP_write_bigendian_uint8(mc->oflags, data + written);
    written += DP_write_bytes(mc->message, 1, mc->message_len, data + written);
    DP_ASSERT(written == msg_chat_payload_length(msg));
    return written;
}

static bool msg_chat_write_payload_text(DP_Message *msg, DP_TextWriter *writer)
{
    DP_MsgChat *mc = DP_message_internal(msg);
    return DP_text_writer_write_string(writer, "message", mc->message)
        && DP_text_writer_write_flags(
               writer, "oflags", mc->oflags, 5,
               (const char *[]){"shout", "action", "pin", "alert", "roll"},
               (unsigned int[]){
                   DP_MSG_CHAT_OFLAGS_SHOUT, DP_MSG_CHAT_OFLAGS_ACTION,
                   DP_MSG_CHAT_OFLAGS_PIN, DP_MSG_CHAT_OFLAGS_ALERT,
                   DP_MSG_CHAT_OFLAGS_ROLL})
        && DP_text_writer_write_flags(
               writer, "tflags", mc->tflags, 1, (const char *[]){"bypass"},
               (unsigned int[]){DP_MSG_CHAT_TFLAGS_BYPASS});
}

static bool msg_chat_equals(DP_Message *DP_RESTRICT msg,
                            DP_Message *DP_RESTRICT other)
{
    DP_MsgChat *a = DP_message_internal(msg);
    DP_MsgChat *b = DP_message_internal(other);
    return a->tflags == b->tflags && a->oflags == b->oflags
        && a->message_len == b->message_len
        && memcmp(a->message, b->message, a->message_len) == 0;
}

static const DP_MessageMethods msg_chat_methods = {
    msg_chat_payload_length,     msg_chat_serialize_payload,
    msg_chat_payload_length,     msg_chat_serialize_payload,
    msg_chat_write_payload_text, msg_chat_equals,
};

DP_Message *DP_msg_chat_new(unsigned int context_id, uint8_t tflags,
                            uint8_t oflags, const char *message_value,
                            size_t message_len)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_CHAT, context_id, &msg_chat_methods,
                       DP_FLEX_SIZEOF(DP_MsgChat, message, message_len + 1));
    DP_MsgChat *mc = DP_message_internal(msg);
    mc->tflags = tflags;
    mc->oflags = oflags;
    mc->message_len = DP_size_to_uint16(message_len);
    assign_string(mc->message, message_value, mc->message_len);
    return msg;
}

DP_Message *DP_msg_chat_deserialize(unsigned int context_id,
                                    const unsigned char *buffer, size_t length)
{
    if (length < 2 || length > 65535) {
        DP_error_set("Wrong length for chat message; "
                     "expected between 2 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t tflags = read_uint8(buffer + read, &read);
    uint8_t oflags = read_uint8(buffer + read, &read);
    size_t message_bytes = length - read;
    uint16_t message_len = DP_size_to_uint16(message_bytes);
    const char *message = (const char *)buffer + read;
    return DP_msg_chat_new(context_id, tflags, oflags, message, message_len);
}

DP_Message *DP_msg_chat_deserialize_compat(unsigned int context_id,
                                           const unsigned char *buffer,
                                           size_t length)
{
    DP_Message *msg = DP_msg_chat_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_chat_parse(unsigned int context_id, DP_TextReader *reader)
{
    uint8_t tflags = (uint8_t)DP_text_reader_get_flags(
        reader, "tflags", 1, (const char *[]){"bypass"},
        (unsigned int[]){DP_MSG_CHAT_TFLAGS_BYPASS});
    uint8_t oflags = (uint8_t)DP_text_reader_get_flags(
        reader, "oflags", 5,
        (const char *[]){"shout", "action", "pin", "alert", "roll"},
        (unsigned int[]){DP_MSG_CHAT_OFLAGS_SHOUT, DP_MSG_CHAT_OFLAGS_ACTION,
                         DP_MSG_CHAT_OFLAGS_PIN, DP_MSG_CHAT_OFLAGS_ALERT,
                         DP_MSG_CHAT_OFLAGS_ROLL});
    uint16_t message_len;
    const char *message =
        DP_text_reader_get_string(reader, "message", &message_len);
    return DP_msg_chat_new(context_id, tflags, oflags, message, message_len);
}

DP_MsgChat *DP_msg_chat_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_CHAT);
}

uint8_t DP_msg_chat_tflags(const DP_MsgChat *mc)
{
    DP_ASSERT(mc);
    return mc->tflags;
}

uint8_t DP_msg_chat_oflags(const DP_MsgChat *mc)
{
    DP_ASSERT(mc);
    return mc->oflags;
}

const char *DP_msg_chat_message(const DP_MsgChat *mc, size_t *out_len)
{
    DP_ASSERT(mc);
    if (out_len) {
        *out_len = mc->message_len;
    }
    return mc->message;
}

size_t DP_msg_chat_message_len(const DP_MsgChat *mc)
{
    return mc->message_len;
}


/* DP_MSG_TRUSTED_USERS */

struct DP_MsgTrustedUsers {
    uint16_t users_count;
    uint8_t users[];
};

static size_t msg_trusted_users_payload_length(DP_Message *msg)
{
    DP_MsgTrustedUsers *mtu = DP_message_internal(msg);
    return DP_int_to_size(mtu->users_count);
}

static size_t msg_trusted_users_serialize_payload(DP_Message *msg,
                                                  unsigned char *data)
{
    DP_MsgTrustedUsers *mtu = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8_array(mtu->users, mtu->users_count,
                                              data + written);
    DP_ASSERT(written == msg_trusted_users_payload_length(msg));
    return written;
}

static bool msg_trusted_users_write_payload_text(DP_Message *msg,
                                                 DP_TextWriter *writer)
{
    DP_MsgTrustedUsers *mtu = DP_message_internal(msg);
    return DP_text_writer_write_uint8_list(writer, "users", mtu->users,
                                           mtu->users_count);
}

static bool msg_trusted_users_equals(DP_Message *DP_RESTRICT msg,
                                     DP_Message *DP_RESTRICT other)
{
    DP_MsgTrustedUsers *a = DP_message_internal(msg);
    DP_MsgTrustedUsers *b = DP_message_internal(other);
    return a->users_count == b->users_count
        && memcmp(a->users, b->users, DP_uint16_to_size(a->users_count)) == 0;
}

static const DP_MessageMethods msg_trusted_users_methods = {
    msg_trusted_users_payload_length,     msg_trusted_users_serialize_payload,
    msg_trusted_users_payload_length,     msg_trusted_users_serialize_payload,
    msg_trusted_users_write_payload_text, msg_trusted_users_equals,
};

DP_Message *DP_msg_trusted_users_new(unsigned int context_id,
                                     void (*set_users)(int, uint8_t *, void *),
                                     int users_count, void *users_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_TRUSTED_USERS, context_id, &msg_trusted_users_methods,
        DP_FLEX_SIZEOF(DP_MsgTrustedUsers, users, DP_int_to_size(users_count)));
    DP_MsgTrustedUsers *mtu = DP_message_internal(msg);
    mtu->users_count = DP_int_to_uint16(users_count);
    if (set_users) {
        set_users(mtu->users_count, mtu->users, users_user);
    }
    return msg;
}

DP_Message *DP_msg_trusted_users_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length)
{
    if (length > 255) {
        DP_error_set("Wrong length for trusted message; "
                     "expected between 0 and 255, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    size_t users_bytes = length - read;
    uint16_t users_count = DP_size_to_uint16(users_bytes);
    void *users_user = (void *)(buffer + read);
    return DP_msg_trusted_users_new(context_id, read_uint8_array, users_count,
                                    users_user);
}

DP_Message *DP_msg_trusted_users_deserialize_compat(unsigned int context_id,
                                                    const unsigned char *buffer,
                                                    size_t length)
{
    DP_Message *msg =
        DP_msg_trusted_users_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_trusted_users_parse(unsigned int context_id,
                                       DP_TextReader *reader)
{
    int users_count;
    DP_TextReaderParseParams users_params =
        DP_text_reader_get_array(reader, "users", &users_count);
    return DP_msg_trusted_users_new(context_id,
                                    DP_text_reader_parse_uint8_array,
                                    users_count, &users_params);
}

DP_MsgTrustedUsers *DP_msg_trusted_users_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_TRUSTED_USERS);
}

const uint8_t *DP_msg_trusted_users_users(const DP_MsgTrustedUsers *mtu,
                                          int *out_count)
{
    DP_ASSERT(mtu);
    if (out_count) {
        *out_count = mtu->users_count;
    }
    return mtu->users;
}

int DP_msg_trusted_users_users_count(const DP_MsgTrustedUsers *mtu)
{
    return mtu->users_count;
}


/* DP_MSG_SOFT_RESET */

DP_Message *DP_msg_soft_reset_new(unsigned int context_id)
{
    return DP_message_new(DP_MSG_SOFT_RESET, context_id, &zero_length_methods,
                          0);
}

DP_Message *DP_msg_soft_reset_deserialize(unsigned int context_id,
                                          DP_UNUSED const unsigned char *buffer,
                                          size_t length)
{
    if (length != 0) {
        DP_error_set("Wrong length for softreset message; "
                     "expected 0, got %zu",
                     length);
        return NULL;
    }
    return DP_msg_soft_reset_new(context_id);
}

DP_Message *DP_msg_soft_reset_deserialize_compat(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length)
{
    DP_Message *msg = DP_msg_soft_reset_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_soft_reset_parse(unsigned int context_id,
                                    DP_UNUSED DP_TextReader *reader)
{
    return DP_msg_soft_reset_new(context_id);
}


/* DP_MSG_PRIVATE_CHAT */

struct DP_MsgPrivateChat {
    uint8_t target;
    uint8_t oflags;
    uint16_t message_len;
    char message[];
};

static size_t msg_private_chat_payload_length(DP_Message *msg)
{
    DP_MsgPrivateChat *mpc = DP_message_internal(msg);
    return ((size_t)2) + DP_uint16_to_size(mpc->message_len);
}

static size_t msg_private_chat_serialize_payload(DP_Message *msg,
                                                 unsigned char *data)
{
    DP_MsgPrivateChat *mpc = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(mpc->target, data + written);
    written += DP_write_bigendian_uint8(mpc->oflags, data + written);
    written +=
        DP_write_bytes(mpc->message, 1, mpc->message_len, data + written);
    DP_ASSERT(written == msg_private_chat_payload_length(msg));
    return written;
}

static bool msg_private_chat_write_payload_text(DP_Message *msg,
                                                DP_TextWriter *writer)
{
    DP_MsgPrivateChat *mpc = DP_message_internal(msg);
    return DP_text_writer_write_string(writer, "message", mpc->message)
        && DP_text_writer_write_uint(writer, "oflags", mpc->oflags)
        && DP_text_writer_write_uint(writer, "target", mpc->target);
}

static bool msg_private_chat_equals(DP_Message *DP_RESTRICT msg,
                                    DP_Message *DP_RESTRICT other)
{
    DP_MsgPrivateChat *a = DP_message_internal(msg);
    DP_MsgPrivateChat *b = DP_message_internal(other);
    return a->target == b->target && a->oflags == b->oflags
        && a->message_len == b->message_len
        && memcmp(a->message, b->message, a->message_len) == 0;
}

static const DP_MessageMethods msg_private_chat_methods = {
    msg_private_chat_payload_length,     msg_private_chat_serialize_payload,
    msg_private_chat_payload_length,     msg_private_chat_serialize_payload,
    msg_private_chat_write_payload_text, msg_private_chat_equals,
};

DP_Message *DP_msg_private_chat_new(unsigned int context_id, uint8_t target,
                                    uint8_t oflags, const char *message_value,
                                    size_t message_len)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_PRIVATE_CHAT, context_id, &msg_private_chat_methods,
        DP_FLEX_SIZEOF(DP_MsgPrivateChat, message, message_len + 1));
    DP_MsgPrivateChat *mpc = DP_message_internal(msg);
    mpc->target = target;
    mpc->oflags = oflags;
    mpc->message_len = DP_size_to_uint16(message_len);
    assign_string(mpc->message, message_value, mpc->message_len);
    return msg;
}

DP_Message *DP_msg_private_chat_deserialize(unsigned int context_id,
                                            const unsigned char *buffer,
                                            size_t length)
{
    if (length < 2 || length > 65535) {
        DP_error_set("Wrong length for privatechat message; "
                     "expected between 2 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t target = read_uint8(buffer + read, &read);
    uint8_t oflags = read_uint8(buffer + read, &read);
    size_t message_bytes = length - read;
    uint16_t message_len = DP_size_to_uint16(message_bytes);
    const char *message = (const char *)buffer + read;
    return DP_msg_private_chat_new(context_id, target, oflags, message,
                                   message_len);
}

DP_Message *DP_msg_private_chat_deserialize_compat(unsigned int context_id,
                                                   const unsigned char *buffer,
                                                   size_t length)
{
    DP_Message *msg =
        DP_msg_private_chat_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_private_chat_parse(unsigned int context_id,
                                      DP_TextReader *reader)
{
    uint8_t target =
        (uint8_t)DP_text_reader_get_ulong(reader, "target", UINT8_MAX);
    uint8_t oflags =
        (uint8_t)DP_text_reader_get_ulong(reader, "oflags", UINT8_MAX);
    uint16_t message_len;
    const char *message =
        DP_text_reader_get_string(reader, "message", &message_len);
    return DP_msg_private_chat_new(context_id, target, oflags, message,
                                   message_len);
}

DP_MsgPrivateChat *DP_msg_private_chat_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_PRIVATE_CHAT);
}

uint8_t DP_msg_private_chat_target(const DP_MsgPrivateChat *mpc)
{
    DP_ASSERT(mpc);
    return mpc->target;
}

uint8_t DP_msg_private_chat_oflags(const DP_MsgPrivateChat *mpc)
{
    DP_ASSERT(mpc);
    return mpc->oflags;
}

const char *DP_msg_private_chat_message(const DP_MsgPrivateChat *mpc,
                                        size_t *out_len)
{
    DP_ASSERT(mpc);
    if (out_len) {
        *out_len = mpc->message_len;
    }
    return mpc->message;
}

size_t DP_msg_private_chat_message_len(const DP_MsgPrivateChat *mpc)
{
    return mpc->message_len;
}


/* DP_MSG_RESET_STREAM */

struct DP_MsgResetStream {
    uint16_t data_size;
    unsigned char data[];
};

static size_t msg_reset_stream_payload_length(DP_Message *msg)
{
    DP_MsgResetStream *mrs = DP_message_internal(msg);
    return mrs->data_size;
}

static size_t msg_reset_stream_serialize_payload(DP_Message *msg,
                                                 unsigned char *data)
{
    DP_MsgResetStream *mrs = DP_message_internal(msg);
    size_t written = 0;
    written += write_bytes(mrs->data, mrs->data_size, data + written);
    DP_ASSERT(written == msg_reset_stream_payload_length(msg));
    return written;
}

static bool msg_reset_stream_write_payload_text(DP_Message *msg,
                                                DP_TextWriter *writer)
{
    DP_MsgResetStream *mrs = DP_message_internal(msg);
    return DP_text_writer_write_base64(writer, "data", mrs->data,
                                       mrs->data_size);
}

static bool msg_reset_stream_equals(DP_Message *DP_RESTRICT msg,
                                    DP_Message *DP_RESTRICT other)
{
    DP_MsgResetStream *a = DP_message_internal(msg);
    DP_MsgResetStream *b = DP_message_internal(other);
    return a->data_size == b->data_size
        && memcmp(a->data, b->data, DP_uint16_to_size(a->data_size)) == 0;
}

static const DP_MessageMethods msg_reset_stream_methods = {
    msg_reset_stream_payload_length,     msg_reset_stream_serialize_payload,
    msg_reset_stream_payload_length,     msg_reset_stream_serialize_payload,
    msg_reset_stream_write_payload_text, msg_reset_stream_equals,
};

DP_Message *DP_msg_reset_stream_new(unsigned int context_id,
                                    void (*set_data)(size_t, unsigned char *,
                                                     void *),
                                    size_t data_size, void *data_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_RESET_STREAM, context_id, &msg_reset_stream_methods,
        DP_FLEX_SIZEOF(DP_MsgResetStream, data, data_size));
    DP_MsgResetStream *mrs = DP_message_internal(msg);
    mrs->data_size = DP_size_to_uint16(data_size);
    if (set_data) {
        set_data(mrs->data_size, mrs->data, data_user);
    }
    return msg;
}

DP_Message *DP_msg_reset_stream_deserialize(unsigned int context_id,
                                            const unsigned char *buffer,
                                            size_t length)
{
    if (length > 65535) {
        DP_error_set("Wrong length for resetstream message; "
                     "expected between 0 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    size_t data_bytes = length - read;
    uint16_t data_size = DP_size_to_uint16(data_bytes);
    void *data_user = (void *)(buffer + read);
    return DP_msg_reset_stream_new(context_id, read_bytes, data_size,
                                   data_user);
}

DP_Message *DP_msg_reset_stream_deserialize_compat(unsigned int context_id,
                                                   const unsigned char *buffer,
                                                   size_t length)
{
    DP_Message *msg =
        DP_msg_reset_stream_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_reset_stream_parse(unsigned int context_id,
                                      DP_TextReader *reader)
{
    size_t data_size;
    DP_TextReaderParseParams data_params =
        DP_text_reader_get_base64_string(reader, "data", &data_size);
    return DP_msg_reset_stream_new(context_id, DP_text_reader_parse_base64,
                                   data_size, &data_params);
}

DP_MsgResetStream *DP_msg_reset_stream_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_RESET_STREAM);
}

const unsigned char *DP_msg_reset_stream_data(const DP_MsgResetStream *mrs,
                                              size_t *out_size)
{
    DP_ASSERT(mrs);
    if (out_size) {
        *out_size = mrs->data_size;
    }
    return mrs->data;
}

size_t DP_msg_reset_stream_data_size(const DP_MsgResetStream *mrs)
{
    return mrs->data_size;
}


/* DP_MSG_INTERVAL */

struct DP_MsgInterval {
    uint16_t msecs;
};

static size_t msg_interval_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)2);
}

static size_t msg_interval_serialize_payload(DP_Message *msg,
                                             unsigned char *data)
{
    DP_MsgInterval *mi = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(mi->msecs, data + written);
    DP_ASSERT(written == msg_interval_payload_length(msg));
    return written;
}

static bool msg_interval_write_payload_text(DP_Message *msg,
                                            DP_TextWriter *writer)
{
    DP_MsgInterval *mi = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "msecs", mi->msecs);
}

static bool msg_interval_equals(DP_Message *DP_RESTRICT msg,
                                DP_Message *DP_RESTRICT other)
{
    DP_MsgInterval *a = DP_message_internal(msg);
    DP_MsgInterval *b = DP_message_internal(other);
    return a->msecs == b->msecs;
}

static const DP_MessageMethods msg_interval_methods = {
    msg_interval_payload_length,     msg_interval_serialize_payload,
    msg_interval_payload_length,     msg_interval_serialize_payload,
    msg_interval_write_payload_text, msg_interval_equals,
};

DP_Message *DP_msg_interval_new(unsigned int context_id, uint16_t msecs)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_INTERVAL, context_id, &msg_interval_methods,
                       sizeof(DP_MsgInterval));
    DP_MsgInterval *mi = DP_message_internal(msg);
    mi->msecs = msecs;
    return msg;
}

DP_Message *DP_msg_interval_deserialize(unsigned int context_id,
                                        const unsigned char *buffer,
                                        size_t length)
{
    if (length != 2) {
        DP_error_set("Wrong length for interval message; "
                     "expected 2, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t msecs = read_uint16(buffer + read, &read);
    return DP_msg_interval_new(context_id, msecs);
}

DP_Message *DP_msg_interval_deserialize_compat(unsigned int context_id,
                                               const unsigned char *buffer,
                                               size_t length)
{
    DP_Message *msg = DP_msg_interval_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_interval_parse(unsigned int context_id,
                                  DP_TextReader *reader)
{
    uint16_t msecs =
        (uint16_t)DP_text_reader_get_ulong(reader, "msecs", UINT16_MAX);
    return DP_msg_interval_new(context_id, msecs);
}

DP_MsgInterval *DP_msg_interval_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_INTERVAL);
}

uint16_t DP_msg_interval_msecs(const DP_MsgInterval *mi)
{
    DP_ASSERT(mi);
    return mi->msecs;
}


/* DP_MSG_LASER_TRAIL */

struct DP_MsgLaserTrail {
    uint32_t color;
    uint8_t persistence;
};

static size_t msg_laser_trail_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)5);
}

static size_t msg_laser_trail_serialize_payload(DP_Message *msg,
                                                unsigned char *data)
{
    DP_MsgLaserTrail *mlt = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint32(mlt->color, data + written);
    written += DP_write_bigendian_uint8(mlt->persistence, data + written);
    DP_ASSERT(written == msg_laser_trail_payload_length(msg));
    return written;
}

static bool msg_laser_trail_write_payload_text(DP_Message *msg,
                                               DP_TextWriter *writer)
{
    DP_MsgLaserTrail *mlt = DP_message_internal(msg);
    return DP_text_writer_write_argb_color(writer, "color", mlt->color)
        && DP_text_writer_write_uint(writer, "persistence", mlt->persistence);
}

static bool msg_laser_trail_equals(DP_Message *DP_RESTRICT msg,
                                   DP_Message *DP_RESTRICT other)
{
    DP_MsgLaserTrail *a = DP_message_internal(msg);
    DP_MsgLaserTrail *b = DP_message_internal(other);
    return a->color == b->color && a->persistence == b->persistence;
}

static const DP_MessageMethods msg_laser_trail_methods = {
    msg_laser_trail_payload_length,     msg_laser_trail_serialize_payload,
    msg_laser_trail_payload_length,     msg_laser_trail_serialize_payload,
    msg_laser_trail_write_payload_text, msg_laser_trail_equals,
};

DP_Message *DP_msg_laser_trail_new(unsigned int context_id, uint32_t color,
                                   uint8_t persistence)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_LASER_TRAIL, context_id, &msg_laser_trail_methods,
                       sizeof(DP_MsgLaserTrail));
    DP_MsgLaserTrail *mlt = DP_message_internal(msg);
    mlt->color = color;
    mlt->persistence = persistence;
    return msg;
}

DP_Message *DP_msg_laser_trail_deserialize(unsigned int context_id,
                                           const unsigned char *buffer,
                                           size_t length)
{
    if (length != 5) {
        DP_error_set("Wrong length for lasertrail message; "
                     "expected 5, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint32_t color = read_uint32(buffer + read, &read);
    uint8_t persistence = read_uint8(buffer + read, &read);
    return DP_msg_laser_trail_new(context_id, color, persistence);
}

DP_Message *DP_msg_laser_trail_deserialize_compat(unsigned int context_id,
                                                  const unsigned char *buffer,
                                                  size_t length)
{
    DP_Message *msg =
        DP_msg_laser_trail_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_laser_trail_parse(unsigned int context_id,
                                     DP_TextReader *reader)
{
    uint32_t color = DP_text_reader_get_argb_color(reader, "color");
    uint8_t persistence =
        (uint8_t)DP_text_reader_get_ulong(reader, "persistence", UINT8_MAX);
    return DP_msg_laser_trail_new(context_id, color, persistence);
}

DP_MsgLaserTrail *DP_msg_laser_trail_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_LASER_TRAIL);
}

uint32_t DP_msg_laser_trail_color(const DP_MsgLaserTrail *mlt)
{
    DP_ASSERT(mlt);
    return mlt->color;
}

uint8_t DP_msg_laser_trail_persistence(const DP_MsgLaserTrail *mlt)
{
    DP_ASSERT(mlt);
    return mlt->persistence;
}


/* DP_MSG_MOVE_POINTER */

struct DP_MsgMovePointer {
    int32_t x;
    int32_t y;
};

static size_t msg_move_pointer_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)8);
}

static size_t msg_move_pointer_serialize_payload(DP_Message *msg,
                                                 unsigned char *data)
{
    DP_MsgMovePointer *mmp = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_int32(mmp->x, data + written);
    written += DP_write_bigendian_int32(mmp->y, data + written);
    DP_ASSERT(written == msg_move_pointer_payload_length(msg));
    return written;
}

static bool msg_move_pointer_write_payload_text(DP_Message *msg,
                                                DP_TextWriter *writer)
{
    DP_MsgMovePointer *mmp = DP_message_internal(msg);
    return DP_text_writer_write_int(writer, "x", mmp->x)
        && DP_text_writer_write_int(writer, "y", mmp->y);
}

static bool msg_move_pointer_equals(DP_Message *DP_RESTRICT msg,
                                    DP_Message *DP_RESTRICT other)
{
    DP_MsgMovePointer *a = DP_message_internal(msg);
    DP_MsgMovePointer *b = DP_message_internal(other);
    return a->x == b->x && a->y == b->y;
}

static const DP_MessageMethods msg_move_pointer_methods = {
    msg_move_pointer_payload_length,     msg_move_pointer_serialize_payload,
    msg_move_pointer_payload_length,     msg_move_pointer_serialize_payload,
    msg_move_pointer_write_payload_text, msg_move_pointer_equals,
};

DP_Message *DP_msg_move_pointer_new(unsigned int context_id, int32_t x,
                                    int32_t y)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_MOVE_POINTER, context_id,
                       &msg_move_pointer_methods, sizeof(DP_MsgMovePointer));
    DP_MsgMovePointer *mmp = DP_message_internal(msg);
    mmp->x = x;
    mmp->y = y;
    return msg;
}

DP_Message *DP_msg_move_pointer_deserialize(unsigned int context_id,
                                            const unsigned char *buffer,
                                            size_t length)
{
    if (length != 8) {
        DP_error_set("Wrong length for movepointer message; "
                     "expected 8, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    int32_t x = read_int32(buffer + read, &read);
    int32_t y = read_int32(buffer + read, &read);
    return DP_msg_move_pointer_new(context_id, x, y);
}

DP_Message *DP_msg_move_pointer_deserialize_compat(unsigned int context_id,
                                                   const unsigned char *buffer,
                                                   size_t length)
{
    DP_Message *msg =
        DP_msg_move_pointer_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_move_pointer_parse(unsigned int context_id,
                                      DP_TextReader *reader)
{
    int32_t x =
        (int32_t)DP_text_reader_get_long(reader, "x", INT32_MIN, INT32_MAX);
    int32_t y =
        (int32_t)DP_text_reader_get_long(reader, "y", INT32_MIN, INT32_MAX);
    return DP_msg_move_pointer_new(context_id, x, y);
}

DP_MsgMovePointer *DP_msg_move_pointer_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_MOVE_POINTER);
}

int32_t DP_msg_move_pointer_x(const DP_MsgMovePointer *mmp)
{
    DP_ASSERT(mmp);
    return mmp->x;
}

int32_t DP_msg_move_pointer_y(const DP_MsgMovePointer *mmp)
{
    DP_ASSERT(mmp);
    return mmp->y;
}


/* DP_MSG_USER_ACL */

struct DP_MsgUserAcl {
    uint16_t users_count;
    uint8_t users[];
};

static size_t msg_user_acl_payload_length(DP_Message *msg)
{
    DP_MsgUserAcl *mua = DP_message_internal(msg);
    return DP_int_to_size(mua->users_count);
}

static size_t msg_user_acl_serialize_payload(DP_Message *msg,
                                             unsigned char *data)
{
    DP_MsgUserAcl *mua = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8_array(mua->users, mua->users_count,
                                              data + written);
    DP_ASSERT(written == msg_user_acl_payload_length(msg));
    return written;
}

static bool msg_user_acl_write_payload_text(DP_Message *msg,
                                            DP_TextWriter *writer)
{
    DP_MsgUserAcl *mua = DP_message_internal(msg);
    return DP_text_writer_write_uint8_list(writer, "users", mua->users,
                                           mua->users_count);
}

static bool msg_user_acl_equals(DP_Message *DP_RESTRICT msg,
                                DP_Message *DP_RESTRICT other)
{
    DP_MsgUserAcl *a = DP_message_internal(msg);
    DP_MsgUserAcl *b = DP_message_internal(other);
    return a->users_count == b->users_count
        && memcmp(a->users, b->users, DP_uint16_to_size(a->users_count)) == 0;
}

static const DP_MessageMethods msg_user_acl_methods = {
    msg_user_acl_payload_length,     msg_user_acl_serialize_payload,
    msg_user_acl_payload_length,     msg_user_acl_serialize_payload,
    msg_user_acl_write_payload_text, msg_user_acl_equals,
};

DP_Message *DP_msg_user_acl_new(unsigned int context_id,
                                void (*set_users)(int, uint8_t *, void *),
                                int users_count, void *users_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_USER_ACL, context_id, &msg_user_acl_methods,
        DP_FLEX_SIZEOF(DP_MsgUserAcl, users, DP_int_to_size(users_count)));
    DP_MsgUserAcl *mua = DP_message_internal(msg);
    mua->users_count = DP_int_to_uint16(users_count);
    if (set_users) {
        set_users(mua->users_count, mua->users, users_user);
    }
    return msg;
}

DP_Message *DP_msg_user_acl_deserialize(unsigned int context_id,
                                        const unsigned char *buffer,
                                        size_t length)
{
    if (length > 255) {
        DP_error_set("Wrong length for useracl message; "
                     "expected between 0 and 255, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    size_t users_bytes = length - read;
    uint16_t users_count = DP_size_to_uint16(users_bytes);
    void *users_user = (void *)(buffer + read);
    return DP_msg_user_acl_new(context_id, read_uint8_array, users_count,
                               users_user);
}

DP_Message *DP_msg_user_acl_deserialize_compat(unsigned int context_id,
                                               const unsigned char *buffer,
                                               size_t length)
{
    DP_Message *msg = DP_msg_user_acl_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_user_acl_parse(unsigned int context_id,
                                  DP_TextReader *reader)
{
    int users_count;
    DP_TextReaderParseParams users_params =
        DP_text_reader_get_array(reader, "users", &users_count);
    return DP_msg_user_acl_new(context_id, DP_text_reader_parse_uint8_array,
                               users_count, &users_params);
}

DP_MsgUserAcl *DP_msg_user_acl_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_USER_ACL);
}

const uint8_t *DP_msg_user_acl_users(const DP_MsgUserAcl *mua, int *out_count)
{
    DP_ASSERT(mua);
    if (out_count) {
        *out_count = mua->users_count;
    }
    return mua->users;
}

int DP_msg_user_acl_users_count(const DP_MsgUserAcl *mua)
{
    return mua->users_count;
}


/* DP_MSG_LAYER_ACL */

struct DP_MsgLayerAcl {
    uint32_t id;
    uint8_t flags;
    uint16_t exclusive_count;
    uint8_t exclusive[];
};

static size_t msg_layer_acl_payload_length(DP_Message *msg)
{
    DP_MsgLayerAcl *mla = DP_message_internal(msg);
    return ((size_t)4) + DP_int_to_size(mla->exclusive_count);
}

static size_t msg_layer_acl_payload_length_compat(DP_Message *msg)
{
    DP_MsgLayerAcl *mla = DP_message_internal(msg);
    return ((size_t)3) + DP_int_to_size(mla->exclusive_count);
}

static size_t msg_layer_acl_serialize_payload(DP_Message *msg,
                                              unsigned char *data)
{
    DP_MsgLayerAcl *mla = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint24(mla->id, data + written);
    written += DP_write_bigendian_uint8(mla->flags, data + written);
    written += DP_write_bigendian_uint8_array(
        mla->exclusive, mla->exclusive_count, data + written);
    DP_ASSERT(written == msg_layer_acl_payload_length(msg));
    return written;
}

static size_t msg_layer_acl_serialize_payload_compat(DP_Message *msg,
                                                     unsigned char *data)
{
    DP_MsgLayerAcl *mla = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(serialize_layer_id_compat(mla->id),
                                         data + written);
    written +=
        DP_write_bigendian_uint8(mla->flags & (uint8_t)0x83, data + written);
    written += DP_write_bigendian_uint8_array(
        mla->exclusive, mla->exclusive_count, data + written);
    DP_ASSERT(written == msg_layer_acl_payload_length_compat(msg));
    return written;
}

static bool msg_layer_acl_write_payload_text(DP_Message *msg,
                                             DP_TextWriter *writer)
{
    DP_MsgLayerAcl *mla = DP_message_internal(msg);
    return DP_text_writer_write_uint8_list(writer, "exclusive", mla->exclusive,
                                           mla->exclusive_count)
        && DP_text_writer_write_uint(writer, "flags", mla->flags)
        && DP_text_writer_write_uint(writer, "id", mla->id);
}

static bool msg_layer_acl_equals(DP_Message *DP_RESTRICT msg,
                                 DP_Message *DP_RESTRICT other)
{
    DP_MsgLayerAcl *a = DP_message_internal(msg);
    DP_MsgLayerAcl *b = DP_message_internal(other);
    return a->id == b->id && a->flags == b->flags
        && a->exclusive_count == b->exclusive_count
        && memcmp(a->exclusive, b->exclusive,
                  DP_uint16_to_size(a->exclusive_count))
               == 0;
}

static const DP_MessageMethods msg_layer_acl_methods = {
    msg_layer_acl_payload_length,        msg_layer_acl_serialize_payload,
    msg_layer_acl_payload_length_compat, msg_layer_acl_serialize_payload_compat,
    msg_layer_acl_write_payload_text,    msg_layer_acl_equals,
};

DP_Message *DP_msg_layer_acl_new(unsigned int context_id, uint32_t id,
                                 uint8_t flags,
                                 void (*set_exclusive)(int, uint8_t *, void *),
                                 int exclusive_count, void *exclusive_user)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_LAYER_ACL, context_id, &msg_layer_acl_methods,
                       DP_FLEX_SIZEOF(DP_MsgLayerAcl, exclusive,
                                      DP_int_to_size(exclusive_count)));
    DP_MsgLayerAcl *mla = DP_message_internal(msg);
    mla->id = id;
    mla->flags = flags;
    mla->exclusive_count = DP_int_to_uint16(exclusive_count);
    if (set_exclusive) {
        set_exclusive(mla->exclusive_count, mla->exclusive, exclusive_user);
    }
    return msg;
}

DP_Message *DP_msg_layer_acl_deserialize(unsigned int context_id,
                                         const unsigned char *buffer,
                                         size_t length)
{
    if (length < 4 || length > 259) {
        DP_error_set("Wrong length for layeracl message; "
                     "expected between 4 and 259, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint32_t id = read_uint24(buffer + read, &read);
    uint8_t flags = read_uint8(buffer + read, &read);
    size_t exclusive_bytes = length - read;
    uint16_t exclusive_count = DP_size_to_uint16(exclusive_bytes);
    void *exclusive_user = (void *)(buffer + read);
    return DP_msg_layer_acl_new(context_id, id, flags, read_uint8_array,
                                exclusive_count, exclusive_user);
}

DP_Message *DP_msg_layer_acl_deserialize_compat(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length)
{
    if (length < 3 || length > 258) {
        DP_error_set("Wrong length for layeracl compat message; "
                     "expected between 3 and 258, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    uint8_t flags = read_uint8(buffer + read, &read);
    size_t exclusive_bytes = length - read;
    uint16_t exclusive_count = DP_size_to_uint16(exclusive_bytes);
    void *exclusive_user = (void *)(buffer + read);
    DP_Message *msg = DP_msg_layer_acl_new(
        context_id, deserialize_layer_id_compat(id), flags & (uint8_t)0x83,
        read_uint8_array, exclusive_count, exclusive_user);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_layer_acl_parse(unsigned int context_id,
                                   DP_TextReader *reader)
{
    uint32_t id =
        (uint32_t)DP_text_reader_get_ulong(reader, "id", DP_UINT24_MAX);
    uint8_t flags =
        (uint8_t)DP_text_reader_get_ulong(reader, "flags", UINT8_MAX);
    int exclusive_count;
    DP_TextReaderParseParams exclusive_params =
        DP_text_reader_get_array(reader, "exclusive", &exclusive_count);
    return DP_msg_layer_acl_new(context_id, id, flags,
                                DP_text_reader_parse_uint8_array,
                                exclusive_count, &exclusive_params);
}

DP_MsgLayerAcl *DP_msg_layer_acl_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_LAYER_ACL);
}

uint32_t DP_msg_layer_acl_id(const DP_MsgLayerAcl *mla)
{
    DP_ASSERT(mla);
    return mla->id;
}

uint8_t DP_msg_layer_acl_flags(const DP_MsgLayerAcl *mla)
{
    DP_ASSERT(mla);
    return mla->flags;
}

const uint8_t *DP_msg_layer_acl_exclusive(const DP_MsgLayerAcl *mla,
                                          int *out_count)
{
    DP_ASSERT(mla);
    if (out_count) {
        *out_count = mla->exclusive_count;
    }
    return mla->exclusive;
}

int DP_msg_layer_acl_exclusive_count(const DP_MsgLayerAcl *mla)
{
    return mla->exclusive_count;
}


/* DP_MSG_FEATURE_ACCESS_LEVELS */

struct DP_MsgFeatureAccessLevels {
    uint16_t feature_tiers_count;
    uint8_t feature_tiers[];
};

static size_t msg_feature_access_levels_payload_length(DP_Message *msg)
{
    DP_MsgFeatureAccessLevels *mfal = DP_message_internal(msg);
    return DP_int_to_size(mfal->feature_tiers_count);
}

static size_t msg_feature_access_levels_serialize_payload(DP_Message *msg,
                                                          unsigned char *data)
{
    DP_MsgFeatureAccessLevels *mfal = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8_array(
        mfal->feature_tiers, mfal->feature_tiers_count, data + written);
    DP_ASSERT(written == msg_feature_access_levels_payload_length(msg));
    return written;
}

static bool msg_feature_access_levels_write_payload_text(DP_Message *msg,
                                                         DP_TextWriter *writer)
{
    DP_MsgFeatureAccessLevels *mfal = DP_message_internal(msg);
    return DP_text_writer_write_uint8_list(writer, "feature_tiers",
                                           mfal->feature_tiers,
                                           mfal->feature_tiers_count);
}

static bool msg_feature_access_levels_equals(DP_Message *DP_RESTRICT msg,
                                             DP_Message *DP_RESTRICT other)
{
    DP_MsgFeatureAccessLevels *a = DP_message_internal(msg);
    DP_MsgFeatureAccessLevels *b = DP_message_internal(other);
    return a->feature_tiers_count == b->feature_tiers_count
        && memcmp(a->feature_tiers, b->feature_tiers,
                  DP_uint16_to_size(a->feature_tiers_count))
               == 0;
}

static const DP_MessageMethods msg_feature_access_levels_methods = {
    msg_feature_access_levels_payload_length,
    msg_feature_access_levels_serialize_payload,
    msg_feature_access_levels_payload_length,
    msg_feature_access_levels_serialize_payload,
    msg_feature_access_levels_write_payload_text,
    msg_feature_access_levels_equals,
};

DP_Message *DP_msg_feature_access_levels_new(
    unsigned int context_id, void (*set_feature_tiers)(int, uint8_t *, void *),
    int feature_tiers_count, void *feature_tiers_user)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_FEATURE_ACCESS_LEVELS, context_id,
                       &msg_feature_access_levels_methods,
                       DP_FLEX_SIZEOF(DP_MsgFeatureAccessLevels, feature_tiers,
                                      DP_int_to_size(feature_tiers_count)));
    DP_MsgFeatureAccessLevels *mfal = DP_message_internal(msg);
    mfal->feature_tiers_count = DP_int_to_uint16(feature_tiers_count);
    if (set_feature_tiers) {
        set_feature_tiers(mfal->feature_tiers_count, mfal->feature_tiers,
                          feature_tiers_user);
    }
    return msg;
}

DP_Message *DP_msg_feature_access_levels_deserialize(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length < 1 || length > 255) {
        DP_error_set("Wrong length for featureaccess message; "
                     "expected between 1 and 255, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    size_t feature_tiers_bytes = length - read;
    uint16_t feature_tiers_count = DP_size_to_uint16(feature_tiers_bytes);
    void *feature_tiers_user = (void *)(buffer + read);
    return DP_msg_feature_access_levels_new(
        context_id, read_uint8_array, feature_tiers_count, feature_tiers_user);
}

DP_Message *DP_msg_feature_access_levels_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    DP_Message *msg =
        DP_msg_feature_access_levels_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_feature_access_levels_parse(unsigned int context_id,
                                               DP_TextReader *reader)
{
    int feature_tiers_count;
    DP_TextReaderParseParams feature_tiers_params =
        DP_text_reader_get_array(reader, "feature_tiers", &feature_tiers_count);
    return DP_msg_feature_access_levels_new(
        context_id, DP_text_reader_parse_uint8_array, feature_tiers_count,
        &feature_tiers_params);
}

DP_MsgFeatureAccessLevels *DP_msg_feature_access_levels_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_FEATURE_ACCESS_LEVELS);
}

const uint8_t *DP_msg_feature_access_levels_feature_tiers(
    const DP_MsgFeatureAccessLevels *mfal, int *out_count)
{
    DP_ASSERT(mfal);
    if (out_count) {
        *out_count = mfal->feature_tiers_count;
    }
    return mfal->feature_tiers;
}

int DP_msg_feature_access_levels_feature_tiers_count(
    const DP_MsgFeatureAccessLevels *mfal)
{
    return mfal->feature_tiers_count;
}


/* DP_MSG_DEFAULT_LAYER */

struct DP_MsgDefaultLayer {
    uint32_t id;
};

static size_t msg_default_layer_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)3);
}

static size_t msg_default_layer_payload_length_compat(DP_UNUSED DP_Message *msg)
{
    return ((size_t)2);
}

static size_t msg_default_layer_serialize_payload(DP_Message *msg,
                                                  unsigned char *data)
{
    DP_MsgDefaultLayer *mdl = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint24(mdl->id, data + written);
    DP_ASSERT(written == msg_default_layer_payload_length(msg));
    return written;
}

static size_t msg_default_layer_serialize_payload_compat(DP_Message *msg,
                                                         unsigned char *data)
{
    DP_MsgDefaultLayer *mdl = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(serialize_layer_id_compat(mdl->id),
                                         data + written);
    DP_ASSERT(written == msg_default_layer_payload_length_compat(msg));
    return written;
}

static bool msg_default_layer_write_payload_text(DP_Message *msg,
                                                 DP_TextWriter *writer)
{
    DP_MsgDefaultLayer *mdl = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "id", mdl->id);
}

static bool msg_default_layer_equals(DP_Message *DP_RESTRICT msg,
                                     DP_Message *DP_RESTRICT other)
{
    DP_MsgDefaultLayer *a = DP_message_internal(msg);
    DP_MsgDefaultLayer *b = DP_message_internal(other);
    return a->id == b->id;
}

static const DP_MessageMethods msg_default_layer_methods = {
    msg_default_layer_payload_length,
    msg_default_layer_serialize_payload,
    msg_default_layer_payload_length_compat,
    msg_default_layer_serialize_payload_compat,
    msg_default_layer_write_payload_text,
    msg_default_layer_equals,
};

DP_Message *DP_msg_default_layer_new(unsigned int context_id, uint32_t id)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_DEFAULT_LAYER, context_id,
                       &msg_default_layer_methods, sizeof(DP_MsgDefaultLayer));
    DP_MsgDefaultLayer *mdl = DP_message_internal(msg);
    mdl->id = id;
    return msg;
}

DP_Message *DP_msg_default_layer_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length)
{
    if (length != 3) {
        DP_error_set("Wrong length for defaultlayer message; "
                     "expected 3, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint32_t id = read_uint24(buffer + read, &read);
    return DP_msg_default_layer_new(context_id, id);
}

DP_Message *DP_msg_default_layer_deserialize_compat(unsigned int context_id,
                                                    const unsigned char *buffer,
                                                    size_t length)
{
    if (length != 2) {
        DP_error_set("Wrong length for defaultlayer compat message; "
                     "expected 2, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    DP_Message *msg =
        DP_msg_default_layer_new(context_id, deserialize_layer_id_compat(id));
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_default_layer_parse(unsigned int context_id,
                                       DP_TextReader *reader)
{
    uint32_t id =
        (uint32_t)DP_text_reader_get_ulong(reader, "id", DP_UINT24_MAX);
    return DP_msg_default_layer_new(context_id, id);
}

DP_MsgDefaultLayer *DP_msg_default_layer_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_DEFAULT_LAYER);
}

uint32_t DP_msg_default_layer_id(const DP_MsgDefaultLayer *mdl)
{
    DP_ASSERT(mdl);
    return mdl->id;
}


/* DP_MSG_UNDO_DEPTH */

struct DP_MsgUndoDepth {
    uint8_t depth;
};

static size_t msg_undo_depth_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)1);
}

static size_t msg_undo_depth_serialize_payload(DP_Message *msg,
                                               unsigned char *data)
{
    DP_MsgUndoDepth *mud = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(mud->depth, data + written);
    DP_ASSERT(written == msg_undo_depth_payload_length(msg));
    return written;
}

static bool msg_undo_depth_write_payload_text(DP_Message *msg,
                                              DP_TextWriter *writer)
{
    DP_MsgUndoDepth *mud = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "depth", mud->depth);
}

static bool msg_undo_depth_equals(DP_Message *DP_RESTRICT msg,
                                  DP_Message *DP_RESTRICT other)
{
    DP_MsgUndoDepth *a = DP_message_internal(msg);
    DP_MsgUndoDepth *b = DP_message_internal(other);
    return a->depth == b->depth;
}

static const DP_MessageMethods msg_undo_depth_methods = {
    msg_undo_depth_payload_length,     msg_undo_depth_serialize_payload,
    msg_undo_depth_payload_length,     msg_undo_depth_serialize_payload,
    msg_undo_depth_write_payload_text, msg_undo_depth_equals,
};

DP_Message *DP_msg_undo_depth_new(unsigned int context_id, uint8_t depth)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_UNDO_DEPTH, context_id, &msg_undo_depth_methods,
                       sizeof(DP_MsgUndoDepth));
    DP_MsgUndoDepth *mud = DP_message_internal(msg);
    mud->depth = depth;
    return msg;
}

DP_Message *DP_msg_undo_depth_deserialize(unsigned int context_id,
                                          const unsigned char *buffer,
                                          size_t length)
{
    if (length != 1) {
        DP_error_set("Wrong length for undodepth message; "
                     "expected 1, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t depth = read_uint8(buffer + read, &read);
    return DP_msg_undo_depth_new(context_id, depth);
}

DP_Message *DP_msg_undo_depth_deserialize_compat(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length)
{
    DP_Message *msg = DP_msg_undo_depth_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_undo_depth_parse(unsigned int context_id,
                                    DP_TextReader *reader)
{
    uint8_t depth =
        (uint8_t)DP_text_reader_get_ulong(reader, "depth", UINT8_MAX);
    return DP_msg_undo_depth_new(context_id, depth);
}

DP_MsgUndoDepth *DP_msg_undo_depth_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_UNDO_DEPTH);
}

uint8_t DP_msg_undo_depth_depth(const DP_MsgUndoDepth *mud)
{
    DP_ASSERT(mud);
    return mud->depth;
}


/* DP_MSG_DATA */

const char *DP_msg_data_type_variant_name(unsigned int value)
{
    switch (value) {
    case DP_MSG_DATA_TYPE_USER_INFO:
        return "UserInfo";
    default:
        return NULL;
    }
}

struct DP_MsgData {
    uint8_t type;
    uint8_t recipient;
    uint16_t body_size;
    unsigned char body[];
};

static size_t msg_data_payload_length(DP_Message *msg)
{
    DP_MsgData *md = DP_message_internal(msg);
    return ((size_t)2) + md->body_size;
}

static size_t msg_data_serialize_payload(DP_Message *msg, unsigned char *data)
{
    DP_MsgData *md = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(md->type, data + written);
    written += DP_write_bigendian_uint8(md->recipient, data + written);
    written += write_bytes(md->body, md->body_size, data + written);
    DP_ASSERT(written == msg_data_payload_length(msg));
    return written;
}

static bool msg_data_write_payload_text(DP_Message *msg, DP_TextWriter *writer)
{
    DP_MsgData *md = DP_message_internal(msg);
    return DP_text_writer_write_base64(writer, "body", md->body, md->body_size)
        && DP_text_writer_write_uint(writer, "recipient", md->recipient)
        && DP_text_writer_write_uint(writer, "type", md->type);
}

static bool msg_data_equals(DP_Message *DP_RESTRICT msg,
                            DP_Message *DP_RESTRICT other)
{
    DP_MsgData *a = DP_message_internal(msg);
    DP_MsgData *b = DP_message_internal(other);
    return a->type == b->type && a->recipient == b->recipient
        && a->body_size == b->body_size
        && memcmp(a->body, b->body, DP_uint16_to_size(a->body_size)) == 0;
}

static const DP_MessageMethods msg_data_methods = {
    msg_data_payload_length,     msg_data_serialize_payload,
    msg_data_payload_length,     msg_data_serialize_payload,
    msg_data_write_payload_text, msg_data_equals,
};

DP_Message *DP_msg_data_new(unsigned int context_id, uint8_t type,
                            uint8_t recipient,
                            void (*set_body)(size_t, unsigned char *, void *),
                            size_t body_size, void *body_user)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_DATA, context_id, &msg_data_methods,
                       DP_FLEX_SIZEOF(DP_MsgData, body, body_size));
    DP_MsgData *md = DP_message_internal(msg);
    md->type = type;
    md->recipient = recipient;
    md->body_size = DP_size_to_uint16(body_size);
    if (set_body) {
        set_body(md->body_size, md->body, body_user);
    }
    return msg;
}

DP_Message *DP_msg_data_deserialize(unsigned int context_id,
                                    const unsigned char *buffer, size_t length)
{
    if (length < 2 || length > 65535) {
        DP_error_set("Wrong length for data message; "
                     "expected between 2 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t type = read_uint8(buffer + read, &read);
    uint8_t recipient = read_uint8(buffer + read, &read);
    size_t body_bytes = length - read;
    uint16_t body_size = DP_size_to_uint16(body_bytes);
    void *body_user = (void *)(buffer + read);
    return DP_msg_data_new(context_id, type, recipient, read_bytes, body_size,
                           body_user);
}

DP_Message *DP_msg_data_deserialize_compat(unsigned int context_id,
                                           const unsigned char *buffer,
                                           size_t length)
{
    DP_Message *msg = DP_msg_data_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_data_parse(unsigned int context_id, DP_TextReader *reader)
{
    uint8_t type = (uint8_t)DP_text_reader_get_ulong(reader, "type", UINT8_MAX);
    uint8_t recipient =
        (uint8_t)DP_text_reader_get_ulong(reader, "recipient", UINT8_MAX);
    size_t body_size;
    DP_TextReaderParseParams body_params =
        DP_text_reader_get_base64_string(reader, "body", &body_size);
    return DP_msg_data_new(context_id, type, recipient,
                           DP_text_reader_parse_base64, body_size,
                           &body_params);
}

DP_MsgData *DP_msg_data_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_DATA);
}

uint8_t DP_msg_data_type(const DP_MsgData *md)
{
    DP_ASSERT(md);
    return md->type;
}

uint8_t DP_msg_data_recipient(const DP_MsgData *md)
{
    DP_ASSERT(md);
    return md->recipient;
}

const unsigned char *DP_msg_data_body(const DP_MsgData *md, size_t *out_size)
{
    DP_ASSERT(md);
    if (out_size) {
        *out_size = md->body_size;
    }
    return md->body;
}

size_t DP_msg_data_body_size(const DP_MsgData *md)
{
    return md->body_size;
}


/* DP_MSG_LOCAL_CHANGE */

const char *DP_msg_local_change_type_variant_name(unsigned int value)
{
    switch (value) {
    case DP_MSG_LOCAL_CHANGE_TYPE_LAYER_VISIBILITY:
        return "LayerVisibility";
    case DP_MSG_LOCAL_CHANGE_TYPE_BACKGROUND_TILE:
        return "BackgroundTile";
    case DP_MSG_LOCAL_CHANGE_TYPE_VIEW_MODE:
        return "ViewMode";
    case DP_MSG_LOCAL_CHANGE_TYPE_ACTIVE_LAYER:
        return "ActiveLayer";
    case DP_MSG_LOCAL_CHANGE_TYPE_ACTIVE_FRAME:
        return "ActiveFrame";
    case DP_MSG_LOCAL_CHANGE_TYPE_ONION_SKINS:
        return "OnionSkins";
    case DP_MSG_LOCAL_CHANGE_TYPE_TRACK_VISIBILITY:
        return "TrackVisibility";
    case DP_MSG_LOCAL_CHANGE_TYPE_TRACK_ONION_SKIN:
        return "TrackOnionSkin";
    case DP_MSG_LOCAL_CHANGE_TYPE_LAYER_SKETCH:
        return "LayerSketch";
    case DP_MSG_LOCAL_CHANGE_TYPE_LAYER_ALPHA_LOCK:
        return "LayerAlphaLock";
    case DP_MSG_LOCAL_CHANGE_TYPE_LAYER_CENSORED:
        return "LayerCensored";
    default:
        return NULL;
    }
}

struct DP_MsgLocalChange {
    uint8_t type;
    uint16_t body_size;
    unsigned char body[];
};

static size_t msg_local_change_payload_length(DP_Message *msg)
{
    DP_MsgLocalChange *mlc = DP_message_internal(msg);
    return ((size_t)1) + mlc->body_size;
}

static size_t msg_local_change_serialize_payload(DP_Message *msg,
                                                 unsigned char *data)
{
    DP_MsgLocalChange *mlc = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(mlc->type, data + written);
    written += write_bytes(mlc->body, mlc->body_size, data + written);
    DP_ASSERT(written == msg_local_change_payload_length(msg));
    return written;
}

static bool msg_local_change_write_payload_text(DP_Message *msg,
                                                DP_TextWriter *writer)
{
    DP_MsgLocalChange *mlc = DP_message_internal(msg);
    return DP_text_writer_write_base64(writer, "body", mlc->body,
                                       mlc->body_size)
        && DP_text_writer_write_uint(writer, "type", mlc->type);
}

static bool msg_local_change_equals(DP_Message *DP_RESTRICT msg,
                                    DP_Message *DP_RESTRICT other)
{
    DP_MsgLocalChange *a = DP_message_internal(msg);
    DP_MsgLocalChange *b = DP_message_internal(other);
    return a->type == b->type && a->body_size == b->body_size
        && memcmp(a->body, b->body, DP_uint16_to_size(a->body_size)) == 0;
}

static const DP_MessageMethods msg_local_change_methods = {
    msg_local_change_payload_length,     msg_local_change_serialize_payload,
    msg_local_change_payload_length,     msg_local_change_serialize_payload,
    msg_local_change_write_payload_text, msg_local_change_equals,
};

DP_Message *DP_msg_local_change_new(unsigned int context_id, uint8_t type,
                                    void (*set_body)(size_t, unsigned char *,
                                                     void *),
                                    size_t body_size, void *body_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_LOCAL_CHANGE, context_id, &msg_local_change_methods,
        DP_FLEX_SIZEOF(DP_MsgLocalChange, body, body_size));
    DP_MsgLocalChange *mlc = DP_message_internal(msg);
    mlc->type = type;
    mlc->body_size = DP_size_to_uint16(body_size);
    if (set_body) {
        set_body(mlc->body_size, mlc->body, body_user);
    }
    return msg;
}

DP_Message *DP_msg_local_change_deserialize(unsigned int context_id,
                                            const unsigned char *buffer,
                                            size_t length)
{
    if (length < 1 || length > 65535) {
        DP_error_set("Wrong length for localchange message; "
                     "expected between 1 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t type = read_uint8(buffer + read, &read);
    size_t body_bytes = length - read;
    uint16_t body_size = DP_size_to_uint16(body_bytes);
    void *body_user = (void *)(buffer + read);
    return DP_msg_local_change_new(context_id, type, read_bytes, body_size,
                                   body_user);
}

DP_Message *DP_msg_local_change_deserialize_compat(unsigned int context_id,
                                                   const unsigned char *buffer,
                                                   size_t length)
{
    DP_Message *msg =
        DP_msg_local_change_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_local_change_parse(unsigned int context_id,
                                      DP_TextReader *reader)
{
    uint8_t type = (uint8_t)DP_text_reader_get_ulong(reader, "type", UINT8_MAX);
    size_t body_size;
    DP_TextReaderParseParams body_params =
        DP_text_reader_get_base64_string(reader, "body", &body_size);
    return DP_msg_local_change_new(
        context_id, type, DP_text_reader_parse_base64, body_size, &body_params);
}

DP_MsgLocalChange *DP_msg_local_change_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_LOCAL_CHANGE);
}

uint8_t DP_msg_local_change_type(const DP_MsgLocalChange *mlc)
{
    DP_ASSERT(mlc);
    return mlc->type;
}

const unsigned char *DP_msg_local_change_body(const DP_MsgLocalChange *mlc,
                                              size_t *out_size)
{
    DP_ASSERT(mlc);
    if (out_size) {
        *out_size = mlc->body_size;
    }
    return mlc->body;
}

size_t DP_msg_local_change_body_size(const DP_MsgLocalChange *mlc)
{
    return mlc->body_size;
}


/* DP_MSG_FEATURE_LIMITS */

struct DP_MsgFeatureLimits {
    uint16_t limits_count;
    int32_t limits[];
};

static size_t msg_feature_limits_payload_length(DP_Message *msg)
{
    DP_MsgFeatureLimits *mfl = DP_message_internal(msg);
    return DP_int_to_size(mfl->limits_count) * 4;
}

static size_t msg_feature_limits_serialize_payload(DP_Message *msg,
                                                   unsigned char *data)
{
    DP_MsgFeatureLimits *mfl = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_int32_array(mfl->limits, mfl->limits_count,
                                              data + written);
    DP_ASSERT(written == msg_feature_limits_payload_length(msg));
    return written;
}

static bool msg_feature_limits_write_payload_text(DP_Message *msg,
                                                  DP_TextWriter *writer)
{
    DP_MsgFeatureLimits *mfl = DP_message_internal(msg);
    return DP_text_writer_write_int32_list(writer, "limits", mfl->limits,
                                           mfl->limits_count);
}

static bool msg_feature_limits_equals(DP_Message *DP_RESTRICT msg,
                                      DP_Message *DP_RESTRICT other)
{
    DP_MsgFeatureLimits *a = DP_message_internal(msg);
    DP_MsgFeatureLimits *b = DP_message_internal(other);
    return a->limits_count == b->limits_count
        && memcmp(a->limits, b->limits, DP_uint16_to_size(a->limits_count) * 4)
               == 0;
}

static const DP_MessageMethods msg_feature_limits_methods = {
    msg_feature_limits_payload_length,     msg_feature_limits_serialize_payload,
    msg_feature_limits_payload_length,     msg_feature_limits_serialize_payload,
    msg_feature_limits_write_payload_text, msg_feature_limits_equals,
};

DP_Message *DP_msg_feature_limits_new(unsigned int context_id,
                                      void (*set_limits)(int, int32_t *,
                                                         void *),
                                      int limits_count, void *limits_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_FEATURE_LIMITS, context_id, &msg_feature_limits_methods,
        DP_FLEX_SIZEOF(DP_MsgFeatureLimits, limits,
                       DP_int_to_size(limits_count) * 4));
    DP_MsgFeatureLimits *mfl = DP_message_internal(msg);
    mfl->limits_count = DP_int_to_uint16(limits_count);
    if (set_limits) {
        set_limits(mfl->limits_count, mfl->limits, limits_user);
    }
    return msg;
}

DP_Message *DP_msg_feature_limits_deserialize(unsigned int context_id,
                                              const unsigned char *buffer,
                                              size_t length)
{
    if (length < 16 || length > 1020) {
        DP_error_set("Wrong length for featurelimits message; "
                     "expected between 16 and 1020, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    size_t limits_bytes = length - read;
    if ((limits_bytes % 4) != 0) {
        DP_error_set("Wrong length for limits field in featurelimits message; "
                     "%zu not divisible by 4",
                     limits_bytes);
        return NULL;
    }
    uint16_t limits_count = DP_size_to_uint16(limits_bytes / 4);
    void *limits_user = (void *)(buffer + read);
    return DP_msg_feature_limits_new(context_id, read_int32_array, limits_count,
                                     limits_user);
}

DP_Message *DP_msg_feature_limits_parse(unsigned int context_id,
                                        DP_TextReader *reader)
{
    int limits_count;
    DP_TextReaderParseParams limits_params =
        DP_text_reader_get_array(reader, "limits", &limits_count);
    return DP_msg_feature_limits_new(context_id,
                                     DP_text_reader_parse_int32_array,
                                     limits_count, &limits_params);
}

DP_MsgFeatureLimits *DP_msg_feature_limits_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_FEATURE_LIMITS);
}

const int32_t *DP_msg_feature_limits_limits(const DP_MsgFeatureLimits *mfl,
                                            int *out_count)
{
    DP_ASSERT(mfl);
    if (out_count) {
        *out_count = mfl->limits_count;
    }
    return mfl->limits;
}

int DP_msg_feature_limits_limits_count(const DP_MsgFeatureLimits *mfl)
{
    return mfl->limits_count;
}


/* DP_MSG_UNDO_POINT */

DP_Message *DP_msg_undo_point_new(unsigned int context_id)
{
    return DP_message_new(DP_MSG_UNDO_POINT, context_id, &zero_length_methods,
                          0);
}

DP_Message *DP_msg_undo_point_deserialize(unsigned int context_id,
                                          DP_UNUSED const unsigned char *buffer,
                                          size_t length)
{
    if (length != 0) {
        DP_error_set("Wrong length for undopoint message; "
                     "expected 0, got %zu",
                     length);
        return NULL;
    }
    return DP_msg_undo_point_new(context_id);
}

DP_Message *DP_msg_undo_point_deserialize_compat(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length)
{
    DP_Message *msg = DP_msg_undo_point_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_undo_point_parse(unsigned int context_id,
                                    DP_UNUSED DP_TextReader *reader)
{
    return DP_msg_undo_point_new(context_id);
}


/* DP_MSG_CANVAS_RESIZE */

struct DP_MsgCanvasResize {
    int32_t top;
    int32_t right;
    int32_t bottom;
    int32_t left;
};

static size_t msg_canvas_resize_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)16);
}

static size_t msg_canvas_resize_serialize_payload(DP_Message *msg,
                                                  unsigned char *data)
{
    DP_MsgCanvasResize *mcr = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_int32(mcr->top, data + written);
    written += DP_write_bigendian_int32(mcr->right, data + written);
    written += DP_write_bigendian_int32(mcr->bottom, data + written);
    written += DP_write_bigendian_int32(mcr->left, data + written);
    DP_ASSERT(written == msg_canvas_resize_payload_length(msg));
    return written;
}

static bool msg_canvas_resize_write_payload_text(DP_Message *msg,
                                                 DP_TextWriter *writer)
{
    DP_MsgCanvasResize *mcr = DP_message_internal(msg);
    return DP_text_writer_write_int(writer, "bottom", mcr->bottom)
        && DP_text_writer_write_int(writer, "left", mcr->left)
        && DP_text_writer_write_int(writer, "right", mcr->right)
        && DP_text_writer_write_int(writer, "top", mcr->top);
}

static bool msg_canvas_resize_equals(DP_Message *DP_RESTRICT msg,
                                     DP_Message *DP_RESTRICT other)
{
    DP_MsgCanvasResize *a = DP_message_internal(msg);
    DP_MsgCanvasResize *b = DP_message_internal(other);
    return a->top == b->top && a->right == b->right && a->bottom == b->bottom
        && a->left == b->left;
}

static const DP_MessageMethods msg_canvas_resize_methods = {
    msg_canvas_resize_payload_length,     msg_canvas_resize_serialize_payload,
    msg_canvas_resize_payload_length,     msg_canvas_resize_serialize_payload,
    msg_canvas_resize_write_payload_text, msg_canvas_resize_equals,
};

DP_Message *DP_msg_canvas_resize_new(unsigned int context_id, int32_t top,
                                     int32_t right, int32_t bottom,
                                     int32_t left)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_CANVAS_RESIZE, context_id,
                       &msg_canvas_resize_methods, sizeof(DP_MsgCanvasResize));
    DP_MsgCanvasResize *mcr = DP_message_internal(msg);
    mcr->top = top;
    mcr->right = right;
    mcr->bottom = bottom;
    mcr->left = left;
    return msg;
}

DP_Message *DP_msg_canvas_resize_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length)
{
    if (length != 16) {
        DP_error_set("Wrong length for resize message; "
                     "expected 16, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    int32_t top = read_int32(buffer + read, &read);
    int32_t right = read_int32(buffer + read, &read);
    int32_t bottom = read_int32(buffer + read, &read);
    int32_t left = read_int32(buffer + read, &read);
    return DP_msg_canvas_resize_new(context_id, top, right, bottom, left);
}

DP_Message *DP_msg_canvas_resize_deserialize_compat(unsigned int context_id,
                                                    const unsigned char *buffer,
                                                    size_t length)
{
    DP_Message *msg =
        DP_msg_canvas_resize_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_canvas_resize_parse(unsigned int context_id,
                                       DP_TextReader *reader)
{
    int32_t top =
        (int32_t)DP_text_reader_get_long(reader, "top", INT32_MIN, INT32_MAX);
    int32_t right =
        (int32_t)DP_text_reader_get_long(reader, "right", INT32_MIN, INT32_MAX);
    int32_t bottom = (int32_t)DP_text_reader_get_long(reader, "bottom",
                                                      INT32_MIN, INT32_MAX);
    int32_t left =
        (int32_t)DP_text_reader_get_long(reader, "left", INT32_MIN, INT32_MAX);
    return DP_msg_canvas_resize_new(context_id, top, right, bottom, left);
}

DP_MsgCanvasResize *DP_msg_canvas_resize_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_CANVAS_RESIZE);
}

int32_t DP_msg_canvas_resize_top(const DP_MsgCanvasResize *mcr)
{
    DP_ASSERT(mcr);
    return mcr->top;
}

int32_t DP_msg_canvas_resize_right(const DP_MsgCanvasResize *mcr)
{
    DP_ASSERT(mcr);
    return mcr->right;
}

int32_t DP_msg_canvas_resize_bottom(const DP_MsgCanvasResize *mcr)
{
    DP_ASSERT(mcr);
    return mcr->bottom;
}

int32_t DP_msg_canvas_resize_left(const DP_MsgCanvasResize *mcr)
{
    DP_ASSERT(mcr);
    return mcr->left;
}


/* DP_MSG_LAYER_ATTRIBUTES */

const char *DP_msg_layer_attributes_flags_flag_name(unsigned int value)
{
    switch (value) {
    case DP_MSG_LAYER_ATTRIBUTES_FLAGS_CENSOR:
        return "censor";
    case DP_MSG_LAYER_ATTRIBUTES_FLAGS_FIXED:
        return "fixed";
    case DP_MSG_LAYER_ATTRIBUTES_FLAGS_ISOLATED:
        return "isolated";
    case DP_MSG_LAYER_ATTRIBUTES_FLAGS_CLIP:
        return "clip";
    default:
        return NULL;
    }
}

struct DP_MsgLayerAttributes {
    uint32_t id;
    uint8_t sublayer;
    uint8_t flags;
    uint8_t opacity;
    uint8_t blend;
};

static size_t msg_layer_attributes_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)7);
}

static size_t
msg_layer_attributes_payload_length_compat(DP_UNUSED DP_Message *msg)
{
    return ((size_t)6);
}

static size_t msg_layer_attributes_serialize_payload(DP_Message *msg,
                                                     unsigned char *data)
{
    DP_MsgLayerAttributes *mla = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint24(mla->id, data + written);
    written += DP_write_bigendian_uint8(mla->sublayer, data + written);
    written += DP_write_bigendian_uint8(mla->flags, data + written);
    written += DP_write_bigendian_uint8(mla->opacity, data + written);
    written += DP_write_bigendian_uint8(mla->blend, data + written);
    DP_ASSERT(written == msg_layer_attributes_payload_length(msg));
    return written;
}

static size_t msg_layer_attributes_serialize_payload_compat(DP_Message *msg,
                                                            unsigned char *data)
{
    DP_MsgLayerAttributes *mla = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(serialize_layer_id_compat(mla->id),
                                         data + written);
    written += DP_write_bigendian_uint8(mla->sublayer, data + written);
    written +=
        DP_write_bigendian_uint8(mla->flags & (uint8_t)0x7, data + written);
    written += DP_write_bigendian_uint8(mla->opacity, data + written);
    written += DP_write_bigendian_uint8(mla->blend, data + written);
    DP_ASSERT(written == msg_layer_attributes_payload_length_compat(msg));
    return written;
}

static bool msg_layer_attributes_write_payload_text(DP_Message *msg,
                                                    DP_TextWriter *writer)
{
    DP_MsgLayerAttributes *mla = DP_message_internal(msg);
    return DP_text_writer_write_blend_mode(writer, "blend", mla->blend)
        && DP_text_writer_write_flags(
               writer, "flags", mla->flags, 4,
               (const char *[]){"censor", "fixed", "isolated", "clip"},
               (unsigned int[]){DP_MSG_LAYER_ATTRIBUTES_FLAGS_CENSOR,
                                DP_MSG_LAYER_ATTRIBUTES_FLAGS_FIXED,
                                DP_MSG_LAYER_ATTRIBUTES_FLAGS_ISOLATED,
                                DP_MSG_LAYER_ATTRIBUTES_FLAGS_CLIP})
        && DP_text_writer_write_uint(writer, "id", mla->id)
        && DP_text_writer_write_uint(writer, "opacity", mla->opacity)
        && DP_text_writer_write_uint(writer, "sublayer", mla->sublayer);
}

static bool msg_layer_attributes_equals(DP_Message *DP_RESTRICT msg,
                                        DP_Message *DP_RESTRICT other)
{
    DP_MsgLayerAttributes *a = DP_message_internal(msg);
    DP_MsgLayerAttributes *b = DP_message_internal(other);
    return a->id == b->id && a->sublayer == b->sublayer && a->flags == b->flags
        && a->opacity == b->opacity && a->blend == b->blend;
}

static const DP_MessageMethods msg_layer_attributes_methods = {
    msg_layer_attributes_payload_length,
    msg_layer_attributes_serialize_payload,
    msg_layer_attributes_payload_length_compat,
    msg_layer_attributes_serialize_payload_compat,
    msg_layer_attributes_write_payload_text,
    msg_layer_attributes_equals,
};

DP_Message *DP_msg_layer_attributes_new(unsigned int context_id, uint32_t id,
                                        uint8_t sublayer, uint8_t flags,
                                        uint8_t opacity, uint8_t blend)
{
    DP_Message *msg = DP_message_new(DP_MSG_LAYER_ATTRIBUTES, context_id,
                                     &msg_layer_attributes_methods,
                                     sizeof(DP_MsgLayerAttributes));
    DP_MsgLayerAttributes *mla = DP_message_internal(msg);
    mla->id = id;
    mla->sublayer = sublayer;
    mla->flags = flags;
    mla->opacity = opacity;
    mla->blend = blend;
    return msg;
}

DP_Message *DP_msg_layer_attributes_deserialize(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length)
{
    if (length != 7) {
        DP_error_set("Wrong length for layerattr message; "
                     "expected 7, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint32_t id = read_uint24(buffer + read, &read);
    uint8_t sublayer = read_uint8(buffer + read, &read);
    uint8_t flags = read_uint8(buffer + read, &read);
    uint8_t opacity = read_uint8(buffer + read, &read);
    uint8_t blend = read_uint8(buffer + read, &read);
    return DP_msg_layer_attributes_new(context_id, id, sublayer, flags, opacity,
                                       blend);
}

DP_Message *DP_msg_layer_attributes_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length != 6) {
        DP_error_set("Wrong length for layerattr compat message; "
                     "expected 6, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    uint8_t sublayer = read_uint8(buffer + read, &read);
    uint8_t flags = read_uint8(buffer + read, &read);
    uint8_t opacity = read_uint8(buffer + read, &read);
    uint8_t blend = read_uint8(buffer + read, &read);
    DP_Message *msg = DP_msg_layer_attributes_new(
        context_id, deserialize_layer_id_compat(id), sublayer,
        flags & (uint8_t)0x7, opacity, blend);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_layer_attributes_parse(unsigned int context_id,
                                          DP_TextReader *reader)
{
    uint32_t id =
        (uint32_t)DP_text_reader_get_ulong(reader, "id", DP_UINT24_MAX);
    uint8_t sublayer =
        (uint8_t)DP_text_reader_get_ulong(reader, "sublayer", UINT8_MAX);
    uint8_t flags = (uint8_t)DP_text_reader_get_flags(
        reader, "flags", 4,
        (const char *[]){"censor", "fixed", "isolated", "clip"},
        (unsigned int[]){DP_MSG_LAYER_ATTRIBUTES_FLAGS_CENSOR,
                         DP_MSG_LAYER_ATTRIBUTES_FLAGS_FIXED,
                         DP_MSG_LAYER_ATTRIBUTES_FLAGS_ISOLATED,
                         DP_MSG_LAYER_ATTRIBUTES_FLAGS_CLIP});
    uint8_t opacity =
        (uint8_t)DP_text_reader_get_ulong(reader, "opacity", UINT8_MAX);
    uint8_t blend = DP_text_reader_get_blend_mode(reader, "blend");
    return DP_msg_layer_attributes_new(context_id, id, sublayer, flags, opacity,
                                       blend);
}

DP_MsgLayerAttributes *DP_msg_layer_attributes_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_LAYER_ATTRIBUTES);
}

uint32_t DP_msg_layer_attributes_id(const DP_MsgLayerAttributes *mla)
{
    DP_ASSERT(mla);
    return mla->id;
}

uint8_t DP_msg_layer_attributes_sublayer(const DP_MsgLayerAttributes *mla)
{
    DP_ASSERT(mla);
    return mla->sublayer;
}

uint8_t DP_msg_layer_attributes_flags(const DP_MsgLayerAttributes *mla)
{
    DP_ASSERT(mla);
    return mla->flags;
}

uint8_t DP_msg_layer_attributes_opacity(const DP_MsgLayerAttributes *mla)
{
    DP_ASSERT(mla);
    return mla->opacity;
}

uint8_t DP_msg_layer_attributes_blend(const DP_MsgLayerAttributes *mla)
{
    DP_ASSERT(mla);
    return mla->blend;
}


/* DP_MSG_LAYER_RETITLE */

struct DP_MsgLayerRetitle {
    uint32_t id;
    uint16_t title_len;
    char title[];
};

static size_t msg_layer_retitle_payload_length(DP_Message *msg)
{
    DP_MsgLayerRetitle *mlr = DP_message_internal(msg);
    return ((size_t)3) + DP_uint16_to_size(mlr->title_len);
}

static size_t msg_layer_retitle_payload_length_compat(DP_Message *msg)
{
    DP_MsgLayerRetitle *mlr = DP_message_internal(msg);
    return ((size_t)2) + DP_uint16_to_size(mlr->title_len);
}

static size_t msg_layer_retitle_serialize_payload(DP_Message *msg,
                                                  unsigned char *data)
{
    DP_MsgLayerRetitle *mlr = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint24(mlr->id, data + written);
    written += DP_write_bytes(mlr->title, 1, mlr->title_len, data + written);
    DP_ASSERT(written == msg_layer_retitle_payload_length(msg));
    return written;
}

static size_t msg_layer_retitle_serialize_payload_compat(DP_Message *msg,
                                                         unsigned char *data)
{
    DP_MsgLayerRetitle *mlr = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(serialize_layer_id_compat(mlr->id),
                                         data + written);
    written += DP_write_bytes(mlr->title, 1, mlr->title_len, data + written);
    DP_ASSERT(written == msg_layer_retitle_payload_length_compat(msg));
    return written;
}

static bool msg_layer_retitle_write_payload_text(DP_Message *msg,
                                                 DP_TextWriter *writer)
{
    DP_MsgLayerRetitle *mlr = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "id", mlr->id)
        && DP_text_writer_write_string(writer, "title", mlr->title);
}

static bool msg_layer_retitle_equals(DP_Message *DP_RESTRICT msg,
                                     DP_Message *DP_RESTRICT other)
{
    DP_MsgLayerRetitle *a = DP_message_internal(msg);
    DP_MsgLayerRetitle *b = DP_message_internal(other);
    return a->id == b->id && a->title_len == b->title_len
        && memcmp(a->title, b->title, a->title_len) == 0;
}

static const DP_MessageMethods msg_layer_retitle_methods = {
    msg_layer_retitle_payload_length,
    msg_layer_retitle_serialize_payload,
    msg_layer_retitle_payload_length_compat,
    msg_layer_retitle_serialize_payload_compat,
    msg_layer_retitle_write_payload_text,
    msg_layer_retitle_equals,
};

DP_Message *DP_msg_layer_retitle_new(unsigned int context_id, uint32_t id,
                                     const char *title_value, size_t title_len)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_LAYER_RETITLE, context_id, &msg_layer_retitle_methods,
        DP_FLEX_SIZEOF(DP_MsgLayerRetitle, title, title_len + 1));
    DP_MsgLayerRetitle *mlr = DP_message_internal(msg);
    mlr->id = id;
    mlr->title_len = DP_size_to_uint16(title_len);
    assign_string(mlr->title, title_value, mlr->title_len);
    return msg;
}

DP_Message *DP_msg_layer_retitle_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length)
{
    if (length < 3 || length > 65535) {
        DP_error_set("Wrong length for retitlelayer message; "
                     "expected between 3 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint32_t id = read_uint24(buffer + read, &read);
    size_t title_bytes = length - read;
    uint16_t title_len = DP_size_to_uint16(title_bytes);
    const char *title = (const char *)buffer + read;
    return DP_msg_layer_retitle_new(context_id, id, title, title_len);
}

DP_Message *DP_msg_layer_retitle_deserialize_compat(unsigned int context_id,
                                                    const unsigned char *buffer,
                                                    size_t length)
{
    if (length < 2 || length > 65535) {
        DP_error_set("Wrong length for retitlelayer compat message; "
                     "expected between 2 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    size_t title_bytes = length - read;
    uint16_t title_len = DP_size_to_uint16(title_bytes);
    const char *title = (const char *)buffer + read;
    DP_Message *msg = DP_msg_layer_retitle_new(
        context_id, deserialize_layer_id_compat(id), title, title_len);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_layer_retitle_parse(unsigned int context_id,
                                       DP_TextReader *reader)
{
    uint32_t id =
        (uint32_t)DP_text_reader_get_ulong(reader, "id", DP_UINT24_MAX);
    uint16_t title_len;
    const char *title = DP_text_reader_get_string(reader, "title", &title_len);
    return DP_msg_layer_retitle_new(context_id, id, title, title_len);
}

DP_MsgLayerRetitle *DP_msg_layer_retitle_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_LAYER_RETITLE);
}

uint32_t DP_msg_layer_retitle_id(const DP_MsgLayerRetitle *mlr)
{
    DP_ASSERT(mlr);
    return mlr->id;
}

const char *DP_msg_layer_retitle_title(const DP_MsgLayerRetitle *mlr,
                                       size_t *out_len)
{
    DP_ASSERT(mlr);
    if (out_len) {
        *out_len = mlr->title_len;
    }
    return mlr->title;
}

size_t DP_msg_layer_retitle_title_len(const DP_MsgLayerRetitle *mlr)
{
    return mlr->title_len;
}


/* DP_MSG_PUT_IMAGE */

struct DP_MsgPutImage {
    uint32_t layer;
    uint8_t mode;
    uint32_t x;
    uint32_t y;
    uint32_t w;
    uint32_t h;
    uint16_t image_size;
    unsigned char image[];
};

static size_t msg_put_image_payload_length(DP_Message *msg)
{
    DP_MsgPutImage *mpi = DP_message_internal(msg);
    return ((size_t)20) + mpi->image_size;
}

static size_t msg_put_image_payload_length_compat(DP_Message *msg)
{
    DP_MsgPutImage *mpi = DP_message_internal(msg);
    return ((size_t)19) + mpi->image_size;
}

static size_t msg_put_image_serialize_payload(DP_Message *msg,
                                              unsigned char *data)
{
    DP_MsgPutImage *mpi = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint24(mpi->layer, data + written);
    written += DP_write_bigendian_uint8(mpi->mode, data + written);
    written += DP_write_bigendian_uint32(mpi->x, data + written);
    written += DP_write_bigendian_uint32(mpi->y, data + written);
    written += DP_write_bigendian_uint32(mpi->w, data + written);
    written += DP_write_bigendian_uint32(mpi->h, data + written);
    written += write_bytes(mpi->image, mpi->image_size, data + written);
    DP_ASSERT(written == msg_put_image_payload_length(msg));
    return written;
}

static size_t msg_put_image_serialize_payload_compat(DP_Message *msg,
                                                     unsigned char *data)
{
    DP_MsgPutImage *mpi = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(serialize_layer_id_compat(mpi->layer),
                                         data + written);
    written += DP_write_bigendian_uint8(DP_blend_mode_to_compatible(mpi->mode),
                                        data + written);
    written += DP_write_bigendian_uint32(mpi->x, data + written);
    written += DP_write_bigendian_uint32(mpi->y, data + written);
    written += DP_write_bigendian_uint32(mpi->w, data + written);
    written += DP_write_bigendian_uint32(mpi->h, data + written);
    written += write_bytes(mpi->image, mpi->image_size, data + written);
    DP_ASSERT(written == msg_put_image_payload_length_compat(msg));
    return written;
}

static bool msg_put_image_write_payload_text(DP_Message *msg,
                                             DP_TextWriter *writer)
{
    DP_MsgPutImage *mpi = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "h", mpi->h)
        && DP_text_writer_write_base64(writer, "image", mpi->image,
                                       mpi->image_size)
        && DP_text_writer_write_uint(writer, "layer", mpi->layer)
        && DP_text_writer_write_blend_mode(writer, "mode", mpi->mode)
        && DP_text_writer_write_uint(writer, "w", mpi->w)
        && DP_text_writer_write_uint(writer, "x", mpi->x)
        && DP_text_writer_write_uint(writer, "y", mpi->y);
}

static bool msg_put_image_equals(DP_Message *DP_RESTRICT msg,
                                 DP_Message *DP_RESTRICT other)
{
    DP_MsgPutImage *a = DP_message_internal(msg);
    DP_MsgPutImage *b = DP_message_internal(other);
    return a->layer == b->layer && a->mode == b->mode && a->x == b->x
        && a->y == b->y && a->w == b->w && a->h == b->h
        && a->image_size == b->image_size
        && memcmp(a->image, b->image, DP_uint16_to_size(a->image_size)) == 0;
}

void DP_msg_put_image_local_match_set(DP_UNUSED size_t size,
                                      unsigned char *data, void *user)
{
    DP_ASSERT(size == DP_MSG_PUT_IMAGE_MATCH_LENGTH);
    const DP_MsgPutImage *mpi = user;
    size_t written = 0;
    written += DP_write_bigendian_uint24(mpi->layer, data + written);
    written += DP_write_bigendian_uint8(mpi->mode, data + written);
    written += DP_write_bigendian_uint32(mpi->x, data + written);
    written += DP_write_bigendian_uint32(mpi->y, data + written);
    written += DP_write_bigendian_uint32(mpi->w, data + written);
    written += DP_write_bigendian_uint32(mpi->h, data + written);
    written += DP_write_bigendian_uint16(mpi->image_size, data + written);
    DP_ASSERT(written == DP_MSG_PUT_IMAGE_MATCH_LENGTH);
}

bool DP_msg_put_image_local_match_matches(const DP_MsgPutImage *mpi,
                                          DP_Message *local_match_msg)
{
    size_t size;
    const unsigned char *buffer = local_match_data(local_match_msg, &size);
    size_t read = 0;
    return size == DP_MSG_PUT_IMAGE_MATCH_LENGTH
        && read_uint24(buffer + read, &read) == mpi->layer
        && read_uint8(buffer + read, &read) == mpi->mode
        && read_uint32(buffer + read, &read) == mpi->x
        && read_uint32(buffer + read, &read) == mpi->y
        && read_uint32(buffer + read, &read) == mpi->w
        && read_uint32(buffer + read, &read) == mpi->h
        && read_uint16(buffer + read, &read) == mpi->image_size;
}

static const DP_MessageMethods msg_put_image_methods = {
    msg_put_image_payload_length,        msg_put_image_serialize_payload,
    msg_put_image_payload_length_compat, msg_put_image_serialize_payload_compat,
    msg_put_image_write_payload_text,    msg_put_image_equals,
};

DP_Message *
DP_msg_put_image_new(unsigned int context_id, uint32_t layer, uint8_t mode,
                     uint32_t x, uint32_t y, uint32_t w, uint32_t h,
                     void (*set_image)(size_t, unsigned char *, void *),
                     size_t image_size, void *image_user)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_PUT_IMAGE, context_id, &msg_put_image_methods,
                       DP_FLEX_SIZEOF(DP_MsgPutImage, image, image_size));
    DP_MsgPutImage *mpi = DP_message_internal(msg);
    mpi->layer = layer;
    mpi->mode = mode;
    mpi->x = x;
    mpi->y = y;
    mpi->w = w;
    mpi->h = h;
    mpi->image_size = DP_size_to_uint16(image_size);
    if (set_image) {
        set_image(mpi->image_size, mpi->image, image_user);
    }
    return msg;
}

DP_Message *DP_msg_put_image_deserialize(unsigned int context_id,
                                         const unsigned char *buffer,
                                         size_t length)
{
    if (length < 20 || length > 65535) {
        DP_error_set("Wrong length for putimage message; "
                     "expected between 20 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint32_t layer = read_uint24(buffer + read, &read);
    uint8_t mode = read_uint8(buffer + read, &read);
    uint32_t x = read_uint32(buffer + read, &read);
    uint32_t y = read_uint32(buffer + read, &read);
    uint32_t w = read_uint32(buffer + read, &read);
    uint32_t h = read_uint32(buffer + read, &read);
    size_t image_bytes = length - read;
    uint16_t image_size = DP_size_to_uint16(image_bytes);
    void *image_user = (void *)(buffer + read);
    return DP_msg_put_image_new(context_id, layer, mode, x, y, w, h, read_bytes,
                                image_size, image_user);
}

DP_Message *DP_msg_put_image_deserialize_compat(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length)
{
    if (length < 19 || length > 65535) {
        DP_error_set("Wrong length for putimage compat message; "
                     "expected between 19 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t layer = read_uint16(buffer + read, &read);
    uint8_t mode = read_uint8(buffer + read, &read);
    uint32_t x = read_uint32(buffer + read, &read);
    uint32_t y = read_uint32(buffer + read, &read);
    uint32_t w = read_uint32(buffer + read, &read);
    uint32_t h = read_uint32(buffer + read, &read);
    size_t image_bytes = length - read;
    uint16_t image_size = DP_size_to_uint16(image_bytes);
    void *image_user = (void *)(buffer + read);
    DP_Message *msg =
        DP_msg_put_image_new(context_id, deserialize_layer_id_compat(layer),
                             DP_blend_mode_to_compatible(mode), x, y, w, h,
                             read_bytes, image_size, image_user);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_put_image_parse(unsigned int context_id,
                                   DP_TextReader *reader)
{
    uint32_t layer =
        (uint32_t)DP_text_reader_get_ulong(reader, "layer", DP_UINT24_MAX);
    uint8_t mode = DP_text_reader_get_blend_mode(reader, "mode");
    uint32_t x = (uint32_t)DP_text_reader_get_ulong(reader, "x", UINT32_MAX);
    uint32_t y = (uint32_t)DP_text_reader_get_ulong(reader, "y", UINT32_MAX);
    uint32_t w = (uint32_t)DP_text_reader_get_ulong(reader, "w", UINT32_MAX);
    uint32_t h = (uint32_t)DP_text_reader_get_ulong(reader, "h", UINT32_MAX);
    size_t image_size;
    DP_TextReaderParseParams image_params =
        DP_text_reader_get_base64_string(reader, "image", &image_size);
    return DP_msg_put_image_new(context_id, layer, mode, x, y, w, h,
                                DP_text_reader_parse_base64, image_size,
                                &image_params);
}

DP_MsgPutImage *DP_msg_put_image_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_PUT_IMAGE);
}

uint32_t DP_msg_put_image_layer(const DP_MsgPutImage *mpi)
{
    DP_ASSERT(mpi);
    return mpi->layer;
}

uint8_t DP_msg_put_image_mode(const DP_MsgPutImage *mpi)
{
    DP_ASSERT(mpi);
    return mpi->mode;
}

uint32_t DP_msg_put_image_x(const DP_MsgPutImage *mpi)
{
    DP_ASSERT(mpi);
    return mpi->x;
}

uint32_t DP_msg_put_image_y(const DP_MsgPutImage *mpi)
{
    DP_ASSERT(mpi);
    return mpi->y;
}

uint32_t DP_msg_put_image_w(const DP_MsgPutImage *mpi)
{
    DP_ASSERT(mpi);
    return mpi->w;
}

uint32_t DP_msg_put_image_h(const DP_MsgPutImage *mpi)
{
    DP_ASSERT(mpi);
    return mpi->h;
}

const unsigned char *DP_msg_put_image_image(const DP_MsgPutImage *mpi,
                                            size_t *out_size)
{
    DP_ASSERT(mpi);
    if (out_size) {
        *out_size = mpi->image_size;
    }
    return mpi->image;
}

size_t DP_msg_put_image_image_size(const DP_MsgPutImage *mpi)
{
    return mpi->image_size;
}


/* DP_MSG_FILL_RECT */

struct DP_MsgFillRect {
    uint32_t layer;
    uint8_t mode;
    uint32_t x;
    uint32_t y;
    uint32_t w;
    uint32_t h;
    uint32_t color;
};

static size_t msg_fill_rect_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)24);
}

static size_t msg_fill_rect_payload_length_compat(DP_UNUSED DP_Message *msg)
{
    return ((size_t)23);
}

static size_t msg_fill_rect_serialize_payload(DP_Message *msg,
                                              unsigned char *data)
{
    DP_MsgFillRect *mfr = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint24(mfr->layer, data + written);
    written += DP_write_bigendian_uint8(mfr->mode, data + written);
    written += DP_write_bigendian_uint32(mfr->x, data + written);
    written += DP_write_bigendian_uint32(mfr->y, data + written);
    written += DP_write_bigendian_uint32(mfr->w, data + written);
    written += DP_write_bigendian_uint32(mfr->h, data + written);
    written += DP_write_bigendian_uint32(mfr->color, data + written);
    DP_ASSERT(written == msg_fill_rect_payload_length(msg));
    return written;
}

static size_t msg_fill_rect_serialize_payload_compat(DP_Message *msg,
                                                     unsigned char *data)
{
    DP_MsgFillRect *mfr = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(serialize_layer_id_compat(mfr->layer),
                                         data + written);
    written += DP_write_bigendian_uint8(DP_blend_mode_to_compatible(mfr->mode),
                                        data + written);
    written += DP_write_bigendian_uint32(mfr->x, data + written);
    written += DP_write_bigendian_uint32(mfr->y, data + written);
    written += DP_write_bigendian_uint32(mfr->w, data + written);
    written += DP_write_bigendian_uint32(mfr->h, data + written);
    written += DP_write_bigendian_uint32(mfr->color, data + written);
    DP_ASSERT(written == msg_fill_rect_payload_length_compat(msg));
    return written;
}

static bool msg_fill_rect_write_payload_text(DP_Message *msg,
                                             DP_TextWriter *writer)
{
    DP_MsgFillRect *mfr = DP_message_internal(msg);
    return DP_text_writer_write_argb_color(writer, "color", mfr->color)
        && DP_text_writer_write_uint(writer, "h", mfr->h)
        && DP_text_writer_write_uint(writer, "layer", mfr->layer)
        && DP_text_writer_write_blend_mode(writer, "mode", mfr->mode)
        && DP_text_writer_write_uint(writer, "w", mfr->w)
        && DP_text_writer_write_uint(writer, "x", mfr->x)
        && DP_text_writer_write_uint(writer, "y", mfr->y);
}

static bool msg_fill_rect_equals(DP_Message *DP_RESTRICT msg,
                                 DP_Message *DP_RESTRICT other)
{
    DP_MsgFillRect *a = DP_message_internal(msg);
    DP_MsgFillRect *b = DP_message_internal(other);
    return a->layer == b->layer && a->mode == b->mode && a->x == b->x
        && a->y == b->y && a->w == b->w && a->h == b->h && a->color == b->color;
}

void DP_msg_fill_rect_local_match_set(DP_UNUSED size_t size,
                                      unsigned char *data, void *user)
{
    DP_ASSERT(size == DP_MSG_FILL_RECT_MATCH_LENGTH);
    const DP_MsgFillRect *mfr = user;
    size_t written = 0;
    written += DP_write_bigendian_uint24(mfr->layer, data + written);
    written += DP_write_bigendian_uint8(mfr->mode, data + written);
    written += DP_write_bigendian_uint32(mfr->x, data + written);
    written += DP_write_bigendian_uint32(mfr->y, data + written);
    written += DP_write_bigendian_uint32(mfr->w, data + written);
    written += DP_write_bigendian_uint32(mfr->h, data + written);
    written += DP_write_bigendian_uint32(mfr->color, data + written);
    DP_ASSERT(written == DP_MSG_FILL_RECT_MATCH_LENGTH);
}

bool DP_msg_fill_rect_local_match_matches(const DP_MsgFillRect *mfr,
                                          DP_Message *local_match_msg)
{
    size_t size;
    const unsigned char *buffer = local_match_data(local_match_msg, &size);
    size_t read = 0;
    return size == DP_MSG_FILL_RECT_MATCH_LENGTH
        && read_uint24(buffer + read, &read) == mfr->layer
        && read_uint8(buffer + read, &read) == mfr->mode
        && read_uint32(buffer + read, &read) == mfr->x
        && read_uint32(buffer + read, &read) == mfr->y
        && read_uint32(buffer + read, &read) == mfr->w
        && read_uint32(buffer + read, &read) == mfr->h
        && read_uint32(buffer + read, &read) == mfr->color;
}

static const DP_MessageMethods msg_fill_rect_methods = {
    msg_fill_rect_payload_length,        msg_fill_rect_serialize_payload,
    msg_fill_rect_payload_length_compat, msg_fill_rect_serialize_payload_compat,
    msg_fill_rect_write_payload_text,    msg_fill_rect_equals,
};

DP_Message *DP_msg_fill_rect_new(unsigned int context_id, uint32_t layer,
                                 uint8_t mode, uint32_t x, uint32_t y,
                                 uint32_t w, uint32_t h, uint32_t color)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_FILL_RECT, context_id, &msg_fill_rect_methods,
                       sizeof(DP_MsgFillRect));
    DP_MsgFillRect *mfr = DP_message_internal(msg);
    mfr->layer = layer;
    mfr->mode = mode;
    mfr->x = x;
    mfr->y = y;
    mfr->w = w;
    mfr->h = h;
    mfr->color = color;
    return msg;
}

DP_Message *DP_msg_fill_rect_deserialize(unsigned int context_id,
                                         const unsigned char *buffer,
                                         size_t length)
{
    if (length != 24) {
        DP_error_set("Wrong length for fillrect message; "
                     "expected 24, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint32_t layer = read_uint24(buffer + read, &read);
    uint8_t mode = read_uint8(buffer + read, &read);
    uint32_t x = read_uint32(buffer + read, &read);
    uint32_t y = read_uint32(buffer + read, &read);
    uint32_t w = read_uint32(buffer + read, &read);
    uint32_t h = read_uint32(buffer + read, &read);
    uint32_t color = read_uint32(buffer + read, &read);
    return DP_msg_fill_rect_new(context_id, layer, mode, x, y, w, h, color);
}

DP_Message *DP_msg_fill_rect_deserialize_compat(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length)
{
    if (length != 23) {
        DP_error_set("Wrong length for fillrect compat message; "
                     "expected 23, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t layer = read_uint16(buffer + read, &read);
    uint8_t mode = read_uint8(buffer + read, &read);
    uint32_t x = read_uint32(buffer + read, &read);
    uint32_t y = read_uint32(buffer + read, &read);
    uint32_t w = read_uint32(buffer + read, &read);
    uint32_t h = read_uint32(buffer + read, &read);
    uint32_t color = read_uint32(buffer + read, &read);
    DP_Message *msg = DP_msg_fill_rect_new(
        context_id, deserialize_layer_id_compat(layer),
        DP_blend_mode_to_compatible(mode), x, y, w, h, color);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_fill_rect_parse(unsigned int context_id,
                                   DP_TextReader *reader)
{
    uint32_t layer =
        (uint32_t)DP_text_reader_get_ulong(reader, "layer", DP_UINT24_MAX);
    uint8_t mode = DP_text_reader_get_blend_mode(reader, "mode");
    uint32_t x = (uint32_t)DP_text_reader_get_ulong(reader, "x", UINT32_MAX);
    uint32_t y = (uint32_t)DP_text_reader_get_ulong(reader, "y", UINT32_MAX);
    uint32_t w = (uint32_t)DP_text_reader_get_ulong(reader, "w", UINT32_MAX);
    uint32_t h = (uint32_t)DP_text_reader_get_ulong(reader, "h", UINT32_MAX);
    uint32_t color = DP_text_reader_get_argb_color(reader, "color");
    return DP_msg_fill_rect_new(context_id, layer, mode, x, y, w, h, color);
}

DP_MsgFillRect *DP_msg_fill_rect_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_FILL_RECT);
}

uint32_t DP_msg_fill_rect_layer(const DP_MsgFillRect *mfr)
{
    DP_ASSERT(mfr);
    return mfr->layer;
}

uint8_t DP_msg_fill_rect_mode(const DP_MsgFillRect *mfr)
{
    DP_ASSERT(mfr);
    return mfr->mode;
}

uint32_t DP_msg_fill_rect_x(const DP_MsgFillRect *mfr)
{
    DP_ASSERT(mfr);
    return mfr->x;
}

uint32_t DP_msg_fill_rect_y(const DP_MsgFillRect *mfr)
{
    DP_ASSERT(mfr);
    return mfr->y;
}

uint32_t DP_msg_fill_rect_w(const DP_MsgFillRect *mfr)
{
    DP_ASSERT(mfr);
    return mfr->w;
}

uint32_t DP_msg_fill_rect_h(const DP_MsgFillRect *mfr)
{
    DP_ASSERT(mfr);
    return mfr->h;
}

uint32_t DP_msg_fill_rect_color(const DP_MsgFillRect *mfr)
{
    DP_ASSERT(mfr);
    return mfr->color;
}


/* DP_MSG_PEN_UP */

struct DP_MsgPenUp {
    uint32_t layer;
};

static size_t msg_pen_up_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)3);
}

static size_t msg_pen_up_serialize_payload(DP_Message *msg, unsigned char *data)
{
    DP_MsgPenUp *mpu = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint24(mpu->layer, data + written);
    DP_ASSERT(written == msg_pen_up_payload_length(msg));
    return written;
}

static bool msg_pen_up_write_payload_text(DP_Message *msg,
                                          DP_TextWriter *writer)
{
    DP_MsgPenUp *mpu = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "layer", mpu->layer);
}

static bool msg_pen_up_equals(DP_Message *DP_RESTRICT msg,
                              DP_Message *DP_RESTRICT other)
{
    DP_MsgPenUp *a = DP_message_internal(msg);
    DP_MsgPenUp *b = DP_message_internal(other);
    return a->layer == b->layer;
}

static const DP_MessageMethods msg_pen_up_methods = {
    msg_pen_up_payload_length,     msg_pen_up_serialize_payload,
    zero_length_payload_length,    zero_length_serialize_payload,
    msg_pen_up_write_payload_text, msg_pen_up_equals,
};

DP_Message *DP_msg_pen_up_new(unsigned int context_id, uint32_t layer)
{
    DP_Message *msg = DP_message_new(DP_MSG_PEN_UP, context_id,
                                     &msg_pen_up_methods, sizeof(DP_MsgPenUp));
    DP_MsgPenUp *mpu = DP_message_internal(msg);
    mpu->layer = layer;
    return msg;
}

DP_Message *DP_msg_pen_up_deserialize(unsigned int context_id,
                                      const unsigned char *buffer,
                                      size_t length)
{
    if (length != 3) {
        DP_error_set("Wrong length for penup message; "
                     "expected 3, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint32_t layer = read_uint24(buffer + read, &read);
    return DP_msg_pen_up_new(context_id, layer);
}

DP_Message *
DP_msg_pen_up_deserialize_compat(unsigned int context_id,
                                 DP_UNUSED const unsigned char *buffer,
                                 size_t length)
{
    if (length != 0) {
        DP_error_set("Wrong length for penup compat message; "
                     "expected 0, got %zu",
                     length);
        return NULL;
    }
    DP_Message *msg = DP_msg_pen_up_new(context_id, 0);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_pen_up_parse(unsigned int context_id, DP_TextReader *reader)
{
    uint32_t layer =
        (uint32_t)DP_text_reader_get_ulong(reader, "layer", DP_UINT24_MAX);
    return DP_msg_pen_up_new(context_id, layer);
}

DP_MsgPenUp *DP_msg_pen_up_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_PEN_UP);
}

uint32_t DP_msg_pen_up_layer(const DP_MsgPenUp *mpu)
{
    DP_ASSERT(mpu);
    return mpu->layer;
}


/* DP_MSG_ANNOTATION_CREATE */

struct DP_MsgAnnotationCreate {
    uint16_t id;
    int32_t x;
    int32_t y;
    uint16_t w;
    uint16_t h;
};

static size_t msg_annotation_create_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)14);
}

static size_t
msg_annotation_create_payload_length_compat(DP_UNUSED DP_Message *msg)
{
    return ((size_t)14);
}

static size_t msg_annotation_create_serialize_payload(DP_Message *msg,
                                                      unsigned char *data)
{
    DP_MsgAnnotationCreate *mac = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(mac->id, data + written);
    written += DP_write_bigendian_int32(mac->x, data + written);
    written += DP_write_bigendian_int32(mac->y, data + written);
    written += DP_write_bigendian_uint16(mac->w, data + written);
    written += DP_write_bigendian_uint16(mac->h, data + written);
    DP_ASSERT(written == msg_annotation_create_payload_length(msg));
    return written;
}

static size_t
msg_annotation_create_serialize_payload_compat(DP_Message *msg,
                                               unsigned char *data)
{
    DP_MsgAnnotationCreate *mac = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(convert_other_id_compat(mac->id),
                                         data + written);
    written += DP_write_bigendian_int32(mac->x, data + written);
    written += DP_write_bigendian_int32(mac->y, data + written);
    written += DP_write_bigendian_uint16(mac->w, data + written);
    written += DP_write_bigendian_uint16(mac->h, data + written);
    DP_ASSERT(written == msg_annotation_create_payload_length_compat(msg));
    return written;
}

static bool msg_annotation_create_write_payload_text(DP_Message *msg,
                                                     DP_TextWriter *writer)
{
    DP_MsgAnnotationCreate *mac = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "h", mac->h)
        && DP_text_writer_write_uint(writer, "id", mac->id)
        && DP_text_writer_write_uint(writer, "w", mac->w)
        && DP_text_writer_write_int(writer, "x", mac->x)
        && DP_text_writer_write_int(writer, "y", mac->y);
}

static bool msg_annotation_create_equals(DP_Message *DP_RESTRICT msg,
                                         DP_Message *DP_RESTRICT other)
{
    DP_MsgAnnotationCreate *a = DP_message_internal(msg);
    DP_MsgAnnotationCreate *b = DP_message_internal(other);
    return a->id == b->id && a->x == b->x && a->y == b->y && a->w == b->w
        && a->h == b->h;
}

static const DP_MessageMethods msg_annotation_create_methods = {
    msg_annotation_create_payload_length,
    msg_annotation_create_serialize_payload,
    msg_annotation_create_payload_length_compat,
    msg_annotation_create_serialize_payload_compat,
    msg_annotation_create_write_payload_text,
    msg_annotation_create_equals,
};

DP_Message *DP_msg_annotation_create_new(unsigned int context_id, uint16_t id,
                                         int32_t x, int32_t y, uint16_t w,
                                         uint16_t h)
{
    DP_Message *msg = DP_message_new(DP_MSG_ANNOTATION_CREATE, context_id,
                                     &msg_annotation_create_methods,
                                     sizeof(DP_MsgAnnotationCreate));
    DP_MsgAnnotationCreate *mac = DP_message_internal(msg);
    mac->id = id;
    mac->x = x;
    mac->y = y;
    mac->w = w;
    mac->h = h;
    return msg;
}

DP_Message *DP_msg_annotation_create_deserialize(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length)
{
    if (length != 14) {
        DP_error_set("Wrong length for newannotation message; "
                     "expected 14, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    int32_t x = read_int32(buffer + read, &read);
    int32_t y = read_int32(buffer + read, &read);
    uint16_t w = read_uint16(buffer + read, &read);
    uint16_t h = read_uint16(buffer + read, &read);
    return DP_msg_annotation_create_new(context_id, id, x, y, w, h);
}

DP_Message *DP_msg_annotation_create_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length != 14) {
        DP_error_set("Wrong length for newannotation compat message; "
                     "expected 14, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    int32_t x = read_int32(buffer + read, &read);
    int32_t y = read_int32(buffer + read, &read);
    uint16_t w = read_uint16(buffer + read, &read);
    uint16_t h = read_uint16(buffer + read, &read);
    DP_Message *msg = DP_msg_annotation_create_new(
        context_id, convert_other_id_compat(id), x, y, w, h);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_annotation_create_parse(unsigned int context_id,
                                           DP_TextReader *reader)
{
    uint16_t id = (uint16_t)DP_text_reader_get_ulong(reader, "id", UINT16_MAX);
    int32_t x =
        (int32_t)DP_text_reader_get_long(reader, "x", INT32_MIN, INT32_MAX);
    int32_t y =
        (int32_t)DP_text_reader_get_long(reader, "y", INT32_MIN, INT32_MAX);
    uint16_t w = (uint16_t)DP_text_reader_get_ulong(reader, "w", UINT16_MAX);
    uint16_t h = (uint16_t)DP_text_reader_get_ulong(reader, "h", UINT16_MAX);
    return DP_msg_annotation_create_new(context_id, id, x, y, w, h);
}

DP_MsgAnnotationCreate *DP_msg_annotation_create_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_ANNOTATION_CREATE);
}

uint16_t DP_msg_annotation_create_id(const DP_MsgAnnotationCreate *mac)
{
    DP_ASSERT(mac);
    return mac->id;
}

int32_t DP_msg_annotation_create_x(const DP_MsgAnnotationCreate *mac)
{
    DP_ASSERT(mac);
    return mac->x;
}

int32_t DP_msg_annotation_create_y(const DP_MsgAnnotationCreate *mac)
{
    DP_ASSERT(mac);
    return mac->y;
}

uint16_t DP_msg_annotation_create_w(const DP_MsgAnnotationCreate *mac)
{
    DP_ASSERT(mac);
    return mac->w;
}

uint16_t DP_msg_annotation_create_h(const DP_MsgAnnotationCreate *mac)
{
    DP_ASSERT(mac);
    return mac->h;
}


/* DP_MSG_ANNOTATION_RESHAPE */

struct DP_MsgAnnotationReshape {
    uint16_t id;
    int32_t x;
    int32_t y;
    uint16_t w;
    uint16_t h;
};

static size_t msg_annotation_reshape_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)14);
}

static size_t
msg_annotation_reshape_payload_length_compat(DP_UNUSED DP_Message *msg)
{
    return ((size_t)14);
}

static size_t msg_annotation_reshape_serialize_payload(DP_Message *msg,
                                                       unsigned char *data)
{
    DP_MsgAnnotationReshape *mar = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(mar->id, data + written);
    written += DP_write_bigendian_int32(mar->x, data + written);
    written += DP_write_bigendian_int32(mar->y, data + written);
    written += DP_write_bigendian_uint16(mar->w, data + written);
    written += DP_write_bigendian_uint16(mar->h, data + written);
    DP_ASSERT(written == msg_annotation_reshape_payload_length(msg));
    return written;
}

static size_t
msg_annotation_reshape_serialize_payload_compat(DP_Message *msg,
                                                unsigned char *data)
{
    DP_MsgAnnotationReshape *mar = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(convert_other_id_compat(mar->id),
                                         data + written);
    written += DP_write_bigendian_int32(mar->x, data + written);
    written += DP_write_bigendian_int32(mar->y, data + written);
    written += DP_write_bigendian_uint16(mar->w, data + written);
    written += DP_write_bigendian_uint16(mar->h, data + written);
    DP_ASSERT(written == msg_annotation_reshape_payload_length_compat(msg));
    return written;
}

static bool msg_annotation_reshape_write_payload_text(DP_Message *msg,
                                                      DP_TextWriter *writer)
{
    DP_MsgAnnotationReshape *mar = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "h", mar->h)
        && DP_text_writer_write_uint(writer, "id", mar->id)
        && DP_text_writer_write_uint(writer, "w", mar->w)
        && DP_text_writer_write_int(writer, "x", mar->x)
        && DP_text_writer_write_int(writer, "y", mar->y);
}

static bool msg_annotation_reshape_equals(DP_Message *DP_RESTRICT msg,
                                          DP_Message *DP_RESTRICT other)
{
    DP_MsgAnnotationReshape *a = DP_message_internal(msg);
    DP_MsgAnnotationReshape *b = DP_message_internal(other);
    return a->id == b->id && a->x == b->x && a->y == b->y && a->w == b->w
        && a->h == b->h;
}

static const DP_MessageMethods msg_annotation_reshape_methods = {
    msg_annotation_reshape_payload_length,
    msg_annotation_reshape_serialize_payload,
    msg_annotation_reshape_payload_length_compat,
    msg_annotation_reshape_serialize_payload_compat,
    msg_annotation_reshape_write_payload_text,
    msg_annotation_reshape_equals,
};

DP_Message *DP_msg_annotation_reshape_new(unsigned int context_id, uint16_t id,
                                          int32_t x, int32_t y, uint16_t w,
                                          uint16_t h)
{
    DP_Message *msg = DP_message_new(DP_MSG_ANNOTATION_RESHAPE, context_id,
                                     &msg_annotation_reshape_methods,
                                     sizeof(DP_MsgAnnotationReshape));
    DP_MsgAnnotationReshape *mar = DP_message_internal(msg);
    mar->id = id;
    mar->x = x;
    mar->y = y;
    mar->w = w;
    mar->h = h;
    return msg;
}

DP_Message *DP_msg_annotation_reshape_deserialize(unsigned int context_id,
                                                  const unsigned char *buffer,
                                                  size_t length)
{
    if (length != 14) {
        DP_error_set("Wrong length for reshapeannotation message; "
                     "expected 14, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    int32_t x = read_int32(buffer + read, &read);
    int32_t y = read_int32(buffer + read, &read);
    uint16_t w = read_uint16(buffer + read, &read);
    uint16_t h = read_uint16(buffer + read, &read);
    return DP_msg_annotation_reshape_new(context_id, id, x, y, w, h);
}

DP_Message *DP_msg_annotation_reshape_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length != 14) {
        DP_error_set("Wrong length for reshapeannotation compat message; "
                     "expected 14, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    int32_t x = read_int32(buffer + read, &read);
    int32_t y = read_int32(buffer + read, &read);
    uint16_t w = read_uint16(buffer + read, &read);
    uint16_t h = read_uint16(buffer + read, &read);
    DP_Message *msg = DP_msg_annotation_reshape_new(
        context_id, convert_other_id_compat(id), x, y, w, h);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_annotation_reshape_parse(unsigned int context_id,
                                            DP_TextReader *reader)
{
    uint16_t id = (uint16_t)DP_text_reader_get_ulong(reader, "id", UINT16_MAX);
    int32_t x =
        (int32_t)DP_text_reader_get_long(reader, "x", INT32_MIN, INT32_MAX);
    int32_t y =
        (int32_t)DP_text_reader_get_long(reader, "y", INT32_MIN, INT32_MAX);
    uint16_t w = (uint16_t)DP_text_reader_get_ulong(reader, "w", UINT16_MAX);
    uint16_t h = (uint16_t)DP_text_reader_get_ulong(reader, "h", UINT16_MAX);
    return DP_msg_annotation_reshape_new(context_id, id, x, y, w, h);
}

DP_MsgAnnotationReshape *DP_msg_annotation_reshape_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_ANNOTATION_RESHAPE);
}

uint16_t DP_msg_annotation_reshape_id(const DP_MsgAnnotationReshape *mar)
{
    DP_ASSERT(mar);
    return mar->id;
}

int32_t DP_msg_annotation_reshape_x(const DP_MsgAnnotationReshape *mar)
{
    DP_ASSERT(mar);
    return mar->x;
}

int32_t DP_msg_annotation_reshape_y(const DP_MsgAnnotationReshape *mar)
{
    DP_ASSERT(mar);
    return mar->y;
}

uint16_t DP_msg_annotation_reshape_w(const DP_MsgAnnotationReshape *mar)
{
    DP_ASSERT(mar);
    return mar->w;
}

uint16_t DP_msg_annotation_reshape_h(const DP_MsgAnnotationReshape *mar)
{
    DP_ASSERT(mar);
    return mar->h;
}


/* DP_MSG_ANNOTATION_EDIT */

const char *DP_msg_annotation_edit_flags_flag_name(unsigned int value)
{
    switch (value) {
    case DP_MSG_ANNOTATION_EDIT_FLAGS_PROTECT:
        return "protect";
    case DP_MSG_ANNOTATION_EDIT_FLAGS_VALIGN_CENTER:
        return "valign_center";
    case DP_MSG_ANNOTATION_EDIT_FLAGS_VALIGN_BOTTOM:
        return "valign_bottom";
    case DP_MSG_ANNOTATION_EDIT_FLAGS_ALIAS:
        return "alias";
    case DP_MSG_ANNOTATION_EDIT_FLAGS_RASTERIZE:
        return "rasterize";
    default:
        return NULL;
    }
}

struct DP_MsgAnnotationEdit {
    uint16_t id;
    uint32_t bg;
    uint8_t flags;
    uint8_t border;
    uint16_t text_len;
    char text[];
};

static size_t msg_annotation_edit_payload_length(DP_Message *msg)
{
    DP_MsgAnnotationEdit *mae = DP_message_internal(msg);
    return ((size_t)8) + DP_uint16_to_size(mae->text_len);
}

static size_t msg_annotation_edit_payload_length_compat(DP_Message *msg)
{
    DP_MsgAnnotationEdit *mae = DP_message_internal(msg);
    return ((size_t)8) + DP_uint16_to_size(mae->text_len);
}

static size_t msg_annotation_edit_serialize_payload(DP_Message *msg,
                                                    unsigned char *data)
{
    DP_MsgAnnotationEdit *mae = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(mae->id, data + written);
    written += DP_write_bigendian_uint32(mae->bg, data + written);
    written += DP_write_bigendian_uint8(mae->flags, data + written);
    written += DP_write_bigendian_uint8(mae->border, data + written);
    written += DP_write_bytes(mae->text, 1, mae->text_len, data + written);
    DP_ASSERT(written == msg_annotation_edit_payload_length(msg));
    return written;
}

static size_t msg_annotation_edit_serialize_payload_compat(DP_Message *msg,
                                                           unsigned char *data)
{
    DP_MsgAnnotationEdit *mae = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(convert_other_id_compat(mae->id),
                                         data + written);
    written += DP_write_bigendian_uint32(mae->bg, data + written);
    written +=
        DP_write_bigendian_uint8(mae->flags & (uint8_t)0x7, data + written);
    written += DP_write_bigendian_uint8(mae->border, data + written);
    written += DP_write_bytes(mae->text, 1, mae->text_len, data + written);
    DP_ASSERT(written == msg_annotation_edit_payload_length_compat(msg));
    return written;
}

static bool msg_annotation_edit_write_payload_text(DP_Message *msg,
                                                   DP_TextWriter *writer)
{
    DP_MsgAnnotationEdit *mae = DP_message_internal(msg);
    return DP_text_writer_write_argb_color(writer, "bg", mae->bg)
        && DP_text_writer_write_uint(writer, "border", mae->border)
        && DP_text_writer_write_flags(
               writer, "flags", mae->flags, 5,
               (const char *[]){"protect", "valign_center", "valign_bottom",
                                "alias", "rasterize"},
               (unsigned int[]){DP_MSG_ANNOTATION_EDIT_FLAGS_PROTECT,
                                DP_MSG_ANNOTATION_EDIT_FLAGS_VALIGN_CENTER,
                                DP_MSG_ANNOTATION_EDIT_FLAGS_VALIGN_BOTTOM,
                                DP_MSG_ANNOTATION_EDIT_FLAGS_ALIAS,
                                DP_MSG_ANNOTATION_EDIT_FLAGS_RASTERIZE})
        && DP_text_writer_write_uint(writer, "id", mae->id)
        && DP_text_writer_write_string(writer, "text", mae->text);
}

static bool msg_annotation_edit_equals(DP_Message *DP_RESTRICT msg,
                                       DP_Message *DP_RESTRICT other)
{
    DP_MsgAnnotationEdit *a = DP_message_internal(msg);
    DP_MsgAnnotationEdit *b = DP_message_internal(other);
    return a->id == b->id && a->bg == b->bg && a->flags == b->flags
        && a->border == b->border && a->text_len == b->text_len
        && memcmp(a->text, b->text, a->text_len) == 0;
}

static const DP_MessageMethods msg_annotation_edit_methods = {
    msg_annotation_edit_payload_length,
    msg_annotation_edit_serialize_payload,
    msg_annotation_edit_payload_length_compat,
    msg_annotation_edit_serialize_payload_compat,
    msg_annotation_edit_write_payload_text,
    msg_annotation_edit_equals,
};

DP_Message *DP_msg_annotation_edit_new(unsigned int context_id, uint16_t id,
                                       uint32_t bg, uint8_t flags,
                                       uint8_t border, const char *text_value,
                                       size_t text_len)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_ANNOTATION_EDIT, context_id, &msg_annotation_edit_methods,
        DP_FLEX_SIZEOF(DP_MsgAnnotationEdit, text, text_len + 1));
    DP_MsgAnnotationEdit *mae = DP_message_internal(msg);
    mae->id = id;
    mae->bg = bg;
    mae->flags = flags;
    mae->border = border;
    mae->text_len = DP_size_to_uint16(text_len);
    assign_string(mae->text, text_value, mae->text_len);
    return msg;
}

DP_Message *DP_msg_annotation_edit_deserialize(unsigned int context_id,
                                               const unsigned char *buffer,
                                               size_t length)
{
    if (length < 8 || length > 65535) {
        DP_error_set("Wrong length for editannotation message; "
                     "expected between 8 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    uint32_t bg = read_uint32(buffer + read, &read);
    uint8_t flags = read_uint8(buffer + read, &read);
    uint8_t border = read_uint8(buffer + read, &read);
    size_t text_bytes = length - read;
    uint16_t text_len = DP_size_to_uint16(text_bytes);
    const char *text = (const char *)buffer + read;
    return DP_msg_annotation_edit_new(context_id, id, bg, flags, border, text,
                                      text_len);
}

DP_Message *DP_msg_annotation_edit_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length < 8 || length > 65535) {
        DP_error_set("Wrong length for editannotation compat message; "
                     "expected between 8 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    uint32_t bg = read_uint32(buffer + read, &read);
    uint8_t flags = read_uint8(buffer + read, &read);
    uint8_t border = read_uint8(buffer + read, &read);
    size_t text_bytes = length - read;
    uint16_t text_len = DP_size_to_uint16(text_bytes);
    const char *text = (const char *)buffer + read;
    DP_Message *msg = DP_msg_annotation_edit_new(
        context_id, convert_other_id_compat(id), bg, flags & (uint8_t)0x7,
        border, text, text_len);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_annotation_edit_parse(unsigned int context_id,
                                         DP_TextReader *reader)
{
    uint16_t id = (uint16_t)DP_text_reader_get_ulong(reader, "id", UINT16_MAX);
    uint32_t bg = DP_text_reader_get_argb_color(reader, "bg");
    uint8_t flags = (uint8_t)DP_text_reader_get_flags(
        reader, "flags", 5,
        (const char *[]){"protect", "valign_center", "valign_bottom", "alias",
                         "rasterize"},
        (unsigned int[]){DP_MSG_ANNOTATION_EDIT_FLAGS_PROTECT,
                         DP_MSG_ANNOTATION_EDIT_FLAGS_VALIGN_CENTER,
                         DP_MSG_ANNOTATION_EDIT_FLAGS_VALIGN_BOTTOM,
                         DP_MSG_ANNOTATION_EDIT_FLAGS_ALIAS,
                         DP_MSG_ANNOTATION_EDIT_FLAGS_RASTERIZE});
    uint8_t border =
        (uint8_t)DP_text_reader_get_ulong(reader, "border", UINT8_MAX);
    uint16_t text_len;
    const char *text = DP_text_reader_get_string(reader, "text", &text_len);
    return DP_msg_annotation_edit_new(context_id, id, bg, flags, border, text,
                                      text_len);
}

DP_MsgAnnotationEdit *DP_msg_annotation_edit_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_ANNOTATION_EDIT);
}

uint16_t DP_msg_annotation_edit_id(const DP_MsgAnnotationEdit *mae)
{
    DP_ASSERT(mae);
    return mae->id;
}

uint32_t DP_msg_annotation_edit_bg(const DP_MsgAnnotationEdit *mae)
{
    DP_ASSERT(mae);
    return mae->bg;
}

uint8_t DP_msg_annotation_edit_flags(const DP_MsgAnnotationEdit *mae)
{
    DP_ASSERT(mae);
    return mae->flags;
}

uint8_t DP_msg_annotation_edit_border(const DP_MsgAnnotationEdit *mae)
{
    DP_ASSERT(mae);
    return mae->border;
}

const char *DP_msg_annotation_edit_text(const DP_MsgAnnotationEdit *mae,
                                        size_t *out_len)
{
    DP_ASSERT(mae);
    if (out_len) {
        *out_len = mae->text_len;
    }
    return mae->text;
}

size_t DP_msg_annotation_edit_text_len(const DP_MsgAnnotationEdit *mae)
{
    return mae->text_len;
}


/* DP_MSG_ANNOTATION_DELETE */

struct DP_MsgAnnotationDelete {
    uint16_t id;
};

static size_t msg_annotation_delete_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)2);
}

static size_t
msg_annotation_delete_payload_length_compat(DP_UNUSED DP_Message *msg)
{
    return ((size_t)2);
}

static size_t msg_annotation_delete_serialize_payload(DP_Message *msg,
                                                      unsigned char *data)
{
    DP_MsgAnnotationDelete *mad = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(mad->id, data + written);
    DP_ASSERT(written == msg_annotation_delete_payload_length(msg));
    return written;
}

static size_t
msg_annotation_delete_serialize_payload_compat(DP_Message *msg,
                                               unsigned char *data)
{
    DP_MsgAnnotationDelete *mad = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(convert_other_id_compat(mad->id),
                                         data + written);
    DP_ASSERT(written == msg_annotation_delete_payload_length_compat(msg));
    return written;
}

static bool msg_annotation_delete_write_payload_text(DP_Message *msg,
                                                     DP_TextWriter *writer)
{
    DP_MsgAnnotationDelete *mad = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "id", mad->id);
}

static bool msg_annotation_delete_equals(DP_Message *DP_RESTRICT msg,
                                         DP_Message *DP_RESTRICT other)
{
    DP_MsgAnnotationDelete *a = DP_message_internal(msg);
    DP_MsgAnnotationDelete *b = DP_message_internal(other);
    return a->id == b->id;
}

static const DP_MessageMethods msg_annotation_delete_methods = {
    msg_annotation_delete_payload_length,
    msg_annotation_delete_serialize_payload,
    msg_annotation_delete_payload_length_compat,
    msg_annotation_delete_serialize_payload_compat,
    msg_annotation_delete_write_payload_text,
    msg_annotation_delete_equals,
};

DP_Message *DP_msg_annotation_delete_new(unsigned int context_id, uint16_t id)
{
    DP_Message *msg = DP_message_new(DP_MSG_ANNOTATION_DELETE, context_id,
                                     &msg_annotation_delete_methods,
                                     sizeof(DP_MsgAnnotationDelete));
    DP_MsgAnnotationDelete *mad = DP_message_internal(msg);
    mad->id = id;
    return msg;
}

DP_Message *DP_msg_annotation_delete_deserialize(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length)
{
    if (length != 2) {
        DP_error_set("Wrong length for deleteannotation message; "
                     "expected 2, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    return DP_msg_annotation_delete_new(context_id, id);
}

DP_Message *DP_msg_annotation_delete_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length != 2) {
        DP_error_set("Wrong length for deleteannotation compat message; "
                     "expected 2, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    DP_Message *msg =
        DP_msg_annotation_delete_new(context_id, convert_other_id_compat(id));
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_annotation_delete_parse(unsigned int context_id,
                                           DP_TextReader *reader)
{
    uint16_t id = (uint16_t)DP_text_reader_get_ulong(reader, "id", UINT16_MAX);
    return DP_msg_annotation_delete_new(context_id, id);
}

DP_MsgAnnotationDelete *DP_msg_annotation_delete_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_ANNOTATION_DELETE);
}

uint16_t DP_msg_annotation_delete_id(const DP_MsgAnnotationDelete *mad)
{
    DP_ASSERT(mad);
    return mad->id;
}


/* DP_MSG_PUT_TILE */

struct DP_MsgPutTile {
    uint8_t user;
    uint32_t layer;
    uint8_t sublayer;
    uint16_t col;
    uint16_t row;
    uint16_t repeat;
    uint16_t image_size;
    unsigned char image[];
};

static size_t msg_put_tile_payload_length(DP_Message *msg)
{
    DP_MsgPutTile *mpt = DP_message_internal(msg);
    return ((size_t)11) + mpt->image_size;
}

static size_t msg_put_tile_payload_length_compat(DP_Message *msg)
{
    DP_MsgPutTile *mpt = DP_message_internal(msg);
    return ((size_t)9) + mpt->image_size;
}

static size_t msg_put_tile_serialize_payload(DP_Message *msg,
                                             unsigned char *data)
{
    DP_MsgPutTile *mpt = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(mpt->user, data + written);
    written += DP_write_bigendian_uint24(mpt->layer, data + written);
    written += DP_write_bigendian_uint8(mpt->sublayer, data + written);
    written += DP_write_bigendian_uint16(mpt->col, data + written);
    written += DP_write_bigendian_uint16(mpt->row, data + written);
    written += DP_write_bigendian_uint16(mpt->repeat, data + written);
    written += write_bytes(mpt->image, mpt->image_size, data + written);
    DP_ASSERT(written == msg_put_tile_payload_length(msg));
    return written;
}

static size_t msg_put_tile_serialize_payload_compat(DP_Message *msg,
                                                    unsigned char *data)
{
    DP_MsgPutTile *mpt = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(serialize_layer_id_compat(mpt->layer),
                                         data + written);
    written += DP_write_bigendian_uint8(mpt->sublayer, data + written);
    written += DP_write_bigendian_uint16(mpt->col, data + written);
    written += DP_write_bigendian_uint16(mpt->row, data + written);
    written += DP_write_bigendian_uint16(mpt->repeat, data + written);
    written += write_bytes(mpt->image, mpt->image_size, data + written);
    DP_ASSERT(written == msg_put_tile_payload_length_compat(msg));
    return written;
}

static bool msg_put_tile_write_payload_text(DP_Message *msg,
                                            DP_TextWriter *writer)
{
    DP_MsgPutTile *mpt = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "col", mpt->col)
        && DP_text_writer_write_base64(writer, "image", mpt->image,
                                       mpt->image_size)
        && DP_text_writer_write_uint(writer, "layer", mpt->layer)
        && DP_text_writer_write_uint(writer, "repeat", mpt->repeat)
        && DP_text_writer_write_uint(writer, "row", mpt->row)
        && DP_text_writer_write_uint(writer, "sublayer", mpt->sublayer)
        && DP_text_writer_write_uint(writer, "user", mpt->user);
}

static bool msg_put_tile_equals(DP_Message *DP_RESTRICT msg,
                                DP_Message *DP_RESTRICT other)
{
    DP_MsgPutTile *a = DP_message_internal(msg);
    DP_MsgPutTile *b = DP_message_internal(other);
    return a->user == b->user && a->layer == b->layer
        && a->sublayer == b->sublayer && a->col == b->col && a->row == b->row
        && a->repeat == b->repeat && a->image_size == b->image_size
        && memcmp(a->image, b->image, DP_uint16_to_size(a->image_size)) == 0;
}

static const DP_MessageMethods msg_put_tile_methods = {
    msg_put_tile_payload_length,        msg_put_tile_serialize_payload,
    msg_put_tile_payload_length_compat, msg_put_tile_serialize_payload_compat,
    msg_put_tile_write_payload_text,    msg_put_tile_equals,
};

DP_Message *DP_msg_put_tile_new(unsigned int context_id, uint8_t user,
                                uint32_t layer, uint8_t sublayer, uint16_t col,
                                uint16_t row, uint16_t repeat,
                                void (*set_image)(size_t, unsigned char *,
                                                  void *),
                                size_t image_size, void *image_user)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_PUT_TILE, context_id, &msg_put_tile_methods,
                       DP_FLEX_SIZEOF(DP_MsgPutTile, image, image_size));
    DP_MsgPutTile *mpt = DP_message_internal(msg);
    mpt->user = user;
    mpt->layer = layer;
    mpt->sublayer = sublayer;
    mpt->col = col;
    mpt->row = row;
    mpt->repeat = repeat;
    mpt->image_size = DP_size_to_uint16(image_size);
    if (set_image) {
        set_image(mpt->image_size, mpt->image, image_user);
    }
    return msg;
}

DP_Message *DP_msg_put_tile_deserialize(unsigned int context_id,
                                        const unsigned char *buffer,
                                        size_t length)
{
    if (length < 11 || length > 65535) {
        DP_error_set("Wrong length for puttile message; "
                     "expected between 11 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t user = read_uint8(buffer + read, &read);
    uint32_t layer = read_uint24(buffer + read, &read);
    uint8_t sublayer = read_uint8(buffer + read, &read);
    uint16_t col = read_uint16(buffer + read, &read);
    uint16_t row = read_uint16(buffer + read, &read);
    uint16_t repeat = read_uint16(buffer + read, &read);
    size_t image_bytes = length - read;
    uint16_t image_size = DP_size_to_uint16(image_bytes);
    void *image_user = (void *)(buffer + read);
    return DP_msg_put_tile_new(context_id, user, layer, sublayer, col, row,
                               repeat, read_bytes, image_size, image_user);
}

DP_Message *DP_msg_put_tile_deserialize_compat(unsigned int context_id,
                                               const unsigned char *buffer,
                                               size_t length)
{
    if (length < 9 || length > 65535) {
        DP_error_set("Wrong length for puttile compat message; "
                     "expected between 9 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t layer = read_uint16(buffer + read, &read);
    uint8_t sublayer = read_uint8(buffer + read, &read);
    uint16_t col = read_uint16(buffer + read, &read);
    uint16_t row = read_uint16(buffer + read, &read);
    uint16_t repeat = read_uint16(buffer + read, &read);
    size_t image_bytes = length - read;
    uint16_t image_size = DP_size_to_uint16(image_bytes);
    void *image_user = (void *)(buffer + read);
    DP_Message *msg = DP_msg_put_tile_new(
        context_id, 0, deserialize_layer_id_compat(layer), sublayer, col, row,
        repeat, read_bytes, image_size, image_user);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_put_tile_parse(unsigned int context_id,
                                  DP_TextReader *reader)
{
    uint8_t user = (uint8_t)DP_text_reader_get_ulong(reader, "user", UINT8_MAX);
    uint32_t layer =
        (uint32_t)DP_text_reader_get_ulong(reader, "layer", DP_UINT24_MAX);
    uint8_t sublayer =
        (uint8_t)DP_text_reader_get_ulong(reader, "sublayer", UINT8_MAX);
    uint16_t col =
        (uint16_t)DP_text_reader_get_ulong(reader, "col", UINT16_MAX);
    uint16_t row =
        (uint16_t)DP_text_reader_get_ulong(reader, "row", UINT16_MAX);
    uint16_t repeat =
        (uint16_t)DP_text_reader_get_ulong(reader, "repeat", UINT16_MAX);
    size_t image_size;
    DP_TextReaderParseParams image_params =
        DP_text_reader_get_base64_string(reader, "image", &image_size);
    return DP_msg_put_tile_new(context_id, user, layer, sublayer, col, row,
                               repeat, DP_text_reader_parse_base64, image_size,
                               &image_params);
}

DP_MsgPutTile *DP_msg_put_tile_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_PUT_TILE);
}

uint8_t DP_msg_put_tile_user(const DP_MsgPutTile *mpt)
{
    DP_ASSERT(mpt);
    return mpt->user;
}

uint32_t DP_msg_put_tile_layer(const DP_MsgPutTile *mpt)
{
    DP_ASSERT(mpt);
    return mpt->layer;
}

uint8_t DP_msg_put_tile_sublayer(const DP_MsgPutTile *mpt)
{
    DP_ASSERT(mpt);
    return mpt->sublayer;
}

uint16_t DP_msg_put_tile_col(const DP_MsgPutTile *mpt)
{
    DP_ASSERT(mpt);
    return mpt->col;
}

uint16_t DP_msg_put_tile_row(const DP_MsgPutTile *mpt)
{
    DP_ASSERT(mpt);
    return mpt->row;
}

uint16_t DP_msg_put_tile_repeat(const DP_MsgPutTile *mpt)
{
    DP_ASSERT(mpt);
    return mpt->repeat;
}

const unsigned char *DP_msg_put_tile_image(const DP_MsgPutTile *mpt,
                                           size_t *out_size)
{
    DP_ASSERT(mpt);
    if (out_size) {
        *out_size = mpt->image_size;
    }
    return mpt->image;
}

size_t DP_msg_put_tile_image_size(const DP_MsgPutTile *mpt)
{
    return mpt->image_size;
}


/* DP_MSG_CANVAS_BACKGROUND */

struct DP_MsgCanvasBackground {
    uint16_t image_size;
    unsigned char image[];
};

static size_t msg_canvas_background_payload_length(DP_Message *msg)
{
    DP_MsgCanvasBackground *mcb = DP_message_internal(msg);
    return mcb->image_size;
}

static size_t msg_canvas_background_serialize_payload(DP_Message *msg,
                                                      unsigned char *data)
{
    DP_MsgCanvasBackground *mcb = DP_message_internal(msg);
    size_t written = 0;
    written += write_bytes(mcb->image, mcb->image_size, data + written);
    DP_ASSERT(written == msg_canvas_background_payload_length(msg));
    return written;
}

static bool msg_canvas_background_write_payload_text(DP_Message *msg,
                                                     DP_TextWriter *writer)
{
    DP_MsgCanvasBackground *mcb = DP_message_internal(msg);
    return DP_text_writer_write_base64(writer, "image", mcb->image,
                                       mcb->image_size);
}

static bool msg_canvas_background_equals(DP_Message *DP_RESTRICT msg,
                                         DP_Message *DP_RESTRICT other)
{
    DP_MsgCanvasBackground *a = DP_message_internal(msg);
    DP_MsgCanvasBackground *b = DP_message_internal(other);
    return a->image_size == b->image_size
        && memcmp(a->image, b->image, DP_uint16_to_size(a->image_size)) == 0;
}

static const DP_MessageMethods msg_canvas_background_methods = {
    msg_canvas_background_payload_length,
    msg_canvas_background_serialize_payload,
    msg_canvas_background_payload_length,
    msg_canvas_background_serialize_payload,
    msg_canvas_background_write_payload_text,
    msg_canvas_background_equals,
};

DP_Message *
DP_msg_canvas_background_new(unsigned int context_id,
                             void (*set_image)(size_t, unsigned char *, void *),
                             size_t image_size, void *image_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_CANVAS_BACKGROUND, context_id, &msg_canvas_background_methods,
        DP_FLEX_SIZEOF(DP_MsgCanvasBackground, image, image_size));
    DP_MsgCanvasBackground *mcb = DP_message_internal(msg);
    mcb->image_size = DP_size_to_uint16(image_size);
    if (set_image) {
        set_image(mcb->image_size, mcb->image, image_user);
    }
    return msg;
}

DP_Message *DP_msg_canvas_background_deserialize(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length)
{
    if (length > 65535) {
        DP_error_set("Wrong length for background message; "
                     "expected between 0 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    size_t image_bytes = length - read;
    uint16_t image_size = DP_size_to_uint16(image_bytes);
    void *image_user = (void *)(buffer + read);
    return DP_msg_canvas_background_new(context_id, read_bytes, image_size,
                                        image_user);
}

DP_Message *DP_msg_canvas_background_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    DP_Message *msg =
        DP_msg_canvas_background_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_canvas_background_parse(unsigned int context_id,
                                           DP_TextReader *reader)
{
    size_t image_size;
    DP_TextReaderParseParams image_params =
        DP_text_reader_get_base64_string(reader, "image", &image_size);
    return DP_msg_canvas_background_new(context_id, DP_text_reader_parse_base64,
                                        image_size, &image_params);
}

DP_MsgCanvasBackground *DP_msg_canvas_background_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_CANVAS_BACKGROUND);
}

const unsigned char *
DP_msg_canvas_background_image(const DP_MsgCanvasBackground *mcb,
                               size_t *out_size)
{
    DP_ASSERT(mcb);
    if (out_size) {
        *out_size = mcb->image_size;
    }
    return mcb->image;
}

size_t DP_msg_canvas_background_image_size(const DP_MsgCanvasBackground *mcb)
{
    return mcb->image_size;
}


/* DP_MSG_DRAW_DABS_CLASSIC */

struct DP_ClassicDab {
    int8_t x;
    int8_t y;
    uint32_t size;
    uint8_t hardness;
    uint8_t opacity;
};

static size_t classic_dab_serialize_payload(DP_ClassicDab *cd,
                                            unsigned char *data)
{
    size_t written = 0;
    written += DP_write_bigendian_int8(cd->x, data + written);
    written += DP_write_bigendian_int8(cd->y, data + written);
    written += DP_write_bigendian_uint24(cd->size, data + written);
    written += DP_write_bigendian_uint8(cd->hardness, data + written);
    written += DP_write_bigendian_uint8(cd->opacity, data + written);
    return written;
}

static size_t classic_dab_serialize_payloads(DP_ClassicDab *cd, int count,
                                             unsigned char *data)
{
    size_t written = 0;
    for (int i = 0; i < count; ++i) {
        written += classic_dab_serialize_payload(&cd[i], data + written);
    }
    return written;
}

static bool classic_dab_write_payload_text(DP_ClassicDab *cd,
                                           DP_TextWriter *writer)
{
    return DP_text_writer_start_subobject(writer)
        && DP_text_writer_write_subfield_decimal(writer, "x",
                                                 (double)cd->x / 4.0)
        && DP_text_writer_write_subfield_decimal(writer, "y",
                                                 (double)cd->y / 4.0)
        && DP_text_writer_write_subfield_decimal(writer, "size",
                                                 (double)cd->size / 256.0)
        && DP_text_writer_write_subfield_uint(writer, "hardness", cd->hardness)
        && DP_text_writer_write_subfield_uint(writer, "opacity", cd->opacity)
        && DP_text_writer_finish_subobject(writer);
}

static size_t classic_dab_write_payload_texts(DP_ClassicDab *cd, int count,
                                              DP_TextWriter *writer)
{
    if (count != 0) {
        if (!DP_text_writer_start_subs(writer)) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (!classic_dab_write_payload_text(&cd[i], writer)) {
                return false;
            }
        }
        if (!DP_text_writer_finish_subs(writer)) {
            return false;
        }
    }
    return true;
}

static bool classic_dab_equals(DP_ClassicDab *DP_RESTRICT a,
                               DP_ClassicDab *DP_RESTRICT b)
{
    return a->x == b->x && a->y == b->y && a->size == b->size
        && a->hardness == b->hardness && a->opacity == b->opacity;
}

static bool classic_dabs_equal(DP_ClassicDab *DP_RESTRICT a,
                               DP_ClassicDab *DP_RESTRICT b, int count)
{
    for (int i = 0; i < count; ++i) {
        if (!classic_dab_equals(&a[i], &b[i])) {
            return false;
        }
    }
    return true;
}

void DP_classic_dab_init(DP_ClassicDab *cds, int i, int8_t x, int8_t y,
                         uint32_t size, uint8_t hardness, uint8_t opacity)
{
    DP_ASSERT(cds);
    DP_ClassicDab *cd = &cds[i];
    cd->x = x;
    cd->y = y;
    cd->size = size;
    cd->hardness = hardness;
    cd->opacity = opacity;
}

static void classic_dab_deserialize(int count, DP_ClassicDab *cds, void *user)
{
    const unsigned char *buffer = user;
    size_t read = 0;
    for (int i = 0; i < count; ++i) {
        int8_t x = read_int8(buffer + read, &read);
        int8_t y = read_int8(buffer + read, &read);
        uint32_t size = read_uint24(buffer + read, &read);
        uint8_t hardness = read_uint8(buffer + read, &read);
        uint8_t opacity = read_uint8(buffer + read, &read);
        DP_classic_dab_init(cds, i, x, y, size, hardness, opacity);
    }
}

static void classic_dab_parse(int count, DP_ClassicDab *cds, void *user)
{
    DP_TextReader *reader = user;
    for (int i = 0; i < count; ++i) {
        int8_t x = (int8_t)DP_text_reader_get_subfield_decimal(
            reader, i, "x", 4.0, INT8_MIN, INT8_MAX);
        int8_t y = (int8_t)DP_text_reader_get_subfield_decimal(
            reader, i, "y", 4.0, INT8_MIN, INT8_MAX);
        uint32_t size = (uint32_t)DP_text_reader_get_subfield_decimal(
            reader, i, "size", 256.0, 0, DP_UINT24_MAX);
        uint8_t hardness = (uint8_t)DP_text_reader_get_subfield_ulong(
            reader, i, "hardness", UINT8_MAX);
        uint8_t opacity = (uint8_t)DP_text_reader_get_subfield_ulong(
            reader, i, "opacity", UINT8_MAX);
        DP_classic_dab_init(cds, i, x, y, size, hardness, opacity);
    }
}

int8_t DP_classic_dab_x(const DP_ClassicDab *cd)
{
    DP_ASSERT(cd);
    return cd->x;
}

int8_t DP_classic_dab_y(const DP_ClassicDab *cd)
{
    DP_ASSERT(cd);
    return cd->y;
}

uint32_t DP_classic_dab_size(const DP_ClassicDab *cd)
{
    DP_ASSERT(cd);
    return cd->size;
}

uint8_t DP_classic_dab_hardness(const DP_ClassicDab *cd)
{
    DP_ASSERT(cd);
    return cd->hardness;
}

uint8_t DP_classic_dab_opacity(const DP_ClassicDab *cd)
{
    DP_ASSERT(cd);
    return cd->opacity;
}

const DP_ClassicDab *DP_classic_dab_at(const DP_ClassicDab *cd, int i)
{
    DP_ASSERT(cd);
    return &cd[i];
}

static size_t classic_dab_serialize_payload_compat(DP_ClassicDab *cd,
                                                   unsigned char *data)
{
    size_t written = 0;
    written += DP_write_bigendian_int8(cd->x, data + written);
    written += DP_write_bigendian_int8(cd->y, data + written);
    written += DP_write_bigendian_uint16(DP_uint32_to_uint16(cd->size),
                                         data + written);
    written += DP_write_bigendian_uint8(cd->hardness, data + written);
    written += DP_write_bigendian_uint8(cd->opacity, data + written);
    return written;
}

static size_t classic_dab_serialize_payloads_compat(DP_ClassicDab *cd,
                                                    int count,
                                                    unsigned char *data)
{
    size_t written = 0;
    for (int i = 0; i < count; ++i) {
        written += classic_dab_serialize_payload_compat(&cd[i], data + written);
    }
    return written;
}

static void classic_dab_deserialize_compat(int count, DP_ClassicDab *cds,
                                           void *user)
{
    const unsigned char *buffer = user;
    size_t read = 0;
    for (int i = 0; i < count; ++i) {
        int8_t x = read_int8(buffer + read, &read);
        int8_t y = read_int8(buffer + read, &read);
        uint16_t size = read_uint16(buffer + read, &read);
        uint8_t hardness = read_uint8(buffer + read, &read);
        uint8_t opacity = read_uint8(buffer + read, &read);
        DP_classic_dab_init(cds, i, x, y, DP_uint16_to_uint32(size), hardness,
                            opacity);
    }
}

struct DP_MsgDrawDabsClassic {
    uint8_t flags;
    uint32_t layer;
    int32_t x;
    int32_t y;
    uint32_t color;
    uint8_t mode;
    uint16_t dabs_count;
    DP_ClassicDab dabs[];
};

static size_t msg_draw_dabs_classic_payload_length(DP_Message *msg)
{
    DP_MsgDrawDabsClassic *mddc = DP_message_internal(msg);
    return ((size_t)17) + DP_int_to_size(mddc->dabs_count) * 7;
}

static size_t msg_draw_dabs_classic_payload_length_compat(DP_Message *msg)
{
    DP_MsgDrawDabsClassic *mddc = DP_message_internal(msg);
    return ((size_t)15) + DP_int_to_size(mddc->dabs_count) * 6;
}

static size_t msg_draw_dabs_classic_serialize_payload(DP_Message *msg,
                                                      unsigned char *data)
{
    DP_MsgDrawDabsClassic *mddc = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(mddc->flags, data + written);
    written += DP_write_bigendian_uint24(mddc->layer, data + written);
    written += DP_write_bigendian_int32(mddc->x, data + written);
    written += DP_write_bigendian_int32(mddc->y, data + written);
    written += DP_write_bigendian_uint32(mddc->color, data + written);
    written += DP_write_bigendian_uint8(mddc->mode, data + written);
    written += classic_dab_serialize_payloads(mddc->dabs, mddc->dabs_count,
                                              data + written);
    DP_ASSERT(written == msg_draw_dabs_classic_payload_length(msg));
    return written;
}

static size_t
msg_draw_dabs_classic_serialize_payload_compat(DP_Message *msg,
                                               unsigned char *data)
{
    DP_MsgDrawDabsClassic *mddc = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(serialize_layer_id_compat(mddc->layer),
                                         data + written);
    written += DP_write_bigendian_int32(mddc->x, data + written);
    written += DP_write_bigendian_int32(mddc->y, data + written);
    written += DP_write_bigendian_uint32(mddc->color, data + written);
    written += DP_write_bigendian_uint8(DP_blend_mode_to_compatible(mddc->mode),
                                        data + written);
    written += classic_dab_serialize_payloads_compat(
        mddc->dabs, mddc->dabs_count, data + written);
    DP_ASSERT(written == msg_draw_dabs_classic_payload_length_compat(msg));
    return written;
}

static bool msg_draw_dabs_classic_write_payload_text(DP_Message *msg,
                                                     DP_TextWriter *writer)
{
    DP_MsgDrawDabsClassic *mddc = DP_message_internal(msg);
    return DP_text_writer_write_argb_color(writer, "color", mddc->color)
        && DP_text_writer_write_uint(writer, "flags", mddc->flags)
        && DP_text_writer_write_uint(writer, "layer", mddc->layer)
        && DP_text_writer_write_blend_mode(writer, "mode", mddc->mode)
        && DP_text_writer_write_decimal(writer, "x", (double)mddc->x / 4.0)
        && DP_text_writer_write_decimal(writer, "y", (double)mddc->y / 4.0)
        && classic_dab_write_payload_texts(mddc->dabs, mddc->dabs_count,
                                           writer);
}

static bool msg_draw_dabs_classic_equals(DP_Message *DP_RESTRICT msg,
                                         DP_Message *DP_RESTRICT other)
{
    DP_MsgDrawDabsClassic *a = DP_message_internal(msg);
    DP_MsgDrawDabsClassic *b = DP_message_internal(other);
    return a->flags == b->flags && a->layer == b->layer && a->x == b->x
        && a->y == b->y && a->color == b->color && a->mode == b->mode
        && a->dabs_count == b->dabs_count
        && classic_dabs_equal(a->dabs, b->dabs, a->dabs_count);
}

void DP_msg_draw_dabs_classic_local_match_set(DP_UNUSED size_t size,
                                              unsigned char *data, void *user)
{
    DP_ASSERT(size == DP_MSG_DRAW_DABS_CLASSIC_MATCH_LENGTH);
    const DP_MsgDrawDabsClassic *mddc = user;
    size_t written = 0;
    written += DP_write_bigendian_uint8(mddc->flags, data + written);
    written += DP_write_bigendian_uint24(mddc->layer, data + written);
    written += DP_write_bigendian_int32(mddc->x, data + written);
    written += DP_write_bigendian_int32(mddc->y, data + written);
    written += DP_write_bigendian_uint32(mddc->color, data + written);
    written += DP_write_bigendian_uint8(mddc->mode, data + written);
    written += DP_write_bigendian_uint16(mddc->dabs_count, data + written);
    DP_ASSERT(written == DP_MSG_DRAW_DABS_CLASSIC_MATCH_LENGTH);
}

bool DP_msg_draw_dabs_classic_local_match_matches(
    const DP_MsgDrawDabsClassic *mddc, DP_Message *local_match_msg)
{
    size_t size;
    const unsigned char *buffer = local_match_data(local_match_msg, &size);
    size_t read = 0;
    return size == DP_MSG_DRAW_DABS_CLASSIC_MATCH_LENGTH
        && read_uint8(buffer + read, &read) == mddc->flags
        && read_uint24(buffer + read, &read) == mddc->layer
        && read_int32(buffer + read, &read) == mddc->x
        && read_int32(buffer + read, &read) == mddc->y
        && read_uint32(buffer + read, &read) == mddc->color
        && read_uint8(buffer + read, &read) == mddc->mode
        && read_uint16(buffer + read, &read) == mddc->dabs_count;
}

static const DP_MessageMethods msg_draw_dabs_classic_methods = {
    msg_draw_dabs_classic_payload_length,
    msg_draw_dabs_classic_serialize_payload,
    msg_draw_dabs_classic_payload_length_compat,
    msg_draw_dabs_classic_serialize_payload_compat,
    msg_draw_dabs_classic_write_payload_text,
    msg_draw_dabs_classic_equals,
};

DP_Message *DP_msg_draw_dabs_classic_new(unsigned int context_id, uint8_t flags,
                                         uint32_t layer, int32_t x, int32_t y,
                                         uint32_t color, uint8_t mode,
                                         void (*set_dabs)(int, DP_ClassicDab *,
                                                          void *),
                                         int dabs_count, void *dabs_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_DRAW_DABS_CLASSIC, context_id, &msg_draw_dabs_classic_methods,
        DP_FLEX_SIZEOF(DP_MsgDrawDabsClassic, dabs,
                       DP_int_to_size(dabs_count) * sizeof(DP_ClassicDab)));
    DP_MsgDrawDabsClassic *mddc = DP_message_internal(msg);
    mddc->flags = flags;
    mddc->layer = layer;
    mddc->x = x;
    mddc->y = y;
    mddc->color = color;
    mddc->mode = mode;
    mddc->dabs_count = DP_int_to_uint16(dabs_count);
    set_dabs(mddc->dabs_count, mddc->dabs, dabs_user);
    return msg;
}

DP_Message *DP_msg_draw_dabs_classic_deserialize(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length)
{
    if (length < 24 || length > 65530) {
        DP_error_set("Wrong length for classicdabs message; "
                     "expected between 24 and 65530, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t flags = read_uint8(buffer + read, &read);
    uint32_t layer = read_uint24(buffer + read, &read);
    int32_t x = read_int32(buffer + read, &read);
    int32_t y = read_int32(buffer + read, &read);
    uint32_t color = read_uint32(buffer + read, &read);
    uint8_t mode = read_uint8(buffer + read, &read);
    size_t dabs_bytes = length - read;
    if ((dabs_bytes % 7) != 0) {
        DP_error_set("Wrong length for dabs field in classicdabs message; "
                     "%zu not divisible by 7",
                     dabs_bytes);
        return NULL;
    }
    int dabs_count = DP_size_to_int(dabs_bytes) / 7;
    void *dabs_user = (void *)(buffer + read);
    return DP_msg_draw_dabs_classic_new(context_id, flags, layer, x, y, color,
                                        mode, classic_dab_deserialize,
                                        dabs_count, dabs_user);
}

DP_Message *DP_msg_draw_dabs_classic_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length < 21 || length > 65535) {
        DP_error_set("Wrong length for classicdabs compat message; "
                     "expected between 21 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t layer = read_uint16(buffer + read, &read);
    int32_t x = read_int32(buffer + read, &read);
    int32_t y = read_int32(buffer + read, &read);
    uint32_t color = read_uint32(buffer + read, &read);
    uint8_t mode = read_uint8(buffer + read, &read);
    size_t dabs_bytes = length - read;
    if ((dabs_bytes % 6) != 0) {
        DP_error_set("Wrong length for dabs field in classicdabs message; "
                     "%zu not divisible by 6",
                     dabs_bytes);
        return NULL;
    }
    int dabs_count = DP_size_to_int(dabs_bytes) / 6;
    void *dabs_user = (void *)(buffer + read);
    DP_Message *msg = DP_msg_draw_dabs_classic_new(
        context_id, get_draw_dabs_flags_compat(color),
        deserialize_layer_id_compat(layer), x, y, color,
        DP_blend_mode_to_compatible(mode), classic_dab_deserialize_compat,
        dabs_count, dabs_user);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_draw_dabs_classic_parse(unsigned int context_id,
                                           DP_TextReader *reader)
{
    uint8_t flags =
        (uint8_t)DP_text_reader_get_ulong(reader, "flags", UINT8_MAX);
    uint32_t layer =
        (uint32_t)DP_text_reader_get_ulong(reader, "layer", DP_UINT24_MAX);
    int32_t x = (int32_t)DP_text_reader_get_decimal(reader, "x", 4.0, INT32_MIN,
                                                    INT32_MAX);
    int32_t y = (int32_t)DP_text_reader_get_decimal(reader, "y", 4.0, INT32_MIN,
                                                    INT32_MAX);
    uint32_t color = DP_text_reader_get_argb_color(reader, "color");
    uint8_t mode = DP_text_reader_get_blend_mode(reader, "mode");
    int dabs_count = DP_text_reader_get_sub_count(reader);
    void *dabs_user = reader;
    return DP_msg_draw_dabs_classic_new(context_id, flags, layer, x, y, color,
                                        mode, classic_dab_parse, dabs_count,
                                        dabs_user);
}

DP_MsgDrawDabsClassic *DP_msg_draw_dabs_classic_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_DRAW_DABS_CLASSIC);
}

uint8_t DP_msg_draw_dabs_classic_flags(const DP_MsgDrawDabsClassic *mddc)
{
    DP_ASSERT(mddc);
    return mddc->flags;
}

uint32_t DP_msg_draw_dabs_classic_layer(const DP_MsgDrawDabsClassic *mddc)
{
    DP_ASSERT(mddc);
    return mddc->layer;
}

int32_t DP_msg_draw_dabs_classic_x(const DP_MsgDrawDabsClassic *mddc)
{
    DP_ASSERT(mddc);
    return mddc->x;
}

int32_t DP_msg_draw_dabs_classic_y(const DP_MsgDrawDabsClassic *mddc)
{
    DP_ASSERT(mddc);
    return mddc->y;
}

uint32_t DP_msg_draw_dabs_classic_color(const DP_MsgDrawDabsClassic *mddc)
{
    DP_ASSERT(mddc);
    return mddc->color;
}

uint8_t DP_msg_draw_dabs_classic_mode(const DP_MsgDrawDabsClassic *mddc)
{
    DP_ASSERT(mddc);
    return mddc->mode;
}

const DP_ClassicDab *
DP_msg_draw_dabs_classic_dabs(const DP_MsgDrawDabsClassic *mddc, int *out_count)
{
    DP_ASSERT(mddc);
    if (out_count) {
        *out_count = mddc->dabs_count;
    }
    return mddc->dabs;
}

int DP_msg_draw_dabs_classic_dabs_count(const DP_MsgDrawDabsClassic *mddc)
{
    return mddc->dabs_count;
}


/* DP_MSG_DRAW_DABS_PIXEL */

struct DP_PixelDab {
    int8_t x;
    int8_t y;
    uint16_t size;
    uint8_t opacity;
};

static size_t pixel_dab_serialize_payload(DP_PixelDab *pd, unsigned char *data)
{
    size_t written = 0;
    written += DP_write_bigendian_int8(pd->x, data + written);
    written += DP_write_bigendian_int8(pd->y, data + written);
    written += DP_write_bigendian_uint16(pd->size, data + written);
    written += DP_write_bigendian_uint8(pd->opacity, data + written);
    return written;
}

static size_t pixel_dab_serialize_payloads(DP_PixelDab *pd, int count,
                                           unsigned char *data)
{
    size_t written = 0;
    for (int i = 0; i < count; ++i) {
        written += pixel_dab_serialize_payload(&pd[i], data + written);
    }
    return written;
}

static bool pixel_dab_write_payload_text(DP_PixelDab *pd, DP_TextWriter *writer)
{
    return DP_text_writer_start_subobject(writer)
        && DP_text_writer_write_subfield_int(writer, "x", pd->x)
        && DP_text_writer_write_subfield_int(writer, "y", pd->y)
        && DP_text_writer_write_subfield_uint(writer, "size", pd->size)
        && DP_text_writer_write_subfield_uint(writer, "opacity", pd->opacity)
        && DP_text_writer_finish_subobject(writer);
}

static size_t pixel_dab_write_payload_texts(DP_PixelDab *pd, int count,
                                            DP_TextWriter *writer)
{
    if (count != 0) {
        if (!DP_text_writer_start_subs(writer)) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (!pixel_dab_write_payload_text(&pd[i], writer)) {
                return false;
            }
        }
        if (!DP_text_writer_finish_subs(writer)) {
            return false;
        }
    }
    return true;
}

static bool pixel_dab_equals(DP_PixelDab *DP_RESTRICT a,
                             DP_PixelDab *DP_RESTRICT b)
{
    return a->x == b->x && a->y == b->y && a->size == b->size
        && a->opacity == b->opacity;
}

static bool pixel_dabs_equal(DP_PixelDab *DP_RESTRICT a,
                             DP_PixelDab *DP_RESTRICT b, int count)
{
    for (int i = 0; i < count; ++i) {
        if (!pixel_dab_equals(&a[i], &b[i])) {
            return false;
        }
    }
    return true;
}

void DP_pixel_dab_init(DP_PixelDab *pds, int i, int8_t x, int8_t y,
                       uint16_t size, uint8_t opacity)
{
    DP_ASSERT(pds);
    DP_PixelDab *pd = &pds[i];
    pd->x = x;
    pd->y = y;
    pd->size = size;
    pd->opacity = opacity;
}

static void pixel_dab_deserialize(int count, DP_PixelDab *pds, void *user)
{
    const unsigned char *buffer = user;
    size_t read = 0;
    for (int i = 0; i < count; ++i) {
        int8_t x = read_int8(buffer + read, &read);
        int8_t y = read_int8(buffer + read, &read);
        uint16_t size = read_uint16(buffer + read, &read);
        uint8_t opacity = read_uint8(buffer + read, &read);
        DP_pixel_dab_init(pds, i, x, y, size, opacity);
    }
}

static void pixel_dab_parse(int count, DP_PixelDab *pds, void *user)
{
    DP_TextReader *reader = user;
    for (int i = 0; i < count; ++i) {
        int8_t x = (int8_t)DP_text_reader_get_subfield_long(reader, i, "x",
                                                            INT8_MIN, INT8_MAX);
        int8_t y = (int8_t)DP_text_reader_get_subfield_long(reader, i, "y",
                                                            INT8_MIN, INT8_MAX);
        uint16_t size = (uint16_t)DP_text_reader_get_subfield_ulong(
            reader, i, "size", UINT16_MAX);
        uint8_t opacity = (uint8_t)DP_text_reader_get_subfield_ulong(
            reader, i, "opacity", UINT8_MAX);
        DP_pixel_dab_init(pds, i, x, y, size, opacity);
    }
}

int8_t DP_pixel_dab_x(const DP_PixelDab *pd)
{
    DP_ASSERT(pd);
    return pd->x;
}

int8_t DP_pixel_dab_y(const DP_PixelDab *pd)
{
    DP_ASSERT(pd);
    return pd->y;
}

uint16_t DP_pixel_dab_size(const DP_PixelDab *pd)
{
    DP_ASSERT(pd);
    return pd->size;
}

uint8_t DP_pixel_dab_opacity(const DP_PixelDab *pd)
{
    DP_ASSERT(pd);
    return pd->opacity;
}

const DP_PixelDab *DP_pixel_dab_at(const DP_PixelDab *pd, int i)
{
    DP_ASSERT(pd);
    return &pd[i];
}

static size_t pixel_dab_serialize_payload_compat(DP_PixelDab *pd,
                                                 unsigned char *data)
{
    size_t written = 0;
    written += DP_write_bigendian_int8(pd->x, data + written);
    written += DP_write_bigendian_int8(pd->y, data + written);
    written +=
        DP_write_bigendian_uint8(DP_uint16_to_uint8(pd->size), data + written);
    written += DP_write_bigendian_uint8(pd->opacity, data + written);
    return written;
}

static size_t pixel_dab_serialize_payloads_compat(DP_PixelDab *pd, int count,
                                                  unsigned char *data)
{
    size_t written = 0;
    for (int i = 0; i < count; ++i) {
        written += pixel_dab_serialize_payload_compat(&pd[i], data + written);
    }
    return written;
}

static void pixel_dab_deserialize_compat(int count, DP_PixelDab *pds,
                                         void *user)
{
    const unsigned char *buffer = user;
    size_t read = 0;
    for (int i = 0; i < count; ++i) {
        int8_t x = read_int8(buffer + read, &read);
        int8_t y = read_int8(buffer + read, &read);
        uint8_t size = read_uint8(buffer + read, &read);
        uint8_t opacity = read_uint8(buffer + read, &read);
        DP_pixel_dab_init(pds, i, x, y, DP_uint8_to_uint16(size), opacity);
    }
}

struct DP_MsgDrawDabsPixel {
    uint8_t flags;
    uint32_t layer;
    int32_t x;
    int32_t y;
    uint32_t color;
    uint8_t mode;
    uint16_t dabs_count;
    DP_PixelDab dabs[];
};

static size_t msg_draw_dabs_pixel_payload_length(DP_Message *msg)
{
    DP_MsgDrawDabsPixel *mddp = DP_message_internal(msg);
    return ((size_t)17) + DP_int_to_size(mddp->dabs_count) * 5;
}

static size_t msg_draw_dabs_pixel_payload_length_compat(DP_Message *msg)
{
    DP_MsgDrawDabsPixel *mddp = DP_message_internal(msg);
    return ((size_t)15) + DP_int_to_size(mddp->dabs_count) * 4;
}

static size_t msg_draw_dabs_pixel_serialize_payload(DP_Message *msg,
                                                    unsigned char *data)
{
    DP_MsgDrawDabsPixel *mddp = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(mddp->flags, data + written);
    written += DP_write_bigendian_uint24(mddp->layer, data + written);
    written += DP_write_bigendian_int32(mddp->x, data + written);
    written += DP_write_bigendian_int32(mddp->y, data + written);
    written += DP_write_bigendian_uint32(mddp->color, data + written);
    written += DP_write_bigendian_uint8(mddp->mode, data + written);
    written += pixel_dab_serialize_payloads(mddp->dabs, mddp->dabs_count,
                                            data + written);
    DP_ASSERT(written == msg_draw_dabs_pixel_payload_length(msg));
    return written;
}

static size_t msg_draw_dabs_pixel_serialize_payload_compat(DP_Message *msg,
                                                           unsigned char *data)
{
    DP_MsgDrawDabsPixel *mddp = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(serialize_layer_id_compat(mddp->layer),
                                         data + written);
    written += DP_write_bigendian_int32(mddp->x, data + written);
    written += DP_write_bigendian_int32(mddp->y, data + written);
    written += DP_write_bigendian_uint32(mddp->color, data + written);
    written += DP_write_bigendian_uint8(DP_blend_mode_to_compatible(mddp->mode),
                                        data + written);
    written += pixel_dab_serialize_payloads_compat(mddp->dabs, mddp->dabs_count,
                                                   data + written);
    DP_ASSERT(written == msg_draw_dabs_pixel_payload_length_compat(msg));
    return written;
}

static bool msg_draw_dabs_pixel_write_payload_text(DP_Message *msg,
                                                   DP_TextWriter *writer)
{
    DP_MsgDrawDabsPixel *mddp = DP_message_internal(msg);
    return DP_text_writer_write_argb_color(writer, "color", mddp->color)
        && DP_text_writer_write_uint(writer, "flags", mddp->flags)
        && DP_text_writer_write_uint(writer, "layer", mddp->layer)
        && DP_text_writer_write_blend_mode(writer, "mode", mddp->mode)
        && DP_text_writer_write_int(writer, "x", mddp->x)
        && DP_text_writer_write_int(writer, "y", mddp->y)
        && pixel_dab_write_payload_texts(mddp->dabs, mddp->dabs_count, writer);
}

static bool msg_draw_dabs_pixel_equals(DP_Message *DP_RESTRICT msg,
                                       DP_Message *DP_RESTRICT other)
{
    DP_MsgDrawDabsPixel *a = DP_message_internal(msg);
    DP_MsgDrawDabsPixel *b = DP_message_internal(other);
    return a->flags == b->flags && a->layer == b->layer && a->x == b->x
        && a->y == b->y && a->color == b->color && a->mode == b->mode
        && a->dabs_count == b->dabs_count
        && pixel_dabs_equal(a->dabs, b->dabs, a->dabs_count);
}

void DP_msg_draw_dabs_pixel_local_match_set(DP_UNUSED size_t size,
                                            unsigned char *data, void *user)
{
    DP_ASSERT(size == DP_MSG_DRAW_DABS_PIXEL_MATCH_LENGTH);
    const DP_MsgDrawDabsPixel *mddp = user;
    size_t written = 0;
    written += DP_write_bigendian_uint8(mddp->flags, data + written);
    written += DP_write_bigendian_uint24(mddp->layer, data + written);
    written += DP_write_bigendian_int32(mddp->x, data + written);
    written += DP_write_bigendian_int32(mddp->y, data + written);
    written += DP_write_bigendian_uint32(mddp->color, data + written);
    written += DP_write_bigendian_uint8(mddp->mode, data + written);
    written += DP_write_bigendian_uint16(mddp->dabs_count, data + written);
    DP_ASSERT(written == DP_MSG_DRAW_DABS_PIXEL_MATCH_LENGTH);
}

bool DP_msg_draw_dabs_pixel_local_match_matches(const DP_MsgDrawDabsPixel *mddp,
                                                DP_Message *local_match_msg)
{
    size_t size;
    const unsigned char *buffer = local_match_data(local_match_msg, &size);
    size_t read = 0;
    return size == DP_MSG_DRAW_DABS_PIXEL_MATCH_LENGTH
        && read_uint8(buffer + read, &read) == mddp->flags
        && read_uint24(buffer + read, &read) == mddp->layer
        && read_int32(buffer + read, &read) == mddp->x
        && read_int32(buffer + read, &read) == mddp->y
        && read_uint32(buffer + read, &read) == mddp->color
        && read_uint8(buffer + read, &read) == mddp->mode
        && read_uint16(buffer + read, &read) == mddp->dabs_count;
}

static const DP_MessageMethods msg_draw_dabs_pixel_methods = {
    msg_draw_dabs_pixel_payload_length,
    msg_draw_dabs_pixel_serialize_payload,
    msg_draw_dabs_pixel_payload_length_compat,
    msg_draw_dabs_pixel_serialize_payload_compat,
    msg_draw_dabs_pixel_write_payload_text,
    msg_draw_dabs_pixel_equals,
};

DP_Message *DP_msg_draw_dabs_pixel_new(unsigned int context_id, uint8_t flags,
                                       uint32_t layer, int32_t x, int32_t y,
                                       uint32_t color, uint8_t mode,
                                       void (*set_dabs)(int, DP_PixelDab *,
                                                        void *),
                                       int dabs_count, void *dabs_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_DRAW_DABS_PIXEL, context_id, &msg_draw_dabs_pixel_methods,
        DP_FLEX_SIZEOF(DP_MsgDrawDabsPixel, dabs,
                       DP_int_to_size(dabs_count) * sizeof(DP_PixelDab)));
    DP_MsgDrawDabsPixel *mddp = DP_message_internal(msg);
    mddp->flags = flags;
    mddp->layer = layer;
    mddp->x = x;
    mddp->y = y;
    mddp->color = color;
    mddp->mode = mode;
    mddp->dabs_count = DP_int_to_uint16(dabs_count);
    set_dabs(mddp->dabs_count, mddp->dabs, dabs_user);
    return msg;
}

DP_Message *DP_msg_draw_dabs_pixel_deserialize(unsigned int context_id,
                                               const unsigned char *buffer,
                                               size_t length)
{
    if (length < 22 || length > 65532) {
        DP_error_set("Wrong length for pixeldabs message; "
                     "expected between 22 and 65532, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t flags = read_uint8(buffer + read, &read);
    uint32_t layer = read_uint24(buffer + read, &read);
    int32_t x = read_int32(buffer + read, &read);
    int32_t y = read_int32(buffer + read, &read);
    uint32_t color = read_uint32(buffer + read, &read);
    uint8_t mode = read_uint8(buffer + read, &read);
    size_t dabs_bytes = length - read;
    if ((dabs_bytes % 5) != 0) {
        DP_error_set("Wrong length for dabs field in pixeldabs message; "
                     "%zu not divisible by 5",
                     dabs_bytes);
        return NULL;
    }
    int dabs_count = DP_size_to_int(dabs_bytes) / 5;
    void *dabs_user = (void *)(buffer + read);
    return DP_msg_draw_dabs_pixel_new(context_id, flags, layer, x, y, color,
                                      mode, pixel_dab_deserialize, dabs_count,
                                      dabs_user);
}

DP_Message *DP_msg_draw_dabs_pixel_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length < 19 || length > 65535) {
        DP_error_set("Wrong length for pixeldabs compat message; "
                     "expected between 19 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t layer = read_uint16(buffer + read, &read);
    int32_t x = read_int32(buffer + read, &read);
    int32_t y = read_int32(buffer + read, &read);
    uint32_t color = read_uint32(buffer + read, &read);
    uint8_t mode = read_uint8(buffer + read, &read);
    size_t dabs_bytes = length - read;
    if ((dabs_bytes % 4) != 0) {
        DP_error_set("Wrong length for dabs field in pixeldabs message; "
                     "%zu not divisible by 4",
                     dabs_bytes);
        return NULL;
    }
    int dabs_count = DP_size_to_int(dabs_bytes) / 4;
    void *dabs_user = (void *)(buffer + read);
    DP_Message *msg = DP_msg_draw_dabs_pixel_new(
        context_id, get_draw_dabs_flags_compat(color),
        deserialize_layer_id_compat(layer), x, y, color,
        DP_blend_mode_to_compatible(mode), pixel_dab_deserialize_compat,
        dabs_count, dabs_user);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_draw_dabs_pixel_parse(unsigned int context_id,
                                         DP_TextReader *reader)
{
    uint8_t flags =
        (uint8_t)DP_text_reader_get_ulong(reader, "flags", UINT8_MAX);
    uint32_t layer =
        (uint32_t)DP_text_reader_get_ulong(reader, "layer", DP_UINT24_MAX);
    int32_t x =
        (int32_t)DP_text_reader_get_long(reader, "x", INT32_MIN, INT32_MAX);
    int32_t y =
        (int32_t)DP_text_reader_get_long(reader, "y", INT32_MIN, INT32_MAX);
    uint32_t color = DP_text_reader_get_argb_color(reader, "color");
    uint8_t mode = DP_text_reader_get_blend_mode(reader, "mode");
    int dabs_count = DP_text_reader_get_sub_count(reader);
    void *dabs_user = reader;
    return DP_msg_draw_dabs_pixel_new(context_id, flags, layer, x, y, color,
                                      mode, pixel_dab_parse, dabs_count,
                                      dabs_user);
}

DP_MsgDrawDabsPixel *DP_msg_draw_dabs_pixel_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_DRAW_DABS_PIXEL);
}

uint8_t DP_msg_draw_dabs_pixel_flags(const DP_MsgDrawDabsPixel *mddp)
{
    DP_ASSERT(mddp);
    return mddp->flags;
}

uint32_t DP_msg_draw_dabs_pixel_layer(const DP_MsgDrawDabsPixel *mddp)
{
    DP_ASSERT(mddp);
    return mddp->layer;
}

int32_t DP_msg_draw_dabs_pixel_x(const DP_MsgDrawDabsPixel *mddp)
{
    DP_ASSERT(mddp);
    return mddp->x;
}

int32_t DP_msg_draw_dabs_pixel_y(const DP_MsgDrawDabsPixel *mddp)
{
    DP_ASSERT(mddp);
    return mddp->y;
}

uint32_t DP_msg_draw_dabs_pixel_color(const DP_MsgDrawDabsPixel *mddp)
{
    DP_ASSERT(mddp);
    return mddp->color;
}

uint8_t DP_msg_draw_dabs_pixel_mode(const DP_MsgDrawDabsPixel *mddp)
{
    DP_ASSERT(mddp);
    return mddp->mode;
}

const DP_PixelDab *DP_msg_draw_dabs_pixel_dabs(const DP_MsgDrawDabsPixel *mddp,
                                               int *out_count)
{
    DP_ASSERT(mddp);
    if (out_count) {
        *out_count = mddp->dabs_count;
    }
    return mddp->dabs;
}

int DP_msg_draw_dabs_pixel_dabs_count(const DP_MsgDrawDabsPixel *mddp)
{
    return mddp->dabs_count;
}


/* DP_MSG_DRAW_DABS_PIXEL_SQUARE */

DP_Message *
DP_msg_draw_dabs_pixel_square_new(unsigned int context_id, uint8_t flags,
                                  uint32_t layer, int32_t x, int32_t y,
                                  uint32_t color, uint8_t mode,
                                  void (*set_dabs)(int, DP_PixelDab *, void *),
                                  int dabs_count, void *dabs_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_DRAW_DABS_PIXEL_SQUARE, context_id, &msg_draw_dabs_pixel_methods,
        DP_FLEX_SIZEOF(DP_MsgDrawDabsPixel, dabs,
                       DP_int_to_size(dabs_count) * sizeof(DP_PixelDab)));
    DP_MsgDrawDabsPixel *mddps = DP_message_internal(msg);
    mddps->flags = flags;
    mddps->layer = layer;
    mddps->x = x;
    mddps->y = y;
    mddps->color = color;
    mddps->mode = mode;
    mddps->dabs_count = DP_int_to_uint16(dabs_count);
    set_dabs(mddps->dabs_count, mddps->dabs, dabs_user);
    return msg;
}

DP_Message *DP_msg_draw_dabs_pixel_square_deserialize(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length < 22 || length > 65532) {
        DP_error_set("Wrong length for squarepixeldabs message; "
                     "expected between 22 and 65532, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t flags = read_uint8(buffer + read, &read);
    uint32_t layer = read_uint24(buffer + read, &read);
    int32_t x = read_int32(buffer + read, &read);
    int32_t y = read_int32(buffer + read, &read);
    uint32_t color = read_uint32(buffer + read, &read);
    uint8_t mode = read_uint8(buffer + read, &read);
    size_t dabs_bytes = length - read;
    if ((dabs_bytes % 5) != 0) {
        DP_error_set("Wrong length for dabs field in squarepixeldabs message; "
                     "%zu not divisible by 5",
                     dabs_bytes);
        return NULL;
    }
    int dabs_count = DP_size_to_int(dabs_bytes) / 5;
    void *dabs_user = (void *)(buffer + read);
    return DP_msg_draw_dabs_pixel_square_new(context_id, flags, layer, x, y,
                                             color, mode, pixel_dab_deserialize,
                                             dabs_count, dabs_user);
}

DP_Message *DP_msg_draw_dabs_pixel_square_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length < 19 || length > 65535) {
        DP_error_set("Wrong length for squarepixeldabs compat message; "
                     "expected between 19 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t layer = read_uint16(buffer + read, &read);
    int32_t x = read_int32(buffer + read, &read);
    int32_t y = read_int32(buffer + read, &read);
    uint32_t color = read_uint32(buffer + read, &read);
    uint8_t mode = read_uint8(buffer + read, &read);
    size_t dabs_bytes = length - read;
    if ((dabs_bytes % 4) != 0) {
        DP_error_set("Wrong length for dabs field in squarepixeldabs message; "
                     "%zu not divisible by 4",
                     dabs_bytes);
        return NULL;
    }
    int dabs_count = DP_size_to_int(dabs_bytes) / 4;
    void *dabs_user = (void *)(buffer + read);
    DP_Message *msg = DP_msg_draw_dabs_pixel_square_new(
        context_id, get_draw_dabs_flags_compat(color),
        deserialize_layer_id_compat(layer), x, y, color,
        DP_blend_mode_to_compatible(mode), pixel_dab_deserialize_compat,
        dabs_count, dabs_user);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_draw_dabs_pixel_square_parse(unsigned int context_id,
                                                DP_TextReader *reader)
{
    uint8_t flags =
        (uint8_t)DP_text_reader_get_ulong(reader, "flags", UINT8_MAX);
    uint32_t layer =
        (uint32_t)DP_text_reader_get_ulong(reader, "layer", DP_UINT24_MAX);
    int32_t x =
        (int32_t)DP_text_reader_get_long(reader, "x", INT32_MIN, INT32_MAX);
    int32_t y =
        (int32_t)DP_text_reader_get_long(reader, "y", INT32_MIN, INT32_MAX);
    uint32_t color = DP_text_reader_get_argb_color(reader, "color");
    uint8_t mode = DP_text_reader_get_blend_mode(reader, "mode");
    int dabs_count = DP_text_reader_get_sub_count(reader);
    void *dabs_user = reader;
    return DP_msg_draw_dabs_pixel_square_new(context_id, flags, layer, x, y,
                                             color, mode, pixel_dab_parse,
                                             dabs_count, dabs_user);
}

DP_MsgDrawDabsPixel *DP_msg_draw_dabs_pixel_square_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_DRAW_DABS_PIXEL_SQUARE);
}


/* DP_MSG_DRAW_DABS_MYPAINT */

struct DP_MyPaintDab {
    int8_t x;
    int8_t y;
    uint32_t size;
    uint8_t hardness;
    uint8_t opacity;
    uint8_t angle;
    uint8_t aspect_ratio;
};

static size_t mypaint_dab_serialize_payload(DP_MyPaintDab *mpd,
                                            unsigned char *data)
{
    size_t written = 0;
    written += DP_write_bigendian_int8(mpd->x, data + written);
    written += DP_write_bigendian_int8(mpd->y, data + written);
    written += DP_write_bigendian_uint24(mpd->size, data + written);
    written += DP_write_bigendian_uint8(mpd->hardness, data + written);
    written += DP_write_bigendian_uint8(mpd->opacity, data + written);
    written += DP_write_bigendian_uint8(mpd->angle, data + written);
    written += DP_write_bigendian_uint8(mpd->aspect_ratio, data + written);
    return written;
}

static size_t mypaint_dab_serialize_payloads(DP_MyPaintDab *mpd, int count,
                                             unsigned char *data)
{
    size_t written = 0;
    for (int i = 0; i < count; ++i) {
        written += mypaint_dab_serialize_payload(&mpd[i], data + written);
    }
    return written;
}

static bool mypaint_dab_write_payload_text(DP_MyPaintDab *mpd,
                                           DP_TextWriter *writer)
{
    return DP_text_writer_start_subobject(writer)
        && DP_text_writer_write_subfield_decimal(writer, "x",
                                                 (double)mpd->x / 4.0)
        && DP_text_writer_write_subfield_decimal(writer, "y",
                                                 (double)mpd->y / 4.0)
        && DP_text_writer_write_subfield_decimal(writer, "size",
                                                 (double)mpd->size / 256.0)
        && DP_text_writer_write_subfield_uint(writer, "hardness", mpd->hardness)
        && DP_text_writer_write_subfield_uint(writer, "opacity", mpd->opacity)
        && DP_text_writer_write_subfield_uint(writer, "angle", mpd->angle)
        && DP_text_writer_write_subfield_uint(writer, "aspect_ratio",
                                              mpd->aspect_ratio)
        && DP_text_writer_finish_subobject(writer);
}

static size_t mypaint_dab_write_payload_texts(DP_MyPaintDab *mpd, int count,
                                              DP_TextWriter *writer)
{
    if (count != 0) {
        if (!DP_text_writer_start_subs(writer)) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (!mypaint_dab_write_payload_text(&mpd[i], writer)) {
                return false;
            }
        }
        if (!DP_text_writer_finish_subs(writer)) {
            return false;
        }
    }
    return true;
}

static bool mypaint_dab_equals(DP_MyPaintDab *DP_RESTRICT a,
                               DP_MyPaintDab *DP_RESTRICT b)
{
    return a->x == b->x && a->y == b->y && a->size == b->size
        && a->hardness == b->hardness && a->opacity == b->opacity
        && a->angle == b->angle && a->aspect_ratio == b->aspect_ratio;
}

static bool mypaint_dabs_equal(DP_MyPaintDab *DP_RESTRICT a,
                               DP_MyPaintDab *DP_RESTRICT b, int count)
{
    for (int i = 0; i < count; ++i) {
        if (!mypaint_dab_equals(&a[i], &b[i])) {
            return false;
        }
    }
    return true;
}

void DP_mypaint_dab_init(DP_MyPaintDab *mpds, int i, int8_t x, int8_t y,
                         uint32_t size, uint8_t hardness, uint8_t opacity,
                         uint8_t angle, uint8_t aspect_ratio)
{
    DP_ASSERT(mpds);
    DP_MyPaintDab *mpd = &mpds[i];
    mpd->x = x;
    mpd->y = y;
    mpd->size = size;
    mpd->hardness = hardness;
    mpd->opacity = opacity;
    mpd->angle = angle;
    mpd->aspect_ratio = aspect_ratio;
}

static void mypaint_dab_deserialize(int count, DP_MyPaintDab *mpds, void *user)
{
    const unsigned char *buffer = user;
    size_t read = 0;
    for (int i = 0; i < count; ++i) {
        int8_t x = read_int8(buffer + read, &read);
        int8_t y = read_int8(buffer + read, &read);
        uint32_t size = read_uint24(buffer + read, &read);
        uint8_t hardness = read_uint8(buffer + read, &read);
        uint8_t opacity = read_uint8(buffer + read, &read);
        uint8_t angle = read_uint8(buffer + read, &read);
        uint8_t aspect_ratio = read_uint8(buffer + read, &read);
        DP_mypaint_dab_init(mpds, i, x, y, size, hardness, opacity, angle,
                            aspect_ratio);
    }
}

static void mypaint_dab_parse(int count, DP_MyPaintDab *mpds, void *user)
{
    DP_TextReader *reader = user;
    for (int i = 0; i < count; ++i) {
        int8_t x = (int8_t)DP_text_reader_get_subfield_decimal(
            reader, i, "x", 4.0, INT8_MIN, INT8_MAX);
        int8_t y = (int8_t)DP_text_reader_get_subfield_decimal(
            reader, i, "y", 4.0, INT8_MIN, INT8_MAX);
        uint32_t size = (uint32_t)DP_text_reader_get_subfield_decimal(
            reader, i, "size", 256.0, 0, DP_UINT24_MAX);
        uint8_t hardness = (uint8_t)DP_text_reader_get_subfield_ulong(
            reader, i, "hardness", UINT8_MAX);
        uint8_t opacity = (uint8_t)DP_text_reader_get_subfield_ulong(
            reader, i, "opacity", UINT8_MAX);
        uint8_t angle = (uint8_t)DP_text_reader_get_subfield_ulong(
            reader, i, "angle", UINT8_MAX);
        uint8_t aspect_ratio = (uint8_t)DP_text_reader_get_subfield_ulong(
            reader, i, "aspect_ratio", UINT8_MAX);
        DP_mypaint_dab_init(mpds, i, x, y, size, hardness, opacity, angle,
                            aspect_ratio);
    }
}

int8_t DP_mypaint_dab_x(const DP_MyPaintDab *mpd)
{
    DP_ASSERT(mpd);
    return mpd->x;
}

int8_t DP_mypaint_dab_y(const DP_MyPaintDab *mpd)
{
    DP_ASSERT(mpd);
    return mpd->y;
}

uint32_t DP_mypaint_dab_size(const DP_MyPaintDab *mpd)
{
    DP_ASSERT(mpd);
    return mpd->size;
}

uint8_t DP_mypaint_dab_hardness(const DP_MyPaintDab *mpd)
{
    DP_ASSERT(mpd);
    return mpd->hardness;
}

uint8_t DP_mypaint_dab_opacity(const DP_MyPaintDab *mpd)
{
    DP_ASSERT(mpd);
    return mpd->opacity;
}

uint8_t DP_mypaint_dab_angle(const DP_MyPaintDab *mpd)
{
    DP_ASSERT(mpd);
    return mpd->angle;
}

uint8_t DP_mypaint_dab_aspect_ratio(const DP_MyPaintDab *mpd)
{
    DP_ASSERT(mpd);
    return mpd->aspect_ratio;
}

const DP_MyPaintDab *DP_mypaint_dab_at(const DP_MyPaintDab *mpd, int i)
{
    DP_ASSERT(mpd);
    return &mpd[i];
}

static size_t mypaint_dab_serialize_payload_compat(DP_MyPaintDab *mpd,
                                                   unsigned char *data)
{
    size_t written = 0;
    written += DP_write_bigendian_int8(mpd->x, data + written);
    written += DP_write_bigendian_int8(mpd->y, data + written);
    written += DP_write_bigendian_uint16(DP_uint32_to_uint16(mpd->size),
                                         data + written);
    written += DP_write_bigendian_uint8(mpd->hardness, data + written);
    written += DP_write_bigendian_uint8(mpd->opacity, data + written);
    written += DP_write_bigendian_uint8(mpd->angle, data + written);
    written += DP_write_bigendian_uint8(mpd->aspect_ratio, data + written);
    return written;
}

static size_t mypaint_dab_serialize_payloads_compat(DP_MyPaintDab *mpd,
                                                    int count,
                                                    unsigned char *data)
{
    size_t written = 0;
    for (int i = 0; i < count; ++i) {
        written +=
            mypaint_dab_serialize_payload_compat(&mpd[i], data + written);
    }
    return written;
}

static void mypaint_dab_deserialize_compat(int count, DP_MyPaintDab *mpds,
                                           void *user)
{
    const unsigned char *buffer = user;
    size_t read = 0;
    for (int i = 0; i < count; ++i) {
        int8_t x = read_int8(buffer + read, &read);
        int8_t y = read_int8(buffer + read, &read);
        uint16_t size = read_uint16(buffer + read, &read);
        uint8_t hardness = read_uint8(buffer + read, &read);
        uint8_t opacity = read_uint8(buffer + read, &read);
        uint8_t angle = read_uint8(buffer + read, &read);
        uint8_t aspect_ratio = read_uint8(buffer + read, &read);
        DP_mypaint_dab_init(mpds, i, x, y, DP_uint16_to_uint32(size), hardness,
                            opacity, angle, aspect_ratio);
    }
}

struct DP_MsgDrawDabsMyPaint {
    uint8_t flags;
    uint32_t layer;
    int32_t x;
    int32_t y;
    uint32_t color;
    uint8_t lock_alpha;
    uint8_t colorize;
    uint8_t posterize;
    uint8_t mode;
    uint16_t dabs_count;
    DP_MyPaintDab dabs[];
};

static size_t msg_draw_dabs_mypaint_payload_length(DP_Message *msg)
{
    DP_MsgDrawDabsMyPaint *mddmp = DP_message_internal(msg);
    return ((size_t)20) + DP_int_to_size(mddmp->dabs_count) * 9;
}

static size_t msg_draw_dabs_mypaint_payload_length_compat(DP_Message *msg)
{
    DP_MsgDrawDabsMyPaint *mddmp = DP_message_internal(msg);
    return ((size_t)18) + DP_int_to_size(mddmp->dabs_count) * 8;
}

static size_t msg_draw_dabs_mypaint_serialize_payload(DP_Message *msg,
                                                      unsigned char *data)
{
    DP_MsgDrawDabsMyPaint *mddmp = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(mddmp->flags, data + written);
    written += DP_write_bigendian_uint24(mddmp->layer, data + written);
    written += DP_write_bigendian_int32(mddmp->x, data + written);
    written += DP_write_bigendian_int32(mddmp->y, data + written);
    written += DP_write_bigendian_uint32(mddmp->color, data + written);
    written += DP_write_bigendian_uint8(mddmp->lock_alpha, data + written);
    written += DP_write_bigendian_uint8(mddmp->colorize, data + written);
    written += DP_write_bigendian_uint8(mddmp->posterize, data + written);
    written += DP_write_bigendian_uint8(mddmp->mode, data + written);
    written += mypaint_dab_serialize_payloads(mddmp->dabs, mddmp->dabs_count,
                                              data + written);
    DP_ASSERT(written == msg_draw_dabs_mypaint_payload_length(msg));
    return written;
}

static size_t
msg_draw_dabs_mypaint_serialize_payload_compat(DP_Message *msg,
                                               unsigned char *data)
{
    DP_MsgDrawDabsMyPaint *mddmp = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(
        serialize_layer_id_compat(mddmp->layer), data + written);
    written += DP_write_bigendian_int32(mddmp->x, data + written);
    written += DP_write_bigendian_int32(mddmp->y, data + written);
    written += DP_write_bigendian_uint32(mddmp->color, data + written);
    written += DP_write_bigendian_uint8(mddmp->lock_alpha, data + written);
    written += DP_write_bigendian_uint8(mddmp->colorize, data + written);
    written += DP_write_bigendian_uint8(mddmp->posterize, data + written);
    written += DP_write_bigendian_uint8(mddmp->mode, data + written);
    written += mypaint_dab_serialize_payloads_compat(
        mddmp->dabs, mddmp->dabs_count, data + written);
    DP_ASSERT(written == msg_draw_dabs_mypaint_payload_length_compat(msg));
    return written;
}

static bool msg_draw_dabs_mypaint_write_payload_text(DP_Message *msg,
                                                     DP_TextWriter *writer)
{
    DP_MsgDrawDabsMyPaint *mddmp = DP_message_internal(msg);
    return DP_text_writer_write_argb_color(writer, "color", mddmp->color)
        && DP_text_writer_write_uint(writer, "colorize", mddmp->colorize)
        && DP_text_writer_write_uint(writer, "flags", mddmp->flags)
        && DP_text_writer_write_uint(writer, "layer", mddmp->layer)
        && DP_text_writer_write_uint(writer, "lock_alpha", mddmp->lock_alpha)
        && DP_text_writer_write_uint(writer, "mode", mddmp->mode)
        && DP_text_writer_write_uint(writer, "posterize", mddmp->posterize)
        && DP_text_writer_write_decimal(writer, "x", (double)mddmp->x / 4.0)
        && DP_text_writer_write_decimal(writer, "y", (double)mddmp->y / 4.0)
        && mypaint_dab_write_payload_texts(mddmp->dabs, mddmp->dabs_count,
                                           writer);
}

static bool msg_draw_dabs_mypaint_equals(DP_Message *DP_RESTRICT msg,
                                         DP_Message *DP_RESTRICT other)
{
    DP_MsgDrawDabsMyPaint *a = DP_message_internal(msg);
    DP_MsgDrawDabsMyPaint *b = DP_message_internal(other);
    return a->flags == b->flags && a->layer == b->layer && a->x == b->x
        && a->y == b->y && a->color == b->color
        && a->lock_alpha == b->lock_alpha && a->colorize == b->colorize
        && a->posterize == b->posterize && a->mode == b->mode
        && a->dabs_count == b->dabs_count
        && mypaint_dabs_equal(a->dabs, b->dabs, a->dabs_count);
}

void DP_msg_draw_dabs_mypaint_local_match_set(DP_UNUSED size_t size,
                                              unsigned char *data, void *user)
{
    DP_ASSERT(size == DP_MSG_DRAW_DABS_MYPAINT_MATCH_LENGTH);
    const DP_MsgDrawDabsMyPaint *mddmp = user;
    size_t written = 0;
    written += DP_write_bigendian_uint8(mddmp->flags, data + written);
    written += DP_write_bigendian_uint24(mddmp->layer, data + written);
    written += DP_write_bigendian_int32(mddmp->x, data + written);
    written += DP_write_bigendian_int32(mddmp->y, data + written);
    written += DP_write_bigendian_uint32(mddmp->color, data + written);
    written += DP_write_bigendian_uint8(mddmp->lock_alpha, data + written);
    written += DP_write_bigendian_uint8(mddmp->colorize, data + written);
    written += DP_write_bigendian_uint8(mddmp->posterize, data + written);
    written += DP_write_bigendian_uint8(mddmp->mode, data + written);
    written += DP_write_bigendian_uint16(mddmp->dabs_count, data + written);
    DP_ASSERT(written == DP_MSG_DRAW_DABS_MYPAINT_MATCH_LENGTH);
}

bool DP_msg_draw_dabs_mypaint_local_match_matches(
    const DP_MsgDrawDabsMyPaint *mddmp, DP_Message *local_match_msg)
{
    size_t size;
    const unsigned char *buffer = local_match_data(local_match_msg, &size);
    size_t read = 0;
    return size == DP_MSG_DRAW_DABS_MYPAINT_MATCH_LENGTH
        && read_uint8(buffer + read, &read) == mddmp->flags
        && read_uint24(buffer + read, &read) == mddmp->layer
        && read_int32(buffer + read, &read) == mddmp->x
        && read_int32(buffer + read, &read) == mddmp->y
        && read_uint32(buffer + read, &read) == mddmp->color
        && read_uint8(buffer + read, &read) == mddmp->lock_alpha
        && read_uint8(buffer + read, &read) == mddmp->colorize
        && read_uint8(buffer + read, &read) == mddmp->posterize
        && read_uint8(buffer + read, &read) == mddmp->mode
        && read_uint16(buffer + read, &read) == mddmp->dabs_count;
}

static const DP_MessageMethods msg_draw_dabs_mypaint_methods = {
    msg_draw_dabs_mypaint_payload_length,
    msg_draw_dabs_mypaint_serialize_payload,
    msg_draw_dabs_mypaint_payload_length_compat,
    msg_draw_dabs_mypaint_serialize_payload_compat,
    msg_draw_dabs_mypaint_write_payload_text,
    msg_draw_dabs_mypaint_equals,
};

DP_Message *
DP_msg_draw_dabs_mypaint_new(unsigned int context_id, uint8_t flags,
                             uint32_t layer, int32_t x, int32_t y,
                             uint32_t color, uint8_t lock_alpha,
                             uint8_t colorize, uint8_t posterize, uint8_t mode,
                             void (*set_dabs)(int, DP_MyPaintDab *, void *),
                             int dabs_count, void *dabs_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_DRAW_DABS_MYPAINT, context_id, &msg_draw_dabs_mypaint_methods,
        DP_FLEX_SIZEOF(DP_MsgDrawDabsMyPaint, dabs,
                       DP_int_to_size(dabs_count) * sizeof(DP_MyPaintDab)));
    DP_MsgDrawDabsMyPaint *mddmp = DP_message_internal(msg);
    mddmp->flags = flags;
    mddmp->layer = layer;
    mddmp->x = x;
    mddmp->y = y;
    mddmp->color = color;
    mddmp->lock_alpha = lock_alpha;
    mddmp->colorize = colorize;
    mddmp->posterize = posterize;
    mddmp->mode = mode;
    mddmp->dabs_count = DP_int_to_uint16(dabs_count);
    set_dabs(mddmp->dabs_count, mddmp->dabs, dabs_user);
    return msg;
}

DP_Message *DP_msg_draw_dabs_mypaint_deserialize(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length)
{
    if (length < 29 || length > 65531) {
        DP_error_set("Wrong length for mypaintdabs message; "
                     "expected between 29 and 65531, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t flags = read_uint8(buffer + read, &read);
    uint32_t layer = read_uint24(buffer + read, &read);
    int32_t x = read_int32(buffer + read, &read);
    int32_t y = read_int32(buffer + read, &read);
    uint32_t color = read_uint32(buffer + read, &read);
    uint8_t lock_alpha = read_uint8(buffer + read, &read);
    uint8_t colorize = read_uint8(buffer + read, &read);
    uint8_t posterize = read_uint8(buffer + read, &read);
    uint8_t mode = read_uint8(buffer + read, &read);
    size_t dabs_bytes = length - read;
    if ((dabs_bytes % 9) != 0) {
        DP_error_set("Wrong length for dabs field in mypaintdabs message; "
                     "%zu not divisible by 9",
                     dabs_bytes);
        return NULL;
    }
    int dabs_count = DP_size_to_int(dabs_bytes) / 9;
    void *dabs_user = (void *)(buffer + read);
    return DP_msg_draw_dabs_mypaint_new(
        context_id, flags, layer, x, y, color, lock_alpha, colorize, posterize,
        mode, mypaint_dab_deserialize, dabs_count, dabs_user);
}

DP_Message *DP_msg_draw_dabs_mypaint_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length < 26 || length > 65530) {
        DP_error_set("Wrong length for mypaintdabs compat message; "
                     "expected between 26 and 65530, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t layer = read_uint16(buffer + read, &read);
    int32_t x = read_int32(buffer + read, &read);
    int32_t y = read_int32(buffer + read, &read);
    uint32_t color = read_uint32(buffer + read, &read);
    uint8_t lock_alpha = read_uint8(buffer + read, &read);
    uint8_t colorize = read_uint8(buffer + read, &read);
    uint8_t posterize = read_uint8(buffer + read, &read);
    uint8_t mode = read_uint8(buffer + read, &read);
    size_t dabs_bytes = length - read;
    if ((dabs_bytes % 8) != 0) {
        DP_error_set("Wrong length for dabs field in mypaintdabs message; "
                     "%zu not divisible by 8",
                     dabs_bytes);
        return NULL;
    }
    int dabs_count = DP_size_to_int(dabs_bytes) / 8;
    void *dabs_user = (void *)(buffer + read);
    DP_Message *msg = DP_msg_draw_dabs_mypaint_new(
        context_id, 0, deserialize_layer_id_compat(layer), x, y, color,
        lock_alpha, colorize, posterize, mode, mypaint_dab_deserialize_compat,
        dabs_count, dabs_user);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_draw_dabs_mypaint_parse(unsigned int context_id,
                                           DP_TextReader *reader)
{
    uint8_t flags =
        (uint8_t)DP_text_reader_get_ulong(reader, "flags", UINT8_MAX);
    uint32_t layer =
        (uint32_t)DP_text_reader_get_ulong(reader, "layer", DP_UINT24_MAX);
    int32_t x = (int32_t)DP_text_reader_get_decimal(reader, "x", 4.0, INT32_MIN,
                                                    INT32_MAX);
    int32_t y = (int32_t)DP_text_reader_get_decimal(reader, "y", 4.0, INT32_MIN,
                                                    INT32_MAX);
    uint32_t color = DP_text_reader_get_argb_color(reader, "color");
    uint8_t lock_alpha =
        (uint8_t)DP_text_reader_get_ulong(reader, "lock_alpha", UINT8_MAX);
    uint8_t colorize =
        (uint8_t)DP_text_reader_get_ulong(reader, "colorize", UINT8_MAX);
    uint8_t posterize =
        (uint8_t)DP_text_reader_get_ulong(reader, "posterize", UINT8_MAX);
    uint8_t mode = (uint8_t)DP_text_reader_get_ulong(reader, "mode", UINT8_MAX);
    int dabs_count = DP_text_reader_get_sub_count(reader);
    void *dabs_user = reader;
    return DP_msg_draw_dabs_mypaint_new(
        context_id, flags, layer, x, y, color, lock_alpha, colorize, posterize,
        mode, mypaint_dab_parse, dabs_count, dabs_user);
}

DP_MsgDrawDabsMyPaint *DP_msg_draw_dabs_mypaint_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_DRAW_DABS_MYPAINT);
}

uint8_t DP_msg_draw_dabs_mypaint_flags(const DP_MsgDrawDabsMyPaint *mddmp)
{
    DP_ASSERT(mddmp);
    return mddmp->flags;
}

uint32_t DP_msg_draw_dabs_mypaint_layer(const DP_MsgDrawDabsMyPaint *mddmp)
{
    DP_ASSERT(mddmp);
    return mddmp->layer;
}

int32_t DP_msg_draw_dabs_mypaint_x(const DP_MsgDrawDabsMyPaint *mddmp)
{
    DP_ASSERT(mddmp);
    return mddmp->x;
}

int32_t DP_msg_draw_dabs_mypaint_y(const DP_MsgDrawDabsMyPaint *mddmp)
{
    DP_ASSERT(mddmp);
    return mddmp->y;
}

uint32_t DP_msg_draw_dabs_mypaint_color(const DP_MsgDrawDabsMyPaint *mddmp)
{
    DP_ASSERT(mddmp);
    return mddmp->color;
}

uint8_t DP_msg_draw_dabs_mypaint_lock_alpha(const DP_MsgDrawDabsMyPaint *mddmp)
{
    DP_ASSERT(mddmp);
    return mddmp->lock_alpha;
}

uint8_t DP_msg_draw_dabs_mypaint_colorize(const DP_MsgDrawDabsMyPaint *mddmp)
{
    DP_ASSERT(mddmp);
    return mddmp->colorize;
}

uint8_t DP_msg_draw_dabs_mypaint_posterize(const DP_MsgDrawDabsMyPaint *mddmp)
{
    DP_ASSERT(mddmp);
    return mddmp->posterize;
}

uint8_t DP_msg_draw_dabs_mypaint_mode(const DP_MsgDrawDabsMyPaint *mddmp)
{
    DP_ASSERT(mddmp);
    return mddmp->mode;
}

const DP_MyPaintDab *
DP_msg_draw_dabs_mypaint_dabs(const DP_MsgDrawDabsMyPaint *mddmp,
                              int *out_count)
{
    DP_ASSERT(mddmp);
    if (out_count) {
        *out_count = mddmp->dabs_count;
    }
    return mddmp->dabs;
}

int DP_msg_draw_dabs_mypaint_dabs_count(const DP_MsgDrawDabsMyPaint *mddmp)
{
    return mddmp->dabs_count;
}


/* DP_MSG_DRAW_DABS_MYPAINT_BLEND */

struct DP_MyPaintBlendDab {
    int8_t x;
    int8_t y;
    uint32_t size;
    uint8_t hardness;
    uint8_t opacity;
    uint8_t angle;
    uint8_t aspect_ratio;
};

static size_t mypaint_blend_dab_serialize_payload(DP_MyPaintBlendDab *mpbd,
                                                  unsigned char *data)
{
    size_t written = 0;
    written += DP_write_bigendian_int8(mpbd->x, data + written);
    written += DP_write_bigendian_int8(mpbd->y, data + written);
    written += DP_write_bigendian_uint24(mpbd->size, data + written);
    written += DP_write_bigendian_uint8(mpbd->hardness, data + written);
    written += DP_write_bigendian_uint8(mpbd->opacity, data + written);
    written += DP_write_bigendian_uint8(mpbd->angle, data + written);
    written += DP_write_bigendian_uint8(mpbd->aspect_ratio, data + written);
    return written;
}

static size_t mypaint_blend_dab_serialize_payloads(DP_MyPaintBlendDab *mpbd,
                                                   int count,
                                                   unsigned char *data)
{
    size_t written = 0;
    for (int i = 0; i < count; ++i) {
        written +=
            mypaint_blend_dab_serialize_payload(&mpbd[i], data + written);
    }
    return written;
}

static bool mypaint_blend_dab_write_payload_text(DP_MyPaintBlendDab *mpbd,
                                                 DP_TextWriter *writer)
{
    return DP_text_writer_start_subobject(writer)
        && DP_text_writer_write_subfield_decimal(writer, "x",
                                                 (double)mpbd->x / 4.0)
        && DP_text_writer_write_subfield_decimal(writer, "y",
                                                 (double)mpbd->y / 4.0)
        && DP_text_writer_write_subfield_decimal(writer, "size",
                                                 (double)mpbd->size / 256.0)
        && DP_text_writer_write_subfield_uint(writer, "hardness",
                                              mpbd->hardness)
        && DP_text_writer_write_subfield_uint(writer, "opacity", mpbd->opacity)
        && DP_text_writer_write_subfield_uint(writer, "angle", mpbd->angle)
        && DP_text_writer_write_subfield_uint(writer, "aspect_ratio",
                                              mpbd->aspect_ratio)
        && DP_text_writer_finish_subobject(writer);
}

static size_t mypaint_blend_dab_write_payload_texts(DP_MyPaintBlendDab *mpbd,
                                                    int count,
                                                    DP_TextWriter *writer)
{
    if (count != 0) {
        if (!DP_text_writer_start_subs(writer)) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (!mypaint_blend_dab_write_payload_text(&mpbd[i], writer)) {
                return false;
            }
        }
        if (!DP_text_writer_finish_subs(writer)) {
            return false;
        }
    }
    return true;
}

static bool mypaint_blend_dab_equals(DP_MyPaintBlendDab *DP_RESTRICT a,
                                     DP_MyPaintBlendDab *DP_RESTRICT b)
{
    return a->x == b->x && a->y == b->y && a->size == b->size
        && a->hardness == b->hardness && a->opacity == b->opacity
        && a->angle == b->angle && a->aspect_ratio == b->aspect_ratio;
}

static bool mypaint_blend_dabs_equal(DP_MyPaintBlendDab *DP_RESTRICT a,
                                     DP_MyPaintBlendDab *DP_RESTRICT b,
                                     int count)
{
    for (int i = 0; i < count; ++i) {
        if (!mypaint_blend_dab_equals(&a[i], &b[i])) {
            return false;
        }
    }
    return true;
}

void DP_mypaint_blend_dab_init(DP_MyPaintBlendDab *mpbds, int i, int8_t x,
                               int8_t y, uint32_t size, uint8_t hardness,
                               uint8_t opacity, uint8_t angle,
                               uint8_t aspect_ratio)
{
    DP_ASSERT(mpbds);
    DP_MyPaintBlendDab *mpbd = &mpbds[i];
    mpbd->x = x;
    mpbd->y = y;
    mpbd->size = size;
    mpbd->hardness = hardness;
    mpbd->opacity = opacity;
    mpbd->angle = angle;
    mpbd->aspect_ratio = aspect_ratio;
}

static void mypaint_blend_dab_deserialize(int count, DP_MyPaintBlendDab *mpbds,
                                          void *user)
{
    const unsigned char *buffer = user;
    size_t read = 0;
    for (int i = 0; i < count; ++i) {
        int8_t x = read_int8(buffer + read, &read);
        int8_t y = read_int8(buffer + read, &read);
        uint32_t size = read_uint24(buffer + read, &read);
        uint8_t hardness = read_uint8(buffer + read, &read);
        uint8_t opacity = read_uint8(buffer + read, &read);
        uint8_t angle = read_uint8(buffer + read, &read);
        uint8_t aspect_ratio = read_uint8(buffer + read, &read);
        DP_mypaint_blend_dab_init(mpbds, i, x, y, size, hardness, opacity,
                                  angle, aspect_ratio);
    }
}

static void mypaint_blend_dab_parse(int count, DP_MyPaintBlendDab *mpbds,
                                    void *user)
{
    DP_TextReader *reader = user;
    for (int i = 0; i < count; ++i) {
        int8_t x = (int8_t)DP_text_reader_get_subfield_decimal(
            reader, i, "x", 4.0, INT8_MIN, INT8_MAX);
        int8_t y = (int8_t)DP_text_reader_get_subfield_decimal(
            reader, i, "y", 4.0, INT8_MIN, INT8_MAX);
        uint32_t size = (uint32_t)DP_text_reader_get_subfield_decimal(
            reader, i, "size", 256.0, 0, DP_UINT24_MAX);
        uint8_t hardness = (uint8_t)DP_text_reader_get_subfield_ulong(
            reader, i, "hardness", UINT8_MAX);
        uint8_t opacity = (uint8_t)DP_text_reader_get_subfield_ulong(
            reader, i, "opacity", UINT8_MAX);
        uint8_t angle = (uint8_t)DP_text_reader_get_subfield_ulong(
            reader, i, "angle", UINT8_MAX);
        uint8_t aspect_ratio = (uint8_t)DP_text_reader_get_subfield_ulong(
            reader, i, "aspect_ratio", UINT8_MAX);
        DP_mypaint_blend_dab_init(mpbds, i, x, y, size, hardness, opacity,
                                  angle, aspect_ratio);
    }
}

int8_t DP_mypaint_blend_dab_x(const DP_MyPaintBlendDab *mpbd)
{
    DP_ASSERT(mpbd);
    return mpbd->x;
}

int8_t DP_mypaint_blend_dab_y(const DP_MyPaintBlendDab *mpbd)
{
    DP_ASSERT(mpbd);
    return mpbd->y;
}

uint32_t DP_mypaint_blend_dab_size(const DP_MyPaintBlendDab *mpbd)
{
    DP_ASSERT(mpbd);
    return mpbd->size;
}

uint8_t DP_mypaint_blend_dab_hardness(const DP_MyPaintBlendDab *mpbd)
{
    DP_ASSERT(mpbd);
    return mpbd->hardness;
}

uint8_t DP_mypaint_blend_dab_opacity(const DP_MyPaintBlendDab *mpbd)
{
    DP_ASSERT(mpbd);
    return mpbd->opacity;
}

uint8_t DP_mypaint_blend_dab_angle(const DP_MyPaintBlendDab *mpbd)
{
    DP_ASSERT(mpbd);
    return mpbd->angle;
}

uint8_t DP_mypaint_blend_dab_aspect_ratio(const DP_MyPaintBlendDab *mpbd)
{
    DP_ASSERT(mpbd);
    return mpbd->aspect_ratio;
}

const DP_MyPaintBlendDab *
DP_mypaint_blend_dab_at(const DP_MyPaintBlendDab *mpbd, int i)
{
    DP_ASSERT(mpbd);
    return &mpbd[i];
}

struct DP_MsgDrawDabsMyPaintBlend {
    uint8_t flags;
    uint32_t layer;
    int32_t x;
    int32_t y;
    uint32_t color;
    uint8_t mode;
    uint16_t dabs_count;
    DP_MyPaintBlendDab dabs[];
};

static size_t msg_draw_dabs_mypaint_blend_payload_length(DP_Message *msg)
{
    DP_MsgDrawDabsMyPaintBlend *mddmpb = DP_message_internal(msg);
    return ((size_t)17) + DP_int_to_size(mddmpb->dabs_count) * 9;
}

static size_t msg_draw_dabs_mypaint_blend_serialize_payload(DP_Message *msg,
                                                            unsigned char *data)
{
    DP_MsgDrawDabsMyPaintBlend *mddmpb = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(mddmpb->flags, data + written);
    written += DP_write_bigendian_uint24(mddmpb->layer, data + written);
    written += DP_write_bigendian_int32(mddmpb->x, data + written);
    written += DP_write_bigendian_int32(mddmpb->y, data + written);
    written += DP_write_bigendian_uint32(mddmpb->color, data + written);
    written += DP_write_bigendian_uint8(mddmpb->mode, data + written);
    written += mypaint_blend_dab_serialize_payloads(
        mddmpb->dabs, mddmpb->dabs_count, data + written);
    DP_ASSERT(written == msg_draw_dabs_mypaint_blend_payload_length(msg));
    return written;
}

static bool
msg_draw_dabs_mypaint_blend_write_payload_text(DP_Message *msg,
                                               DP_TextWriter *writer)
{
    DP_MsgDrawDabsMyPaintBlend *mddmpb = DP_message_internal(msg);
    return DP_text_writer_write_argb_color(writer, "color", mddmpb->color)
        && DP_text_writer_write_uint(writer, "flags", mddmpb->flags)
        && DP_text_writer_write_uint(writer, "layer", mddmpb->layer)
        && DP_text_writer_write_blend_mode(writer, "mode", mddmpb->mode)
        && DP_text_writer_write_decimal(writer, "x", (double)mddmpb->x / 4.0)
        && DP_text_writer_write_decimal(writer, "y", (double)mddmpb->y / 4.0)
        && mypaint_blend_dab_write_payload_texts(mddmpb->dabs,
                                                 mddmpb->dabs_count, writer);
}

static bool msg_draw_dabs_mypaint_blend_equals(DP_Message *DP_RESTRICT msg,
                                               DP_Message *DP_RESTRICT other)
{
    DP_MsgDrawDabsMyPaintBlend *a = DP_message_internal(msg);
    DP_MsgDrawDabsMyPaintBlend *b = DP_message_internal(other);
    return a->flags == b->flags && a->layer == b->layer && a->x == b->x
        && a->y == b->y && a->color == b->color && a->mode == b->mode
        && a->dabs_count == b->dabs_count
        && mypaint_blend_dabs_equal(a->dabs, b->dabs, a->dabs_count);
}

void DP_msg_draw_dabs_mypaint_blend_local_match_set(DP_UNUSED size_t size,
                                                    unsigned char *data,
                                                    void *user)
{
    DP_ASSERT(size == DP_MSG_DRAW_DABS_MYPAINT_BLEND_MATCH_LENGTH);
    const DP_MsgDrawDabsMyPaintBlend *mddmpb = user;
    size_t written = 0;
    written += DP_write_bigendian_uint8(mddmpb->flags, data + written);
    written += DP_write_bigendian_uint24(mddmpb->layer, data + written);
    written += DP_write_bigendian_int32(mddmpb->x, data + written);
    written += DP_write_bigendian_int32(mddmpb->y, data + written);
    written += DP_write_bigendian_uint32(mddmpb->color, data + written);
    written += DP_write_bigendian_uint8(mddmpb->mode, data + written);
    written += DP_write_bigendian_uint16(mddmpb->dabs_count, data + written);
    DP_ASSERT(written == DP_MSG_DRAW_DABS_MYPAINT_BLEND_MATCH_LENGTH);
}

bool DP_msg_draw_dabs_mypaint_blend_local_match_matches(
    const DP_MsgDrawDabsMyPaintBlend *mddmpb, DP_Message *local_match_msg)
{
    size_t size;
    const unsigned char *buffer = local_match_data(local_match_msg, &size);
    size_t read = 0;
    return size == DP_MSG_DRAW_DABS_MYPAINT_BLEND_MATCH_LENGTH
        && read_uint8(buffer + read, &read) == mddmpb->flags
        && read_uint24(buffer + read, &read) == mddmpb->layer
        && read_int32(buffer + read, &read) == mddmpb->x
        && read_int32(buffer + read, &read) == mddmpb->y
        && read_uint32(buffer + read, &read) == mddmpb->color
        && read_uint8(buffer + read, &read) == mddmpb->mode
        && read_uint16(buffer + read, &read) == mddmpb->dabs_count;
}

static const DP_MessageMethods msg_draw_dabs_mypaint_blend_methods = {
    msg_draw_dabs_mypaint_blend_payload_length,
    msg_draw_dabs_mypaint_blend_serialize_payload,
    msg_draw_dabs_mypaint_blend_payload_length,
    msg_draw_dabs_mypaint_blend_serialize_payload,
    msg_draw_dabs_mypaint_blend_write_payload_text,
    msg_draw_dabs_mypaint_blend_equals,
};

DP_Message *DP_msg_draw_dabs_mypaint_blend_new(
    unsigned int context_id, uint8_t flags, uint32_t layer, int32_t x,
    int32_t y, uint32_t color, uint8_t mode,
    void (*set_dabs)(int, DP_MyPaintBlendDab *, void *), int dabs_count,
    void *dabs_user)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_DRAW_DABS_MYPAINT_BLEND, context_id,
                       &msg_draw_dabs_mypaint_blend_methods,
                       DP_FLEX_SIZEOF(DP_MsgDrawDabsMyPaintBlend, dabs,
                                      DP_int_to_size(dabs_count)
                                          * sizeof(DP_MyPaintBlendDab)));
    DP_MsgDrawDabsMyPaintBlend *mddmpb = DP_message_internal(msg);
    mddmpb->flags = flags;
    mddmpb->layer = layer;
    mddmpb->x = x;
    mddmpb->y = y;
    mddmpb->color = color;
    mddmpb->mode = mode;
    mddmpb->dabs_count = DP_int_to_uint16(dabs_count);
    set_dabs(mddmpb->dabs_count, mddmpb->dabs, dabs_user);
    return msg;
}

DP_Message *DP_msg_draw_dabs_mypaint_blend_deserialize(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length < 26 || length > 65528) {
        DP_error_set("Wrong length for mypaintdabsblend message; "
                     "expected between 26 and 65528, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t flags = read_uint8(buffer + read, &read);
    uint32_t layer = read_uint24(buffer + read, &read);
    int32_t x = read_int32(buffer + read, &read);
    int32_t y = read_int32(buffer + read, &read);
    uint32_t color = read_uint32(buffer + read, &read);
    uint8_t mode = read_uint8(buffer + read, &read);
    size_t dabs_bytes = length - read;
    if ((dabs_bytes % 9) != 0) {
        DP_error_set("Wrong length for dabs field in mypaintdabsblend message; "
                     "%zu not divisible by 9",
                     dabs_bytes);
        return NULL;
    }
    int dabs_count = DP_size_to_int(dabs_bytes) / 9;
    void *dabs_user = (void *)(buffer + read);
    return DP_msg_draw_dabs_mypaint_blend_new(
        context_id, flags, layer, x, y, color, mode,
        mypaint_blend_dab_deserialize, dabs_count, dabs_user);
}

DP_Message *DP_msg_draw_dabs_mypaint_blend_parse(unsigned int context_id,
                                                 DP_TextReader *reader)
{
    uint8_t flags =
        (uint8_t)DP_text_reader_get_ulong(reader, "flags", UINT8_MAX);
    uint32_t layer =
        (uint32_t)DP_text_reader_get_ulong(reader, "layer", DP_UINT24_MAX);
    int32_t x = (int32_t)DP_text_reader_get_decimal(reader, "x", 4.0, INT32_MIN,
                                                    INT32_MAX);
    int32_t y = (int32_t)DP_text_reader_get_decimal(reader, "y", 4.0, INT32_MIN,
                                                    INT32_MAX);
    uint32_t color = DP_text_reader_get_argb_color(reader, "color");
    uint8_t mode = DP_text_reader_get_blend_mode(reader, "mode");
    int dabs_count = DP_text_reader_get_sub_count(reader);
    void *dabs_user = reader;
    return DP_msg_draw_dabs_mypaint_blend_new(
        context_id, flags, layer, x, y, color, mode, mypaint_blend_dab_parse,
        dabs_count, dabs_user);
}

DP_MsgDrawDabsMyPaintBlend *DP_msg_draw_dabs_mypaint_blend_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_DRAW_DABS_MYPAINT_BLEND);
}

uint8_t
DP_msg_draw_dabs_mypaint_blend_flags(const DP_MsgDrawDabsMyPaintBlend *mddmpb)
{
    DP_ASSERT(mddmpb);
    return mddmpb->flags;
}

uint32_t
DP_msg_draw_dabs_mypaint_blend_layer(const DP_MsgDrawDabsMyPaintBlend *mddmpb)
{
    DP_ASSERT(mddmpb);
    return mddmpb->layer;
}

int32_t
DP_msg_draw_dabs_mypaint_blend_x(const DP_MsgDrawDabsMyPaintBlend *mddmpb)
{
    DP_ASSERT(mddmpb);
    return mddmpb->x;
}

int32_t
DP_msg_draw_dabs_mypaint_blend_y(const DP_MsgDrawDabsMyPaintBlend *mddmpb)
{
    DP_ASSERT(mddmpb);
    return mddmpb->y;
}

uint32_t
DP_msg_draw_dabs_mypaint_blend_color(const DP_MsgDrawDabsMyPaintBlend *mddmpb)
{
    DP_ASSERT(mddmpb);
    return mddmpb->color;
}

uint8_t
DP_msg_draw_dabs_mypaint_blend_mode(const DP_MsgDrawDabsMyPaintBlend *mddmpb)
{
    DP_ASSERT(mddmpb);
    return mddmpb->mode;
}

const DP_MyPaintBlendDab *
DP_msg_draw_dabs_mypaint_blend_dabs(const DP_MsgDrawDabsMyPaintBlend *mddmpb,
                                    int *out_count)
{
    DP_ASSERT(mddmpb);
    if (out_count) {
        *out_count = mddmpb->dabs_count;
    }
    return mddmpb->dabs;
}

int DP_msg_draw_dabs_mypaint_blend_dabs_count(
    const DP_MsgDrawDabsMyPaintBlend *mddmpb)
{
    return mddmpb->dabs_count;
}


/* DP_MSG_MOVE_RECT */

struct DP_MsgMoveRect {
    uint32_t layer;
    uint32_t source;
    int32_t sx;
    int32_t sy;
    int32_t tx;
    int32_t ty;
    int32_t w;
    int32_t h;
    uint8_t blend;
    uint8_t opacity;
    uint16_t mask_size;
    unsigned char mask[];
};

static size_t msg_move_rect_payload_length(DP_Message *msg)
{
    DP_MsgMoveRect *mmr = DP_message_internal(msg);
    return ((size_t)32) + mmr->mask_size;
}

static size_t msg_move_rect_payload_length_compat(DP_Message *msg)
{
    DP_MsgMoveRect *mmr = DP_message_internal(msg);
    return ((size_t)28) + mmr->mask_size;
}

static size_t msg_move_rect_serialize_payload(DP_Message *msg,
                                              unsigned char *data)
{
    DP_MsgMoveRect *mmr = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint24(mmr->layer, data + written);
    written += DP_write_bigendian_uint24(mmr->source, data + written);
    written += DP_write_bigendian_int32(mmr->sx, data + written);
    written += DP_write_bigendian_int32(mmr->sy, data + written);
    written += DP_write_bigendian_int32(mmr->tx, data + written);
    written += DP_write_bigendian_int32(mmr->ty, data + written);
    written += DP_write_bigendian_int32(mmr->w, data + written);
    written += DP_write_bigendian_int32(mmr->h, data + written);
    written += DP_write_bigendian_uint8(mmr->blend, data + written);
    written += DP_write_bigendian_uint8(mmr->opacity, data + written);
    written += write_bytes(mmr->mask, mmr->mask_size, data + written);
    DP_ASSERT(written == msg_move_rect_payload_length(msg));
    return written;
}

static size_t msg_move_rect_serialize_payload_compat(DP_Message *msg,
                                                     unsigned char *data)
{
    DP_MsgMoveRect *mmr = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(serialize_layer_id_compat(mmr->layer),
                                         data + written);
    written += DP_write_bigendian_uint16(serialize_layer_id_compat(mmr->source),
                                         data + written);
    written += DP_write_bigendian_int32(mmr->sx, data + written);
    written += DP_write_bigendian_int32(mmr->sy, data + written);
    written += DP_write_bigendian_int32(mmr->tx, data + written);
    written += DP_write_bigendian_int32(mmr->ty, data + written);
    written += DP_write_bigendian_int32(mmr->w, data + written);
    written += DP_write_bigendian_int32(mmr->h, data + written);
    written += write_bytes(mmr->mask, mmr->mask_size, data + written);
    DP_ASSERT(written == msg_move_rect_payload_length_compat(msg));
    return written;
}

static bool msg_move_rect_write_payload_text(DP_Message *msg,
                                             DP_TextWriter *writer)
{
    DP_MsgMoveRect *mmr = DP_message_internal(msg);
    return DP_text_writer_write_blend_mode(writer, "blend", mmr->blend)
        && DP_text_writer_write_int(writer, "h", mmr->h)
        && DP_text_writer_write_uint(writer, "layer", mmr->layer)
        && DP_text_writer_write_base64(writer, "mask", mmr->mask,
                                       mmr->mask_size)
        && DP_text_writer_write_uint(writer, "opacity", mmr->opacity)
        && DP_text_writer_write_uint(writer, "source", mmr->source)
        && DP_text_writer_write_int(writer, "sx", mmr->sx)
        && DP_text_writer_write_int(writer, "sy", mmr->sy)
        && DP_text_writer_write_int(writer, "tx", mmr->tx)
        && DP_text_writer_write_int(writer, "ty", mmr->ty)
        && DP_text_writer_write_int(writer, "w", mmr->w);
}

static bool msg_move_rect_equals(DP_Message *DP_RESTRICT msg,
                                 DP_Message *DP_RESTRICT other)
{
    DP_MsgMoveRect *a = DP_message_internal(msg);
    DP_MsgMoveRect *b = DP_message_internal(other);
    return a->layer == b->layer && a->source == b->source && a->sx == b->sx
        && a->sy == b->sy && a->tx == b->tx && a->ty == b->ty && a->w == b->w
        && a->h == b->h && a->blend == b->blend && a->opacity == b->opacity
        && a->mask_size == b->mask_size
        && memcmp(a->mask, b->mask, DP_uint16_to_size(a->mask_size)) == 0;
}

void DP_msg_move_rect_local_match_set(DP_UNUSED size_t size,
                                      unsigned char *data, void *user)
{
    DP_ASSERT(size == DP_MSG_MOVE_RECT_MATCH_LENGTH);
    const DP_MsgMoveRect *mmr = user;
    size_t written = 0;
    written += DP_write_bigendian_uint24(mmr->layer, data + written);
    written += DP_write_bigendian_uint24(mmr->source, data + written);
    written += DP_write_bigendian_int32(mmr->sx, data + written);
    written += DP_write_bigendian_int32(mmr->sy, data + written);
    written += DP_write_bigendian_int32(mmr->tx, data + written);
    written += DP_write_bigendian_int32(mmr->ty, data + written);
    written += DP_write_bigendian_int32(mmr->w, data + written);
    written += DP_write_bigendian_int32(mmr->h, data + written);
    written += DP_write_bigendian_uint8(mmr->blend, data + written);
    written += DP_write_bigendian_uint8(mmr->opacity, data + written);
    written += DP_write_bigendian_uint16(mmr->mask_size, data + written);
    DP_ASSERT(written == DP_MSG_MOVE_RECT_MATCH_LENGTH);
}

bool DP_msg_move_rect_local_match_matches(const DP_MsgMoveRect *mmr,
                                          DP_Message *local_match_msg)
{
    size_t size;
    const unsigned char *buffer = local_match_data(local_match_msg, &size);
    size_t read = 0;
    return size == DP_MSG_MOVE_RECT_MATCH_LENGTH
        && read_uint24(buffer + read, &read) == mmr->layer
        && read_uint24(buffer + read, &read) == mmr->source
        && read_int32(buffer + read, &read) == mmr->sx
        && read_int32(buffer + read, &read) == mmr->sy
        && read_int32(buffer + read, &read) == mmr->tx
        && read_int32(buffer + read, &read) == mmr->ty
        && read_int32(buffer + read, &read) == mmr->w
        && read_int32(buffer + read, &read) == mmr->h
        && read_uint8(buffer + read, &read) == mmr->blend
        && read_uint8(buffer + read, &read) == mmr->opacity
        && read_uint16(buffer + read, &read) == mmr->mask_size;
}

static const DP_MessageMethods msg_move_rect_methods = {
    msg_move_rect_payload_length,        msg_move_rect_serialize_payload,
    msg_move_rect_payload_length_compat, msg_move_rect_serialize_payload_compat,
    msg_move_rect_write_payload_text,    msg_move_rect_equals,
};

DP_Message *
DP_msg_move_rect_new(unsigned int context_id, uint32_t layer, uint32_t source,
                     int32_t sx, int32_t sy, int32_t tx, int32_t ty, int32_t w,
                     int32_t h, uint8_t blend, uint8_t opacity,
                     void (*set_mask)(size_t, unsigned char *, void *),
                     size_t mask_size, void *mask_user)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_MOVE_RECT, context_id, &msg_move_rect_methods,
                       DP_FLEX_SIZEOF(DP_MsgMoveRect, mask, mask_size));
    DP_MsgMoveRect *mmr = DP_message_internal(msg);
    mmr->layer = layer;
    mmr->source = source;
    mmr->sx = sx;
    mmr->sy = sy;
    mmr->tx = tx;
    mmr->ty = ty;
    mmr->w = w;
    mmr->h = h;
    mmr->blend = blend;
    mmr->opacity = opacity;
    mmr->mask_size = DP_size_to_uint16(mask_size);
    if (set_mask) {
        set_mask(mmr->mask_size, mmr->mask, mask_user);
    }
    return msg;
}

DP_Message *DP_msg_move_rect_deserialize(unsigned int context_id,
                                         const unsigned char *buffer,
                                         size_t length)
{
    if (length < 32 || length > 65535) {
        DP_error_set("Wrong length for moverect message; "
                     "expected between 32 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint32_t layer = read_uint24(buffer + read, &read);
    uint32_t source = read_uint24(buffer + read, &read);
    int32_t sx = read_int32(buffer + read, &read);
    int32_t sy = read_int32(buffer + read, &read);
    int32_t tx = read_int32(buffer + read, &read);
    int32_t ty = read_int32(buffer + read, &read);
    int32_t w = read_int32(buffer + read, &read);
    int32_t h = read_int32(buffer + read, &read);
    uint8_t blend = read_uint8(buffer + read, &read);
    uint8_t opacity = read_uint8(buffer + read, &read);
    size_t mask_bytes = length - read;
    uint16_t mask_size = DP_size_to_uint16(mask_bytes);
    void *mask_user = (void *)(buffer + read);
    return DP_msg_move_rect_new(context_id, layer, source, sx, sy, tx, ty, w, h,
                                blend, opacity, read_bytes, mask_size,
                                mask_user);
}

DP_Message *DP_msg_move_rect_deserialize_compat(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length)
{
    if (length < 28 || length > 65535) {
        DP_error_set("Wrong length for moverect compat message; "
                     "expected between 28 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t layer = read_uint16(buffer + read, &read);
    uint16_t source = read_uint16(buffer + read, &read);
    int32_t sx = read_int32(buffer + read, &read);
    int32_t sy = read_int32(buffer + read, &read);
    int32_t tx = read_int32(buffer + read, &read);
    int32_t ty = read_int32(buffer + read, &read);
    int32_t w = read_int32(buffer + read, &read);
    int32_t h = read_int32(buffer + read, &read);
    size_t mask_bytes = length - read;
    uint16_t mask_size = DP_size_to_uint16(mask_bytes);
    void *mask_user = (void *)(buffer + read);
    DP_Message *msg = DP_msg_move_rect_new(
        context_id, deserialize_layer_id_compat(layer),
        deserialize_layer_id_compat(source), sx, sy, tx, ty, w, h,
        (uint8_t)DP_BLEND_MODE_NORMAL, 255, read_bytes, mask_size, mask_user);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_move_rect_parse(unsigned int context_id,
                                   DP_TextReader *reader)
{
    uint32_t layer =
        (uint32_t)DP_text_reader_get_ulong(reader, "layer", DP_UINT24_MAX);
    uint32_t source =
        (uint32_t)DP_text_reader_get_ulong(reader, "source", DP_UINT24_MAX);
    int32_t sx =
        (int32_t)DP_text_reader_get_long(reader, "sx", INT32_MIN, INT32_MAX);
    int32_t sy =
        (int32_t)DP_text_reader_get_long(reader, "sy", INT32_MIN, INT32_MAX);
    int32_t tx =
        (int32_t)DP_text_reader_get_long(reader, "tx", INT32_MIN, INT32_MAX);
    int32_t ty =
        (int32_t)DP_text_reader_get_long(reader, "ty", INT32_MIN, INT32_MAX);
    int32_t w =
        (int32_t)DP_text_reader_get_long(reader, "w", INT32_MIN, INT32_MAX);
    int32_t h =
        (int32_t)DP_text_reader_get_long(reader, "h", INT32_MIN, INT32_MAX);
    uint8_t blend = DP_text_reader_get_blend_mode(reader, "blend");
    uint8_t opacity =
        (uint8_t)DP_text_reader_get_ulong(reader, "opacity", UINT8_MAX);
    size_t mask_size;
    DP_TextReaderParseParams mask_params =
        DP_text_reader_get_base64_string(reader, "mask", &mask_size);
    return DP_msg_move_rect_new(context_id, layer, source, sx, sy, tx, ty, w, h,
                                blend, opacity, DP_text_reader_parse_base64,
                                mask_size, &mask_params);
}

DP_MsgMoveRect *DP_msg_move_rect_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_MOVE_RECT);
}

uint32_t DP_msg_move_rect_layer(const DP_MsgMoveRect *mmr)
{
    DP_ASSERT(mmr);
    return mmr->layer;
}

uint32_t DP_msg_move_rect_source(const DP_MsgMoveRect *mmr)
{
    DP_ASSERT(mmr);
    return mmr->source;
}

int32_t DP_msg_move_rect_sx(const DP_MsgMoveRect *mmr)
{
    DP_ASSERT(mmr);
    return mmr->sx;
}

int32_t DP_msg_move_rect_sy(const DP_MsgMoveRect *mmr)
{
    DP_ASSERT(mmr);
    return mmr->sy;
}

int32_t DP_msg_move_rect_tx(const DP_MsgMoveRect *mmr)
{
    DP_ASSERT(mmr);
    return mmr->tx;
}

int32_t DP_msg_move_rect_ty(const DP_MsgMoveRect *mmr)
{
    DP_ASSERT(mmr);
    return mmr->ty;
}

int32_t DP_msg_move_rect_w(const DP_MsgMoveRect *mmr)
{
    DP_ASSERT(mmr);
    return mmr->w;
}

int32_t DP_msg_move_rect_h(const DP_MsgMoveRect *mmr)
{
    DP_ASSERT(mmr);
    return mmr->h;
}

uint8_t DP_msg_move_rect_blend(const DP_MsgMoveRect *mmr)
{
    DP_ASSERT(mmr);
    return mmr->blend;
}

uint8_t DP_msg_move_rect_opacity(const DP_MsgMoveRect *mmr)
{
    DP_ASSERT(mmr);
    return mmr->opacity;
}

const unsigned char *DP_msg_move_rect_mask(const DP_MsgMoveRect *mmr,
                                           size_t *out_size)
{
    DP_ASSERT(mmr);
    if (out_size) {
        *out_size = mmr->mask_size;
    }
    return mmr->mask;
}

size_t DP_msg_move_rect_mask_size(const DP_MsgMoveRect *mmr)
{
    return mmr->mask_size;
}


/* DP_MSG_SET_METADATA_INT */

const char *DP_msg_set_metadata_int_field_variant_name(unsigned int value)
{
    switch (value) {
    case DP_MSG_SET_METADATA_INT_FIELD_DPIX:
        return "Dpix";
    case DP_MSG_SET_METADATA_INT_FIELD_DPIY:
        return "Dpiy";
    case DP_MSG_SET_METADATA_INT_FIELD_FRAMERATE:
        return "Framerate";
    case DP_MSG_SET_METADATA_INT_FIELD_FRAME_COUNT:
        return "FrameCount";
    case DP_MSG_SET_METADATA_INT_FIELD_FRAMERATE_FRACTION:
        return "FramerateFraction";
    case DP_MSG_SET_METADATA_INT_FIELD_FRAME_RANGE_FIRST:
        return "FrameRangeFirst";
    case DP_MSG_SET_METADATA_INT_FIELD_FRAME_RANGE_LAST:
        return "FrameRangeLast";
    default:
        return NULL;
    }
}

struct DP_MsgSetMetadataInt {
    uint8_t field;
    int32_t value;
};

static size_t msg_set_metadata_int_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)5);
}

static size_t msg_set_metadata_int_serialize_payload(DP_Message *msg,
                                                     unsigned char *data)
{
    DP_MsgSetMetadataInt *msmi = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(msmi->field, data + written);
    written += DP_write_bigendian_int32(msmi->value, data + written);
    DP_ASSERT(written == msg_set_metadata_int_payload_length(msg));
    return written;
}

static bool msg_set_metadata_int_write_payload_text(DP_Message *msg,
                                                    DP_TextWriter *writer)
{
    DP_MsgSetMetadataInt *msmi = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "field", msmi->field)
        && DP_text_writer_write_int(writer, "value", msmi->value);
}

static bool msg_set_metadata_int_equals(DP_Message *DP_RESTRICT msg,
                                        DP_Message *DP_RESTRICT other)
{
    DP_MsgSetMetadataInt *a = DP_message_internal(msg);
    DP_MsgSetMetadataInt *b = DP_message_internal(other);
    return a->field == b->field && a->value == b->value;
}

static const DP_MessageMethods msg_set_metadata_int_methods = {
    msg_set_metadata_int_payload_length,
    msg_set_metadata_int_serialize_payload,
    msg_set_metadata_int_payload_length,
    msg_set_metadata_int_serialize_payload,
    msg_set_metadata_int_write_payload_text,
    msg_set_metadata_int_equals,
};

DP_Message *DP_msg_set_metadata_int_new(unsigned int context_id, uint8_t field,
                                        int32_t value)
{
    DP_Message *msg = DP_message_new(DP_MSG_SET_METADATA_INT, context_id,
                                     &msg_set_metadata_int_methods,
                                     sizeof(DP_MsgSetMetadataInt));
    DP_MsgSetMetadataInt *msmi = DP_message_internal(msg);
    msmi->field = field;
    msmi->value = value;
    return msg;
}

DP_Message *DP_msg_set_metadata_int_deserialize(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length)
{
    if (length != 5) {
        DP_error_set("Wrong length for setmetadataint message; "
                     "expected 5, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t field = read_uint8(buffer + read, &read);
    int32_t value = read_int32(buffer + read, &read);
    return DP_msg_set_metadata_int_new(context_id, field, value);
}

DP_Message *DP_msg_set_metadata_int_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    DP_Message *msg =
        DP_msg_set_metadata_int_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_set_metadata_int_parse(unsigned int context_id,
                                          DP_TextReader *reader)
{
    uint8_t field =
        (uint8_t)DP_text_reader_get_ulong(reader, "field", UINT8_MAX);
    int32_t value =
        (int32_t)DP_text_reader_get_long(reader, "value", INT32_MIN, INT32_MAX);
    return DP_msg_set_metadata_int_new(context_id, field, value);
}

DP_MsgSetMetadataInt *DP_msg_set_metadata_int_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_SET_METADATA_INT);
}

uint8_t DP_msg_set_metadata_int_field(const DP_MsgSetMetadataInt *msmi)
{
    DP_ASSERT(msmi);
    return msmi->field;
}

int32_t DP_msg_set_metadata_int_value(const DP_MsgSetMetadataInt *msmi)
{
    DP_ASSERT(msmi);
    return msmi->value;
}


/* DP_MSG_LAYER_TREE_CREATE */

const char *DP_msg_layer_tree_create_flags_flag_name(unsigned int value)
{
    switch (value) {
    case DP_MSG_LAYER_TREE_CREATE_FLAGS_GROUP:
        return "group";
    case DP_MSG_LAYER_TREE_CREATE_FLAGS_INTO:
        return "into";
    default:
        return NULL;
    }
}

struct DP_MsgLayerTreeCreate {
    uint32_t id;
    uint32_t source;
    uint32_t target;
    uint32_t fill;
    uint8_t flags;
    uint16_t title_len;
    char title[];
};

static size_t msg_layer_tree_create_payload_length(DP_Message *msg)
{
    DP_MsgLayerTreeCreate *mltc = DP_message_internal(msg);
    return ((size_t)14) + DP_uint16_to_size(mltc->title_len);
}

static size_t msg_layer_tree_create_payload_length_compat(DP_Message *msg)
{
    DP_MsgLayerTreeCreate *mltc = DP_message_internal(msg);
    return ((size_t)11) + DP_uint16_to_size(mltc->title_len);
}

static size_t msg_layer_tree_create_serialize_payload(DP_Message *msg,
                                                      unsigned char *data)
{
    DP_MsgLayerTreeCreate *mltc = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint24(mltc->id, data + written);
    written += DP_write_bigendian_uint24(mltc->source, data + written);
    written += DP_write_bigendian_uint24(mltc->target, data + written);
    written += DP_write_bigendian_uint32(mltc->fill, data + written);
    written += DP_write_bigendian_uint8(mltc->flags, data + written);
    written += DP_write_bytes(mltc->title, 1, mltc->title_len, data + written);
    DP_ASSERT(written == msg_layer_tree_create_payload_length(msg));
    return written;
}

static size_t
msg_layer_tree_create_serialize_payload_compat(DP_Message *msg,
                                               unsigned char *data)
{
    DP_MsgLayerTreeCreate *mltc = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(serialize_layer_id_compat(mltc->id),
                                         data + written);
    written += DP_write_bigendian_uint16(
        serialize_layer_id_compat(mltc->source), data + written);
    written += DP_write_bigendian_uint16(
        serialize_layer_id_compat(mltc->target), data + written);
    written += DP_write_bigendian_uint32(mltc->fill, data + written);
    written += DP_write_bigendian_uint8(mltc->flags, data + written);
    written += DP_write_bytes(mltc->title, 1, mltc->title_len, data + written);
    DP_ASSERT(written == msg_layer_tree_create_payload_length_compat(msg));
    return written;
}

static bool msg_layer_tree_create_write_payload_text(DP_Message *msg,
                                                     DP_TextWriter *writer)
{
    DP_MsgLayerTreeCreate *mltc = DP_message_internal(msg);
    return DP_text_writer_write_argb_color(writer, "fill", mltc->fill)
        && DP_text_writer_write_flags(
               writer, "flags", mltc->flags, 2,
               (const char *[]){"group", "into"},
               (unsigned int[]){DP_MSG_LAYER_TREE_CREATE_FLAGS_GROUP,
                                DP_MSG_LAYER_TREE_CREATE_FLAGS_INTO})
        && DP_text_writer_write_uint(writer, "id", mltc->id)
        && DP_text_writer_write_uint(writer, "source", mltc->source)
        && DP_text_writer_write_uint(writer, "target", mltc->target)
        && DP_text_writer_write_string(writer, "title", mltc->title);
}

static bool msg_layer_tree_create_equals(DP_Message *DP_RESTRICT msg,
                                         DP_Message *DP_RESTRICT other)
{
    DP_MsgLayerTreeCreate *a = DP_message_internal(msg);
    DP_MsgLayerTreeCreate *b = DP_message_internal(other);
    return a->id == b->id && a->source == b->source && a->target == b->target
        && a->fill == b->fill && a->flags == b->flags
        && a->title_len == b->title_len
        && memcmp(a->title, b->title, a->title_len) == 0;
}

static const DP_MessageMethods msg_layer_tree_create_methods = {
    msg_layer_tree_create_payload_length,
    msg_layer_tree_create_serialize_payload,
    msg_layer_tree_create_payload_length_compat,
    msg_layer_tree_create_serialize_payload_compat,
    msg_layer_tree_create_write_payload_text,
    msg_layer_tree_create_equals,
};

DP_Message *DP_msg_layer_tree_create_new(unsigned int context_id, uint32_t id,
                                         uint32_t source, uint32_t target,
                                         uint32_t fill, uint8_t flags,
                                         const char *title_value,
                                         size_t title_len)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_LAYER_TREE_CREATE, context_id, &msg_layer_tree_create_methods,
        DP_FLEX_SIZEOF(DP_MsgLayerTreeCreate, title, title_len + 1));
    DP_MsgLayerTreeCreate *mltc = DP_message_internal(msg);
    mltc->id = id;
    mltc->source = source;
    mltc->target = target;
    mltc->fill = fill;
    mltc->flags = flags;
    mltc->title_len = DP_size_to_uint16(title_len);
    assign_string(mltc->title, title_value, mltc->title_len);
    return msg;
}

DP_Message *DP_msg_layer_tree_create_deserialize(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length)
{
    if (length < 14 || length > 65535) {
        DP_error_set("Wrong length for layertreecreate message; "
                     "expected between 14 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint32_t id = read_uint24(buffer + read, &read);
    uint32_t source = read_uint24(buffer + read, &read);
    uint32_t target = read_uint24(buffer + read, &read);
    uint32_t fill = read_uint32(buffer + read, &read);
    uint8_t flags = read_uint8(buffer + read, &read);
    size_t title_bytes = length - read;
    uint16_t title_len = DP_size_to_uint16(title_bytes);
    const char *title = (const char *)buffer + read;
    return DP_msg_layer_tree_create_new(context_id, id, source, target, fill,
                                        flags, title, title_len);
}

DP_Message *DP_msg_layer_tree_create_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length < 11 || length > 65535) {
        DP_error_set("Wrong length for layertreecreate compat message; "
                     "expected between 11 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    uint16_t source = read_uint16(buffer + read, &read);
    uint16_t target = read_uint16(buffer + read, &read);
    uint32_t fill = read_uint32(buffer + read, &read);
    uint8_t flags = read_uint8(buffer + read, &read);
    size_t title_bytes = length - read;
    uint16_t title_len = DP_size_to_uint16(title_bytes);
    const char *title = (const char *)buffer + read;
    DP_Message *msg = DP_msg_layer_tree_create_new(
        context_id, deserialize_layer_id_compat(id),
        deserialize_layer_id_compat(source),
        deserialize_layer_id_compat(target), fill, flags, title, title_len);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_layer_tree_create_parse(unsigned int context_id,
                                           DP_TextReader *reader)
{
    uint32_t id =
        (uint32_t)DP_text_reader_get_ulong(reader, "id", DP_UINT24_MAX);
    uint32_t source =
        (uint32_t)DP_text_reader_get_ulong(reader, "source", DP_UINT24_MAX);
    uint32_t target =
        (uint32_t)DP_text_reader_get_ulong(reader, "target", DP_UINT24_MAX);
    uint32_t fill = DP_text_reader_get_argb_color(reader, "fill");
    uint8_t flags = (uint8_t)DP_text_reader_get_flags(
        reader, "flags", 2, (const char *[]){"group", "into"},
        (unsigned int[]){DP_MSG_LAYER_TREE_CREATE_FLAGS_GROUP,
                         DP_MSG_LAYER_TREE_CREATE_FLAGS_INTO});
    uint16_t title_len;
    const char *title = DP_text_reader_get_string(reader, "title", &title_len);
    return DP_msg_layer_tree_create_new(context_id, id, source, target, fill,
                                        flags, title, title_len);
}

DP_MsgLayerTreeCreate *DP_msg_layer_tree_create_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_LAYER_TREE_CREATE);
}

uint32_t DP_msg_layer_tree_create_id(const DP_MsgLayerTreeCreate *mltc)
{
    DP_ASSERT(mltc);
    return mltc->id;
}

uint32_t DP_msg_layer_tree_create_source(const DP_MsgLayerTreeCreate *mltc)
{
    DP_ASSERT(mltc);
    return mltc->source;
}

uint32_t DP_msg_layer_tree_create_target(const DP_MsgLayerTreeCreate *mltc)
{
    DP_ASSERT(mltc);
    return mltc->target;
}

uint32_t DP_msg_layer_tree_create_fill(const DP_MsgLayerTreeCreate *mltc)
{
    DP_ASSERT(mltc);
    return mltc->fill;
}

uint8_t DP_msg_layer_tree_create_flags(const DP_MsgLayerTreeCreate *mltc)
{
    DP_ASSERT(mltc);
    return mltc->flags;
}

const char *DP_msg_layer_tree_create_title(const DP_MsgLayerTreeCreate *mltc,
                                           size_t *out_len)
{
    DP_ASSERT(mltc);
    if (out_len) {
        *out_len = mltc->title_len;
    }
    return mltc->title;
}

size_t DP_msg_layer_tree_create_title_len(const DP_MsgLayerTreeCreate *mltc)
{
    return mltc->title_len;
}


/* DP_MSG_LAYER_TREE_MOVE */

struct DP_MsgLayerTreeMove {
    uint32_t layer;
    uint32_t parent;
    uint32_t sibling;
};

static size_t msg_layer_tree_move_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)9);
}

static size_t
msg_layer_tree_move_payload_length_compat(DP_UNUSED DP_Message *msg)
{
    return ((size_t)6);
}

static size_t msg_layer_tree_move_serialize_payload(DP_Message *msg,
                                                    unsigned char *data)
{
    DP_MsgLayerTreeMove *mltm = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint24(mltm->layer, data + written);
    written += DP_write_bigendian_uint24(mltm->parent, data + written);
    written += DP_write_bigendian_uint24(mltm->sibling, data + written);
    DP_ASSERT(written == msg_layer_tree_move_payload_length(msg));
    return written;
}

static size_t msg_layer_tree_move_serialize_payload_compat(DP_Message *msg,
                                                           unsigned char *data)
{
    DP_MsgLayerTreeMove *mltm = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(serialize_layer_id_compat(mltm->layer),
                                         data + written);
    written += DP_write_bigendian_uint16(
        serialize_layer_id_compat(mltm->parent), data + written);
    written += DP_write_bigendian_uint16(
        serialize_layer_id_compat(mltm->sibling), data + written);
    DP_ASSERT(written == msg_layer_tree_move_payload_length_compat(msg));
    return written;
}

static bool msg_layer_tree_move_write_payload_text(DP_Message *msg,
                                                   DP_TextWriter *writer)
{
    DP_MsgLayerTreeMove *mltm = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "layer", mltm->layer)
        && DP_text_writer_write_uint(writer, "parent", mltm->parent)
        && DP_text_writer_write_uint(writer, "sibling", mltm->sibling);
}

static bool msg_layer_tree_move_equals(DP_Message *DP_RESTRICT msg,
                                       DP_Message *DP_RESTRICT other)
{
    DP_MsgLayerTreeMove *a = DP_message_internal(msg);
    DP_MsgLayerTreeMove *b = DP_message_internal(other);
    return a->layer == b->layer && a->parent == b->parent
        && a->sibling == b->sibling;
}

static const DP_MessageMethods msg_layer_tree_move_methods = {
    msg_layer_tree_move_payload_length,
    msg_layer_tree_move_serialize_payload,
    msg_layer_tree_move_payload_length_compat,
    msg_layer_tree_move_serialize_payload_compat,
    msg_layer_tree_move_write_payload_text,
    msg_layer_tree_move_equals,
};

DP_Message *DP_msg_layer_tree_move_new(unsigned int context_id, uint32_t layer,
                                       uint32_t parent, uint32_t sibling)
{
    DP_Message *msg = DP_message_new(DP_MSG_LAYER_TREE_MOVE, context_id,
                                     &msg_layer_tree_move_methods,
                                     sizeof(DP_MsgLayerTreeMove));
    DP_MsgLayerTreeMove *mltm = DP_message_internal(msg);
    mltm->layer = layer;
    mltm->parent = parent;
    mltm->sibling = sibling;
    return msg;
}

DP_Message *DP_msg_layer_tree_move_deserialize(unsigned int context_id,
                                               const unsigned char *buffer,
                                               size_t length)
{
    if (length != 9) {
        DP_error_set("Wrong length for layertreemove message; "
                     "expected 9, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint32_t layer = read_uint24(buffer + read, &read);
    uint32_t parent = read_uint24(buffer + read, &read);
    uint32_t sibling = read_uint24(buffer + read, &read);
    return DP_msg_layer_tree_move_new(context_id, layer, parent, sibling);
}

DP_Message *DP_msg_layer_tree_move_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length != 6) {
        DP_error_set("Wrong length for layertreemove compat message; "
                     "expected 6, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t layer = read_uint16(buffer + read, &read);
    uint16_t parent = read_uint16(buffer + read, &read);
    uint16_t sibling = read_uint16(buffer + read, &read);
    DP_Message *msg = DP_msg_layer_tree_move_new(
        context_id, deserialize_layer_id_compat(layer),
        deserialize_layer_id_compat(parent),
        deserialize_layer_id_compat(sibling));
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_layer_tree_move_parse(unsigned int context_id,
                                         DP_TextReader *reader)
{
    uint32_t layer =
        (uint32_t)DP_text_reader_get_ulong(reader, "layer", DP_UINT24_MAX);
    uint32_t parent =
        (uint32_t)DP_text_reader_get_ulong(reader, "parent", DP_UINT24_MAX);
    uint32_t sibling =
        (uint32_t)DP_text_reader_get_ulong(reader, "sibling", DP_UINT24_MAX);
    return DP_msg_layer_tree_move_new(context_id, layer, parent, sibling);
}

DP_MsgLayerTreeMove *DP_msg_layer_tree_move_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_LAYER_TREE_MOVE);
}

uint32_t DP_msg_layer_tree_move_layer(const DP_MsgLayerTreeMove *mltm)
{
    DP_ASSERT(mltm);
    return mltm->layer;
}

uint32_t DP_msg_layer_tree_move_parent(const DP_MsgLayerTreeMove *mltm)
{
    DP_ASSERT(mltm);
    return mltm->parent;
}

uint32_t DP_msg_layer_tree_move_sibling(const DP_MsgLayerTreeMove *mltm)
{
    DP_ASSERT(mltm);
    return mltm->sibling;
}


/* DP_MSG_LAYER_TREE_DELETE */

struct DP_MsgLayerTreeDelete {
    uint32_t id;
    uint32_t merge_to;
};

static size_t msg_layer_tree_delete_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)6);
}

static size_t
msg_layer_tree_delete_payload_length_compat(DP_UNUSED DP_Message *msg)
{
    return ((size_t)4);
}

static size_t msg_layer_tree_delete_serialize_payload(DP_Message *msg,
                                                      unsigned char *data)
{
    DP_MsgLayerTreeDelete *mltd = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint24(mltd->id, data + written);
    written += DP_write_bigendian_uint24(mltd->merge_to, data + written);
    DP_ASSERT(written == msg_layer_tree_delete_payload_length(msg));
    return written;
}

static size_t
msg_layer_tree_delete_serialize_payload_compat(DP_Message *msg,
                                               unsigned char *data)
{
    DP_MsgLayerTreeDelete *mltd = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(serialize_layer_id_compat(mltd->id),
                                         data + written);
    written += DP_write_bigendian_uint16(
        serialize_layer_id_compat(mltd->merge_to), data + written);
    DP_ASSERT(written == msg_layer_tree_delete_payload_length_compat(msg));
    return written;
}

static bool msg_layer_tree_delete_write_payload_text(DP_Message *msg,
                                                     DP_TextWriter *writer)
{
    DP_MsgLayerTreeDelete *mltd = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "id", mltd->id)
        && DP_text_writer_write_uint(writer, "merge_to", mltd->merge_to);
}

static bool msg_layer_tree_delete_equals(DP_Message *DP_RESTRICT msg,
                                         DP_Message *DP_RESTRICT other)
{
    DP_MsgLayerTreeDelete *a = DP_message_internal(msg);
    DP_MsgLayerTreeDelete *b = DP_message_internal(other);
    return a->id == b->id && a->merge_to == b->merge_to;
}

static const DP_MessageMethods msg_layer_tree_delete_methods = {
    msg_layer_tree_delete_payload_length,
    msg_layer_tree_delete_serialize_payload,
    msg_layer_tree_delete_payload_length_compat,
    msg_layer_tree_delete_serialize_payload_compat,
    msg_layer_tree_delete_write_payload_text,
    msg_layer_tree_delete_equals,
};

DP_Message *DP_msg_layer_tree_delete_new(unsigned int context_id, uint32_t id,
                                         uint32_t merge_to)
{
    DP_Message *msg = DP_message_new(DP_MSG_LAYER_TREE_DELETE, context_id,
                                     &msg_layer_tree_delete_methods,
                                     sizeof(DP_MsgLayerTreeDelete));
    DP_MsgLayerTreeDelete *mltd = DP_message_internal(msg);
    mltd->id = id;
    mltd->merge_to = merge_to;
    return msg;
}

DP_Message *DP_msg_layer_tree_delete_deserialize(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length)
{
    if (length != 6) {
        DP_error_set("Wrong length for layertreedelete message; "
                     "expected 6, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint32_t id = read_uint24(buffer + read, &read);
    uint32_t merge_to = read_uint24(buffer + read, &read);
    return DP_msg_layer_tree_delete_new(context_id, id, merge_to);
}

DP_Message *DP_msg_layer_tree_delete_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length != 4) {
        DP_error_set("Wrong length for layertreedelete compat message; "
                     "expected 4, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    uint16_t merge_to = read_uint16(buffer + read, &read);
    DP_Message *msg = DP_msg_layer_tree_delete_new(
        context_id, deserialize_layer_id_compat(id),
        deserialize_layer_id_compat(merge_to));
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_layer_tree_delete_parse(unsigned int context_id,
                                           DP_TextReader *reader)
{
    uint32_t id =
        (uint32_t)DP_text_reader_get_ulong(reader, "id", DP_UINT24_MAX);
    uint32_t merge_to =
        (uint32_t)DP_text_reader_get_ulong(reader, "merge_to", DP_UINT24_MAX);
    return DP_msg_layer_tree_delete_new(context_id, id, merge_to);
}

DP_MsgLayerTreeDelete *DP_msg_layer_tree_delete_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_LAYER_TREE_DELETE);
}

uint32_t DP_msg_layer_tree_delete_id(const DP_MsgLayerTreeDelete *mltd)
{
    DP_ASSERT(mltd);
    return mltd->id;
}

uint32_t DP_msg_layer_tree_delete_merge_to(const DP_MsgLayerTreeDelete *mltd)
{
    DP_ASSERT(mltd);
    return mltd->merge_to;
}


/* DP_MSG_TRANSFORM_REGION */

const char *DP_msg_transform_region_mode_variant_name(unsigned int value)
{
    switch (value) {
    case DP_MSG_TRANSFORM_REGION_MODE_NEAREST:
        return "Nearest";
    case DP_MSG_TRANSFORM_REGION_MODE_BILINEAR:
        return "Bilinear";
    case DP_MSG_TRANSFORM_REGION_MODE_BINARY:
        return "Binary";
    default:
        return NULL;
    }
}

struct DP_MsgTransformRegion {
    uint32_t layer;
    uint32_t source;
    int32_t bx;
    int32_t by;
    int32_t bw;
    int32_t bh;
    int32_t x1;
    int32_t y1;
    int32_t x2;
    int32_t y2;
    int32_t x3;
    int32_t y3;
    int32_t x4;
    int32_t y4;
    uint8_t mode;
    uint8_t blend;
    uint8_t opacity;
    uint16_t mask_size;
    unsigned char mask[];
};

static size_t msg_transform_region_payload_length(DP_Message *msg)
{
    DP_MsgTransformRegion *mtr = DP_message_internal(msg);
    return ((size_t)57) + mtr->mask_size;
}

static size_t msg_transform_region_payload_length_compat(DP_Message *msg)
{
    DP_MsgTransformRegion *mtr = DP_message_internal(msg);
    return ((size_t)53) + mtr->mask_size;
}

static size_t msg_transform_region_serialize_payload(DP_Message *msg,
                                                     unsigned char *data)
{
    DP_MsgTransformRegion *mtr = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint24(mtr->layer, data + written);
    written += DP_write_bigendian_uint24(mtr->source, data + written);
    written += DP_write_bigendian_int32(mtr->bx, data + written);
    written += DP_write_bigendian_int32(mtr->by, data + written);
    written += DP_write_bigendian_int32(mtr->bw, data + written);
    written += DP_write_bigendian_int32(mtr->bh, data + written);
    written += DP_write_bigendian_int32(mtr->x1, data + written);
    written += DP_write_bigendian_int32(mtr->y1, data + written);
    written += DP_write_bigendian_int32(mtr->x2, data + written);
    written += DP_write_bigendian_int32(mtr->y2, data + written);
    written += DP_write_bigendian_int32(mtr->x3, data + written);
    written += DP_write_bigendian_int32(mtr->y3, data + written);
    written += DP_write_bigendian_int32(mtr->x4, data + written);
    written += DP_write_bigendian_int32(mtr->y4, data + written);
    written += DP_write_bigendian_uint8(mtr->mode, data + written);
    written += DP_write_bigendian_uint8(mtr->blend, data + written);
    written += DP_write_bigendian_uint8(mtr->opacity, data + written);
    written += write_bytes(mtr->mask, mtr->mask_size, data + written);
    DP_ASSERT(written == msg_transform_region_payload_length(msg));
    return written;
}

static size_t msg_transform_region_serialize_payload_compat(DP_Message *msg,
                                                            unsigned char *data)
{
    DP_MsgTransformRegion *mtr = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(serialize_layer_id_compat(mtr->layer),
                                         data + written);
    written += DP_write_bigendian_uint16(serialize_layer_id_compat(mtr->source),
                                         data + written);
    written += DP_write_bigendian_int32(mtr->bx, data + written);
    written += DP_write_bigendian_int32(mtr->by, data + written);
    written += DP_write_bigendian_int32(mtr->bw, data + written);
    written += DP_write_bigendian_int32(mtr->bh, data + written);
    written += DP_write_bigendian_int32(mtr->x1, data + written);
    written += DP_write_bigendian_int32(mtr->y1, data + written);
    written += DP_write_bigendian_int32(mtr->x2, data + written);
    written += DP_write_bigendian_int32(mtr->y2, data + written);
    written += DP_write_bigendian_int32(mtr->x3, data + written);
    written += DP_write_bigendian_int32(mtr->y3, data + written);
    written += DP_write_bigendian_int32(mtr->x4, data + written);
    written += DP_write_bigendian_int32(mtr->y4, data + written);
    written += DP_write_bigendian_uint8(mtr->mode, data + written);
    written += write_bytes(mtr->mask, mtr->mask_size, data + written);
    DP_ASSERT(written == msg_transform_region_payload_length_compat(msg));
    return written;
}

static bool msg_transform_region_write_payload_text(DP_Message *msg,
                                                    DP_TextWriter *writer)
{
    DP_MsgTransformRegion *mtr = DP_message_internal(msg);
    return DP_text_writer_write_int(writer, "bh", mtr->bh)
        && DP_text_writer_write_blend_mode(writer, "blend", mtr->blend)
        && DP_text_writer_write_int(writer, "bw", mtr->bw)
        && DP_text_writer_write_int(writer, "bx", mtr->bx)
        && DP_text_writer_write_int(writer, "by", mtr->by)
        && DP_text_writer_write_uint(writer, "layer", mtr->layer)
        && DP_text_writer_write_base64(writer, "mask", mtr->mask,
                                       mtr->mask_size)
        && DP_text_writer_write_uint(writer, "mode", mtr->mode)
        && DP_text_writer_write_uint(writer, "opacity", mtr->opacity)
        && DP_text_writer_write_uint(writer, "source", mtr->source)
        && DP_text_writer_write_int(writer, "x1", mtr->x1)
        && DP_text_writer_write_int(writer, "x2", mtr->x2)
        && DP_text_writer_write_int(writer, "x3", mtr->x3)
        && DP_text_writer_write_int(writer, "x4", mtr->x4)
        && DP_text_writer_write_int(writer, "y1", mtr->y1)
        && DP_text_writer_write_int(writer, "y2", mtr->y2)
        && DP_text_writer_write_int(writer, "y3", mtr->y3)
        && DP_text_writer_write_int(writer, "y4", mtr->y4);
}

static bool msg_transform_region_equals(DP_Message *DP_RESTRICT msg,
                                        DP_Message *DP_RESTRICT other)
{
    DP_MsgTransformRegion *a = DP_message_internal(msg);
    DP_MsgTransformRegion *b = DP_message_internal(other);
    return a->layer == b->layer && a->source == b->source && a->bx == b->bx
        && a->by == b->by && a->bw == b->bw && a->bh == b->bh && a->x1 == b->x1
        && a->y1 == b->y1 && a->x2 == b->x2 && a->y2 == b->y2 && a->x3 == b->x3
        && a->y3 == b->y3 && a->x4 == b->x4 && a->y4 == b->y4
        && a->mode == b->mode && a->blend == b->blend
        && a->opacity == b->opacity && a->mask_size == b->mask_size
        && memcmp(a->mask, b->mask, DP_uint16_to_size(a->mask_size)) == 0;
}

void DP_msg_transform_region_local_match_set(DP_UNUSED size_t size,
                                             unsigned char *data, void *user)
{
    DP_ASSERT(size == DP_MSG_TRANSFORM_REGION_MATCH_LENGTH);
    const DP_MsgTransformRegion *mtr = user;
    size_t written = 0;
    written += DP_write_bigendian_uint24(mtr->layer, data + written);
    written += DP_write_bigendian_uint24(mtr->source, data + written);
    written += DP_write_bigendian_int32(mtr->bx, data + written);
    written += DP_write_bigendian_int32(mtr->by, data + written);
    written += DP_write_bigendian_int32(mtr->bw, data + written);
    written += DP_write_bigendian_int32(mtr->bh, data + written);
    written += DP_write_bigendian_int32(mtr->x1, data + written);
    written += DP_write_bigendian_int32(mtr->y1, data + written);
    written += DP_write_bigendian_int32(mtr->x2, data + written);
    written += DP_write_bigendian_int32(mtr->y2, data + written);
    written += DP_write_bigendian_int32(mtr->x3, data + written);
    written += DP_write_bigendian_int32(mtr->y3, data + written);
    written += DP_write_bigendian_int32(mtr->x4, data + written);
    written += DP_write_bigendian_int32(mtr->y4, data + written);
    written += DP_write_bigendian_uint8(mtr->mode, data + written);
    written += DP_write_bigendian_uint8(mtr->blend, data + written);
    written += DP_write_bigendian_uint8(mtr->opacity, data + written);
    written += DP_write_bigendian_uint16(mtr->mask_size, data + written);
    DP_ASSERT(written == DP_MSG_TRANSFORM_REGION_MATCH_LENGTH);
}

bool DP_msg_transform_region_local_match_matches(
    const DP_MsgTransformRegion *mtr, DP_Message *local_match_msg)
{
    size_t size;
    const unsigned char *buffer = local_match_data(local_match_msg, &size);
    size_t read = 0;
    return size == DP_MSG_TRANSFORM_REGION_MATCH_LENGTH
        && read_uint24(buffer + read, &read) == mtr->layer
        && read_uint24(buffer + read, &read) == mtr->source
        && read_int32(buffer + read, &read) == mtr->bx
        && read_int32(buffer + read, &read) == mtr->by
        && read_int32(buffer + read, &read) == mtr->bw
        && read_int32(buffer + read, &read) == mtr->bh
        && read_int32(buffer + read, &read) == mtr->x1
        && read_int32(buffer + read, &read) == mtr->y1
        && read_int32(buffer + read, &read) == mtr->x2
        && read_int32(buffer + read, &read) == mtr->y2
        && read_int32(buffer + read, &read) == mtr->x3
        && read_int32(buffer + read, &read) == mtr->y3
        && read_int32(buffer + read, &read) == mtr->x4
        && read_int32(buffer + read, &read) == mtr->y4
        && read_uint8(buffer + read, &read) == mtr->mode
        && read_uint8(buffer + read, &read) == mtr->blend
        && read_uint8(buffer + read, &read) == mtr->opacity
        && read_uint16(buffer + read, &read) == mtr->mask_size;
}

static const DP_MessageMethods msg_transform_region_methods = {
    msg_transform_region_payload_length,
    msg_transform_region_serialize_payload,
    msg_transform_region_payload_length_compat,
    msg_transform_region_serialize_payload_compat,
    msg_transform_region_write_payload_text,
    msg_transform_region_equals,
};

DP_Message *DP_msg_transform_region_new(
    unsigned int context_id, uint32_t layer, uint32_t source, int32_t bx,
    int32_t by, int32_t bw, int32_t bh, int32_t x1, int32_t y1, int32_t x2,
    int32_t y2, int32_t x3, int32_t y3, int32_t x4, int32_t y4, uint8_t mode,
    uint8_t blend, uint8_t opacity,
    void (*set_mask)(size_t, unsigned char *, void *), size_t mask_size,
    void *mask_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_TRANSFORM_REGION, context_id, &msg_transform_region_methods,
        DP_FLEX_SIZEOF(DP_MsgTransformRegion, mask, mask_size));
    DP_MsgTransformRegion *mtr = DP_message_internal(msg);
    mtr->layer = layer;
    mtr->source = source;
    mtr->bx = bx;
    mtr->by = by;
    mtr->bw = bw;
    mtr->bh = bh;
    mtr->x1 = x1;
    mtr->y1 = y1;
    mtr->x2 = x2;
    mtr->y2 = y2;
    mtr->x3 = x3;
    mtr->y3 = y3;
    mtr->x4 = x4;
    mtr->y4 = y4;
    mtr->mode = mode;
    mtr->blend = blend;
    mtr->opacity = opacity;
    mtr->mask_size = DP_size_to_uint16(mask_size);
    if (set_mask) {
        set_mask(mtr->mask_size, mtr->mask, mask_user);
    }
    return msg;
}

DP_Message *DP_msg_transform_region_deserialize(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length)
{
    if (length < 57 || length > 65535) {
        DP_error_set("Wrong length for transformregion message; "
                     "expected between 57 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint32_t layer = read_uint24(buffer + read, &read);
    uint32_t source = read_uint24(buffer + read, &read);
    int32_t bx = read_int32(buffer + read, &read);
    int32_t by = read_int32(buffer + read, &read);
    int32_t bw = read_int32(buffer + read, &read);
    int32_t bh = read_int32(buffer + read, &read);
    int32_t x1 = read_int32(buffer + read, &read);
    int32_t y1 = read_int32(buffer + read, &read);
    int32_t x2 = read_int32(buffer + read, &read);
    int32_t y2 = read_int32(buffer + read, &read);
    int32_t x3 = read_int32(buffer + read, &read);
    int32_t y3 = read_int32(buffer + read, &read);
    int32_t x4 = read_int32(buffer + read, &read);
    int32_t y4 = read_int32(buffer + read, &read);
    uint8_t mode = read_uint8(buffer + read, &read);
    uint8_t blend = read_uint8(buffer + read, &read);
    uint8_t opacity = read_uint8(buffer + read, &read);
    size_t mask_bytes = length - read;
    uint16_t mask_size = DP_size_to_uint16(mask_bytes);
    void *mask_user = (void *)(buffer + read);
    return DP_msg_transform_region_new(
        context_id, layer, source, bx, by, bw, bh, x1, y1, x2, y2, x3, y3, x4,
        y4, mode, blend, opacity, read_bytes, mask_size, mask_user);
}

DP_Message *DP_msg_transform_region_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length < 53 || length > 65535) {
        DP_error_set("Wrong length for transformregion compat message; "
                     "expected between 53 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t layer = read_uint16(buffer + read, &read);
    uint16_t source = read_uint16(buffer + read, &read);
    int32_t bx = read_int32(buffer + read, &read);
    int32_t by = read_int32(buffer + read, &read);
    int32_t bw = read_int32(buffer + read, &read);
    int32_t bh = read_int32(buffer + read, &read);
    int32_t x1 = read_int32(buffer + read, &read);
    int32_t y1 = read_int32(buffer + read, &read);
    int32_t x2 = read_int32(buffer + read, &read);
    int32_t y2 = read_int32(buffer + read, &read);
    int32_t x3 = read_int32(buffer + read, &read);
    int32_t y3 = read_int32(buffer + read, &read);
    int32_t x4 = read_int32(buffer + read, &read);
    int32_t y4 = read_int32(buffer + read, &read);
    uint8_t mode = read_uint8(buffer + read, &read);
    size_t mask_bytes = length - read;
    uint16_t mask_size = DP_size_to_uint16(mask_bytes);
    void *mask_user = (void *)(buffer + read);
    DP_Message *msg = DP_msg_transform_region_new(
        context_id, deserialize_layer_id_compat(layer),
        deserialize_layer_id_compat(source), bx, by, bw, bh, x1, y1, x2, y2, x3,
        y3, x4, y4, mode, DP_BLEND_MODE_NORMAL, 255, read_bytes, mask_size,
        mask_user);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_transform_region_parse(unsigned int context_id,
                                          DP_TextReader *reader)
{
    uint32_t layer =
        (uint32_t)DP_text_reader_get_ulong(reader, "layer", DP_UINT24_MAX);
    uint32_t source =
        (uint32_t)DP_text_reader_get_ulong(reader, "source", DP_UINT24_MAX);
    int32_t bx =
        (int32_t)DP_text_reader_get_long(reader, "bx", INT32_MIN, INT32_MAX);
    int32_t by =
        (int32_t)DP_text_reader_get_long(reader, "by", INT32_MIN, INT32_MAX);
    int32_t bw =
        (int32_t)DP_text_reader_get_long(reader, "bw", INT32_MIN, INT32_MAX);
    int32_t bh =
        (int32_t)DP_text_reader_get_long(reader, "bh", INT32_MIN, INT32_MAX);
    int32_t x1 =
        (int32_t)DP_text_reader_get_long(reader, "x1", INT32_MIN, INT32_MAX);
    int32_t y1 =
        (int32_t)DP_text_reader_get_long(reader, "y1", INT32_MIN, INT32_MAX);
    int32_t x2 =
        (int32_t)DP_text_reader_get_long(reader, "x2", INT32_MIN, INT32_MAX);
    int32_t y2 =
        (int32_t)DP_text_reader_get_long(reader, "y2", INT32_MIN, INT32_MAX);
    int32_t x3 =
        (int32_t)DP_text_reader_get_long(reader, "x3", INT32_MIN, INT32_MAX);
    int32_t y3 =
        (int32_t)DP_text_reader_get_long(reader, "y3", INT32_MIN, INT32_MAX);
    int32_t x4 =
        (int32_t)DP_text_reader_get_long(reader, "x4", INT32_MIN, INT32_MAX);
    int32_t y4 =
        (int32_t)DP_text_reader_get_long(reader, "y4", INT32_MIN, INT32_MAX);
    uint8_t mode = (uint8_t)DP_text_reader_get_ulong(reader, "mode", UINT8_MAX);
    uint8_t blend = DP_text_reader_get_blend_mode(reader, "blend");
    uint8_t opacity =
        (uint8_t)DP_text_reader_get_ulong(reader, "opacity", UINT8_MAX);
    size_t mask_size;
    DP_TextReaderParseParams mask_params =
        DP_text_reader_get_base64_string(reader, "mask", &mask_size);
    return DP_msg_transform_region_new(
        context_id, layer, source, bx, by, bw, bh, x1, y1, x2, y2, x3, y3, x4,
        y4, mode, blend, opacity, DP_text_reader_parse_base64, mask_size,
        &mask_params);
}

DP_MsgTransformRegion *DP_msg_transform_region_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_TRANSFORM_REGION);
}

uint32_t DP_msg_transform_region_layer(const DP_MsgTransformRegion *mtr)
{
    DP_ASSERT(mtr);
    return mtr->layer;
}

uint32_t DP_msg_transform_region_source(const DP_MsgTransformRegion *mtr)
{
    DP_ASSERT(mtr);
    return mtr->source;
}

int32_t DP_msg_transform_region_bx(const DP_MsgTransformRegion *mtr)
{
    DP_ASSERT(mtr);
    return mtr->bx;
}

int32_t DP_msg_transform_region_by(const DP_MsgTransformRegion *mtr)
{
    DP_ASSERT(mtr);
    return mtr->by;
}

int32_t DP_msg_transform_region_bw(const DP_MsgTransformRegion *mtr)
{
    DP_ASSERT(mtr);
    return mtr->bw;
}

int32_t DP_msg_transform_region_bh(const DP_MsgTransformRegion *mtr)
{
    DP_ASSERT(mtr);
    return mtr->bh;
}

int32_t DP_msg_transform_region_x1(const DP_MsgTransformRegion *mtr)
{
    DP_ASSERT(mtr);
    return mtr->x1;
}

int32_t DP_msg_transform_region_y1(const DP_MsgTransformRegion *mtr)
{
    DP_ASSERT(mtr);
    return mtr->y1;
}

int32_t DP_msg_transform_region_x2(const DP_MsgTransformRegion *mtr)
{
    DP_ASSERT(mtr);
    return mtr->x2;
}

int32_t DP_msg_transform_region_y2(const DP_MsgTransformRegion *mtr)
{
    DP_ASSERT(mtr);
    return mtr->y2;
}

int32_t DP_msg_transform_region_x3(const DP_MsgTransformRegion *mtr)
{
    DP_ASSERT(mtr);
    return mtr->x3;
}

int32_t DP_msg_transform_region_y3(const DP_MsgTransformRegion *mtr)
{
    DP_ASSERT(mtr);
    return mtr->y3;
}

int32_t DP_msg_transform_region_x4(const DP_MsgTransformRegion *mtr)
{
    DP_ASSERT(mtr);
    return mtr->x4;
}

int32_t DP_msg_transform_region_y4(const DP_MsgTransformRegion *mtr)
{
    DP_ASSERT(mtr);
    return mtr->y4;
}

uint8_t DP_msg_transform_region_mode(const DP_MsgTransformRegion *mtr)
{
    DP_ASSERT(mtr);
    return mtr->mode;
}

uint8_t DP_msg_transform_region_blend(const DP_MsgTransformRegion *mtr)
{
    DP_ASSERT(mtr);
    return mtr->blend;
}

uint8_t DP_msg_transform_region_opacity(const DP_MsgTransformRegion *mtr)
{
    DP_ASSERT(mtr);
    return mtr->opacity;
}

const unsigned char *
DP_msg_transform_region_mask(const DP_MsgTransformRegion *mtr, size_t *out_size)
{
    DP_ASSERT(mtr);
    if (out_size) {
        *out_size = mtr->mask_size;
    }
    return mtr->mask;
}

size_t DP_msg_transform_region_mask_size(const DP_MsgTransformRegion *mtr)
{
    return mtr->mask_size;
}


/* DP_MSG_TRACK_CREATE */

struct DP_MsgTrackCreate {
    uint16_t id;
    uint16_t insert_id;
    uint16_t source_id;
    uint16_t title_len;
    char title[];
};

static size_t msg_track_create_payload_length(DP_Message *msg)
{
    DP_MsgTrackCreate *mtc = DP_message_internal(msg);
    return ((size_t)6) + DP_uint16_to_size(mtc->title_len);
}

static size_t msg_track_create_payload_length_compat(DP_Message *msg)
{
    DP_MsgTrackCreate *mtc = DP_message_internal(msg);
    return ((size_t)6) + DP_uint16_to_size(mtc->title_len);
}

static size_t msg_track_create_serialize_payload(DP_Message *msg,
                                                 unsigned char *data)
{
    DP_MsgTrackCreate *mtc = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(mtc->id, data + written);
    written += DP_write_bigendian_uint16(mtc->insert_id, data + written);
    written += DP_write_bigendian_uint16(mtc->source_id, data + written);
    written += DP_write_bytes(mtc->title, 1, mtc->title_len, data + written);
    DP_ASSERT(written == msg_track_create_payload_length(msg));
    return written;
}

static size_t msg_track_create_serialize_payload_compat(DP_Message *msg,
                                                        unsigned char *data)
{
    DP_MsgTrackCreate *mtc = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(convert_other_id_compat(mtc->id),
                                         data + written);
    written += DP_write_bigendian_uint16(
        convert_other_id_compat(mtc->insert_id), data + written);
    written += DP_write_bigendian_uint16(
        convert_other_id_compat(mtc->source_id), data + written);
    written += DP_write_bytes(mtc->title, 1, mtc->title_len, data + written);
    DP_ASSERT(written == msg_track_create_payload_length_compat(msg));
    return written;
}

static bool msg_track_create_write_payload_text(DP_Message *msg,
                                                DP_TextWriter *writer)
{
    DP_MsgTrackCreate *mtc = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "id", mtc->id)
        && DP_text_writer_write_uint(writer, "insert_id", mtc->insert_id)
        && DP_text_writer_write_uint(writer, "source_id", mtc->source_id)
        && DP_text_writer_write_string(writer, "title", mtc->title);
}

static bool msg_track_create_equals(DP_Message *DP_RESTRICT msg,
                                    DP_Message *DP_RESTRICT other)
{
    DP_MsgTrackCreate *a = DP_message_internal(msg);
    DP_MsgTrackCreate *b = DP_message_internal(other);
    return a->id == b->id && a->insert_id == b->insert_id
        && a->source_id == b->source_id && a->title_len == b->title_len
        && memcmp(a->title, b->title, a->title_len) == 0;
}

static const DP_MessageMethods msg_track_create_methods = {
    msg_track_create_payload_length,
    msg_track_create_serialize_payload,
    msg_track_create_payload_length_compat,
    msg_track_create_serialize_payload_compat,
    msg_track_create_write_payload_text,
    msg_track_create_equals,
};

DP_Message *DP_msg_track_create_new(unsigned int context_id, uint16_t id,
                                    uint16_t insert_id, uint16_t source_id,
                                    const char *title_value, size_t title_len)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_TRACK_CREATE, context_id, &msg_track_create_methods,
        DP_FLEX_SIZEOF(DP_MsgTrackCreate, title, title_len + 1));
    DP_MsgTrackCreate *mtc = DP_message_internal(msg);
    mtc->id = id;
    mtc->insert_id = insert_id;
    mtc->source_id = source_id;
    mtc->title_len = DP_size_to_uint16(title_len);
    assign_string(mtc->title, title_value, mtc->title_len);
    return msg;
}

DP_Message *DP_msg_track_create_deserialize(unsigned int context_id,
                                            const unsigned char *buffer,
                                            size_t length)
{
    if (length < 6 || length > 65535) {
        DP_error_set("Wrong length for trackcreate message; "
                     "expected between 6 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    uint16_t insert_id = read_uint16(buffer + read, &read);
    uint16_t source_id = read_uint16(buffer + read, &read);
    size_t title_bytes = length - read;
    uint16_t title_len = DP_size_to_uint16(title_bytes);
    const char *title = (const char *)buffer + read;
    return DP_msg_track_create_new(context_id, id, insert_id, source_id, title,
                                   title_len);
}

DP_Message *DP_msg_track_create_deserialize_compat(unsigned int context_id,
                                                   const unsigned char *buffer,
                                                   size_t length)
{
    if (length < 6 || length > 65535) {
        DP_error_set("Wrong length for trackcreate compat message; "
                     "expected between 6 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    uint16_t insert_id = read_uint16(buffer + read, &read);
    uint16_t source_id = read_uint16(buffer + read, &read);
    size_t title_bytes = length - read;
    uint16_t title_len = DP_size_to_uint16(title_bytes);
    const char *title = (const char *)buffer + read;
    DP_Message *msg = DP_msg_track_create_new(
        context_id, convert_other_id_compat(id),
        convert_other_id_compat(insert_id), convert_other_id_compat(source_id),
        title, title_len);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_track_create_parse(unsigned int context_id,
                                      DP_TextReader *reader)
{
    uint16_t id = (uint16_t)DP_text_reader_get_ulong(reader, "id", UINT16_MAX);
    uint16_t insert_id =
        (uint16_t)DP_text_reader_get_ulong(reader, "insert_id", UINT16_MAX);
    uint16_t source_id =
        (uint16_t)DP_text_reader_get_ulong(reader, "source_id", UINT16_MAX);
    uint16_t title_len;
    const char *title = DP_text_reader_get_string(reader, "title", &title_len);
    return DP_msg_track_create_new(context_id, id, insert_id, source_id, title,
                                   title_len);
}

DP_MsgTrackCreate *DP_msg_track_create_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_TRACK_CREATE);
}

uint16_t DP_msg_track_create_id(const DP_MsgTrackCreate *mtc)
{
    DP_ASSERT(mtc);
    return mtc->id;
}

uint16_t DP_msg_track_create_insert_id(const DP_MsgTrackCreate *mtc)
{
    DP_ASSERT(mtc);
    return mtc->insert_id;
}

uint16_t DP_msg_track_create_source_id(const DP_MsgTrackCreate *mtc)
{
    DP_ASSERT(mtc);
    return mtc->source_id;
}

const char *DP_msg_track_create_title(const DP_MsgTrackCreate *mtc,
                                      size_t *out_len)
{
    DP_ASSERT(mtc);
    if (out_len) {
        *out_len = mtc->title_len;
    }
    return mtc->title;
}

size_t DP_msg_track_create_title_len(const DP_MsgTrackCreate *mtc)
{
    return mtc->title_len;
}


/* DP_MSG_TRACK_RETITLE */

struct DP_MsgTrackRetitle {
    uint16_t id;
    uint16_t title_len;
    char title[];
};

static size_t msg_track_retitle_payload_length(DP_Message *msg)
{
    DP_MsgTrackRetitle *mtr = DP_message_internal(msg);
    return ((size_t)2) + DP_uint16_to_size(mtr->title_len);
}

static size_t msg_track_retitle_payload_length_compat(DP_Message *msg)
{
    DP_MsgTrackRetitle *mtr = DP_message_internal(msg);
    return ((size_t)2) + DP_uint16_to_size(mtr->title_len);
}

static size_t msg_track_retitle_serialize_payload(DP_Message *msg,
                                                  unsigned char *data)
{
    DP_MsgTrackRetitle *mtr = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(mtr->id, data + written);
    written += DP_write_bytes(mtr->title, 1, mtr->title_len, data + written);
    DP_ASSERT(written == msg_track_retitle_payload_length(msg));
    return written;
}

static size_t msg_track_retitle_serialize_payload_compat(DP_Message *msg,
                                                         unsigned char *data)
{
    DP_MsgTrackRetitle *mtr = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(convert_other_id_compat(mtr->id),
                                         data + written);
    written += DP_write_bytes(mtr->title, 1, mtr->title_len, data + written);
    DP_ASSERT(written == msg_track_retitle_payload_length_compat(msg));
    return written;
}

static bool msg_track_retitle_write_payload_text(DP_Message *msg,
                                                 DP_TextWriter *writer)
{
    DP_MsgTrackRetitle *mtr = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "id", mtr->id)
        && DP_text_writer_write_string(writer, "title", mtr->title);
}

static bool msg_track_retitle_equals(DP_Message *DP_RESTRICT msg,
                                     DP_Message *DP_RESTRICT other)
{
    DP_MsgTrackRetitle *a = DP_message_internal(msg);
    DP_MsgTrackRetitle *b = DP_message_internal(other);
    return a->id == b->id && a->title_len == b->title_len
        && memcmp(a->title, b->title, a->title_len) == 0;
}

static const DP_MessageMethods msg_track_retitle_methods = {
    msg_track_retitle_payload_length,
    msg_track_retitle_serialize_payload,
    msg_track_retitle_payload_length_compat,
    msg_track_retitle_serialize_payload_compat,
    msg_track_retitle_write_payload_text,
    msg_track_retitle_equals,
};

DP_Message *DP_msg_track_retitle_new(unsigned int context_id, uint16_t id,
                                     const char *title_value, size_t title_len)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_TRACK_RETITLE, context_id, &msg_track_retitle_methods,
        DP_FLEX_SIZEOF(DP_MsgTrackRetitle, title, title_len + 1));
    DP_MsgTrackRetitle *mtr = DP_message_internal(msg);
    mtr->id = id;
    mtr->title_len = DP_size_to_uint16(title_len);
    assign_string(mtr->title, title_value, mtr->title_len);
    return msg;
}

DP_Message *DP_msg_track_retitle_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length)
{
    if (length < 2 || length > 65535) {
        DP_error_set("Wrong length for trackretitle message; "
                     "expected between 2 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    size_t title_bytes = length - read;
    uint16_t title_len = DP_size_to_uint16(title_bytes);
    const char *title = (const char *)buffer + read;
    return DP_msg_track_retitle_new(context_id, id, title, title_len);
}

DP_Message *DP_msg_track_retitle_deserialize_compat(unsigned int context_id,
                                                    const unsigned char *buffer,
                                                    size_t length)
{
    if (length < 2 || length > 65535) {
        DP_error_set("Wrong length for trackretitle compat message; "
                     "expected between 2 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    size_t title_bytes = length - read;
    uint16_t title_len = DP_size_to_uint16(title_bytes);
    const char *title = (const char *)buffer + read;
    DP_Message *msg = DP_msg_track_retitle_new(
        context_id, convert_other_id_compat(id), title, title_len);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_track_retitle_parse(unsigned int context_id,
                                       DP_TextReader *reader)
{
    uint16_t id = (uint16_t)DP_text_reader_get_ulong(reader, "id", UINT16_MAX);
    uint16_t title_len;
    const char *title = DP_text_reader_get_string(reader, "title", &title_len);
    return DP_msg_track_retitle_new(context_id, id, title, title_len);
}

DP_MsgTrackRetitle *DP_msg_track_retitle_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_TRACK_RETITLE);
}

uint16_t DP_msg_track_retitle_id(const DP_MsgTrackRetitle *mtr)
{
    DP_ASSERT(mtr);
    return mtr->id;
}

const char *DP_msg_track_retitle_title(const DP_MsgTrackRetitle *mtr,
                                       size_t *out_len)
{
    DP_ASSERT(mtr);
    if (out_len) {
        *out_len = mtr->title_len;
    }
    return mtr->title;
}

size_t DP_msg_track_retitle_title_len(const DP_MsgTrackRetitle *mtr)
{
    return mtr->title_len;
}


/* DP_MSG_TRACK_DELETE */

struct DP_MsgTrackDelete {
    uint16_t id;
};

static size_t msg_track_delete_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)2);
}

static size_t msg_track_delete_payload_length_compat(DP_UNUSED DP_Message *msg)
{
    return ((size_t)2);
}

static size_t msg_track_delete_serialize_payload(DP_Message *msg,
                                                 unsigned char *data)
{
    DP_MsgTrackDelete *mtd = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(mtd->id, data + written);
    DP_ASSERT(written == msg_track_delete_payload_length(msg));
    return written;
}

static size_t msg_track_delete_serialize_payload_compat(DP_Message *msg,
                                                        unsigned char *data)
{
    DP_MsgTrackDelete *mtd = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(convert_other_id_compat(mtd->id),
                                         data + written);
    DP_ASSERT(written == msg_track_delete_payload_length_compat(msg));
    return written;
}

static bool msg_track_delete_write_payload_text(DP_Message *msg,
                                                DP_TextWriter *writer)
{
    DP_MsgTrackDelete *mtd = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "id", mtd->id);
}

static bool msg_track_delete_equals(DP_Message *DP_RESTRICT msg,
                                    DP_Message *DP_RESTRICT other)
{
    DP_MsgTrackDelete *a = DP_message_internal(msg);
    DP_MsgTrackDelete *b = DP_message_internal(other);
    return a->id == b->id;
}

static const DP_MessageMethods msg_track_delete_methods = {
    msg_track_delete_payload_length,
    msg_track_delete_serialize_payload,
    msg_track_delete_payload_length_compat,
    msg_track_delete_serialize_payload_compat,
    msg_track_delete_write_payload_text,
    msg_track_delete_equals,
};

DP_Message *DP_msg_track_delete_new(unsigned int context_id, uint16_t id)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_TRACK_DELETE, context_id,
                       &msg_track_delete_methods, sizeof(DP_MsgTrackDelete));
    DP_MsgTrackDelete *mtd = DP_message_internal(msg);
    mtd->id = id;
    return msg;
}

DP_Message *DP_msg_track_delete_deserialize(unsigned int context_id,
                                            const unsigned char *buffer,
                                            size_t length)
{
    if (length != 2) {
        DP_error_set("Wrong length for trackdelete message; "
                     "expected 2, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    return DP_msg_track_delete_new(context_id, id);
}

DP_Message *DP_msg_track_delete_deserialize_compat(unsigned int context_id,
                                                   const unsigned char *buffer,
                                                   size_t length)
{
    if (length != 2) {
        DP_error_set("Wrong length for trackdelete compat message; "
                     "expected 2, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t id = read_uint16(buffer + read, &read);
    DP_Message *msg =
        DP_msg_track_delete_new(context_id, convert_other_id_compat(id));
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_track_delete_parse(unsigned int context_id,
                                      DP_TextReader *reader)
{
    uint16_t id = (uint16_t)DP_text_reader_get_ulong(reader, "id", UINT16_MAX);
    return DP_msg_track_delete_new(context_id, id);
}

DP_MsgTrackDelete *DP_msg_track_delete_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_TRACK_DELETE);
}

uint16_t DP_msg_track_delete_id(const DP_MsgTrackDelete *mtd)
{
    DP_ASSERT(mtd);
    return mtd->id;
}


/* DP_MSG_TRACK_ORDER */

struct DP_MsgTrackOrder {
    uint16_t tracks_count;
    uint16_t tracks[];
};

static size_t msg_track_order_payload_length(DP_Message *msg)
{
    DP_MsgTrackOrder *mto = DP_message_internal(msg);
    return DP_int_to_size(mto->tracks_count) * 2;
}

static size_t msg_track_order_payload_length_compat(DP_Message *msg)
{
    DP_MsgTrackOrder *mto = DP_message_internal(msg);
    return DP_int_to_size(mto->tracks_count) * 2;
}

static size_t msg_track_order_serialize_payload(DP_Message *msg,
                                                unsigned char *data)
{
    DP_MsgTrackOrder *mto = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16_array(mto->tracks, mto->tracks_count,
                                               data + written);
    DP_ASSERT(written == msg_track_order_payload_length(msg));
    return written;
}

static size_t msg_track_order_serialize_payload_compat(DP_Message *msg,
                                                       unsigned char *data)
{
    DP_MsgTrackOrder *mto = DP_message_internal(msg);
    size_t written = 0;
    written +=
        write_track_ids_compat(mto->tracks, mto->tracks_count, data + written);
    DP_ASSERT(written == msg_track_order_payload_length_compat(msg));
    return written;
}

static bool msg_track_order_write_payload_text(DP_Message *msg,
                                               DP_TextWriter *writer)
{
    DP_MsgTrackOrder *mto = DP_message_internal(msg);
    return DP_text_writer_write_uint16_list(writer, "tracks", mto->tracks,
                                            mto->tracks_count);
}

static bool msg_track_order_equals(DP_Message *DP_RESTRICT msg,
                                   DP_Message *DP_RESTRICT other)
{
    DP_MsgTrackOrder *a = DP_message_internal(msg);
    DP_MsgTrackOrder *b = DP_message_internal(other);
    return a->tracks_count == b->tracks_count
        && memcmp(a->tracks, b->tracks, DP_uint16_to_size(a->tracks_count) * 2)
               == 0;
}

static const DP_MessageMethods msg_track_order_methods = {
    msg_track_order_payload_length,
    msg_track_order_serialize_payload,
    msg_track_order_payload_length_compat,
    msg_track_order_serialize_payload_compat,
    msg_track_order_write_payload_text,
    msg_track_order_equals,
};

DP_Message *DP_msg_track_order_new(unsigned int context_id,
                                   void (*set_tracks)(int, uint16_t *, void *),
                                   int tracks_count, void *tracks_user)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_TRACK_ORDER, context_id, &msg_track_order_methods,
                       DP_FLEX_SIZEOF(DP_MsgTrackOrder, tracks,
                                      DP_int_to_size(tracks_count) * 2));
    DP_MsgTrackOrder *mto = DP_message_internal(msg);
    mto->tracks_count = DP_int_to_uint16(tracks_count);
    if (set_tracks) {
        set_tracks(mto->tracks_count, mto->tracks, tracks_user);
    }
    return msg;
}

DP_Message *DP_msg_track_order_deserialize(unsigned int context_id,
                                           const unsigned char *buffer,
                                           size_t length)
{
    if (length > 65535) {
        DP_error_set("Wrong length for trackorder message; "
                     "expected between 0 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    size_t tracks_bytes = length - read;
    if ((tracks_bytes % 2) != 0) {
        DP_error_set("Wrong length for tracks field in trackorder message; "
                     "%zu not divisible by 2",
                     tracks_bytes);
        return NULL;
    }
    uint16_t tracks_count = DP_size_to_uint16(tracks_bytes / 2);
    void *tracks_user = (void *)(buffer + read);
    return DP_msg_track_order_new(context_id, read_uint16_array, tracks_count,
                                  tracks_user);
}

DP_Message *DP_msg_track_order_deserialize_compat(unsigned int context_id,
                                                  const unsigned char *buffer,
                                                  size_t length)
{
    if (length > 65535) {
        DP_error_set("Wrong length for trackorder compat message; "
                     "expected between 0 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    size_t tracks_bytes = length - read;
    if ((tracks_bytes % 2) != 0) {
        DP_error_set("Wrong length for tracks field in trackorder message; "
                     "%zu not divisible by 2",
                     tracks_bytes);
        return NULL;
    }
    uint16_t tracks_count = DP_size_to_uint16(tracks_bytes / 2);
    void *tracks_user = (void *)(buffer + read);
    DP_Message *msg = DP_msg_track_order_new(context_id, read_track_ids_compat,
                                             tracks_count, tracks_user);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_track_order_parse(unsigned int context_id,
                                     DP_TextReader *reader)
{
    int tracks_count;
    DP_TextReaderParseParams tracks_params =
        DP_text_reader_get_array(reader, "tracks", &tracks_count);
    return DP_msg_track_order_new(context_id, DP_text_reader_parse_uint16_array,
                                  tracks_count, &tracks_params);
}

DP_MsgTrackOrder *DP_msg_track_order_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_TRACK_ORDER);
}

const uint16_t *DP_msg_track_order_tracks(const DP_MsgTrackOrder *mto,
                                          int *out_count)
{
    DP_ASSERT(mto);
    if (out_count) {
        *out_count = mto->tracks_count;
    }
    return mto->tracks;
}

int DP_msg_track_order_tracks_count(const DP_MsgTrackOrder *mto)
{
    return mto->tracks_count;
}


/* DP_MSG_KEY_FRAME_SET */

const char *DP_msg_key_frame_set_source_variant_name(unsigned int value)
{
    switch (value) {
    case DP_MSG_KEY_FRAME_SET_SOURCE_LAYER:
        return "Layer";
    case DP_MSG_KEY_FRAME_SET_SOURCE_KEY_FRAME:
        return "KeyFrame";
    default:
        return NULL;
    }
}

struct DP_MsgKeyFrameSet {
    uint16_t track_id;
    uint16_t frame_index;
    uint32_t source_id;
    uint16_t source_index;
    uint8_t source;
};

static size_t msg_key_frame_set_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)10);
}

static size_t msg_key_frame_set_payload_length_compat(DP_UNUSED DP_Message *msg)
{
    return ((size_t)9);
}

static size_t msg_key_frame_set_serialize_payload(DP_Message *msg,
                                                  unsigned char *data)
{
    DP_MsgKeyFrameSet *mkfs = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(mkfs->track_id, data + written);
    written += DP_write_bigendian_uint16(mkfs->frame_index, data + written);
    written += DP_write_bigendian_uint24(mkfs->source_id, data + written);
    written += DP_write_bigendian_uint16(mkfs->source_index, data + written);
    written += DP_write_bigendian_uint8(mkfs->source, data + written);
    DP_ASSERT(written == msg_key_frame_set_payload_length(msg));
    return written;
}

static size_t msg_key_frame_set_serialize_payload_compat(DP_Message *msg,
                                                         unsigned char *data)
{
    DP_MsgKeyFrameSet *mkfs = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(
        convert_other_id_compat(mkfs->track_id), data + written);
    written += DP_write_bigendian_uint16(mkfs->frame_index, data + written);
    written += DP_write_bigendian_uint16(
        mkfs->source == DP_MSG_KEY_FRAME_SET_SOURCE_LAYER
            ? serialize_layer_id_compat(mkfs->source_id)
            : convert_other_id_compat(mkfs->source_id),
        data + written);
    written += DP_write_bigendian_uint16(mkfs->source_index, data + written);
    written += DP_write_bigendian_uint8(mkfs->source, data + written);
    DP_ASSERT(written == msg_key_frame_set_payload_length_compat(msg));
    return written;
}

static bool msg_key_frame_set_write_payload_text(DP_Message *msg,
                                                 DP_TextWriter *writer)
{
    DP_MsgKeyFrameSet *mkfs = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "frame_index", mkfs->frame_index)
        && DP_text_writer_write_uint(writer, "source", mkfs->source)
        && DP_text_writer_write_uint(writer, "source_id", mkfs->source_id)
        && DP_text_writer_write_uint(writer, "source_index", mkfs->source_index)
        && DP_text_writer_write_uint(writer, "track_id", mkfs->track_id);
}

static bool msg_key_frame_set_equals(DP_Message *DP_RESTRICT msg,
                                     DP_Message *DP_RESTRICT other)
{
    DP_MsgKeyFrameSet *a = DP_message_internal(msg);
    DP_MsgKeyFrameSet *b = DP_message_internal(other);
    return a->track_id == b->track_id && a->frame_index == b->frame_index
        && a->source_id == b->source_id && a->source_index == b->source_index
        && a->source == b->source;
}

static const DP_MessageMethods msg_key_frame_set_methods = {
    msg_key_frame_set_payload_length,
    msg_key_frame_set_serialize_payload,
    msg_key_frame_set_payload_length_compat,
    msg_key_frame_set_serialize_payload_compat,
    msg_key_frame_set_write_payload_text,
    msg_key_frame_set_equals,
};

DP_Message *DP_msg_key_frame_set_new(unsigned int context_id, uint16_t track_id,
                                     uint16_t frame_index, uint32_t source_id,
                                     uint16_t source_index, uint8_t source)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_KEY_FRAME_SET, context_id,
                       &msg_key_frame_set_methods, sizeof(DP_MsgKeyFrameSet));
    DP_MsgKeyFrameSet *mkfs = DP_message_internal(msg);
    mkfs->track_id = track_id;
    mkfs->frame_index = frame_index;
    mkfs->source_id = source_id;
    mkfs->source_index = source_index;
    mkfs->source = source;
    return msg;
}

DP_Message *DP_msg_key_frame_set_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length)
{
    if (length != 10) {
        DP_error_set("Wrong length for keyframeset message; "
                     "expected 10, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t track_id = read_uint16(buffer + read, &read);
    uint16_t frame_index = read_uint16(buffer + read, &read);
    uint32_t source_id = read_uint24(buffer + read, &read);
    uint16_t source_index = read_uint16(buffer + read, &read);
    uint8_t source = read_uint8(buffer + read, &read);
    return DP_msg_key_frame_set_new(context_id, track_id, frame_index,
                                    source_id, source_index, source);
}

DP_Message *DP_msg_key_frame_set_deserialize_compat(unsigned int context_id,
                                                    const unsigned char *buffer,
                                                    size_t length)
{
    if (length != 9) {
        DP_error_set("Wrong length for keyframeset compat message; "
                     "expected 9, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t track_id = read_uint16(buffer + read, &read);
    uint16_t frame_index = read_uint16(buffer + read, &read);
    uint16_t source_id = read_uint16(buffer + read, &read);
    uint16_t source_index = read_uint16(buffer + read, &read);
    uint8_t source = read_uint8(buffer + read, &read);
    DP_Message *msg = DP_msg_key_frame_set_new(
        context_id, convert_other_id_compat(track_id), frame_index,
        source == DP_MSG_KEY_FRAME_SET_SOURCE_LAYER
            ? deserialize_layer_id_compat(source_id)
            : convert_other_id_compat(source_id),
        source_index, source);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_key_frame_set_parse(unsigned int context_id,
                                       DP_TextReader *reader)
{
    uint16_t track_id =
        (uint16_t)DP_text_reader_get_ulong(reader, "track_id", UINT16_MAX);
    uint16_t frame_index =
        (uint16_t)DP_text_reader_get_ulong(reader, "frame_index", UINT16_MAX);
    uint32_t source_id =
        (uint32_t)DP_text_reader_get_ulong(reader, "source_id", DP_UINT24_MAX);
    uint16_t source_index =
        (uint16_t)DP_text_reader_get_ulong(reader, "source_index", UINT16_MAX);
    uint8_t source =
        (uint8_t)DP_text_reader_get_ulong(reader, "source", UINT8_MAX);
    return DP_msg_key_frame_set_new(context_id, track_id, frame_index,
                                    source_id, source_index, source);
}

DP_MsgKeyFrameSet *DP_msg_key_frame_set_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_KEY_FRAME_SET);
}

uint16_t DP_msg_key_frame_set_track_id(const DP_MsgKeyFrameSet *mkfs)
{
    DP_ASSERT(mkfs);
    return mkfs->track_id;
}

uint16_t DP_msg_key_frame_set_frame_index(const DP_MsgKeyFrameSet *mkfs)
{
    DP_ASSERT(mkfs);
    return mkfs->frame_index;
}

uint32_t DP_msg_key_frame_set_source_id(const DP_MsgKeyFrameSet *mkfs)
{
    DP_ASSERT(mkfs);
    return mkfs->source_id;
}

uint16_t DP_msg_key_frame_set_source_index(const DP_MsgKeyFrameSet *mkfs)
{
    DP_ASSERT(mkfs);
    return mkfs->source_index;
}

uint8_t DP_msg_key_frame_set_source(const DP_MsgKeyFrameSet *mkfs)
{
    DP_ASSERT(mkfs);
    return mkfs->source;
}


/* DP_MSG_KEY_FRAME_RETITLE */

struct DP_MsgKeyFrameRetitle {
    uint16_t track_id;
    uint16_t frame_index;
    uint16_t title_len;
    char title[];
};

static size_t msg_key_frame_retitle_payload_length(DP_Message *msg)
{
    DP_MsgKeyFrameRetitle *mkfr = DP_message_internal(msg);
    return ((size_t)4) + DP_uint16_to_size(mkfr->title_len);
}

static size_t msg_key_frame_retitle_payload_length_compat(DP_Message *msg)
{
    DP_MsgKeyFrameRetitle *mkfr = DP_message_internal(msg);
    return ((size_t)4) + DP_uint16_to_size(mkfr->title_len);
}

static size_t msg_key_frame_retitle_serialize_payload(DP_Message *msg,
                                                      unsigned char *data)
{
    DP_MsgKeyFrameRetitle *mkfr = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(mkfr->track_id, data + written);
    written += DP_write_bigendian_uint16(mkfr->frame_index, data + written);
    written += DP_write_bytes(mkfr->title, 1, mkfr->title_len, data + written);
    DP_ASSERT(written == msg_key_frame_retitle_payload_length(msg));
    return written;
}

static size_t
msg_key_frame_retitle_serialize_payload_compat(DP_Message *msg,
                                               unsigned char *data)
{
    DP_MsgKeyFrameRetitle *mkfr = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(
        convert_other_id_compat(mkfr->track_id), data + written);
    written += DP_write_bigendian_uint16(mkfr->frame_index, data + written);
    written += DP_write_bytes(mkfr->title, 1, mkfr->title_len, data + written);
    DP_ASSERT(written == msg_key_frame_retitle_payload_length_compat(msg));
    return written;
}

static bool msg_key_frame_retitle_write_payload_text(DP_Message *msg,
                                                     DP_TextWriter *writer)
{
    DP_MsgKeyFrameRetitle *mkfr = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "frame_index", mkfr->frame_index)
        && DP_text_writer_write_string(writer, "title", mkfr->title)
        && DP_text_writer_write_uint(writer, "track_id", mkfr->track_id);
}

static bool msg_key_frame_retitle_equals(DP_Message *DP_RESTRICT msg,
                                         DP_Message *DP_RESTRICT other)
{
    DP_MsgKeyFrameRetitle *a = DP_message_internal(msg);
    DP_MsgKeyFrameRetitle *b = DP_message_internal(other);
    return a->track_id == b->track_id && a->frame_index == b->frame_index
        && a->title_len == b->title_len
        && memcmp(a->title, b->title, a->title_len) == 0;
}

static const DP_MessageMethods msg_key_frame_retitle_methods = {
    msg_key_frame_retitle_payload_length,
    msg_key_frame_retitle_serialize_payload,
    msg_key_frame_retitle_payload_length_compat,
    msg_key_frame_retitle_serialize_payload_compat,
    msg_key_frame_retitle_write_payload_text,
    msg_key_frame_retitle_equals,
};

DP_Message *DP_msg_key_frame_retitle_new(unsigned int context_id,
                                         uint16_t track_id,
                                         uint16_t frame_index,
                                         const char *title_value,
                                         size_t title_len)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_KEY_FRAME_RETITLE, context_id, &msg_key_frame_retitle_methods,
        DP_FLEX_SIZEOF(DP_MsgKeyFrameRetitle, title, title_len + 1));
    DP_MsgKeyFrameRetitle *mkfr = DP_message_internal(msg);
    mkfr->track_id = track_id;
    mkfr->frame_index = frame_index;
    mkfr->title_len = DP_size_to_uint16(title_len);
    assign_string(mkfr->title, title_value, mkfr->title_len);
    return msg;
}

DP_Message *DP_msg_key_frame_retitle_deserialize(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length)
{
    if (length < 4 || length > 65535) {
        DP_error_set("Wrong length for keyframeretitle message; "
                     "expected between 4 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t track_id = read_uint16(buffer + read, &read);
    uint16_t frame_index = read_uint16(buffer + read, &read);
    size_t title_bytes = length - read;
    uint16_t title_len = DP_size_to_uint16(title_bytes);
    const char *title = (const char *)buffer + read;
    return DP_msg_key_frame_retitle_new(context_id, track_id, frame_index,
                                        title, title_len);
}

DP_Message *DP_msg_key_frame_retitle_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length < 4 || length > 65535) {
        DP_error_set("Wrong length for keyframeretitle compat message; "
                     "expected between 4 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t track_id = read_uint16(buffer + read, &read);
    uint16_t frame_index = read_uint16(buffer + read, &read);
    size_t title_bytes = length - read;
    uint16_t title_len = DP_size_to_uint16(title_bytes);
    const char *title = (const char *)buffer + read;
    DP_Message *msg = DP_msg_key_frame_retitle_new(
        context_id, convert_other_id_compat(track_id), frame_index, title,
        title_len);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_key_frame_retitle_parse(unsigned int context_id,
                                           DP_TextReader *reader)
{
    uint16_t track_id =
        (uint16_t)DP_text_reader_get_ulong(reader, "track_id", UINT16_MAX);
    uint16_t frame_index =
        (uint16_t)DP_text_reader_get_ulong(reader, "frame_index", UINT16_MAX);
    uint16_t title_len;
    const char *title = DP_text_reader_get_string(reader, "title", &title_len);
    return DP_msg_key_frame_retitle_new(context_id, track_id, frame_index,
                                        title, title_len);
}

DP_MsgKeyFrameRetitle *DP_msg_key_frame_retitle_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_KEY_FRAME_RETITLE);
}

uint16_t DP_msg_key_frame_retitle_track_id(const DP_MsgKeyFrameRetitle *mkfr)
{
    DP_ASSERT(mkfr);
    return mkfr->track_id;
}

uint16_t DP_msg_key_frame_retitle_frame_index(const DP_MsgKeyFrameRetitle *mkfr)
{
    DP_ASSERT(mkfr);
    return mkfr->frame_index;
}

const char *DP_msg_key_frame_retitle_title(const DP_MsgKeyFrameRetitle *mkfr,
                                           size_t *out_len)
{
    DP_ASSERT(mkfr);
    if (out_len) {
        *out_len = mkfr->title_len;
    }
    return mkfr->title;
}

size_t DP_msg_key_frame_retitle_title_len(const DP_MsgKeyFrameRetitle *mkfr)
{
    return mkfr->title_len;
}


/* DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES */

struct DP_MsgKeyFrameLayerAttributes {
    uint16_t track_id;
    uint16_t frame_index;
    uint16_t layer_flags_count;
    uint32_t layer_flags[];
};

static size_t msg_key_frame_layer_attributes_payload_length(DP_Message *msg)
{
    DP_MsgKeyFrameLayerAttributes *mkfla = DP_message_internal(msg);
    return ((size_t)4) + DP_int_to_size(mkfla->layer_flags_count) * 4;
}

static size_t
msg_key_frame_layer_attributes_payload_length_compat(DP_Message *msg)
{
    DP_MsgKeyFrameLayerAttributes *mkfla = DP_message_internal(msg);
    return ((size_t)4) + DP_int_to_size(mkfla->layer_flags_count) * 4;
}

static size_t
msg_key_frame_layer_attributes_serialize_payload(DP_Message *msg,
                                                 unsigned char *data)
{
    DP_MsgKeyFrameLayerAttributes *mkfla = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(mkfla->track_id, data + written);
    written += DP_write_bigendian_uint16(mkfla->frame_index, data + written);
    written += DP_write_bigendian_uint32_array(
        mkfla->layer_flags, mkfla->layer_flags_count, data + written);
    DP_ASSERT(written == msg_key_frame_layer_attributes_payload_length(msg));
    return written;
}

static size_t
msg_key_frame_layer_attributes_serialize_payload_compat(DP_Message *msg,
                                                        unsigned char *data)
{
    DP_MsgKeyFrameLayerAttributes *mkfla = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(
        convert_other_id_compat(mkfla->track_id), data + written);
    written += DP_write_bigendian_uint16(mkfla->frame_index, data + written);
    written += write_key_frame_layer_flags_compat(
        mkfla->layer_flags, mkfla->layer_flags_count, data + written);
    DP_ASSERT(written
              == msg_key_frame_layer_attributes_payload_length_compat(msg));
    return written;
}

static bool
msg_key_frame_layer_attributes_write_payload_text(DP_Message *msg,
                                                  DP_TextWriter *writer)
{
    DP_MsgKeyFrameLayerAttributes *mkfla = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "frame_index", mkfla->frame_index)
        && DP_text_writer_write_uint32_list(writer, "layer_flags",
                                            mkfla->layer_flags,
                                            mkfla->layer_flags_count)
        && DP_text_writer_write_uint(writer, "track_id", mkfla->track_id);
}

static bool msg_key_frame_layer_attributes_equals(DP_Message *DP_RESTRICT msg,
                                                  DP_Message *DP_RESTRICT other)
{
    DP_MsgKeyFrameLayerAttributes *a = DP_message_internal(msg);
    DP_MsgKeyFrameLayerAttributes *b = DP_message_internal(other);
    return a->track_id == b->track_id && a->frame_index == b->frame_index
        && a->layer_flags_count == b->layer_flags_count
        && memcmp(a->layer_flags, b->layer_flags,
                  DP_uint16_to_size(a->layer_flags_count) * 4)
               == 0;
}

static const DP_MessageMethods msg_key_frame_layer_attributes_methods = {
    msg_key_frame_layer_attributes_payload_length,
    msg_key_frame_layer_attributes_serialize_payload,
    msg_key_frame_layer_attributes_payload_length_compat,
    msg_key_frame_layer_attributes_serialize_payload_compat,
    msg_key_frame_layer_attributes_write_payload_text,
    msg_key_frame_layer_attributes_equals,
};

DP_Message *DP_msg_key_frame_layer_attributes_new(
    unsigned int context_id, uint16_t track_id, uint16_t frame_index,
    void (*set_layer_flags)(int, uint32_t *, void *), int layer_flags_count,
    void *layer_flags_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES, context_id,
        &msg_key_frame_layer_attributes_methods,
        DP_FLEX_SIZEOF(DP_MsgKeyFrameLayerAttributes, layer_flags,
                       DP_int_to_size(layer_flags_count) * 4));
    DP_MsgKeyFrameLayerAttributes *mkfla = DP_message_internal(msg);
    mkfla->track_id = track_id;
    mkfla->frame_index = frame_index;
    mkfla->layer_flags_count = DP_int_to_uint16(layer_flags_count);
    if (set_layer_flags) {
        set_layer_flags(mkfla->layer_flags_count, mkfla->layer_flags,
                        layer_flags_user);
    }
    return msg;
}

DP_Message *DP_msg_key_frame_layer_attributes_deserialize(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length < 4 || length > 65535) {
        DP_error_set("Wrong length for keyframelayerattributes message; "
                     "expected between 4 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t track_id = read_uint16(buffer + read, &read);
    uint16_t frame_index = read_uint16(buffer + read, &read);
    size_t layer_flags_bytes = length - read;
    if ((layer_flags_bytes % 4) != 0) {
        DP_error_set("Wrong length for layer_flags field in "
                     "keyframelayerattributes message; "
                     "%zu not divisible by 4",
                     layer_flags_bytes);
        return NULL;
    }
    uint16_t layer_flags_count = DP_size_to_uint16(layer_flags_bytes / 4);
    void *layer_flags_user = (void *)(buffer + read);
    return DP_msg_key_frame_layer_attributes_new(
        context_id, track_id, frame_index, read_uint32_array, layer_flags_count,
        layer_flags_user);
}

DP_Message *DP_msg_key_frame_layer_attributes_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length < 4 || length > 65535) {
        DP_error_set("Wrong length for keyframelayerattributes compat message; "
                     "expected between 4 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t track_id = read_uint16(buffer + read, &read);
    uint16_t frame_index = read_uint16(buffer + read, &read);
    size_t layer_flags_bytes = length - read;
    if ((layer_flags_bytes % 2) != 0) {
        DP_error_set("Wrong length for layer_flags field in "
                     "keyframelayerattributes message; "
                     "%zu not divisible by 2",
                     layer_flags_bytes);
        return NULL;
    }
    uint16_t layer_flags_count = DP_size_to_uint16(layer_flags_bytes / 2);
    void *layer_flags_user = (void *)(buffer + read);
    DP_Message *msg = DP_msg_key_frame_layer_attributes_new(
        context_id, convert_other_id_compat(track_id), frame_index,
        read_key_frame_layer_flags_compat, layer_flags_count / 2,
        layer_flags_user);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_key_frame_layer_attributes_parse(unsigned int context_id,
                                                    DP_TextReader *reader)
{
    uint16_t track_id =
        (uint16_t)DP_text_reader_get_ulong(reader, "track_id", UINT16_MAX);
    uint16_t frame_index =
        (uint16_t)DP_text_reader_get_ulong(reader, "frame_index", UINT16_MAX);
    int layer_flags_count;
    DP_TextReaderParseParams layer_flags_params =
        DP_text_reader_get_array(reader, "layer_flags", &layer_flags_count);
    return DP_msg_key_frame_layer_attributes_new(
        context_id, track_id, frame_index, DP_text_reader_parse_uint32_array,
        layer_flags_count, &layer_flags_params);
}

DP_MsgKeyFrameLayerAttributes *
DP_msg_key_frame_layer_attributes_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES);
}

uint16_t DP_msg_key_frame_layer_attributes_track_id(
    const DP_MsgKeyFrameLayerAttributes *mkfla)
{
    DP_ASSERT(mkfla);
    return mkfla->track_id;
}

uint16_t DP_msg_key_frame_layer_attributes_frame_index(
    const DP_MsgKeyFrameLayerAttributes *mkfla)
{
    DP_ASSERT(mkfla);
    return mkfla->frame_index;
}

const uint32_t *DP_msg_key_frame_layer_attributes_layer_flags(
    const DP_MsgKeyFrameLayerAttributes *mkfla, int *out_count)
{
    DP_ASSERT(mkfla);
    if (out_count) {
        *out_count = mkfla->layer_flags_count;
    }
    return mkfla->layer_flags;
}

int DP_msg_key_frame_layer_attributes_layer_flags_count(
    const DP_MsgKeyFrameLayerAttributes *mkfla)
{
    return mkfla->layer_flags_count;
}


/* DP_MSG_KEY_FRAME_DELETE */

struct DP_MsgKeyFrameDelete {
    uint16_t track_id;
    uint16_t frame_index;
    uint16_t move_track_id;
    uint16_t move_frame_index;
};

static size_t msg_key_frame_delete_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)8);
}

static size_t
msg_key_frame_delete_payload_length_compat(DP_UNUSED DP_Message *msg)
{
    return ((size_t)8);
}

static size_t msg_key_frame_delete_serialize_payload(DP_Message *msg,
                                                     unsigned char *data)
{
    DP_MsgKeyFrameDelete *mkfd = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(mkfd->track_id, data + written);
    written += DP_write_bigendian_uint16(mkfd->frame_index, data + written);
    written += DP_write_bigendian_uint16(mkfd->move_track_id, data + written);
    written +=
        DP_write_bigendian_uint16(mkfd->move_frame_index, data + written);
    DP_ASSERT(written == msg_key_frame_delete_payload_length(msg));
    return written;
}

static size_t msg_key_frame_delete_serialize_payload_compat(DP_Message *msg,
                                                            unsigned char *data)
{
    DP_MsgKeyFrameDelete *mkfd = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint16(
        convert_other_id_compat(mkfd->track_id), data + written);
    written += DP_write_bigendian_uint16(mkfd->frame_index, data + written);
    written += DP_write_bigendian_uint16(
        convert_other_id_compat(mkfd->move_track_id), data + written);
    written +=
        DP_write_bigendian_uint16(mkfd->move_frame_index, data + written);
    DP_ASSERT(written == msg_key_frame_delete_payload_length_compat(msg));
    return written;
}

static bool msg_key_frame_delete_write_payload_text(DP_Message *msg,
                                                    DP_TextWriter *writer)
{
    DP_MsgKeyFrameDelete *mkfd = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "frame_index", mkfd->frame_index)
        && DP_text_writer_write_uint(writer, "move_frame_index",
                                     mkfd->move_frame_index)
        && DP_text_writer_write_uint(writer, "move_track_id",
                                     mkfd->move_track_id)
        && DP_text_writer_write_uint(writer, "track_id", mkfd->track_id);
}

static bool msg_key_frame_delete_equals(DP_Message *DP_RESTRICT msg,
                                        DP_Message *DP_RESTRICT other)
{
    DP_MsgKeyFrameDelete *a = DP_message_internal(msg);
    DP_MsgKeyFrameDelete *b = DP_message_internal(other);
    return a->track_id == b->track_id && a->frame_index == b->frame_index
        && a->move_track_id == b->move_track_id
        && a->move_frame_index == b->move_frame_index;
}

static const DP_MessageMethods msg_key_frame_delete_methods = {
    msg_key_frame_delete_payload_length,
    msg_key_frame_delete_serialize_payload,
    msg_key_frame_delete_payload_length_compat,
    msg_key_frame_delete_serialize_payload_compat,
    msg_key_frame_delete_write_payload_text,
    msg_key_frame_delete_equals,
};

DP_Message *DP_msg_key_frame_delete_new(unsigned int context_id,
                                        uint16_t track_id, uint16_t frame_index,
                                        uint16_t move_track_id,
                                        uint16_t move_frame_index)
{
    DP_Message *msg = DP_message_new(DP_MSG_KEY_FRAME_DELETE, context_id,
                                     &msg_key_frame_delete_methods,
                                     sizeof(DP_MsgKeyFrameDelete));
    DP_MsgKeyFrameDelete *mkfd = DP_message_internal(msg);
    mkfd->track_id = track_id;
    mkfd->frame_index = frame_index;
    mkfd->move_track_id = move_track_id;
    mkfd->move_frame_index = move_frame_index;
    return msg;
}

DP_Message *DP_msg_key_frame_delete_deserialize(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length)
{
    if (length != 8) {
        DP_error_set("Wrong length for keyframedelete message; "
                     "expected 8, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t track_id = read_uint16(buffer + read, &read);
    uint16_t frame_index = read_uint16(buffer + read, &read);
    uint16_t move_track_id = read_uint16(buffer + read, &read);
    uint16_t move_frame_index = read_uint16(buffer + read, &read);
    return DP_msg_key_frame_delete_new(context_id, track_id, frame_index,
                                       move_track_id, move_frame_index);
}

DP_Message *DP_msg_key_frame_delete_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length != 8) {
        DP_error_set("Wrong length for keyframedelete compat message; "
                     "expected 8, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint16_t track_id = read_uint16(buffer + read, &read);
    uint16_t frame_index = read_uint16(buffer + read, &read);
    uint16_t move_track_id = read_uint16(buffer + read, &read);
    uint16_t move_frame_index = read_uint16(buffer + read, &read);
    DP_Message *msg = DP_msg_key_frame_delete_new(
        context_id, convert_other_id_compat(track_id), frame_index,
        convert_other_id_compat(move_track_id), move_frame_index);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_key_frame_delete_parse(unsigned int context_id,
                                          DP_TextReader *reader)
{
    uint16_t track_id =
        (uint16_t)DP_text_reader_get_ulong(reader, "track_id", UINT16_MAX);
    uint16_t frame_index =
        (uint16_t)DP_text_reader_get_ulong(reader, "frame_index", UINT16_MAX);
    uint16_t move_track_id =
        (uint16_t)DP_text_reader_get_ulong(reader, "move_track_id", UINT16_MAX);
    uint16_t move_frame_index = (uint16_t)DP_text_reader_get_ulong(
        reader, "move_frame_index", UINT16_MAX);
    return DP_msg_key_frame_delete_new(context_id, track_id, frame_index,
                                       move_track_id, move_frame_index);
}

DP_MsgKeyFrameDelete *DP_msg_key_frame_delete_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_KEY_FRAME_DELETE);
}

uint16_t DP_msg_key_frame_delete_track_id(const DP_MsgKeyFrameDelete *mkfd)
{
    DP_ASSERT(mkfd);
    return mkfd->track_id;
}

uint16_t DP_msg_key_frame_delete_frame_index(const DP_MsgKeyFrameDelete *mkfd)
{
    DP_ASSERT(mkfd);
    return mkfd->frame_index;
}

uint16_t DP_msg_key_frame_delete_move_track_id(const DP_MsgKeyFrameDelete *mkfd)
{
    DP_ASSERT(mkfd);
    return mkfd->move_track_id;
}

uint16_t
DP_msg_key_frame_delete_move_frame_index(const DP_MsgKeyFrameDelete *mkfd)
{
    DP_ASSERT(mkfd);
    return mkfd->move_frame_index;
}


/* DP_MSG_SELECTION_PUT */

const char *DP_msg_selection_put_op_variant_name(unsigned int value)
{
    switch (value) {
    case DP_MSG_SELECTION_PUT_OP_REPLACE:
        return "Replace";
    case DP_MSG_SELECTION_PUT_OP_UNITE:
        return "Unite";
    case DP_MSG_SELECTION_PUT_OP_INTERSECT:
        return "Intersect";
    case DP_MSG_SELECTION_PUT_OP_EXCLUDE:
        return "Exclude";
    case DP_MSG_SELECTION_PUT_OP_COMPLEMENT:
        return "Complement";
    default:
        return NULL;
    }
}

struct DP_MsgSelectionPut {
    uint8_t selection_id;
    uint8_t op;
    int32_t x;
    int32_t y;
    uint32_t w;
    uint32_t h;
    uint16_t mask_size;
    unsigned char mask[];
};

static size_t msg_selection_put_payload_length(DP_Message *msg)
{
    DP_MsgSelectionPut *msp = DP_message_internal(msg);
    return ((size_t)18) + msp->mask_size;
}

static size_t msg_selection_put_serialize_payload(DP_Message *msg,
                                                  unsigned char *data)
{
    DP_MsgSelectionPut *msp = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(msp->selection_id, data + written);
    written += DP_write_bigendian_uint8(msp->op, data + written);
    written += DP_write_bigendian_int32(msp->x, data + written);
    written += DP_write_bigendian_int32(msp->y, data + written);
    written += DP_write_bigendian_uint32(msp->w, data + written);
    written += DP_write_bigendian_uint32(msp->h, data + written);
    written += write_bytes(msp->mask, msp->mask_size, data + written);
    DP_ASSERT(written == msg_selection_put_payload_length(msg));
    return written;
}

static bool msg_selection_put_write_payload_text(DP_Message *msg,
                                                 DP_TextWriter *writer)
{
    DP_MsgSelectionPut *msp = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "h", msp->h)
        && DP_text_writer_write_base64(writer, "mask", msp->mask,
                                       msp->mask_size)
        && DP_text_writer_write_uint(writer, "op", msp->op)
        && DP_text_writer_write_uint(writer, "selection_id", msp->selection_id)
        && DP_text_writer_write_uint(writer, "w", msp->w)
        && DP_text_writer_write_int(writer, "x", msp->x)
        && DP_text_writer_write_int(writer, "y", msp->y);
}

static bool msg_selection_put_equals(DP_Message *DP_RESTRICT msg,
                                     DP_Message *DP_RESTRICT other)
{
    DP_MsgSelectionPut *a = DP_message_internal(msg);
    DP_MsgSelectionPut *b = DP_message_internal(other);
    return a->selection_id == b->selection_id && a->op == b->op && a->x == b->x
        && a->y == b->y && a->w == b->w && a->h == b->h
        && a->mask_size == b->mask_size
        && memcmp(a->mask, b->mask, DP_uint16_to_size(a->mask_size)) == 0;
}

void DP_msg_selection_put_local_match_set(DP_UNUSED size_t size,
                                          unsigned char *data, void *user)
{
    DP_ASSERT(size == DP_MSG_SELECTION_PUT_MATCH_LENGTH);
    const DP_MsgSelectionPut *msp = user;
    size_t written = 0;
    written += DP_write_bigendian_uint8(msp->selection_id, data + written);
    written += DP_write_bigendian_uint8(msp->op, data + written);
    written += DP_write_bigendian_int32(msp->x, data + written);
    written += DP_write_bigendian_int32(msp->y, data + written);
    written += DP_write_bigendian_uint32(msp->w, data + written);
    written += DP_write_bigendian_uint32(msp->h, data + written);
    written += DP_write_bigendian_uint16(msp->mask_size, data + written);
    DP_ASSERT(written == DP_MSG_SELECTION_PUT_MATCH_LENGTH);
}

bool DP_msg_selection_put_local_match_matches(const DP_MsgSelectionPut *msp,
                                              DP_Message *local_match_msg)
{
    size_t size;
    const unsigned char *buffer = local_match_data(local_match_msg, &size);
    size_t read = 0;
    return size == DP_MSG_SELECTION_PUT_MATCH_LENGTH
        && read_uint8(buffer + read, &read) == msp->selection_id
        && read_uint8(buffer + read, &read) == msp->op
        && read_int32(buffer + read, &read) == msp->x
        && read_int32(buffer + read, &read) == msp->y
        && read_uint32(buffer + read, &read) == msp->w
        && read_uint32(buffer + read, &read) == msp->h
        && read_uint16(buffer + read, &read) == msp->mask_size;
}

static const DP_MessageMethods msg_selection_put_methods = {
    msg_selection_put_payload_length,     msg_selection_put_serialize_payload,
    msg_selection_put_payload_length,     msg_selection_put_serialize_payload,
    msg_selection_put_write_payload_text, msg_selection_put_equals,
};

DP_Message *
DP_msg_selection_put_new(unsigned int context_id, uint8_t selection_id,
                         uint8_t op, int32_t x, int32_t y, uint32_t w,
                         uint32_t h,
                         void (*set_mask)(size_t, unsigned char *, void *),
                         size_t mask_size, void *mask_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_SELECTION_PUT, context_id, &msg_selection_put_methods,
        DP_FLEX_SIZEOF(DP_MsgSelectionPut, mask, mask_size));
    DP_MsgSelectionPut *msp = DP_message_internal(msg);
    msp->selection_id = selection_id;
    msp->op = op;
    msp->x = x;
    msp->y = y;
    msp->w = w;
    msp->h = h;
    msp->mask_size = DP_size_to_uint16(mask_size);
    if (set_mask) {
        set_mask(msp->mask_size, msp->mask, mask_user);
    }
    return msg;
}

DP_Message *DP_msg_selection_put_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length)
{
    if (length < 18 || length > 65535) {
        DP_error_set("Wrong length for selectionput message; "
                     "expected between 18 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t selection_id = read_uint8(buffer + read, &read);
    uint8_t op = read_uint8(buffer + read, &read);
    int32_t x = read_int32(buffer + read, &read);
    int32_t y = read_int32(buffer + read, &read);
    uint32_t w = read_uint32(buffer + read, &read);
    uint32_t h = read_uint32(buffer + read, &read);
    size_t mask_bytes = length - read;
    uint16_t mask_size = DP_size_to_uint16(mask_bytes);
    void *mask_user = (void *)(buffer + read);
    return DP_msg_selection_put_new(context_id, selection_id, op, x, y, w, h,
                                    read_bytes, mask_size, mask_user);
}

DP_Message *DP_msg_selection_put_parse(unsigned int context_id,
                                       DP_TextReader *reader)
{
    uint8_t selection_id =
        (uint8_t)DP_text_reader_get_ulong(reader, "selection_id", UINT8_MAX);
    uint8_t op = (uint8_t)DP_text_reader_get_ulong(reader, "op", UINT8_MAX);
    int32_t x =
        (int32_t)DP_text_reader_get_long(reader, "x", INT32_MIN, INT32_MAX);
    int32_t y =
        (int32_t)DP_text_reader_get_long(reader, "y", INT32_MIN, INT32_MAX);
    uint32_t w = (uint32_t)DP_text_reader_get_ulong(reader, "w", UINT32_MAX);
    uint32_t h = (uint32_t)DP_text_reader_get_ulong(reader, "h", UINT32_MAX);
    size_t mask_size;
    DP_TextReaderParseParams mask_params =
        DP_text_reader_get_base64_string(reader, "mask", &mask_size);
    return DP_msg_selection_put_new(context_id, selection_id, op, x, y, w, h,
                                    DP_text_reader_parse_base64, mask_size,
                                    &mask_params);
}

DP_MsgSelectionPut *DP_msg_selection_put_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_SELECTION_PUT);
}

uint8_t DP_msg_selection_put_selection_id(const DP_MsgSelectionPut *msp)
{
    DP_ASSERT(msp);
    return msp->selection_id;
}

uint8_t DP_msg_selection_put_op(const DP_MsgSelectionPut *msp)
{
    DP_ASSERT(msp);
    return msp->op;
}

int32_t DP_msg_selection_put_x(const DP_MsgSelectionPut *msp)
{
    DP_ASSERT(msp);
    return msp->x;
}

int32_t DP_msg_selection_put_y(const DP_MsgSelectionPut *msp)
{
    DP_ASSERT(msp);
    return msp->y;
}

uint32_t DP_msg_selection_put_w(const DP_MsgSelectionPut *msp)
{
    DP_ASSERT(msp);
    return msp->w;
}

uint32_t DP_msg_selection_put_h(const DP_MsgSelectionPut *msp)
{
    DP_ASSERT(msp);
    return msp->h;
}

const unsigned char *DP_msg_selection_put_mask(const DP_MsgSelectionPut *msp,
                                               size_t *out_size)
{
    DP_ASSERT(msp);
    if (out_size) {
        *out_size = msp->mask_size;
    }
    return msp->mask;
}

size_t DP_msg_selection_put_mask_size(const DP_MsgSelectionPut *msp)
{
    return msp->mask_size;
}


/* DP_MSG_SELECTION_CLEAR */

struct DP_MsgSelectionClear {
    uint8_t selection_id;
};

static size_t msg_selection_clear_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)1);
}

static size_t msg_selection_clear_serialize_payload(DP_Message *msg,
                                                    unsigned char *data)
{
    DP_MsgSelectionClear *msc = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(msc->selection_id, data + written);
    DP_ASSERT(written == msg_selection_clear_payload_length(msg));
    return written;
}

static bool msg_selection_clear_write_payload_text(DP_Message *msg,
                                                   DP_TextWriter *writer)
{
    DP_MsgSelectionClear *msc = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "selection_id", msc->selection_id);
}

static bool msg_selection_clear_equals(DP_Message *DP_RESTRICT msg,
                                       DP_Message *DP_RESTRICT other)
{
    DP_MsgSelectionClear *a = DP_message_internal(msg);
    DP_MsgSelectionClear *b = DP_message_internal(other);
    return a->selection_id == b->selection_id;
}

void DP_msg_selection_clear_local_match_set(DP_UNUSED size_t size,
                                            unsigned char *data, void *user)
{
    DP_ASSERT(size == DP_MSG_SELECTION_CLEAR_MATCH_LENGTH);
    const DP_MsgSelectionClear *msc = user;
    size_t written = 0;
    written += DP_write_bigendian_uint8(msc->selection_id, data + written);
    DP_ASSERT(written == DP_MSG_SELECTION_CLEAR_MATCH_LENGTH);
}

bool DP_msg_selection_clear_local_match_matches(const DP_MsgSelectionClear *msc,
                                                DP_Message *local_match_msg)
{
    size_t size;
    const unsigned char *buffer = local_match_data(local_match_msg, &size);
    size_t read = 0;
    return size == DP_MSG_SELECTION_CLEAR_MATCH_LENGTH
        && read_uint8(buffer + read, &read) == msc->selection_id;
}

static const DP_MessageMethods msg_selection_clear_methods = {
    msg_selection_clear_payload_length,
    msg_selection_clear_serialize_payload,
    msg_selection_clear_payload_length,
    msg_selection_clear_serialize_payload,
    msg_selection_clear_write_payload_text,
    msg_selection_clear_equals,
};

DP_Message *DP_msg_selection_clear_new(unsigned int context_id,
                                       uint8_t selection_id)
{
    DP_Message *msg = DP_message_new(DP_MSG_SELECTION_CLEAR, context_id,
                                     &msg_selection_clear_methods,
                                     sizeof(DP_MsgSelectionClear));
    DP_MsgSelectionClear *msc = DP_message_internal(msg);
    msc->selection_id = selection_id;
    return msg;
}

DP_Message *DP_msg_selection_clear_deserialize(unsigned int context_id,
                                               const unsigned char *buffer,
                                               size_t length)
{
    if (length != 1) {
        DP_error_set("Wrong length for selectionclear message; "
                     "expected 1, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t selection_id = read_uint8(buffer + read, &read);
    return DP_msg_selection_clear_new(context_id, selection_id);
}

DP_Message *DP_msg_selection_clear_parse(unsigned int context_id,
                                         DP_TextReader *reader)
{
    uint8_t selection_id =
        (uint8_t)DP_text_reader_get_ulong(reader, "selection_id", UINT8_MAX);
    return DP_msg_selection_clear_new(context_id, selection_id);
}

DP_MsgSelectionClear *DP_msg_selection_clear_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_SELECTION_CLEAR);
}

uint8_t DP_msg_selection_clear_selection_id(const DP_MsgSelectionClear *msc)
{
    DP_ASSERT(msc);
    return msc->selection_id;
}


/* DP_MSG_LOCAL_MATCH */

struct DP_MsgLocalMatch {
    uint8_t type;
    uint16_t data_size;
    unsigned char data[];
};

static size_t msg_local_match_payload_length(DP_Message *msg)
{
    DP_MsgLocalMatch *mlm = DP_message_internal(msg);
    return ((size_t)1) + mlm->data_size;
}

static size_t msg_local_match_serialize_payload(DP_Message *msg,
                                                unsigned char *data)
{
    DP_MsgLocalMatch *mlm = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(mlm->type, data + written);
    written += write_bytes(mlm->data, mlm->data_size, data + written);
    DP_ASSERT(written == msg_local_match_payload_length(msg));
    return written;
}

static bool msg_local_match_write_payload_text(DP_Message *msg,
                                               DP_TextWriter *writer)
{
    DP_MsgLocalMatch *mlm = DP_message_internal(msg);
    return DP_text_writer_write_base64(writer, "data", mlm->data,
                                       mlm->data_size)
        && DP_text_writer_write_uint(writer, "type", mlm->type);
}

static bool msg_local_match_equals(DP_Message *DP_RESTRICT msg,
                                   DP_Message *DP_RESTRICT other)
{
    DP_MsgLocalMatch *a = DP_message_internal(msg);
    DP_MsgLocalMatch *b = DP_message_internal(other);
    return a->type == b->type && a->data_size == b->data_size
        && memcmp(a->data, b->data, DP_uint16_to_size(a->data_size)) == 0;
}

static const DP_MessageMethods msg_local_match_methods = {
    msg_local_match_payload_length,     msg_local_match_serialize_payload,
    msg_local_match_payload_length,     msg_local_match_serialize_payload,
    msg_local_match_write_payload_text, msg_local_match_equals,
};

DP_Message *DP_msg_local_match_new(unsigned int context_id, uint8_t type,
                                   void (*set_data)(size_t, unsigned char *,
                                                    void *),
                                   size_t data_size, void *data_user)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_LOCAL_MATCH, context_id, &msg_local_match_methods,
                       DP_FLEX_SIZEOF(DP_MsgLocalMatch, data, data_size));
    DP_MsgLocalMatch *mlm = DP_message_internal(msg);
    mlm->type = type;
    mlm->data_size = DP_size_to_uint16(data_size);
    if (set_data) {
        set_data(mlm->data_size, mlm->data, data_user);
    }
    return msg;
}

DP_Message *DP_msg_local_match_deserialize(unsigned int context_id,
                                           const unsigned char *buffer,
                                           size_t length)
{
    if (length < 1 || length > 65535) {
        DP_error_set("Wrong length for localmatch message; "
                     "expected between 1 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t type = read_uint8(buffer + read, &read);
    size_t data_bytes = length - read;
    uint16_t data_size = DP_size_to_uint16(data_bytes);
    void *data_user = (void *)(buffer + read);
    return DP_msg_local_match_new(context_id, type, read_bytes, data_size,
                                  data_user);
}

DP_Message *DP_msg_local_match_deserialize_compat(unsigned int context_id,
                                                  const unsigned char *buffer,
                                                  size_t length)
{
    DP_Message *msg =
        DP_msg_local_match_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_local_match_parse(unsigned int context_id,
                                     DP_TextReader *reader)
{
    uint8_t type = (uint8_t)DP_text_reader_get_ulong(reader, "type", UINT8_MAX);
    size_t data_size;
    DP_TextReaderParseParams data_params =
        DP_text_reader_get_base64_string(reader, "data", &data_size);
    return DP_msg_local_match_new(context_id, type, DP_text_reader_parse_base64,
                                  data_size, &data_params);
}

DP_MsgLocalMatch *DP_msg_local_match_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_LOCAL_MATCH);
}

uint8_t DP_msg_local_match_type(const DP_MsgLocalMatch *mlm)
{
    DP_ASSERT(mlm);
    return mlm->type;
}

const unsigned char *DP_msg_local_match_data(const DP_MsgLocalMatch *mlm,
                                             size_t *out_size)
{
    DP_ASSERT(mlm);
    if (out_size) {
        *out_size = mlm->data_size;
    }
    return mlm->data;
}

size_t DP_msg_local_match_data_size(const DP_MsgLocalMatch *mlm)
{
    return mlm->data_size;
}


/* DP_MSG_SYNC_SELECTION_TILE */

struct DP_MsgSyncSelectionTile {
    uint8_t user;
    uint8_t selection_id;
    uint16_t col;
    uint16_t row;
    uint16_t mask_size;
    unsigned char mask[];
};

static size_t msg_sync_selection_tile_payload_length(DP_Message *msg)
{
    DP_MsgSyncSelectionTile *msst = DP_message_internal(msg);
    return ((size_t)6) + msst->mask_size;
}

static size_t msg_sync_selection_tile_serialize_payload(DP_Message *msg,
                                                        unsigned char *data)
{
    DP_MsgSyncSelectionTile *msst = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(msst->user, data + written);
    written += DP_write_bigendian_uint8(msst->selection_id, data + written);
    written += DP_write_bigendian_uint16(msst->col, data + written);
    written += DP_write_bigendian_uint16(msst->row, data + written);
    written += write_bytes(msst->mask, msst->mask_size, data + written);
    DP_ASSERT(written == msg_sync_selection_tile_payload_length(msg));
    return written;
}

static bool msg_sync_selection_tile_write_payload_text(DP_Message *msg,
                                                       DP_TextWriter *writer)
{
    DP_MsgSyncSelectionTile *msst = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "col", msst->col)
        && DP_text_writer_write_base64(writer, "mask", msst->mask,
                                       msst->mask_size)
        && DP_text_writer_write_uint(writer, "row", msst->row)
        && DP_text_writer_write_uint(writer, "selection_id", msst->selection_id)
        && DP_text_writer_write_uint(writer, "user", msst->user);
}

static bool msg_sync_selection_tile_equals(DP_Message *DP_RESTRICT msg,
                                           DP_Message *DP_RESTRICT other)
{
    DP_MsgSyncSelectionTile *a = DP_message_internal(msg);
    DP_MsgSyncSelectionTile *b = DP_message_internal(other);
    return a->user == b->user && a->selection_id == b->selection_id
        && a->col == b->col && a->row == b->row && a->mask_size == b->mask_size
        && memcmp(a->mask, b->mask, DP_uint16_to_size(a->mask_size)) == 0;
}

static const DP_MessageMethods msg_sync_selection_tile_methods = {
    msg_sync_selection_tile_payload_length,
    msg_sync_selection_tile_serialize_payload,
    msg_sync_selection_tile_payload_length,
    msg_sync_selection_tile_serialize_payload,
    msg_sync_selection_tile_write_payload_text,
    msg_sync_selection_tile_equals,
};

DP_Message *DP_msg_sync_selection_tile_new(
    unsigned int context_id, uint8_t user, uint8_t selection_id, uint16_t col,
    uint16_t row, void (*set_mask)(size_t, unsigned char *, void *),
    size_t mask_size, void *mask_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_SYNC_SELECTION_TILE, context_id,
        &msg_sync_selection_tile_methods,
        DP_FLEX_SIZEOF(DP_MsgSyncSelectionTile, mask, mask_size));
    DP_MsgSyncSelectionTile *msst = DP_message_internal(msg);
    msst->user = user;
    msst->selection_id = selection_id;
    msst->col = col;
    msst->row = row;
    msst->mask_size = DP_size_to_uint16(mask_size);
    if (set_mask) {
        set_mask(msst->mask_size, msst->mask, mask_user);
    }
    return msg;
}

DP_Message *DP_msg_sync_selection_tile_deserialize(unsigned int context_id,
                                                   const unsigned char *buffer,
                                                   size_t length)
{
    if (length < 6 || length > 65535) {
        DP_error_set("Wrong length for syncselectiontile message; "
                     "expected between 6 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t user = read_uint8(buffer + read, &read);
    uint8_t selection_id = read_uint8(buffer + read, &read);
    uint16_t col = read_uint16(buffer + read, &read);
    uint16_t row = read_uint16(buffer + read, &read);
    size_t mask_bytes = length - read;
    uint16_t mask_size = DP_size_to_uint16(mask_bytes);
    void *mask_user = (void *)(buffer + read);
    return DP_msg_sync_selection_tile_new(context_id, user, selection_id, col,
                                          row, read_bytes, mask_size,
                                          mask_user);
}

DP_Message *DP_msg_sync_selection_tile_parse(unsigned int context_id,
                                             DP_TextReader *reader)
{
    uint8_t user = (uint8_t)DP_text_reader_get_ulong(reader, "user", UINT8_MAX);
    uint8_t selection_id =
        (uint8_t)DP_text_reader_get_ulong(reader, "selection_id", UINT8_MAX);
    uint16_t col =
        (uint16_t)DP_text_reader_get_ulong(reader, "col", UINT16_MAX);
    uint16_t row =
        (uint16_t)DP_text_reader_get_ulong(reader, "row", UINT16_MAX);
    size_t mask_size;
    DP_TextReaderParseParams mask_params =
        DP_text_reader_get_base64_string(reader, "mask", &mask_size);
    return DP_msg_sync_selection_tile_new(context_id, user, selection_id, col,
                                          row, DP_text_reader_parse_base64,
                                          mask_size, &mask_params);
}

DP_MsgSyncSelectionTile *DP_msg_sync_selection_tile_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_SYNC_SELECTION_TILE);
}

uint8_t DP_msg_sync_selection_tile_user(const DP_MsgSyncSelectionTile *msst)
{
    DP_ASSERT(msst);
    return msst->user;
}

uint8_t
DP_msg_sync_selection_tile_selection_id(const DP_MsgSyncSelectionTile *msst)
{
    DP_ASSERT(msst);
    return msst->selection_id;
}

uint16_t DP_msg_sync_selection_tile_col(const DP_MsgSyncSelectionTile *msst)
{
    DP_ASSERT(msst);
    return msst->col;
}

uint16_t DP_msg_sync_selection_tile_row(const DP_MsgSyncSelectionTile *msst)
{
    DP_ASSERT(msst);
    return msst->row;
}

const unsigned char *
DP_msg_sync_selection_tile_mask(const DP_MsgSyncSelectionTile *msst,
                                size_t *out_size)
{
    DP_ASSERT(msst);
    if (out_size) {
        *out_size = msst->mask_size;
    }
    return msst->mask;
}

size_t DP_msg_sync_selection_tile_mask_size(const DP_MsgSyncSelectionTile *msst)
{
    return msst->mask_size;
}


/* DP_MSG_PUT_IMAGE_ZSTD */

DP_Message *
DP_msg_put_image_zstd_new(unsigned int context_id, uint32_t layer, uint8_t mode,
                          uint32_t x, uint32_t y, uint32_t w, uint32_t h,
                          void (*set_image)(size_t, unsigned char *, void *),
                          size_t image_size, void *image_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_PUT_IMAGE_ZSTD, context_id, &msg_put_image_methods,
        DP_FLEX_SIZEOF(DP_MsgPutImage, image, image_size));
    DP_MsgPutImage *mpiz = DP_message_internal(msg);
    mpiz->layer = layer;
    mpiz->mode = mode;
    mpiz->x = x;
    mpiz->y = y;
    mpiz->w = w;
    mpiz->h = h;
    mpiz->image_size = DP_size_to_uint16(image_size);
    if (set_image) {
        set_image(mpiz->image_size, mpiz->image, image_user);
    }
    return msg;
}

DP_Message *DP_msg_put_image_zstd_deserialize(unsigned int context_id,
                                              const unsigned char *buffer,
                                              size_t length)
{
    if (length < 20 || length > 65535) {
        DP_error_set("Wrong length for putimagezstd message; "
                     "expected between 20 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint32_t layer = read_uint24(buffer + read, &read);
    uint8_t mode = read_uint8(buffer + read, &read);
    uint32_t x = read_uint32(buffer + read, &read);
    uint32_t y = read_uint32(buffer + read, &read);
    uint32_t w = read_uint32(buffer + read, &read);
    uint32_t h = read_uint32(buffer + read, &read);
    size_t image_bytes = length - read;
    uint16_t image_size = DP_size_to_uint16(image_bytes);
    void *image_user = (void *)(buffer + read);
    return DP_msg_put_image_zstd_new(context_id, layer, mode, x, y, w, h,
                                     read_bytes, image_size, image_user);
}

DP_Message *DP_msg_put_image_zstd_parse(unsigned int context_id,
                                        DP_TextReader *reader)
{
    uint32_t layer =
        (uint32_t)DP_text_reader_get_ulong(reader, "layer", DP_UINT24_MAX);
    uint8_t mode = DP_text_reader_get_blend_mode(reader, "mode");
    uint32_t x = (uint32_t)DP_text_reader_get_ulong(reader, "x", UINT32_MAX);
    uint32_t y = (uint32_t)DP_text_reader_get_ulong(reader, "y", UINT32_MAX);
    uint32_t w = (uint32_t)DP_text_reader_get_ulong(reader, "w", UINT32_MAX);
    uint32_t h = (uint32_t)DP_text_reader_get_ulong(reader, "h", UINT32_MAX);
    size_t image_size;
    DP_TextReaderParseParams image_params =
        DP_text_reader_get_base64_string(reader, "image", &image_size);
    return DP_msg_put_image_zstd_new(context_id, layer, mode, x, y, w, h,
                                     DP_text_reader_parse_base64, image_size,
                                     &image_params);
}

DP_MsgPutImage *DP_msg_put_image_zstd_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_PUT_IMAGE_ZSTD);
}


/* DP_MSG_PUT_TILE_ZSTD */

DP_Message *
DP_msg_put_tile_zstd_new(unsigned int context_id, uint8_t user, uint32_t layer,
                         uint8_t sublayer, uint16_t col, uint16_t row,
                         uint16_t repeat,
                         void (*set_image)(size_t, unsigned char *, void *),
                         size_t image_size, void *image_user)
{
    DP_Message *msg =
        DP_message_new(DP_MSG_PUT_TILE_ZSTD, context_id, &msg_put_tile_methods,
                       DP_FLEX_SIZEOF(DP_MsgPutTile, image, image_size));
    DP_MsgPutTile *mptz = DP_message_internal(msg);
    mptz->user = user;
    mptz->layer = layer;
    mptz->sublayer = sublayer;
    mptz->col = col;
    mptz->row = row;
    mptz->repeat = repeat;
    mptz->image_size = DP_size_to_uint16(image_size);
    if (set_image) {
        set_image(mptz->image_size, mptz->image, image_user);
    }
    return msg;
}

DP_Message *DP_msg_put_tile_zstd_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length)
{
    if (length < 11 || length > 65535) {
        DP_error_set("Wrong length for puttilezstd message; "
                     "expected between 11 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t user = read_uint8(buffer + read, &read);
    uint32_t layer = read_uint24(buffer + read, &read);
    uint8_t sublayer = read_uint8(buffer + read, &read);
    uint16_t col = read_uint16(buffer + read, &read);
    uint16_t row = read_uint16(buffer + read, &read);
    uint16_t repeat = read_uint16(buffer + read, &read);
    size_t image_bytes = length - read;
    uint16_t image_size = DP_size_to_uint16(image_bytes);
    void *image_user = (void *)(buffer + read);
    return DP_msg_put_tile_zstd_new(context_id, user, layer, sublayer, col, row,
                                    repeat, read_bytes, image_size, image_user);
}

DP_Message *DP_msg_put_tile_zstd_parse(unsigned int context_id,
                                       DP_TextReader *reader)
{
    uint8_t user = (uint8_t)DP_text_reader_get_ulong(reader, "user", UINT8_MAX);
    uint32_t layer =
        (uint32_t)DP_text_reader_get_ulong(reader, "layer", DP_UINT24_MAX);
    uint8_t sublayer =
        (uint8_t)DP_text_reader_get_ulong(reader, "sublayer", UINT8_MAX);
    uint16_t col =
        (uint16_t)DP_text_reader_get_ulong(reader, "col", UINT16_MAX);
    uint16_t row =
        (uint16_t)DP_text_reader_get_ulong(reader, "row", UINT16_MAX);
    uint16_t repeat =
        (uint16_t)DP_text_reader_get_ulong(reader, "repeat", UINT16_MAX);
    size_t image_size;
    DP_TextReaderParseParams image_params =
        DP_text_reader_get_base64_string(reader, "image", &image_size);
    return DP_msg_put_tile_zstd_new(context_id, user, layer, sublayer, col, row,
                                    repeat, DP_text_reader_parse_base64,
                                    image_size, &image_params);
}

DP_MsgPutTile *DP_msg_put_tile_zstd_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_PUT_TILE_ZSTD);
}


/* DP_MSG_CANVAS_BACKGROUND_ZSTD */

DP_Message *DP_msg_canvas_background_zstd_new(
    unsigned int context_id, void (*set_image)(size_t, unsigned char *, void *),
    size_t image_size, void *image_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_CANVAS_BACKGROUND_ZSTD, context_id,
        &msg_canvas_background_methods,
        DP_FLEX_SIZEOF(DP_MsgCanvasBackground, image, image_size));
    DP_MsgCanvasBackground *mcbz = DP_message_internal(msg);
    mcbz->image_size = DP_size_to_uint16(image_size);
    if (set_image) {
        set_image(mcbz->image_size, mcbz->image, image_user);
    }
    return msg;
}

DP_Message *DP_msg_canvas_background_zstd_deserialize(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length > 65535) {
        DP_error_set("Wrong length for canvasbackgroundzstd message; "
                     "expected between 0 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    size_t image_bytes = length - read;
    uint16_t image_size = DP_size_to_uint16(image_bytes);
    void *image_user = (void *)(buffer + read);
    return DP_msg_canvas_background_zstd_new(context_id, read_bytes, image_size,
                                             image_user);
}

DP_Message *DP_msg_canvas_background_zstd_parse(unsigned int context_id,
                                                DP_TextReader *reader)
{
    size_t image_size;
    DP_TextReaderParseParams image_params =
        DP_text_reader_get_base64_string(reader, "image", &image_size);
    return DP_msg_canvas_background_zstd_new(
        context_id, DP_text_reader_parse_base64, image_size, &image_params);
}

DP_MsgCanvasBackground *DP_msg_canvas_background_zstd_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_CANVAS_BACKGROUND_ZSTD);
}


/* DP_MSG_MOVE_RECT_ZSTD */

DP_Message *DP_msg_move_rect_zstd_new(
    unsigned int context_id, uint32_t layer, uint32_t source, int32_t sx,
    int32_t sy, int32_t tx, int32_t ty, int32_t w, int32_t h, uint8_t blend,
    uint8_t opacity, void (*set_mask)(size_t, unsigned char *, void *),
    size_t mask_size, void *mask_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_MOVE_RECT_ZSTD, context_id, &msg_move_rect_methods,
        DP_FLEX_SIZEOF(DP_MsgMoveRect, mask, mask_size));
    DP_MsgMoveRect *mmrz = DP_message_internal(msg);
    mmrz->layer = layer;
    mmrz->source = source;
    mmrz->sx = sx;
    mmrz->sy = sy;
    mmrz->tx = tx;
    mmrz->ty = ty;
    mmrz->w = w;
    mmrz->h = h;
    mmrz->blend = blend;
    mmrz->opacity = opacity;
    mmrz->mask_size = DP_size_to_uint16(mask_size);
    if (set_mask) {
        set_mask(mmrz->mask_size, mmrz->mask, mask_user);
    }
    return msg;
}

DP_Message *DP_msg_move_rect_zstd_deserialize(unsigned int context_id,
                                              const unsigned char *buffer,
                                              size_t length)
{
    if (length < 32 || length > 65535) {
        DP_error_set("Wrong length for moverectzstd message; "
                     "expected between 32 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint32_t layer = read_uint24(buffer + read, &read);
    uint32_t source = read_uint24(buffer + read, &read);
    int32_t sx = read_int32(buffer + read, &read);
    int32_t sy = read_int32(buffer + read, &read);
    int32_t tx = read_int32(buffer + read, &read);
    int32_t ty = read_int32(buffer + read, &read);
    int32_t w = read_int32(buffer + read, &read);
    int32_t h = read_int32(buffer + read, &read);
    uint8_t blend = read_uint8(buffer + read, &read);
    uint8_t opacity = read_uint8(buffer + read, &read);
    size_t mask_bytes = length - read;
    uint16_t mask_size = DP_size_to_uint16(mask_bytes);
    void *mask_user = (void *)(buffer + read);
    return DP_msg_move_rect_zstd_new(context_id, layer, source, sx, sy, tx, ty,
                                     w, h, blend, opacity, read_bytes,
                                     mask_size, mask_user);
}

DP_Message *DP_msg_move_rect_zstd_parse(unsigned int context_id,
                                        DP_TextReader *reader)
{
    uint32_t layer =
        (uint32_t)DP_text_reader_get_ulong(reader, "layer", DP_UINT24_MAX);
    uint32_t source =
        (uint32_t)DP_text_reader_get_ulong(reader, "source", DP_UINT24_MAX);
    int32_t sx =
        (int32_t)DP_text_reader_get_long(reader, "sx", INT32_MIN, INT32_MAX);
    int32_t sy =
        (int32_t)DP_text_reader_get_long(reader, "sy", INT32_MIN, INT32_MAX);
    int32_t tx =
        (int32_t)DP_text_reader_get_long(reader, "tx", INT32_MIN, INT32_MAX);
    int32_t ty =
        (int32_t)DP_text_reader_get_long(reader, "ty", INT32_MIN, INT32_MAX);
    int32_t w =
        (int32_t)DP_text_reader_get_long(reader, "w", INT32_MIN, INT32_MAX);
    int32_t h =
        (int32_t)DP_text_reader_get_long(reader, "h", INT32_MIN, INT32_MAX);
    uint8_t blend = DP_text_reader_get_blend_mode(reader, "blend");
    uint8_t opacity =
        (uint8_t)DP_text_reader_get_ulong(reader, "opacity", UINT8_MAX);
    size_t mask_size;
    DP_TextReaderParseParams mask_params =
        DP_text_reader_get_base64_string(reader, "mask", &mask_size);
    return DP_msg_move_rect_zstd_new(
        context_id, layer, source, sx, sy, tx, ty, w, h, blend, opacity,
        DP_text_reader_parse_base64, mask_size, &mask_params);
}

DP_MsgMoveRect *DP_msg_move_rect_zstd_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_MOVE_RECT_ZSTD);
}


/* DP_MSG_TRANSFORM_REGION_ZSTD */

DP_Message *DP_msg_transform_region_zstd_new(
    unsigned int context_id, uint32_t layer, uint32_t source, int32_t bx,
    int32_t by, int32_t bw, int32_t bh, int32_t x1, int32_t y1, int32_t x2,
    int32_t y2, int32_t x3, int32_t y3, int32_t x4, int32_t y4, uint8_t mode,
    uint8_t blend, uint8_t opacity,
    void (*set_mask)(size_t, unsigned char *, void *), size_t mask_size,
    void *mask_user)
{
    DP_Message *msg = DP_message_new(
        DP_MSG_TRANSFORM_REGION_ZSTD, context_id, &msg_transform_region_methods,
        DP_FLEX_SIZEOF(DP_MsgTransformRegion, mask, mask_size));
    DP_MsgTransformRegion *mtrz = DP_message_internal(msg);
    mtrz->layer = layer;
    mtrz->source = source;
    mtrz->bx = bx;
    mtrz->by = by;
    mtrz->bw = bw;
    mtrz->bh = bh;
    mtrz->x1 = x1;
    mtrz->y1 = y1;
    mtrz->x2 = x2;
    mtrz->y2 = y2;
    mtrz->x3 = x3;
    mtrz->y3 = y3;
    mtrz->x4 = x4;
    mtrz->y4 = y4;
    mtrz->mode = mode;
    mtrz->blend = blend;
    mtrz->opacity = opacity;
    mtrz->mask_size = DP_size_to_uint16(mask_size);
    if (set_mask) {
        set_mask(mtrz->mask_size, mtrz->mask, mask_user);
    }
    return msg;
}

DP_Message *DP_msg_transform_region_zstd_deserialize(
    unsigned int context_id, const unsigned char *buffer, size_t length)
{
    if (length < 57 || length > 65535) {
        DP_error_set("Wrong length for transformregionzstd message; "
                     "expected between 57 and 65535, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint32_t layer = read_uint24(buffer + read, &read);
    uint32_t source = read_uint24(buffer + read, &read);
    int32_t bx = read_int32(buffer + read, &read);
    int32_t by = read_int32(buffer + read, &read);
    int32_t bw = read_int32(buffer + read, &read);
    int32_t bh = read_int32(buffer + read, &read);
    int32_t x1 = read_int32(buffer + read, &read);
    int32_t y1 = read_int32(buffer + read, &read);
    int32_t x2 = read_int32(buffer + read, &read);
    int32_t y2 = read_int32(buffer + read, &read);
    int32_t x3 = read_int32(buffer + read, &read);
    int32_t y3 = read_int32(buffer + read, &read);
    int32_t x4 = read_int32(buffer + read, &read);
    int32_t y4 = read_int32(buffer + read, &read);
    uint8_t mode = read_uint8(buffer + read, &read);
    uint8_t blend = read_uint8(buffer + read, &read);
    uint8_t opacity = read_uint8(buffer + read, &read);
    size_t mask_bytes = length - read;
    uint16_t mask_size = DP_size_to_uint16(mask_bytes);
    void *mask_user = (void *)(buffer + read);
    return DP_msg_transform_region_zstd_new(
        context_id, layer, source, bx, by, bw, bh, x1, y1, x2, y2, x3, y3, x4,
        y4, mode, blend, opacity, read_bytes, mask_size, mask_user);
}

DP_Message *DP_msg_transform_region_zstd_parse(unsigned int context_id,
                                               DP_TextReader *reader)
{
    uint32_t layer =
        (uint32_t)DP_text_reader_get_ulong(reader, "layer", DP_UINT24_MAX);
    uint32_t source =
        (uint32_t)DP_text_reader_get_ulong(reader, "source", DP_UINT24_MAX);
    int32_t bx =
        (int32_t)DP_text_reader_get_long(reader, "bx", INT32_MIN, INT32_MAX);
    int32_t by =
        (int32_t)DP_text_reader_get_long(reader, "by", INT32_MIN, INT32_MAX);
    int32_t bw =
        (int32_t)DP_text_reader_get_long(reader, "bw", INT32_MIN, INT32_MAX);
    int32_t bh =
        (int32_t)DP_text_reader_get_long(reader, "bh", INT32_MIN, INT32_MAX);
    int32_t x1 =
        (int32_t)DP_text_reader_get_long(reader, "x1", INT32_MIN, INT32_MAX);
    int32_t y1 =
        (int32_t)DP_text_reader_get_long(reader, "y1", INT32_MIN, INT32_MAX);
    int32_t x2 =
        (int32_t)DP_text_reader_get_long(reader, "x2", INT32_MIN, INT32_MAX);
    int32_t y2 =
        (int32_t)DP_text_reader_get_long(reader, "y2", INT32_MIN, INT32_MAX);
    int32_t x3 =
        (int32_t)DP_text_reader_get_long(reader, "x3", INT32_MIN, INT32_MAX);
    int32_t y3 =
        (int32_t)DP_text_reader_get_long(reader, "y3", INT32_MIN, INT32_MAX);
    int32_t x4 =
        (int32_t)DP_text_reader_get_long(reader, "x4", INT32_MIN, INT32_MAX);
    int32_t y4 =
        (int32_t)DP_text_reader_get_long(reader, "y4", INT32_MIN, INT32_MAX);
    uint8_t mode = (uint8_t)DP_text_reader_get_ulong(reader, "mode", UINT8_MAX);
    uint8_t blend = DP_text_reader_get_blend_mode(reader, "blend");
    uint8_t opacity =
        (uint8_t)DP_text_reader_get_ulong(reader, "opacity", UINT8_MAX);
    size_t mask_size;
    DP_TextReaderParseParams mask_params =
        DP_text_reader_get_base64_string(reader, "mask", &mask_size);
    return DP_msg_transform_region_zstd_new(
        context_id, layer, source, bx, by, bw, bh, x1, y1, x2, y2, x3, y3, x4,
        y4, mode, blend, opacity, DP_text_reader_parse_base64, mask_size,
        &mask_params);
}

DP_MsgTransformRegion *DP_msg_transform_region_zstd_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_TRANSFORM_REGION_ZSTD);
}


/* DP_MSG_UNDO */

struct DP_MsgUndo {
    uint8_t override_user;
    bool redo;
};

static size_t msg_undo_payload_length(DP_UNUSED DP_Message *msg)
{
    return ((size_t)2);
}

static size_t msg_undo_serialize_payload(DP_Message *msg, unsigned char *data)
{
    DP_MsgUndo *mu = DP_message_internal(msg);
    size_t written = 0;
    written += DP_write_bigendian_uint8(mu->override_user, data + written);
    written += DP_write_bigendian_uint8(mu->redo, data + written);
    DP_ASSERT(written == msg_undo_payload_length(msg));
    return written;
}

static bool msg_undo_write_payload_text(DP_Message *msg, DP_TextWriter *writer)
{
    DP_MsgUndo *mu = DP_message_internal(msg);
    return DP_text_writer_write_uint(writer, "override_user", mu->override_user)
        && DP_text_writer_write_bool(writer, "redo", mu->redo);
}

static bool msg_undo_equals(DP_Message *DP_RESTRICT msg,
                            DP_Message *DP_RESTRICT other)
{
    DP_MsgUndo *a = DP_message_internal(msg);
    DP_MsgUndo *b = DP_message_internal(other);
    return a->override_user == b->override_user && a->redo == b->redo;
}

static const DP_MessageMethods msg_undo_methods = {
    msg_undo_payload_length,     msg_undo_serialize_payload,
    msg_undo_payload_length,     msg_undo_serialize_payload,
    msg_undo_write_payload_text, msg_undo_equals,
};

DP_Message *DP_msg_undo_new(unsigned int context_id, uint8_t override_user,
                            bool redo)
{
    DP_Message *msg = DP_message_new(DP_MSG_UNDO, context_id, &msg_undo_methods,
                                     sizeof(DP_MsgUndo));
    DP_MsgUndo *mu = DP_message_internal(msg);
    mu->override_user = override_user;
    mu->redo = redo;
    return msg;
}

DP_Message *DP_msg_undo_deserialize(unsigned int context_id,
                                    const unsigned char *buffer, size_t length)
{
    if (length != 2) {
        DP_error_set("Wrong length for undo message; "
                     "expected 2, got %zu",
                     length);
        return NULL;
    }
    size_t read = 0;
    uint8_t override_user = read_uint8(buffer + read, &read);
    bool redo = read_bool(buffer + read, &read);
    return DP_msg_undo_new(context_id, override_user, redo);
}

DP_Message *DP_msg_undo_deserialize_compat(unsigned int context_id,
                                           const unsigned char *buffer,
                                           size_t length)
{
    DP_Message *msg = DP_msg_undo_deserialize(context_id, buffer, length);
    DP_message_compat_set(msg);
    return msg;
}

DP_Message *DP_msg_undo_parse(unsigned int context_id, DP_TextReader *reader)
{
    uint8_t override_user =
        (uint8_t)DP_text_reader_get_ulong(reader, "override_user", UINT8_MAX);
    bool redo = DP_text_reader_get_bool(reader, "redo");
    return DP_msg_undo_new(context_id, override_user, redo);
}

DP_MsgUndo *DP_msg_undo_cast(DP_Message *msg)
{
    return DP_message_cast(msg, DP_MSG_UNDO);
}

uint8_t DP_msg_undo_override_user(const DP_MsgUndo *mu)
{
    DP_ASSERT(mu);
    return mu->override_user;
}

bool DP_msg_undo_redo(const DP_MsgUndo *mu)
{
    DP_ASSERT(mu);
    return mu->redo;
}


static bool local_layer_id(uint32_t layer_id)
{
    return DP_layer_id_local(DP_protocol_to_layer_id(layer_id));
}

static bool local_selection_id(uint8_t selection_id)
{
    return DP_selection_id_local(selection_id);
}

static DP_Message *make_local_match(bool disguise_as_put_image, uint8_t type,
                                    unsigned int context_id,
                                    DP_MessageLocalMatchSetFn set, size_t size,
                                    void *user)
{
    if (disguise_as_put_image) {
        return DP_msg_put_image_new(context_id, type,
                                    DP_BLEND_MODE_COMPAT_LOCAL_MATCH, 0, 0, 0,
                                    0, set, size, user);
    }
    else {
        return DP_msg_local_match_new(context_id, type, set, size, user);
    }
}

DP_Message *DP_msg_local_match_make(DP_Message *msg, bool disguise_as_put_image)
{
    DP_ASSERT(msg);
    DP_MessageType type = DP_message_type(msg);
    switch (type) {
    case DP_MSG_PUT_IMAGE:
    case DP_MSG_PUT_IMAGE_ZSTD: {
        DP_MsgPutImage *mpi = DP_message_internal(msg);
        if (local_layer_id(mpi->layer)) {
            return make_local_match(disguise_as_put_image, (uint8_t)type,
                                    DP_message_context_id(msg),
                                    DP_msg_put_image_local_match_set,
                                    DP_MSG_PUT_IMAGE_MATCH_LENGTH, mpi);
            break;
        }
        else {
            return NULL;
        }
    }
    case DP_MSG_FILL_RECT: {
        DP_MsgFillRect *mfr = DP_message_internal(msg);
        if (local_layer_id(mfr->layer)) {
            return make_local_match(disguise_as_put_image, (uint8_t)type,
                                    DP_message_context_id(msg),
                                    DP_msg_fill_rect_local_match_set,
                                    DP_MSG_FILL_RECT_MATCH_LENGTH, mfr);
            break;
        }
        else {
            return NULL;
        }
    }
    case DP_MSG_DRAW_DABS_CLASSIC: {
        DP_MsgDrawDabsClassic *mddc = DP_message_internal(msg);
        if (local_layer_id(mddc->layer)) {
            return make_local_match(disguise_as_put_image, (uint8_t)type,
                                    DP_message_context_id(msg),
                                    DP_msg_draw_dabs_classic_local_match_set,
                                    DP_MSG_DRAW_DABS_CLASSIC_MATCH_LENGTH,
                                    mddc);
            break;
        }
        else {
            return NULL;
        }
    }
    case DP_MSG_DRAW_DABS_PIXEL:
    case DP_MSG_DRAW_DABS_PIXEL_SQUARE: {
        DP_MsgDrawDabsPixel *mddp = DP_message_internal(msg);
        if (local_layer_id(mddp->layer)) {
            return make_local_match(disguise_as_put_image, (uint8_t)type,
                                    DP_message_context_id(msg),
                                    DP_msg_draw_dabs_pixel_local_match_set,
                                    DP_MSG_DRAW_DABS_PIXEL_MATCH_LENGTH, mddp);
            break;
        }
        else {
            return NULL;
        }
    }
    case DP_MSG_DRAW_DABS_MYPAINT: {
        DP_MsgDrawDabsMyPaint *mddmp = DP_message_internal(msg);
        if (local_layer_id(mddmp->layer)) {
            return make_local_match(disguise_as_put_image, (uint8_t)type,
                                    DP_message_context_id(msg),
                                    DP_msg_draw_dabs_mypaint_local_match_set,
                                    DP_MSG_DRAW_DABS_MYPAINT_MATCH_LENGTH,
                                    mddmp);
            break;
        }
        else {
            return NULL;
        }
    }
    case DP_MSG_DRAW_DABS_MYPAINT_BLEND: {
        DP_MsgDrawDabsMyPaintBlend *mddmpb = DP_message_internal(msg);
        if (local_layer_id(mddmpb->layer)) {
            return make_local_match(
                disguise_as_put_image, (uint8_t)type,
                DP_message_context_id(msg),
                DP_msg_draw_dabs_mypaint_blend_local_match_set,
                DP_MSG_DRAW_DABS_MYPAINT_BLEND_MATCH_LENGTH, mddmpb);
            break;
        }
        else {
            return NULL;
        }
    }
    case DP_MSG_MOVE_RECT:
    case DP_MSG_MOVE_RECT_ZSTD: {
        DP_MsgMoveRect *mmr = DP_message_internal(msg);
        if (local_layer_id(mmr->layer) || local_layer_id(mmr->source)) {
            return make_local_match(disguise_as_put_image, (uint8_t)type,
                                    DP_message_context_id(msg),
                                    DP_msg_move_rect_local_match_set,
                                    DP_MSG_MOVE_RECT_MATCH_LENGTH, mmr);
            break;
        }
        else {
            return NULL;
        }
    }
    case DP_MSG_TRANSFORM_REGION:
    case DP_MSG_TRANSFORM_REGION_ZSTD: {
        DP_MsgTransformRegion *mtr = DP_message_internal(msg);
        if (local_layer_id(mtr->layer) || local_layer_id(mtr->source)) {
            return make_local_match(disguise_as_put_image, (uint8_t)type,
                                    DP_message_context_id(msg),
                                    DP_msg_transform_region_local_match_set,
                                    DP_MSG_TRANSFORM_REGION_MATCH_LENGTH, mtr);
            break;
        }
        else {
            return NULL;
        }
    }
    case DP_MSG_SELECTION_PUT: {
        DP_MsgSelectionPut *msp = DP_message_internal(msg);
        if (local_selection_id(msp->selection_id)) {
            return make_local_match(disguise_as_put_image, (uint8_t)type,
                                    DP_message_context_id(msg),
                                    DP_msg_selection_put_local_match_set,
                                    DP_MSG_SELECTION_PUT_MATCH_LENGTH, msp);
            break;
        }
        else {
            return NULL;
        }
    }
    case DP_MSG_SELECTION_CLEAR: {
        DP_MsgSelectionClear *msc = DP_message_internal(msg);
        if (local_selection_id(msc->selection_id)) {
            return make_local_match(disguise_as_put_image, (uint8_t)type,
                                    DP_message_context_id(msg),
                                    DP_msg_selection_clear_local_match_set,
                                    DP_MSG_SELECTION_CLEAR_MATCH_LENGTH, msc);
            break;
        }
        else {
            return NULL;
        }
    }
    default:
        return NULL;
    }
}

bool DP_msg_local_match_is_local_match(DP_Message *msg)
{
    switch (DP_message_type(msg)) {
    case DP_MSG_LOCAL_MATCH:
        return true;
    case DP_MSG_PUT_IMAGE:
        return DP_msg_put_image_mode(DP_message_internal(msg))
            == DP_BLEND_MODE_COMPAT_LOCAL_MATCH;
    default:
        return false;
    }
}

bool DP_msg_local_match_matches(DP_Message *msg, DP_Message *local_match_msg)
{
    DP_ASSERT(msg);
    DP_MessageType type = DP_message_type(msg);
    switch (type) {
    case DP_MSG_PUT_IMAGE:
    case DP_MSG_PUT_IMAGE_ZSTD: {
        DP_MsgPutImage *mpi = DP_message_internal(msg);
        return (local_layer_id(mpi->layer))
            && DP_msg_put_image_local_match_matches(mpi, local_match_msg);
    }
    case DP_MSG_FILL_RECT: {
        DP_MsgFillRect *mfr = DP_message_internal(msg);
        return (local_layer_id(mfr->layer))
            && DP_msg_fill_rect_local_match_matches(mfr, local_match_msg);
    }
    case DP_MSG_DRAW_DABS_CLASSIC: {
        DP_MsgDrawDabsClassic *mddc = DP_message_internal(msg);
        return (local_layer_id(mddc->layer))
            && DP_msg_draw_dabs_classic_local_match_matches(mddc,
                                                            local_match_msg);
    }
    case DP_MSG_DRAW_DABS_PIXEL:
    case DP_MSG_DRAW_DABS_PIXEL_SQUARE: {
        DP_MsgDrawDabsPixel *mddp = DP_message_internal(msg);
        return (local_layer_id(mddp->layer))
            && DP_msg_draw_dabs_pixel_local_match_matches(mddp,
                                                          local_match_msg);
    }
    case DP_MSG_DRAW_DABS_MYPAINT: {
        DP_MsgDrawDabsMyPaint *mddmp = DP_message_internal(msg);
        return (local_layer_id(mddmp->layer))
            && DP_msg_draw_dabs_mypaint_local_match_matches(mddmp,
                                                            local_match_msg);
    }
    case DP_MSG_DRAW_DABS_MYPAINT_BLEND: {
        DP_MsgDrawDabsMyPaintBlend *mddmpb = DP_message_internal(msg);
        return (local_layer_id(mddmpb->layer))
            && DP_msg_draw_dabs_mypaint_blend_local_match_matches(
                   mddmpb, local_match_msg);
    }
    case DP_MSG_MOVE_RECT:
    case DP_MSG_MOVE_RECT_ZSTD: {
        DP_MsgMoveRect *mmr = DP_message_internal(msg);
        return (local_layer_id(mmr->layer) || local_layer_id(mmr->source))
            && DP_msg_move_rect_local_match_matches(mmr, local_match_msg);
    }
    case DP_MSG_TRANSFORM_REGION:
    case DP_MSG_TRANSFORM_REGION_ZSTD: {
        DP_MsgTransformRegion *mtr = DP_message_internal(msg);
        return (local_layer_id(mtr->layer) || local_layer_id(mtr->source))
            && DP_msg_transform_region_local_match_matches(mtr,
                                                           local_match_msg);
    }
    case DP_MSG_SELECTION_PUT: {
        DP_MsgSelectionPut *msp = DP_message_internal(msg);
        return (local_selection_id(msp->selection_id))
            && DP_msg_selection_put_local_match_matches(msp, local_match_msg);
    }
    case DP_MSG_SELECTION_CLEAR: {
        DP_MsgSelectionClear *msc = DP_message_internal(msg);
        return (local_selection_id(msc->selection_id))
            && DP_msg_selection_clear_local_match_matches(msc, local_match_msg);
    }
    default:
        return false;
    }
}
