// Copyright 2011-2020, Molecular Matters GmbH <office@molecular-matters.com>
// See LICENSE.txt for licensing details (2-clause BSD License: https://opensource.org/licenses/BSD-2-Clause)

#include "PsdPch.h"
#include "PsdFile.h"
#include "PsdAssert.h"


PSD_NAMESPACE_BEGIN

// ---------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------
File::File(Allocator* allocator)
	: m_allocator(allocator)
{
	PSD_ASSERT_NOT_NULL(allocator);
}


// ---------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------
File::~File(void)
{
}


// ---------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------
bool File::OpenRead(void* user)
{
	return DoOpenRead(user);
}


// ---------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------
bool File::Close(void)
{
	return DoClose();
}


// ---------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------
File::ReadOperation File::Read(void* buffer, uint32_t count, uint64_t position)
{
	PSD_ASSERT_NOT_NULL(buffer);

	return DoRead(buffer, count, position);
}


// ---------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------
bool File::WaitForRead(File::ReadOperation& operation)
{
	return DoWaitForRead(operation);
}


// ---------------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------------
uint64_t File::GetSize(void) const
{
	return DoGetSize();
}

PSD_NAMESPACE_END
