// SPDX-License-Identifier: GPL-3.0-or-later
// This file is generated by parse-emoji.py, don't edit it manually!
// It is based on emoji-sequences.txt and emoji-zwj-sequences.txt.
#include <QString>

namespace htmlutils {

static bool emojiMatch1(const QString &input, int offset)
{
	int state = 0;
	while(true) {
		switch(state) {
		case 0:
			switch(input[offset + 0].unicode()) {
			case 0x231au:
			case 0x231bu:
			case 0x23e9u:
			case 0x23eau:
			case 0x23ebu:
			case 0x23ecu:
			case 0x23f0u:
			case 0x23f3u:
			case 0x25fdu:
			case 0x25feu:
			case 0x2614u:
			case 0x2615u:
			case 0x2648u:
			case 0x2649u:
			case 0x264au:
			case 0x264bu:
			case 0x264cu:
			case 0x264du:
			case 0x264eu:
			case 0x264fu:
			case 0x2650u:
			case 0x2651u:
			case 0x2652u:
			case 0x2653u:
			case 0x267fu:
			case 0x2693u:
			case 0x26a1u:
			case 0x26aau:
			case 0x26abu:
			case 0x26bdu:
			case 0x26beu:
			case 0x26c4u:
			case 0x26c5u:
			case 0x26ceu:
			case 0x26d4u:
			case 0x26eau:
			case 0x26f2u:
			case 0x26f3u:
			case 0x26f5u:
			case 0x26fau:
			case 0x26fdu:
			case 0x2705u:
			case 0x270au:
			case 0x270bu:
			case 0x2728u:
			case 0x274cu:
			case 0x274eu:
			case 0x2753u:
			case 0x2754u:
			case 0x2755u:
			case 0x2757u:
			case 0x2795u:
			case 0x2796u:
			case 0x2797u:
			case 0x27b0u:
			case 0x27bfu:
			case 0x2b1bu:
			case 0x2b1cu:
			case 0x2b50u:
			case 0x2b55u:
				return true;
			default:
				return false;
			}
		default:
			Q_ASSERT_X(false, "emojiMatch1", "Invalid state");
			return false;
		}
	}
}

static bool emojiMatch2(const QString &input, int offset)
{
	int state = 0;
	while(true) {
		switch(state) {
		case 0:
			switch(input[offset + 0].unicode()) {
			case 0x00a9u:
				state = 1;
				continue;
			case 0x00aeu:
				state = 2;
				continue;
			case 0x203cu:
				state = 3;
				continue;
			case 0x2049u:
				state = 4;
				continue;
			case 0x2122u:
				state = 5;
				continue;
			case 0x2139u:
				state = 6;
				continue;
			case 0x2194u:
				state = 7;
				continue;
			case 0x2195u:
				state = 8;
				continue;
			case 0x2196u:
				state = 9;
				continue;
			case 0x2197u:
				state = 10;
				continue;
			case 0x2198u:
				state = 11;
				continue;
			case 0x2199u:
				state = 12;
				continue;
			case 0x21a9u:
				state = 13;
				continue;
			case 0x21aau:
				state = 14;
				continue;
			case 0x2328u:
				state = 15;
				continue;
			case 0x23cfu:
				state = 16;
				continue;
			case 0x23edu:
				state = 17;
				continue;
			case 0x23eeu:
				state = 18;
				continue;
			case 0x23efu:
				state = 19;
				continue;
			case 0x23f1u:
				state = 20;
				continue;
			case 0x23f2u:
				state = 21;
				continue;
			case 0x23f8u:
				state = 22;
				continue;
			case 0x23f9u:
				state = 23;
				continue;
			case 0x23fau:
				state = 24;
				continue;
			case 0x24c2u:
				state = 25;
				continue;
			case 0x25aau:
				state = 26;
				continue;
			case 0x25abu:
				state = 27;
				continue;
			case 0x25b6u:
				state = 28;
				continue;
			case 0x25c0u:
				state = 29;
				continue;
			case 0x25fbu:
				state = 30;
				continue;
			case 0x25fcu:
				state = 31;
				continue;
			case 0x2600u:
				state = 32;
				continue;
			case 0x2601u:
				state = 33;
				continue;
			case 0x2602u:
				state = 34;
				continue;
			case 0x2603u:
				state = 35;
				continue;
			case 0x2604u:
				state = 36;
				continue;
			case 0x260eu:
				state = 37;
				continue;
			case 0x2611u:
				state = 38;
				continue;
			case 0x2618u:
				state = 39;
				continue;
			case 0x261du:
				state = 40;
				continue;
			case 0x2620u:
				state = 41;
				continue;
			case 0x2622u:
				state = 42;
				continue;
			case 0x2623u:
				state = 43;
				continue;
			case 0x2626u:
				state = 44;
				continue;
			case 0x262au:
				state = 45;
				continue;
			case 0x262eu:
				state = 46;
				continue;
			case 0x262fu:
				state = 47;
				continue;
			case 0x2638u:
				state = 48;
				continue;
			case 0x2639u:
				state = 49;
				continue;
			case 0x263au:
				state = 50;
				continue;
			case 0x2640u:
				state = 51;
				continue;
			case 0x2642u:
				state = 52;
				continue;
			case 0x265fu:
				state = 53;
				continue;
			case 0x2660u:
				state = 54;
				continue;
			case 0x2663u:
				state = 55;
				continue;
			case 0x2665u:
				state = 56;
				continue;
			case 0x2666u:
				state = 57;
				continue;
			case 0x2668u:
				state = 58;
				continue;
			case 0x267bu:
				state = 59;
				continue;
			case 0x267eu:
				state = 60;
				continue;
			case 0x2692u:
				state = 61;
				continue;
			case 0x2694u:
				state = 62;
				continue;
			case 0x2695u:
				state = 63;
				continue;
			case 0x2696u:
				state = 64;
				continue;
			case 0x2697u:
				state = 65;
				continue;
			case 0x2699u:
				state = 66;
				continue;
			case 0x269bu:
				state = 67;
				continue;
			case 0x269cu:
				state = 68;
				continue;
			case 0x26a0u:
				state = 69;
				continue;
			case 0x26a7u:
				state = 70;
				continue;
			case 0x26b0u:
				state = 71;
				continue;
			case 0x26b1u:
				state = 72;
				continue;
			case 0x26c8u:
				state = 73;
				continue;
			case 0x26cfu:
				state = 74;
				continue;
			case 0x26d1u:
				state = 75;
				continue;
			case 0x26d3u:
				state = 76;
				continue;
			case 0x26e9u:
				state = 77;
				continue;
			case 0x26f0u:
				state = 78;
				continue;
			case 0x26f1u:
				state = 79;
				continue;
			case 0x26f4u:
				state = 80;
				continue;
			case 0x26f7u:
				state = 81;
				continue;
			case 0x26f8u:
				state = 82;
				continue;
			case 0x26f9u:
				state = 83;
				continue;
			case 0x2702u:
				state = 84;
				continue;
			case 0x2708u:
				state = 85;
				continue;
			case 0x2709u:
				state = 86;
				continue;
			case 0x270cu:
				state = 87;
				continue;
			case 0x270du:
				state = 88;
				continue;
			case 0x270fu:
				state = 89;
				continue;
			case 0x2712u:
				state = 90;
				continue;
			case 0x2714u:
				state = 91;
				continue;
			case 0x2716u:
				state = 92;
				continue;
			case 0x271du:
				state = 93;
				continue;
			case 0x2721u:
				state = 94;
				continue;
			case 0x2733u:
				state = 95;
				continue;
			case 0x2734u:
				state = 96;
				continue;
			case 0x2744u:
				state = 97;
				continue;
			case 0x2747u:
				state = 98;
				continue;
			case 0x2763u:
				state = 99;
				continue;
			case 0x2764u:
				state = 100;
				continue;
			case 0x27a1u:
				state = 101;
				continue;
			case 0x2934u:
				state = 102;
				continue;
			case 0x2935u:
				state = 103;
				continue;
			case 0x2b05u:
				state = 104;
				continue;
			case 0x2b06u:
				state = 105;
				continue;
			case 0x2b07u:
				state = 106;
				continue;
			case 0x3030u:
				state = 107;
				continue;
			case 0x303du:
				state = 108;
				continue;
			case 0x3297u:
				state = 109;
				continue;
			case 0x3299u:
				state = 110;
				continue;
			case 0xd83cu:
				state = 111;
				continue;
			case 0xd83du:
				state = 112;
				continue;
			case 0xd83eu:
				state = 113;
				continue;
			default:
				return false;
			}
		case 1:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 2:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 3:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 4:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 5:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 6:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 7:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 8:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 9:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 10:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 11:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 12:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 13:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 14:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 15:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 16:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 17:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 18:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 19:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 20:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 21:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 22:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 23:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 24:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 25:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 26:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 27:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 28:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 29:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 30:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 31:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 32:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 33:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 34:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 35:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 36:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 37:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 38:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 39:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 40:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 41:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 42:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 43:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 44:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 45:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 46:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 47:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 48:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 49:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 50:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 51:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 52:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 53:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 54:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 55:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 56:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 57:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 58:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 59:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 60:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 61:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 62:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 63:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 64:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 65:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 66:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 67:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 68:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 69:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 70:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 71:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 72:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 73:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 74:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 75:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 76:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 77:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 78:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 79:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 80:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 81:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 82:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 83:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 84:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 85:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 86:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 87:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 88:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 89:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 90:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 91:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 92:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 93:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 94:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 95:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 96:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 97:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 98:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 99:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 100:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 101:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 102:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 103:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 104:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 105:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 106:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 107:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 108:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 109:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 110:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 111:
			switch(input[offset + 1].unicode()) {
			case 0xdc04u:
			case 0xdccfu:
			case 0xdd8eu:
			case 0xdd91u:
			case 0xdd92u:
			case 0xdd93u:
			case 0xdd94u:
			case 0xdd95u:
			case 0xdd96u:
			case 0xdd97u:
			case 0xdd98u:
			case 0xdd99u:
			case 0xdd9au:
			case 0xde01u:
			case 0xde1au:
			case 0xde2fu:
			case 0xde32u:
			case 0xde33u:
			case 0xde34u:
			case 0xde35u:
			case 0xde36u:
			case 0xde38u:
			case 0xde39u:
			case 0xde3au:
			case 0xde50u:
			case 0xde51u:
			case 0xdf00u:
			case 0xdf01u:
			case 0xdf02u:
			case 0xdf03u:
			case 0xdf04u:
			case 0xdf05u:
			case 0xdf06u:
			case 0xdf07u:
			case 0xdf08u:
			case 0xdf09u:
			case 0xdf0au:
			case 0xdf0bu:
			case 0xdf0cu:
			case 0xdf0du:
			case 0xdf0eu:
			case 0xdf0fu:
			case 0xdf10u:
			case 0xdf11u:
			case 0xdf12u:
			case 0xdf13u:
			case 0xdf14u:
			case 0xdf15u:
			case 0xdf16u:
			case 0xdf17u:
			case 0xdf18u:
			case 0xdf19u:
			case 0xdf1au:
			case 0xdf1bu:
			case 0xdf1cu:
			case 0xdf1du:
			case 0xdf1eu:
			case 0xdf1fu:
			case 0xdf20u:
			case 0xdf2du:
			case 0xdf2eu:
			case 0xdf2fu:
			case 0xdf30u:
			case 0xdf31u:
			case 0xdf32u:
			case 0xdf33u:
			case 0xdf34u:
			case 0xdf35u:
			case 0xdf37u:
			case 0xdf38u:
			case 0xdf39u:
			case 0xdf3au:
			case 0xdf3bu:
			case 0xdf3cu:
			case 0xdf3du:
			case 0xdf3eu:
			case 0xdf3fu:
			case 0xdf40u:
			case 0xdf41u:
			case 0xdf42u:
			case 0xdf43u:
			case 0xdf44u:
			case 0xdf45u:
			case 0xdf46u:
			case 0xdf47u:
			case 0xdf48u:
			case 0xdf49u:
			case 0xdf4au:
			case 0xdf4bu:
			case 0xdf4cu:
			case 0xdf4du:
			case 0xdf4eu:
			case 0xdf4fu:
			case 0xdf50u:
			case 0xdf51u:
			case 0xdf52u:
			case 0xdf53u:
			case 0xdf54u:
			case 0xdf55u:
			case 0xdf56u:
			case 0xdf57u:
			case 0xdf58u:
			case 0xdf59u:
			case 0xdf5au:
			case 0xdf5bu:
			case 0xdf5cu:
			case 0xdf5du:
			case 0xdf5eu:
			case 0xdf5fu:
			case 0xdf60u:
			case 0xdf61u:
			case 0xdf62u:
			case 0xdf63u:
			case 0xdf64u:
			case 0xdf65u:
			case 0xdf66u:
			case 0xdf67u:
			case 0xdf68u:
			case 0xdf69u:
			case 0xdf6au:
			case 0xdf6bu:
			case 0xdf6cu:
			case 0xdf6du:
			case 0xdf6eu:
			case 0xdf6fu:
			case 0xdf70u:
			case 0xdf71u:
			case 0xdf72u:
			case 0xdf73u:
			case 0xdf74u:
			case 0xdf75u:
			case 0xdf76u:
			case 0xdf77u:
			case 0xdf78u:
			case 0xdf79u:
			case 0xdf7au:
			case 0xdf7bu:
			case 0xdf7cu:
			case 0xdf7eu:
			case 0xdf7fu:
			case 0xdf80u:
			case 0xdf81u:
			case 0xdf82u:
			case 0xdf83u:
			case 0xdf84u:
			case 0xdf85u:
			case 0xdf86u:
			case 0xdf87u:
			case 0xdf88u:
			case 0xdf89u:
			case 0xdf8au:
			case 0xdf8bu:
			case 0xdf8cu:
			case 0xdf8du:
			case 0xdf8eu:
			case 0xdf8fu:
			case 0xdf90u:
			case 0xdf91u:
			case 0xdf92u:
			case 0xdf93u:
			case 0xdfa0u:
			case 0xdfa1u:
			case 0xdfa2u:
			case 0xdfa3u:
			case 0xdfa4u:
			case 0xdfa5u:
			case 0xdfa6u:
			case 0xdfa7u:
			case 0xdfa8u:
			case 0xdfa9u:
			case 0xdfaau:
			case 0xdfabu:
			case 0xdfacu:
			case 0xdfadu:
			case 0xdfaeu:
			case 0xdfafu:
			case 0xdfb0u:
			case 0xdfb1u:
			case 0xdfb2u:
			case 0xdfb3u:
			case 0xdfb4u:
			case 0xdfb5u:
			case 0xdfb6u:
			case 0xdfb7u:
			case 0xdfb8u:
			case 0xdfb9u:
			case 0xdfbau:
			case 0xdfbbu:
			case 0xdfbcu:
			case 0xdfbdu:
			case 0xdfbeu:
			case 0xdfbfu:
			case 0xdfc0u:
			case 0xdfc1u:
			case 0xdfc2u:
			case 0xdfc3u:
			case 0xdfc4u:
			case 0xdfc5u:
			case 0xdfc6u:
			case 0xdfc7u:
			case 0xdfc8u:
			case 0xdfc9u:
			case 0xdfcau:
			case 0xdfcfu:
			case 0xdfd0u:
			case 0xdfd1u:
			case 0xdfd2u:
			case 0xdfd3u:
			case 0xdfe0u:
			case 0xdfe1u:
			case 0xdfe2u:
			case 0xdfe3u:
			case 0xdfe4u:
			case 0xdfe5u:
			case 0xdfe6u:
			case 0xdfe7u:
			case 0xdfe8u:
			case 0xdfe9u:
			case 0xdfeau:
			case 0xdfebu:
			case 0xdfecu:
			case 0xdfedu:
			case 0xdfeeu:
			case 0xdfefu:
			case 0xdff0u:
			case 0xdff4u:
			case 0xdff8u:
			case 0xdff9u:
			case 0xdffau:
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 112:
			switch(input[offset + 1].unicode()) {
			case 0xdc00u:
			case 0xdc01u:
			case 0xdc02u:
			case 0xdc03u:
			case 0xdc04u:
			case 0xdc05u:
			case 0xdc06u:
			case 0xdc07u:
			case 0xdc08u:
			case 0xdc09u:
			case 0xdc0au:
			case 0xdc0bu:
			case 0xdc0cu:
			case 0xdc0du:
			case 0xdc0eu:
			case 0xdc0fu:
			case 0xdc10u:
			case 0xdc11u:
			case 0xdc12u:
			case 0xdc13u:
			case 0xdc14u:
			case 0xdc15u:
			case 0xdc16u:
			case 0xdc17u:
			case 0xdc18u:
			case 0xdc19u:
			case 0xdc1au:
			case 0xdc1bu:
			case 0xdc1cu:
			case 0xdc1du:
			case 0xdc1eu:
			case 0xdc1fu:
			case 0xdc20u:
			case 0xdc21u:
			case 0xdc22u:
			case 0xdc23u:
			case 0xdc24u:
			case 0xdc25u:
			case 0xdc26u:
			case 0xdc27u:
			case 0xdc28u:
			case 0xdc29u:
			case 0xdc2au:
			case 0xdc2bu:
			case 0xdc2cu:
			case 0xdc2du:
			case 0xdc2eu:
			case 0xdc2fu:
			case 0xdc30u:
			case 0xdc31u:
			case 0xdc32u:
			case 0xdc33u:
			case 0xdc34u:
			case 0xdc35u:
			case 0xdc36u:
			case 0xdc37u:
			case 0xdc38u:
			case 0xdc39u:
			case 0xdc3au:
			case 0xdc3bu:
			case 0xdc3cu:
			case 0xdc3du:
			case 0xdc3eu:
			case 0xdc40u:
			case 0xdc42u:
			case 0xdc43u:
			case 0xdc44u:
			case 0xdc45u:
			case 0xdc46u:
			case 0xdc47u:
			case 0xdc48u:
			case 0xdc49u:
			case 0xdc4au:
			case 0xdc4bu:
			case 0xdc4cu:
			case 0xdc4du:
			case 0xdc4eu:
			case 0xdc4fu:
			case 0xdc50u:
			case 0xdc51u:
			case 0xdc52u:
			case 0xdc53u:
			case 0xdc54u:
			case 0xdc55u:
			case 0xdc56u:
			case 0xdc57u:
			case 0xdc58u:
			case 0xdc59u:
			case 0xdc5au:
			case 0xdc5bu:
			case 0xdc5cu:
			case 0xdc5du:
			case 0xdc5eu:
			case 0xdc5fu:
			case 0xdc60u:
			case 0xdc61u:
			case 0xdc62u:
			case 0xdc63u:
			case 0xdc64u:
			case 0xdc65u:
			case 0xdc66u:
			case 0xdc67u:
			case 0xdc68u:
			case 0xdc69u:
			case 0xdc6au:
			case 0xdc6bu:
			case 0xdc6cu:
			case 0xdc6du:
			case 0xdc6eu:
			case 0xdc6fu:
			case 0xdc70u:
			case 0xdc71u:
			case 0xdc72u:
			case 0xdc73u:
			case 0xdc74u:
			case 0xdc75u:
			case 0xdc76u:
			case 0xdc77u:
			case 0xdc78u:
			case 0xdc79u:
			case 0xdc7au:
			case 0xdc7bu:
			case 0xdc7cu:
			case 0xdc7du:
			case 0xdc7eu:
			case 0xdc7fu:
			case 0xdc80u:
			case 0xdc81u:
			case 0xdc82u:
			case 0xdc83u:
			case 0xdc84u:
			case 0xdc85u:
			case 0xdc86u:
			case 0xdc87u:
			case 0xdc88u:
			case 0xdc89u:
			case 0xdc8au:
			case 0xdc8bu:
			case 0xdc8cu:
			case 0xdc8du:
			case 0xdc8eu:
			case 0xdc8fu:
			case 0xdc90u:
			case 0xdc91u:
			case 0xdc92u:
			case 0xdc93u:
			case 0xdc94u:
			case 0xdc95u:
			case 0xdc96u:
			case 0xdc97u:
			case 0xdc98u:
			case 0xdc99u:
			case 0xdc9au:
			case 0xdc9bu:
			case 0xdc9cu:
			case 0xdc9du:
			case 0xdc9eu:
			case 0xdc9fu:
			case 0xdca0u:
			case 0xdca1u:
			case 0xdca2u:
			case 0xdca3u:
			case 0xdca4u:
			case 0xdca5u:
			case 0xdca6u:
			case 0xdca7u:
			case 0xdca8u:
			case 0xdca9u:
			case 0xdcaau:
			case 0xdcabu:
			case 0xdcacu:
			case 0xdcadu:
			case 0xdcaeu:
			case 0xdcafu:
			case 0xdcb0u:
			case 0xdcb1u:
			case 0xdcb2u:
			case 0xdcb3u:
			case 0xdcb4u:
			case 0xdcb5u:
			case 0xdcb6u:
			case 0xdcb7u:
			case 0xdcb8u:
			case 0xdcb9u:
			case 0xdcbau:
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdcbdu:
			case 0xdcbeu:
			case 0xdcbfu:
			case 0xdcc0u:
			case 0xdcc1u:
			case 0xdcc2u:
			case 0xdcc3u:
			case 0xdcc4u:
			case 0xdcc5u:
			case 0xdcc6u:
			case 0xdcc7u:
			case 0xdcc8u:
			case 0xdcc9u:
			case 0xdccau:
			case 0xdccbu:
			case 0xdcccu:
			case 0xdccdu:
			case 0xdcceu:
			case 0xdccfu:
			case 0xdcd0u:
			case 0xdcd1u:
			case 0xdcd2u:
			case 0xdcd3u:
			case 0xdcd4u:
			case 0xdcd5u:
			case 0xdcd6u:
			case 0xdcd7u:
			case 0xdcd8u:
			case 0xdcd9u:
			case 0xdcdau:
			case 0xdcdbu:
			case 0xdcdcu:
			case 0xdcddu:
			case 0xdcdeu:
			case 0xdcdfu:
			case 0xdce0u:
			case 0xdce1u:
			case 0xdce2u:
			case 0xdce3u:
			case 0xdce4u:
			case 0xdce5u:
			case 0xdce6u:
			case 0xdce7u:
			case 0xdce8u:
			case 0xdce9u:
			case 0xdceau:
			case 0xdcebu:
			case 0xdcecu:
			case 0xdcedu:
			case 0xdceeu:
			case 0xdcefu:
			case 0xdcf0u:
			case 0xdcf1u:
			case 0xdcf2u:
			case 0xdcf3u:
			case 0xdcf4u:
			case 0xdcf5u:
			case 0xdcf6u:
			case 0xdcf7u:
			case 0xdcf8u:
			case 0xdcf9u:
			case 0xdcfau:
			case 0xdcfbu:
			case 0xdcfcu:
			case 0xdcffu:
			case 0xdd00u:
			case 0xdd01u:
			case 0xdd02u:
			case 0xdd03u:
			case 0xdd04u:
			case 0xdd05u:
			case 0xdd06u:
			case 0xdd07u:
			case 0xdd08u:
			case 0xdd09u:
			case 0xdd0au:
			case 0xdd0bu:
			case 0xdd0cu:
			case 0xdd0du:
			case 0xdd0eu:
			case 0xdd0fu:
			case 0xdd10u:
			case 0xdd11u:
			case 0xdd12u:
			case 0xdd13u:
			case 0xdd14u:
			case 0xdd15u:
			case 0xdd16u:
			case 0xdd17u:
			case 0xdd18u:
			case 0xdd19u:
			case 0xdd1au:
			case 0xdd1bu:
			case 0xdd1cu:
			case 0xdd1du:
			case 0xdd1eu:
			case 0xdd1fu:
			case 0xdd20u:
			case 0xdd21u:
			case 0xdd22u:
			case 0xdd23u:
			case 0xdd24u:
			case 0xdd25u:
			case 0xdd26u:
			case 0xdd27u:
			case 0xdd28u:
			case 0xdd29u:
			case 0xdd2au:
			case 0xdd2bu:
			case 0xdd2cu:
			case 0xdd2du:
			case 0xdd2eu:
			case 0xdd2fu:
			case 0xdd30u:
			case 0xdd31u:
			case 0xdd32u:
			case 0xdd33u:
			case 0xdd34u:
			case 0xdd35u:
			case 0xdd36u:
			case 0xdd37u:
			case 0xdd38u:
			case 0xdd39u:
			case 0xdd3au:
			case 0xdd3bu:
			case 0xdd3cu:
			case 0xdd3du:
			case 0xdd4bu:
			case 0xdd4cu:
			case 0xdd4du:
			case 0xdd4eu:
			case 0xdd50u:
			case 0xdd51u:
			case 0xdd52u:
			case 0xdd53u:
			case 0xdd54u:
			case 0xdd55u:
			case 0xdd56u:
			case 0xdd57u:
			case 0xdd58u:
			case 0xdd59u:
			case 0xdd5au:
			case 0xdd5bu:
			case 0xdd5cu:
			case 0xdd5du:
			case 0xdd5eu:
			case 0xdd5fu:
			case 0xdd60u:
			case 0xdd61u:
			case 0xdd62u:
			case 0xdd63u:
			case 0xdd64u:
			case 0xdd65u:
			case 0xdd66u:
			case 0xdd67u:
			case 0xdd7au:
			case 0xdd95u:
			case 0xdd96u:
			case 0xdda4u:
			case 0xddfbu:
			case 0xddfcu:
			case 0xddfdu:
			case 0xddfeu:
			case 0xddffu:
			case 0xde00u:
			case 0xde01u:
			case 0xde02u:
			case 0xde03u:
			case 0xde04u:
			case 0xde05u:
			case 0xde06u:
			case 0xde07u:
			case 0xde08u:
			case 0xde09u:
			case 0xde0au:
			case 0xde0bu:
			case 0xde0cu:
			case 0xde0du:
			case 0xde0eu:
			case 0xde0fu:
			case 0xde10u:
			case 0xde11u:
			case 0xde12u:
			case 0xde13u:
			case 0xde14u:
			case 0xde15u:
			case 0xde16u:
			case 0xde17u:
			case 0xde18u:
			case 0xde19u:
			case 0xde1au:
			case 0xde1bu:
			case 0xde1cu:
			case 0xde1du:
			case 0xde1eu:
			case 0xde1fu:
			case 0xde20u:
			case 0xde21u:
			case 0xde22u:
			case 0xde23u:
			case 0xde24u:
			case 0xde25u:
			case 0xde26u:
			case 0xde27u:
			case 0xde28u:
			case 0xde29u:
			case 0xde2au:
			case 0xde2bu:
			case 0xde2cu:
			case 0xde2du:
			case 0xde2eu:
			case 0xde2fu:
			case 0xde30u:
			case 0xde31u:
			case 0xde32u:
			case 0xde33u:
			case 0xde34u:
			case 0xde35u:
			case 0xde36u:
			case 0xde37u:
			case 0xde38u:
			case 0xde39u:
			case 0xde3au:
			case 0xde3bu:
			case 0xde3cu:
			case 0xde3du:
			case 0xde3eu:
			case 0xde3fu:
			case 0xde40u:
			case 0xde41u:
			case 0xde42u:
			case 0xde43u:
			case 0xde44u:
			case 0xde45u:
			case 0xde46u:
			case 0xde47u:
			case 0xde48u:
			case 0xde49u:
			case 0xde4au:
			case 0xde4bu:
			case 0xde4cu:
			case 0xde4du:
			case 0xde4eu:
			case 0xde4fu:
			case 0xde80u:
			case 0xde81u:
			case 0xde82u:
			case 0xde83u:
			case 0xde84u:
			case 0xde85u:
			case 0xde86u:
			case 0xde87u:
			case 0xde88u:
			case 0xde89u:
			case 0xde8au:
			case 0xde8bu:
			case 0xde8cu:
			case 0xde8du:
			case 0xde8eu:
			case 0xde8fu:
			case 0xde90u:
			case 0xde91u:
			case 0xde92u:
			case 0xde93u:
			case 0xde94u:
			case 0xde95u:
			case 0xde96u:
			case 0xde97u:
			case 0xde98u:
			case 0xde99u:
			case 0xde9au:
			case 0xde9bu:
			case 0xde9cu:
			case 0xde9du:
			case 0xde9eu:
			case 0xde9fu:
			case 0xdea0u:
			case 0xdea1u:
			case 0xdea2u:
			case 0xdea3u:
			case 0xdea4u:
			case 0xdea5u:
			case 0xdea6u:
			case 0xdea7u:
			case 0xdea8u:
			case 0xdea9u:
			case 0xdeaau:
			case 0xdeabu:
			case 0xdeacu:
			case 0xdeadu:
			case 0xdeaeu:
			case 0xdeafu:
			case 0xdeb0u:
			case 0xdeb1u:
			case 0xdeb2u:
			case 0xdeb3u:
			case 0xdeb4u:
			case 0xdeb5u:
			case 0xdeb6u:
			case 0xdeb7u:
			case 0xdeb8u:
			case 0xdeb9u:
			case 0xdebau:
			case 0xdebbu:
			case 0xdebcu:
			case 0xdebdu:
			case 0xdebeu:
			case 0xdebfu:
			case 0xdec0u:
			case 0xdec1u:
			case 0xdec2u:
			case 0xdec3u:
			case 0xdec4u:
			case 0xdec5u:
			case 0xdeccu:
			case 0xded0u:
			case 0xded1u:
			case 0xded2u:
			case 0xded5u:
			case 0xded6u:
			case 0xded7u:
			case 0xdedcu:
			case 0xdeddu:
			case 0xdedeu:
			case 0xdedfu:
			case 0xdeebu:
			case 0xdeecu:
			case 0xdef4u:
			case 0xdef5u:
			case 0xdef6u:
			case 0xdef7u:
			case 0xdef8u:
			case 0xdef9u:
			case 0xdefau:
			case 0xdefbu:
			case 0xdefcu:
			case 0xdfe0u:
			case 0xdfe1u:
			case 0xdfe2u:
			case 0xdfe3u:
			case 0xdfe4u:
			case 0xdfe5u:
			case 0xdfe6u:
			case 0xdfe7u:
			case 0xdfe8u:
			case 0xdfe9u:
			case 0xdfeau:
			case 0xdfebu:
			case 0xdff0u:
				return true;
			default:
				return false;
			}
		case 113:
			switch(input[offset + 1].unicode()) {
			case 0xdd0cu:
			case 0xdd0du:
			case 0xdd0eu:
			case 0xdd0fu:
			case 0xdd10u:
			case 0xdd11u:
			case 0xdd12u:
			case 0xdd13u:
			case 0xdd14u:
			case 0xdd15u:
			case 0xdd16u:
			case 0xdd17u:
			case 0xdd18u:
			case 0xdd19u:
			case 0xdd1au:
			case 0xdd1bu:
			case 0xdd1cu:
			case 0xdd1du:
			case 0xdd1eu:
			case 0xdd1fu:
			case 0xdd20u:
			case 0xdd21u:
			case 0xdd22u:
			case 0xdd23u:
			case 0xdd24u:
			case 0xdd25u:
			case 0xdd26u:
			case 0xdd27u:
			case 0xdd28u:
			case 0xdd29u:
			case 0xdd2au:
			case 0xdd2bu:
			case 0xdd2cu:
			case 0xdd2du:
			case 0xdd2eu:
			case 0xdd2fu:
			case 0xdd30u:
			case 0xdd31u:
			case 0xdd32u:
			case 0xdd33u:
			case 0xdd34u:
			case 0xdd35u:
			case 0xdd36u:
			case 0xdd37u:
			case 0xdd38u:
			case 0xdd39u:
			case 0xdd3au:
			case 0xdd3cu:
			case 0xdd3du:
			case 0xdd3eu:
			case 0xdd3fu:
			case 0xdd40u:
			case 0xdd41u:
			case 0xdd42u:
			case 0xdd43u:
			case 0xdd44u:
			case 0xdd45u:
			case 0xdd47u:
			case 0xdd48u:
			case 0xdd49u:
			case 0xdd4au:
			case 0xdd4bu:
			case 0xdd4cu:
			case 0xdd4du:
			case 0xdd4eu:
			case 0xdd4fu:
			case 0xdd50u:
			case 0xdd51u:
			case 0xdd52u:
			case 0xdd53u:
			case 0xdd54u:
			case 0xdd55u:
			case 0xdd56u:
			case 0xdd57u:
			case 0xdd58u:
			case 0xdd59u:
			case 0xdd5au:
			case 0xdd5bu:
			case 0xdd5cu:
			case 0xdd5du:
			case 0xdd5eu:
			case 0xdd5fu:
			case 0xdd60u:
			case 0xdd61u:
			case 0xdd62u:
			case 0xdd63u:
			case 0xdd64u:
			case 0xdd65u:
			case 0xdd66u:
			case 0xdd67u:
			case 0xdd68u:
			case 0xdd69u:
			case 0xdd6au:
			case 0xdd6bu:
			case 0xdd6cu:
			case 0xdd6du:
			case 0xdd6eu:
			case 0xdd6fu:
			case 0xdd70u:
			case 0xdd71u:
			case 0xdd72u:
			case 0xdd73u:
			case 0xdd74u:
			case 0xdd75u:
			case 0xdd76u:
			case 0xdd77u:
			case 0xdd78u:
			case 0xdd79u:
			case 0xdd7au:
			case 0xdd7bu:
			case 0xdd7cu:
			case 0xdd7du:
			case 0xdd7eu:
			case 0xdd7fu:
			case 0xdd80u:
			case 0xdd81u:
			case 0xdd82u:
			case 0xdd83u:
			case 0xdd84u:
			case 0xdd85u:
			case 0xdd86u:
			case 0xdd87u:
			case 0xdd88u:
			case 0xdd89u:
			case 0xdd8au:
			case 0xdd8bu:
			case 0xdd8cu:
			case 0xdd8du:
			case 0xdd8eu:
			case 0xdd8fu:
			case 0xdd90u:
			case 0xdd91u:
			case 0xdd92u:
			case 0xdd93u:
			case 0xdd94u:
			case 0xdd95u:
			case 0xdd96u:
			case 0xdd97u:
			case 0xdd98u:
			case 0xdd99u:
			case 0xdd9au:
			case 0xdd9bu:
			case 0xdd9cu:
			case 0xdd9du:
			case 0xdd9eu:
			case 0xdd9fu:
			case 0xdda0u:
			case 0xdda1u:
			case 0xdda2u:
			case 0xdda3u:
			case 0xdda4u:
			case 0xdda5u:
			case 0xdda6u:
			case 0xdda7u:
			case 0xdda8u:
			case 0xdda9u:
			case 0xddaau:
			case 0xddabu:
			case 0xddacu:
			case 0xddadu:
			case 0xddaeu:
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddb4u:
			case 0xddb5u:
			case 0xddb6u:
			case 0xddb7u:
			case 0xddb8u:
			case 0xddb9u:
			case 0xddbau:
			case 0xddbbu:
			case 0xddbcu:
			case 0xddbdu:
			case 0xddbeu:
			case 0xddbfu:
			case 0xddc0u:
			case 0xddc1u:
			case 0xddc2u:
			case 0xddc3u:
			case 0xddc4u:
			case 0xddc5u:
			case 0xddc6u:
			case 0xddc7u:
			case 0xddc8u:
			case 0xddc9u:
			case 0xddcau:
			case 0xddcbu:
			case 0xddccu:
			case 0xddcdu:
			case 0xddceu:
			case 0xddcfu:
			case 0xddd0u:
			case 0xddd1u:
			case 0xddd2u:
			case 0xddd3u:
			case 0xddd4u:
			case 0xddd5u:
			case 0xddd6u:
			case 0xddd7u:
			case 0xddd8u:
			case 0xddd9u:
			case 0xdddau:
			case 0xdddbu:
			case 0xdddcu:
			case 0xddddu:
			case 0xdddeu:
			case 0xdddfu:
			case 0xdde0u:
			case 0xdde1u:
			case 0xdde2u:
			case 0xdde3u:
			case 0xdde4u:
			case 0xdde5u:
			case 0xdde6u:
			case 0xdde7u:
			case 0xdde8u:
			case 0xdde9u:
			case 0xddeau:
			case 0xddebu:
			case 0xddecu:
			case 0xddedu:
			case 0xddeeu:
			case 0xddefu:
			case 0xddf0u:
			case 0xddf1u:
			case 0xddf2u:
			case 0xddf3u:
			case 0xddf4u:
			case 0xddf5u:
			case 0xddf6u:
			case 0xddf7u:
			case 0xddf8u:
			case 0xddf9u:
			case 0xddfau:
			case 0xddfbu:
			case 0xddfcu:
			case 0xddfdu:
			case 0xddfeu:
			case 0xddffu:
			case 0xde70u:
			case 0xde71u:
			case 0xde72u:
			case 0xde73u:
			case 0xde74u:
			case 0xde75u:
			case 0xde76u:
			case 0xde77u:
			case 0xde78u:
			case 0xde79u:
			case 0xde7au:
			case 0xde7bu:
			case 0xde7cu:
			case 0xde80u:
			case 0xde81u:
			case 0xde82u:
			case 0xde83u:
			case 0xde84u:
			case 0xde85u:
			case 0xde86u:
			case 0xde87u:
			case 0xde88u:
			case 0xde90u:
			case 0xde91u:
			case 0xde92u:
			case 0xde93u:
			case 0xde94u:
			case 0xde95u:
			case 0xde96u:
			case 0xde97u:
			case 0xde98u:
			case 0xde99u:
			case 0xde9au:
			case 0xde9bu:
			case 0xde9cu:
			case 0xde9du:
			case 0xde9eu:
			case 0xde9fu:
			case 0xdea0u:
			case 0xdea1u:
			case 0xdea2u:
			case 0xdea3u:
			case 0xdea4u:
			case 0xdea5u:
			case 0xdea6u:
			case 0xdea7u:
			case 0xdea8u:
			case 0xdea9u:
			case 0xdeaau:
			case 0xdeabu:
			case 0xdeacu:
			case 0xdeadu:
			case 0xdeaeu:
			case 0xdeafu:
			case 0xdeb0u:
			case 0xdeb1u:
			case 0xdeb2u:
			case 0xdeb3u:
			case 0xdeb4u:
			case 0xdeb5u:
			case 0xdeb6u:
			case 0xdeb7u:
			case 0xdeb8u:
			case 0xdeb9u:
			case 0xdebau:
			case 0xdebbu:
			case 0xdebcu:
			case 0xdebdu:
			case 0xdebfu:
			case 0xdec0u:
			case 0xdec1u:
			case 0xdec2u:
			case 0xdec3u:
			case 0xdec4u:
			case 0xdec5u:
			case 0xdeceu:
			case 0xdecfu:
			case 0xded0u:
			case 0xded1u:
			case 0xded2u:
			case 0xded3u:
			case 0xded4u:
			case 0xded5u:
			case 0xded6u:
			case 0xded7u:
			case 0xded8u:
			case 0xded9u:
			case 0xdedau:
			case 0xdedbu:
			case 0xdee0u:
			case 0xdee1u:
			case 0xdee2u:
			case 0xdee3u:
			case 0xdee4u:
			case 0xdee5u:
			case 0xdee6u:
			case 0xdee7u:
			case 0xdee8u:
			case 0xdef0u:
			case 0xdef1u:
			case 0xdef2u:
			case 0xdef3u:
			case 0xdef4u:
			case 0xdef5u:
			case 0xdef6u:
			case 0xdef7u:
			case 0xdef8u:
				return true;
			default:
				return false;
			}
		default:
			Q_ASSERT_X(false, "emojiMatch2", "Invalid state");
			return false;
		}
	}
}

static bool emojiMatch3(const QString &input, int offset)
{
	int state = 0;
	while(true) {
		switch(state) {
		case 0:
			switch(input[offset + 0].unicode()) {
			case 0x0023u:
				state = 1;
				continue;
			case 0x002au:
				state = 2;
				continue;
			case 0x0030u:
				state = 3;
				continue;
			case 0x0031u:
				state = 4;
				continue;
			case 0x0032u:
				state = 5;
				continue;
			case 0x0033u:
				state = 6;
				continue;
			case 0x0034u:
				state = 7;
				continue;
			case 0x0035u:
				state = 8;
				continue;
			case 0x0036u:
				state = 9;
				continue;
			case 0x0037u:
				state = 10;
				continue;
			case 0x0038u:
				state = 11;
				continue;
			case 0x0039u:
				state = 12;
				continue;
			case 0x261du:
				state = 13;
				continue;
			case 0x26f9u:
				state = 14;
				continue;
			case 0x270au:
				state = 15;
				continue;
			case 0x270bu:
				state = 16;
				continue;
			case 0x270cu:
				state = 17;
				continue;
			case 0x270du:
				state = 18;
				continue;
			case 0xd83cu:
				state = 19;
				continue;
			case 0xd83du:
				state = 20;
				continue;
			default:
				return false;
			}
		case 1:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				state = 21;
				continue;
			default:
				return false;
			}
		case 21:
			switch(input[offset + 2].unicode()) {
			case 0x20e3u:
				return true;
			default:
				return false;
			}
		case 2:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				state = 22;
				continue;
			default:
				return false;
			}
		case 22:
			switch(input[offset + 2].unicode()) {
			case 0x20e3u:
				return true;
			default:
				return false;
			}
		case 3:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				state = 23;
				continue;
			default:
				return false;
			}
		case 23:
			switch(input[offset + 2].unicode()) {
			case 0x20e3u:
				return true;
			default:
				return false;
			}
		case 4:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				state = 24;
				continue;
			default:
				return false;
			}
		case 24:
			switch(input[offset + 2].unicode()) {
			case 0x20e3u:
				return true;
			default:
				return false;
			}
		case 5:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				state = 25;
				continue;
			default:
				return false;
			}
		case 25:
			switch(input[offset + 2].unicode()) {
			case 0x20e3u:
				return true;
			default:
				return false;
			}
		case 6:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				state = 26;
				continue;
			default:
				return false;
			}
		case 26:
			switch(input[offset + 2].unicode()) {
			case 0x20e3u:
				return true;
			default:
				return false;
			}
		case 7:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				state = 27;
				continue;
			default:
				return false;
			}
		case 27:
			switch(input[offset + 2].unicode()) {
			case 0x20e3u:
				return true;
			default:
				return false;
			}
		case 8:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				state = 28;
				continue;
			default:
				return false;
			}
		case 28:
			switch(input[offset + 2].unicode()) {
			case 0x20e3u:
				return true;
			default:
				return false;
			}
		case 9:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				state = 29;
				continue;
			default:
				return false;
			}
		case 29:
			switch(input[offset + 2].unicode()) {
			case 0x20e3u:
				return true;
			default:
				return false;
			}
		case 10:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				state = 30;
				continue;
			default:
				return false;
			}
		case 30:
			switch(input[offset + 2].unicode()) {
			case 0x20e3u:
				return true;
			default:
				return false;
			}
		case 11:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				state = 31;
				continue;
			default:
				return false;
			}
		case 31:
			switch(input[offset + 2].unicode()) {
			case 0x20e3u:
				return true;
			default:
				return false;
			}
		case 12:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				state = 32;
				continue;
			default:
				return false;
			}
		case 32:
			switch(input[offset + 2].unicode()) {
			case 0x20e3u:
				return true;
			default:
				return false;
			}
		case 13:
			switch(input[offset + 1].unicode()) {
			case 0xd83cu:
				state = 33;
				continue;
			default:
				return false;
			}
		case 33:
			switch(input[offset + 2].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 14:
			switch(input[offset + 1].unicode()) {
			case 0xd83cu:
				state = 34;
				continue;
			default:
				return false;
			}
		case 34:
			switch(input[offset + 2].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 15:
			switch(input[offset + 1].unicode()) {
			case 0xd83cu:
				state = 35;
				continue;
			default:
				return false;
			}
		case 35:
			switch(input[offset + 2].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 16:
			switch(input[offset + 1].unicode()) {
			case 0xd83cu:
				state = 36;
				continue;
			default:
				return false;
			}
		case 36:
			switch(input[offset + 2].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 17:
			switch(input[offset + 1].unicode()) {
			case 0xd83cu:
				state = 37;
				continue;
			default:
				return false;
			}
		case 37:
			switch(input[offset + 2].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 18:
			switch(input[offset + 1].unicode()) {
			case 0xd83cu:
				state = 38;
				continue;
			default:
				return false;
			}
		case 38:
			switch(input[offset + 2].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 19:
			switch(input[offset + 1].unicode()) {
			case 0xdd70u:
				state = 39;
				continue;
			case 0xdd71u:
				state = 40;
				continue;
			case 0xdd7eu:
				state = 41;
				continue;
			case 0xdd7fu:
				state = 42;
				continue;
			case 0xde02u:
				state = 43;
				continue;
			case 0xde37u:
				state = 44;
				continue;
			case 0xdf21u:
				state = 45;
				continue;
			case 0xdf24u:
				state = 46;
				continue;
			case 0xdf25u:
				state = 47;
				continue;
			case 0xdf26u:
				state = 48;
				continue;
			case 0xdf27u:
				state = 49;
				continue;
			case 0xdf28u:
				state = 50;
				continue;
			case 0xdf29u:
				state = 51;
				continue;
			case 0xdf2au:
				state = 52;
				continue;
			case 0xdf2bu:
				state = 53;
				continue;
			case 0xdf2cu:
				state = 54;
				continue;
			case 0xdf36u:
				state = 55;
				continue;
			case 0xdf7du:
				state = 56;
				continue;
			case 0xdf96u:
				state = 57;
				continue;
			case 0xdf97u:
				state = 58;
				continue;
			case 0xdf99u:
				state = 59;
				continue;
			case 0xdf9au:
				state = 60;
				continue;
			case 0xdf9bu:
				state = 61;
				continue;
			case 0xdf9eu:
				state = 62;
				continue;
			case 0xdf9fu:
				state = 63;
				continue;
			case 0xdfcbu:
				state = 64;
				continue;
			case 0xdfccu:
				state = 65;
				continue;
			case 0xdfcdu:
				state = 66;
				continue;
			case 0xdfceu:
				state = 67;
				continue;
			case 0xdfd4u:
				state = 68;
				continue;
			case 0xdfd5u:
				state = 69;
				continue;
			case 0xdfd6u:
				state = 70;
				continue;
			case 0xdfd7u:
				state = 71;
				continue;
			case 0xdfd8u:
				state = 72;
				continue;
			case 0xdfd9u:
				state = 73;
				continue;
			case 0xdfdau:
				state = 74;
				continue;
			case 0xdfdbu:
				state = 75;
				continue;
			case 0xdfdcu:
				state = 76;
				continue;
			case 0xdfddu:
				state = 77;
				continue;
			case 0xdfdeu:
				state = 78;
				continue;
			case 0xdfdfu:
				state = 79;
				continue;
			case 0xdff3u:
				state = 80;
				continue;
			case 0xdff5u:
				state = 81;
				continue;
			case 0xdff7u:
				state = 82;
				continue;
			default:
				return false;
			}
		case 39:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 40:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 41:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 42:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 43:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 44:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 45:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 46:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 47:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 48:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 49:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 50:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 51:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 52:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 53:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 54:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 55:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 56:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 57:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 58:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 59:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 60:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 61:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 62:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 63:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 64:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 65:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 66:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 67:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 68:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 69:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 70:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 71:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 72:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 73:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 74:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 75:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 76:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 77:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 78:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 79:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 80:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 81:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 82:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 20:
			switch(input[offset + 1].unicode()) {
			case 0xdc3fu:
				state = 83;
				continue;
			case 0xdc41u:
				state = 84;
				continue;
			case 0xdcfdu:
				state = 85;
				continue;
			case 0xdd49u:
				state = 86;
				continue;
			case 0xdd4au:
				state = 87;
				continue;
			case 0xdd6fu:
				state = 88;
				continue;
			case 0xdd70u:
				state = 89;
				continue;
			case 0xdd73u:
				state = 90;
				continue;
			case 0xdd74u:
				state = 91;
				continue;
			case 0xdd75u:
				state = 92;
				continue;
			case 0xdd76u:
				state = 93;
				continue;
			case 0xdd77u:
				state = 94;
				continue;
			case 0xdd78u:
				state = 95;
				continue;
			case 0xdd79u:
				state = 96;
				continue;
			case 0xdd87u:
				state = 97;
				continue;
			case 0xdd8au:
				state = 98;
				continue;
			case 0xdd8bu:
				state = 99;
				continue;
			case 0xdd8cu:
				state = 100;
				continue;
			case 0xdd8du:
				state = 101;
				continue;
			case 0xdd90u:
				state = 102;
				continue;
			case 0xdda5u:
				state = 103;
				continue;
			case 0xdda8u:
				state = 104;
				continue;
			case 0xddb1u:
				state = 105;
				continue;
			case 0xddb2u:
				state = 106;
				continue;
			case 0xddbcu:
				state = 107;
				continue;
			case 0xddc2u:
				state = 108;
				continue;
			case 0xddc3u:
				state = 109;
				continue;
			case 0xddc4u:
				state = 110;
				continue;
			case 0xddd1u:
				state = 111;
				continue;
			case 0xddd2u:
				state = 112;
				continue;
			case 0xddd3u:
				state = 113;
				continue;
			case 0xdddcu:
				state = 114;
				continue;
			case 0xddddu:
				state = 115;
				continue;
			case 0xdddeu:
				state = 116;
				continue;
			case 0xdde1u:
				state = 117;
				continue;
			case 0xdde3u:
				state = 118;
				continue;
			case 0xdde8u:
				state = 119;
				continue;
			case 0xddefu:
				state = 120;
				continue;
			case 0xddf3u:
				state = 121;
				continue;
			case 0xddfau:
				state = 122;
				continue;
			case 0xdecbu:
				state = 123;
				continue;
			case 0xdecdu:
				state = 124;
				continue;
			case 0xdeceu:
				state = 125;
				continue;
			case 0xdecfu:
				state = 126;
				continue;
			case 0xdee0u:
				state = 127;
				continue;
			case 0xdee1u:
				state = 128;
				continue;
			case 0xdee2u:
				state = 129;
				continue;
			case 0xdee3u:
				state = 130;
				continue;
			case 0xdee4u:
				state = 131;
				continue;
			case 0xdee5u:
				state = 132;
				continue;
			case 0xdee9u:
				state = 133;
				continue;
			case 0xdef0u:
				state = 134;
				continue;
			case 0xdef3u:
				state = 135;
				continue;
			default:
				return false;
			}
		case 83:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 84:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 85:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 86:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 87:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 88:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 89:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 90:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 91:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 92:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 93:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 94:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 95:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 96:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 97:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 98:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 99:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 100:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 101:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 102:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 103:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 104:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 105:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 106:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 107:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 108:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 109:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 110:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 111:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 112:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 113:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 114:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 115:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 116:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 117:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 118:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 119:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 120:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 121:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 122:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 123:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 124:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 125:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 126:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 127:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 128:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 129:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 130:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 131:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 132:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 133:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 134:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 135:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		default:
			Q_ASSERT_X(false, "emojiMatch3", "Invalid state");
			return false;
		}
	}
}

static bool emojiMatch4(const QString &input, int offset)
{
	int state = 0;
	while(true) {
		switch(state) {
		case 0:
			switch(input[offset + 0].unicode()) {
			case 0xd83cu:
				state = 1;
				continue;
			case 0xd83du:
				state = 2;
				continue;
			case 0xd83eu:
				state = 3;
				continue;
			default:
				return false;
			}
		case 1:
			switch(input[offset + 1].unicode()) {
			case 0xdde6u:
				state = 4;
				continue;
			case 0xdde7u:
				state = 5;
				continue;
			case 0xdde8u:
				state = 6;
				continue;
			case 0xdde9u:
				state = 7;
				continue;
			case 0xddeau:
				state = 8;
				continue;
			case 0xddebu:
				state = 9;
				continue;
			case 0xddecu:
				state = 10;
				continue;
			case 0xddedu:
				state = 11;
				continue;
			case 0xddeeu:
				state = 12;
				continue;
			case 0xddefu:
				state = 13;
				continue;
			case 0xddf0u:
				state = 14;
				continue;
			case 0xddf1u:
				state = 15;
				continue;
			case 0xddf2u:
				state = 16;
				continue;
			case 0xddf3u:
				state = 17;
				continue;
			case 0xddf4u:
				state = 18;
				continue;
			case 0xddf5u:
				state = 19;
				continue;
			case 0xddf6u:
				state = 20;
				continue;
			case 0xddf7u:
				state = 21;
				continue;
			case 0xddf8u:
				state = 22;
				continue;
			case 0xddf9u:
				state = 23;
				continue;
			case 0xddfau:
				state = 24;
				continue;
			case 0xddfbu:
				state = 25;
				continue;
			case 0xddfcu:
				state = 26;
				continue;
			case 0xddfdu:
				state = 27;
				continue;
			case 0xddfeu:
				state = 28;
				continue;
			case 0xddffu:
				state = 29;
				continue;
			case 0xdf85u:
				state = 30;
				continue;
			case 0xdfc2u:
				state = 31;
				continue;
			case 0xdfc3u:
				state = 32;
				continue;
			case 0xdfc4u:
				state = 33;
				continue;
			case 0xdfc7u:
				state = 34;
				continue;
			case 0xdfcau:
				state = 35;
				continue;
			case 0xdfcbu:
				state = 36;
				continue;
			case 0xdfccu:
				state = 37;
				continue;
			default:
				return false;
			}
		case 4:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 38;
				continue;
			default:
				return false;
			}
		case 38:
			switch(input[offset + 3].unicode()) {
			case 0xdde8u:
			case 0xdde9u:
			case 0xddeau:
			case 0xddebu:
			case 0xddecu:
			case 0xddeeu:
			case 0xddf1u:
			case 0xddf2u:
			case 0xddf4u:
			case 0xddf6u:
			case 0xddf7u:
			case 0xddf8u:
			case 0xddf9u:
			case 0xddfau:
			case 0xddfcu:
			case 0xddfdu:
			case 0xddffu:
				return true;
			default:
				return false;
			}
		case 5:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 39;
				continue;
			default:
				return false;
			}
		case 39:
			switch(input[offset + 3].unicode()) {
			case 0xdde6u:
			case 0xdde7u:
			case 0xdde9u:
			case 0xddeau:
			case 0xddebu:
			case 0xddecu:
			case 0xddedu:
			case 0xddeeu:
			case 0xddefu:
			case 0xddf1u:
			case 0xddf2u:
			case 0xddf3u:
			case 0xddf4u:
			case 0xddf6u:
			case 0xddf7u:
			case 0xddf8u:
			case 0xddf9u:
			case 0xddfbu:
			case 0xddfcu:
			case 0xddfeu:
			case 0xddffu:
				return true;
			default:
				return false;
			}
		case 6:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 40;
				continue;
			default:
				return false;
			}
		case 40:
			switch(input[offset + 3].unicode()) {
			case 0xdde6u:
			case 0xdde8u:
			case 0xdde9u:
			case 0xddebu:
			case 0xddecu:
			case 0xddedu:
			case 0xddeeu:
			case 0xddf0u:
			case 0xddf1u:
			case 0xddf2u:
			case 0xddf3u:
			case 0xddf4u:
			case 0xddf5u:
			case 0xddf7u:
			case 0xddfau:
			case 0xddfbu:
			case 0xddfcu:
			case 0xddfdu:
			case 0xddfeu:
			case 0xddffu:
				return true;
			default:
				return false;
			}
		case 7:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 41;
				continue;
			default:
				return false;
			}
		case 41:
			switch(input[offset + 3].unicode()) {
			case 0xddeau:
			case 0xddecu:
			case 0xddefu:
			case 0xddf0u:
			case 0xddf2u:
			case 0xddf4u:
			case 0xddffu:
				return true;
			default:
				return false;
			}
		case 8:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 42;
				continue;
			default:
				return false;
			}
		case 42:
			switch(input[offset + 3].unicode()) {
			case 0xdde6u:
			case 0xdde8u:
			case 0xddeau:
			case 0xddecu:
			case 0xddedu:
			case 0xddf7u:
			case 0xddf8u:
			case 0xddf9u:
			case 0xddfau:
				return true;
			default:
				return false;
			}
		case 9:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 43;
				continue;
			default:
				return false;
			}
		case 43:
			switch(input[offset + 3].unicode()) {
			case 0xddeeu:
			case 0xddefu:
			case 0xddf0u:
			case 0xddf2u:
			case 0xddf4u:
			case 0xddf7u:
				return true;
			default:
				return false;
			}
		case 10:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 44;
				continue;
			default:
				return false;
			}
		case 44:
			switch(input[offset + 3].unicode()) {
			case 0xdde6u:
			case 0xdde7u:
			case 0xdde9u:
			case 0xddeau:
			case 0xddebu:
			case 0xddecu:
			case 0xddedu:
			case 0xddeeu:
			case 0xddf1u:
			case 0xddf2u:
			case 0xddf3u:
			case 0xddf5u:
			case 0xddf6u:
			case 0xddf7u:
			case 0xddf8u:
			case 0xddf9u:
			case 0xddfau:
			case 0xddfcu:
			case 0xddfeu:
				return true;
			default:
				return false;
			}
		case 11:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 45;
				continue;
			default:
				return false;
			}
		case 45:
			switch(input[offset + 3].unicode()) {
			case 0xddf0u:
			case 0xddf2u:
			case 0xddf3u:
			case 0xddf7u:
			case 0xddf9u:
			case 0xddfau:
				return true;
			default:
				return false;
			}
		case 12:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 46;
				continue;
			default:
				return false;
			}
		case 46:
			switch(input[offset + 3].unicode()) {
			case 0xdde8u:
			case 0xdde9u:
			case 0xddeau:
			case 0xddf1u:
			case 0xddf2u:
			case 0xddf3u:
			case 0xddf4u:
			case 0xddf6u:
			case 0xddf7u:
			case 0xddf8u:
			case 0xddf9u:
				return true;
			default:
				return false;
			}
		case 13:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 47;
				continue;
			default:
				return false;
			}
		case 47:
			switch(input[offset + 3].unicode()) {
			case 0xddeau:
			case 0xddf2u:
			case 0xddf4u:
			case 0xddf5u:
				return true;
			default:
				return false;
			}
		case 14:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 48;
				continue;
			default:
				return false;
			}
		case 48:
			switch(input[offset + 3].unicode()) {
			case 0xddeau:
			case 0xddecu:
			case 0xddedu:
			case 0xddeeu:
			case 0xddf2u:
			case 0xddf3u:
			case 0xddf5u:
			case 0xddf7u:
			case 0xddfcu:
			case 0xddfeu:
			case 0xddffu:
				return true;
			default:
				return false;
			}
		case 15:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 49;
				continue;
			default:
				return false;
			}
		case 49:
			switch(input[offset + 3].unicode()) {
			case 0xdde6u:
			case 0xdde7u:
			case 0xdde8u:
			case 0xddeeu:
			case 0xddf0u:
			case 0xddf7u:
			case 0xddf8u:
			case 0xddf9u:
			case 0xddfau:
			case 0xddfbu:
			case 0xddfeu:
				return true;
			default:
				return false;
			}
		case 16:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 50;
				continue;
			default:
				return false;
			}
		case 50:
			switch(input[offset + 3].unicode()) {
			case 0xdde6u:
			case 0xdde8u:
			case 0xdde9u:
			case 0xddeau:
			case 0xddebu:
			case 0xddecu:
			case 0xddedu:
			case 0xddf0u:
			case 0xddf1u:
			case 0xddf2u:
			case 0xddf3u:
			case 0xddf4u:
			case 0xddf5u:
			case 0xddf6u:
			case 0xddf7u:
			case 0xddf8u:
			case 0xddf9u:
			case 0xddfau:
			case 0xddfbu:
			case 0xddfcu:
			case 0xddfdu:
			case 0xddfeu:
			case 0xddffu:
				return true;
			default:
				return false;
			}
		case 17:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 51;
				continue;
			default:
				return false;
			}
		case 51:
			switch(input[offset + 3].unicode()) {
			case 0xdde6u:
			case 0xdde8u:
			case 0xddeau:
			case 0xddebu:
			case 0xddecu:
			case 0xddeeu:
			case 0xddf1u:
			case 0xddf4u:
			case 0xddf5u:
			case 0xddf7u:
			case 0xddfau:
			case 0xddffu:
				return true;
			default:
				return false;
			}
		case 18:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 52;
				continue;
			default:
				return false;
			}
		case 52:
			switch(input[offset + 3].unicode()) {
			case 0xddf2u:
				return true;
			default:
				return false;
			}
		case 19:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 53;
				continue;
			default:
				return false;
			}
		case 53:
			switch(input[offset + 3].unicode()) {
			case 0xdde6u:
			case 0xddeau:
			case 0xddebu:
			case 0xddecu:
			case 0xddedu:
			case 0xddf0u:
			case 0xddf1u:
			case 0xddf2u:
			case 0xddf3u:
			case 0xddf7u:
			case 0xddf8u:
			case 0xddf9u:
			case 0xddfcu:
			case 0xddfeu:
				return true;
			default:
				return false;
			}
		case 20:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 54;
				continue;
			default:
				return false;
			}
		case 54:
			switch(input[offset + 3].unicode()) {
			case 0xdde6u:
				return true;
			default:
				return false;
			}
		case 21:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 55;
				continue;
			default:
				return false;
			}
		case 55:
			switch(input[offset + 3].unicode()) {
			case 0xddeau:
			case 0xddf4u:
			case 0xddf8u:
			case 0xddfau:
			case 0xddfcu:
				return true;
			default:
				return false;
			}
		case 22:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 56;
				continue;
			default:
				return false;
			}
		case 56:
			switch(input[offset + 3].unicode()) {
			case 0xdde6u:
			case 0xdde7u:
			case 0xdde8u:
			case 0xdde9u:
			case 0xddeau:
			case 0xddecu:
			case 0xddedu:
			case 0xddeeu:
			case 0xddefu:
			case 0xddf0u:
			case 0xddf1u:
			case 0xddf2u:
			case 0xddf3u:
			case 0xddf4u:
			case 0xddf7u:
			case 0xddf8u:
			case 0xddf9u:
			case 0xddfbu:
			case 0xddfdu:
			case 0xddfeu:
			case 0xddffu:
				return true;
			default:
				return false;
			}
		case 23:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 57;
				continue;
			default:
				return false;
			}
		case 57:
			switch(input[offset + 3].unicode()) {
			case 0xdde6u:
			case 0xdde8u:
			case 0xdde9u:
			case 0xddebu:
			case 0xddecu:
			case 0xddedu:
			case 0xddefu:
			case 0xddf0u:
			case 0xddf1u:
			case 0xddf2u:
			case 0xddf3u:
			case 0xddf4u:
			case 0xddf7u:
			case 0xddf9u:
			case 0xddfbu:
			case 0xddfcu:
			case 0xddffu:
				return true;
			default:
				return false;
			}
		case 24:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 58;
				continue;
			default:
				return false;
			}
		case 58:
			switch(input[offset + 3].unicode()) {
			case 0xdde6u:
			case 0xddecu:
			case 0xddf2u:
			case 0xddf3u:
			case 0xddf8u:
			case 0xddfeu:
			case 0xddffu:
				return true;
			default:
				return false;
			}
		case 25:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 59;
				continue;
			default:
				return false;
			}
		case 59:
			switch(input[offset + 3].unicode()) {
			case 0xdde6u:
			case 0xdde8u:
			case 0xddeau:
			case 0xddecu:
			case 0xddeeu:
			case 0xddf3u:
			case 0xddfau:
				return true;
			default:
				return false;
			}
		case 26:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 60;
				continue;
			default:
				return false;
			}
		case 60:
			switch(input[offset + 3].unicode()) {
			case 0xddebu:
			case 0xddf8u:
				return true;
			default:
				return false;
			}
		case 27:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 61;
				continue;
			default:
				return false;
			}
		case 61:
			switch(input[offset + 3].unicode()) {
			case 0xddf0u:
				return true;
			default:
				return false;
			}
		case 28:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 62;
				continue;
			default:
				return false;
			}
		case 62:
			switch(input[offset + 3].unicode()) {
			case 0xddeau:
			case 0xddf9u:
				return true;
			default:
				return false;
			}
		case 29:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 63;
				continue;
			default:
				return false;
			}
		case 63:
			switch(input[offset + 3].unicode()) {
			case 0xdde6u:
			case 0xddf2u:
			case 0xddfcu:
				return true;
			default:
				return false;
			}
		case 30:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 64;
				continue;
			default:
				return false;
			}
		case 64:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 31:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 65;
				continue;
			default:
				return false;
			}
		case 65:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 32:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 66;
				continue;
			default:
				return false;
			}
		case 66:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 33:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 67;
				continue;
			default:
				return false;
			}
		case 67:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 34:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 68;
				continue;
			default:
				return false;
			}
		case 68:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 35:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 69;
				continue;
			default:
				return false;
			}
		case 69:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 36:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 70;
				continue;
			default:
				return false;
			}
		case 70:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 37:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 71;
				continue;
			default:
				return false;
			}
		case 71:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 2:
			switch(input[offset + 1].unicode()) {
			case 0xdc08u:
				state = 72;
				continue;
			case 0xdc26u:
				state = 73;
				continue;
			case 0xdc42u:
				state = 74;
				continue;
			case 0xdc43u:
				state = 75;
				continue;
			case 0xdc46u:
				state = 76;
				continue;
			case 0xdc47u:
				state = 77;
				continue;
			case 0xdc48u:
				state = 78;
				continue;
			case 0xdc49u:
				state = 79;
				continue;
			case 0xdc4au:
				state = 80;
				continue;
			case 0xdc4bu:
				state = 81;
				continue;
			case 0xdc4cu:
				state = 82;
				continue;
			case 0xdc4du:
				state = 83;
				continue;
			case 0xdc4eu:
				state = 84;
				continue;
			case 0xdc4fu:
				state = 85;
				continue;
			case 0xdc50u:
				state = 86;
				continue;
			case 0xdc66u:
				state = 87;
				continue;
			case 0xdc67u:
				state = 88;
				continue;
			case 0xdc68u:
				state = 89;
				continue;
			case 0xdc69u:
				state = 90;
				continue;
			case 0xdc6bu:
				state = 91;
				continue;
			case 0xdc6cu:
				state = 92;
				continue;
			case 0xdc6du:
				state = 93;
				continue;
			case 0xdc6eu:
				state = 94;
				continue;
			case 0xdc70u:
				state = 95;
				continue;
			case 0xdc71u:
				state = 96;
				continue;
			case 0xdc72u:
				state = 97;
				continue;
			case 0xdc73u:
				state = 98;
				continue;
			case 0xdc74u:
				state = 99;
				continue;
			case 0xdc75u:
				state = 100;
				continue;
			case 0xdc76u:
				state = 101;
				continue;
			case 0xdc77u:
				state = 102;
				continue;
			case 0xdc78u:
				state = 103;
				continue;
			case 0xdc7cu:
				state = 104;
				continue;
			case 0xdc81u:
				state = 105;
				continue;
			case 0xdc82u:
				state = 106;
				continue;
			case 0xdc83u:
				state = 107;
				continue;
			case 0xdc85u:
				state = 108;
				continue;
			case 0xdc86u:
				state = 109;
				continue;
			case 0xdc87u:
				state = 110;
				continue;
			case 0xdc8fu:
				state = 111;
				continue;
			case 0xdc91u:
				state = 112;
				continue;
			case 0xdcaau:
				state = 113;
				continue;
			case 0xdd74u:
				state = 114;
				continue;
			case 0xdd75u:
				state = 115;
				continue;
			case 0xdd7au:
				state = 116;
				continue;
			case 0xdd90u:
				state = 117;
				continue;
			case 0xdd95u:
				state = 118;
				continue;
			case 0xdd96u:
				state = 119;
				continue;
			case 0xde45u:
				state = 120;
				continue;
			case 0xde46u:
				state = 121;
				continue;
			case 0xde47u:
				state = 122;
				continue;
			case 0xde4bu:
				state = 123;
				continue;
			case 0xde4cu:
				state = 124;
				continue;
			case 0xde4du:
				state = 125;
				continue;
			case 0xde4eu:
				state = 126;
				continue;
			case 0xde4fu:
				state = 127;
				continue;
			case 0xdea3u:
				state = 128;
				continue;
			case 0xdeb4u:
				state = 129;
				continue;
			case 0xdeb5u:
				state = 130;
				continue;
			case 0xdeb6u:
				state = 131;
				continue;
			case 0xdec0u:
				state = 132;
				continue;
			case 0xdeccu:
				state = 133;
				continue;
			default:
				return false;
			}
		case 72:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 134;
				continue;
			default:
				return false;
			}
		case 134:
			switch(input[offset + 3].unicode()) {
			case 0x2b1bu:
				return true;
			default:
				return false;
			}
		case 73:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 135;
				continue;
			default:
				return false;
			}
		case 135:
			switch(input[offset + 3].unicode()) {
			case 0x2b1bu:
				return true;
			default:
				return false;
			}
		case 74:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 136;
				continue;
			default:
				return false;
			}
		case 136:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 75:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 137;
				continue;
			default:
				return false;
			}
		case 137:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 76:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 138;
				continue;
			default:
				return false;
			}
		case 138:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 77:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 139;
				continue;
			default:
				return false;
			}
		case 139:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 78:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 140;
				continue;
			default:
				return false;
			}
		case 140:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 79:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 141;
				continue;
			default:
				return false;
			}
		case 141:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 80:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 142;
				continue;
			default:
				return false;
			}
		case 142:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 81:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 143;
				continue;
			default:
				return false;
			}
		case 143:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 82:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 144;
				continue;
			default:
				return false;
			}
		case 144:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 83:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 145;
				continue;
			default:
				return false;
			}
		case 145:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 84:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 146;
				continue;
			default:
				return false;
			}
		case 146:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 85:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 147;
				continue;
			default:
				return false;
			}
		case 147:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 86:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 148;
				continue;
			default:
				return false;
			}
		case 148:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 87:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 149;
				continue;
			default:
				return false;
			}
		case 149:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 88:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 150;
				continue;
			default:
				return false;
			}
		case 150:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 89:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 151;
				continue;
			default:
				return false;
			}
		case 151:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 90:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 152;
				continue;
			default:
				return false;
			}
		case 152:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 91:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 153;
				continue;
			default:
				return false;
			}
		case 153:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 92:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 154;
				continue;
			default:
				return false;
			}
		case 154:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 93:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 155;
				continue;
			default:
				return false;
			}
		case 155:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 94:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 156;
				continue;
			default:
				return false;
			}
		case 156:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 95:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 157;
				continue;
			default:
				return false;
			}
		case 157:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 96:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 158;
				continue;
			default:
				return false;
			}
		case 158:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 97:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 159;
				continue;
			default:
				return false;
			}
		case 159:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 98:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 160;
				continue;
			default:
				return false;
			}
		case 160:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 99:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 161;
				continue;
			default:
				return false;
			}
		case 161:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 100:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 162;
				continue;
			default:
				return false;
			}
		case 162:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 101:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 163;
				continue;
			default:
				return false;
			}
		case 163:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 102:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 164;
				continue;
			default:
				return false;
			}
		case 164:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 103:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 165;
				continue;
			default:
				return false;
			}
		case 165:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 104:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 166;
				continue;
			default:
				return false;
			}
		case 166:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 105:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 167;
				continue;
			default:
				return false;
			}
		case 167:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 106:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 168;
				continue;
			default:
				return false;
			}
		case 168:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 107:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 169;
				continue;
			default:
				return false;
			}
		case 169:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 108:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 170;
				continue;
			default:
				return false;
			}
		case 170:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 109:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 171;
				continue;
			default:
				return false;
			}
		case 171:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 110:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 172;
				continue;
			default:
				return false;
			}
		case 172:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 111:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 173;
				continue;
			default:
				return false;
			}
		case 173:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 112:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 174;
				continue;
			default:
				return false;
			}
		case 174:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 113:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 175;
				continue;
			default:
				return false;
			}
		case 175:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 114:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 176;
				continue;
			default:
				return false;
			}
		case 176:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 115:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 177;
				continue;
			default:
				return false;
			}
		case 177:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 116:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 178;
				continue;
			default:
				return false;
			}
		case 178:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 117:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 179;
				continue;
			default:
				return false;
			}
		case 179:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 118:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 180;
				continue;
			default:
				return false;
			}
		case 180:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 119:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 181;
				continue;
			default:
				return false;
			}
		case 181:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 120:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 182;
				continue;
			default:
				return false;
			}
		case 182:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 121:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 183;
				continue;
			default:
				return false;
			}
		case 183:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 122:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 184;
				continue;
			default:
				return false;
			}
		case 184:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 123:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 185;
				continue;
			default:
				return false;
			}
		case 185:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 124:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 186;
				continue;
			default:
				return false;
			}
		case 186:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 125:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 187;
				continue;
			default:
				return false;
			}
		case 187:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 126:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 188;
				continue;
			default:
				return false;
			}
		case 188:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 127:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 189;
				continue;
			default:
				return false;
			}
		case 189:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 128:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 190;
				continue;
			default:
				return false;
			}
		case 190:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 129:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 191;
				continue;
			default:
				return false;
			}
		case 191:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 130:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 192;
				continue;
			default:
				return false;
			}
		case 192:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 131:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 193;
				continue;
			default:
				return false;
			}
		case 193:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 132:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 194;
				continue;
			default:
				return false;
			}
		case 194:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 133:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 195;
				continue;
			default:
				return false;
			}
		case 195:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 3:
			switch(input[offset + 1].unicode()) {
			case 0xdd0cu:
				state = 196;
				continue;
			case 0xdd0fu:
				state = 197;
				continue;
			case 0xdd18u:
				state = 198;
				continue;
			case 0xdd19u:
				state = 199;
				continue;
			case 0xdd1au:
				state = 200;
				continue;
			case 0xdd1bu:
				state = 201;
				continue;
			case 0xdd1cu:
				state = 202;
				continue;
			case 0xdd1du:
				state = 203;
				continue;
			case 0xdd1eu:
				state = 204;
				continue;
			case 0xdd1fu:
				state = 205;
				continue;
			case 0xdd26u:
				state = 206;
				continue;
			case 0xdd30u:
				state = 207;
				continue;
			case 0xdd31u:
				state = 208;
				continue;
			case 0xdd32u:
				state = 209;
				continue;
			case 0xdd33u:
				state = 210;
				continue;
			case 0xdd34u:
				state = 211;
				continue;
			case 0xdd35u:
				state = 212;
				continue;
			case 0xdd36u:
				state = 213;
				continue;
			case 0xdd37u:
				state = 214;
				continue;
			case 0xdd38u:
				state = 215;
				continue;
			case 0xdd39u:
				state = 216;
				continue;
			case 0xdd3du:
				state = 217;
				continue;
			case 0xdd3eu:
				state = 218;
				continue;
			case 0xdd77u:
				state = 219;
				continue;
			case 0xddb5u:
				state = 220;
				continue;
			case 0xddb6u:
				state = 221;
				continue;
			case 0xddb8u:
				state = 222;
				continue;
			case 0xddb9u:
				state = 223;
				continue;
			case 0xddbbu:
				state = 224;
				continue;
			case 0xddcdu:
				state = 225;
				continue;
			case 0xddceu:
				state = 226;
				continue;
			case 0xddcfu:
				state = 227;
				continue;
			case 0xddd1u:
				state = 228;
				continue;
			case 0xddd2u:
				state = 229;
				continue;
			case 0xddd3u:
				state = 230;
				continue;
			case 0xddd4u:
				state = 231;
				continue;
			case 0xddd5u:
				state = 232;
				continue;
			case 0xddd6u:
				state = 233;
				continue;
			case 0xddd7u:
				state = 234;
				continue;
			case 0xddd8u:
				state = 235;
				continue;
			case 0xddd9u:
				state = 236;
				continue;
			case 0xdddau:
				state = 237;
				continue;
			case 0xdddbu:
				state = 238;
				continue;
			case 0xdddcu:
				state = 239;
				continue;
			case 0xddddu:
				state = 240;
				continue;
			case 0xdec3u:
				state = 241;
				continue;
			case 0xdec4u:
				state = 242;
				continue;
			case 0xdec5u:
				state = 243;
				continue;
			case 0xdef0u:
				state = 244;
				continue;
			case 0xdef1u:
				state = 245;
				continue;
			case 0xdef2u:
				state = 246;
				continue;
			case 0xdef3u:
				state = 247;
				continue;
			case 0xdef4u:
				state = 248;
				continue;
			case 0xdef5u:
				state = 249;
				continue;
			case 0xdef6u:
				state = 250;
				continue;
			case 0xdef7u:
				state = 251;
				continue;
			case 0xdef8u:
				state = 252;
				continue;
			default:
				return false;
			}
		case 196:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 253;
				continue;
			default:
				return false;
			}
		case 253:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 197:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 254;
				continue;
			default:
				return false;
			}
		case 254:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 198:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 255;
				continue;
			default:
				return false;
			}
		case 255:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 199:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 256;
				continue;
			default:
				return false;
			}
		case 256:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 200:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 257;
				continue;
			default:
				return false;
			}
		case 257:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 201:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 258;
				continue;
			default:
				return false;
			}
		case 258:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 202:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 259;
				continue;
			default:
				return false;
			}
		case 259:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 203:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 260;
				continue;
			default:
				return false;
			}
		case 260:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 204:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 261;
				continue;
			default:
				return false;
			}
		case 261:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 205:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 262;
				continue;
			default:
				return false;
			}
		case 262:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 206:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 263;
				continue;
			default:
				return false;
			}
		case 263:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 207:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 264;
				continue;
			default:
				return false;
			}
		case 264:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 208:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 265;
				continue;
			default:
				return false;
			}
		case 265:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 209:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 266;
				continue;
			default:
				return false;
			}
		case 266:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 210:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 267;
				continue;
			default:
				return false;
			}
		case 267:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 211:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 268;
				continue;
			default:
				return false;
			}
		case 268:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 212:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 269;
				continue;
			default:
				return false;
			}
		case 269:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 213:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 270;
				continue;
			default:
				return false;
			}
		case 270:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 214:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 271;
				continue;
			default:
				return false;
			}
		case 271:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 215:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 272;
				continue;
			default:
				return false;
			}
		case 272:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 216:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 273;
				continue;
			default:
				return false;
			}
		case 273:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 217:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 274;
				continue;
			default:
				return false;
			}
		case 274:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 218:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 275;
				continue;
			default:
				return false;
			}
		case 275:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 219:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 276;
				continue;
			default:
				return false;
			}
		case 276:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 220:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 277;
				continue;
			default:
				return false;
			}
		case 277:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 221:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 278;
				continue;
			default:
				return false;
			}
		case 278:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 222:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 279;
				continue;
			default:
				return false;
			}
		case 279:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 223:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 280;
				continue;
			default:
				return false;
			}
		case 280:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 224:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 281;
				continue;
			default:
				return false;
			}
		case 281:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 225:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 282;
				continue;
			default:
				return false;
			}
		case 282:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 226:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 283;
				continue;
			default:
				return false;
			}
		case 283:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 227:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 284;
				continue;
			default:
				return false;
			}
		case 284:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 228:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 285;
				continue;
			default:
				return false;
			}
		case 285:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 229:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 286;
				continue;
			default:
				return false;
			}
		case 286:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 230:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 287;
				continue;
			default:
				return false;
			}
		case 287:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 231:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 288;
				continue;
			default:
				return false;
			}
		case 288:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 232:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 289;
				continue;
			default:
				return false;
			}
		case 289:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 233:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 290;
				continue;
			default:
				return false;
			}
		case 290:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 234:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 291;
				continue;
			default:
				return false;
			}
		case 291:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 235:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 292;
				continue;
			default:
				return false;
			}
		case 292:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 236:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 293;
				continue;
			default:
				return false;
			}
		case 293:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 237:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 294;
				continue;
			default:
				return false;
			}
		case 294:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 238:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 295;
				continue;
			default:
				return false;
			}
		case 295:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 239:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 296;
				continue;
			default:
				return false;
			}
		case 296:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 240:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 297;
				continue;
			default:
				return false;
			}
		case 297:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 241:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 298;
				continue;
			default:
				return false;
			}
		case 298:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 242:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 299;
				continue;
			default:
				return false;
			}
		case 299:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 243:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 300;
				continue;
			default:
				return false;
			}
		case 300:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 244:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 301;
				continue;
			default:
				return false;
			}
		case 301:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 245:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 302;
				continue;
			default:
				return false;
			}
		case 302:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 246:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 303;
				continue;
			default:
				return false;
			}
		case 303:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 247:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 304;
				continue;
			default:
				return false;
			}
		case 304:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 248:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 305;
				continue;
			default:
				return false;
			}
		case 305:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 249:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 306;
				continue;
			default:
				return false;
			}
		case 306:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 250:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 307;
				continue;
			default:
				return false;
			}
		case 307:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 251:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 308;
				continue;
			default:
				return false;
			}
		case 308:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 252:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 309;
				continue;
			default:
				return false;
			}
		case 309:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		default:
			Q_ASSERT_X(false, "emojiMatch4", "Invalid state");
			return false;
		}
	}
}

static bool emojiMatch5(const QString &input, int offset)
{
	int state = 0;
	while(true) {
		switch(state) {
		case 0:
			switch(input[offset + 0].unicode()) {
			case 0x26f9u:
				state = 1;
				continue;
			case 0x2764u:
				state = 2;
				continue;
			case 0xd83cu:
				state = 3;
				continue;
			case 0xd83du:
				state = 4;
				continue;
			case 0xd83eu:
				state = 5;
				continue;
			default:
				return false;
			}
		case 1:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				state = 6;
				continue;
			default:
				return false;
			}
		case 6:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 7;
				continue;
			default:
				return false;
			}
		case 7:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 8;
				continue;
			case 0x2642u:
				state = 9;
				continue;
			default:
				return false;
			}
		case 8:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 9:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 2:
			switch(input[offset + 1].unicode()) {
			case 0xfe0fu:
				state = 10;
				continue;
			default:
				return false;
			}
		case 10:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 11;
				continue;
			default:
				return false;
			}
		case 11:
			switch(input[offset + 3].unicode()) {
			case 0xd83du:
				state = 12;
				continue;
			case 0xd83eu:
				state = 13;
				continue;
			default:
				return false;
			}
		case 12:
			switch(input[offset + 4].unicode()) {
			case 0xdd25u:
				return true;
			default:
				return false;
			}
		case 13:
			switch(input[offset + 4].unicode()) {
			case 0xde79u:
				return true;
			default:
				return false;
			}
		case 3:
			switch(input[offset + 1].unicode()) {
			case 0xdfc3u:
				state = 14;
				continue;
			case 0xdfc4u:
				state = 15;
				continue;
			case 0xdfcau:
				state = 16;
				continue;
			case 0xdff4u:
				state = 17;
				continue;
			default:
				return false;
			}
		case 14:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 18;
				continue;
			default:
				return false;
			}
		case 18:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 19;
				continue;
			case 0x2642u:
				state = 20;
				continue;
			default:
				return false;
			}
		case 19:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 20:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 15:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 21;
				continue;
			default:
				return false;
			}
		case 21:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 22;
				continue;
			case 0x2642u:
				state = 23;
				continue;
			default:
				return false;
			}
		case 22:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 23:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 16:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 24;
				continue;
			default:
				return false;
			}
		case 24:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 25;
				continue;
			case 0x2642u:
				state = 26;
				continue;
			default:
				return false;
			}
		case 25:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 26:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 17:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 27;
				continue;
			default:
				return false;
			}
		case 27:
			switch(input[offset + 3].unicode()) {
			case 0x2620u:
				state = 28;
				continue;
			default:
				return false;
			}
		case 28:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 4:
			switch(input[offset + 1].unicode()) {
			case 0xdc15u:
				state = 29;
				continue;
			case 0xdc3bu:
				state = 30;
				continue;
			case 0xdc68u:
				state = 31;
				continue;
			case 0xdc69u:
				state = 32;
				continue;
			case 0xdc6eu:
				state = 33;
				continue;
			case 0xdc6fu:
				state = 34;
				continue;
			case 0xdc70u:
				state = 35;
				continue;
			case 0xdc71u:
				state = 36;
				continue;
			case 0xdc73u:
				state = 37;
				continue;
			case 0xdc77u:
				state = 38;
				continue;
			case 0xdc81u:
				state = 39;
				continue;
			case 0xdc82u:
				state = 40;
				continue;
			case 0xdc86u:
				state = 41;
				continue;
			case 0xdc87u:
				state = 42;
				continue;
			case 0xde2eu:
				state = 43;
				continue;
			case 0xde35u:
				state = 44;
				continue;
			case 0xde45u:
				state = 45;
				continue;
			case 0xde46u:
				state = 46;
				continue;
			case 0xde47u:
				state = 47;
				continue;
			case 0xde4bu:
				state = 48;
				continue;
			case 0xde4du:
				state = 49;
				continue;
			case 0xde4eu:
				state = 50;
				continue;
			case 0xdea3u:
				state = 51;
				continue;
			case 0xdeb4u:
				state = 52;
				continue;
			case 0xdeb5u:
				state = 53;
				continue;
			case 0xdeb6u:
				state = 54;
				continue;
			default:
				return false;
			}
		case 29:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 55;
				continue;
			default:
				return false;
			}
		case 55:
			switch(input[offset + 3].unicode()) {
			case 0xd83eu:
				state = 56;
				continue;
			default:
				return false;
			}
		case 56:
			switch(input[offset + 4].unicode()) {
			case 0xddbau:
				return true;
			default:
				return false;
			}
		case 30:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 57;
				continue;
			default:
				return false;
			}
		case 57:
			switch(input[offset + 3].unicode()) {
			case 0x2744u:
				state = 58;
				continue;
			default:
				return false;
			}
		case 58:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 31:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 59;
				continue;
			default:
				return false;
			}
		case 59:
			switch(input[offset + 3].unicode()) {
			case 0x2695u:
				state = 60;
				continue;
			case 0x2696u:
				state = 61;
				continue;
			case 0x2708u:
				state = 62;
				continue;
			case 0xd83cu:
				state = 63;
				continue;
			case 0xd83du:
				state = 64;
				continue;
			case 0xd83eu:
				state = 65;
				continue;
			default:
				return false;
			}
		case 60:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 61:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 62:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 63:
			switch(input[offset + 4].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 64:
			switch(input[offset + 4].unicode()) {
			case 0xdc66u:
			case 0xdc67u:
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 65:
			switch(input[offset + 4].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 32:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 66;
				continue;
			default:
				return false;
			}
		case 66:
			switch(input[offset + 3].unicode()) {
			case 0x2695u:
				state = 67;
				continue;
			case 0x2696u:
				state = 68;
				continue;
			case 0x2708u:
				state = 69;
				continue;
			case 0xd83cu:
				state = 70;
				continue;
			case 0xd83du:
				state = 71;
				continue;
			case 0xd83eu:
				state = 72;
				continue;
			default:
				return false;
			}
		case 67:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 68:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 69:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 70:
			switch(input[offset + 4].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 71:
			switch(input[offset + 4].unicode()) {
			case 0xdc66u:
			case 0xdc67u:
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 72:
			switch(input[offset + 4].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 33:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 73;
				continue;
			default:
				return false;
			}
		case 73:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 74;
				continue;
			case 0x2642u:
				state = 75;
				continue;
			default:
				return false;
			}
		case 74:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 75:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 34:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 76;
				continue;
			default:
				return false;
			}
		case 76:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 77;
				continue;
			case 0x2642u:
				state = 78;
				continue;
			default:
				return false;
			}
		case 77:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 78:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 35:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 79;
				continue;
			default:
				return false;
			}
		case 79:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 80;
				continue;
			case 0x2642u:
				state = 81;
				continue;
			default:
				return false;
			}
		case 80:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 81:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 36:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 82;
				continue;
			default:
				return false;
			}
		case 82:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 83;
				continue;
			case 0x2642u:
				state = 84;
				continue;
			default:
				return false;
			}
		case 83:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 84:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 37:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 85;
				continue;
			default:
				return false;
			}
		case 85:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 86;
				continue;
			case 0x2642u:
				state = 87;
				continue;
			default:
				return false;
			}
		case 86:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 87:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 38:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 88;
				continue;
			default:
				return false;
			}
		case 88:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 89;
				continue;
			case 0x2642u:
				state = 90;
				continue;
			default:
				return false;
			}
		case 89:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 90:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 39:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 91;
				continue;
			default:
				return false;
			}
		case 91:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 92;
				continue;
			case 0x2642u:
				state = 93;
				continue;
			default:
				return false;
			}
		case 92:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 93:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 40:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 94;
				continue;
			default:
				return false;
			}
		case 94:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 95;
				continue;
			case 0x2642u:
				state = 96;
				continue;
			default:
				return false;
			}
		case 95:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 96:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 41:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 97;
				continue;
			default:
				return false;
			}
		case 97:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 98;
				continue;
			case 0x2642u:
				state = 99;
				continue;
			default:
				return false;
			}
		case 98:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 99:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 42:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 100;
				continue;
			default:
				return false;
			}
		case 100:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 101;
				continue;
			case 0x2642u:
				state = 102;
				continue;
			default:
				return false;
			}
		case 101:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 102:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 43:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 103;
				continue;
			default:
				return false;
			}
		case 103:
			switch(input[offset + 3].unicode()) {
			case 0xd83du:
				state = 104;
				continue;
			default:
				return false;
			}
		case 104:
			switch(input[offset + 4].unicode()) {
			case 0xdca8u:
				return true;
			default:
				return false;
			}
		case 44:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 105;
				continue;
			default:
				return false;
			}
		case 105:
			switch(input[offset + 3].unicode()) {
			case 0xd83du:
				state = 106;
				continue;
			default:
				return false;
			}
		case 106:
			switch(input[offset + 4].unicode()) {
			case 0xdcabu:
				return true;
			default:
				return false;
			}
		case 45:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 107;
				continue;
			default:
				return false;
			}
		case 107:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 108;
				continue;
			case 0x2642u:
				state = 109;
				continue;
			default:
				return false;
			}
		case 108:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 109:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 46:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 110;
				continue;
			default:
				return false;
			}
		case 110:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 111;
				continue;
			case 0x2642u:
				state = 112;
				continue;
			default:
				return false;
			}
		case 111:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 112:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 47:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 113;
				continue;
			default:
				return false;
			}
		case 113:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 114;
				continue;
			case 0x2642u:
				state = 115;
				continue;
			default:
				return false;
			}
		case 114:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 115:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 48:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 116;
				continue;
			default:
				return false;
			}
		case 116:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 117;
				continue;
			case 0x2642u:
				state = 118;
				continue;
			default:
				return false;
			}
		case 117:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 118:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 49:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 119;
				continue;
			default:
				return false;
			}
		case 119:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 120;
				continue;
			case 0x2642u:
				state = 121;
				continue;
			default:
				return false;
			}
		case 120:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 121:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 50:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 122;
				continue;
			default:
				return false;
			}
		case 122:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 123;
				continue;
			case 0x2642u:
				state = 124;
				continue;
			default:
				return false;
			}
		case 123:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 124:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 51:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 125;
				continue;
			default:
				return false;
			}
		case 125:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 126;
				continue;
			case 0x2642u:
				state = 127;
				continue;
			default:
				return false;
			}
		case 126:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 127:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 52:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 128;
				continue;
			default:
				return false;
			}
		case 128:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 129;
				continue;
			case 0x2642u:
				state = 130;
				continue;
			default:
				return false;
			}
		case 129:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 130:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 53:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 131;
				continue;
			default:
				return false;
			}
		case 131:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 132;
				continue;
			case 0x2642u:
				state = 133;
				continue;
			default:
				return false;
			}
		case 132:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 133:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 54:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 134;
				continue;
			default:
				return false;
			}
		case 134:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 135;
				continue;
			case 0x2642u:
				state = 136;
				continue;
			default:
				return false;
			}
		case 135:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 136:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 5:
			switch(input[offset + 1].unicode()) {
			case 0xdd26u:
				state = 137;
				continue;
			case 0xdd35u:
				state = 138;
				continue;
			case 0xdd37u:
				state = 139;
				continue;
			case 0xdd38u:
				state = 140;
				continue;
			case 0xdd39u:
				state = 141;
				continue;
			case 0xdd3cu:
				state = 142;
				continue;
			case 0xdd3du:
				state = 143;
				continue;
			case 0xdd3eu:
				state = 144;
				continue;
			case 0xddb8u:
				state = 145;
				continue;
			case 0xddb9u:
				state = 146;
				continue;
			case 0xddcdu:
				state = 147;
				continue;
			case 0xddceu:
				state = 148;
				continue;
			case 0xddcfu:
				state = 149;
				continue;
			case 0xddd1u:
				state = 150;
				continue;
			case 0xddd4u:
				state = 151;
				continue;
			case 0xddd6u:
				state = 152;
				continue;
			case 0xddd7u:
				state = 153;
				continue;
			case 0xddd8u:
				state = 154;
				continue;
			case 0xddd9u:
				state = 155;
				continue;
			case 0xdddau:
				state = 156;
				continue;
			case 0xdddbu:
				state = 157;
				continue;
			case 0xdddcu:
				state = 158;
				continue;
			case 0xddddu:
				state = 159;
				continue;
			case 0xdddeu:
				state = 160;
				continue;
			case 0xdddfu:
				state = 161;
				continue;
			default:
				return false;
			}
		case 137:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 162;
				continue;
			default:
				return false;
			}
		case 162:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 163;
				continue;
			case 0x2642u:
				state = 164;
				continue;
			default:
				return false;
			}
		case 163:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 164:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 138:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 165;
				continue;
			default:
				return false;
			}
		case 165:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 166;
				continue;
			case 0x2642u:
				state = 167;
				continue;
			default:
				return false;
			}
		case 166:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 167:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 139:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 168;
				continue;
			default:
				return false;
			}
		case 168:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 169;
				continue;
			case 0x2642u:
				state = 170;
				continue;
			default:
				return false;
			}
		case 169:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 170:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 140:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 171;
				continue;
			default:
				return false;
			}
		case 171:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 172;
				continue;
			case 0x2642u:
				state = 173;
				continue;
			default:
				return false;
			}
		case 172:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 173:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 141:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 174;
				continue;
			default:
				return false;
			}
		case 174:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 175;
				continue;
			case 0x2642u:
				state = 176;
				continue;
			default:
				return false;
			}
		case 175:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 176:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 142:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 177;
				continue;
			default:
				return false;
			}
		case 177:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 178;
				continue;
			case 0x2642u:
				state = 179;
				continue;
			default:
				return false;
			}
		case 178:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 179:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 143:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 180;
				continue;
			default:
				return false;
			}
		case 180:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 181;
				continue;
			case 0x2642u:
				state = 182;
				continue;
			default:
				return false;
			}
		case 181:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 182:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 144:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 183;
				continue;
			default:
				return false;
			}
		case 183:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 184;
				continue;
			case 0x2642u:
				state = 185;
				continue;
			default:
				return false;
			}
		case 184:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 185:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 145:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 186;
				continue;
			default:
				return false;
			}
		case 186:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 187;
				continue;
			case 0x2642u:
				state = 188;
				continue;
			default:
				return false;
			}
		case 187:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 188:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 146:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 189;
				continue;
			default:
				return false;
			}
		case 189:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 190;
				continue;
			case 0x2642u:
				state = 191;
				continue;
			default:
				return false;
			}
		case 190:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 191:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 147:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 192;
				continue;
			default:
				return false;
			}
		case 192:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 193;
				continue;
			case 0x2642u:
				state = 194;
				continue;
			default:
				return false;
			}
		case 193:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 194:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 148:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 195;
				continue;
			default:
				return false;
			}
		case 195:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 196;
				continue;
			case 0x2642u:
				state = 197;
				continue;
			default:
				return false;
			}
		case 196:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 197:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 149:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 198;
				continue;
			default:
				return false;
			}
		case 198:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 199;
				continue;
			case 0x2642u:
				state = 200;
				continue;
			default:
				return false;
			}
		case 199:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 200:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 150:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 201;
				continue;
			default:
				return false;
			}
		case 201:
			switch(input[offset + 3].unicode()) {
			case 0x2695u:
				state = 202;
				continue;
			case 0x2696u:
				state = 203;
				continue;
			case 0x2708u:
				state = 204;
				continue;
			case 0xd83cu:
				state = 205;
				continue;
			case 0xd83du:
				state = 206;
				continue;
			case 0xd83eu:
				state = 207;
				continue;
			default:
				return false;
			}
		case 202:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 203:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 204:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 205:
			switch(input[offset + 4].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf84u:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 206:
			switch(input[offset + 4].unicode()) {
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 207:
			switch(input[offset + 4].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 151:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 208;
				continue;
			default:
				return false;
			}
		case 208:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 209;
				continue;
			case 0x2642u:
				state = 210;
				continue;
			default:
				return false;
			}
		case 209:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 210:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 152:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 211;
				continue;
			default:
				return false;
			}
		case 211:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 212;
				continue;
			case 0x2642u:
				state = 213;
				continue;
			default:
				return false;
			}
		case 212:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 213:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 153:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 214;
				continue;
			default:
				return false;
			}
		case 214:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 215;
				continue;
			case 0x2642u:
				state = 216;
				continue;
			default:
				return false;
			}
		case 215:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 216:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 154:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 217;
				continue;
			default:
				return false;
			}
		case 217:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 218;
				continue;
			case 0x2642u:
				state = 219;
				continue;
			default:
				return false;
			}
		case 218:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 219:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 155:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 220;
				continue;
			default:
				return false;
			}
		case 220:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 221;
				continue;
			case 0x2642u:
				state = 222;
				continue;
			default:
				return false;
			}
		case 221:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 222:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 156:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 223;
				continue;
			default:
				return false;
			}
		case 223:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 224;
				continue;
			case 0x2642u:
				state = 225;
				continue;
			default:
				return false;
			}
		case 224:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 225:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 157:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 226;
				continue;
			default:
				return false;
			}
		case 226:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 227;
				continue;
			case 0x2642u:
				state = 228;
				continue;
			default:
				return false;
			}
		case 227:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 228:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 158:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 229;
				continue;
			default:
				return false;
			}
		case 229:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 230;
				continue;
			case 0x2642u:
				state = 231;
				continue;
			default:
				return false;
			}
		case 230:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 231:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 159:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 232;
				continue;
			default:
				return false;
			}
		case 232:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 233;
				continue;
			case 0x2642u:
				state = 234;
				continue;
			default:
				return false;
			}
		case 233:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 234:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 160:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 235;
				continue;
			default:
				return false;
			}
		case 235:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 236;
				continue;
			case 0x2642u:
				state = 237;
				continue;
			default:
				return false;
			}
		case 236:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 237:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 161:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 238;
				continue;
			default:
				return false;
			}
		case 238:
			switch(input[offset + 3].unicode()) {
			case 0x2640u:
				state = 239;
				continue;
			case 0x2642u:
				state = 240;
				continue;
			default:
				return false;
			}
		case 239:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 240:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		default:
			Q_ASSERT_X(false, "emojiMatch5", "Invalid state");
			return false;
		}
	}
}

static bool emojiMatch6(const QString &input, int offset)
{
	int state = 0;
	while(true) {
		switch(state) {
		case 0:
			switch(input[offset + 0].unicode()) {
			case 0x26f9u:
				state = 1;
				continue;
			case 0xd83cu:
				state = 2;
				continue;
			case 0xd83du:
				state = 3;
				continue;
			default:
				return false;
			}
		case 1:
			switch(input[offset + 1].unicode()) {
			case 0xd83cu:
				state = 4;
				continue;
			default:
				return false;
			}
		case 4:
			switch(input[offset + 2].unicode()) {
			case 0xdffbu:
				state = 5;
				continue;
			case 0xdffcu:
				state = 6;
				continue;
			case 0xdffdu:
				state = 7;
				continue;
			case 0xdffeu:
				state = 8;
				continue;
			case 0xdfffu:
				state = 9;
				continue;
			default:
				return false;
			}
		case 5:
			switch(input[offset + 3].unicode()) {
			case 0x200du:
				state = 10;
				continue;
			default:
				return false;
			}
		case 10:
			switch(input[offset + 4].unicode()) {
			case 0x2640u:
				state = 11;
				continue;
			case 0x2642u:
				state = 12;
				continue;
			default:
				return false;
			}
		case 11:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 12:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 6:
			switch(input[offset + 3].unicode()) {
			case 0x200du:
				state = 13;
				continue;
			default:
				return false;
			}
		case 13:
			switch(input[offset + 4].unicode()) {
			case 0x2640u:
				state = 14;
				continue;
			case 0x2642u:
				state = 15;
				continue;
			default:
				return false;
			}
		case 14:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 15:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 7:
			switch(input[offset + 3].unicode()) {
			case 0x200du:
				state = 16;
				continue;
			default:
				return false;
			}
		case 16:
			switch(input[offset + 4].unicode()) {
			case 0x2640u:
				state = 17;
				continue;
			case 0x2642u:
				state = 18;
				continue;
			default:
				return false;
			}
		case 17:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 18:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 8:
			switch(input[offset + 3].unicode()) {
			case 0x200du:
				state = 19;
				continue;
			default:
				return false;
			}
		case 19:
			switch(input[offset + 4].unicode()) {
			case 0x2640u:
				state = 20;
				continue;
			case 0x2642u:
				state = 21;
				continue;
			default:
				return false;
			}
		case 20:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 21:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 9:
			switch(input[offset + 3].unicode()) {
			case 0x200du:
				state = 22;
				continue;
			default:
				return false;
			}
		case 22:
			switch(input[offset + 4].unicode()) {
			case 0x2640u:
				state = 23;
				continue;
			case 0x2642u:
				state = 24;
				continue;
			default:
				return false;
			}
		case 23:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 24:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 2:
			switch(input[offset + 1].unicode()) {
			case 0xdfcbu:
				state = 25;
				continue;
			case 0xdfccu:
				state = 26;
				continue;
			case 0xdff3u:
				state = 27;
				continue;
			default:
				return false;
			}
		case 25:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				state = 28;
				continue;
			default:
				return false;
			}
		case 28:
			switch(input[offset + 3].unicode()) {
			case 0x200du:
				state = 29;
				continue;
			default:
				return false;
			}
		case 29:
			switch(input[offset + 4].unicode()) {
			case 0x2640u:
				state = 30;
				continue;
			case 0x2642u:
				state = 31;
				continue;
			default:
				return false;
			}
		case 30:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 31:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 26:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				state = 32;
				continue;
			default:
				return false;
			}
		case 32:
			switch(input[offset + 3].unicode()) {
			case 0x200du:
				state = 33;
				continue;
			default:
				return false;
			}
		case 33:
			switch(input[offset + 4].unicode()) {
			case 0x2640u:
				state = 34;
				continue;
			case 0x2642u:
				state = 35;
				continue;
			default:
				return false;
			}
		case 34:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 35:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 27:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				state = 36;
				continue;
			default:
				return false;
			}
		case 36:
			switch(input[offset + 3].unicode()) {
			case 0x200du:
				state = 37;
				continue;
			default:
				return false;
			}
		case 37:
			switch(input[offset + 4].unicode()) {
			case 0x26a7u:
				state = 38;
				continue;
			case 0xd83cu:
				state = 39;
				continue;
			default:
				return false;
			}
		case 38:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 39:
			switch(input[offset + 5].unicode()) {
			case 0xdf08u:
				return true;
			default:
				return false;
			}
		case 3:
			switch(input[offset + 1].unicode()) {
			case 0xdd75u:
				state = 40;
				continue;
			case 0xde36u:
				state = 41;
				continue;
			default:
				return false;
			}
		case 40:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				state = 42;
				continue;
			default:
				return false;
			}
		case 42:
			switch(input[offset + 3].unicode()) {
			case 0x200du:
				state = 43;
				continue;
			default:
				return false;
			}
		case 43:
			switch(input[offset + 4].unicode()) {
			case 0x2640u:
				state = 44;
				continue;
			case 0x2642u:
				state = 45;
				continue;
			default:
				return false;
			}
		case 44:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 45:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 41:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 46;
				continue;
			default:
				return false;
			}
		case 46:
			switch(input[offset + 3].unicode()) {
			case 0xd83cu:
				state = 47;
				continue;
			default:
				return false;
			}
		case 47:
			switch(input[offset + 4].unicode()) {
			case 0xdf2bu:
				state = 48;
				continue;
			default:
				return false;
			}
		case 48:
			switch(input[offset + 5].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		default:
			Q_ASSERT_X(false, "emojiMatch6", "Invalid state");
			return false;
		}
	}
}

static bool emojiMatch7(const QString &input, int offset)
{
	int state = 0;
	while(true) {
		switch(state) {
		case 0:
			switch(input[offset + 0].unicode()) {
			case 0xd83cu:
				state = 1;
				continue;
			case 0xd83du:
				state = 2;
				continue;
			case 0xd83eu:
				state = 3;
				continue;
			default:
				return false;
			}
		case 1:
			switch(input[offset + 1].unicode()) {
			case 0xdfc3u:
				state = 4;
				continue;
			case 0xdfc4u:
				state = 5;
				continue;
			case 0xdfcau:
				state = 6;
				continue;
			case 0xdfcbu:
				state = 7;
				continue;
			case 0xdfccu:
				state = 8;
				continue;
			default:
				return false;
			}
		case 4:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 9;
				continue;
			default:
				return false;
			}
		case 9:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 10;
				continue;
			case 0xdffcu:
				state = 11;
				continue;
			case 0xdffdu:
				state = 12;
				continue;
			case 0xdffeu:
				state = 13;
				continue;
			case 0xdfffu:
				state = 14;
				continue;
			default:
				return false;
			}
		case 10:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 15;
				continue;
			default:
				return false;
			}
		case 15:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 16;
				continue;
			case 0x2642u:
				state = 17;
				continue;
			default:
				return false;
			}
		case 16:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 17:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 11:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 18;
				continue;
			default:
				return false;
			}
		case 18:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 19;
				continue;
			case 0x2642u:
				state = 20;
				continue;
			default:
				return false;
			}
		case 19:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 20:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 12:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 21;
				continue;
			default:
				return false;
			}
		case 21:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 22;
				continue;
			case 0x2642u:
				state = 23;
				continue;
			default:
				return false;
			}
		case 22:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 23:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 13:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 24;
				continue;
			default:
				return false;
			}
		case 24:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 25;
				continue;
			case 0x2642u:
				state = 26;
				continue;
			default:
				return false;
			}
		case 25:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 26:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 14:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 27;
				continue;
			default:
				return false;
			}
		case 27:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 28;
				continue;
			case 0x2642u:
				state = 29;
				continue;
			default:
				return false;
			}
		case 28:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 29:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 5:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 30;
				continue;
			default:
				return false;
			}
		case 30:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 31;
				continue;
			case 0xdffcu:
				state = 32;
				continue;
			case 0xdffdu:
				state = 33;
				continue;
			case 0xdffeu:
				state = 34;
				continue;
			case 0xdfffu:
				state = 35;
				continue;
			default:
				return false;
			}
		case 31:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 36;
				continue;
			default:
				return false;
			}
		case 36:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 37;
				continue;
			case 0x2642u:
				state = 38;
				continue;
			default:
				return false;
			}
		case 37:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 38:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 32:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 39;
				continue;
			default:
				return false;
			}
		case 39:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 40;
				continue;
			case 0x2642u:
				state = 41;
				continue;
			default:
				return false;
			}
		case 40:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 41:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 33:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 42;
				continue;
			default:
				return false;
			}
		case 42:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 43;
				continue;
			case 0x2642u:
				state = 44;
				continue;
			default:
				return false;
			}
		case 43:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 44:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 34:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 45;
				continue;
			default:
				return false;
			}
		case 45:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 46;
				continue;
			case 0x2642u:
				state = 47;
				continue;
			default:
				return false;
			}
		case 46:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 47:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 35:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 48;
				continue;
			default:
				return false;
			}
		case 48:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 49;
				continue;
			case 0x2642u:
				state = 50;
				continue;
			default:
				return false;
			}
		case 49:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 50:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 6:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 51;
				continue;
			default:
				return false;
			}
		case 51:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 52;
				continue;
			case 0xdffcu:
				state = 53;
				continue;
			case 0xdffdu:
				state = 54;
				continue;
			case 0xdffeu:
				state = 55;
				continue;
			case 0xdfffu:
				state = 56;
				continue;
			default:
				return false;
			}
		case 52:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 57;
				continue;
			default:
				return false;
			}
		case 57:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 58;
				continue;
			case 0x2642u:
				state = 59;
				continue;
			default:
				return false;
			}
		case 58:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 59:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 53:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 60;
				continue;
			default:
				return false;
			}
		case 60:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 61;
				continue;
			case 0x2642u:
				state = 62;
				continue;
			default:
				return false;
			}
		case 61:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 62:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 54:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 63;
				continue;
			default:
				return false;
			}
		case 63:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 64;
				continue;
			case 0x2642u:
				state = 65;
				continue;
			default:
				return false;
			}
		case 64:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 65:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 55:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 66;
				continue;
			default:
				return false;
			}
		case 66:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 67;
				continue;
			case 0x2642u:
				state = 68;
				continue;
			default:
				return false;
			}
		case 67:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 68:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 56:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 69;
				continue;
			default:
				return false;
			}
		case 69:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 70;
				continue;
			case 0x2642u:
				state = 71;
				continue;
			default:
				return false;
			}
		case 70:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 71:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 7:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 72;
				continue;
			default:
				return false;
			}
		case 72:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 73;
				continue;
			case 0xdffcu:
				state = 74;
				continue;
			case 0xdffdu:
				state = 75;
				continue;
			case 0xdffeu:
				state = 76;
				continue;
			case 0xdfffu:
				state = 77;
				continue;
			default:
				return false;
			}
		case 73:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 78;
				continue;
			default:
				return false;
			}
		case 78:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 79;
				continue;
			case 0x2642u:
				state = 80;
				continue;
			default:
				return false;
			}
		case 79:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 80:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 74:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 81;
				continue;
			default:
				return false;
			}
		case 81:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 82;
				continue;
			case 0x2642u:
				state = 83;
				continue;
			default:
				return false;
			}
		case 82:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 83:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 75:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 84;
				continue;
			default:
				return false;
			}
		case 84:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 85;
				continue;
			case 0x2642u:
				state = 86;
				continue;
			default:
				return false;
			}
		case 85:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 86:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 76:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 87;
				continue;
			default:
				return false;
			}
		case 87:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 88;
				continue;
			case 0x2642u:
				state = 89;
				continue;
			default:
				return false;
			}
		case 88:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 89:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 77:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 90;
				continue;
			default:
				return false;
			}
		case 90:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 91;
				continue;
			case 0x2642u:
				state = 92;
				continue;
			default:
				return false;
			}
		case 91:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 92:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 8:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 93;
				continue;
			default:
				return false;
			}
		case 93:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 94;
				continue;
			case 0xdffcu:
				state = 95;
				continue;
			case 0xdffdu:
				state = 96;
				continue;
			case 0xdffeu:
				state = 97;
				continue;
			case 0xdfffu:
				state = 98;
				continue;
			default:
				return false;
			}
		case 94:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 99;
				continue;
			default:
				return false;
			}
		case 99:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 100;
				continue;
			case 0x2642u:
				state = 101;
				continue;
			default:
				return false;
			}
		case 100:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 101:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 95:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 102;
				continue;
			default:
				return false;
			}
		case 102:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 103;
				continue;
			case 0x2642u:
				state = 104;
				continue;
			default:
				return false;
			}
		case 103:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 104:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 96:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 105;
				continue;
			default:
				return false;
			}
		case 105:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 106;
				continue;
			case 0x2642u:
				state = 107;
				continue;
			default:
				return false;
			}
		case 106:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 107:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 97:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 108;
				continue;
			default:
				return false;
			}
		case 108:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 109;
				continue;
			case 0x2642u:
				state = 110;
				continue;
			default:
				return false;
			}
		case 109:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 110:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 98:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 111;
				continue;
			default:
				return false;
			}
		case 111:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 112;
				continue;
			case 0x2642u:
				state = 113;
				continue;
			default:
				return false;
			}
		case 112:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 113:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 2:
			switch(input[offset + 1].unicode()) {
			case 0xdc41u:
				state = 114;
				continue;
			case 0xdc68u:
				state = 115;
				continue;
			case 0xdc69u:
				state = 116;
				continue;
			case 0xdc6eu:
				state = 117;
				continue;
			case 0xdc70u:
				state = 118;
				continue;
			case 0xdc71u:
				state = 119;
				continue;
			case 0xdc73u:
				state = 120;
				continue;
			case 0xdc77u:
				state = 121;
				continue;
			case 0xdc81u:
				state = 122;
				continue;
			case 0xdc82u:
				state = 123;
				continue;
			case 0xdc86u:
				state = 124;
				continue;
			case 0xdc87u:
				state = 125;
				continue;
			case 0xdd75u:
				state = 126;
				continue;
			case 0xde45u:
				state = 127;
				continue;
			case 0xde46u:
				state = 128;
				continue;
			case 0xde47u:
				state = 129;
				continue;
			case 0xde4bu:
				state = 130;
				continue;
			case 0xde4du:
				state = 131;
				continue;
			case 0xde4eu:
				state = 132;
				continue;
			case 0xdea3u:
				state = 133;
				continue;
			case 0xdeb4u:
				state = 134;
				continue;
			case 0xdeb5u:
				state = 135;
				continue;
			case 0xdeb6u:
				state = 136;
				continue;
			default:
				return false;
			}
		case 114:
			switch(input[offset + 2].unicode()) {
			case 0xfe0fu:
				state = 137;
				continue;
			default:
				return false;
			}
		case 137:
			switch(input[offset + 3].unicode()) {
			case 0x200du:
				state = 138;
				continue;
			default:
				return false;
			}
		case 138:
			switch(input[offset + 4].unicode()) {
			case 0xd83du:
				state = 139;
				continue;
			default:
				return false;
			}
		case 139:
			switch(input[offset + 5].unicode()) {
			case 0xdde8u:
				state = 140;
				continue;
			default:
				return false;
			}
		case 140:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 115:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 141;
				continue;
			default:
				return false;
			}
		case 141:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 142;
				continue;
			case 0xdffcu:
				state = 143;
				continue;
			case 0xdffdu:
				state = 144;
				continue;
			case 0xdffeu:
				state = 145;
				continue;
			case 0xdfffu:
				state = 146;
				continue;
			default:
				return false;
			}
		case 142:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 147;
				continue;
			default:
				return false;
			}
		case 147:
			switch(input[offset + 5].unicode()) {
			case 0x2695u:
				state = 148;
				continue;
			case 0x2696u:
				state = 149;
				continue;
			case 0x2708u:
				state = 150;
				continue;
			case 0xd83cu:
				state = 151;
				continue;
			case 0xd83du:
				state = 152;
				continue;
			case 0xd83eu:
				state = 153;
				continue;
			default:
				return false;
			}
		case 148:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 149:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 150:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 151:
			switch(input[offset + 6].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 152:
			switch(input[offset + 6].unicode()) {
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 153:
			switch(input[offset + 6].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 143:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 154;
				continue;
			default:
				return false;
			}
		case 154:
			switch(input[offset + 5].unicode()) {
			case 0x2695u:
				state = 155;
				continue;
			case 0x2696u:
				state = 156;
				continue;
			case 0x2708u:
				state = 157;
				continue;
			case 0xd83cu:
				state = 158;
				continue;
			case 0xd83du:
				state = 159;
				continue;
			case 0xd83eu:
				state = 160;
				continue;
			default:
				return false;
			}
		case 155:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 156:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 157:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 158:
			switch(input[offset + 6].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 159:
			switch(input[offset + 6].unicode()) {
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 160:
			switch(input[offset + 6].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 144:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 161;
				continue;
			default:
				return false;
			}
		case 161:
			switch(input[offset + 5].unicode()) {
			case 0x2695u:
				state = 162;
				continue;
			case 0x2696u:
				state = 163;
				continue;
			case 0x2708u:
				state = 164;
				continue;
			case 0xd83cu:
				state = 165;
				continue;
			case 0xd83du:
				state = 166;
				continue;
			case 0xd83eu:
				state = 167;
				continue;
			default:
				return false;
			}
		case 162:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 163:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 164:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 165:
			switch(input[offset + 6].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 166:
			switch(input[offset + 6].unicode()) {
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 167:
			switch(input[offset + 6].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 145:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 168;
				continue;
			default:
				return false;
			}
		case 168:
			switch(input[offset + 5].unicode()) {
			case 0x2695u:
				state = 169;
				continue;
			case 0x2696u:
				state = 170;
				continue;
			case 0x2708u:
				state = 171;
				continue;
			case 0xd83cu:
				state = 172;
				continue;
			case 0xd83du:
				state = 173;
				continue;
			case 0xd83eu:
				state = 174;
				continue;
			default:
				return false;
			}
		case 169:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 170:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 171:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 172:
			switch(input[offset + 6].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 173:
			switch(input[offset + 6].unicode()) {
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 174:
			switch(input[offset + 6].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 146:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 175;
				continue;
			default:
				return false;
			}
		case 175:
			switch(input[offset + 5].unicode()) {
			case 0x2695u:
				state = 176;
				continue;
			case 0x2696u:
				state = 177;
				continue;
			case 0x2708u:
				state = 178;
				continue;
			case 0xd83cu:
				state = 179;
				continue;
			case 0xd83du:
				state = 180;
				continue;
			case 0xd83eu:
				state = 181;
				continue;
			default:
				return false;
			}
		case 176:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 177:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 178:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 179:
			switch(input[offset + 6].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 180:
			switch(input[offset + 6].unicode()) {
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 181:
			switch(input[offset + 6].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 116:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 182;
				continue;
			default:
				return false;
			}
		case 182:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 183;
				continue;
			case 0xdffcu:
				state = 184;
				continue;
			case 0xdffdu:
				state = 185;
				continue;
			case 0xdffeu:
				state = 186;
				continue;
			case 0xdfffu:
				state = 187;
				continue;
			default:
				return false;
			}
		case 183:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 188;
				continue;
			default:
				return false;
			}
		case 188:
			switch(input[offset + 5].unicode()) {
			case 0x2695u:
				state = 189;
				continue;
			case 0x2696u:
				state = 190;
				continue;
			case 0x2708u:
				state = 191;
				continue;
			case 0xd83cu:
				state = 192;
				continue;
			case 0xd83du:
				state = 193;
				continue;
			case 0xd83eu:
				state = 194;
				continue;
			default:
				return false;
			}
		case 189:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 190:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 191:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 192:
			switch(input[offset + 6].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 193:
			switch(input[offset + 6].unicode()) {
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 194:
			switch(input[offset + 6].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 184:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 195;
				continue;
			default:
				return false;
			}
		case 195:
			switch(input[offset + 5].unicode()) {
			case 0x2695u:
				state = 196;
				continue;
			case 0x2696u:
				state = 197;
				continue;
			case 0x2708u:
				state = 198;
				continue;
			case 0xd83cu:
				state = 199;
				continue;
			case 0xd83du:
				state = 200;
				continue;
			case 0xd83eu:
				state = 201;
				continue;
			default:
				return false;
			}
		case 196:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 197:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 198:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 199:
			switch(input[offset + 6].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 200:
			switch(input[offset + 6].unicode()) {
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 201:
			switch(input[offset + 6].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 185:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 202;
				continue;
			default:
				return false;
			}
		case 202:
			switch(input[offset + 5].unicode()) {
			case 0x2695u:
				state = 203;
				continue;
			case 0x2696u:
				state = 204;
				continue;
			case 0x2708u:
				state = 205;
				continue;
			case 0xd83cu:
				state = 206;
				continue;
			case 0xd83du:
				state = 207;
				continue;
			case 0xd83eu:
				state = 208;
				continue;
			default:
				return false;
			}
		case 203:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 204:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 205:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 206:
			switch(input[offset + 6].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 207:
			switch(input[offset + 6].unicode()) {
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 208:
			switch(input[offset + 6].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 186:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 209;
				continue;
			default:
				return false;
			}
		case 209:
			switch(input[offset + 5].unicode()) {
			case 0x2695u:
				state = 210;
				continue;
			case 0x2696u:
				state = 211;
				continue;
			case 0x2708u:
				state = 212;
				continue;
			case 0xd83cu:
				state = 213;
				continue;
			case 0xd83du:
				state = 214;
				continue;
			case 0xd83eu:
				state = 215;
				continue;
			default:
				return false;
			}
		case 210:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 211:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 212:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 213:
			switch(input[offset + 6].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 214:
			switch(input[offset + 6].unicode()) {
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 215:
			switch(input[offset + 6].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 187:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 216;
				continue;
			default:
				return false;
			}
		case 216:
			switch(input[offset + 5].unicode()) {
			case 0x2695u:
				state = 217;
				continue;
			case 0x2696u:
				state = 218;
				continue;
			case 0x2708u:
				state = 219;
				continue;
			case 0xd83cu:
				state = 220;
				continue;
			case 0xd83du:
				state = 221;
				continue;
			case 0xd83eu:
				state = 222;
				continue;
			default:
				return false;
			}
		case 217:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 218:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 219:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 220:
			switch(input[offset + 6].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 221:
			switch(input[offset + 6].unicode()) {
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 222:
			switch(input[offset + 6].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 117:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 223;
				continue;
			default:
				return false;
			}
		case 223:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 224;
				continue;
			case 0xdffcu:
				state = 225;
				continue;
			case 0xdffdu:
				state = 226;
				continue;
			case 0xdffeu:
				state = 227;
				continue;
			case 0xdfffu:
				state = 228;
				continue;
			default:
				return false;
			}
		case 224:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 229;
				continue;
			default:
				return false;
			}
		case 229:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 230;
				continue;
			case 0x2642u:
				state = 231;
				continue;
			default:
				return false;
			}
		case 230:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 231:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 225:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 232;
				continue;
			default:
				return false;
			}
		case 232:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 233;
				continue;
			case 0x2642u:
				state = 234;
				continue;
			default:
				return false;
			}
		case 233:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 234:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 226:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 235;
				continue;
			default:
				return false;
			}
		case 235:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 236;
				continue;
			case 0x2642u:
				state = 237;
				continue;
			default:
				return false;
			}
		case 236:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 237:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 227:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 238;
				continue;
			default:
				return false;
			}
		case 238:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 239;
				continue;
			case 0x2642u:
				state = 240;
				continue;
			default:
				return false;
			}
		case 239:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 240:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 228:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 241;
				continue;
			default:
				return false;
			}
		case 241:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 242;
				continue;
			case 0x2642u:
				state = 243;
				continue;
			default:
				return false;
			}
		case 242:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 243:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 118:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 244;
				continue;
			default:
				return false;
			}
		case 244:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 245;
				continue;
			case 0xdffcu:
				state = 246;
				continue;
			case 0xdffdu:
				state = 247;
				continue;
			case 0xdffeu:
				state = 248;
				continue;
			case 0xdfffu:
				state = 249;
				continue;
			default:
				return false;
			}
		case 245:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 250;
				continue;
			default:
				return false;
			}
		case 250:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 251;
				continue;
			case 0x2642u:
				state = 252;
				continue;
			default:
				return false;
			}
		case 251:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 252:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 246:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 253;
				continue;
			default:
				return false;
			}
		case 253:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 254;
				continue;
			case 0x2642u:
				state = 255;
				continue;
			default:
				return false;
			}
		case 254:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 255:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 247:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 256;
				continue;
			default:
				return false;
			}
		case 256:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 257;
				continue;
			case 0x2642u:
				state = 258;
				continue;
			default:
				return false;
			}
		case 257:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 258:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 248:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 259;
				continue;
			default:
				return false;
			}
		case 259:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 260;
				continue;
			case 0x2642u:
				state = 261;
				continue;
			default:
				return false;
			}
		case 260:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 261:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 249:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 262;
				continue;
			default:
				return false;
			}
		case 262:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 263;
				continue;
			case 0x2642u:
				state = 264;
				continue;
			default:
				return false;
			}
		case 263:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 264:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 119:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 265;
				continue;
			default:
				return false;
			}
		case 265:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 266;
				continue;
			case 0xdffcu:
				state = 267;
				continue;
			case 0xdffdu:
				state = 268;
				continue;
			case 0xdffeu:
				state = 269;
				continue;
			case 0xdfffu:
				state = 270;
				continue;
			default:
				return false;
			}
		case 266:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 271;
				continue;
			default:
				return false;
			}
		case 271:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 272;
				continue;
			case 0x2642u:
				state = 273;
				continue;
			default:
				return false;
			}
		case 272:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 273:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 267:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 274;
				continue;
			default:
				return false;
			}
		case 274:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 275;
				continue;
			case 0x2642u:
				state = 276;
				continue;
			default:
				return false;
			}
		case 275:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 276:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 268:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 277;
				continue;
			default:
				return false;
			}
		case 277:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 278;
				continue;
			case 0x2642u:
				state = 279;
				continue;
			default:
				return false;
			}
		case 278:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 279:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 269:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 280;
				continue;
			default:
				return false;
			}
		case 280:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 281;
				continue;
			case 0x2642u:
				state = 282;
				continue;
			default:
				return false;
			}
		case 281:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 282:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 270:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 283;
				continue;
			default:
				return false;
			}
		case 283:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 284;
				continue;
			case 0x2642u:
				state = 285;
				continue;
			default:
				return false;
			}
		case 284:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 285:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 120:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 286;
				continue;
			default:
				return false;
			}
		case 286:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 287;
				continue;
			case 0xdffcu:
				state = 288;
				continue;
			case 0xdffdu:
				state = 289;
				continue;
			case 0xdffeu:
				state = 290;
				continue;
			case 0xdfffu:
				state = 291;
				continue;
			default:
				return false;
			}
		case 287:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 292;
				continue;
			default:
				return false;
			}
		case 292:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 293;
				continue;
			case 0x2642u:
				state = 294;
				continue;
			default:
				return false;
			}
		case 293:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 294:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 288:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 295;
				continue;
			default:
				return false;
			}
		case 295:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 296;
				continue;
			case 0x2642u:
				state = 297;
				continue;
			default:
				return false;
			}
		case 296:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 297:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 289:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 298;
				continue;
			default:
				return false;
			}
		case 298:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 299;
				continue;
			case 0x2642u:
				state = 300;
				continue;
			default:
				return false;
			}
		case 299:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 300:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 290:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 301;
				continue;
			default:
				return false;
			}
		case 301:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 302;
				continue;
			case 0x2642u:
				state = 303;
				continue;
			default:
				return false;
			}
		case 302:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 303:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 291:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 304;
				continue;
			default:
				return false;
			}
		case 304:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 305;
				continue;
			case 0x2642u:
				state = 306;
				continue;
			default:
				return false;
			}
		case 305:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 306:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 121:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 307;
				continue;
			default:
				return false;
			}
		case 307:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 308;
				continue;
			case 0xdffcu:
				state = 309;
				continue;
			case 0xdffdu:
				state = 310;
				continue;
			case 0xdffeu:
				state = 311;
				continue;
			case 0xdfffu:
				state = 312;
				continue;
			default:
				return false;
			}
		case 308:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 313;
				continue;
			default:
				return false;
			}
		case 313:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 314;
				continue;
			case 0x2642u:
				state = 315;
				continue;
			default:
				return false;
			}
		case 314:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 315:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 309:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 316;
				continue;
			default:
				return false;
			}
		case 316:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 317;
				continue;
			case 0x2642u:
				state = 318;
				continue;
			default:
				return false;
			}
		case 317:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 318:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 310:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 319;
				continue;
			default:
				return false;
			}
		case 319:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 320;
				continue;
			case 0x2642u:
				state = 321;
				continue;
			default:
				return false;
			}
		case 320:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 321:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 311:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 322;
				continue;
			default:
				return false;
			}
		case 322:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 323;
				continue;
			case 0x2642u:
				state = 324;
				continue;
			default:
				return false;
			}
		case 323:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 324:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 312:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 325;
				continue;
			default:
				return false;
			}
		case 325:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 326;
				continue;
			case 0x2642u:
				state = 327;
				continue;
			default:
				return false;
			}
		case 326:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 327:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 122:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 328;
				continue;
			default:
				return false;
			}
		case 328:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 329;
				continue;
			case 0xdffcu:
				state = 330;
				continue;
			case 0xdffdu:
				state = 331;
				continue;
			case 0xdffeu:
				state = 332;
				continue;
			case 0xdfffu:
				state = 333;
				continue;
			default:
				return false;
			}
		case 329:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 334;
				continue;
			default:
				return false;
			}
		case 334:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 335;
				continue;
			case 0x2642u:
				state = 336;
				continue;
			default:
				return false;
			}
		case 335:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 336:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 330:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 337;
				continue;
			default:
				return false;
			}
		case 337:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 338;
				continue;
			case 0x2642u:
				state = 339;
				continue;
			default:
				return false;
			}
		case 338:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 339:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 331:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 340;
				continue;
			default:
				return false;
			}
		case 340:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 341;
				continue;
			case 0x2642u:
				state = 342;
				continue;
			default:
				return false;
			}
		case 341:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 342:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 332:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 343;
				continue;
			default:
				return false;
			}
		case 343:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 344;
				continue;
			case 0x2642u:
				state = 345;
				continue;
			default:
				return false;
			}
		case 344:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 345:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 333:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 346;
				continue;
			default:
				return false;
			}
		case 346:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 347;
				continue;
			case 0x2642u:
				state = 348;
				continue;
			default:
				return false;
			}
		case 347:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 348:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 123:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 349;
				continue;
			default:
				return false;
			}
		case 349:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 350;
				continue;
			case 0xdffcu:
				state = 351;
				continue;
			case 0xdffdu:
				state = 352;
				continue;
			case 0xdffeu:
				state = 353;
				continue;
			case 0xdfffu:
				state = 354;
				continue;
			default:
				return false;
			}
		case 350:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 355;
				continue;
			default:
				return false;
			}
		case 355:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 356;
				continue;
			case 0x2642u:
				state = 357;
				continue;
			default:
				return false;
			}
		case 356:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 357:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 351:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 358;
				continue;
			default:
				return false;
			}
		case 358:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 359;
				continue;
			case 0x2642u:
				state = 360;
				continue;
			default:
				return false;
			}
		case 359:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 360:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 352:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 361;
				continue;
			default:
				return false;
			}
		case 361:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 362;
				continue;
			case 0x2642u:
				state = 363;
				continue;
			default:
				return false;
			}
		case 362:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 363:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 353:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 364;
				continue;
			default:
				return false;
			}
		case 364:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 365;
				continue;
			case 0x2642u:
				state = 366;
				continue;
			default:
				return false;
			}
		case 365:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 366:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 354:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 367;
				continue;
			default:
				return false;
			}
		case 367:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 368;
				continue;
			case 0x2642u:
				state = 369;
				continue;
			default:
				return false;
			}
		case 368:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 369:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 124:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 370;
				continue;
			default:
				return false;
			}
		case 370:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 371;
				continue;
			case 0xdffcu:
				state = 372;
				continue;
			case 0xdffdu:
				state = 373;
				continue;
			case 0xdffeu:
				state = 374;
				continue;
			case 0xdfffu:
				state = 375;
				continue;
			default:
				return false;
			}
		case 371:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 376;
				continue;
			default:
				return false;
			}
		case 376:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 377;
				continue;
			case 0x2642u:
				state = 378;
				continue;
			default:
				return false;
			}
		case 377:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 378:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 372:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 379;
				continue;
			default:
				return false;
			}
		case 379:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 380;
				continue;
			case 0x2642u:
				state = 381;
				continue;
			default:
				return false;
			}
		case 380:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 381:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 373:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 382;
				continue;
			default:
				return false;
			}
		case 382:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 383;
				continue;
			case 0x2642u:
				state = 384;
				continue;
			default:
				return false;
			}
		case 383:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 384:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 374:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 385;
				continue;
			default:
				return false;
			}
		case 385:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 386;
				continue;
			case 0x2642u:
				state = 387;
				continue;
			default:
				return false;
			}
		case 386:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 387:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 375:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 388;
				continue;
			default:
				return false;
			}
		case 388:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 389;
				continue;
			case 0x2642u:
				state = 390;
				continue;
			default:
				return false;
			}
		case 389:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 390:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 125:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 391;
				continue;
			default:
				return false;
			}
		case 391:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 392;
				continue;
			case 0xdffcu:
				state = 393;
				continue;
			case 0xdffdu:
				state = 394;
				continue;
			case 0xdffeu:
				state = 395;
				continue;
			case 0xdfffu:
				state = 396;
				continue;
			default:
				return false;
			}
		case 392:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 397;
				continue;
			default:
				return false;
			}
		case 397:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 398;
				continue;
			case 0x2642u:
				state = 399;
				continue;
			default:
				return false;
			}
		case 398:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 399:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 393:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 400;
				continue;
			default:
				return false;
			}
		case 400:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 401;
				continue;
			case 0x2642u:
				state = 402;
				continue;
			default:
				return false;
			}
		case 401:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 402:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 394:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 403;
				continue;
			default:
				return false;
			}
		case 403:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 404;
				continue;
			case 0x2642u:
				state = 405;
				continue;
			default:
				return false;
			}
		case 404:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 405:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 395:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 406;
				continue;
			default:
				return false;
			}
		case 406:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 407;
				continue;
			case 0x2642u:
				state = 408;
				continue;
			default:
				return false;
			}
		case 407:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 408:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 396:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 409;
				continue;
			default:
				return false;
			}
		case 409:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 410;
				continue;
			case 0x2642u:
				state = 411;
				continue;
			default:
				return false;
			}
		case 410:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 411:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 126:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 412;
				continue;
			default:
				return false;
			}
		case 412:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 413;
				continue;
			case 0xdffcu:
				state = 414;
				continue;
			case 0xdffdu:
				state = 415;
				continue;
			case 0xdffeu:
				state = 416;
				continue;
			case 0xdfffu:
				state = 417;
				continue;
			default:
				return false;
			}
		case 413:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 418;
				continue;
			default:
				return false;
			}
		case 418:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 419;
				continue;
			case 0x2642u:
				state = 420;
				continue;
			default:
				return false;
			}
		case 419:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 420:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 414:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 421;
				continue;
			default:
				return false;
			}
		case 421:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 422;
				continue;
			case 0x2642u:
				state = 423;
				continue;
			default:
				return false;
			}
		case 422:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 423:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 415:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 424;
				continue;
			default:
				return false;
			}
		case 424:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 425;
				continue;
			case 0x2642u:
				state = 426;
				continue;
			default:
				return false;
			}
		case 425:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 426:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 416:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 427;
				continue;
			default:
				return false;
			}
		case 427:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 428;
				continue;
			case 0x2642u:
				state = 429;
				continue;
			default:
				return false;
			}
		case 428:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 429:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 417:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 430;
				continue;
			default:
				return false;
			}
		case 430:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 431;
				continue;
			case 0x2642u:
				state = 432;
				continue;
			default:
				return false;
			}
		case 431:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 432:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 127:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 433;
				continue;
			default:
				return false;
			}
		case 433:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 434;
				continue;
			case 0xdffcu:
				state = 435;
				continue;
			case 0xdffdu:
				state = 436;
				continue;
			case 0xdffeu:
				state = 437;
				continue;
			case 0xdfffu:
				state = 438;
				continue;
			default:
				return false;
			}
		case 434:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 439;
				continue;
			default:
				return false;
			}
		case 439:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 440;
				continue;
			case 0x2642u:
				state = 441;
				continue;
			default:
				return false;
			}
		case 440:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 441:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 435:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 442;
				continue;
			default:
				return false;
			}
		case 442:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 443;
				continue;
			case 0x2642u:
				state = 444;
				continue;
			default:
				return false;
			}
		case 443:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 444:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 436:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 445;
				continue;
			default:
				return false;
			}
		case 445:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 446;
				continue;
			case 0x2642u:
				state = 447;
				continue;
			default:
				return false;
			}
		case 446:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 447:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 437:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 448;
				continue;
			default:
				return false;
			}
		case 448:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 449;
				continue;
			case 0x2642u:
				state = 450;
				continue;
			default:
				return false;
			}
		case 449:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 450:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 438:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 451;
				continue;
			default:
				return false;
			}
		case 451:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 452;
				continue;
			case 0x2642u:
				state = 453;
				continue;
			default:
				return false;
			}
		case 452:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 453:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 128:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 454;
				continue;
			default:
				return false;
			}
		case 454:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 455;
				continue;
			case 0xdffcu:
				state = 456;
				continue;
			case 0xdffdu:
				state = 457;
				continue;
			case 0xdffeu:
				state = 458;
				continue;
			case 0xdfffu:
				state = 459;
				continue;
			default:
				return false;
			}
		case 455:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 460;
				continue;
			default:
				return false;
			}
		case 460:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 461;
				continue;
			case 0x2642u:
				state = 462;
				continue;
			default:
				return false;
			}
		case 461:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 462:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 456:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 463;
				continue;
			default:
				return false;
			}
		case 463:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 464;
				continue;
			case 0x2642u:
				state = 465;
				continue;
			default:
				return false;
			}
		case 464:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 465:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 457:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 466;
				continue;
			default:
				return false;
			}
		case 466:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 467;
				continue;
			case 0x2642u:
				state = 468;
				continue;
			default:
				return false;
			}
		case 467:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 468:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 458:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 469;
				continue;
			default:
				return false;
			}
		case 469:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 470;
				continue;
			case 0x2642u:
				state = 471;
				continue;
			default:
				return false;
			}
		case 470:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 471:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 459:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 472;
				continue;
			default:
				return false;
			}
		case 472:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 473;
				continue;
			case 0x2642u:
				state = 474;
				continue;
			default:
				return false;
			}
		case 473:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 474:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 129:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 475;
				continue;
			default:
				return false;
			}
		case 475:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 476;
				continue;
			case 0xdffcu:
				state = 477;
				continue;
			case 0xdffdu:
				state = 478;
				continue;
			case 0xdffeu:
				state = 479;
				continue;
			case 0xdfffu:
				state = 480;
				continue;
			default:
				return false;
			}
		case 476:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 481;
				continue;
			default:
				return false;
			}
		case 481:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 482;
				continue;
			case 0x2642u:
				state = 483;
				continue;
			default:
				return false;
			}
		case 482:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 483:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 477:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 484;
				continue;
			default:
				return false;
			}
		case 484:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 485;
				continue;
			case 0x2642u:
				state = 486;
				continue;
			default:
				return false;
			}
		case 485:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 486:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 478:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 487;
				continue;
			default:
				return false;
			}
		case 487:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 488;
				continue;
			case 0x2642u:
				state = 489;
				continue;
			default:
				return false;
			}
		case 488:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 489:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 479:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 490;
				continue;
			default:
				return false;
			}
		case 490:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 491;
				continue;
			case 0x2642u:
				state = 492;
				continue;
			default:
				return false;
			}
		case 491:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 492:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 480:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 493;
				continue;
			default:
				return false;
			}
		case 493:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 494;
				continue;
			case 0x2642u:
				state = 495;
				continue;
			default:
				return false;
			}
		case 494:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 495:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 130:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 496;
				continue;
			default:
				return false;
			}
		case 496:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 497;
				continue;
			case 0xdffcu:
				state = 498;
				continue;
			case 0xdffdu:
				state = 499;
				continue;
			case 0xdffeu:
				state = 500;
				continue;
			case 0xdfffu:
				state = 501;
				continue;
			default:
				return false;
			}
		case 497:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 502;
				continue;
			default:
				return false;
			}
		case 502:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 503;
				continue;
			case 0x2642u:
				state = 504;
				continue;
			default:
				return false;
			}
		case 503:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 504:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 498:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 505;
				continue;
			default:
				return false;
			}
		case 505:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 506;
				continue;
			case 0x2642u:
				state = 507;
				continue;
			default:
				return false;
			}
		case 506:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 507:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 499:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 508;
				continue;
			default:
				return false;
			}
		case 508:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 509;
				continue;
			case 0x2642u:
				state = 510;
				continue;
			default:
				return false;
			}
		case 509:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 510:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 500:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 511;
				continue;
			default:
				return false;
			}
		case 511:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 512;
				continue;
			case 0x2642u:
				state = 513;
				continue;
			default:
				return false;
			}
		case 512:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 513:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 501:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 514;
				continue;
			default:
				return false;
			}
		case 514:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 515;
				continue;
			case 0x2642u:
				state = 516;
				continue;
			default:
				return false;
			}
		case 515:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 516:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 131:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 517;
				continue;
			default:
				return false;
			}
		case 517:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 518;
				continue;
			case 0xdffcu:
				state = 519;
				continue;
			case 0xdffdu:
				state = 520;
				continue;
			case 0xdffeu:
				state = 521;
				continue;
			case 0xdfffu:
				state = 522;
				continue;
			default:
				return false;
			}
		case 518:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 523;
				continue;
			default:
				return false;
			}
		case 523:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 524;
				continue;
			case 0x2642u:
				state = 525;
				continue;
			default:
				return false;
			}
		case 524:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 525:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 519:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 526;
				continue;
			default:
				return false;
			}
		case 526:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 527;
				continue;
			case 0x2642u:
				state = 528;
				continue;
			default:
				return false;
			}
		case 527:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 528:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 520:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 529;
				continue;
			default:
				return false;
			}
		case 529:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 530;
				continue;
			case 0x2642u:
				state = 531;
				continue;
			default:
				return false;
			}
		case 530:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 531:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 521:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 532;
				continue;
			default:
				return false;
			}
		case 532:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 533;
				continue;
			case 0x2642u:
				state = 534;
				continue;
			default:
				return false;
			}
		case 533:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 534:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 522:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 535;
				continue;
			default:
				return false;
			}
		case 535:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 536;
				continue;
			case 0x2642u:
				state = 537;
				continue;
			default:
				return false;
			}
		case 536:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 537:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 132:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 538;
				continue;
			default:
				return false;
			}
		case 538:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 539;
				continue;
			case 0xdffcu:
				state = 540;
				continue;
			case 0xdffdu:
				state = 541;
				continue;
			case 0xdffeu:
				state = 542;
				continue;
			case 0xdfffu:
				state = 543;
				continue;
			default:
				return false;
			}
		case 539:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 544;
				continue;
			default:
				return false;
			}
		case 544:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 545;
				continue;
			case 0x2642u:
				state = 546;
				continue;
			default:
				return false;
			}
		case 545:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 546:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 540:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 547;
				continue;
			default:
				return false;
			}
		case 547:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 548;
				continue;
			case 0x2642u:
				state = 549;
				continue;
			default:
				return false;
			}
		case 548:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 549:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 541:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 550;
				continue;
			default:
				return false;
			}
		case 550:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 551;
				continue;
			case 0x2642u:
				state = 552;
				continue;
			default:
				return false;
			}
		case 551:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 552:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 542:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 553;
				continue;
			default:
				return false;
			}
		case 553:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 554;
				continue;
			case 0x2642u:
				state = 555;
				continue;
			default:
				return false;
			}
		case 554:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 555:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 543:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 556;
				continue;
			default:
				return false;
			}
		case 556:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 557;
				continue;
			case 0x2642u:
				state = 558;
				continue;
			default:
				return false;
			}
		case 557:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 558:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 133:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 559;
				continue;
			default:
				return false;
			}
		case 559:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 560;
				continue;
			case 0xdffcu:
				state = 561;
				continue;
			case 0xdffdu:
				state = 562;
				continue;
			case 0xdffeu:
				state = 563;
				continue;
			case 0xdfffu:
				state = 564;
				continue;
			default:
				return false;
			}
		case 560:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 565;
				continue;
			default:
				return false;
			}
		case 565:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 566;
				continue;
			case 0x2642u:
				state = 567;
				continue;
			default:
				return false;
			}
		case 566:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 567:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 561:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 568;
				continue;
			default:
				return false;
			}
		case 568:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 569;
				continue;
			case 0x2642u:
				state = 570;
				continue;
			default:
				return false;
			}
		case 569:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 570:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 562:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 571;
				continue;
			default:
				return false;
			}
		case 571:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 572;
				continue;
			case 0x2642u:
				state = 573;
				continue;
			default:
				return false;
			}
		case 572:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 573:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 563:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 574;
				continue;
			default:
				return false;
			}
		case 574:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 575;
				continue;
			case 0x2642u:
				state = 576;
				continue;
			default:
				return false;
			}
		case 575:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 576:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 564:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 577;
				continue;
			default:
				return false;
			}
		case 577:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 578;
				continue;
			case 0x2642u:
				state = 579;
				continue;
			default:
				return false;
			}
		case 578:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 579:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 134:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 580;
				continue;
			default:
				return false;
			}
		case 580:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 581;
				continue;
			case 0xdffcu:
				state = 582;
				continue;
			case 0xdffdu:
				state = 583;
				continue;
			case 0xdffeu:
				state = 584;
				continue;
			case 0xdfffu:
				state = 585;
				continue;
			default:
				return false;
			}
		case 581:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 586;
				continue;
			default:
				return false;
			}
		case 586:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 587;
				continue;
			case 0x2642u:
				state = 588;
				continue;
			default:
				return false;
			}
		case 587:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 588:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 582:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 589;
				continue;
			default:
				return false;
			}
		case 589:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 590;
				continue;
			case 0x2642u:
				state = 591;
				continue;
			default:
				return false;
			}
		case 590:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 591:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 583:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 592;
				continue;
			default:
				return false;
			}
		case 592:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 593;
				continue;
			case 0x2642u:
				state = 594;
				continue;
			default:
				return false;
			}
		case 593:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 594:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 584:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 595;
				continue;
			default:
				return false;
			}
		case 595:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 596;
				continue;
			case 0x2642u:
				state = 597;
				continue;
			default:
				return false;
			}
		case 596:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 597:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 585:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 598;
				continue;
			default:
				return false;
			}
		case 598:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 599;
				continue;
			case 0x2642u:
				state = 600;
				continue;
			default:
				return false;
			}
		case 599:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 600:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 135:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 601;
				continue;
			default:
				return false;
			}
		case 601:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 602;
				continue;
			case 0xdffcu:
				state = 603;
				continue;
			case 0xdffdu:
				state = 604;
				continue;
			case 0xdffeu:
				state = 605;
				continue;
			case 0xdfffu:
				state = 606;
				continue;
			default:
				return false;
			}
		case 602:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 607;
				continue;
			default:
				return false;
			}
		case 607:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 608;
				continue;
			case 0x2642u:
				state = 609;
				continue;
			default:
				return false;
			}
		case 608:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 609:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 603:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 610;
				continue;
			default:
				return false;
			}
		case 610:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 611;
				continue;
			case 0x2642u:
				state = 612;
				continue;
			default:
				return false;
			}
		case 611:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 612:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 604:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 613;
				continue;
			default:
				return false;
			}
		case 613:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 614;
				continue;
			case 0x2642u:
				state = 615;
				continue;
			default:
				return false;
			}
		case 614:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 615:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 605:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 616;
				continue;
			default:
				return false;
			}
		case 616:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 617;
				continue;
			case 0x2642u:
				state = 618;
				continue;
			default:
				return false;
			}
		case 617:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 618:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 606:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 619;
				continue;
			default:
				return false;
			}
		case 619:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 620;
				continue;
			case 0x2642u:
				state = 621;
				continue;
			default:
				return false;
			}
		case 620:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 621:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 136:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 622;
				continue;
			default:
				return false;
			}
		case 622:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 623;
				continue;
			case 0xdffcu:
				state = 624;
				continue;
			case 0xdffdu:
				state = 625;
				continue;
			case 0xdffeu:
				state = 626;
				continue;
			case 0xdfffu:
				state = 627;
				continue;
			default:
				return false;
			}
		case 623:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 628;
				continue;
			default:
				return false;
			}
		case 628:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 629;
				continue;
			case 0x2642u:
				state = 630;
				continue;
			default:
				return false;
			}
		case 629:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 630:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 624:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 631;
				continue;
			default:
				return false;
			}
		case 631:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 632;
				continue;
			case 0x2642u:
				state = 633;
				continue;
			default:
				return false;
			}
		case 632:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 633:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 625:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 634;
				continue;
			default:
				return false;
			}
		case 634:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 635;
				continue;
			case 0x2642u:
				state = 636;
				continue;
			default:
				return false;
			}
		case 635:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 636:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 626:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 637;
				continue;
			default:
				return false;
			}
		case 637:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 638;
				continue;
			case 0x2642u:
				state = 639;
				continue;
			default:
				return false;
			}
		case 638:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 639:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 627:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 640;
				continue;
			default:
				return false;
			}
		case 640:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 641;
				continue;
			case 0x2642u:
				state = 642;
				continue;
			default:
				return false;
			}
		case 641:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 642:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 3:
			switch(input[offset + 1].unicode()) {
			case 0xdd26u:
				state = 643;
				continue;
			case 0xdd35u:
				state = 644;
				continue;
			case 0xdd37u:
				state = 645;
				continue;
			case 0xdd38u:
				state = 646;
				continue;
			case 0xdd39u:
				state = 647;
				continue;
			case 0xdd3du:
				state = 648;
				continue;
			case 0xdd3eu:
				state = 649;
				continue;
			case 0xddb8u:
				state = 650;
				continue;
			case 0xddb9u:
				state = 651;
				continue;
			case 0xddcdu:
				state = 652;
				continue;
			case 0xddceu:
				state = 653;
				continue;
			case 0xddcfu:
				state = 654;
				continue;
			case 0xddd1u:
				state = 655;
				continue;
			case 0xddd4u:
				state = 656;
				continue;
			case 0xddd6u:
				state = 657;
				continue;
			case 0xddd7u:
				state = 658;
				continue;
			case 0xddd8u:
				state = 659;
				continue;
			case 0xddd9u:
				state = 660;
				continue;
			case 0xdddau:
				state = 661;
				continue;
			case 0xdddbu:
				state = 662;
				continue;
			case 0xdddcu:
				state = 663;
				continue;
			case 0xddddu:
				state = 664;
				continue;
			default:
				return false;
			}
		case 643:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 665;
				continue;
			default:
				return false;
			}
		case 665:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 666;
				continue;
			case 0xdffcu:
				state = 667;
				continue;
			case 0xdffdu:
				state = 668;
				continue;
			case 0xdffeu:
				state = 669;
				continue;
			case 0xdfffu:
				state = 670;
				continue;
			default:
				return false;
			}
		case 666:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 671;
				continue;
			default:
				return false;
			}
		case 671:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 672;
				continue;
			case 0x2642u:
				state = 673;
				continue;
			default:
				return false;
			}
		case 672:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 673:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 667:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 674;
				continue;
			default:
				return false;
			}
		case 674:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 675;
				continue;
			case 0x2642u:
				state = 676;
				continue;
			default:
				return false;
			}
		case 675:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 676:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 668:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 677;
				continue;
			default:
				return false;
			}
		case 677:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 678;
				continue;
			case 0x2642u:
				state = 679;
				continue;
			default:
				return false;
			}
		case 678:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 679:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 669:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 680;
				continue;
			default:
				return false;
			}
		case 680:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 681;
				continue;
			case 0x2642u:
				state = 682;
				continue;
			default:
				return false;
			}
		case 681:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 682:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 670:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 683;
				continue;
			default:
				return false;
			}
		case 683:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 684;
				continue;
			case 0x2642u:
				state = 685;
				continue;
			default:
				return false;
			}
		case 684:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 685:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 644:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 686;
				continue;
			default:
				return false;
			}
		case 686:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 687;
				continue;
			case 0xdffcu:
				state = 688;
				continue;
			case 0xdffdu:
				state = 689;
				continue;
			case 0xdffeu:
				state = 690;
				continue;
			case 0xdfffu:
				state = 691;
				continue;
			default:
				return false;
			}
		case 687:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 692;
				continue;
			default:
				return false;
			}
		case 692:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 693;
				continue;
			case 0x2642u:
				state = 694;
				continue;
			default:
				return false;
			}
		case 693:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 694:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 688:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 695;
				continue;
			default:
				return false;
			}
		case 695:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 696;
				continue;
			case 0x2642u:
				state = 697;
				continue;
			default:
				return false;
			}
		case 696:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 697:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 689:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 698;
				continue;
			default:
				return false;
			}
		case 698:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 699;
				continue;
			case 0x2642u:
				state = 700;
				continue;
			default:
				return false;
			}
		case 699:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 700:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 690:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 701;
				continue;
			default:
				return false;
			}
		case 701:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 702;
				continue;
			case 0x2642u:
				state = 703;
				continue;
			default:
				return false;
			}
		case 702:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 703:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 691:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 704;
				continue;
			default:
				return false;
			}
		case 704:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 705;
				continue;
			case 0x2642u:
				state = 706;
				continue;
			default:
				return false;
			}
		case 705:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 706:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 645:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 707;
				continue;
			default:
				return false;
			}
		case 707:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 708;
				continue;
			case 0xdffcu:
				state = 709;
				continue;
			case 0xdffdu:
				state = 710;
				continue;
			case 0xdffeu:
				state = 711;
				continue;
			case 0xdfffu:
				state = 712;
				continue;
			default:
				return false;
			}
		case 708:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 713;
				continue;
			default:
				return false;
			}
		case 713:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 714;
				continue;
			case 0x2642u:
				state = 715;
				continue;
			default:
				return false;
			}
		case 714:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 715:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 709:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 716;
				continue;
			default:
				return false;
			}
		case 716:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 717;
				continue;
			case 0x2642u:
				state = 718;
				continue;
			default:
				return false;
			}
		case 717:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 718:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 710:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 719;
				continue;
			default:
				return false;
			}
		case 719:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 720;
				continue;
			case 0x2642u:
				state = 721;
				continue;
			default:
				return false;
			}
		case 720:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 721:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 711:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 722;
				continue;
			default:
				return false;
			}
		case 722:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 723;
				continue;
			case 0x2642u:
				state = 724;
				continue;
			default:
				return false;
			}
		case 723:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 724:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 712:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 725;
				continue;
			default:
				return false;
			}
		case 725:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 726;
				continue;
			case 0x2642u:
				state = 727;
				continue;
			default:
				return false;
			}
		case 726:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 727:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 646:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 728;
				continue;
			default:
				return false;
			}
		case 728:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 729;
				continue;
			case 0xdffcu:
				state = 730;
				continue;
			case 0xdffdu:
				state = 731;
				continue;
			case 0xdffeu:
				state = 732;
				continue;
			case 0xdfffu:
				state = 733;
				continue;
			default:
				return false;
			}
		case 729:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 734;
				continue;
			default:
				return false;
			}
		case 734:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 735;
				continue;
			case 0x2642u:
				state = 736;
				continue;
			default:
				return false;
			}
		case 735:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 736:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 730:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 737;
				continue;
			default:
				return false;
			}
		case 737:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 738;
				continue;
			case 0x2642u:
				state = 739;
				continue;
			default:
				return false;
			}
		case 738:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 739:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 731:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 740;
				continue;
			default:
				return false;
			}
		case 740:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 741;
				continue;
			case 0x2642u:
				state = 742;
				continue;
			default:
				return false;
			}
		case 741:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 742:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 732:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 743;
				continue;
			default:
				return false;
			}
		case 743:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 744;
				continue;
			case 0x2642u:
				state = 745;
				continue;
			default:
				return false;
			}
		case 744:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 745:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 733:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 746;
				continue;
			default:
				return false;
			}
		case 746:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 747;
				continue;
			case 0x2642u:
				state = 748;
				continue;
			default:
				return false;
			}
		case 747:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 748:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 647:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 749;
				continue;
			default:
				return false;
			}
		case 749:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 750;
				continue;
			case 0xdffcu:
				state = 751;
				continue;
			case 0xdffdu:
				state = 752;
				continue;
			case 0xdffeu:
				state = 753;
				continue;
			case 0xdfffu:
				state = 754;
				continue;
			default:
				return false;
			}
		case 750:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 755;
				continue;
			default:
				return false;
			}
		case 755:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 756;
				continue;
			case 0x2642u:
				state = 757;
				continue;
			default:
				return false;
			}
		case 756:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 757:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 751:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 758;
				continue;
			default:
				return false;
			}
		case 758:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 759;
				continue;
			case 0x2642u:
				state = 760;
				continue;
			default:
				return false;
			}
		case 759:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 760:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 752:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 761;
				continue;
			default:
				return false;
			}
		case 761:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 762;
				continue;
			case 0x2642u:
				state = 763;
				continue;
			default:
				return false;
			}
		case 762:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 763:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 753:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 764;
				continue;
			default:
				return false;
			}
		case 764:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 765;
				continue;
			case 0x2642u:
				state = 766;
				continue;
			default:
				return false;
			}
		case 765:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 766:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 754:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 767;
				continue;
			default:
				return false;
			}
		case 767:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 768;
				continue;
			case 0x2642u:
				state = 769;
				continue;
			default:
				return false;
			}
		case 768:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 769:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 648:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 770;
				continue;
			default:
				return false;
			}
		case 770:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 771;
				continue;
			case 0xdffcu:
				state = 772;
				continue;
			case 0xdffdu:
				state = 773;
				continue;
			case 0xdffeu:
				state = 774;
				continue;
			case 0xdfffu:
				state = 775;
				continue;
			default:
				return false;
			}
		case 771:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 776;
				continue;
			default:
				return false;
			}
		case 776:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 777;
				continue;
			case 0x2642u:
				state = 778;
				continue;
			default:
				return false;
			}
		case 777:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 778:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 772:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 779;
				continue;
			default:
				return false;
			}
		case 779:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 780;
				continue;
			case 0x2642u:
				state = 781;
				continue;
			default:
				return false;
			}
		case 780:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 781:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 773:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 782;
				continue;
			default:
				return false;
			}
		case 782:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 783;
				continue;
			case 0x2642u:
				state = 784;
				continue;
			default:
				return false;
			}
		case 783:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 784:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 774:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 785;
				continue;
			default:
				return false;
			}
		case 785:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 786;
				continue;
			case 0x2642u:
				state = 787;
				continue;
			default:
				return false;
			}
		case 786:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 787:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 775:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 788;
				continue;
			default:
				return false;
			}
		case 788:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 789;
				continue;
			case 0x2642u:
				state = 790;
				continue;
			default:
				return false;
			}
		case 789:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 790:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 649:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 791;
				continue;
			default:
				return false;
			}
		case 791:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 792;
				continue;
			case 0xdffcu:
				state = 793;
				continue;
			case 0xdffdu:
				state = 794;
				continue;
			case 0xdffeu:
				state = 795;
				continue;
			case 0xdfffu:
				state = 796;
				continue;
			default:
				return false;
			}
		case 792:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 797;
				continue;
			default:
				return false;
			}
		case 797:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 798;
				continue;
			case 0x2642u:
				state = 799;
				continue;
			default:
				return false;
			}
		case 798:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 799:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 793:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 800;
				continue;
			default:
				return false;
			}
		case 800:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 801;
				continue;
			case 0x2642u:
				state = 802;
				continue;
			default:
				return false;
			}
		case 801:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 802:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 794:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 803;
				continue;
			default:
				return false;
			}
		case 803:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 804;
				continue;
			case 0x2642u:
				state = 805;
				continue;
			default:
				return false;
			}
		case 804:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 805:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 795:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 806;
				continue;
			default:
				return false;
			}
		case 806:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 807;
				continue;
			case 0x2642u:
				state = 808;
				continue;
			default:
				return false;
			}
		case 807:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 808:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 796:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 809;
				continue;
			default:
				return false;
			}
		case 809:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 810;
				continue;
			case 0x2642u:
				state = 811;
				continue;
			default:
				return false;
			}
		case 810:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 811:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 650:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 812;
				continue;
			default:
				return false;
			}
		case 812:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 813;
				continue;
			case 0xdffcu:
				state = 814;
				continue;
			case 0xdffdu:
				state = 815;
				continue;
			case 0xdffeu:
				state = 816;
				continue;
			case 0xdfffu:
				state = 817;
				continue;
			default:
				return false;
			}
		case 813:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 818;
				continue;
			default:
				return false;
			}
		case 818:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 819;
				continue;
			case 0x2642u:
				state = 820;
				continue;
			default:
				return false;
			}
		case 819:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 820:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 814:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 821;
				continue;
			default:
				return false;
			}
		case 821:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 822;
				continue;
			case 0x2642u:
				state = 823;
				continue;
			default:
				return false;
			}
		case 822:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 823:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 815:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 824;
				continue;
			default:
				return false;
			}
		case 824:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 825;
				continue;
			case 0x2642u:
				state = 826;
				continue;
			default:
				return false;
			}
		case 825:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 826:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 816:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 827;
				continue;
			default:
				return false;
			}
		case 827:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 828;
				continue;
			case 0x2642u:
				state = 829;
				continue;
			default:
				return false;
			}
		case 828:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 829:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 817:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 830;
				continue;
			default:
				return false;
			}
		case 830:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 831;
				continue;
			case 0x2642u:
				state = 832;
				continue;
			default:
				return false;
			}
		case 831:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 832:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 651:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 833;
				continue;
			default:
				return false;
			}
		case 833:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 834;
				continue;
			case 0xdffcu:
				state = 835;
				continue;
			case 0xdffdu:
				state = 836;
				continue;
			case 0xdffeu:
				state = 837;
				continue;
			case 0xdfffu:
				state = 838;
				continue;
			default:
				return false;
			}
		case 834:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 839;
				continue;
			default:
				return false;
			}
		case 839:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 840;
				continue;
			case 0x2642u:
				state = 841;
				continue;
			default:
				return false;
			}
		case 840:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 841:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 835:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 842;
				continue;
			default:
				return false;
			}
		case 842:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 843;
				continue;
			case 0x2642u:
				state = 844;
				continue;
			default:
				return false;
			}
		case 843:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 844:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 836:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 845;
				continue;
			default:
				return false;
			}
		case 845:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 846;
				continue;
			case 0x2642u:
				state = 847;
				continue;
			default:
				return false;
			}
		case 846:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 847:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 837:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 848;
				continue;
			default:
				return false;
			}
		case 848:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 849;
				continue;
			case 0x2642u:
				state = 850;
				continue;
			default:
				return false;
			}
		case 849:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 850:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 838:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 851;
				continue;
			default:
				return false;
			}
		case 851:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 852;
				continue;
			case 0x2642u:
				state = 853;
				continue;
			default:
				return false;
			}
		case 852:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 853:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 652:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 854;
				continue;
			default:
				return false;
			}
		case 854:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 855;
				continue;
			case 0xdffcu:
				state = 856;
				continue;
			case 0xdffdu:
				state = 857;
				continue;
			case 0xdffeu:
				state = 858;
				continue;
			case 0xdfffu:
				state = 859;
				continue;
			default:
				return false;
			}
		case 855:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 860;
				continue;
			default:
				return false;
			}
		case 860:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 861;
				continue;
			case 0x2642u:
				state = 862;
				continue;
			default:
				return false;
			}
		case 861:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 862:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 856:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 863;
				continue;
			default:
				return false;
			}
		case 863:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 864;
				continue;
			case 0x2642u:
				state = 865;
				continue;
			default:
				return false;
			}
		case 864:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 865:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 857:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 866;
				continue;
			default:
				return false;
			}
		case 866:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 867;
				continue;
			case 0x2642u:
				state = 868;
				continue;
			default:
				return false;
			}
		case 867:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 868:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 858:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 869;
				continue;
			default:
				return false;
			}
		case 869:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 870;
				continue;
			case 0x2642u:
				state = 871;
				continue;
			default:
				return false;
			}
		case 870:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 871:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 859:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 872;
				continue;
			default:
				return false;
			}
		case 872:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 873;
				continue;
			case 0x2642u:
				state = 874;
				continue;
			default:
				return false;
			}
		case 873:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 874:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 653:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 875;
				continue;
			default:
				return false;
			}
		case 875:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 876;
				continue;
			case 0xdffcu:
				state = 877;
				continue;
			case 0xdffdu:
				state = 878;
				continue;
			case 0xdffeu:
				state = 879;
				continue;
			case 0xdfffu:
				state = 880;
				continue;
			default:
				return false;
			}
		case 876:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 881;
				continue;
			default:
				return false;
			}
		case 881:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 882;
				continue;
			case 0x2642u:
				state = 883;
				continue;
			default:
				return false;
			}
		case 882:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 883:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 877:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 884;
				continue;
			default:
				return false;
			}
		case 884:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 885;
				continue;
			case 0x2642u:
				state = 886;
				continue;
			default:
				return false;
			}
		case 885:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 886:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 878:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 887;
				continue;
			default:
				return false;
			}
		case 887:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 888;
				continue;
			case 0x2642u:
				state = 889;
				continue;
			default:
				return false;
			}
		case 888:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 889:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 879:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 890;
				continue;
			default:
				return false;
			}
		case 890:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 891;
				continue;
			case 0x2642u:
				state = 892;
				continue;
			default:
				return false;
			}
		case 891:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 892:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 880:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 893;
				continue;
			default:
				return false;
			}
		case 893:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 894;
				continue;
			case 0x2642u:
				state = 895;
				continue;
			default:
				return false;
			}
		case 894:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 895:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 654:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 896;
				continue;
			default:
				return false;
			}
		case 896:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 897;
				continue;
			case 0xdffcu:
				state = 898;
				continue;
			case 0xdffdu:
				state = 899;
				continue;
			case 0xdffeu:
				state = 900;
				continue;
			case 0xdfffu:
				state = 901;
				continue;
			default:
				return false;
			}
		case 897:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 902;
				continue;
			default:
				return false;
			}
		case 902:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 903;
				continue;
			case 0x2642u:
				state = 904;
				continue;
			default:
				return false;
			}
		case 903:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 904:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 898:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 905;
				continue;
			default:
				return false;
			}
		case 905:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 906;
				continue;
			case 0x2642u:
				state = 907;
				continue;
			default:
				return false;
			}
		case 906:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 907:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 899:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 908;
				continue;
			default:
				return false;
			}
		case 908:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 909;
				continue;
			case 0x2642u:
				state = 910;
				continue;
			default:
				return false;
			}
		case 909:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 910:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 900:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 911;
				continue;
			default:
				return false;
			}
		case 911:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 912;
				continue;
			case 0x2642u:
				state = 913;
				continue;
			default:
				return false;
			}
		case 912:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 913:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 901:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 914;
				continue;
			default:
				return false;
			}
		case 914:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 915;
				continue;
			case 0x2642u:
				state = 916;
				continue;
			default:
				return false;
			}
		case 915:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 916:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 655:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 917;
				continue;
			default:
				return false;
			}
		case 917:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 918;
				continue;
			case 0xdffcu:
				state = 919;
				continue;
			case 0xdffdu:
				state = 920;
				continue;
			case 0xdffeu:
				state = 921;
				continue;
			case 0xdfffu:
				state = 922;
				continue;
			default:
				return false;
			}
		case 918:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 923;
				continue;
			default:
				return false;
			}
		case 923:
			switch(input[offset + 5].unicode()) {
			case 0x2695u:
				state = 924;
				continue;
			case 0x2696u:
				state = 925;
				continue;
			case 0x2708u:
				state = 926;
				continue;
			case 0xd83cu:
				state = 927;
				continue;
			case 0xd83du:
				state = 928;
				continue;
			case 0xd83eu:
				state = 929;
				continue;
			default:
				return false;
			}
		case 924:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 925:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 926:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 927:
			switch(input[offset + 6].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf84u:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 928:
			switch(input[offset + 6].unicode()) {
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 929:
			switch(input[offset + 6].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 919:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 930;
				continue;
			default:
				return false;
			}
		case 930:
			switch(input[offset + 5].unicode()) {
			case 0x2695u:
				state = 931;
				continue;
			case 0x2696u:
				state = 932;
				continue;
			case 0x2708u:
				state = 933;
				continue;
			case 0xd83cu:
				state = 934;
				continue;
			case 0xd83du:
				state = 935;
				continue;
			case 0xd83eu:
				state = 936;
				continue;
			default:
				return false;
			}
		case 931:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 932:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 933:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 934:
			switch(input[offset + 6].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf84u:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 935:
			switch(input[offset + 6].unicode()) {
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 936:
			switch(input[offset + 6].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 920:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 937;
				continue;
			default:
				return false;
			}
		case 937:
			switch(input[offset + 5].unicode()) {
			case 0x2695u:
				state = 938;
				continue;
			case 0x2696u:
				state = 939;
				continue;
			case 0x2708u:
				state = 940;
				continue;
			case 0xd83cu:
				state = 941;
				continue;
			case 0xd83du:
				state = 942;
				continue;
			case 0xd83eu:
				state = 943;
				continue;
			default:
				return false;
			}
		case 938:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 939:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 940:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 941:
			switch(input[offset + 6].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf84u:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 942:
			switch(input[offset + 6].unicode()) {
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 943:
			switch(input[offset + 6].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 921:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 944;
				continue;
			default:
				return false;
			}
		case 944:
			switch(input[offset + 5].unicode()) {
			case 0x2695u:
				state = 945;
				continue;
			case 0x2696u:
				state = 946;
				continue;
			case 0x2708u:
				state = 947;
				continue;
			case 0xd83cu:
				state = 948;
				continue;
			case 0xd83du:
				state = 949;
				continue;
			case 0xd83eu:
				state = 950;
				continue;
			default:
				return false;
			}
		case 945:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 946:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 947:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 948:
			switch(input[offset + 6].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf84u:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 949:
			switch(input[offset + 6].unicode()) {
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 950:
			switch(input[offset + 6].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 922:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 951;
				continue;
			default:
				return false;
			}
		case 951:
			switch(input[offset + 5].unicode()) {
			case 0x2695u:
				state = 952;
				continue;
			case 0x2696u:
				state = 953;
				continue;
			case 0x2708u:
				state = 954;
				continue;
			case 0xd83cu:
				state = 955;
				continue;
			case 0xd83du:
				state = 956;
				continue;
			case 0xd83eu:
				state = 957;
				continue;
			default:
				return false;
			}
		case 952:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 953:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 954:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 955:
			switch(input[offset + 6].unicode()) {
			case 0xdf3eu:
			case 0xdf73u:
			case 0xdf7cu:
			case 0xdf84u:
			case 0xdf93u:
			case 0xdfa4u:
			case 0xdfa8u:
			case 0xdfebu:
			case 0xdfedu:
				return true;
			default:
				return false;
			}
		case 956:
			switch(input[offset + 6].unicode()) {
			case 0xdcbbu:
			case 0xdcbcu:
			case 0xdd27u:
			case 0xdd2cu:
			case 0xde80u:
			case 0xde92u:
				return true;
			default:
				return false;
			}
		case 957:
			switch(input[offset + 6].unicode()) {
			case 0xddafu:
			case 0xddb0u:
			case 0xddb1u:
			case 0xddb2u:
			case 0xddb3u:
			case 0xddbcu:
			case 0xddbdu:
				return true;
			default:
				return false;
			}
		case 656:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 958;
				continue;
			default:
				return false;
			}
		case 958:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 959;
				continue;
			case 0xdffcu:
				state = 960;
				continue;
			case 0xdffdu:
				state = 961;
				continue;
			case 0xdffeu:
				state = 962;
				continue;
			case 0xdfffu:
				state = 963;
				continue;
			default:
				return false;
			}
		case 959:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 964;
				continue;
			default:
				return false;
			}
		case 964:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 965;
				continue;
			case 0x2642u:
				state = 966;
				continue;
			default:
				return false;
			}
		case 965:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 966:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 960:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 967;
				continue;
			default:
				return false;
			}
		case 967:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 968;
				continue;
			case 0x2642u:
				state = 969;
				continue;
			default:
				return false;
			}
		case 968:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 969:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 961:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 970;
				continue;
			default:
				return false;
			}
		case 970:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 971;
				continue;
			case 0x2642u:
				state = 972;
				continue;
			default:
				return false;
			}
		case 971:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 972:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 962:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 973;
				continue;
			default:
				return false;
			}
		case 973:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 974;
				continue;
			case 0x2642u:
				state = 975;
				continue;
			default:
				return false;
			}
		case 974:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 975:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 963:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 976;
				continue;
			default:
				return false;
			}
		case 976:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 977;
				continue;
			case 0x2642u:
				state = 978;
				continue;
			default:
				return false;
			}
		case 977:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 978:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 657:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 979;
				continue;
			default:
				return false;
			}
		case 979:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 980;
				continue;
			case 0xdffcu:
				state = 981;
				continue;
			case 0xdffdu:
				state = 982;
				continue;
			case 0xdffeu:
				state = 983;
				continue;
			case 0xdfffu:
				state = 984;
				continue;
			default:
				return false;
			}
		case 980:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 985;
				continue;
			default:
				return false;
			}
		case 985:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 986;
				continue;
			case 0x2642u:
				state = 987;
				continue;
			default:
				return false;
			}
		case 986:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 987:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 981:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 988;
				continue;
			default:
				return false;
			}
		case 988:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 989;
				continue;
			case 0x2642u:
				state = 990;
				continue;
			default:
				return false;
			}
		case 989:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 990:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 982:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 991;
				continue;
			default:
				return false;
			}
		case 991:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 992;
				continue;
			case 0x2642u:
				state = 993;
				continue;
			default:
				return false;
			}
		case 992:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 993:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 983:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 994;
				continue;
			default:
				return false;
			}
		case 994:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 995;
				continue;
			case 0x2642u:
				state = 996;
				continue;
			default:
				return false;
			}
		case 995:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 996:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 984:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 997;
				continue;
			default:
				return false;
			}
		case 997:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 998;
				continue;
			case 0x2642u:
				state = 999;
				continue;
			default:
				return false;
			}
		case 998:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 999:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 658:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 1000;
				continue;
			default:
				return false;
			}
		case 1000:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 1001;
				continue;
			case 0xdffcu:
				state = 1002;
				continue;
			case 0xdffdu:
				state = 1003;
				continue;
			case 0xdffeu:
				state = 1004;
				continue;
			case 0xdfffu:
				state = 1005;
				continue;
			default:
				return false;
			}
		case 1001:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1006;
				continue;
			default:
				return false;
			}
		case 1006:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1007;
				continue;
			case 0x2642u:
				state = 1008;
				continue;
			default:
				return false;
			}
		case 1007:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1008:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1002:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1009;
				continue;
			default:
				return false;
			}
		case 1009:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1010;
				continue;
			case 0x2642u:
				state = 1011;
				continue;
			default:
				return false;
			}
		case 1010:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1011:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1003:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1012;
				continue;
			default:
				return false;
			}
		case 1012:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1013;
				continue;
			case 0x2642u:
				state = 1014;
				continue;
			default:
				return false;
			}
		case 1013:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1014:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1004:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1015;
				continue;
			default:
				return false;
			}
		case 1015:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1016;
				continue;
			case 0x2642u:
				state = 1017;
				continue;
			default:
				return false;
			}
		case 1016:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1017:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1005:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1018;
				continue;
			default:
				return false;
			}
		case 1018:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1019;
				continue;
			case 0x2642u:
				state = 1020;
				continue;
			default:
				return false;
			}
		case 1019:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1020:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 659:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 1021;
				continue;
			default:
				return false;
			}
		case 1021:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 1022;
				continue;
			case 0xdffcu:
				state = 1023;
				continue;
			case 0xdffdu:
				state = 1024;
				continue;
			case 0xdffeu:
				state = 1025;
				continue;
			case 0xdfffu:
				state = 1026;
				continue;
			default:
				return false;
			}
		case 1022:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1027;
				continue;
			default:
				return false;
			}
		case 1027:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1028;
				continue;
			case 0x2642u:
				state = 1029;
				continue;
			default:
				return false;
			}
		case 1028:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1029:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1023:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1030;
				continue;
			default:
				return false;
			}
		case 1030:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1031;
				continue;
			case 0x2642u:
				state = 1032;
				continue;
			default:
				return false;
			}
		case 1031:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1032:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1024:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1033;
				continue;
			default:
				return false;
			}
		case 1033:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1034;
				continue;
			case 0x2642u:
				state = 1035;
				continue;
			default:
				return false;
			}
		case 1034:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1035:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1025:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1036;
				continue;
			default:
				return false;
			}
		case 1036:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1037;
				continue;
			case 0x2642u:
				state = 1038;
				continue;
			default:
				return false;
			}
		case 1037:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1038:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1026:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1039;
				continue;
			default:
				return false;
			}
		case 1039:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1040;
				continue;
			case 0x2642u:
				state = 1041;
				continue;
			default:
				return false;
			}
		case 1040:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1041:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 660:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 1042;
				continue;
			default:
				return false;
			}
		case 1042:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 1043;
				continue;
			case 0xdffcu:
				state = 1044;
				continue;
			case 0xdffdu:
				state = 1045;
				continue;
			case 0xdffeu:
				state = 1046;
				continue;
			case 0xdfffu:
				state = 1047;
				continue;
			default:
				return false;
			}
		case 1043:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1048;
				continue;
			default:
				return false;
			}
		case 1048:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1049;
				continue;
			case 0x2642u:
				state = 1050;
				continue;
			default:
				return false;
			}
		case 1049:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1050:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1044:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1051;
				continue;
			default:
				return false;
			}
		case 1051:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1052;
				continue;
			case 0x2642u:
				state = 1053;
				continue;
			default:
				return false;
			}
		case 1052:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1053:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1045:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1054;
				continue;
			default:
				return false;
			}
		case 1054:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1055;
				continue;
			case 0x2642u:
				state = 1056;
				continue;
			default:
				return false;
			}
		case 1055:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1056:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1046:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1057;
				continue;
			default:
				return false;
			}
		case 1057:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1058;
				continue;
			case 0x2642u:
				state = 1059;
				continue;
			default:
				return false;
			}
		case 1058:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1059:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1047:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1060;
				continue;
			default:
				return false;
			}
		case 1060:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1061;
				continue;
			case 0x2642u:
				state = 1062;
				continue;
			default:
				return false;
			}
		case 1061:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1062:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 661:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 1063;
				continue;
			default:
				return false;
			}
		case 1063:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 1064;
				continue;
			case 0xdffcu:
				state = 1065;
				continue;
			case 0xdffdu:
				state = 1066;
				continue;
			case 0xdffeu:
				state = 1067;
				continue;
			case 0xdfffu:
				state = 1068;
				continue;
			default:
				return false;
			}
		case 1064:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1069;
				continue;
			default:
				return false;
			}
		case 1069:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1070;
				continue;
			case 0x2642u:
				state = 1071;
				continue;
			default:
				return false;
			}
		case 1070:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1071:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1065:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1072;
				continue;
			default:
				return false;
			}
		case 1072:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1073;
				continue;
			case 0x2642u:
				state = 1074;
				continue;
			default:
				return false;
			}
		case 1073:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1074:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1066:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1075;
				continue;
			default:
				return false;
			}
		case 1075:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1076;
				continue;
			case 0x2642u:
				state = 1077;
				continue;
			default:
				return false;
			}
		case 1076:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1077:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1067:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1078;
				continue;
			default:
				return false;
			}
		case 1078:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1079;
				continue;
			case 0x2642u:
				state = 1080;
				continue;
			default:
				return false;
			}
		case 1079:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1080:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1068:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1081;
				continue;
			default:
				return false;
			}
		case 1081:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1082;
				continue;
			case 0x2642u:
				state = 1083;
				continue;
			default:
				return false;
			}
		case 1082:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1083:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 662:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 1084;
				continue;
			default:
				return false;
			}
		case 1084:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 1085;
				continue;
			case 0xdffcu:
				state = 1086;
				continue;
			case 0xdffdu:
				state = 1087;
				continue;
			case 0xdffeu:
				state = 1088;
				continue;
			case 0xdfffu:
				state = 1089;
				continue;
			default:
				return false;
			}
		case 1085:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1090;
				continue;
			default:
				return false;
			}
		case 1090:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1091;
				continue;
			case 0x2642u:
				state = 1092;
				continue;
			default:
				return false;
			}
		case 1091:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1092:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1086:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1093;
				continue;
			default:
				return false;
			}
		case 1093:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1094;
				continue;
			case 0x2642u:
				state = 1095;
				continue;
			default:
				return false;
			}
		case 1094:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1095:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1087:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1096;
				continue;
			default:
				return false;
			}
		case 1096:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1097;
				continue;
			case 0x2642u:
				state = 1098;
				continue;
			default:
				return false;
			}
		case 1097:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1098:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1088:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1099;
				continue;
			default:
				return false;
			}
		case 1099:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1100;
				continue;
			case 0x2642u:
				state = 1101;
				continue;
			default:
				return false;
			}
		case 1100:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1101:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1089:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1102;
				continue;
			default:
				return false;
			}
		case 1102:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1103;
				continue;
			case 0x2642u:
				state = 1104;
				continue;
			default:
				return false;
			}
		case 1103:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1104:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 663:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 1105;
				continue;
			default:
				return false;
			}
		case 1105:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 1106;
				continue;
			case 0xdffcu:
				state = 1107;
				continue;
			case 0xdffdu:
				state = 1108;
				continue;
			case 0xdffeu:
				state = 1109;
				continue;
			case 0xdfffu:
				state = 1110;
				continue;
			default:
				return false;
			}
		case 1106:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1111;
				continue;
			default:
				return false;
			}
		case 1111:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1112;
				continue;
			case 0x2642u:
				state = 1113;
				continue;
			default:
				return false;
			}
		case 1112:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1113:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1107:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1114;
				continue;
			default:
				return false;
			}
		case 1114:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1115;
				continue;
			case 0x2642u:
				state = 1116;
				continue;
			default:
				return false;
			}
		case 1115:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1116:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1108:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1117;
				continue;
			default:
				return false;
			}
		case 1117:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1118;
				continue;
			case 0x2642u:
				state = 1119;
				continue;
			default:
				return false;
			}
		case 1118:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1119:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1109:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1120;
				continue;
			default:
				return false;
			}
		case 1120:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1121;
				continue;
			case 0x2642u:
				state = 1122;
				continue;
			default:
				return false;
			}
		case 1121:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1122:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1110:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1123;
				continue;
			default:
				return false;
			}
		case 1123:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1124;
				continue;
			case 0x2642u:
				state = 1125;
				continue;
			default:
				return false;
			}
		case 1124:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1125:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 664:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 1126;
				continue;
			default:
				return false;
			}
		case 1126:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 1127;
				continue;
			case 0xdffcu:
				state = 1128;
				continue;
			case 0xdffdu:
				state = 1129;
				continue;
			case 0xdffeu:
				state = 1130;
				continue;
			case 0xdfffu:
				state = 1131;
				continue;
			default:
				return false;
			}
		case 1127:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1132;
				continue;
			default:
				return false;
			}
		case 1132:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1133;
				continue;
			case 0x2642u:
				state = 1134;
				continue;
			default:
				return false;
			}
		case 1133:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1134:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1128:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1135;
				continue;
			default:
				return false;
			}
		case 1135:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1136;
				continue;
			case 0x2642u:
				state = 1137;
				continue;
			default:
				return false;
			}
		case 1136:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1137:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1129:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1138;
				continue;
			default:
				return false;
			}
		case 1138:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1139;
				continue;
			case 0x2642u:
				state = 1140;
				continue;
			default:
				return false;
			}
		case 1139:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1140:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1130:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1141;
				continue;
			default:
				return false;
			}
		case 1141:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1142;
				continue;
			case 0x2642u:
				state = 1143;
				continue;
			default:
				return false;
			}
		case 1142:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1143:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1131:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 1144;
				continue;
			default:
				return false;
			}
		case 1144:
			switch(input[offset + 5].unicode()) {
			case 0x2640u:
				state = 1145;
				continue;
			case 0x2642u:
				state = 1146;
				continue;
			default:
				return false;
			}
		case 1145:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		case 1146:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				return true;
			default:
				return false;
			}
		default:
			Q_ASSERT_X(false, "emojiMatch7", "Invalid state");
			return false;
		}
	}
}

static bool emojiMatch8(const QString &input, int offset)
{
	int state = 0;
	while(true) {
		switch(state) {
		case 0:
			switch(input[offset + 0].unicode()) {
			case 0xd83du:
				state = 1;
				continue;
			case 0xd83eu:
				state = 2;
				continue;
			default:
				return false;
			}
		case 1:
			switch(input[offset + 1].unicode()) {
			case 0xdc68u:
				state = 3;
				continue;
			case 0xdc69u:
				state = 4;
				continue;
			default:
				return false;
			}
		case 3:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 5;
				continue;
			default:
				return false;
			}
		case 5:
			switch(input[offset + 3].unicode()) {
			case 0x2764u:
				state = 6;
				continue;
			case 0xd83du:
				state = 7;
				continue;
			default:
				return false;
			}
		case 6:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				state = 8;
				continue;
			default:
				return false;
			}
		case 8:
			switch(input[offset + 5].unicode()) {
			case 0x200du:
				state = 9;
				continue;
			default:
				return false;
			}
		case 9:
			switch(input[offset + 6].unicode()) {
			case 0xd83du:
				state = 10;
				continue;
			default:
				return false;
			}
		case 10:
			switch(input[offset + 7].unicode()) {
			case 0xdc68u:
				return true;
			default:
				return false;
			}
		case 7:
			switch(input[offset + 4].unicode()) {
			case 0xdc66u:
				state = 11;
				continue;
			case 0xdc67u:
				state = 12;
				continue;
			case 0xdc68u:
				state = 13;
				continue;
			case 0xdc69u:
				state = 14;
				continue;
			default:
				return false;
			}
		case 11:
			switch(input[offset + 5].unicode()) {
			case 0x200du:
				state = 15;
				continue;
			default:
				return false;
			}
		case 15:
			switch(input[offset + 6].unicode()) {
			case 0xd83du:
				state = 16;
				continue;
			default:
				return false;
			}
		case 16:
			switch(input[offset + 7].unicode()) {
			case 0xdc66u:
				return true;
			default:
				return false;
			}
		case 12:
			switch(input[offset + 5].unicode()) {
			case 0x200du:
				state = 17;
				continue;
			default:
				return false;
			}
		case 17:
			switch(input[offset + 6].unicode()) {
			case 0xd83du:
				state = 18;
				continue;
			default:
				return false;
			}
		case 18:
			switch(input[offset + 7].unicode()) {
			case 0xdc66u:
			case 0xdc67u:
				return true;
			default:
				return false;
			}
		case 13:
			switch(input[offset + 5].unicode()) {
			case 0x200du:
				state = 19;
				continue;
			default:
				return false;
			}
		case 19:
			switch(input[offset + 6].unicode()) {
			case 0xd83du:
				state = 20;
				continue;
			default:
				return false;
			}
		case 20:
			switch(input[offset + 7].unicode()) {
			case 0xdc66u:
			case 0xdc67u:
				return true;
			default:
				return false;
			}
		case 14:
			switch(input[offset + 5].unicode()) {
			case 0x200du:
				state = 21;
				continue;
			default:
				return false;
			}
		case 21:
			switch(input[offset + 6].unicode()) {
			case 0xd83du:
				state = 22;
				continue;
			default:
				return false;
			}
		case 22:
			switch(input[offset + 7].unicode()) {
			case 0xdc66u:
			case 0xdc67u:
				return true;
			default:
				return false;
			}
		case 4:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 23;
				continue;
			default:
				return false;
			}
		case 23:
			switch(input[offset + 3].unicode()) {
			case 0x2764u:
				state = 24;
				continue;
			case 0xd83du:
				state = 25;
				continue;
			default:
				return false;
			}
		case 24:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				state = 26;
				continue;
			default:
				return false;
			}
		case 26:
			switch(input[offset + 5].unicode()) {
			case 0x200du:
				state = 27;
				continue;
			default:
				return false;
			}
		case 27:
			switch(input[offset + 6].unicode()) {
			case 0xd83du:
				state = 28;
				continue;
			default:
				return false;
			}
		case 28:
			switch(input[offset + 7].unicode()) {
			case 0xdc68u:
			case 0xdc69u:
				return true;
			default:
				return false;
			}
		case 25:
			switch(input[offset + 4].unicode()) {
			case 0xdc66u:
				state = 29;
				continue;
			case 0xdc67u:
				state = 30;
				continue;
			case 0xdc69u:
				state = 31;
				continue;
			default:
				return false;
			}
		case 29:
			switch(input[offset + 5].unicode()) {
			case 0x200du:
				state = 32;
				continue;
			default:
				return false;
			}
		case 32:
			switch(input[offset + 6].unicode()) {
			case 0xd83du:
				state = 33;
				continue;
			default:
				return false;
			}
		case 33:
			switch(input[offset + 7].unicode()) {
			case 0xdc66u:
				return true;
			default:
				return false;
			}
		case 30:
			switch(input[offset + 5].unicode()) {
			case 0x200du:
				state = 34;
				continue;
			default:
				return false;
			}
		case 34:
			switch(input[offset + 6].unicode()) {
			case 0xd83du:
				state = 35;
				continue;
			default:
				return false;
			}
		case 35:
			switch(input[offset + 7].unicode()) {
			case 0xdc66u:
			case 0xdc67u:
				return true;
			default:
				return false;
			}
		case 31:
			switch(input[offset + 5].unicode()) {
			case 0x200du:
				state = 36;
				continue;
			default:
				return false;
			}
		case 36:
			switch(input[offset + 6].unicode()) {
			case 0xd83du:
				state = 37;
				continue;
			default:
				return false;
			}
		case 37:
			switch(input[offset + 7].unicode()) {
			case 0xdc66u:
			case 0xdc67u:
				return true;
			default:
				return false;
			}
		case 2:
			switch(input[offset + 1].unicode()) {
			case 0xddd1u:
				state = 38;
				continue;
			default:
				return false;
			}
		case 38:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 39;
				continue;
			default:
				return false;
			}
		case 39:
			switch(input[offset + 3].unicode()) {
			case 0xd83eu:
				state = 40;
				continue;
			default:
				return false;
			}
		case 40:
			switch(input[offset + 4].unicode()) {
			case 0xdd1du:
				state = 41;
				continue;
			default:
				return false;
			}
		case 41:
			switch(input[offset + 5].unicode()) {
			case 0x200du:
				state = 42;
				continue;
			default:
				return false;
			}
		case 42:
			switch(input[offset + 6].unicode()) {
			case 0xd83eu:
				state = 43;
				continue;
			default:
				return false;
			}
		case 43:
			switch(input[offset + 7].unicode()) {
			case 0xddd1u:
				return true;
			default:
				return false;
			}
		default:
			Q_ASSERT_X(false, "emojiMatch8", "Invalid state");
			return false;
		}
	}
}

static bool emojiMatch9(const QString &input, int offset)
{
	int state = 0;
	while(true) {
		switch(state) {
		case 0:
			switch(input[offset + 0].unicode()) {
			case 0xd83eu:
				state = 1;
				continue;
			default:
				return false;
			}
		case 1:
			switch(input[offset + 1].unicode()) {
			case 0xdef1u:
				state = 2;
				continue;
			default:
				return false;
			}
		case 2:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 3;
				continue;
			default:
				return false;
			}
		case 3:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 4;
				continue;
			case 0xdffcu:
				state = 5;
				continue;
			case 0xdffdu:
				state = 6;
				continue;
			case 0xdffeu:
				state = 7;
				continue;
			case 0xdfffu:
				state = 8;
				continue;
			default:
				return false;
			}
		case 4:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 9;
				continue;
			default:
				return false;
			}
		case 9:
			switch(input[offset + 5].unicode()) {
			case 0xd83eu:
				state = 10;
				continue;
			default:
				return false;
			}
		case 10:
			switch(input[offset + 6].unicode()) {
			case 0xdef2u:
				state = 11;
				continue;
			default:
				return false;
			}
		case 11:
			switch(input[offset + 7].unicode()) {
			case 0xd83cu:
				state = 12;
				continue;
			default:
				return false;
			}
		case 12:
			switch(input[offset + 8].unicode()) {
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 5:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 13;
				continue;
			default:
				return false;
			}
		case 13:
			switch(input[offset + 5].unicode()) {
			case 0xd83eu:
				state = 14;
				continue;
			default:
				return false;
			}
		case 14:
			switch(input[offset + 6].unicode()) {
			case 0xdef2u:
				state = 15;
				continue;
			default:
				return false;
			}
		case 15:
			switch(input[offset + 7].unicode()) {
			case 0xd83cu:
				state = 16;
				continue;
			default:
				return false;
			}
		case 16:
			switch(input[offset + 8].unicode()) {
			case 0xdffbu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 6:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 17;
				continue;
			default:
				return false;
			}
		case 17:
			switch(input[offset + 5].unicode()) {
			case 0xd83eu:
				state = 18;
				continue;
			default:
				return false;
			}
		case 18:
			switch(input[offset + 6].unicode()) {
			case 0xdef2u:
				state = 19;
				continue;
			default:
				return false;
			}
		case 19:
			switch(input[offset + 7].unicode()) {
			case 0xd83cu:
				state = 20;
				continue;
			default:
				return false;
			}
		case 20:
			switch(input[offset + 8].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 7:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 21;
				continue;
			default:
				return false;
			}
		case 21:
			switch(input[offset + 5].unicode()) {
			case 0xd83eu:
				state = 22;
				continue;
			default:
				return false;
			}
		case 22:
			switch(input[offset + 6].unicode()) {
			case 0xdef2u:
				state = 23;
				continue;
			default:
				return false;
			}
		case 23:
			switch(input[offset + 7].unicode()) {
			case 0xd83cu:
				state = 24;
				continue;
			default:
				return false;
			}
		case 24:
			switch(input[offset + 8].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 8:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 25;
				continue;
			default:
				return false;
			}
		case 25:
			switch(input[offset + 5].unicode()) {
			case 0xd83eu:
				state = 26;
				continue;
			default:
				return false;
			}
		case 26:
			switch(input[offset + 6].unicode()) {
			case 0xdef2u:
				state = 27;
				continue;
			default:
				return false;
			}
		case 27:
			switch(input[offset + 7].unicode()) {
			case 0xd83cu:
				state = 28;
				continue;
			default:
				return false;
			}
		case 28:
			switch(input[offset + 8].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
				return true;
			default:
				return false;
			}
		default:
			Q_ASSERT_X(false, "emojiMatch9", "Invalid state");
			return false;
		}
	}
}

static bool emojiMatch11(const QString &input, int offset)
{
	int state = 0;
	while(true) {
		switch(state) {
		case 0:
			switch(input[offset + 0].unicode()) {
			case 0xd83du:
				state = 1;
				continue;
			default:
				return false;
			}
		case 1:
			switch(input[offset + 1].unicode()) {
			case 0xdc68u:
				state = 2;
				continue;
			case 0xdc69u:
				state = 3;
				continue;
			default:
				return false;
			}
		case 2:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 4;
				continue;
			default:
				return false;
			}
		case 4:
			switch(input[offset + 3].unicode()) {
			case 0x2764u:
				state = 5;
				continue;
			case 0xd83du:
				state = 6;
				continue;
			default:
				return false;
			}
		case 5:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				state = 7;
				continue;
			default:
				return false;
			}
		case 7:
			switch(input[offset + 5].unicode()) {
			case 0x200du:
				state = 8;
				continue;
			default:
				return false;
			}
		case 8:
			switch(input[offset + 6].unicode()) {
			case 0xd83du:
				state = 9;
				continue;
			default:
				return false;
			}
		case 9:
			switch(input[offset + 7].unicode()) {
			case 0xdc8bu:
				state = 10;
				continue;
			default:
				return false;
			}
		case 10:
			switch(input[offset + 8].unicode()) {
			case 0x200du:
				state = 11;
				continue;
			default:
				return false;
			}
		case 11:
			switch(input[offset + 9].unicode()) {
			case 0xd83du:
				state = 12;
				continue;
			default:
				return false;
			}
		case 12:
			switch(input[offset + 10].unicode()) {
			case 0xdc68u:
				return true;
			default:
				return false;
			}
		case 6:
			switch(input[offset + 4].unicode()) {
			case 0xdc68u:
				state = 13;
				continue;
			case 0xdc69u:
				state = 14;
				continue;
			default:
				return false;
			}
		case 13:
			switch(input[offset + 5].unicode()) {
			case 0x200du:
				state = 15;
				continue;
			default:
				return false;
			}
		case 15:
			switch(input[offset + 6].unicode()) {
			case 0xd83du:
				state = 16;
				continue;
			default:
				return false;
			}
		case 16:
			switch(input[offset + 7].unicode()) {
			case 0xdc66u:
				state = 17;
				continue;
			case 0xdc67u:
				state = 18;
				continue;
			default:
				return false;
			}
		case 17:
			switch(input[offset + 8].unicode()) {
			case 0x200du:
				state = 19;
				continue;
			default:
				return false;
			}
		case 19:
			switch(input[offset + 9].unicode()) {
			case 0xd83du:
				state = 20;
				continue;
			default:
				return false;
			}
		case 20:
			switch(input[offset + 10].unicode()) {
			case 0xdc66u:
				return true;
			default:
				return false;
			}
		case 18:
			switch(input[offset + 8].unicode()) {
			case 0x200du:
				state = 21;
				continue;
			default:
				return false;
			}
		case 21:
			switch(input[offset + 9].unicode()) {
			case 0xd83du:
				state = 22;
				continue;
			default:
				return false;
			}
		case 22:
			switch(input[offset + 10].unicode()) {
			case 0xdc66u:
			case 0xdc67u:
				return true;
			default:
				return false;
			}
		case 14:
			switch(input[offset + 5].unicode()) {
			case 0x200du:
				state = 23;
				continue;
			default:
				return false;
			}
		case 23:
			switch(input[offset + 6].unicode()) {
			case 0xd83du:
				state = 24;
				continue;
			default:
				return false;
			}
		case 24:
			switch(input[offset + 7].unicode()) {
			case 0xdc66u:
				state = 25;
				continue;
			case 0xdc67u:
				state = 26;
				continue;
			default:
				return false;
			}
		case 25:
			switch(input[offset + 8].unicode()) {
			case 0x200du:
				state = 27;
				continue;
			default:
				return false;
			}
		case 27:
			switch(input[offset + 9].unicode()) {
			case 0xd83du:
				state = 28;
				continue;
			default:
				return false;
			}
		case 28:
			switch(input[offset + 10].unicode()) {
			case 0xdc66u:
				return true;
			default:
				return false;
			}
		case 26:
			switch(input[offset + 8].unicode()) {
			case 0x200du:
				state = 29;
				continue;
			default:
				return false;
			}
		case 29:
			switch(input[offset + 9].unicode()) {
			case 0xd83du:
				state = 30;
				continue;
			default:
				return false;
			}
		case 30:
			switch(input[offset + 10].unicode()) {
			case 0xdc66u:
			case 0xdc67u:
				return true;
			default:
				return false;
			}
		case 3:
			switch(input[offset + 2].unicode()) {
			case 0x200du:
				state = 31;
				continue;
			default:
				return false;
			}
		case 31:
			switch(input[offset + 3].unicode()) {
			case 0x2764u:
				state = 32;
				continue;
			case 0xd83du:
				state = 33;
				continue;
			default:
				return false;
			}
		case 32:
			switch(input[offset + 4].unicode()) {
			case 0xfe0fu:
				state = 34;
				continue;
			default:
				return false;
			}
		case 34:
			switch(input[offset + 5].unicode()) {
			case 0x200du:
				state = 35;
				continue;
			default:
				return false;
			}
		case 35:
			switch(input[offset + 6].unicode()) {
			case 0xd83du:
				state = 36;
				continue;
			default:
				return false;
			}
		case 36:
			switch(input[offset + 7].unicode()) {
			case 0xdc8bu:
				state = 37;
				continue;
			default:
				return false;
			}
		case 37:
			switch(input[offset + 8].unicode()) {
			case 0x200du:
				state = 38;
				continue;
			default:
				return false;
			}
		case 38:
			switch(input[offset + 9].unicode()) {
			case 0xd83du:
				state = 39;
				continue;
			default:
				return false;
			}
		case 39:
			switch(input[offset + 10].unicode()) {
			case 0xdc68u:
			case 0xdc69u:
				return true;
			default:
				return false;
			}
		case 33:
			switch(input[offset + 4].unicode()) {
			case 0xdc69u:
				state = 40;
				continue;
			default:
				return false;
			}
		case 40:
			switch(input[offset + 5].unicode()) {
			case 0x200du:
				state = 41;
				continue;
			default:
				return false;
			}
		case 41:
			switch(input[offset + 6].unicode()) {
			case 0xd83du:
				state = 42;
				continue;
			default:
				return false;
			}
		case 42:
			switch(input[offset + 7].unicode()) {
			case 0xdc66u:
				state = 43;
				continue;
			case 0xdc67u:
				state = 44;
				continue;
			default:
				return false;
			}
		case 43:
			switch(input[offset + 8].unicode()) {
			case 0x200du:
				state = 45;
				continue;
			default:
				return false;
			}
		case 45:
			switch(input[offset + 9].unicode()) {
			case 0xd83du:
				state = 46;
				continue;
			default:
				return false;
			}
		case 46:
			switch(input[offset + 10].unicode()) {
			case 0xdc66u:
				return true;
			default:
				return false;
			}
		case 44:
			switch(input[offset + 8].unicode()) {
			case 0x200du:
				state = 47;
				continue;
			default:
				return false;
			}
		case 47:
			switch(input[offset + 9].unicode()) {
			case 0xd83du:
				state = 48;
				continue;
			default:
				return false;
			}
		case 48:
			switch(input[offset + 10].unicode()) {
			case 0xdc66u:
			case 0xdc67u:
				return true;
			default:
				return false;
			}
		default:
			Q_ASSERT_X(false, "emojiMatch11", "Invalid state");
			return false;
		}
	}
}

static bool emojiMatch12(const QString &input, int offset)
{
	int state = 0;
	while(true) {
		switch(state) {
		case 0:
			switch(input[offset + 0].unicode()) {
			case 0xd83du:
				state = 1;
				continue;
			case 0xd83eu:
				state = 2;
				continue;
			default:
				return false;
			}
		case 1:
			switch(input[offset + 1].unicode()) {
			case 0xdc68u:
				state = 3;
				continue;
			case 0xdc69u:
				state = 4;
				continue;
			default:
				return false;
			}
		case 3:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 5;
				continue;
			default:
				return false;
			}
		case 5:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 6;
				continue;
			case 0xdffcu:
				state = 7;
				continue;
			case 0xdffdu:
				state = 8;
				continue;
			case 0xdffeu:
				state = 9;
				continue;
			case 0xdfffu:
				state = 10;
				continue;
			default:
				return false;
			}
		case 6:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 11;
				continue;
			default:
				return false;
			}
		case 11:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 12;
				continue;
			case 0xd83eu:
				state = 13;
				continue;
			default:
				return false;
			}
		case 12:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 14;
				continue;
			default:
				return false;
			}
		case 14:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 15;
				continue;
			default:
				return false;
			}
		case 15:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 16;
				continue;
			default:
				return false;
			}
		case 16:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 17;
				continue;
			default:
				return false;
			}
		case 17:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 18;
				continue;
			default:
				return false;
			}
		case 18:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 13:
			switch(input[offset + 6].unicode()) {
			case 0xdd1du:
				state = 19;
				continue;
			default:
				return false;
			}
		case 19:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 20;
				continue;
			default:
				return false;
			}
		case 20:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 21;
				continue;
			default:
				return false;
			}
		case 21:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 22;
				continue;
			default:
				return false;
			}
		case 22:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 23;
				continue;
			default:
				return false;
			}
		case 23:
			switch(input[offset + 11].unicode()) {
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 7:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 24;
				continue;
			default:
				return false;
			}
		case 24:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 25;
				continue;
			case 0xd83eu:
				state = 26;
				continue;
			default:
				return false;
			}
		case 25:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 27;
				continue;
			default:
				return false;
			}
		case 27:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 28;
				continue;
			default:
				return false;
			}
		case 28:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 29;
				continue;
			default:
				return false;
			}
		case 29:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 30;
				continue;
			default:
				return false;
			}
		case 30:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 31;
				continue;
			default:
				return false;
			}
		case 31:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 26:
			switch(input[offset + 6].unicode()) {
			case 0xdd1du:
				state = 32;
				continue;
			default:
				return false;
			}
		case 32:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 33;
				continue;
			default:
				return false;
			}
		case 33:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 34;
				continue;
			default:
				return false;
			}
		case 34:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 35;
				continue;
			default:
				return false;
			}
		case 35:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 36;
				continue;
			default:
				return false;
			}
		case 36:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 8:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 37;
				continue;
			default:
				return false;
			}
		case 37:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 38;
				continue;
			case 0xd83eu:
				state = 39;
				continue;
			default:
				return false;
			}
		case 38:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 40;
				continue;
			default:
				return false;
			}
		case 40:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 41;
				continue;
			default:
				return false;
			}
		case 41:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 42;
				continue;
			default:
				return false;
			}
		case 42:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 43;
				continue;
			default:
				return false;
			}
		case 43:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 44;
				continue;
			default:
				return false;
			}
		case 44:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 39:
			switch(input[offset + 6].unicode()) {
			case 0xdd1du:
				state = 45;
				continue;
			default:
				return false;
			}
		case 45:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 46;
				continue;
			default:
				return false;
			}
		case 46:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 47;
				continue;
			default:
				return false;
			}
		case 47:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 48;
				continue;
			default:
				return false;
			}
		case 48:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 49;
				continue;
			default:
				return false;
			}
		case 49:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 9:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 50;
				continue;
			default:
				return false;
			}
		case 50:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 51;
				continue;
			case 0xd83eu:
				state = 52;
				continue;
			default:
				return false;
			}
		case 51:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 53;
				continue;
			default:
				return false;
			}
		case 53:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 54;
				continue;
			default:
				return false;
			}
		case 54:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 55;
				continue;
			default:
				return false;
			}
		case 55:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 56;
				continue;
			default:
				return false;
			}
		case 56:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 57;
				continue;
			default:
				return false;
			}
		case 57:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 52:
			switch(input[offset + 6].unicode()) {
			case 0xdd1du:
				state = 58;
				continue;
			default:
				return false;
			}
		case 58:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 59;
				continue;
			default:
				return false;
			}
		case 59:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 60;
				continue;
			default:
				return false;
			}
		case 60:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 61;
				continue;
			default:
				return false;
			}
		case 61:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 62;
				continue;
			default:
				return false;
			}
		case 62:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 10:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 63;
				continue;
			default:
				return false;
			}
		case 63:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 64;
				continue;
			case 0xd83eu:
				state = 65;
				continue;
			default:
				return false;
			}
		case 64:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 66;
				continue;
			default:
				return false;
			}
		case 66:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 67;
				continue;
			default:
				return false;
			}
		case 67:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 68;
				continue;
			default:
				return false;
			}
		case 68:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 69;
				continue;
			default:
				return false;
			}
		case 69:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 70;
				continue;
			default:
				return false;
			}
		case 70:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 65:
			switch(input[offset + 6].unicode()) {
			case 0xdd1du:
				state = 71;
				continue;
			default:
				return false;
			}
		case 71:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 72;
				continue;
			default:
				return false;
			}
		case 72:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 73;
				continue;
			default:
				return false;
			}
		case 73:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 74;
				continue;
			default:
				return false;
			}
		case 74:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 75;
				continue;
			default:
				return false;
			}
		case 75:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
				return true;
			default:
				return false;
			}
		case 4:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 76;
				continue;
			default:
				return false;
			}
		case 76:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 77;
				continue;
			case 0xdffcu:
				state = 78;
				continue;
			case 0xdffdu:
				state = 79;
				continue;
			case 0xdffeu:
				state = 80;
				continue;
			case 0xdfffu:
				state = 81;
				continue;
			default:
				return false;
			}
		case 77:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 82;
				continue;
			default:
				return false;
			}
		case 82:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 83;
				continue;
			case 0xd83eu:
				state = 84;
				continue;
			default:
				return false;
			}
		case 83:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 85;
				continue;
			default:
				return false;
			}
		case 85:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 86;
				continue;
			default:
				return false;
			}
		case 86:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 87;
				continue;
			default:
				return false;
			}
		case 87:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 88;
				continue;
			case 0xdc69u:
				state = 89;
				continue;
			default:
				return false;
			}
		case 88:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 90;
				continue;
			default:
				return false;
			}
		case 90:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 89:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 91;
				continue;
			default:
				return false;
			}
		case 91:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 84:
			switch(input[offset + 6].unicode()) {
			case 0xdd1du:
				state = 92;
				continue;
			default:
				return false;
			}
		case 92:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 93;
				continue;
			default:
				return false;
			}
		case 93:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 94;
				continue;
			default:
				return false;
			}
		case 94:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 95;
				continue;
			case 0xdc69u:
				state = 96;
				continue;
			default:
				return false;
			}
		case 95:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 97;
				continue;
			default:
				return false;
			}
		case 97:
			switch(input[offset + 11].unicode()) {
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 96:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 98;
				continue;
			default:
				return false;
			}
		case 98:
			switch(input[offset + 11].unicode()) {
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 78:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 99;
				continue;
			default:
				return false;
			}
		case 99:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 100;
				continue;
			case 0xd83eu:
				state = 101;
				continue;
			default:
				return false;
			}
		case 100:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 102;
				continue;
			default:
				return false;
			}
		case 102:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 103;
				continue;
			default:
				return false;
			}
		case 103:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 104;
				continue;
			default:
				return false;
			}
		case 104:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 105;
				continue;
			case 0xdc69u:
				state = 106;
				continue;
			default:
				return false;
			}
		case 105:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 107;
				continue;
			default:
				return false;
			}
		case 107:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 106:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 108;
				continue;
			default:
				return false;
			}
		case 108:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 101:
			switch(input[offset + 6].unicode()) {
			case 0xdd1du:
				state = 109;
				continue;
			default:
				return false;
			}
		case 109:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 110;
				continue;
			default:
				return false;
			}
		case 110:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 111;
				continue;
			default:
				return false;
			}
		case 111:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 112;
				continue;
			case 0xdc69u:
				state = 113;
				continue;
			default:
				return false;
			}
		case 112:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 114;
				continue;
			default:
				return false;
			}
		case 114:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 113:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 115;
				continue;
			default:
				return false;
			}
		case 115:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 79:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 116;
				continue;
			default:
				return false;
			}
		case 116:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 117;
				continue;
			case 0xd83eu:
				state = 118;
				continue;
			default:
				return false;
			}
		case 117:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 119;
				continue;
			default:
				return false;
			}
		case 119:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 120;
				continue;
			default:
				return false;
			}
		case 120:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 121;
				continue;
			default:
				return false;
			}
		case 121:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 122;
				continue;
			case 0xdc69u:
				state = 123;
				continue;
			default:
				return false;
			}
		case 122:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 124;
				continue;
			default:
				return false;
			}
		case 124:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 123:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 125;
				continue;
			default:
				return false;
			}
		case 125:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 118:
			switch(input[offset + 6].unicode()) {
			case 0xdd1du:
				state = 126;
				continue;
			default:
				return false;
			}
		case 126:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 127;
				continue;
			default:
				return false;
			}
		case 127:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 128;
				continue;
			default:
				return false;
			}
		case 128:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 129;
				continue;
			case 0xdc69u:
				state = 130;
				continue;
			default:
				return false;
			}
		case 129:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 131;
				continue;
			default:
				return false;
			}
		case 131:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 130:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 132;
				continue;
			default:
				return false;
			}
		case 132:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 80:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 133;
				continue;
			default:
				return false;
			}
		case 133:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 134;
				continue;
			case 0xd83eu:
				state = 135;
				continue;
			default:
				return false;
			}
		case 134:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 136;
				continue;
			default:
				return false;
			}
		case 136:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 137;
				continue;
			default:
				return false;
			}
		case 137:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 138;
				continue;
			default:
				return false;
			}
		case 138:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 139;
				continue;
			case 0xdc69u:
				state = 140;
				continue;
			default:
				return false;
			}
		case 139:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 141;
				continue;
			default:
				return false;
			}
		case 141:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 140:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 142;
				continue;
			default:
				return false;
			}
		case 142:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 135:
			switch(input[offset + 6].unicode()) {
			case 0xdd1du:
				state = 143;
				continue;
			default:
				return false;
			}
		case 143:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 144;
				continue;
			default:
				return false;
			}
		case 144:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 145;
				continue;
			default:
				return false;
			}
		case 145:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 146;
				continue;
			case 0xdc69u:
				state = 147;
				continue;
			default:
				return false;
			}
		case 146:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 148;
				continue;
			default:
				return false;
			}
		case 148:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 147:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 149;
				continue;
			default:
				return false;
			}
		case 149:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 81:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 150;
				continue;
			default:
				return false;
			}
		case 150:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 151;
				continue;
			case 0xd83eu:
				state = 152;
				continue;
			default:
				return false;
			}
		case 151:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 153;
				continue;
			default:
				return false;
			}
		case 153:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 154;
				continue;
			default:
				return false;
			}
		case 154:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 155;
				continue;
			default:
				return false;
			}
		case 155:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 156;
				continue;
			case 0xdc69u:
				state = 157;
				continue;
			default:
				return false;
			}
		case 156:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 158;
				continue;
			default:
				return false;
			}
		case 158:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 157:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 159;
				continue;
			default:
				return false;
			}
		case 159:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 152:
			switch(input[offset + 6].unicode()) {
			case 0xdd1du:
				state = 160;
				continue;
			default:
				return false;
			}
		case 160:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 161;
				continue;
			default:
				return false;
			}
		case 161:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 162;
				continue;
			default:
				return false;
			}
		case 162:
			switch(input[offset + 9].unicode()) {
			case 0xdc68u:
				state = 163;
				continue;
			case 0xdc69u:
				state = 164;
				continue;
			default:
				return false;
			}
		case 163:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 165;
				continue;
			default:
				return false;
			}
		case 165:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
				return true;
			default:
				return false;
			}
		case 164:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 166;
				continue;
			default:
				return false;
			}
		case 166:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
				return true;
			default:
				return false;
			}
		case 2:
			switch(input[offset + 1].unicode()) {
			case 0xddd1u:
				state = 167;
				continue;
			default:
				return false;
			}
		case 167:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 168;
				continue;
			default:
				return false;
			}
		case 168:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 169;
				continue;
			case 0xdffcu:
				state = 170;
				continue;
			case 0xdffdu:
				state = 171;
				continue;
			case 0xdffeu:
				state = 172;
				continue;
			case 0xdfffu:
				state = 173;
				continue;
			default:
				return false;
			}
		case 169:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 174;
				continue;
			default:
				return false;
			}
		case 174:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 175;
				continue;
			case 0xd83eu:
				state = 176;
				continue;
			default:
				return false;
			}
		case 175:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 177;
				continue;
			default:
				return false;
			}
		case 177:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 178;
				continue;
			default:
				return false;
			}
		case 178:
			switch(input[offset + 8].unicode()) {
			case 0xd83eu:
				state = 179;
				continue;
			default:
				return false;
			}
		case 179:
			switch(input[offset + 9].unicode()) {
			case 0xddd1u:
				state = 180;
				continue;
			default:
				return false;
			}
		case 180:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 181;
				continue;
			default:
				return false;
			}
		case 181:
			switch(input[offset + 11].unicode()) {
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 176:
			switch(input[offset + 6].unicode()) {
			case 0xdd1du:
				state = 182;
				continue;
			default:
				return false;
			}
		case 182:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 183;
				continue;
			default:
				return false;
			}
		case 183:
			switch(input[offset + 8].unicode()) {
			case 0xd83eu:
				state = 184;
				continue;
			default:
				return false;
			}
		case 184:
			switch(input[offset + 9].unicode()) {
			case 0xddd1u:
				state = 185;
				continue;
			default:
				return false;
			}
		case 185:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 186;
				continue;
			default:
				return false;
			}
		case 186:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 170:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 187;
				continue;
			default:
				return false;
			}
		case 187:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 188;
				continue;
			case 0xd83eu:
				state = 189;
				continue;
			default:
				return false;
			}
		case 188:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 190;
				continue;
			default:
				return false;
			}
		case 190:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 191;
				continue;
			default:
				return false;
			}
		case 191:
			switch(input[offset + 8].unicode()) {
			case 0xd83eu:
				state = 192;
				continue;
			default:
				return false;
			}
		case 192:
			switch(input[offset + 9].unicode()) {
			case 0xddd1u:
				state = 193;
				continue;
			default:
				return false;
			}
		case 193:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 194;
				continue;
			default:
				return false;
			}
		case 194:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 189:
			switch(input[offset + 6].unicode()) {
			case 0xdd1du:
				state = 195;
				continue;
			default:
				return false;
			}
		case 195:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 196;
				continue;
			default:
				return false;
			}
		case 196:
			switch(input[offset + 8].unicode()) {
			case 0xd83eu:
				state = 197;
				continue;
			default:
				return false;
			}
		case 197:
			switch(input[offset + 9].unicode()) {
			case 0xddd1u:
				state = 198;
				continue;
			default:
				return false;
			}
		case 198:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 199;
				continue;
			default:
				return false;
			}
		case 199:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 171:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 200;
				continue;
			default:
				return false;
			}
		case 200:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 201;
				continue;
			case 0xd83eu:
				state = 202;
				continue;
			default:
				return false;
			}
		case 201:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 203;
				continue;
			default:
				return false;
			}
		case 203:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 204;
				continue;
			default:
				return false;
			}
		case 204:
			switch(input[offset + 8].unicode()) {
			case 0xd83eu:
				state = 205;
				continue;
			default:
				return false;
			}
		case 205:
			switch(input[offset + 9].unicode()) {
			case 0xddd1u:
				state = 206;
				continue;
			default:
				return false;
			}
		case 206:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 207;
				continue;
			default:
				return false;
			}
		case 207:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 202:
			switch(input[offset + 6].unicode()) {
			case 0xdd1du:
				state = 208;
				continue;
			default:
				return false;
			}
		case 208:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 209;
				continue;
			default:
				return false;
			}
		case 209:
			switch(input[offset + 8].unicode()) {
			case 0xd83eu:
				state = 210;
				continue;
			default:
				return false;
			}
		case 210:
			switch(input[offset + 9].unicode()) {
			case 0xddd1u:
				state = 211;
				continue;
			default:
				return false;
			}
		case 211:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 212;
				continue;
			default:
				return false;
			}
		case 212:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 172:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 213;
				continue;
			default:
				return false;
			}
		case 213:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 214;
				continue;
			case 0xd83eu:
				state = 215;
				continue;
			default:
				return false;
			}
		case 214:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 216;
				continue;
			default:
				return false;
			}
		case 216:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 217;
				continue;
			default:
				return false;
			}
		case 217:
			switch(input[offset + 8].unicode()) {
			case 0xd83eu:
				state = 218;
				continue;
			default:
				return false;
			}
		case 218:
			switch(input[offset + 9].unicode()) {
			case 0xddd1u:
				state = 219;
				continue;
			default:
				return false;
			}
		case 219:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 220;
				continue;
			default:
				return false;
			}
		case 220:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 215:
			switch(input[offset + 6].unicode()) {
			case 0xdd1du:
				state = 221;
				continue;
			default:
				return false;
			}
		case 221:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 222;
				continue;
			default:
				return false;
			}
		case 222:
			switch(input[offset + 8].unicode()) {
			case 0xd83eu:
				state = 223;
				continue;
			default:
				return false;
			}
		case 223:
			switch(input[offset + 9].unicode()) {
			case 0xddd1u:
				state = 224;
				continue;
			default:
				return false;
			}
		case 224:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 225;
				continue;
			default:
				return false;
			}
		case 225:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 173:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 226;
				continue;
			default:
				return false;
			}
		case 226:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 227;
				continue;
			case 0xd83eu:
				state = 228;
				continue;
			default:
				return false;
			}
		case 227:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 229;
				continue;
			default:
				return false;
			}
		case 229:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 230;
				continue;
			default:
				return false;
			}
		case 230:
			switch(input[offset + 8].unicode()) {
			case 0xd83eu:
				state = 231;
				continue;
			default:
				return false;
			}
		case 231:
			switch(input[offset + 9].unicode()) {
			case 0xddd1u:
				state = 232;
				continue;
			default:
				return false;
			}
		case 232:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 233;
				continue;
			default:
				return false;
			}
		case 233:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
				return true;
			default:
				return false;
			}
		case 228:
			switch(input[offset + 6].unicode()) {
			case 0xdd1du:
				state = 234;
				continue;
			default:
				return false;
			}
		case 234:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 235;
				continue;
			default:
				return false;
			}
		case 235:
			switch(input[offset + 8].unicode()) {
			case 0xd83eu:
				state = 236;
				continue;
			default:
				return false;
			}
		case 236:
			switch(input[offset + 9].unicode()) {
			case 0xddd1u:
				state = 237;
				continue;
			default:
				return false;
			}
		case 237:
			switch(input[offset + 10].unicode()) {
			case 0xd83cu:
				state = 238;
				continue;
			default:
				return false;
			}
		case 238:
			switch(input[offset + 11].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		default:
			Q_ASSERT_X(false, "emojiMatch12", "Invalid state");
			return false;
		}
	}
}

static bool emojiMatch14(const QString &input, int offset)
{
	int state = 0;
	while(true) {
		switch(state) {
		case 0:
			switch(input[offset + 0].unicode()) {
			case 0xd83cu:
				state = 1;
				continue;
			default:
				return false;
			}
		case 1:
			switch(input[offset + 1].unicode()) {
			case 0xdff4u:
				state = 2;
				continue;
			default:
				return false;
			}
		case 2:
			switch(input[offset + 2].unicode()) {
			case 0xdb40u:
				state = 3;
				continue;
			default:
				return false;
			}
		case 3:
			switch(input[offset + 3].unicode()) {
			case 0xdc67u:
				state = 4;
				continue;
			default:
				return false;
			}
		case 4:
			switch(input[offset + 4].unicode()) {
			case 0xdb40u:
				state = 5;
				continue;
			default:
				return false;
			}
		case 5:
			switch(input[offset + 5].unicode()) {
			case 0xdc62u:
				state = 6;
				continue;
			default:
				return false;
			}
		case 6:
			switch(input[offset + 6].unicode()) {
			case 0xdb40u:
				state = 7;
				continue;
			default:
				return false;
			}
		case 7:
			switch(input[offset + 7].unicode()) {
			case 0xdc65u:
				state = 8;
				continue;
			case 0xdc73u:
				state = 9;
				continue;
			case 0xdc77u:
				state = 10;
				continue;
			default:
				return false;
			}
		case 8:
			switch(input[offset + 8].unicode()) {
			case 0xdb40u:
				state = 11;
				continue;
			default:
				return false;
			}
		case 11:
			switch(input[offset + 9].unicode()) {
			case 0xdc6eu:
				state = 12;
				continue;
			default:
				return false;
			}
		case 12:
			switch(input[offset + 10].unicode()) {
			case 0xdb40u:
				state = 13;
				continue;
			default:
				return false;
			}
		case 13:
			switch(input[offset + 11].unicode()) {
			case 0xdc67u:
				state = 14;
				continue;
			default:
				return false;
			}
		case 14:
			switch(input[offset + 12].unicode()) {
			case 0xdb40u:
				state = 15;
				continue;
			default:
				return false;
			}
		case 15:
			switch(input[offset + 13].unicode()) {
			case 0xdc7fu:
				return true;
			default:
				return false;
			}
		case 9:
			switch(input[offset + 8].unicode()) {
			case 0xdb40u:
				state = 16;
				continue;
			default:
				return false;
			}
		case 16:
			switch(input[offset + 9].unicode()) {
			case 0xdc63u:
				state = 17;
				continue;
			default:
				return false;
			}
		case 17:
			switch(input[offset + 10].unicode()) {
			case 0xdb40u:
				state = 18;
				continue;
			default:
				return false;
			}
		case 18:
			switch(input[offset + 11].unicode()) {
			case 0xdc74u:
				state = 19;
				continue;
			default:
				return false;
			}
		case 19:
			switch(input[offset + 12].unicode()) {
			case 0xdb40u:
				state = 20;
				continue;
			default:
				return false;
			}
		case 20:
			switch(input[offset + 13].unicode()) {
			case 0xdc7fu:
				return true;
			default:
				return false;
			}
		case 10:
			switch(input[offset + 8].unicode()) {
			case 0xdb40u:
				state = 21;
				continue;
			default:
				return false;
			}
		case 21:
			switch(input[offset + 9].unicode()) {
			case 0xdc6cu:
				state = 22;
				continue;
			default:
				return false;
			}
		case 22:
			switch(input[offset + 10].unicode()) {
			case 0xdb40u:
				state = 23;
				continue;
			default:
				return false;
			}
		case 23:
			switch(input[offset + 11].unicode()) {
			case 0xdc73u:
				state = 24;
				continue;
			default:
				return false;
			}
		case 24:
			switch(input[offset + 12].unicode()) {
			case 0xdb40u:
				state = 25;
				continue;
			default:
				return false;
			}
		case 25:
			switch(input[offset + 13].unicode()) {
			case 0xdc7fu:
				return true;
			default:
				return false;
			}
		default:
			Q_ASSERT_X(false, "emojiMatch14", "Invalid state");
			return false;
		}
	}
}

static bool emojiMatch15(const QString &input, int offset)
{
	int state = 0;
	while(true) {
		switch(state) {
		case 0:
			switch(input[offset + 0].unicode()) {
			case 0xd83du:
				state = 1;
				continue;
			case 0xd83eu:
				state = 2;
				continue;
			default:
				return false;
			}
		case 1:
			switch(input[offset + 1].unicode()) {
			case 0xdc68u:
				state = 3;
				continue;
			case 0xdc69u:
				state = 4;
				continue;
			default:
				return false;
			}
		case 3:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 5;
				continue;
			default:
				return false;
			}
		case 5:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 6;
				continue;
			case 0xdffcu:
				state = 7;
				continue;
			case 0xdffdu:
				state = 8;
				continue;
			case 0xdffeu:
				state = 9;
				continue;
			case 0xdfffu:
				state = 10;
				continue;
			default:
				return false;
			}
		case 6:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 11;
				continue;
			default:
				return false;
			}
		case 11:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 12;
				continue;
			default:
				return false;
			}
		case 12:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 13;
				continue;
			default:
				return false;
			}
		case 13:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 14;
				continue;
			default:
				return false;
			}
		case 14:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 15;
				continue;
			default:
				return false;
			}
		case 15:
			switch(input[offset + 9].unicode()) {
			case 0xdc8bu:
				state = 16;
				continue;
			default:
				return false;
			}
		case 16:
			switch(input[offset + 10].unicode()) {
			case 0x200du:
				state = 17;
				continue;
			default:
				return false;
			}
		case 17:
			switch(input[offset + 11].unicode()) {
			case 0xd83du:
				state = 18;
				continue;
			default:
				return false;
			}
		case 18:
			switch(input[offset + 12].unicode()) {
			case 0xdc68u:
				state = 19;
				continue;
			default:
				return false;
			}
		case 19:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 20;
				continue;
			default:
				return false;
			}
		case 20:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 7:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 21;
				continue;
			default:
				return false;
			}
		case 21:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 22;
				continue;
			default:
				return false;
			}
		case 22:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 23;
				continue;
			default:
				return false;
			}
		case 23:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 24;
				continue;
			default:
				return false;
			}
		case 24:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 25;
				continue;
			default:
				return false;
			}
		case 25:
			switch(input[offset + 9].unicode()) {
			case 0xdc8bu:
				state = 26;
				continue;
			default:
				return false;
			}
		case 26:
			switch(input[offset + 10].unicode()) {
			case 0x200du:
				state = 27;
				continue;
			default:
				return false;
			}
		case 27:
			switch(input[offset + 11].unicode()) {
			case 0xd83du:
				state = 28;
				continue;
			default:
				return false;
			}
		case 28:
			switch(input[offset + 12].unicode()) {
			case 0xdc68u:
				state = 29;
				continue;
			default:
				return false;
			}
		case 29:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 30;
				continue;
			default:
				return false;
			}
		case 30:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 8:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 31;
				continue;
			default:
				return false;
			}
		case 31:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 32;
				continue;
			default:
				return false;
			}
		case 32:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 33;
				continue;
			default:
				return false;
			}
		case 33:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 34;
				continue;
			default:
				return false;
			}
		case 34:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 35;
				continue;
			default:
				return false;
			}
		case 35:
			switch(input[offset + 9].unicode()) {
			case 0xdc8bu:
				state = 36;
				continue;
			default:
				return false;
			}
		case 36:
			switch(input[offset + 10].unicode()) {
			case 0x200du:
				state = 37;
				continue;
			default:
				return false;
			}
		case 37:
			switch(input[offset + 11].unicode()) {
			case 0xd83du:
				state = 38;
				continue;
			default:
				return false;
			}
		case 38:
			switch(input[offset + 12].unicode()) {
			case 0xdc68u:
				state = 39;
				continue;
			default:
				return false;
			}
		case 39:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 40;
				continue;
			default:
				return false;
			}
		case 40:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 9:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 41;
				continue;
			default:
				return false;
			}
		case 41:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 42;
				continue;
			default:
				return false;
			}
		case 42:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 43;
				continue;
			default:
				return false;
			}
		case 43:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 44;
				continue;
			default:
				return false;
			}
		case 44:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 45;
				continue;
			default:
				return false;
			}
		case 45:
			switch(input[offset + 9].unicode()) {
			case 0xdc8bu:
				state = 46;
				continue;
			default:
				return false;
			}
		case 46:
			switch(input[offset + 10].unicode()) {
			case 0x200du:
				state = 47;
				continue;
			default:
				return false;
			}
		case 47:
			switch(input[offset + 11].unicode()) {
			case 0xd83du:
				state = 48;
				continue;
			default:
				return false;
			}
		case 48:
			switch(input[offset + 12].unicode()) {
			case 0xdc68u:
				state = 49;
				continue;
			default:
				return false;
			}
		case 49:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 50;
				continue;
			default:
				return false;
			}
		case 50:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 10:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 51;
				continue;
			default:
				return false;
			}
		case 51:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 52;
				continue;
			default:
				return false;
			}
		case 52:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 53;
				continue;
			default:
				return false;
			}
		case 53:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 54;
				continue;
			default:
				return false;
			}
		case 54:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 55;
				continue;
			default:
				return false;
			}
		case 55:
			switch(input[offset + 9].unicode()) {
			case 0xdc8bu:
				state = 56;
				continue;
			default:
				return false;
			}
		case 56:
			switch(input[offset + 10].unicode()) {
			case 0x200du:
				state = 57;
				continue;
			default:
				return false;
			}
		case 57:
			switch(input[offset + 11].unicode()) {
			case 0xd83du:
				state = 58;
				continue;
			default:
				return false;
			}
		case 58:
			switch(input[offset + 12].unicode()) {
			case 0xdc68u:
				state = 59;
				continue;
			default:
				return false;
			}
		case 59:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 60;
				continue;
			default:
				return false;
			}
		case 60:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 4:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 61;
				continue;
			default:
				return false;
			}
		case 61:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 62;
				continue;
			case 0xdffcu:
				state = 63;
				continue;
			case 0xdffdu:
				state = 64;
				continue;
			case 0xdffeu:
				state = 65;
				continue;
			case 0xdfffu:
				state = 66;
				continue;
			default:
				return false;
			}
		case 62:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 67;
				continue;
			default:
				return false;
			}
		case 67:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 68;
				continue;
			default:
				return false;
			}
		case 68:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 69;
				continue;
			default:
				return false;
			}
		case 69:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 70;
				continue;
			default:
				return false;
			}
		case 70:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 71;
				continue;
			default:
				return false;
			}
		case 71:
			switch(input[offset + 9].unicode()) {
			case 0xdc8bu:
				state = 72;
				continue;
			default:
				return false;
			}
		case 72:
			switch(input[offset + 10].unicode()) {
			case 0x200du:
				state = 73;
				continue;
			default:
				return false;
			}
		case 73:
			switch(input[offset + 11].unicode()) {
			case 0xd83du:
				state = 74;
				continue;
			default:
				return false;
			}
		case 74:
			switch(input[offset + 12].unicode()) {
			case 0xdc68u:
				state = 75;
				continue;
			case 0xdc69u:
				state = 76;
				continue;
			default:
				return false;
			}
		case 75:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 77;
				continue;
			default:
				return false;
			}
		case 77:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 76:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 78;
				continue;
			default:
				return false;
			}
		case 78:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 63:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 79;
				continue;
			default:
				return false;
			}
		case 79:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 80;
				continue;
			default:
				return false;
			}
		case 80:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 81;
				continue;
			default:
				return false;
			}
		case 81:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 82;
				continue;
			default:
				return false;
			}
		case 82:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 83;
				continue;
			default:
				return false;
			}
		case 83:
			switch(input[offset + 9].unicode()) {
			case 0xdc8bu:
				state = 84;
				continue;
			default:
				return false;
			}
		case 84:
			switch(input[offset + 10].unicode()) {
			case 0x200du:
				state = 85;
				continue;
			default:
				return false;
			}
		case 85:
			switch(input[offset + 11].unicode()) {
			case 0xd83du:
				state = 86;
				continue;
			default:
				return false;
			}
		case 86:
			switch(input[offset + 12].unicode()) {
			case 0xdc68u:
				state = 87;
				continue;
			case 0xdc69u:
				state = 88;
				continue;
			default:
				return false;
			}
		case 87:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 89;
				continue;
			default:
				return false;
			}
		case 89:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 88:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 90;
				continue;
			default:
				return false;
			}
		case 90:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 64:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 91;
				continue;
			default:
				return false;
			}
		case 91:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 92;
				continue;
			default:
				return false;
			}
		case 92:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 93;
				continue;
			default:
				return false;
			}
		case 93:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 94;
				continue;
			default:
				return false;
			}
		case 94:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 95;
				continue;
			default:
				return false;
			}
		case 95:
			switch(input[offset + 9].unicode()) {
			case 0xdc8bu:
				state = 96;
				continue;
			default:
				return false;
			}
		case 96:
			switch(input[offset + 10].unicode()) {
			case 0x200du:
				state = 97;
				continue;
			default:
				return false;
			}
		case 97:
			switch(input[offset + 11].unicode()) {
			case 0xd83du:
				state = 98;
				continue;
			default:
				return false;
			}
		case 98:
			switch(input[offset + 12].unicode()) {
			case 0xdc68u:
				state = 99;
				continue;
			case 0xdc69u:
				state = 100;
				continue;
			default:
				return false;
			}
		case 99:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 101;
				continue;
			default:
				return false;
			}
		case 101:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 100:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 102;
				continue;
			default:
				return false;
			}
		case 102:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 65:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 103;
				continue;
			default:
				return false;
			}
		case 103:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 104;
				continue;
			default:
				return false;
			}
		case 104:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 105;
				continue;
			default:
				return false;
			}
		case 105:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 106;
				continue;
			default:
				return false;
			}
		case 106:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 107;
				continue;
			default:
				return false;
			}
		case 107:
			switch(input[offset + 9].unicode()) {
			case 0xdc8bu:
				state = 108;
				continue;
			default:
				return false;
			}
		case 108:
			switch(input[offset + 10].unicode()) {
			case 0x200du:
				state = 109;
				continue;
			default:
				return false;
			}
		case 109:
			switch(input[offset + 11].unicode()) {
			case 0xd83du:
				state = 110;
				continue;
			default:
				return false;
			}
		case 110:
			switch(input[offset + 12].unicode()) {
			case 0xdc68u:
				state = 111;
				continue;
			case 0xdc69u:
				state = 112;
				continue;
			default:
				return false;
			}
		case 111:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 113;
				continue;
			default:
				return false;
			}
		case 113:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 112:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 114;
				continue;
			default:
				return false;
			}
		case 114:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 66:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 115;
				continue;
			default:
				return false;
			}
		case 115:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 116;
				continue;
			default:
				return false;
			}
		case 116:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 117;
				continue;
			default:
				return false;
			}
		case 117:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 118;
				continue;
			default:
				return false;
			}
		case 118:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 119;
				continue;
			default:
				return false;
			}
		case 119:
			switch(input[offset + 9].unicode()) {
			case 0xdc8bu:
				state = 120;
				continue;
			default:
				return false;
			}
		case 120:
			switch(input[offset + 10].unicode()) {
			case 0x200du:
				state = 121;
				continue;
			default:
				return false;
			}
		case 121:
			switch(input[offset + 11].unicode()) {
			case 0xd83du:
				state = 122;
				continue;
			default:
				return false;
			}
		case 122:
			switch(input[offset + 12].unicode()) {
			case 0xdc68u:
				state = 123;
				continue;
			case 0xdc69u:
				state = 124;
				continue;
			default:
				return false;
			}
		case 123:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 125;
				continue;
			default:
				return false;
			}
		case 125:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 124:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 126;
				continue;
			default:
				return false;
			}
		case 126:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 2:
			switch(input[offset + 1].unicode()) {
			case 0xddd1u:
				state = 127;
				continue;
			default:
				return false;
			}
		case 127:
			switch(input[offset + 2].unicode()) {
			case 0xd83cu:
				state = 128;
				continue;
			default:
				return false;
			}
		case 128:
			switch(input[offset + 3].unicode()) {
			case 0xdffbu:
				state = 129;
				continue;
			case 0xdffcu:
				state = 130;
				continue;
			case 0xdffdu:
				state = 131;
				continue;
			case 0xdffeu:
				state = 132;
				continue;
			case 0xdfffu:
				state = 133;
				continue;
			default:
				return false;
			}
		case 129:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 134;
				continue;
			default:
				return false;
			}
		case 134:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 135;
				continue;
			default:
				return false;
			}
		case 135:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 136;
				continue;
			default:
				return false;
			}
		case 136:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 137;
				continue;
			default:
				return false;
			}
		case 137:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 138;
				continue;
			default:
				return false;
			}
		case 138:
			switch(input[offset + 9].unicode()) {
			case 0xdc8bu:
				state = 139;
				continue;
			default:
				return false;
			}
		case 139:
			switch(input[offset + 10].unicode()) {
			case 0x200du:
				state = 140;
				continue;
			default:
				return false;
			}
		case 140:
			switch(input[offset + 11].unicode()) {
			case 0xd83eu:
				state = 141;
				continue;
			default:
				return false;
			}
		case 141:
			switch(input[offset + 12].unicode()) {
			case 0xddd1u:
				state = 142;
				continue;
			default:
				return false;
			}
		case 142:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 143;
				continue;
			default:
				return false;
			}
		case 143:
			switch(input[offset + 14].unicode()) {
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 130:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 144;
				continue;
			default:
				return false;
			}
		case 144:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 145;
				continue;
			default:
				return false;
			}
		case 145:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 146;
				continue;
			default:
				return false;
			}
		case 146:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 147;
				continue;
			default:
				return false;
			}
		case 147:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 148;
				continue;
			default:
				return false;
			}
		case 148:
			switch(input[offset + 9].unicode()) {
			case 0xdc8bu:
				state = 149;
				continue;
			default:
				return false;
			}
		case 149:
			switch(input[offset + 10].unicode()) {
			case 0x200du:
				state = 150;
				continue;
			default:
				return false;
			}
		case 150:
			switch(input[offset + 11].unicode()) {
			case 0xd83eu:
				state = 151;
				continue;
			default:
				return false;
			}
		case 151:
			switch(input[offset + 12].unicode()) {
			case 0xddd1u:
				state = 152;
				continue;
			default:
				return false;
			}
		case 152:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 153;
				continue;
			default:
				return false;
			}
		case 153:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffdu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 131:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 154;
				continue;
			default:
				return false;
			}
		case 154:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 155;
				continue;
			default:
				return false;
			}
		case 155:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 156;
				continue;
			default:
				return false;
			}
		case 156:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 157;
				continue;
			default:
				return false;
			}
		case 157:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 158;
				continue;
			default:
				return false;
			}
		case 158:
			switch(input[offset + 9].unicode()) {
			case 0xdc8bu:
				state = 159;
				continue;
			default:
				return false;
			}
		case 159:
			switch(input[offset + 10].unicode()) {
			case 0x200du:
				state = 160;
				continue;
			default:
				return false;
			}
		case 160:
			switch(input[offset + 11].unicode()) {
			case 0xd83eu:
				state = 161;
				continue;
			default:
				return false;
			}
		case 161:
			switch(input[offset + 12].unicode()) {
			case 0xddd1u:
				state = 162;
				continue;
			default:
				return false;
			}
		case 162:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 163;
				continue;
			default:
				return false;
			}
		case 163:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffeu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 132:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 164;
				continue;
			default:
				return false;
			}
		case 164:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 165;
				continue;
			default:
				return false;
			}
		case 165:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 166;
				continue;
			default:
				return false;
			}
		case 166:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 167;
				continue;
			default:
				return false;
			}
		case 167:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 168;
				continue;
			default:
				return false;
			}
		case 168:
			switch(input[offset + 9].unicode()) {
			case 0xdc8bu:
				state = 169;
				continue;
			default:
				return false;
			}
		case 169:
			switch(input[offset + 10].unicode()) {
			case 0x200du:
				state = 170;
				continue;
			default:
				return false;
			}
		case 170:
			switch(input[offset + 11].unicode()) {
			case 0xd83eu:
				state = 171;
				continue;
			default:
				return false;
			}
		case 171:
			switch(input[offset + 12].unicode()) {
			case 0xddd1u:
				state = 172;
				continue;
			default:
				return false;
			}
		case 172:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 173;
				continue;
			default:
				return false;
			}
		case 173:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdfffu:
				return true;
			default:
				return false;
			}
		case 133:
			switch(input[offset + 4].unicode()) {
			case 0x200du:
				state = 174;
				continue;
			default:
				return false;
			}
		case 174:
			switch(input[offset + 5].unicode()) {
			case 0x2764u:
				state = 175;
				continue;
			default:
				return false;
			}
		case 175:
			switch(input[offset + 6].unicode()) {
			case 0xfe0fu:
				state = 176;
				continue;
			default:
				return false;
			}
		case 176:
			switch(input[offset + 7].unicode()) {
			case 0x200du:
				state = 177;
				continue;
			default:
				return false;
			}
		case 177:
			switch(input[offset + 8].unicode()) {
			case 0xd83du:
				state = 178;
				continue;
			default:
				return false;
			}
		case 178:
			switch(input[offset + 9].unicode()) {
			case 0xdc8bu:
				state = 179;
				continue;
			default:
				return false;
			}
		case 179:
			switch(input[offset + 10].unicode()) {
			case 0x200du:
				state = 180;
				continue;
			default:
				return false;
			}
		case 180:
			switch(input[offset + 11].unicode()) {
			case 0xd83eu:
				state = 181;
				continue;
			default:
				return false;
			}
		case 181:
			switch(input[offset + 12].unicode()) {
			case 0xddd1u:
				state = 182;
				continue;
			default:
				return false;
			}
		case 182:
			switch(input[offset + 13].unicode()) {
			case 0xd83cu:
				state = 183;
				continue;
			default:
				return false;
			}
		case 183:
			switch(input[offset + 14].unicode()) {
			case 0xdffbu:
			case 0xdffcu:
			case 0xdffdu:
			case 0xdffeu:
				return true;
			default:
				return false;
			}
		default:
			Q_ASSERT_X(false, "emojiMatch15", "Invalid state");
			return false;
		}
	}
}

QString emojify(const QString &in, const QString &replacement)
{
	QString out;
	int len = in.length();
	int pos = 0;
	int i = 0;
	while(i < len) {
		int remaining = len - i;
		if(remaining >= 15 && emojiMatch15(in, i)) {
			out.append(in.mid(pos, i - pos));
			out.append(replacement.arg(in.mid(i, 15)));
			i += 15;
			pos = i;
		} else if(remaining >= 14 && emojiMatch14(in, i)) {
			out.append(in.mid(pos, i - pos));
			out.append(replacement.arg(in.mid(i, 14)));
			i += 14;
			pos = i;
		} else if(remaining >= 12 && emojiMatch12(in, i)) {
			out.append(in.mid(pos, i - pos));
			out.append(replacement.arg(in.mid(i, 12)));
			i += 12;
			pos = i;
		} else if(remaining >= 11 && emojiMatch11(in, i)) {
			out.append(in.mid(pos, i - pos));
			out.append(replacement.arg(in.mid(i, 11)));
			i += 11;
			pos = i;
		} else if(remaining >= 9 && emojiMatch9(in, i)) {
			out.append(in.mid(pos, i - pos));
			out.append(replacement.arg(in.mid(i, 9)));
			i += 9;
			pos = i;
		} else if(remaining >= 8 && emojiMatch8(in, i)) {
			out.append(in.mid(pos, i - pos));
			out.append(replacement.arg(in.mid(i, 8)));
			i += 8;
			pos = i;
		} else if(remaining >= 7 && emojiMatch7(in, i)) {
			out.append(in.mid(pos, i - pos));
			out.append(replacement.arg(in.mid(i, 7)));
			i += 7;
			pos = i;
		} else if(remaining >= 6 && emojiMatch6(in, i)) {
			out.append(in.mid(pos, i - pos));
			out.append(replacement.arg(in.mid(i, 6)));
			i += 6;
			pos = i;
		} else if(remaining >= 5 && emojiMatch5(in, i)) {
			out.append(in.mid(pos, i - pos));
			out.append(replacement.arg(in.mid(i, 5)));
			i += 5;
			pos = i;
		} else if(remaining >= 4 && emojiMatch4(in, i)) {
			out.append(in.mid(pos, i - pos));
			out.append(replacement.arg(in.mid(i, 4)));
			i += 4;
			pos = i;
		} else if(remaining >= 3 && emojiMatch3(in, i)) {
			out.append(in.mid(pos, i - pos));
			out.append(replacement.arg(in.mid(i, 3)));
			i += 3;
			pos = i;
		} else if(remaining >= 2 && emojiMatch2(in, i)) {
			out.append(in.mid(pos, i - pos));
			out.append(replacement.arg(in.mid(i, 2)));
			i += 2;
			pos = i;
		} else if(remaining >= 1 && emojiMatch1(in, i)) {
			out.append(in.mid(pos, i - pos));
			out.append(replacement.arg(in.mid(i, 1)));
			i += 1;
			pos = i;
		} else {
			++i;
		}
	}

	if(pos == 0) {
		return in;
	} else {
		out.append(in.mid(pos));
		return out;
	}
}

}
