/*
 * Copyright (c) 2022 askmeaboutloom
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#ifndef DP_WORKER_H
#define DP_WORKER_H
#include "common.h"


typedef struct DP_Worker DP_Worker;

typedef void (*DP_WorkerJobFn)(void *element, int thread_index);

int DP_worker_cpu_count(int max);

DP_Worker *DP_worker_new(size_t initial_capacity, size_t element_size,
                         int thread_count, DP_WorkerJobFn job_fn);

void DP_worker_free_join(DP_Worker *worker);

int DP_worker_thread_count(DP_Worker *worker);

void DP_worker_push_with(DP_Worker *worker,
                         void (*insert_element)(void *user, void *element),
                         void *user);

void DP_worker_push(DP_Worker *worker, void *element);


#endif
