/*
 * Copyright (C) 2022 askmeaboutloom
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * --------------------------------------------------------------------
 *
 * This code is auto-generated by generators/protogen/protogen_drawdance.py
 * from generators/protogen/messages.h.jinja. Don't edit it directly.
 */
#ifndef DPMSG_MESSAGES_H
#define DPMSG_MESSAGES_H
#include <dpcommon/common.h>

typedef struct DP_Message DP_Message;
typedef struct DP_TextReader DP_TextReader;
typedef struct DP_TextWriter DP_TextWriter;

typedef void (*DP_MessageLocalMatchSetFn)(size_t, unsigned char *, void *);

#define DP_PROTOCOL_VERSION_NAMESPACE        "dp"
#define DP_PROTOCOL_VERSION_SERVER           4
#define DP_PROTOCOL_VERSION_MAJOR            25
#define DP_PROTOCOL_VERSION_MINOR            1
#define DP_PROTOCOL_VERSION                  "dp:4.25.1"
#define DP_PROTOCOL_COMPAT_VERSION_NAMESPACE "dp"
#define DP_PROTOCOL_COMPAT_VERSION_SERVER    4
#define DP_PROTOCOL_COMPAT_VERSION_MAJOR     24
#define DP_PROTOCOL_COMPAT_VERSION_MINOR     0
#define DP_PROTOCOL_COMPAT_VERSION           "dp:4.24.0"
#define DP_UNDO_DEPTH_DEFAULT                30

typedef struct DP_MessageMethods {
    size_t (*payload_length)(DP_Message *msg);
    size_t (*serialize_payload)(DP_Message *msg, unsigned char *data);
    size_t (*payload_length_compat)(DP_Message *msg);
    size_t (*serialize_payload_compat)(DP_Message *msg, unsigned char *data);
    bool (*write_payload_text)(DP_Message *msg, DP_TextWriter *writer);
    bool (*equals)(DP_Message *DP_RESTRICT msg, DP_Message *DP_RESTRICT other);
} DP_MessageMethods;

typedef enum DP_MessageType {
    DP_MSG_SERVER_COMMAND = 0,
    DP_MSG_DISCONNECT = 1,
    DP_MSG_PING = 2,
    DP_MSG_KEEP_ALIVE = 3,
    DP_MSG_THUMBNAIL = 4,
    DP_MSG_INTERNAL = 31,
    DP_MSG_JOIN = 32,
    DP_MSG_LEAVE = 33,
    DP_MSG_SESSION_OWNER = 34,
    DP_MSG_CHAT = 35,
    DP_MSG_TRUSTED_USERS = 36,
    DP_MSG_SOFT_RESET = 37,
    DP_MSG_PRIVATE_CHAT = 38,
    DP_MSG_RESET_STREAM = 39,
    DP_MSG_INTERVAL = 64,
    DP_MSG_LASER_TRAIL = 65,
    DP_MSG_MOVE_POINTER = 66,
    DP_MSG_REMOVED_MARKER = 67,
    DP_MSG_USER_ACL = 68,
    DP_MSG_LAYER_ACL = 69,
    DP_MSG_FEATURE_ACCESS_LEVELS = 70,
    DP_MSG_DEFAULT_LAYER = 71,
    DP_MSG_REMOVED_FILTERED = 72,
    DP_MSG_EXTENSION = 73,
    DP_MSG_UNDO_DEPTH = 74,
    DP_MSG_DATA = 75,
    DP_MSG_LOCAL_CHANGE = 76,
    DP_MSG_FEATURE_LIMITS = 77,
    DP_MSG_UNDO_POINT = 128,
    DP_MSG_CANVAS_RESIZE = 129,
    DP_MSG_REMOVED_LAYER_CREATE = 130,
    DP_MSG_LAYER_ATTRIBUTES = 131,
    DP_MSG_LAYER_RETITLE = 132,
    DP_MSG_REMOVED_LAYER_ORDER = 133,
    DP_MSG_REMOVED_LAYER_DELETE = 134,
    DP_MSG_REMOVED_LAYER_VISIBILITY = 135,
    DP_MSG_PUT_IMAGE = 136,
    DP_MSG_FILL_RECT = 137,
    DP_MSG_REMOVED_TOOL_CHANGE = 138,
    DP_MSG_REMOVED_PEN_MOVE = 139,
    DP_MSG_PEN_UP = 140,
    DP_MSG_ANNOTATION_CREATE = 141,
    DP_MSG_ANNOTATION_RESHAPE = 142,
    DP_MSG_ANNOTATION_EDIT = 143,
    DP_MSG_ANNOTATION_DELETE = 144,
    DP_MSG_REMOVED_MOVE_REGION = 145,
    DP_MSG_PUT_TILE = 146,
    DP_MSG_CANVAS_BACKGROUND = 147,
    DP_MSG_DRAW_DABS_CLASSIC = 148,
    DP_MSG_DRAW_DABS_PIXEL = 149,
    DP_MSG_DRAW_DABS_PIXEL_SQUARE = 150,
    DP_MSG_DRAW_DABS_MYPAINT = 151,
    DP_MSG_DRAW_DABS_MYPAINT_BLEND = 152,
    DP_MSG_MOVE_RECT = 160,
    DP_MSG_SET_METADATA_INT = 161,
    DP_MSG_LAYER_TREE_CREATE = 162,
    DP_MSG_LAYER_TREE_MOVE = 163,
    DP_MSG_LAYER_TREE_DELETE = 164,
    DP_MSG_TRANSFORM_REGION = 165,
    DP_MSG_TRACK_CREATE = 166,
    DP_MSG_TRACK_RETITLE = 167,
    DP_MSG_TRACK_DELETE = 168,
    DP_MSG_TRACK_ORDER = 169,
    DP_MSG_KEY_FRAME_SET = 170,
    DP_MSG_KEY_FRAME_RETITLE = 171,
    DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES = 172,
    DP_MSG_KEY_FRAME_DELETE = 173,
    DP_MSG_SELECTION_PUT = 174,
    DP_MSG_SELECTION_CLEAR = 175,
    DP_MSG_LOCAL_MATCH = 176,
    DP_MSG_SYNC_SELECTION_TILE = 177,
    DP_MSG_PUT_IMAGE_ZSTD = 178,
    DP_MSG_PUT_TILE_ZSTD = 179,
    DP_MSG_CANVAS_BACKGROUND_ZSTD = 180,
    DP_MSG_MOVE_RECT_ZSTD = 181,
    DP_MSG_TRANSFORM_REGION_ZSTD = 182,
    DP_MSG_UNDO = 255,
    DP_MSG_TYPE_COUNT,
} DP_MessageType;

bool DP_message_type_control(DP_MessageType type);

bool DP_message_type_client_meta(DP_MessageType type);

bool DP_message_type_server_meta(DP_MessageType type);

bool DP_message_type_command(DP_MessageType type);

bool DP_message_type_compatible(DP_MessageType type);

const char *DP_message_type_name(DP_MessageType type);

const char *DP_message_type_enum_name(DP_MessageType type);

const char *DP_message_type_enum_name_unprefixed(DP_MessageType type);

DP_MessageType DP_message_type_from_name(const char *type_name,
                                         DP_MessageType not_found_value);


bool DP_message_dirties_canvas(DP_Message *msg);

DP_Message *DP_message_deserialize_body(int type, unsigned int context_id,
                                        const unsigned char *buf, size_t length,
                                        bool decode_opaque);

DP_Message *DP_message_deserialize_body_compat(int type,
                                               unsigned int context_id,
                                               const unsigned char *buf,
                                               size_t length,
                                               bool decode_opaque);

DP_Message *DP_message_parse_body(DP_MessageType type, unsigned int context_id,
                                  DP_TextReader *reader);


/*
 * DP_MSG_SERVER_COMMAND
 *
 * Server command message
 *
 * This is a general purpose message for sending commands to the server
 * and receiving replies. This is used for (among other things):
 *
 * - the login handshake
 * - setting session parameters (e.g. max user count and password)
 * - sending administration commands (e.g. kick user)
 */

#define DP_MSG_SERVER_COMMAND_STATIC_LENGTH        0
#define DP_MSG_SERVER_COMMAND_STATIC_LENGTH_COMPAT 0

#define DP_MSG_SERVER_COMMAND_MSG_MIN_LEN 0
#define DP_MSG_SERVER_COMMAND_MSG_MAX_LEN 65535

typedef struct DP_MsgServerCommand DP_MsgServerCommand;

DP_Message *DP_msg_server_command_new(unsigned int context_id,
                                      const char *msg_value, size_t msg_len);

DP_Message *DP_msg_server_command_deserialize(unsigned int context_id,
                                              const unsigned char *buffer,
                                              size_t length);

DP_Message *DP_msg_server_command_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_server_command_parse(unsigned int context_id,
                                        DP_TextReader *reader);

DP_MsgServerCommand *DP_msg_server_command_cast(DP_Message *msg);

const char *DP_msg_server_command_msg(const DP_MsgServerCommand *msc,
                                      size_t *out_len);

size_t DP_msg_server_command_msg_len(const DP_MsgServerCommand *msc);


/*
 * DP_MSG_DISCONNECT
 *
 * Disconnect notification
 *
 * This message is used when closing the connection gracefully. The message
 * queue will automatically close the socket after sending this message.
 */

#define DP_MSG_DISCONNECT_STATIC_LENGTH        1
#define DP_MSG_DISCONNECT_STATIC_LENGTH_COMPAT 1

#define DP_MSG_DISCONNECT_REASON_ERROR    0
#define DP_MSG_DISCONNECT_REASON_KICK     1
#define DP_MSG_DISCONNECT_REASON_SHUTDOWN 2
#define DP_MSG_DISCONNECT_REASON_OTHER    3

#define DP_MSG_DISCONNECT_NUM_REASON 4
#define DP_MSG_DISCONNECT_ALL_REASON                               \
    DP_MSG_DISCONNECT_REASON_ERROR, DP_MSG_DISCONNECT_REASON_KICK, \
        DP_MSG_DISCONNECT_REASON_SHUTDOWN, DP_MSG_DISCONNECT_REASON_OTHER

const char *DP_msg_disconnect_reason_variant_name(unsigned int value);

#define DP_MSG_DISCONNECT_MESSAGE_MIN_LEN 0
#define DP_MSG_DISCONNECT_MESSAGE_MAX_LEN 65534

typedef struct DP_MsgDisconnect DP_MsgDisconnect;

DP_Message *DP_msg_disconnect_new(unsigned int context_id, uint8_t reason,
                                  const char *message_value,
                                  size_t message_len);

DP_Message *DP_msg_disconnect_deserialize(unsigned int context_id,
                                          const unsigned char *buffer,
                                          size_t length);

DP_Message *DP_msg_disconnect_deserialize_compat(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length);

DP_Message *DP_msg_disconnect_parse(unsigned int context_id,
                                    DP_TextReader *reader);

DP_MsgDisconnect *DP_msg_disconnect_cast(DP_Message *msg);

uint8_t DP_msg_disconnect_reason(const DP_MsgDisconnect *md);

const char *DP_msg_disconnect_message(const DP_MsgDisconnect *md,
                                      size_t *out_len);

size_t DP_msg_disconnect_message_len(const DP_MsgDisconnect *md);


/*
 * DP_MSG_PING
 *
 * Ping message
 *
 * This is used for latency measurement as well as a keepalive. Normally, the
 * client should be the one to send the ping messages.
 *
 * The server should return a Ping with the is_pong flag set
 */

#define DP_MSG_PING_STATIC_LENGTH        1
#define DP_MSG_PING_STATIC_LENGTH_COMPAT 1

typedef struct DP_MsgPing DP_MsgPing;

DP_Message *DP_msg_ping_new(unsigned int context_id, bool is_pong);

DP_Message *DP_msg_ping_deserialize(unsigned int context_id,
                                    const unsigned char *buffer, size_t length);

DP_Message *DP_msg_ping_deserialize_compat(unsigned int context_id,
                                           const unsigned char *buffer,
                                           size_t length);

DP_Message *DP_msg_ping_parse(unsigned int context_id, DP_TextReader *reader);

DP_MsgPing *DP_msg_ping_cast(DP_Message *msg);

bool DP_msg_ping_is_pong(const DP_MsgPing *mp);


/*
 * DP_MSG_KEEP_ALIVE
 *
 * The client may indicate support for this during login, in which
 * case the server will send this kind of message if it did not send
 * anything else for a while. This is to make sure the client doesn't
 * run into an idle timeout if its upload queue is too saturated to
 * actually manage sending out a ping.
 */

#define DP_MSG_KEEP_ALIVE_STATIC_LENGTH        0
#define DP_MSG_KEEP_ALIVE_STATIC_LENGTH_COMPAT 0

DP_Message *DP_msg_keep_alive_new(unsigned int context_id);

DP_Message *DP_msg_keep_alive_deserialize(unsigned int context_id,
                                          const unsigned char *buffer,
                                          size_t length);

DP_Message *DP_msg_keep_alive_deserialize_compat(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length);

DP_Message *DP_msg_keep_alive_parse(unsigned int context_id,
                                    DP_TextReader *reader);


/*
 * DP_MSG_THUMBNAIL
 *
 * Message from the client to the server to provide a canvas
 * thumbnail. The data may be prefixed by a correlation sequence as
 * sent by the server, followed by the compressed image data in a
 * format like JPEG or WEBP. The server does not interpret this data.
 */

#define DP_MSG_THUMBNAIL_STATIC_LENGTH        0
#define DP_MSG_THUMBNAIL_STATIC_LENGTH_COMPAT 0

#define DP_MSG_THUMBNAIL_DATA_MIN_SIZE 0
#define DP_MSG_THUMBNAIL_DATA_MAX_SIZE 65535

typedef struct DP_MsgThumbnail DP_MsgThumbnail;

DP_Message *DP_msg_thumbnail_new(unsigned int context_id,
                                 void (*set_data)(size_t, unsigned char *,
                                                  void *),
                                 size_t data_size, void *data_user);

DP_Message *DP_msg_thumbnail_deserialize(unsigned int context_id,
                                         const unsigned char *buffer,
                                         size_t length);

DP_Message *DP_msg_thumbnail_deserialize_compat(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length);

DP_Message *DP_msg_thumbnail_parse(unsigned int context_id,
                                   DP_TextReader *reader);

DP_MsgThumbnail *DP_msg_thumbnail_cast(DP_Message *msg);

const unsigned char *DP_msg_thumbnail_data(const DP_MsgThumbnail *mt,
                                           size_t *out_size);

size_t DP_msg_thumbnail_data_size(const DP_MsgThumbnail *mt);


/*
 * DP_MSG_INTERNAL
 *
 * Reserved for internal use
 */


/*
 * DP_MSG_JOIN
 *
 * Inform the client of a new user
 *
 * This message is sent only be the server. It associates a username
 * with a context ID.
 */

#define DP_MSG_JOIN_STATIC_LENGTH        2
#define DP_MSG_JOIN_STATIC_LENGTH_COMPAT 2

#define DP_MSG_JOIN_FLAGS_AUTH 0x1
#define DP_MSG_JOIN_FLAGS_MOD  0x2
#define DP_MSG_JOIN_FLAGS_BOT  0x4
#define DP_MSG_JOIN_FLAGS_OLD  0x8

#define DP_MSG_JOIN_NUM_FLAGS 4
#define DP_MSG_JOIN_ALL_FLAGS                                             \
    DP_MSG_JOIN_FLAGS_AUTH, DP_MSG_JOIN_FLAGS_MOD, DP_MSG_JOIN_FLAGS_BOT, \
        DP_MSG_JOIN_FLAGS_OLD

const char *DP_msg_join_flags_flag_name(unsigned int value);

#define DP_MSG_JOIN_NAME_MIN_LEN 1
#define DP_MSG_JOIN_NAME_MAX_LEN 256

#define DP_MSG_JOIN_AVATAR_MIN_SIZE 0
#define DP_MSG_JOIN_AVATAR_MAX_SIZE 65533

typedef struct DP_MsgJoin DP_MsgJoin;

DP_Message *DP_msg_join_new(unsigned int context_id, uint8_t flags,
                            const char *name_value, size_t name_len,
                            void (*set_avatar)(size_t, unsigned char *, void *),
                            size_t avatar_size, void *avatar_user);

DP_Message *DP_msg_join_deserialize(unsigned int context_id,
                                    const unsigned char *buffer, size_t length);

DP_Message *DP_msg_join_deserialize_compat(unsigned int context_id,
                                           const unsigned char *buffer,
                                           size_t length);

DP_Message *DP_msg_join_parse(unsigned int context_id, DP_TextReader *reader);

DP_MsgJoin *DP_msg_join_cast(DP_Message *msg);

uint8_t DP_msg_join_flags(const DP_MsgJoin *mj);

const char *DP_msg_join_name(const DP_MsgJoin *mj, size_t *out_len);

size_t DP_msg_join_name_len(const DP_MsgJoin *mj);

const unsigned char *DP_msg_join_avatar(const DP_MsgJoin *mj, size_t *out_size);

size_t DP_msg_join_avatar_size(const DP_MsgJoin *mj);


/*
 * DP_MSG_LEAVE
 *
 * Inform the client of a user leaving
 *
 * This message is sent only by the server. Upon receiving this message,
 * clients will typically remove the user from the user listing. The client
 * is also allowed to release resources associated with this context ID.
 */

#define DP_MSG_LEAVE_STATIC_LENGTH        0
#define DP_MSG_LEAVE_STATIC_LENGTH_COMPAT 0

DP_Message *DP_msg_leave_new(unsigned int context_id);

DP_Message *DP_msg_leave_deserialize(unsigned int context_id,
                                     const unsigned char *buffer,
                                     size_t length);

DP_Message *DP_msg_leave_deserialize_compat(unsigned int context_id,
                                            const unsigned char *buffer,
                                            size_t length);

DP_Message *DP_msg_leave_parse(unsigned int context_id, DP_TextReader *reader);


/*
 * DP_MSG_SESSION_OWNER
 *
 * Session ownership change
 *
 * This message sets the users who have operator status. It can be
 * sent by users who are already operators or by the server (user id=0).
 *
 * The list of operators implicitly contains the user who sends the
 * message, thus users cannot deop themselves.
 *
 * The server sanitizes the ID list so, when distributed to other users,
 * it does not contain any duplicates or non-existing users and can be trusted
 * without checking the access control list.
 */

#define DP_MSG_SESSION_OWNER_STATIC_LENGTH        0
#define DP_MSG_SESSION_OWNER_STATIC_LENGTH_COMPAT 0

#define DP_MSG_SESSION_OWNER_USERS_MIN_COUNT 0
#define DP_MSG_SESSION_OWNER_USERS_MAX_COUNT 255

typedef struct DP_MsgSessionOwner DP_MsgSessionOwner;

DP_Message *DP_msg_session_owner_new(unsigned int context_id,
                                     void (*set_users)(int, uint8_t *, void *),
                                     int users_count, void *users_user);

DP_Message *DP_msg_session_owner_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length);

DP_Message *DP_msg_session_owner_deserialize_compat(unsigned int context_id,
                                                    const unsigned char *buffer,
                                                    size_t length);

DP_Message *DP_msg_session_owner_parse(unsigned int context_id,
                                       DP_TextReader *reader);

DP_MsgSessionOwner *DP_msg_session_owner_cast(DP_Message *msg);

const uint8_t *DP_msg_session_owner_users(const DP_MsgSessionOwner *mso,
                                          int *out_count);

int DP_msg_session_owner_users_count(const DP_MsgSessionOwner *mso);


/*
 * DP_MSG_CHAT
 *
 * A chat message
 *
 * Chat message sent by the server with the user ID 0 are server messages.
 * (Typically a Command message is used for server announcements, but the Chat
 * message is used for those messages that must be stored in the session
 * history.)
 */

#define DP_MSG_CHAT_STATIC_LENGTH        2
#define DP_MSG_CHAT_STATIC_LENGTH_COMPAT 2

#define DP_MSG_CHAT_TFLAGS_BYPASS 0x1

#define DP_MSG_CHAT_NUM_TFLAGS 1
#define DP_MSG_CHAT_ALL_TFLAGS DP_MSG_CHAT_TFLAGS_BYPASS

const char *DP_msg_chat_tflags_flag_name(unsigned int value);

#define DP_MSG_CHAT_OFLAGS_SHOUT  0x1
#define DP_MSG_CHAT_OFLAGS_ACTION 0x2
#define DP_MSG_CHAT_OFLAGS_PIN    0x4
#define DP_MSG_CHAT_OFLAGS_ALERT  0x8
#define DP_MSG_CHAT_OFLAGS_ROLL   0x10

#define DP_MSG_CHAT_NUM_OFLAGS 5
#define DP_MSG_CHAT_ALL_OFLAGS                            \
    DP_MSG_CHAT_OFLAGS_SHOUT, DP_MSG_CHAT_OFLAGS_ACTION,  \
        DP_MSG_CHAT_OFLAGS_PIN, DP_MSG_CHAT_OFLAGS_ALERT, \
        DP_MSG_CHAT_OFLAGS_ROLL

const char *DP_msg_chat_oflags_flag_name(unsigned int value);

#define DP_MSG_CHAT_MESSAGE_MIN_LEN 0
#define DP_MSG_CHAT_MESSAGE_MAX_LEN 65533

typedef struct DP_MsgChat DP_MsgChat;

DP_Message *DP_msg_chat_new(unsigned int context_id, uint8_t tflags,
                            uint8_t oflags, const char *message_value,
                            size_t message_len);

DP_Message *DP_msg_chat_deserialize(unsigned int context_id,
                                    const unsigned char *buffer, size_t length);

DP_Message *DP_msg_chat_deserialize_compat(unsigned int context_id,
                                           const unsigned char *buffer,
                                           size_t length);

DP_Message *DP_msg_chat_parse(unsigned int context_id, DP_TextReader *reader);

DP_MsgChat *DP_msg_chat_cast(DP_Message *msg);

uint8_t DP_msg_chat_tflags(const DP_MsgChat *mc);

uint8_t DP_msg_chat_oflags(const DP_MsgChat *mc);

const char *DP_msg_chat_message(const DP_MsgChat *mc, size_t *out_len);

size_t DP_msg_chat_message_len(const DP_MsgChat *mc);


/*
 * DP_MSG_TRUSTED_USERS
 *
 * List of trusted users
 *
 * This message sets the list of user who have been tagged as trusted,
 * but who are not operators. The meaning of "trusted" is a mostly
 * clientside concept, but the session can be configured to allow trusted
 * users access to some operator commands. (Deputies)
 *
 * This command can be sent by operators or by the server (ctx=0).
 *
 * The server sanitizes the ID list so, when distributed to other users,
 * it does not contain any duplicates or non-existing users and can be trusted
 * without checking the access control list.
 */

#define DP_MSG_TRUSTED_USERS_STATIC_LENGTH        0
#define DP_MSG_TRUSTED_USERS_STATIC_LENGTH_COMPAT 0

#define DP_MSG_TRUSTED_USERS_USERS_MIN_COUNT 0
#define DP_MSG_TRUSTED_USERS_USERS_MAX_COUNT 255

typedef struct DP_MsgTrustedUsers DP_MsgTrustedUsers;

DP_Message *DP_msg_trusted_users_new(unsigned int context_id,
                                     void (*set_users)(int, uint8_t *, void *),
                                     int users_count, void *users_user);

DP_Message *DP_msg_trusted_users_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length);

DP_Message *DP_msg_trusted_users_deserialize_compat(unsigned int context_id,
                                                    const unsigned char *buffer,
                                                    size_t length);

DP_Message *DP_msg_trusted_users_parse(unsigned int context_id,
                                       DP_TextReader *reader);

DP_MsgTrustedUsers *DP_msg_trusted_users_cast(DP_Message *msg);

const uint8_t *DP_msg_trusted_users_users(const DP_MsgTrustedUsers *mtu,
                                          int *out_count);

int DP_msg_trusted_users_users_count(const DP_MsgTrustedUsers *mtu);


/*
 * DP_MSG_SOFT_RESET
 *
 * Soft reset point marker
 *
 * This message marks the point in the session history where a soft reset
 * occurs. A thick-server performs an internal soft-reset when a user joins.
 *
 * All users should truncate their own session history when receiving this
 * message, since undos cannot cross the reset boundary.
 */

#define DP_MSG_SOFT_RESET_STATIC_LENGTH        0
#define DP_MSG_SOFT_RESET_STATIC_LENGTH_COMPAT 0

DP_Message *DP_msg_soft_reset_new(unsigned int context_id);

DP_Message *DP_msg_soft_reset_deserialize(unsigned int context_id,
                                          const unsigned char *buffer,
                                          size_t length);

DP_Message *DP_msg_soft_reset_deserialize_compat(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length);

DP_Message *DP_msg_soft_reset_parse(unsigned int context_id,
                                    DP_TextReader *reader);


/*
 * DP_MSG_PRIVATE_CHAT
 *
 * A private chat message
 *
 * Note. This message type was added in protocol 4.21.2 (v. 2.1.0). For backward
 * compatiblity, the server will not send any private messages from itself; it
 * will only relay them from other users. In version 3.0, this should be merged
 * with the normal Chat message.
 *
 * Private messages always bypass the session history.
 */

#define DP_MSG_PRIVATE_CHAT_STATIC_LENGTH        2
#define DP_MSG_PRIVATE_CHAT_STATIC_LENGTH_COMPAT 2

#define DP_MSG_PRIVATE_CHAT_MESSAGE_MIN_LEN 0
#define DP_MSG_PRIVATE_CHAT_MESSAGE_MAX_LEN 65533

typedef struct DP_MsgPrivateChat DP_MsgPrivateChat;

DP_Message *DP_msg_private_chat_new(unsigned int context_id, uint8_t target,
                                    uint8_t oflags, const char *message_value,
                                    size_t message_len);

DP_Message *DP_msg_private_chat_deserialize(unsigned int context_id,
                                            const unsigned char *buffer,
                                            size_t length);

DP_Message *DP_msg_private_chat_deserialize_compat(unsigned int context_id,
                                                   const unsigned char *buffer,
                                                   size_t length);

DP_Message *DP_msg_private_chat_parse(unsigned int context_id,
                                      DP_TextReader *reader);

DP_MsgPrivateChat *DP_msg_private_chat_cast(DP_Message *msg);

uint8_t DP_msg_private_chat_target(const DP_MsgPrivateChat *mpc);

uint8_t DP_msg_private_chat_oflags(const DP_MsgPrivateChat *mpc);

const char *DP_msg_private_chat_message(const DP_MsgPrivateChat *mpc,
                                        size_t *out_len);

size_t DP_msg_private_chat_message_len(const DP_MsgPrivateChat *mpc);


/*
 * DP_MSG_RESET_STREAM
 *
 * Streamed chunk of session reset messages. The client and server
 * will negotiate support and compression algorithm.
 */

#define DP_MSG_RESET_STREAM_STATIC_LENGTH        0
#define DP_MSG_RESET_STREAM_STATIC_LENGTH_COMPAT 0

#define DP_MSG_RESET_STREAM_DATA_MIN_SIZE 0
#define DP_MSG_RESET_STREAM_DATA_MAX_SIZE 65535

typedef struct DP_MsgResetStream DP_MsgResetStream;

DP_Message *DP_msg_reset_stream_new(unsigned int context_id,
                                    void (*set_data)(size_t, unsigned char *,
                                                     void *),
                                    size_t data_size, void *data_user);

DP_Message *DP_msg_reset_stream_deserialize(unsigned int context_id,
                                            const unsigned char *buffer,
                                            size_t length);

DP_Message *DP_msg_reset_stream_deserialize_compat(unsigned int context_id,
                                                   const unsigned char *buffer,
                                                   size_t length);

DP_Message *DP_msg_reset_stream_parse(unsigned int context_id,
                                      DP_TextReader *reader);

DP_MsgResetStream *DP_msg_reset_stream_cast(DP_Message *msg);

const unsigned char *DP_msg_reset_stream_data(const DP_MsgResetStream *mrs,
                                              size_t *out_size);

size_t DP_msg_reset_stream_data_size(const DP_MsgResetStream *mrs);


/*
 * DP_MSG_INTERVAL
 *
 * Event interval record
 *
 * This is used to preserve timing information in session recordings.
 *
 * Note. The maximum interval (using a single message) is about 65 seconds.
 * Typically the intervals we want to store are a few seconds at most, so this
 * should be enough.
 */

#define DP_MSG_INTERVAL_STATIC_LENGTH        2
#define DP_MSG_INTERVAL_STATIC_LENGTH_COMPAT 2

typedef struct DP_MsgInterval DP_MsgInterval;

DP_Message *DP_msg_interval_new(unsigned int context_id, uint16_t msecs);

DP_Message *DP_msg_interval_deserialize(unsigned int context_id,
                                        const unsigned char *buffer,
                                        size_t length);

DP_Message *DP_msg_interval_deserialize_compat(unsigned int context_id,
                                               const unsigned char *buffer,
                                               size_t length);

DP_Message *DP_msg_interval_parse(unsigned int context_id,
                                  DP_TextReader *reader);

DP_MsgInterval *DP_msg_interval_cast(DP_Message *msg);

uint16_t DP_msg_interval_msecs(const DP_MsgInterval *mi);


/*
 * DP_MSG_LASER_TRAIL
 *
 * Start/end drawing pointer laser trail
 *
 * This signals the beginning or the end of a laser pointer trail. The trail
 * coordinates are sent with MovePointer messages.
 *
 * A nonzero persistence indicates the start of the trail and zero the end.
 */

#define DP_MSG_LASER_TRAIL_STATIC_LENGTH        5
#define DP_MSG_LASER_TRAIL_STATIC_LENGTH_COMPAT 5

typedef struct DP_MsgLaserTrail DP_MsgLaserTrail;

DP_Message *DP_msg_laser_trail_new(unsigned int context_id, uint32_t color,
                                   uint8_t persistence);

DP_Message *DP_msg_laser_trail_deserialize(unsigned int context_id,
                                           const unsigned char *buffer,
                                           size_t length);

DP_Message *DP_msg_laser_trail_deserialize_compat(unsigned int context_id,
                                                  const unsigned char *buffer,
                                                  size_t length);

DP_Message *DP_msg_laser_trail_parse(unsigned int context_id,
                                     DP_TextReader *reader);

DP_MsgLaserTrail *DP_msg_laser_trail_cast(DP_Message *msg);

uint32_t DP_msg_laser_trail_color(const DP_MsgLaserTrail *mlt);

uint8_t DP_msg_laser_trail_persistence(const DP_MsgLaserTrail *mlt);


/*
 * DP_MSG_MOVE_POINTER
 *
 * Move user pointer
 *
 * This is message is used to update the position of the user pointer when no
 * actual drawing is taking place. It is also used to draw the "laser pointer"
 * trail. Note. This is a META message, since this is used for a temporary
 * visual effect only, and thus doesn't affect the actual canvas content.
 *
 * The pointer position is divided by 4, like classic brushes.
 */

#define DP_MSG_MOVE_POINTER_STATIC_LENGTH        8
#define DP_MSG_MOVE_POINTER_STATIC_LENGTH_COMPAT 8

typedef struct DP_MsgMovePointer DP_MsgMovePointer;

DP_Message *DP_msg_move_pointer_new(unsigned int context_id, int32_t x,
                                    int32_t y);

DP_Message *DP_msg_move_pointer_deserialize(unsigned int context_id,
                                            const unsigned char *buffer,
                                            size_t length);

DP_Message *DP_msg_move_pointer_deserialize_compat(unsigned int context_id,
                                                   const unsigned char *buffer,
                                                   size_t length);

DP_Message *DP_msg_move_pointer_parse(unsigned int context_id,
                                      DP_TextReader *reader);

DP_MsgMovePointer *DP_msg_move_pointer_cast(DP_Message *msg);

int32_t DP_msg_move_pointer_x(const DP_MsgMovePointer *mmp);

int32_t DP_msg_move_pointer_y(const DP_MsgMovePointer *mmp);


/*
 * DP_MSG_REMOVED_MARKER
 *
 * Removed in version 2.3
 */


/*
 * DP_MSG_USER_ACL
 *
 * Set user specific locks
 *
 * This is an opaque meta command that contains a list of users to be locked.
 * It can only be sent by session operators.
 */

#define DP_MSG_USER_ACL_STATIC_LENGTH        0
#define DP_MSG_USER_ACL_STATIC_LENGTH_COMPAT 0

#define DP_MSG_USER_ACL_USERS_MIN_COUNT 0
#define DP_MSG_USER_ACL_USERS_MAX_COUNT 255

typedef struct DP_MsgUserAcl DP_MsgUserAcl;

DP_Message *DP_msg_user_acl_new(unsigned int context_id,
                                void (*set_users)(int, uint8_t *, void *),
                                int users_count, void *users_user);

DP_Message *DP_msg_user_acl_deserialize(unsigned int context_id,
                                        const unsigned char *buffer,
                                        size_t length);

DP_Message *DP_msg_user_acl_deserialize_compat(unsigned int context_id,
                                               const unsigned char *buffer,
                                               size_t length);

DP_Message *DP_msg_user_acl_parse(unsigned int context_id,
                                  DP_TextReader *reader);

DP_MsgUserAcl *DP_msg_user_acl_cast(DP_Message *msg);

const uint8_t *DP_msg_user_acl_users(const DP_MsgUserAcl *mua, int *out_count);

int DP_msg_user_acl_users_count(const DP_MsgUserAcl *mua);


/*
 * DP_MSG_LAYER_ACL
 *
 * Change layer access control list, setting permission flags, access level
 * and exclusive access on a layer.
 *
 * The first two bits of the flags field indicate the access tier level, 0
 * standing for operators only, 1 for operators and trusted users, 2 for
 * operators, trusted and registered users and 3 for everyone having
 * access.
 *
 * The sixth bit of the flags field locks or unlocks the layer properties.
 *
 * The seventh bit of the flags field locks or unlocks the layer from being
 * moved.
 *
 * The eigth bit of the flags field locks or unlocks the layer.
 *
 * As a special case, setting the ACLs of ID 0 sets or clears the canvas
 * lock. The tier and exclusive user list is not used in this case.
 */

#define DP_MSG_LAYER_ACL_STATIC_LENGTH        4
#define DP_MSG_LAYER_ACL_STATIC_LENGTH_COMPAT 3

#define DP_MSG_LAYER_ACL_EXCLUSIVE_MIN_COUNT 0
#define DP_MSG_LAYER_ACL_EXCLUSIVE_MAX_COUNT 255

typedef struct DP_MsgLayerAcl DP_MsgLayerAcl;

DP_Message *DP_msg_layer_acl_new(unsigned int context_id, uint32_t id,
                                 uint8_t flags,
                                 void (*set_exclusive)(int, uint8_t *, void *),
                                 int exclusive_count, void *exclusive_user);

DP_Message *DP_msg_layer_acl_deserialize(unsigned int context_id,
                                         const unsigned char *buffer,
                                         size_t length);

DP_Message *DP_msg_layer_acl_deserialize_compat(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length);

DP_Message *DP_msg_layer_acl_parse(unsigned int context_id,
                                   DP_TextReader *reader);

DP_MsgLayerAcl *DP_msg_layer_acl_cast(DP_Message *msg);

uint32_t DP_msg_layer_acl_id(const DP_MsgLayerAcl *mla);

uint8_t DP_msg_layer_acl_flags(const DP_MsgLayerAcl *mla);

const uint8_t *DP_msg_layer_acl_exclusive(const DP_MsgLayerAcl *mla,
                                          int *out_count);

int DP_msg_layer_acl_exclusive_count(const DP_MsgLayerAcl *mla);


/*
 * DP_MSG_FEATURE_ACCESS_LEVELS
 *
 * Change feature access tiers
 *
 * Tier 0 is operator, 1 is trusted, 2 is authenticated, 3 and above
 * is guest. A value of 255 means to leave that tier unchanged. Any
 * unknown features will be ignored by the client.
 */

#define DP_MSG_FEATURE_ACCESS_LEVELS_STATIC_LENGTH        0
#define DP_MSG_FEATURE_ACCESS_LEVELS_STATIC_LENGTH_COMPAT 0

#define DP_MSG_FEATURE_ACCESS_LEVELS_FEATURE_TIERS_MIN_COUNT 1
#define DP_MSG_FEATURE_ACCESS_LEVELS_FEATURE_TIERS_MAX_COUNT 255

typedef struct DP_MsgFeatureAccessLevels DP_MsgFeatureAccessLevels;

DP_Message *DP_msg_feature_access_levels_new(
    unsigned int context_id, void (*set_feature_tiers)(int, uint8_t *, void *),
    int feature_tiers_count, void *feature_tiers_user);

DP_Message *DP_msg_feature_access_levels_deserialize(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_feature_access_levels_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_feature_access_levels_parse(unsigned int context_id,
                                               DP_TextReader *reader);

DP_MsgFeatureAccessLevels *DP_msg_feature_access_levels_cast(DP_Message *msg);

const uint8_t *DP_msg_feature_access_levels_feature_tiers(
    const DP_MsgFeatureAccessLevels *mfal, int *out_count);

int DP_msg_feature_access_levels_feature_tiers_count(
    const DP_MsgFeatureAccessLevels *mfal);


/*
 * DP_MSG_DEFAULT_LAYER
 *
 * Set the default layer
 *
 * The default layer is the one new users default to when logging in.
 * If no default layer is set, the newest layer will be selected by default.
 */

#define DP_MSG_DEFAULT_LAYER_STATIC_LENGTH        3
#define DP_MSG_DEFAULT_LAYER_STATIC_LENGTH_COMPAT 2

typedef struct DP_MsgDefaultLayer DP_MsgDefaultLayer;

DP_Message *DP_msg_default_layer_new(unsigned int context_id, uint32_t id);

DP_Message *DP_msg_default_layer_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length);

DP_Message *DP_msg_default_layer_deserialize_compat(unsigned int context_id,
                                                    const unsigned char *buffer,
                                                    size_t length);

DP_Message *DP_msg_default_layer_parse(unsigned int context_id,
                                       DP_TextReader *reader);

DP_MsgDefaultLayer *DP_msg_default_layer_cast(DP_Message *msg);

uint32_t DP_msg_default_layer_id(const DP_MsgDefaultLayer *mdl);


/*
 * DP_MSG_REMOVED_FILTERED
 *
 * Removed in version 2.3
 */


/*
 * DP_MSG_EXTENSION
 *
 * Reserved for non-standard extension use
 */


/*
 * DP_MSG_UNDO_DEPTH
 *
 * Set maximum undo depth
 */

#define DP_MSG_UNDO_DEPTH_STATIC_LENGTH        1
#define DP_MSG_UNDO_DEPTH_STATIC_LENGTH_COMPAT 1

typedef struct DP_MsgUndoDepth DP_MsgUndoDepth;

DP_Message *DP_msg_undo_depth_new(unsigned int context_id, uint8_t depth);

DP_Message *DP_msg_undo_depth_deserialize(unsigned int context_id,
                                          const unsigned char *buffer,
                                          size_t length);

DP_Message *DP_msg_undo_depth_deserialize_compat(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length);

DP_Message *DP_msg_undo_depth_parse(unsigned int context_id,
                                    DP_TextReader *reader);

DP_MsgUndoDepth *DP_msg_undo_depth_cast(DP_Message *msg);

uint8_t DP_msg_undo_depth_depth(const DP_MsgUndoDepth *mud);


/*
 * DP_MSG_DATA
 *
 * Send and receive structured information. Intended for stuff like
 * sending and receiving user troubleshooting information, sharing
 * brushes etc. Should probably be a server meta message so that it
 * can be directed at the appropriate user, but that's something for
 * Drawpile 3.0.
 */

#define DP_MSG_DATA_STATIC_LENGTH        2
#define DP_MSG_DATA_STATIC_LENGTH_COMPAT 2

#define DP_MSG_DATA_TYPE_USER_INFO 0

#define DP_MSG_DATA_NUM_TYPE 1
#define DP_MSG_DATA_ALL_TYPE DP_MSG_DATA_TYPE_USER_INFO

const char *DP_msg_data_type_variant_name(unsigned int value);

#define DP_MSG_DATA_BODY_MIN_SIZE 0
#define DP_MSG_DATA_BODY_MAX_SIZE 65533

typedef struct DP_MsgData DP_MsgData;

DP_Message *DP_msg_data_new(unsigned int context_id, uint8_t type,
                            uint8_t recipient,
                            void (*set_body)(size_t, unsigned char *, void *),
                            size_t body_size, void *body_user);

DP_Message *DP_msg_data_deserialize(unsigned int context_id,
                                    const unsigned char *buffer, size_t length);

DP_Message *DP_msg_data_deserialize_compat(unsigned int context_id,
                                           const unsigned char *buffer,
                                           size_t length);

DP_Message *DP_msg_data_parse(unsigned int context_id, DP_TextReader *reader);

DP_MsgData *DP_msg_data_cast(DP_Message *msg);

uint8_t DP_msg_data_type(const DP_MsgData *md);

uint8_t DP_msg_data_recipient(const DP_MsgData *md);

const unsigned char *DP_msg_data_body(const DP_MsgData *md, size_t *out_size);

size_t DP_msg_data_body_size(const DP_MsgData *md);


/*
 * DP_MSG_LOCAL_CHANGE
 *
 * A local-only modification, such as toggling layer visibility or
 * setting a local canvas background. Shouldn't be sent over the
 * network, but will be recorded.
 */

#define DP_MSG_LOCAL_CHANGE_STATIC_LENGTH        1
#define DP_MSG_LOCAL_CHANGE_STATIC_LENGTH_COMPAT 1

#define DP_MSG_LOCAL_CHANGE_TYPE_LAYER_VISIBILITY 0
#define DP_MSG_LOCAL_CHANGE_TYPE_BACKGROUND_TILE  1
#define DP_MSG_LOCAL_CHANGE_TYPE_VIEW_MODE        2
#define DP_MSG_LOCAL_CHANGE_TYPE_ACTIVE_LAYER     3
#define DP_MSG_LOCAL_CHANGE_TYPE_ACTIVE_FRAME     4
#define DP_MSG_LOCAL_CHANGE_TYPE_ONION_SKINS      5
#define DP_MSG_LOCAL_CHANGE_TYPE_TRACK_VISIBILITY 6
#define DP_MSG_LOCAL_CHANGE_TYPE_TRACK_ONION_SKIN 7
#define DP_MSG_LOCAL_CHANGE_TYPE_LAYER_SKETCH     8
#define DP_MSG_LOCAL_CHANGE_TYPE_LAYER_ALPHA_LOCK 9
#define DP_MSG_LOCAL_CHANGE_TYPE_LAYER_CENSORED   10

#define DP_MSG_LOCAL_CHANGE_NUM_TYPE 11
#define DP_MSG_LOCAL_CHANGE_ALL_TYPE               \
    DP_MSG_LOCAL_CHANGE_TYPE_LAYER_VISIBILITY,     \
        DP_MSG_LOCAL_CHANGE_TYPE_BACKGROUND_TILE,  \
        DP_MSG_LOCAL_CHANGE_TYPE_VIEW_MODE,        \
        DP_MSG_LOCAL_CHANGE_TYPE_ACTIVE_LAYER,     \
        DP_MSG_LOCAL_CHANGE_TYPE_ACTIVE_FRAME,     \
        DP_MSG_LOCAL_CHANGE_TYPE_ONION_SKINS,      \
        DP_MSG_LOCAL_CHANGE_TYPE_TRACK_VISIBILITY, \
        DP_MSG_LOCAL_CHANGE_TYPE_TRACK_ONION_SKIN, \
        DP_MSG_LOCAL_CHANGE_TYPE_LAYER_SKETCH,     \
        DP_MSG_LOCAL_CHANGE_TYPE_LAYER_ALPHA_LOCK, \
        DP_MSG_LOCAL_CHANGE_TYPE_LAYER_CENSORED

const char *DP_msg_local_change_type_variant_name(unsigned int value);

#define DP_MSG_LOCAL_CHANGE_BODY_MIN_SIZE 0
#define DP_MSG_LOCAL_CHANGE_BODY_MAX_SIZE 65534

typedef struct DP_MsgLocalChange DP_MsgLocalChange;

DP_Message *DP_msg_local_change_new(unsigned int context_id, uint8_t type,
                                    void (*set_body)(size_t, unsigned char *,
                                                     void *),
                                    size_t body_size, void *body_user);

DP_Message *DP_msg_local_change_deserialize(unsigned int context_id,
                                            const unsigned char *buffer,
                                            size_t length);

DP_Message *DP_msg_local_change_deserialize_compat(unsigned int context_id,
                                                   const unsigned char *buffer,
                                                   size_t length);

DP_Message *DP_msg_local_change_parse(unsigned int context_id,
                                      DP_TextReader *reader);

DP_MsgLocalChange *DP_msg_local_change_cast(DP_Message *msg);

uint8_t DP_msg_local_change_type(const DP_MsgLocalChange *mlc);

const unsigned char *DP_msg_local_change_body(const DP_MsgLocalChange *mlc,
                                              size_t *out_size);

size_t DP_msg_local_change_body_size(const DP_MsgLocalChange *mlc);


/*
 * DP_MSG_FEATURE_LIMITS
 *
 * Change feature limits.
 */

#define DP_MSG_FEATURE_LIMITS_STATIC_LENGTH 0

#define DP_MSG_FEATURE_LIMITS_LIMITS_MIN_COUNT 4
#define DP_MSG_FEATURE_LIMITS_LIMITS_MAX_COUNT 255

typedef struct DP_MsgFeatureLimits DP_MsgFeatureLimits;

DP_Message *DP_msg_feature_limits_new(unsigned int context_id,
                                      void (*set_limits)(int, int32_t *,
                                                         void *),
                                      int limits_count, void *limits_user);

DP_Message *DP_msg_feature_limits_deserialize(unsigned int context_id,
                                              const unsigned char *buffer,
                                              size_t length);

DP_Message *DP_msg_feature_limits_parse(unsigned int context_id,
                                        DP_TextReader *reader);

DP_MsgFeatureLimits *DP_msg_feature_limits_cast(DP_Message *msg);

const int32_t *DP_msg_feature_limits_limits(const DP_MsgFeatureLimits *mfl,
                                            int *out_count);

int DP_msg_feature_limits_limits_count(const DP_MsgFeatureLimits *mfl);


/*
 * DP_MSG_UNDO_POINT
 *
 * Undo demarcation point
 *
 * The client sends an UndoPoint message to signal the start of an undoable
 * sequence.
 */

#define DP_MSG_UNDO_POINT_STATIC_LENGTH        0
#define DP_MSG_UNDO_POINT_STATIC_LENGTH_COMPAT 0

DP_Message *DP_msg_undo_point_new(unsigned int context_id);

DP_Message *DP_msg_undo_point_deserialize(unsigned int context_id,
                                          const unsigned char *buffer,
                                          size_t length);

DP_Message *DP_msg_undo_point_deserialize_compat(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length);

DP_Message *DP_msg_undo_point_parse(unsigned int context_id,
                                    DP_TextReader *reader);


/*
 * DP_MSG_CANVAS_RESIZE
 *
 * Adjust canvas size
 *
 * This is the first command that must be sent to initialize the session.
 *
 * This affects the size of all existing and future layers.
 *
 * The new canvas size is relative to the old one. The four adjustement
 * parameters extend or retract their respective borders.
 * Initial canvas resize should be (0, w, h, 0).
 */

#define DP_MSG_CANVAS_RESIZE_STATIC_LENGTH        16
#define DP_MSG_CANVAS_RESIZE_STATIC_LENGTH_COMPAT 16

typedef struct DP_MsgCanvasResize DP_MsgCanvasResize;

DP_Message *DP_msg_canvas_resize_new(unsigned int context_id, int32_t top,
                                     int32_t right, int32_t bottom,
                                     int32_t left);

DP_Message *DP_msg_canvas_resize_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length);

DP_Message *DP_msg_canvas_resize_deserialize_compat(unsigned int context_id,
                                                    const unsigned char *buffer,
                                                    size_t length);

DP_Message *DP_msg_canvas_resize_parse(unsigned int context_id,
                                       DP_TextReader *reader);

DP_MsgCanvasResize *DP_msg_canvas_resize_cast(DP_Message *msg);

int32_t DP_msg_canvas_resize_top(const DP_MsgCanvasResize *mcr);

int32_t DP_msg_canvas_resize_right(const DP_MsgCanvasResize *mcr);

int32_t DP_msg_canvas_resize_bottom(const DP_MsgCanvasResize *mcr);

int32_t DP_msg_canvas_resize_left(const DP_MsgCanvasResize *mcr);


/*
 * DP_MSG_REMOVED_LAYER_CREATE
 *
 * Removed in version 2.3, subsumed by LayerTreeCreate
 */


/*
 * DP_MSG_LAYER_ATTRIBUTES
 *
 * Change layer attributes
 *
 * If the target layer is locked, this command requires session operator
 * privileges.
 *
 * Specifying a sublayer requires session operator privileges. Currently, it is
 * used only when sublayers are needed at canvas initialization.
 *
 * Note: the `fixed` flag is unused since version 2.2. It's functionality is
 * replaced by the custom timeline feature.
 */

#define DP_MSG_LAYER_ATTRIBUTES_STATIC_LENGTH        7
#define DP_MSG_LAYER_ATTRIBUTES_STATIC_LENGTH_COMPAT 6

#define DP_MSG_LAYER_ATTRIBUTES_FLAGS_CENSOR   0x1
#define DP_MSG_LAYER_ATTRIBUTES_FLAGS_FIXED    0x2
#define DP_MSG_LAYER_ATTRIBUTES_FLAGS_ISOLATED 0x4
#define DP_MSG_LAYER_ATTRIBUTES_FLAGS_CLIP     0x8

#define DP_MSG_LAYER_ATTRIBUTES_NUM_FLAGS 4
#define DP_MSG_LAYER_ATTRIBUTES_ALL_FLAGS                                      \
    DP_MSG_LAYER_ATTRIBUTES_FLAGS_CENSOR, DP_MSG_LAYER_ATTRIBUTES_FLAGS_FIXED, \
        DP_MSG_LAYER_ATTRIBUTES_FLAGS_ISOLATED,                                \
        DP_MSG_LAYER_ATTRIBUTES_FLAGS_CLIP

const char *DP_msg_layer_attributes_flags_flag_name(unsigned int value);

typedef struct DP_MsgLayerAttributes DP_MsgLayerAttributes;

DP_Message *DP_msg_layer_attributes_new(unsigned int context_id, uint32_t id,
                                        uint8_t sublayer, uint8_t flags,
                                        uint8_t opacity, uint8_t blend);

DP_Message *DP_msg_layer_attributes_deserialize(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length);

DP_Message *DP_msg_layer_attributes_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_layer_attributes_parse(unsigned int context_id,
                                          DP_TextReader *reader);

DP_MsgLayerAttributes *DP_msg_layer_attributes_cast(DP_Message *msg);

uint32_t DP_msg_layer_attributes_id(const DP_MsgLayerAttributes *mla);

uint8_t DP_msg_layer_attributes_sublayer(const DP_MsgLayerAttributes *mla);

uint8_t DP_msg_layer_attributes_flags(const DP_MsgLayerAttributes *mla);

uint8_t DP_msg_layer_attributes_opacity(const DP_MsgLayerAttributes *mla);

uint8_t DP_msg_layer_attributes_blend(const DP_MsgLayerAttributes *mla);


/*
 * DP_MSG_LAYER_RETITLE
 *
 * Change a layer's title
 */

#define DP_MSG_LAYER_RETITLE_STATIC_LENGTH        3
#define DP_MSG_LAYER_RETITLE_STATIC_LENGTH_COMPAT 2

#define DP_MSG_LAYER_RETITLE_TITLE_MIN_LEN 0
#define DP_MSG_LAYER_RETITLE_TITLE_MAX_LEN 65532

typedef struct DP_MsgLayerRetitle DP_MsgLayerRetitle;

DP_Message *DP_msg_layer_retitle_new(unsigned int context_id, uint32_t id,
                                     const char *title_value, size_t title_len);

DP_Message *DP_msg_layer_retitle_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length);

DP_Message *DP_msg_layer_retitle_deserialize_compat(unsigned int context_id,
                                                    const unsigned char *buffer,
                                                    size_t length);

DP_Message *DP_msg_layer_retitle_parse(unsigned int context_id,
                                       DP_TextReader *reader);

DP_MsgLayerRetitle *DP_msg_layer_retitle_cast(DP_Message *msg);

uint32_t DP_msg_layer_retitle_id(const DP_MsgLayerRetitle *mlr);

const char *DP_msg_layer_retitle_title(const DP_MsgLayerRetitle *mlr,
                                       size_t *out_len);

size_t DP_msg_layer_retitle_title_len(const DP_MsgLayerRetitle *mlr);


/*
 * DP_MSG_REMOVED_LAYER_ORDER
 *
 * Removed in version 2.3, subsumed by LayerTreeMove
 */


/*
 * DP_MSG_REMOVED_LAYER_DELETE
 *
 * Removed in version 2.3, subsumed by LayerTreeDelete
 */


/*
 * DP_MSG_REMOVED_LAYER_VISIBILITY
 *
 * Removed in version 2.3, layer visibility is local since 2.2
 */


/*
 * DP_MSG_PUT_IMAGE
 *
 * Draw a bitmap onto a layer or selection.
 *
 * This is used for pasting images, flood-filling, merging annotations
 * and other tasks where image processing is done client-side.
 *
 * All layer blending modes are supported.
 *
 * The image data is DEFLATEd 32bit premultiplied ARGB data. The image
 * is prefixed with a 32 bit unsigned integer (big endian) which
 * contains the expected length of the uncompressed data.
 *
 * Note that since the message length is fairly limited, a large image
 * may have to be divided into multiple PutImage commands.
 *
 * The layer id may refer to a selection.
 */

#define DP_MSG_PUT_IMAGE_STATIC_LENGTH        20
#define DP_MSG_PUT_IMAGE_STATIC_LENGTH_COMPAT 19
#define DP_MSG_PUT_IMAGE_MATCH_LENGTH         22

#define DP_MSG_PUT_IMAGE_IMAGE_MIN_SIZE 0
#define DP_MSG_PUT_IMAGE_IMAGE_MAX_SIZE 65515

typedef struct DP_MsgPutImage DP_MsgPutImage;

DP_Message *
DP_msg_put_image_new(unsigned int context_id, uint32_t layer, uint8_t mode,
                     uint32_t x, uint32_t y, uint32_t w, uint32_t h,
                     void (*set_image)(size_t, unsigned char *, void *),
                     size_t image_size, void *image_user);

DP_Message *DP_msg_put_image_deserialize(unsigned int context_id,
                                         const unsigned char *buffer,
                                         size_t length);

DP_Message *DP_msg_put_image_deserialize_compat(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length);

DP_Message *DP_msg_put_image_parse(unsigned int context_id,
                                   DP_TextReader *reader);

void DP_msg_put_image_local_match_set(size_t size, unsigned char *data,
                                      void *user);

bool DP_msg_put_image_local_match_matches(const DP_MsgPutImage *mpi,
                                          DP_Message *local_match_msg);

DP_MsgPutImage *DP_msg_put_image_cast(DP_Message *msg);

uint32_t DP_msg_put_image_layer(const DP_MsgPutImage *mpi);

uint8_t DP_msg_put_image_mode(const DP_MsgPutImage *mpi);

uint32_t DP_msg_put_image_x(const DP_MsgPutImage *mpi);

uint32_t DP_msg_put_image_y(const DP_MsgPutImage *mpi);

uint32_t DP_msg_put_image_w(const DP_MsgPutImage *mpi);

uint32_t DP_msg_put_image_h(const DP_MsgPutImage *mpi);

const unsigned char *DP_msg_put_image_image(const DP_MsgPutImage *mpi,
                                            size_t *out_size);

size_t DP_msg_put_image_image_size(const DP_MsgPutImage *mpi);


/*
 * DP_MSG_FILL_RECT
 *
 * Fill a rectangle with solid color
 *
 * The layer id may refer to a selection.
 */

#define DP_MSG_FILL_RECT_STATIC_LENGTH        24
#define DP_MSG_FILL_RECT_STATIC_LENGTH_COMPAT 23
#define DP_MSG_FILL_RECT_MATCH_LENGTH         24

typedef struct DP_MsgFillRect DP_MsgFillRect;

DP_Message *DP_msg_fill_rect_new(unsigned int context_id, uint32_t layer,
                                 uint8_t mode, uint32_t x, uint32_t y,
                                 uint32_t w, uint32_t h, uint32_t color);

DP_Message *DP_msg_fill_rect_deserialize(unsigned int context_id,
                                         const unsigned char *buffer,
                                         size_t length);

DP_Message *DP_msg_fill_rect_deserialize_compat(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length);

DP_Message *DP_msg_fill_rect_parse(unsigned int context_id,
                                   DP_TextReader *reader);

void DP_msg_fill_rect_local_match_set(size_t size, unsigned char *data,
                                      void *user);

bool DP_msg_fill_rect_local_match_matches(const DP_MsgFillRect *mfr,
                                          DP_Message *local_match_msg);

DP_MsgFillRect *DP_msg_fill_rect_cast(DP_Message *msg);

uint32_t DP_msg_fill_rect_layer(const DP_MsgFillRect *mfr);

uint8_t DP_msg_fill_rect_mode(const DP_MsgFillRect *mfr);

uint32_t DP_msg_fill_rect_x(const DP_MsgFillRect *mfr);

uint32_t DP_msg_fill_rect_y(const DP_MsgFillRect *mfr);

uint32_t DP_msg_fill_rect_w(const DP_MsgFillRect *mfr);

uint32_t DP_msg_fill_rect_h(const DP_MsgFillRect *mfr);

uint32_t DP_msg_fill_rect_color(const DP_MsgFillRect *mfr);


/*
 * DP_MSG_REMOVED_TOOL_CHANGE
 *
 * Removed in version 2.1
 */


/*
 * DP_MSG_REMOVED_PEN_MOVE
 *
 * Removed in version 2.1
 */


/*
 * DP_MSG_PEN_UP
 *
 * Signals the end of a stroke. If one exists, this causes the
 * sublayer of this user on the given layer to be merged into its
 * parent. Strokes in indirect paint modes will create such sublayers.
 * A pen up command for layer 0 causes the sublayers on all layers to
 * be merged. If the message context id is 0, the sublayers of all
 * users are merged, either on the given layer or on all layers if
 * that's 0 too.
 *
 * The layer id may refer to a selection.
 */

#define DP_MSG_PEN_UP_STATIC_LENGTH        3
#define DP_MSG_PEN_UP_STATIC_LENGTH_COMPAT 0

typedef struct DP_MsgPenUp DP_MsgPenUp;

DP_Message *DP_msg_pen_up_new(unsigned int context_id, uint32_t layer);

DP_Message *DP_msg_pen_up_deserialize(unsigned int context_id,
                                      const unsigned char *buffer,
                                      size_t length);

DP_Message *DP_msg_pen_up_deserialize_compat(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length);

DP_Message *DP_msg_pen_up_parse(unsigned int context_id, DP_TextReader *reader);

DP_MsgPenUp *DP_msg_pen_up_cast(DP_Message *msg);

uint32_t DP_msg_pen_up_layer(const DP_MsgPenUp *mpu);


/*
 * DP_MSG_ANNOTATION_CREATE
 *
 * Create a new annotation
 *
 * Annotations are floating text layers. They are drawn over the image layers
 * and have no defined stacking order.
 *
 * The new annotation created with this command is initally empy with a
 * transparent background
 */

#define DP_MSG_ANNOTATION_CREATE_STATIC_LENGTH        14
#define DP_MSG_ANNOTATION_CREATE_STATIC_LENGTH_COMPAT 14

typedef struct DP_MsgAnnotationCreate DP_MsgAnnotationCreate;

DP_Message *DP_msg_annotation_create_new(unsigned int context_id, uint16_t id,
                                         int32_t x, int32_t y, uint16_t w,
                                         uint16_t h);

DP_Message *DP_msg_annotation_create_deserialize(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length);

DP_Message *DP_msg_annotation_create_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_annotation_create_parse(unsigned int context_id,
                                           DP_TextReader *reader);

DP_MsgAnnotationCreate *DP_msg_annotation_create_cast(DP_Message *msg);

uint16_t DP_msg_annotation_create_id(const DP_MsgAnnotationCreate *mac);

int32_t DP_msg_annotation_create_x(const DP_MsgAnnotationCreate *mac);

int32_t DP_msg_annotation_create_y(const DP_MsgAnnotationCreate *mac);

uint16_t DP_msg_annotation_create_w(const DP_MsgAnnotationCreate *mac);

uint16_t DP_msg_annotation_create_h(const DP_MsgAnnotationCreate *mac);


/*
 * DP_MSG_ANNOTATION_RESHAPE
 *
 * Change the position and size of an annotation
 */

#define DP_MSG_ANNOTATION_RESHAPE_STATIC_LENGTH        14
#define DP_MSG_ANNOTATION_RESHAPE_STATIC_LENGTH_COMPAT 14

typedef struct DP_MsgAnnotationReshape DP_MsgAnnotationReshape;

DP_Message *DP_msg_annotation_reshape_new(unsigned int context_id, uint16_t id,
                                          int32_t x, int32_t y, uint16_t w,
                                          uint16_t h);

DP_Message *DP_msg_annotation_reshape_deserialize(unsigned int context_id,
                                                  const unsigned char *buffer,
                                                  size_t length);

DP_Message *DP_msg_annotation_reshape_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_annotation_reshape_parse(unsigned int context_id,
                                            DP_TextReader *reader);

DP_MsgAnnotationReshape *DP_msg_annotation_reshape_cast(DP_Message *msg);

uint16_t DP_msg_annotation_reshape_id(const DP_MsgAnnotationReshape *mar);

int32_t DP_msg_annotation_reshape_x(const DP_MsgAnnotationReshape *mar);

int32_t DP_msg_annotation_reshape_y(const DP_MsgAnnotationReshape *mar);

uint16_t DP_msg_annotation_reshape_w(const DP_MsgAnnotationReshape *mar);

uint16_t DP_msg_annotation_reshape_h(const DP_MsgAnnotationReshape *mar);


/*
 * DP_MSG_ANNOTATION_EDIT
 *
 * Change annotation content
 *
 * Accepted contents is the subset of HTML understood by QTextDocument
 *
 * If an annotation is flagged as protected, it cannot be modified by users
 * other than the one who created it, or session operators.
 */

#define DP_MSG_ANNOTATION_EDIT_STATIC_LENGTH        8
#define DP_MSG_ANNOTATION_EDIT_STATIC_LENGTH_COMPAT 8

#define DP_MSG_ANNOTATION_EDIT_FLAGS_PROTECT       0x1
#define DP_MSG_ANNOTATION_EDIT_FLAGS_VALIGN_CENTER 0x2
#define DP_MSG_ANNOTATION_EDIT_FLAGS_VALIGN_BOTTOM 0x4
#define DP_MSG_ANNOTATION_EDIT_FLAGS_ALIAS         0x8
#define DP_MSG_ANNOTATION_EDIT_FLAGS_RASTERIZE     0x10

#define DP_MSG_ANNOTATION_EDIT_NUM_FLAGS 5
#define DP_MSG_ANNOTATION_EDIT_ALL_FLAGS            \
    DP_MSG_ANNOTATION_EDIT_FLAGS_PROTECT,           \
        DP_MSG_ANNOTATION_EDIT_FLAGS_VALIGN_CENTER, \
        DP_MSG_ANNOTATION_EDIT_FLAGS_VALIGN_BOTTOM, \
        DP_MSG_ANNOTATION_EDIT_FLAGS_ALIAS,         \
        DP_MSG_ANNOTATION_EDIT_FLAGS_RASTERIZE

const char *DP_msg_annotation_edit_flags_flag_name(unsigned int value);

#define DP_MSG_ANNOTATION_EDIT_TEXT_MIN_LEN 0
#define DP_MSG_ANNOTATION_EDIT_TEXT_MAX_LEN 65527

typedef struct DP_MsgAnnotationEdit DP_MsgAnnotationEdit;

DP_Message *DP_msg_annotation_edit_new(unsigned int context_id, uint16_t id,
                                       uint32_t bg, uint8_t flags,
                                       uint8_t border, const char *text_value,
                                       size_t text_len);

DP_Message *DP_msg_annotation_edit_deserialize(unsigned int context_id,
                                               const unsigned char *buffer,
                                               size_t length);

DP_Message *DP_msg_annotation_edit_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_annotation_edit_parse(unsigned int context_id,
                                         DP_TextReader *reader);

DP_MsgAnnotationEdit *DP_msg_annotation_edit_cast(DP_Message *msg);

uint16_t DP_msg_annotation_edit_id(const DP_MsgAnnotationEdit *mae);

uint32_t DP_msg_annotation_edit_bg(const DP_MsgAnnotationEdit *mae);

uint8_t DP_msg_annotation_edit_flags(const DP_MsgAnnotationEdit *mae);

uint8_t DP_msg_annotation_edit_border(const DP_MsgAnnotationEdit *mae);

const char *DP_msg_annotation_edit_text(const DP_MsgAnnotationEdit *mae,
                                        size_t *out_len);

size_t DP_msg_annotation_edit_text_len(const DP_MsgAnnotationEdit *mae);


/*
 * DP_MSG_ANNOTATION_DELETE
 *
 * Delete an annotation
 *
 * Note: Unlike in layer delete command, there is no "merge" option here.
 * Merging an annotation is done by rendering the annotation item to
 * an image and drawing the image with the PutImage command. This ensures
 * identical rendering on all clients.
 */

#define DP_MSG_ANNOTATION_DELETE_STATIC_LENGTH        2
#define DP_MSG_ANNOTATION_DELETE_STATIC_LENGTH_COMPAT 2

typedef struct DP_MsgAnnotationDelete DP_MsgAnnotationDelete;

DP_Message *DP_msg_annotation_delete_new(unsigned int context_id, uint16_t id);

DP_Message *DP_msg_annotation_delete_deserialize(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length);

DP_Message *DP_msg_annotation_delete_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_annotation_delete_parse(unsigned int context_id,
                                           DP_TextReader *reader);

DP_MsgAnnotationDelete *DP_msg_annotation_delete_cast(DP_Message *msg);

uint16_t DP_msg_annotation_delete_id(const DP_MsgAnnotationDelete *mad);


/*
 * DP_MSG_REMOVED_MOVE_REGION
 *
 * Removed in version 2.3, subsumed by TransformRegion
 */


/*
 * DP_MSG_PUT_TILE
 *
 * Set the content of a tile.
 *
 * Unlike PutImage, this replaces an entire tile directly without any
 * blending. This command is typically used during canvas
 * initialization to set the initial content.
 *
 * PutTile can target sublayers as well. This is used when generating
 * a reset image with incomplete indirect strokes. Sending a PenUp
 * command will merge the sublayer.
 */

#define DP_MSG_PUT_TILE_STATIC_LENGTH        11
#define DP_MSG_PUT_TILE_STATIC_LENGTH_COMPAT 9

#define DP_MSG_PUT_TILE_IMAGE_MIN_SIZE 0
#define DP_MSG_PUT_TILE_IMAGE_MAX_SIZE 65524

typedef struct DP_MsgPutTile DP_MsgPutTile;

DP_Message *DP_msg_put_tile_new(unsigned int context_id, uint8_t user,
                                uint32_t layer, uint8_t sublayer, uint16_t col,
                                uint16_t row, uint16_t repeat,
                                void (*set_image)(size_t, unsigned char *,
                                                  void *),
                                size_t image_size, void *image_user);

DP_Message *DP_msg_put_tile_deserialize(unsigned int context_id,
                                        const unsigned char *buffer,
                                        size_t length);

DP_Message *DP_msg_put_tile_deserialize_compat(unsigned int context_id,
                                               const unsigned char *buffer,
                                               size_t length);

DP_Message *DP_msg_put_tile_parse(unsigned int context_id,
                                  DP_TextReader *reader);

DP_MsgPutTile *DP_msg_put_tile_cast(DP_Message *msg);

uint8_t DP_msg_put_tile_user(const DP_MsgPutTile *mpt);

uint32_t DP_msg_put_tile_layer(const DP_MsgPutTile *mpt);

uint8_t DP_msg_put_tile_sublayer(const DP_MsgPutTile *mpt);

uint16_t DP_msg_put_tile_col(const DP_MsgPutTile *mpt);

uint16_t DP_msg_put_tile_row(const DP_MsgPutTile *mpt);

uint16_t DP_msg_put_tile_repeat(const DP_MsgPutTile *mpt);

const unsigned char *DP_msg_put_tile_image(const DP_MsgPutTile *mpt,
                                           size_t *out_size);

size_t DP_msg_put_tile_image_size(const DP_MsgPutTile *mpt);


/*
 * DP_MSG_CANVAS_BACKGROUND
 *
 * Set the canvas background tile
 *
 * If the payload is exactly 4 bytes long, it should be interpreted as a solid
 * background color. Otherwise, it is the DEFLATED tile bitmap
 */

#define DP_MSG_CANVAS_BACKGROUND_STATIC_LENGTH        0
#define DP_MSG_CANVAS_BACKGROUND_STATIC_LENGTH_COMPAT 0

#define DP_MSG_CANVAS_BACKGROUND_IMAGE_MIN_SIZE 0
#define DP_MSG_CANVAS_BACKGROUND_IMAGE_MAX_SIZE 65535

typedef struct DP_MsgCanvasBackground DP_MsgCanvasBackground;

DP_Message *
DP_msg_canvas_background_new(unsigned int context_id,
                             void (*set_image)(size_t, unsigned char *, void *),
                             size_t image_size, void *image_user);

DP_Message *DP_msg_canvas_background_deserialize(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length);

DP_Message *DP_msg_canvas_background_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_canvas_background_parse(unsigned int context_id,
                                           DP_TextReader *reader);

DP_MsgCanvasBackground *DP_msg_canvas_background_cast(DP_Message *msg);

const unsigned char *
DP_msg_canvas_background_image(const DP_MsgCanvasBackground *mcb,
                               size_t *out_size);

size_t DP_msg_canvas_background_image_size(const DP_MsgCanvasBackground *mcb);


/*
 * DP_MSG_DRAW_DABS_CLASSIC
 *
 * Draw classic brush dabs
 *
 * A simple delta compression scheme is used. The coordinates of each
 * dab are relative to the previous dab. The coordinate system has
 * 1/4 pixel resolution. Divide by 4.0 before use. The size field is
 * the brush diameter multiplied by 256.
 *
 * The layer id may refer to a selection.
 */

#define DP_MSG_DRAW_DABS_CLASSIC_STATIC_LENGTH        17
#define DP_MSG_DRAW_DABS_CLASSIC_STATIC_LENGTH_COMPAT 15
#define DP_MSG_DRAW_DABS_CLASSIC_MATCH_LENGTH         19

#define DP_MSG_DRAW_DABS_CLASSIC_DABS_MIN_COUNT 1
#define DP_MSG_DRAW_DABS_CLASSIC_DABS_MAX_COUNT 9359

#define DP_MSG_DRAW_DABS_CLASSIC_DABS_MAX 9359

typedef struct DP_ClassicDab DP_ClassicDab;

void DP_classic_dab_init(DP_ClassicDab *cds, int i, int8_t x, int8_t y,
                         uint32_t size, uint8_t hardness, uint8_t opacity);

int8_t DP_classic_dab_x(const DP_ClassicDab *cd);

int8_t DP_classic_dab_y(const DP_ClassicDab *cd);

uint32_t DP_classic_dab_size(const DP_ClassicDab *cd);

uint8_t DP_classic_dab_hardness(const DP_ClassicDab *cd);

uint8_t DP_classic_dab_opacity(const DP_ClassicDab *cd);

const DP_ClassicDab *DP_classic_dab_at(const DP_ClassicDab *cd, int i);


typedef struct DP_MsgDrawDabsClassic DP_MsgDrawDabsClassic;

DP_Message *DP_msg_draw_dabs_classic_new(unsigned int context_id, uint8_t flags,
                                         uint32_t layer, int32_t x, int32_t y,
                                         uint32_t color, uint8_t mode,
                                         void (*set_dabs)(int, DP_ClassicDab *,
                                                          void *),
                                         int dabs_count, void *dabs_user);

DP_Message *DP_msg_draw_dabs_classic_deserialize(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length);

DP_Message *DP_msg_draw_dabs_classic_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_draw_dabs_classic_parse(unsigned int context_id,
                                           DP_TextReader *reader);

void DP_msg_draw_dabs_classic_local_match_set(size_t size, unsigned char *data,
                                              void *user);

bool DP_msg_draw_dabs_classic_local_match_matches(
    const DP_MsgDrawDabsClassic *mddc, DP_Message *local_match_msg);

DP_MsgDrawDabsClassic *DP_msg_draw_dabs_classic_cast(DP_Message *msg);

uint8_t DP_msg_draw_dabs_classic_flags(const DP_MsgDrawDabsClassic *mddc);

uint32_t DP_msg_draw_dabs_classic_layer(const DP_MsgDrawDabsClassic *mddc);

int32_t DP_msg_draw_dabs_classic_x(const DP_MsgDrawDabsClassic *mddc);

int32_t DP_msg_draw_dabs_classic_y(const DP_MsgDrawDabsClassic *mddc);

uint32_t DP_msg_draw_dabs_classic_color(const DP_MsgDrawDabsClassic *mddc);

uint8_t DP_msg_draw_dabs_classic_mode(const DP_MsgDrawDabsClassic *mddc);

const DP_ClassicDab *
DP_msg_draw_dabs_classic_dabs(const DP_MsgDrawDabsClassic *mddc,
                              int *out_count);

int DP_msg_draw_dabs_classic_dabs_count(const DP_MsgDrawDabsClassic *mddc);


/*
 * DP_MSG_DRAW_DABS_PIXEL
 *
 * Draw round pixel brush dabs
 *
 * The same kind of delta compression is used as in classicdabs,
 * but the fields all have integer precision.
 *
 * The layer id may refer to a selection.
 */

#define DP_MSG_DRAW_DABS_PIXEL_STATIC_LENGTH        17
#define DP_MSG_DRAW_DABS_PIXEL_STATIC_LENGTH_COMPAT 15
#define DP_MSG_DRAW_DABS_PIXEL_MATCH_LENGTH         19

#define DP_MSG_DRAW_DABS_PIXEL_DABS_MIN_COUNT 1
#define DP_MSG_DRAW_DABS_PIXEL_DABS_MAX_COUNT 13103

#define DP_MSG_DRAW_DABS_PIXEL_DABS_MAX 13103

typedef struct DP_PixelDab DP_PixelDab;

void DP_pixel_dab_init(DP_PixelDab *pds, int i, int8_t x, int8_t y,
                       uint16_t size, uint8_t opacity);

int8_t DP_pixel_dab_x(const DP_PixelDab *pd);

int8_t DP_pixel_dab_y(const DP_PixelDab *pd);

uint16_t DP_pixel_dab_size(const DP_PixelDab *pd);

uint8_t DP_pixel_dab_opacity(const DP_PixelDab *pd);

const DP_PixelDab *DP_pixel_dab_at(const DP_PixelDab *pd, int i);


typedef struct DP_MsgDrawDabsPixel DP_MsgDrawDabsPixel;

DP_Message *DP_msg_draw_dabs_pixel_new(unsigned int context_id, uint8_t flags,
                                       uint32_t layer, int32_t x, int32_t y,
                                       uint32_t color, uint8_t mode,
                                       void (*set_dabs)(int, DP_PixelDab *,
                                                        void *),
                                       int dabs_count, void *dabs_user);

DP_Message *DP_msg_draw_dabs_pixel_deserialize(unsigned int context_id,
                                               const unsigned char *buffer,
                                               size_t length);

DP_Message *DP_msg_draw_dabs_pixel_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_draw_dabs_pixel_parse(unsigned int context_id,
                                         DP_TextReader *reader);

void DP_msg_draw_dabs_pixel_local_match_set(size_t size, unsigned char *data,
                                            void *user);

bool DP_msg_draw_dabs_pixel_local_match_matches(const DP_MsgDrawDabsPixel *mddp,
                                                DP_Message *local_match_msg);

DP_MsgDrawDabsPixel *DP_msg_draw_dabs_pixel_cast(DP_Message *msg);

uint8_t DP_msg_draw_dabs_pixel_flags(const DP_MsgDrawDabsPixel *mddp);

uint32_t DP_msg_draw_dabs_pixel_layer(const DP_MsgDrawDabsPixel *mddp);

int32_t DP_msg_draw_dabs_pixel_x(const DP_MsgDrawDabsPixel *mddp);

int32_t DP_msg_draw_dabs_pixel_y(const DP_MsgDrawDabsPixel *mddp);

uint32_t DP_msg_draw_dabs_pixel_color(const DP_MsgDrawDabsPixel *mddp);

uint8_t DP_msg_draw_dabs_pixel_mode(const DP_MsgDrawDabsPixel *mddp);

const DP_PixelDab *DP_msg_draw_dabs_pixel_dabs(const DP_MsgDrawDabsPixel *mddp,
                                               int *out_count);

int DP_msg_draw_dabs_pixel_dabs_count(const DP_MsgDrawDabsPixel *mddp);


/*
 * DP_MSG_DRAW_DABS_PIXEL_SQUARE
 *
 * Draw square pixel brush dabs
 */

#define DP_MSG_DRAW_DABS_PIXEL_SQUARE_STATIC_LENGTH        0
#define DP_MSG_DRAW_DABS_PIXEL_SQUARE_STATIC_LENGTH_COMPAT 15
#define DP_MSG_DRAW_DABS_PIXEL_SQUARE_MATCH_LENGTH         0

DP_Message *
DP_msg_draw_dabs_pixel_square_new(unsigned int context_id, uint8_t flags,
                                  uint32_t layer, int32_t x, int32_t y,
                                  uint32_t color, uint8_t mode,
                                  void (*set_dabs)(int, DP_PixelDab *, void *),
                                  int dabs_count, void *dabs_user);

DP_Message *DP_msg_draw_dabs_pixel_square_deserialize(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_draw_dabs_pixel_square_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_draw_dabs_pixel_square_parse(unsigned int context_id,
                                                DP_TextReader *reader);

void DP_msg_draw_dabs_pixel_square_local_match_set(size_t size,
                                                   unsigned char *data,
                                                   void *user);

bool DP_msg_draw_dabs_pixel_square_local_match_matches(
    const DP_MsgDrawDabsPixel *mddps, DP_Message *local_match_msg);

DP_MsgDrawDabsPixel *DP_msg_draw_dabs_pixel_square_cast(DP_Message *msg);


/*
 * DP_MSG_DRAW_DABS_MYPAINT
 *
 * Draw MyPaint brush dabs in "normal and eraser" or "pigment and
 * eraser" mode, the regular modes of MyPaint brushes as used in
 * MyPaint itself.
 *
 * The lowest flag bit indicates that this message uses pigment and
 * eraser instead of normal and eraser mode. The top 5 bits indicate
 * the selection ID to use for masking.
 *
 * If the highest bit (0x80) of the mode field is not set, it is
 * treated as the number of posterization colors. If it is set, the
 * first two bits decide the paint and blend mode of this stroke: 0x0
 * means direct with Normal and Eraser mode, 0x1 means soft indirect
 * with Normal mode, 0x2 means soft indirect with Recolor mode and 0x3
 * means soft indirect with Erase mode. This is for backward
 * compatibility with the 2.2 protocol, 2.3 uses the mypaintdabsblend
 * message instead.
 *
 * The layer id may refer to a selection.
 */

#define DP_MSG_DRAW_DABS_MYPAINT_STATIC_LENGTH        20
#define DP_MSG_DRAW_DABS_MYPAINT_STATIC_LENGTH_COMPAT 18
#define DP_MSG_DRAW_DABS_MYPAINT_MATCH_LENGTH         22

#define DP_MSG_DRAW_DABS_MYPAINT_DABS_MIN_COUNT 1
#define DP_MSG_DRAW_DABS_MYPAINT_DABS_MAX_COUNT 7279

#define DP_MSG_DRAW_DABS_MYPAINT_DABS_MAX 7279

typedef struct DP_MyPaintDab DP_MyPaintDab;

void DP_mypaint_dab_init(DP_MyPaintDab *mpds, int i, int8_t x, int8_t y,
                         uint32_t size, uint8_t hardness, uint8_t opacity,
                         uint8_t angle, uint8_t aspect_ratio);

int8_t DP_mypaint_dab_x(const DP_MyPaintDab *mpd);

int8_t DP_mypaint_dab_y(const DP_MyPaintDab *mpd);

uint32_t DP_mypaint_dab_size(const DP_MyPaintDab *mpd);

uint8_t DP_mypaint_dab_hardness(const DP_MyPaintDab *mpd);

uint8_t DP_mypaint_dab_opacity(const DP_MyPaintDab *mpd);

uint8_t DP_mypaint_dab_angle(const DP_MyPaintDab *mpd);

uint8_t DP_mypaint_dab_aspect_ratio(const DP_MyPaintDab *mpd);

const DP_MyPaintDab *DP_mypaint_dab_at(const DP_MyPaintDab *mpd, int i);


typedef struct DP_MsgDrawDabsMyPaint DP_MsgDrawDabsMyPaint;

DP_Message *
DP_msg_draw_dabs_mypaint_new(unsigned int context_id, uint8_t flags,
                             uint32_t layer, int32_t x, int32_t y,
                             uint32_t color, uint8_t lock_alpha,
                             uint8_t colorize, uint8_t posterize, uint8_t mode,
                             void (*set_dabs)(int, DP_MyPaintDab *, void *),
                             int dabs_count, void *dabs_user);

DP_Message *DP_msg_draw_dabs_mypaint_deserialize(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length);

DP_Message *DP_msg_draw_dabs_mypaint_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_draw_dabs_mypaint_parse(unsigned int context_id,
                                           DP_TextReader *reader);

void DP_msg_draw_dabs_mypaint_local_match_set(size_t size, unsigned char *data,
                                              void *user);

bool DP_msg_draw_dabs_mypaint_local_match_matches(
    const DP_MsgDrawDabsMyPaint *mddmp, DP_Message *local_match_msg);

DP_MsgDrawDabsMyPaint *DP_msg_draw_dabs_mypaint_cast(DP_Message *msg);

uint8_t DP_msg_draw_dabs_mypaint_flags(const DP_MsgDrawDabsMyPaint *mddmp);

uint32_t DP_msg_draw_dabs_mypaint_layer(const DP_MsgDrawDabsMyPaint *mddmp);

int32_t DP_msg_draw_dabs_mypaint_x(const DP_MsgDrawDabsMyPaint *mddmp);

int32_t DP_msg_draw_dabs_mypaint_y(const DP_MsgDrawDabsMyPaint *mddmp);

uint32_t DP_msg_draw_dabs_mypaint_color(const DP_MsgDrawDabsMyPaint *mddmp);

uint8_t DP_msg_draw_dabs_mypaint_lock_alpha(const DP_MsgDrawDabsMyPaint *mddmp);

uint8_t DP_msg_draw_dabs_mypaint_colorize(const DP_MsgDrawDabsMyPaint *mddmp);

uint8_t DP_msg_draw_dabs_mypaint_posterize(const DP_MsgDrawDabsMyPaint *mddmp);

uint8_t DP_msg_draw_dabs_mypaint_mode(const DP_MsgDrawDabsMyPaint *mddmp);

const DP_MyPaintDab *
DP_msg_draw_dabs_mypaint_dabs(const DP_MsgDrawDabsMyPaint *mddmp,
                              int *out_count);

int DP_msg_draw_dabs_mypaint_dabs_count(const DP_MsgDrawDabsMyPaint *mddmp);


/*
 * DP_MSG_DRAW_DABS_MYPAINT_BLEND
 *
 * Draw MyPaint brush dabs with single blend mode. Used for cases
 * where the regular MyPaint blending with "normal and eraser" mode is
 * unsuitable.
 *
 * The layer id may refer to a selection.
 */

#define DP_MSG_DRAW_DABS_MYPAINT_BLEND_STATIC_LENGTH 17
#define DP_MSG_DRAW_DABS_MYPAINT_BLEND_MATCH_LENGTH  19

#define DP_MSG_DRAW_DABS_MYPAINT_BLEND_DABS_MIN_COUNT 1
#define DP_MSG_DRAW_DABS_MYPAINT_BLEND_DABS_MAX_COUNT 7279

#define DP_MSG_DRAW_DABS_MYPAINT_BLEND_DABS_MAX 7279

typedef struct DP_MyPaintBlendDab DP_MyPaintBlendDab;

void DP_mypaint_blend_dab_init(DP_MyPaintBlendDab *mpbds, int i, int8_t x,
                               int8_t y, uint32_t size, uint8_t hardness,
                               uint8_t opacity, uint8_t angle,
                               uint8_t aspect_ratio);

int8_t DP_mypaint_blend_dab_x(const DP_MyPaintBlendDab *mpbd);

int8_t DP_mypaint_blend_dab_y(const DP_MyPaintBlendDab *mpbd);

uint32_t DP_mypaint_blend_dab_size(const DP_MyPaintBlendDab *mpbd);

uint8_t DP_mypaint_blend_dab_hardness(const DP_MyPaintBlendDab *mpbd);

uint8_t DP_mypaint_blend_dab_opacity(const DP_MyPaintBlendDab *mpbd);

uint8_t DP_mypaint_blend_dab_angle(const DP_MyPaintBlendDab *mpbd);

uint8_t DP_mypaint_blend_dab_aspect_ratio(const DP_MyPaintBlendDab *mpbd);

const DP_MyPaintBlendDab *
DP_mypaint_blend_dab_at(const DP_MyPaintBlendDab *mpbd, int i);


typedef struct DP_MsgDrawDabsMyPaintBlend DP_MsgDrawDabsMyPaintBlend;

DP_Message *DP_msg_draw_dabs_mypaint_blend_new(
    unsigned int context_id, uint8_t flags, uint32_t layer, int32_t x,
    int32_t y, uint32_t color, uint8_t mode,
    void (*set_dabs)(int, DP_MyPaintBlendDab *, void *), int dabs_count,
    void *dabs_user);

DP_Message *DP_msg_draw_dabs_mypaint_blend_deserialize(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_draw_dabs_mypaint_blend_parse(unsigned int context_id,
                                                 DP_TextReader *reader);

void DP_msg_draw_dabs_mypaint_blend_local_match_set(size_t size,
                                                    unsigned char *data,
                                                    void *user);

bool DP_msg_draw_dabs_mypaint_blend_local_match_matches(
    const DP_MsgDrawDabsMyPaintBlend *mddmpb, DP_Message *local_match_msg);

DP_MsgDrawDabsMyPaintBlend *
DP_msg_draw_dabs_mypaint_blend_cast(DP_Message *msg);

uint8_t
DP_msg_draw_dabs_mypaint_blend_flags(const DP_MsgDrawDabsMyPaintBlend *mddmpb);

uint32_t
DP_msg_draw_dabs_mypaint_blend_layer(const DP_MsgDrawDabsMyPaintBlend *mddmpb);

int32_t
DP_msg_draw_dabs_mypaint_blend_x(const DP_MsgDrawDabsMyPaintBlend *mddmpb);

int32_t
DP_msg_draw_dabs_mypaint_blend_y(const DP_MsgDrawDabsMyPaintBlend *mddmpb);

uint32_t
DP_msg_draw_dabs_mypaint_blend_color(const DP_MsgDrawDabsMyPaintBlend *mddmpb);

uint8_t
DP_msg_draw_dabs_mypaint_blend_mode(const DP_MsgDrawDabsMyPaintBlend *mddmpb);

const DP_MyPaintBlendDab *
DP_msg_draw_dabs_mypaint_blend_dabs(const DP_MsgDrawDabsMyPaintBlend *mddmpb,
                                    int *out_count);

int DP_msg_draw_dabs_mypaint_blend_dabs_count(
    const DP_MsgDrawDabsMyPaintBlend *mddmpb);


/*
 * DP_MSG_MOVE_RECT
 *
 * Move a rectangular area on a layer or a selection.
 *
 * A mask image can be given to mask out part of the region
 * to support non-rectangular selections.
 *
 * Source and target rects may be (partially) outside the canvas.
 *
 * The source and layer id may refer to a selection.
 */

#define DP_MSG_MOVE_RECT_STATIC_LENGTH        32
#define DP_MSG_MOVE_RECT_STATIC_LENGTH_COMPAT 28
#define DP_MSG_MOVE_RECT_MATCH_LENGTH         34

#define DP_MSG_MOVE_RECT_MASK_MIN_SIZE 0
#define DP_MSG_MOVE_RECT_MASK_MAX_SIZE 65503

typedef struct DP_MsgMoveRect DP_MsgMoveRect;

DP_Message *
DP_msg_move_rect_new(unsigned int context_id, uint32_t layer, uint32_t source,
                     int32_t sx, int32_t sy, int32_t tx, int32_t ty, int32_t w,
                     int32_t h, uint8_t blend, uint8_t opacity,
                     void (*set_mask)(size_t, unsigned char *, void *),
                     size_t mask_size, void *mask_user);

DP_Message *DP_msg_move_rect_deserialize(unsigned int context_id,
                                         const unsigned char *buffer,
                                         size_t length);

DP_Message *DP_msg_move_rect_deserialize_compat(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length);

DP_Message *DP_msg_move_rect_parse(unsigned int context_id,
                                   DP_TextReader *reader);

void DP_msg_move_rect_local_match_set(size_t size, unsigned char *data,
                                      void *user);

bool DP_msg_move_rect_local_match_matches(const DP_MsgMoveRect *mmr,
                                          DP_Message *local_match_msg);

DP_MsgMoveRect *DP_msg_move_rect_cast(DP_Message *msg);

uint32_t DP_msg_move_rect_layer(const DP_MsgMoveRect *mmr);

uint32_t DP_msg_move_rect_source(const DP_MsgMoveRect *mmr);

int32_t DP_msg_move_rect_sx(const DP_MsgMoveRect *mmr);

int32_t DP_msg_move_rect_sy(const DP_MsgMoveRect *mmr);

int32_t DP_msg_move_rect_tx(const DP_MsgMoveRect *mmr);

int32_t DP_msg_move_rect_ty(const DP_MsgMoveRect *mmr);

int32_t DP_msg_move_rect_w(const DP_MsgMoveRect *mmr);

int32_t DP_msg_move_rect_h(const DP_MsgMoveRect *mmr);

uint8_t DP_msg_move_rect_blend(const DP_MsgMoveRect *mmr);

uint8_t DP_msg_move_rect_opacity(const DP_MsgMoveRect *mmr);

const unsigned char *DP_msg_move_rect_mask(const DP_MsgMoveRect *mmr,
                                           size_t *out_size);

size_t DP_msg_move_rect_mask_size(const DP_MsgMoveRect *mmr);


/*
 * DP_MSG_SET_METADATA_INT
 *
 * Set a document metadata field (integer type)
 *
 * These typically don't have an immediate visual effect,
 * but these fields are part of the document, like the pixel content
 * or the annotations.
 */

#define DP_MSG_SET_METADATA_INT_STATIC_LENGTH        5
#define DP_MSG_SET_METADATA_INT_STATIC_LENGTH_COMPAT 5

#define DP_MSG_SET_METADATA_INT_FIELD_DPIX               0
#define DP_MSG_SET_METADATA_INT_FIELD_DPIY               1
#define DP_MSG_SET_METADATA_INT_FIELD_FRAMERATE          2
#define DP_MSG_SET_METADATA_INT_FIELD_FRAME_COUNT        3
#define DP_MSG_SET_METADATA_INT_FIELD_FRAMERATE_FRACTION 4
#define DP_MSG_SET_METADATA_INT_FIELD_FRAME_RANGE_FIRST  5
#define DP_MSG_SET_METADATA_INT_FIELD_FRAME_RANGE_LAST   6

#define DP_MSG_SET_METADATA_INT_NUM_FIELD 7
#define DP_MSG_SET_METADATA_INT_ALL_FIELD                                   \
    DP_MSG_SET_METADATA_INT_FIELD_DPIX, DP_MSG_SET_METADATA_INT_FIELD_DPIY, \
        DP_MSG_SET_METADATA_INT_FIELD_FRAMERATE,                            \
        DP_MSG_SET_METADATA_INT_FIELD_FRAME_COUNT,                          \
        DP_MSG_SET_METADATA_INT_FIELD_FRAMERATE_FRACTION,                   \
        DP_MSG_SET_METADATA_INT_FIELD_FRAME_RANGE_FIRST,                    \
        DP_MSG_SET_METADATA_INT_FIELD_FRAME_RANGE_LAST

const char *DP_msg_set_metadata_int_field_variant_name(unsigned int value);

typedef struct DP_MsgSetMetadataInt DP_MsgSetMetadataInt;

DP_Message *DP_msg_set_metadata_int_new(unsigned int context_id, uint8_t field,
                                        int32_t value);

DP_Message *DP_msg_set_metadata_int_deserialize(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length);

DP_Message *DP_msg_set_metadata_int_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_set_metadata_int_parse(unsigned int context_id,
                                          DP_TextReader *reader);

DP_MsgSetMetadataInt *DP_msg_set_metadata_int_cast(DP_Message *msg);

uint8_t DP_msg_set_metadata_int_field(const DP_MsgSetMetadataInt *msmi);

int32_t DP_msg_set_metadata_int_value(const DP_MsgSetMetadataInt *msmi);


/*
 * DP_MSG_LAYER_TREE_CREATE
 *
 * Create a new layer
 *
 * A session starts with zero layers, so a layer creation command is typically
 * the second command to be sent, right after setting the canvas size.
 *
 * The layer ID must be prefixed with the context ID of the user creating it.
 * This allows the client to choose the layer ID without worrying about
 * clashes. In multiuser mode the ACL filter validates the prefix for all new
 * layers.
 *
 * If the `source` field is nonzero, a copy of the source layer is made.
 * Otherwise, either a blank new bitmap or a group layer is created.
 * When copying a group, the group's layers are assigned new IDs sequentally,
 * starting from the group ID, using the group IDs user prefix.
 *
 * If the `target` field is nonzero, the newly created layer will be
 * insert above that layer or group, or into that group. If zero,
 * the layer will be added to the top of the root group.
 *
 * The following flags can be used with layer creation:
 * - GROUP: a group layer is created (ignored if `source` is set)
 * - INTO: the new layer will be added to the top to the `target` group.
 *         The target must be nonzero.
 *
 * If layer controls are locked, this command requires session operator
 * privileges.
 */

#define DP_MSG_LAYER_TREE_CREATE_STATIC_LENGTH        14
#define DP_MSG_LAYER_TREE_CREATE_STATIC_LENGTH_COMPAT 11

#define DP_MSG_LAYER_TREE_CREATE_FLAGS_GROUP 0x1
#define DP_MSG_LAYER_TREE_CREATE_FLAGS_INTO  0x2

#define DP_MSG_LAYER_TREE_CREATE_NUM_FLAGS 2
#define DP_MSG_LAYER_TREE_CREATE_ALL_FLAGS \
    DP_MSG_LAYER_TREE_CREATE_FLAGS_GROUP, DP_MSG_LAYER_TREE_CREATE_FLAGS_INTO

const char *DP_msg_layer_tree_create_flags_flag_name(unsigned int value);

#define DP_MSG_LAYER_TREE_CREATE_TITLE_MIN_LEN 0
#define DP_MSG_LAYER_TREE_CREATE_TITLE_MAX_LEN 65521

typedef struct DP_MsgLayerTreeCreate DP_MsgLayerTreeCreate;

DP_Message *DP_msg_layer_tree_create_new(unsigned int context_id, uint32_t id,
                                         uint32_t source, uint32_t target,
                                         uint32_t fill, uint8_t flags,
                                         const char *title_value,
                                         size_t title_len);

DP_Message *DP_msg_layer_tree_create_deserialize(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length);

DP_Message *DP_msg_layer_tree_create_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_layer_tree_create_parse(unsigned int context_id,
                                           DP_TextReader *reader);

DP_MsgLayerTreeCreate *DP_msg_layer_tree_create_cast(DP_Message *msg);

uint32_t DP_msg_layer_tree_create_id(const DP_MsgLayerTreeCreate *mltc);

uint32_t DP_msg_layer_tree_create_source(const DP_MsgLayerTreeCreate *mltc);

uint32_t DP_msg_layer_tree_create_target(const DP_MsgLayerTreeCreate *mltc);

uint32_t DP_msg_layer_tree_create_fill(const DP_MsgLayerTreeCreate *mltc);

uint8_t DP_msg_layer_tree_create_flags(const DP_MsgLayerTreeCreate *mltc);

const char *DP_msg_layer_tree_create_title(const DP_MsgLayerTreeCreate *mltc,
                                           size_t *out_len);

size_t DP_msg_layer_tree_create_title_len(const DP_MsgLayerTreeCreate *mltc);


/*
 * DP_MSG_LAYER_TREE_MOVE
 *
 * Reorder a layer
 *
 * Moves the given layer into the given parent group or into the root
 * if given 0. It will be placed either below the given sibling or at
 * the bottom if given 0. An invalid move, such as because the parent
 * is missing or the sibling isn't part of the parent group, will not
 * be executed at all, no fallback is attempted.
 *
 * The user is allowed to move a layer if they can edit both it and
 * the parent. Moving into the parent group is allowed if the user has
 * would be allowed to create a layer there (which is always, since
 * that's currently conflated with being allowed to edit layers.)
 */

#define DP_MSG_LAYER_TREE_MOVE_STATIC_LENGTH        9
#define DP_MSG_LAYER_TREE_MOVE_STATIC_LENGTH_COMPAT 6

typedef struct DP_MsgLayerTreeMove DP_MsgLayerTreeMove;

DP_Message *DP_msg_layer_tree_move_new(unsigned int context_id, uint32_t layer,
                                       uint32_t parent, uint32_t sibling);

DP_Message *DP_msg_layer_tree_move_deserialize(unsigned int context_id,
                                               const unsigned char *buffer,
                                               size_t length);

DP_Message *DP_msg_layer_tree_move_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_layer_tree_move_parse(unsigned int context_id,
                                         DP_TextReader *reader);

DP_MsgLayerTreeMove *DP_msg_layer_tree_move_cast(DP_Message *msg);

uint32_t DP_msg_layer_tree_move_layer(const DP_MsgLayerTreeMove *mltm);

uint32_t DP_msg_layer_tree_move_parent(const DP_MsgLayerTreeMove *mltm);

uint32_t DP_msg_layer_tree_move_sibling(const DP_MsgLayerTreeMove *mltm);


/*
 * DP_MSG_LAYER_TREE_DELETE
 *
 * Delete a layer
 *
 * If the merge to attribute is nonzero, the contents of the layer is merged
 * to the layer with the given ID. If the id and merge id both refer to
 * the same layer group, that group is collapsed into a layer.
 *
 * If the current layer or layer controls in general are locked, this command
 * requires session operator privileges.
 */

#define DP_MSG_LAYER_TREE_DELETE_STATIC_LENGTH        6
#define DP_MSG_LAYER_TREE_DELETE_STATIC_LENGTH_COMPAT 4

typedef struct DP_MsgLayerTreeDelete DP_MsgLayerTreeDelete;

DP_Message *DP_msg_layer_tree_delete_new(unsigned int context_id, uint32_t id,
                                         uint32_t merge_to);

DP_Message *DP_msg_layer_tree_delete_deserialize(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length);

DP_Message *DP_msg_layer_tree_delete_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_layer_tree_delete_parse(unsigned int context_id,
                                           DP_TextReader *reader);

DP_MsgLayerTreeDelete *DP_msg_layer_tree_delete_cast(DP_Message *msg);

uint32_t DP_msg_layer_tree_delete_id(const DP_MsgLayerTreeDelete *mltd);

uint32_t DP_msg_layer_tree_delete_merge_to(const DP_MsgLayerTreeDelete *mltd);


/*
 * DP_MSG_TRANSFORM_REGION
 *
 * Transform an area, optionally moving it between two layers.
 *
 * This is used to implement selection moving. It is equivalent
 * to doing two PutImages: the first to mask away the original
 * selection and the other to paste the selection to a new location.
 *
 * This command packages that into a single action that is more
 * bandwidth efficient and can be used even when PutImages in general
 * are locked, since it's not introducing any new pixels onto the canvas.
 *
 * Internally, the paint engine performs the following steps:
 * 1. Copy selected pixels to a buffer
 * 2. Erase selected pixels from the source layer
 * 3. Composite transformed buffer onto the target layer
 *
 * The pixel selection is determined by the mask bitmap. The mask
 * is DEFLATEd 8 bit alpha.
 *
 * For axis aligned rectangle selections, no bitmap is necessary.
 *
 * The source and layer id may refer to a selection.
 */

#define DP_MSG_TRANSFORM_REGION_STATIC_LENGTH        57
#define DP_MSG_TRANSFORM_REGION_STATIC_LENGTH_COMPAT 53
#define DP_MSG_TRANSFORM_REGION_MATCH_LENGTH         59

#define DP_MSG_TRANSFORM_REGION_MODE_NEAREST  0
#define DP_MSG_TRANSFORM_REGION_MODE_BILINEAR 1
#define DP_MSG_TRANSFORM_REGION_MODE_BINARY   2

#define DP_MSG_TRANSFORM_REGION_NUM_MODE 3
#define DP_MSG_TRANSFORM_REGION_ALL_MODE       \
    DP_MSG_TRANSFORM_REGION_MODE_NEAREST,      \
        DP_MSG_TRANSFORM_REGION_MODE_BILINEAR, \
        DP_MSG_TRANSFORM_REGION_MODE_BINARY

const char *DP_msg_transform_region_mode_variant_name(unsigned int value);

#define DP_MSG_TRANSFORM_REGION_MASK_MIN_SIZE 0
#define DP_MSG_TRANSFORM_REGION_MASK_MAX_SIZE 65478

typedef struct DP_MsgTransformRegion DP_MsgTransformRegion;

DP_Message *DP_msg_transform_region_new(
    unsigned int context_id, uint32_t layer, uint32_t source, int32_t bx,
    int32_t by, int32_t bw, int32_t bh, int32_t x1, int32_t y1, int32_t x2,
    int32_t y2, int32_t x3, int32_t y3, int32_t x4, int32_t y4, uint8_t mode,
    uint8_t blend, uint8_t opacity,
    void (*set_mask)(size_t, unsigned char *, void *), size_t mask_size,
    void *mask_user);

DP_Message *DP_msg_transform_region_deserialize(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length);

DP_Message *DP_msg_transform_region_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_transform_region_parse(unsigned int context_id,
                                          DP_TextReader *reader);

void DP_msg_transform_region_local_match_set(size_t size, unsigned char *data,
                                             void *user);

bool DP_msg_transform_region_local_match_matches(
    const DP_MsgTransformRegion *mtr, DP_Message *local_match_msg);

DP_MsgTransformRegion *DP_msg_transform_region_cast(DP_Message *msg);

uint32_t DP_msg_transform_region_layer(const DP_MsgTransformRegion *mtr);

uint32_t DP_msg_transform_region_source(const DP_MsgTransformRegion *mtr);

int32_t DP_msg_transform_region_bx(const DP_MsgTransformRegion *mtr);

int32_t DP_msg_transform_region_by(const DP_MsgTransformRegion *mtr);

int32_t DP_msg_transform_region_bw(const DP_MsgTransformRegion *mtr);

int32_t DP_msg_transform_region_bh(const DP_MsgTransformRegion *mtr);

int32_t DP_msg_transform_region_x1(const DP_MsgTransformRegion *mtr);

int32_t DP_msg_transform_region_y1(const DP_MsgTransformRegion *mtr);

int32_t DP_msg_transform_region_x2(const DP_MsgTransformRegion *mtr);

int32_t DP_msg_transform_region_y2(const DP_MsgTransformRegion *mtr);

int32_t DP_msg_transform_region_x3(const DP_MsgTransformRegion *mtr);

int32_t DP_msg_transform_region_y3(const DP_MsgTransformRegion *mtr);

int32_t DP_msg_transform_region_x4(const DP_MsgTransformRegion *mtr);

int32_t DP_msg_transform_region_y4(const DP_MsgTransformRegion *mtr);

uint8_t DP_msg_transform_region_mode(const DP_MsgTransformRegion *mtr);

uint8_t DP_msg_transform_region_blend(const DP_MsgTransformRegion *mtr);

uint8_t DP_msg_transform_region_opacity(const DP_MsgTransformRegion *mtr);

const unsigned char *
DP_msg_transform_region_mask(const DP_MsgTransformRegion *mtr,
                             size_t *out_size);

size_t DP_msg_transform_region_mask_size(const DP_MsgTransformRegion *mtr);


/*
 * DP_MSG_TRACK_CREATE
 *
 * Create a timeline track.
 *
 * The track id must be prefixed by the user's context id, like layer
 * and annotation ids. Operators are exempt from this restriction.
 */

#define DP_MSG_TRACK_CREATE_STATIC_LENGTH        6
#define DP_MSG_TRACK_CREATE_STATIC_LENGTH_COMPAT 6

#define DP_MSG_TRACK_CREATE_TITLE_MIN_LEN 0
#define DP_MSG_TRACK_CREATE_TITLE_MAX_LEN 65529

typedef struct DP_MsgTrackCreate DP_MsgTrackCreate;

DP_Message *DP_msg_track_create_new(unsigned int context_id, uint16_t id,
                                    uint16_t insert_id, uint16_t source_id,
                                    const char *title_value, size_t title_len);

DP_Message *DP_msg_track_create_deserialize(unsigned int context_id,
                                            const unsigned char *buffer,
                                            size_t length);

DP_Message *DP_msg_track_create_deserialize_compat(unsigned int context_id,
                                                   const unsigned char *buffer,
                                                   size_t length);

DP_Message *DP_msg_track_create_parse(unsigned int context_id,
                                      DP_TextReader *reader);

DP_MsgTrackCreate *DP_msg_track_create_cast(DP_Message *msg);

uint16_t DP_msg_track_create_id(const DP_MsgTrackCreate *mtc);

uint16_t DP_msg_track_create_insert_id(const DP_MsgTrackCreate *mtc);

uint16_t DP_msg_track_create_source_id(const DP_MsgTrackCreate *mtc);

const char *DP_msg_track_create_title(const DP_MsgTrackCreate *mtc,
                                      size_t *out_len);

size_t DP_msg_track_create_title_len(const DP_MsgTrackCreate *mtc);


/*
 * DP_MSG_TRACK_RETITLE
 *
 * Rename a timeline track.
 */

#define DP_MSG_TRACK_RETITLE_STATIC_LENGTH        2
#define DP_MSG_TRACK_RETITLE_STATIC_LENGTH_COMPAT 2

#define DP_MSG_TRACK_RETITLE_TITLE_MIN_LEN 0
#define DP_MSG_TRACK_RETITLE_TITLE_MAX_LEN 65533

typedef struct DP_MsgTrackRetitle DP_MsgTrackRetitle;

DP_Message *DP_msg_track_retitle_new(unsigned int context_id, uint16_t id,
                                     const char *title_value, size_t title_len);

DP_Message *DP_msg_track_retitle_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length);

DP_Message *DP_msg_track_retitle_deserialize_compat(unsigned int context_id,
                                                    const unsigned char *buffer,
                                                    size_t length);

DP_Message *DP_msg_track_retitle_parse(unsigned int context_id,
                                       DP_TextReader *reader);

DP_MsgTrackRetitle *DP_msg_track_retitle_cast(DP_Message *msg);

uint16_t DP_msg_track_retitle_id(const DP_MsgTrackRetitle *mtr);

const char *DP_msg_track_retitle_title(const DP_MsgTrackRetitle *mtr,
                                       size_t *out_len);

size_t DP_msg_track_retitle_title_len(const DP_MsgTrackRetitle *mtr);


/*
 * DP_MSG_TRACK_DELETE
 *
 * Delete a timeline track.
 */

#define DP_MSG_TRACK_DELETE_STATIC_LENGTH        2
#define DP_MSG_TRACK_DELETE_STATIC_LENGTH_COMPAT 2

typedef struct DP_MsgTrackDelete DP_MsgTrackDelete;

DP_Message *DP_msg_track_delete_new(unsigned int context_id, uint16_t id);

DP_Message *DP_msg_track_delete_deserialize(unsigned int context_id,
                                            const unsigned char *buffer,
                                            size_t length);

DP_Message *DP_msg_track_delete_deserialize_compat(unsigned int context_id,
                                                   const unsigned char *buffer,
                                                   size_t length);

DP_Message *DP_msg_track_delete_parse(unsigned int context_id,
                                      DP_TextReader *reader);

DP_MsgTrackDelete *DP_msg_track_delete_cast(DP_Message *msg);

uint16_t DP_msg_track_delete_id(const DP_MsgTrackDelete *mtd);


/*
 * DP_MSG_TRACK_ORDER
 *
 * Reorder timeline tracks.
 *
 * Works like the LayerOrder command, just for tracks: duplicates are
 * ignored and missing tracks are appended to the end.
 */

#define DP_MSG_TRACK_ORDER_STATIC_LENGTH        0
#define DP_MSG_TRACK_ORDER_STATIC_LENGTH_COMPAT 0

#define DP_MSG_TRACK_ORDER_TRACKS_MIN_COUNT 0
#define DP_MSG_TRACK_ORDER_TRACKS_MAX_COUNT 32767

typedef struct DP_MsgTrackOrder DP_MsgTrackOrder;

DP_Message *DP_msg_track_order_new(unsigned int context_id,
                                   void (*set_tracks)(int, uint16_t *, void *),
                                   int tracks_count, void *tracks_user);

DP_Message *DP_msg_track_order_deserialize(unsigned int context_id,
                                           const unsigned char *buffer,
                                           size_t length);

DP_Message *DP_msg_track_order_deserialize_compat(unsigned int context_id,
                                                  const unsigned char *buffer,
                                                  size_t length);

DP_Message *DP_msg_track_order_parse(unsigned int context_id,
                                     DP_TextReader *reader);

DP_MsgTrackOrder *DP_msg_track_order_cast(DP_Message *msg);

const uint16_t *DP_msg_track_order_tracks(const DP_MsgTrackOrder *mto,
                                          int *out_count);

int DP_msg_track_order_tracks_count(const DP_MsgTrackOrder *mto);


/*
 * DP_MSG_KEY_FRAME_SET
 *
 * Create or modify a key frame.
 *
 * If there's no key frame at the given frame index, it will be
 * created, otherwise it will be clobbered. The layer must exist and
 * the frame index must be within the document's frame count.
 *
 * If the source is `Layer`, a new key frame will be created with
 * `source_id` as the layer id, `source_index` will be ignored. If the
 * source is `KeyFrame`, the key frame is copied from the key frame at
 * track with id `source_id` and frame index `source_index`.
 */

#define DP_MSG_KEY_FRAME_SET_STATIC_LENGTH        10
#define DP_MSG_KEY_FRAME_SET_STATIC_LENGTH_COMPAT 9

#define DP_MSG_KEY_FRAME_SET_SOURCE_LAYER     0
#define DP_MSG_KEY_FRAME_SET_SOURCE_KEY_FRAME 1

#define DP_MSG_KEY_FRAME_SET_NUM_SOURCE 2
#define DP_MSG_KEY_FRAME_SET_ALL_SOURCE \
    DP_MSG_KEY_FRAME_SET_SOURCE_LAYER, DP_MSG_KEY_FRAME_SET_SOURCE_KEY_FRAME

const char *DP_msg_key_frame_set_source_variant_name(unsigned int value);

typedef struct DP_MsgKeyFrameSet DP_MsgKeyFrameSet;

DP_Message *DP_msg_key_frame_set_new(unsigned int context_id, uint16_t track_id,
                                     uint16_t frame_index, uint32_t source_id,
                                     uint16_t source_index, uint8_t source);

DP_Message *DP_msg_key_frame_set_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length);

DP_Message *DP_msg_key_frame_set_deserialize_compat(unsigned int context_id,
                                                    const unsigned char *buffer,
                                                    size_t length);

DP_Message *DP_msg_key_frame_set_parse(unsigned int context_id,
                                       DP_TextReader *reader);

DP_MsgKeyFrameSet *DP_msg_key_frame_set_cast(DP_Message *msg);

uint16_t DP_msg_key_frame_set_track_id(const DP_MsgKeyFrameSet *mkfs);

uint16_t DP_msg_key_frame_set_frame_index(const DP_MsgKeyFrameSet *mkfs);

uint32_t DP_msg_key_frame_set_source_id(const DP_MsgKeyFrameSet *mkfs);

uint16_t DP_msg_key_frame_set_source_index(const DP_MsgKeyFrameSet *mkfs);

uint8_t DP_msg_key_frame_set_source(const DP_MsgKeyFrameSet *mkfs);


/*
 * DP_MSG_KEY_FRAME_RETITLE
 *
 * Rename a key frame.
 */

#define DP_MSG_KEY_FRAME_RETITLE_STATIC_LENGTH        4
#define DP_MSG_KEY_FRAME_RETITLE_STATIC_LENGTH_COMPAT 4

#define DP_MSG_KEY_FRAME_RETITLE_TITLE_MIN_LEN 0
#define DP_MSG_KEY_FRAME_RETITLE_TITLE_MAX_LEN 65531

typedef struct DP_MsgKeyFrameRetitle DP_MsgKeyFrameRetitle;

DP_Message *DP_msg_key_frame_retitle_new(unsigned int context_id,
                                         uint16_t track_id,
                                         uint16_t frame_index,
                                         const char *title_value,
                                         size_t title_len);

DP_Message *DP_msg_key_frame_retitle_deserialize(unsigned int context_id,
                                                 const unsigned char *buffer,
                                                 size_t length);

DP_Message *DP_msg_key_frame_retitle_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_key_frame_retitle_parse(unsigned int context_id,
                                           DP_TextReader *reader);

DP_MsgKeyFrameRetitle *DP_msg_key_frame_retitle_cast(DP_Message *msg);

uint16_t DP_msg_key_frame_retitle_track_id(const DP_MsgKeyFrameRetitle *mkfr);

uint16_t
DP_msg_key_frame_retitle_frame_index(const DP_MsgKeyFrameRetitle *mkfr);

const char *DP_msg_key_frame_retitle_title(const DP_MsgKeyFrameRetitle *mkfr,
                                           size_t *out_len);

size_t DP_msg_key_frame_retitle_title_len(const DP_MsgKeyFrameRetitle *mkfr);


/*
 * DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES
 *
 * Set (clobber) flags for layers inside of a key frame.
 *
 * This takes a list of (layer id, flags) pairs. If a layer appears
 * multiple times, only the first occurrence will apply. If a layer
 * doesn't exist or the flags value is 0, it will be ignored. Unknown
 * flags will be retained for forward-compatibility.
 *
 * Used flags are:
 *
 * * `0x1` hidden: hides a layer in the key frame. Children can
 *   override being hidden by setting the revealed flag on them.
 *
 * * `0x2` revealed: overrides the hidden state given by a parent
 *   group, making it visible again. Putting both hidden and revealed
 *   on the same layer cancels each other out and will act like
 *   neither is set.
 */

#define DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES_STATIC_LENGTH        4
#define DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES_STATIC_LENGTH_COMPAT 4

#define DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES_LAYER_FLAGS_MIN_COUNT 0
#define DP_MSG_KEY_FRAME_LAYER_ATTRIBUTES_LAYER_FLAGS_MAX_COUNT 16382

typedef struct DP_MsgKeyFrameLayerAttributes DP_MsgKeyFrameLayerAttributes;

DP_Message *DP_msg_key_frame_layer_attributes_new(
    unsigned int context_id, uint16_t track_id, uint16_t frame_index,
    void (*set_layer_flags)(int, uint32_t *, void *), int layer_flags_count,
    void *layer_flags_user);

DP_Message *DP_msg_key_frame_layer_attributes_deserialize(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_key_frame_layer_attributes_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_key_frame_layer_attributes_parse(unsigned int context_id,
                                                    DP_TextReader *reader);

DP_MsgKeyFrameLayerAttributes *
DP_msg_key_frame_layer_attributes_cast(DP_Message *msg);

uint16_t DP_msg_key_frame_layer_attributes_track_id(
    const DP_MsgKeyFrameLayerAttributes *mkfla);

uint16_t DP_msg_key_frame_layer_attributes_frame_index(
    const DP_MsgKeyFrameLayerAttributes *mkfla);

const uint32_t *DP_msg_key_frame_layer_attributes_layer_flags(
    const DP_MsgKeyFrameLayerAttributes *mkfla, int *out_count);

int DP_msg_key_frame_layer_attributes_layer_flags_count(
    const DP_MsgKeyFrameLayerAttributes *mkfla);


/*
 * DP_MSG_KEY_FRAME_DELETE
 *
 * Delete a key frame, possibly moving it somewhere else.
 */

#define DP_MSG_KEY_FRAME_DELETE_STATIC_LENGTH        8
#define DP_MSG_KEY_FRAME_DELETE_STATIC_LENGTH_COMPAT 8

typedef struct DP_MsgKeyFrameDelete DP_MsgKeyFrameDelete;

DP_Message *DP_msg_key_frame_delete_new(unsigned int context_id,
                                        uint16_t track_id, uint16_t frame_index,
                                        uint16_t move_track_id,
                                        uint16_t move_frame_index);

DP_Message *DP_msg_key_frame_delete_deserialize(unsigned int context_id,
                                                const unsigned char *buffer,
                                                size_t length);

DP_Message *DP_msg_key_frame_delete_deserialize_compat(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_key_frame_delete_parse(unsigned int context_id,
                                          DP_TextReader *reader);

DP_MsgKeyFrameDelete *DP_msg_key_frame_delete_cast(DP_Message *msg);

uint16_t DP_msg_key_frame_delete_track_id(const DP_MsgKeyFrameDelete *mkfd);

uint16_t DP_msg_key_frame_delete_frame_index(const DP_MsgKeyFrameDelete *mkfd);

uint16_t
DP_msg_key_frame_delete_move_track_id(const DP_MsgKeyFrameDelete *mkfd);

uint16_t
DP_msg_key_frame_delete_move_frame_index(const DP_MsgKeyFrameDelete *mkfd);


/*
 * DP_MSG_SELECTION_PUT
 *
 * Modify selection, either by a rectangle or a pixel mask.
 *
 * The selection_id specifies which of the user's selections is affected.
 * An id of 0 is invalid.
 *
 * The mask is delta-encoded, zstd-compressed 8 bit alpha. If absent, this
 * fills the entire rectangle instead.
 *
 * This message is never sent over the network, it's matched by LocalMatch
 * messages instead and selections are synchronized to the remote using
 * SyncSelectionTile messages.
 */

#define DP_MSG_SELECTION_PUT_STATIC_LENGTH 18
#define DP_MSG_SELECTION_PUT_MATCH_LENGTH  20

#define DP_MSG_SELECTION_PUT_OP_REPLACE    0
#define DP_MSG_SELECTION_PUT_OP_UNITE      1
#define DP_MSG_SELECTION_PUT_OP_INTERSECT  2
#define DP_MSG_SELECTION_PUT_OP_EXCLUDE    3
#define DP_MSG_SELECTION_PUT_OP_COMPLEMENT 4

#define DP_MSG_SELECTION_PUT_NUM_OP 5
#define DP_MSG_SELECTION_PUT_ALL_OP                                         \
    DP_MSG_SELECTION_PUT_OP_REPLACE, DP_MSG_SELECTION_PUT_OP_UNITE,         \
        DP_MSG_SELECTION_PUT_OP_INTERSECT, DP_MSG_SELECTION_PUT_OP_EXCLUDE, \
        DP_MSG_SELECTION_PUT_OP_COMPLEMENT

const char *DP_msg_selection_put_op_variant_name(unsigned int value);

#define DP_MSG_SELECTION_PUT_MASK_MIN_SIZE 0
#define DP_MSG_SELECTION_PUT_MASK_MAX_SIZE 65517

typedef struct DP_MsgSelectionPut DP_MsgSelectionPut;

DP_Message *
DP_msg_selection_put_new(unsigned int context_id, uint8_t selection_id,
                         uint8_t op, int32_t x, int32_t y, uint32_t w,
                         uint32_t h,
                         void (*set_mask)(size_t, unsigned char *, void *),
                         size_t mask_size, void *mask_user);

DP_Message *DP_msg_selection_put_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length);

DP_Message *DP_msg_selection_put_parse(unsigned int context_id,
                                       DP_TextReader *reader);

void DP_msg_selection_put_local_match_set(size_t size, unsigned char *data,
                                          void *user);

bool DP_msg_selection_put_local_match_matches(const DP_MsgSelectionPut *msp,
                                              DP_Message *local_match_msg);

DP_MsgSelectionPut *DP_msg_selection_put_cast(DP_Message *msg);

uint8_t DP_msg_selection_put_selection_id(const DP_MsgSelectionPut *msp);

uint8_t DP_msg_selection_put_op(const DP_MsgSelectionPut *msp);

int32_t DP_msg_selection_put_x(const DP_MsgSelectionPut *msp);

int32_t DP_msg_selection_put_y(const DP_MsgSelectionPut *msp);

uint32_t DP_msg_selection_put_w(const DP_MsgSelectionPut *msp);

uint32_t DP_msg_selection_put_h(const DP_MsgSelectionPut *msp);

const unsigned char *DP_msg_selection_put_mask(const DP_MsgSelectionPut *msp,
                                               size_t *out_size);

size_t DP_msg_selection_put_mask_size(const DP_MsgSelectionPut *msp);


/*
 * DP_MSG_SELECTION_CLEAR
 *
 * Remove the selection specified by the selection_id, or all selections if
 * it's 0.
 *
 * This message is never sent over the network, it's matched by LocalMatch
 * messages instead and selections are synchronized to the remote using
 * SyncSelectionTile messages.
 */

#define DP_MSG_SELECTION_CLEAR_STATIC_LENGTH 1
#define DP_MSG_SELECTION_CLEAR_MATCH_LENGTH  1

typedef struct DP_MsgSelectionClear DP_MsgSelectionClear;

DP_Message *DP_msg_selection_clear_new(unsigned int context_id,
                                       uint8_t selection_id);

DP_Message *DP_msg_selection_clear_deserialize(unsigned int context_id,
                                               const unsigned char *buffer,
                                               size_t length);

DP_Message *DP_msg_selection_clear_parse(unsigned int context_id,
                                         DP_TextReader *reader);

void DP_msg_selection_clear_local_match_set(size_t size, unsigned char *data,
                                            void *user);

bool DP_msg_selection_clear_local_match_matches(const DP_MsgSelectionClear *msc,
                                                DP_Message *local_match_msg);

DP_MsgSelectionClear *DP_msg_selection_clear_cast(DP_Message *msg);

uint8_t DP_msg_selection_clear_selection_id(const DP_MsgSelectionClear *msc);


/*
 * DP_MSG_LOCAL_MATCH
 *
 * A command that is sent over the network just to match it with another
 * message in the local fork. It has no effect in itself. This is currently
 * used for selections, which only have an effect on the local user and
 * other users don't need to bother with processing them.
 *
 * The type describes the message type this is matched with and the
 * contents of data depend on that type being matched. It usually contains
 * the same stuff as the matched message, minus any variable-length
 * buffers, where only the size is sent along, since that's good enough for
 * getting a match in practice.
 *
 * Strictly speaking, this is not compatible with the 2.2 protocol and
 * clients before version 2.2.2 don't understand it. However, since it
 * doesn't have any effect for other users, it doesn't cause desync, so we
 * accept it anyway. In sessions on the builtin server, a PutImage message
 * with an invalid blend mode is used instead.
 */

#define DP_MSG_LOCAL_MATCH_STATIC_LENGTH        1
#define DP_MSG_LOCAL_MATCH_STATIC_LENGTH_COMPAT 1

#define DP_MSG_LOCAL_MATCH_DATA_MIN_SIZE 0
#define DP_MSG_LOCAL_MATCH_DATA_MAX_SIZE 65534

typedef struct DP_MsgLocalMatch DP_MsgLocalMatch;

DP_Message *DP_msg_local_match_new(unsigned int context_id, uint8_t type,
                                   void (*set_data)(size_t, unsigned char *,
                                                    void *),
                                   size_t data_size, void *data_user);

DP_Message *DP_msg_local_match_deserialize(unsigned int context_id,
                                           const unsigned char *buffer,
                                           size_t length);

DP_Message *DP_msg_local_match_deserialize_compat(unsigned int context_id,
                                                  const unsigned char *buffer,
                                                  size_t length);

DP_Message *DP_msg_local_match_parse(unsigned int context_id,
                                     DP_TextReader *reader);

DP_MsgLocalMatch *DP_msg_local_match_cast(DP_Message *msg);

uint8_t DP_msg_local_match_type(const DP_MsgLocalMatch *mlm);

const unsigned char *DP_msg_local_match_data(const DP_MsgLocalMatch *mlm,
                                             size_t *out_size);

size_t DP_msg_local_match_data_size(const DP_MsgLocalMatch *mlm);


/*
 * DP_MSG_SYNC_SELECTION_TILE
 *
 * Synchronizes a tile from a local selection into a remote one. The
 * selection id must be 128 or higher.
 *
 * The mask is zstd-compressed, delta-encoded 8 bit alpha. A zero-length
 * mask will make the tile blank. A mask with a single zero byte will make
 * the tile fully opaque.  When the column and row are both 0xffff and the
 * mask has a length of zero, the selection is cleared instead.
 *
 * This command isn't rolled back by undos.
 */

#define DP_MSG_SYNC_SELECTION_TILE_STATIC_LENGTH 6

#define DP_MSG_SYNC_SELECTION_TILE_MASK_MIN_SIZE 0
#define DP_MSG_SYNC_SELECTION_TILE_MASK_MAX_SIZE 65529

typedef struct DP_MsgSyncSelectionTile DP_MsgSyncSelectionTile;

DP_Message *DP_msg_sync_selection_tile_new(
    unsigned int context_id, uint8_t user, uint8_t selection_id, uint16_t col,
    uint16_t row, void (*set_mask)(size_t, unsigned char *, void *),
    size_t mask_size, void *mask_user);

DP_Message *DP_msg_sync_selection_tile_deserialize(unsigned int context_id,
                                                   const unsigned char *buffer,
                                                   size_t length);

DP_Message *DP_msg_sync_selection_tile_parse(unsigned int context_id,
                                             DP_TextReader *reader);

DP_MsgSyncSelectionTile *DP_msg_sync_selection_tile_cast(DP_Message *msg);

uint8_t DP_msg_sync_selection_tile_user(const DP_MsgSyncSelectionTile *msst);

uint8_t
DP_msg_sync_selection_tile_selection_id(const DP_MsgSyncSelectionTile *msst);

uint16_t DP_msg_sync_selection_tile_col(const DP_MsgSyncSelectionTile *msst);

uint16_t DP_msg_sync_selection_tile_row(const DP_MsgSyncSelectionTile *msst);

const unsigned char *
DP_msg_sync_selection_tile_mask(const DP_MsgSyncSelectionTile *msst,
                                size_t *out_size);

size_t
DP_msg_sync_selection_tile_mask_size(const DP_MsgSyncSelectionTile *msst);


/*
 * DP_MSG_PUT_IMAGE_ZSTD
 *
 * Like PutImage, but the image is split channel delta-encoded
 * zstd-compressed 8 bit pixel data instead, prefixed by four bytes of
 * length in little-endian. If the mask is exactly four bytes long, it
 * represents a fill color in little-endian.
 */

#define DP_MSG_PUT_IMAGE_ZSTD_STATIC_LENGTH 0

DP_Message *
DP_msg_put_image_zstd_new(unsigned int context_id, uint32_t layer, uint8_t mode,
                          uint32_t x, uint32_t y, uint32_t w, uint32_t h,
                          void (*set_image)(size_t, unsigned char *, void *),
                          size_t image_size, void *image_user);

DP_Message *DP_msg_put_image_zstd_deserialize(unsigned int context_id,
                                              const unsigned char *buffer,
                                              size_t length);

DP_Message *DP_msg_put_image_zstd_parse(unsigned int context_id,
                                        DP_TextReader *reader);

DP_MsgPutImage *DP_msg_put_image_zstd_cast(DP_Message *msg);


/*
 * DP_MSG_PUT_TILE_ZSTD
 *
 * Analogous to PutImageZstd but for PutTile.
 */

#define DP_MSG_PUT_TILE_ZSTD_STATIC_LENGTH 0

DP_Message *
DP_msg_put_tile_zstd_new(unsigned int context_id, uint8_t user, uint32_t layer,
                         uint8_t sublayer, uint16_t col, uint16_t row,
                         uint16_t repeat,
                         void (*set_image)(size_t, unsigned char *, void *),
                         size_t image_size, void *image_user);

DP_Message *DP_msg_put_tile_zstd_deserialize(unsigned int context_id,
                                             const unsigned char *buffer,
                                             size_t length);

DP_Message *DP_msg_put_tile_zstd_parse(unsigned int context_id,
                                       DP_TextReader *reader);

DP_MsgPutTile *DP_msg_put_tile_zstd_cast(DP_Message *msg);


/*
 * DP_MSG_CANVAS_BACKGROUND_ZSTD
 *
 * Analogous to PutImageZstd but for CanvasBackground.
 */

#define DP_MSG_CANVAS_BACKGROUND_ZSTD_STATIC_LENGTH 0

DP_Message *DP_msg_canvas_background_zstd_new(
    unsigned int context_id, void (*set_image)(size_t, unsigned char *, void *),
    size_t image_size, void *image_user);

DP_Message *DP_msg_canvas_background_zstd_deserialize(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_canvas_background_zstd_parse(unsigned int context_id,
                                                DP_TextReader *reader);

DP_MsgCanvasBackground *DP_msg_canvas_background_zstd_cast(DP_Message *msg);


/*
 * DP_MSG_MOVE_RECT_ZSTD
 *
 * Like MoveRect, but the mask is delta-encoded zstd-compressed 8 bit pixel
 * data instead, prefixed by four bytes of length in little-endian.
 */

#define DP_MSG_MOVE_RECT_ZSTD_STATIC_LENGTH 0

DP_Message *DP_msg_move_rect_zstd_new(
    unsigned int context_id, uint32_t layer, uint32_t source, int32_t sx,
    int32_t sy, int32_t tx, int32_t ty, int32_t w, int32_t h, uint8_t blend,
    uint8_t opacity, void (*set_mask)(size_t, unsigned char *, void *),
    size_t mask_size, void *mask_user);

DP_Message *DP_msg_move_rect_zstd_deserialize(unsigned int context_id,
                                              const unsigned char *buffer,
                                              size_t length);

DP_Message *DP_msg_move_rect_zstd_parse(unsigned int context_id,
                                        DP_TextReader *reader);

DP_MsgMoveRect *DP_msg_move_rect_zstd_cast(DP_Message *msg);


/*
 * DP_MSG_TRANSFORM_REGION_ZSTD
 *
 * Analogous to MoveRectZstd but for TransformRegion.
 */

#define DP_MSG_TRANSFORM_REGION_ZSTD_STATIC_LENGTH 0

DP_Message *DP_msg_transform_region_zstd_new(
    unsigned int context_id, uint32_t layer, uint32_t source, int32_t bx,
    int32_t by, int32_t bw, int32_t bh, int32_t x1, int32_t y1, int32_t x2,
    int32_t y2, int32_t x3, int32_t y3, int32_t x4, int32_t y4, uint8_t mode,
    uint8_t blend, uint8_t opacity,
    void (*set_mask)(size_t, unsigned char *, void *), size_t mask_size,
    void *mask_user);

DP_Message *DP_msg_transform_region_zstd_deserialize(
    unsigned int context_id, const unsigned char *buffer, size_t length);

DP_Message *DP_msg_transform_region_zstd_parse(unsigned int context_id,
                                               DP_TextReader *reader);

DP_MsgTransformRegion *DP_msg_transform_region_zstd_cast(DP_Message *msg);


/*
 * DP_MSG_UNDO
 *
 * Undo or redo actions
 */

#define DP_MSG_UNDO_STATIC_LENGTH        2
#define DP_MSG_UNDO_STATIC_LENGTH_COMPAT 2

typedef struct DP_MsgUndo DP_MsgUndo;

DP_Message *DP_msg_undo_new(unsigned int context_id, uint8_t override_user,
                            bool redo);

DP_Message *DP_msg_undo_deserialize(unsigned int context_id,
                                    const unsigned char *buffer, size_t length);

DP_Message *DP_msg_undo_deserialize_compat(unsigned int context_id,
                                           const unsigned char *buffer,
                                           size_t length);

DP_Message *DP_msg_undo_parse(unsigned int context_id, DP_TextReader *reader);

DP_MsgUndo *DP_msg_undo_cast(DP_Message *msg);

uint8_t DP_msg_undo_override_user(const DP_MsgUndo *mu);

bool DP_msg_undo_redo(const DP_MsgUndo *mu);


DP_Message *DP_msg_local_match_make(DP_Message *msg,
                                    bool disguise_as_put_image);

bool DP_msg_local_match_is_local_match(DP_Message *msg);

bool DP_msg_local_match_matches(DP_Message *msg, DP_Message *local_match_msg);

#endif
