package net.damschen.swatchit.test.ui.viewmodels

import net.damschen.swatchit.test.testHelpers.MainDispatcherRule
import net.damschen.swatchit.test.testHelpers.database.FakeRepo
import net.damschen.swatchit.ui.models.LoadState
import net.damschen.swatchit.ui.viewmodels.SwatchListViewModel
import org.junit.Assert.assertTrue
import org.junit.Rule
import org.junit.Test

class SwatchListViewModelTests {
    @get:Rule
    val mainDispatcherRule = MainDispatcherRule()

    @Test
    fun init_RepositoryReturnsSuccess_loadsSwatches() {
        val repo = FakeRepo()
        val sut = SwatchListViewModel(repo)

        assertTrue(sut.loadState.value is LoadState.Success)
    }

    @Test
    fun init_RepositoryReturnsError_setsErrorLoadState() {
        val repo = FakeRepo()
        repo.returnError = true
        val sut = SwatchListViewModel(repo)

        assertTrue(sut.loadState.value is LoadState.Error)
    }
}