package net.damschen.swatchit.test.ui.models

import junit.framework.TestCase.assertEquals
import junit.framework.TestCase.assertFalse
import junit.framework.TestCase.assertTrue
import net.damschen.swatchit.domain.aggregates.swatch.Gauge
import net.damschen.swatchit.domain.aggregates.swatch.GaugeCount
import net.damschen.swatchit.domain.aggregates.swatch.GaugeSize
import net.damschen.swatchit.ui.models.GaugeFormState
import net.damschen.swatchit.ui.models.ValidatedInput
import org.junit.Test

class GaugeFormStateTests {
    @Test
    fun isValid_noErrors_returnsTrue() {
        val gaugeFormState = GaugeFormState(
            nrOfStitches = ValidatedInput.Valid(""),
            nrOfRows = ValidatedInput.Valid(""),
            size = ValidatedInput.Valid("")
        )

        assertTrue(gaugeFormState.isValid())
    }

    @Test
    fun isValid_errors_returnsFalse() {
        val gaugeFormState = GaugeFormState(
            nrOfStitches = ValidatedInput.Invalid("invalid", 23),
            nrOfRows = ValidatedInput.Invalid("", 24),
            size = ValidatedInput.Valid("")
        )

        assertFalse(gaugeFormState.isValid())
    }

    @Test
    fun fromGauge_gaugeNull_setsStateEmpty() {
        val gaugeFormState = GaugeFormState.fromGauge(null)

        assertEquals(ValidatedInput.Valid(""), gaugeFormState.nrOfStitches)
        assertEquals(ValidatedInput.Valid(""), gaugeFormState.nrOfRows)
        assertEquals(ValidatedInput.Valid(""), gaugeFormState.size)
    }

    @Test
    fun toGauge_afterFromGauge_createsEqualSwatch() {
        val expected = Gauge(GaugeCount(10), GaugeCount(12), GaugeSize(13.0))
        val swatchFormState = GaugeFormState.fromGauge(expected)
        val actual = swatchFormState.toGauge()

        assertEquals(expected, actual)
    }
}