package net.damschen.swatchit.testHelpers.database

import android.database.sqlite.SQLiteException
import kotlinx.coroutines.flow.Flow
import net.damschen.swatchit.infrastructure.database.SwatchAggregate
import net.damschen.swatchit.infrastructure.database.SwatchDao
import net.damschen.swatchit.infrastructure.database.SwatchEntity
import net.damschen.swatchit.infrastructure.database.SwatchId

class FakeSwatchDao(val shouldThrow: Boolean = false) : SwatchDao {
    override fun get(): Flow<List<SwatchAggregate>> {
        if (shouldThrow) throw SQLiteException()
        TODO("Not yet implemented")
    }

    override suspend fun insert(swatch: SwatchEntity): Long {
        TODO("Not yet implemented")
    }

    override suspend fun update(swatch: SwatchEntity) {
        if (shouldThrow) throw SQLiteException()
        TODO("Not yet implemented")
    }

    override suspend fun delete(id: SwatchId) {
        if (shouldThrow) throw SQLiteException()
        TODO("Not yet implemented")
    }

    override suspend fun exists(id: Int?): Boolean {
        TODO("Not yet implemented")
    }

    override suspend fun get(id: Int): SwatchAggregate {
        if (shouldThrow) throw SQLiteException()
        TODO("Not yet implemented")
    }
}