package net.damschen.swatchit.test.infrastructure.repository

import kotlinx.coroutines.flow.first
import kotlinx.coroutines.test.runTest
import net.damschen.swatchit.domain.aggregates.swatch.EpochMillis
import net.damschen.swatchit.domain.aggregates.swatch.Gauge
import net.damschen.swatchit.domain.aggregates.swatch.GaugeCount
import net.damschen.swatchit.domain.aggregates.swatch.GaugeSize
import net.damschen.swatchit.domain.aggregates.swatch.KnittingNeedleSize
import net.damschen.swatchit.domain.aggregates.swatch.Name
import net.damschen.swatchit.domain.aggregates.swatch.Notes
import net.damschen.swatchit.domain.aggregates.swatch.Pattern
import net.damschen.swatchit.domain.aggregates.swatch.Swatch
import net.damschen.swatchit.domain.aggregates.swatch.SwatchId
import net.damschen.swatchit.domain.aggregates.swatch.Yarn
import net.damschen.swatchit.domain.resultWrappers.DatabaseResult
import net.damschen.swatchit.infrastructure.repository.SqlSwatchRepository
import net.damschen.swatchit.testHelpers.database.FakeMeasurementDao
import net.damschen.swatchit.testHelpers.database.FakeSwatchDao
import net.damschen.swatchit.testHelpers.database.FakeTransactionProvider
import org.junit.Assert.assertTrue
import org.junit.Test
import java.time.LocalDate
import java.time.ZoneId

class SwatchRepositoryImplTests {
    @Test
    fun getAllSwatches_daoThrows_returnsErrorResult() = runTest {
        val repository = createSut()
        val result = repository.getAll().first()

        assertTrue(result is DatabaseResult.Error)
    }

    @Test
    fun getSwatch_daoThrows_returnsErrorResult() = runTest {
        val repository = createSut()
        val result = repository.get(1)

        assertTrue(result is DatabaseResult.Error)
    }

    @Test
    fun updateSwatch_daoThrows_returnsErrorResult() = runTest {
        val repository = createSut()
        val result = repository.update(createSwatch())

        assertTrue(result is DatabaseResult.Error)
    }

    @Test
    fun deleteSwatch_daoThrows_returnsErrorResult() = runTest {
        val repository = createSut()
        val result = repository.delete(SwatchId(1))

        assertTrue(result is DatabaseResult.Error)
    }

    private fun createSut(): SqlSwatchRepository {
        val swatchDao = FakeSwatchDao(shouldThrow = true)
        val measurementsDao = FakeMeasurementDao()
        val transactionProvider = FakeTransactionProvider()
        return SqlSwatchRepository(swatchDao, measurementsDao, transactionProvider)
    }
}

private fun createSwatch(id: Int? = null, pattern: Pattern? = defaultPattern): Swatch {
    return Swatch.create(
        needleSize = defaultNeedleSize,
        pattern = pattern,
        yarn = defaultYarn,
        notes = defaultNotes,
        createdAt = defaultCreatedAt,
        id = id?.let { SwatchId(it) },
        name = defaultName
    ).withUpdatedGauge(defaultGauge)
}

private val defaultName = Name.create("TestName")!!
private val defaultNeedleSize = KnittingNeedleSize.SIZE_2_5
private val defaultPattern = Pattern.create("Stockinette")!!
private val defaultGauge =
    Gauge(GaugeCount(20), GaugeCount(30), GaugeSize(10.0))
private val defaultYarn = Yarn.create(Name.create("Yarn Name"), Name.create("Yarn Manufacturer"))!!
private val defaultNotes = Notes.create("Test notes!")!!
private val defaultCreatedAt = EpochMillis(
    LocalDate.of(2025, 2, 17).atStartOfDay(
        ZoneId.of("UTC")
    ).toInstant().toEpochMilli()
)