package net.damschen.swatchit.test.domain.aggregates.swatch

import net.damschen.swatchit.domain.aggregates.swatch.GaugeCount
import net.damschen.swatchit.domain.aggregates.swatch.GaugeSize
import net.damschen.swatchit.domain.aggregates.swatch.Measurement
import net.damschen.swatchit.domain.aggregates.swatch.MeasurementType
import org.junit.Assert.assertEquals
import org.junit.Test

class MeasurementTests {

    @Test
    fun create_validInput_createsMeasurements() {
        val measurement =
            Measurement(
                GaugeCount(3),
                GaugeSize(12.0),
                MeasurementType.Stitches
            )
        assertEquals(3, measurement.gaugeCount.value)
        assertEquals(12.0, measurement.size.value, 1e-5)
        assertEquals(MeasurementType.Stitches, measurement.measurementType)

    }
}
