package net.damschen.swatchit.shared.testhelpers

import android.graphics.Bitmap
import android.net.Uri
import net.damschen.swatchit.infrastructure.services.BitmapDecoder

class FakeBitmapDecoder : BitmapDecoder {
    var shouldThrow = false
    override suspend fun decode(uri: Uri, maxSize: Int?): Bitmap {
        if (shouldThrow) throw IllegalArgumentException()
        return Bitmap.createBitmap(100, 100, Bitmap.Config.ARGB_8888).apply {
            eraseColor(android.graphics.Color.RED)
        }
    }
}