package net.damschen.swatchit.ui.models

import net.damschen.swatchit.domain.aggregates.swatch.EpochMillis
import net.damschen.swatchit.domain.aggregates.swatch.Gauge
import net.damschen.swatchit.domain.aggregates.swatch.KnittingNeedleSize
import net.damschen.swatchit.domain.aggregates.swatch.Measurement
import net.damschen.swatchit.domain.aggregates.swatch.Name
import net.damschen.swatchit.domain.aggregates.swatch.Notes
import net.damschen.swatchit.domain.aggregates.swatch.Pattern
import net.damschen.swatchit.domain.aggregates.swatch.Photo
import net.damschen.swatchit.domain.aggregates.swatch.Swatch
import net.damschen.swatchit.domain.aggregates.swatch.SwatchId
import net.damschen.swatchit.domain.aggregates.swatch.Yarn

data class SwatchState(
    val needleSize: KnittingNeedleSize,
    val pattern: Pattern?,
    val gauge: Gauge?,
    val yarn: Yarn?,
    val notes: Notes?,
    val measurements: List<Measurement>,
    val name: Name?,
    val photo: Photo?,
    val createdAt: EpochMillis,
    val id: SwatchId?
) {
    companion object {
        fun from(swatch: Swatch?) = swatch?.let {
            SwatchState(
                needleSize = it.needleSize,
                pattern = it.pattern,
                gauge = it.gauge,
                yarn = it.yarn,
                notes = it.notes,
                measurements = it.measurements,
                name = it.name,
                createdAt = it.createdAt,
                id = it.id,
                photo = it.photo
            )
        }
    }

    fun toSwatch(): Swatch {
        var swatch = Swatch.create(
            needleSize = needleSize,
            pattern = pattern,
            yarn = yarn,
            notes = notes,
            createdAt = createdAt,
            id = id,
            name = name
        ).withNewMeasurements(measurements)
        swatch = photo?.let { swatch.withUpdatedPhoto(it) } ?: swatch
        return gauge?.let { swatch.withUpdatedGauge(gauge) } ?: swatch
    }
}