package net.damschen.swatchit.ui.models

import net.damschen.swatchit.domain.aggregates.swatch.Swatch
import net.damschen.swatchit.ui.enums.KnittingNeedleSize
import net.damschen.swatchit.ui.enums.toUiEnum

class SwatchListItem private constructor(
    val id: Int,
    val name: String,
    val yarnName: String,
    val yarnManufacturer: String,
    val needleSize: KnittingNeedleSize,
    val gaugeState: GaugeState?,
    val photoFileName: String?
) {
    companion object {
        fun fromSwatch(swatch: Swatch): SwatchListItem {
            val id =
                requireNotNull(swatch.id) { "Id cannot be null for swatches loaded from the database." }
            val gaugeState = swatch.gauge?.let {
                GaugeState.fromGauge(it)
            }
            return SwatchListItem(
                id = id.value,
                name = swatch.name?.value ?: "",
                yarnName = swatch.yarn?.name?.value ?: "",
                yarnManufacturer = swatch.yarn?.manufacturer?.value ?: "",
                needleSize = swatch.needleSize.toUiEnum(),
                gaugeState = gaugeState,
                photoFileName = swatch.photo?.fileName
            )
        }
    }
}

