package net.damschen.swatchit.ui.models

import net.damschen.swatchit.domain.aggregates.swatch.Measurement
import net.damschen.swatchit.ui.enums.CountType
import net.damschen.swatchit.ui.enums.toCountType

data class MeasurementsState(val items: List<MeasurementListItem>) {
    companion object {
        fun fromMeasurements(measurements: List<Measurement>): MeasurementsState {
            return MeasurementsState(measurements.map {
                MeasurementListItem(
                    count = it.gaugeCount.value,
                    size = it.size.value,
                    countType = it.measurementType.toCountType()
                )
            })
        }
    }
}

data class MeasurementListItem(
    val count: Int,
    val size: Double,
    val countType: CountType
)