package net.damschen.swatchit.ui.elements

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.text.TextAutoSize
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.testTag
import androidx.compose.ui.text.style.TextOverflow
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp

@Composable
fun LabeledText(
    value: String,
    labelText: String,
    modifier: Modifier = Modifier,
    testTag: String = "",
    softWrap: Boolean = false
) {
    Column(modifier = modifier) {
        Text(
            text = labelText,
            style = MaterialTheme.typography.labelLarge,
            modifier = Modifier.padding(24.dp, 12.dp, 24.dp, 0.dp)
        )
        Text(
            text = value,
            modifier = Modifier
                .padding(24.dp, 0.dp, 24.dp, 12.dp)
                .testTag(testTag),
            softWrap = softWrap,
            overflow = TextOverflow.Ellipsis,
            autoSize = TextAutoSize.StepBased(
                minFontSize = 12.sp, maxFontSize = 30.sp, stepSize = 1.sp
            ),
            style = MaterialTheme.typography.displaySmall
        )
    }
}